{"vars":[{"name":"base","containerName":"","kind":2,"line":102},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below","parameters":[{"label":"$class"},{"label":"@args"}]},"line":116,"range":{"end":{"line":127,"character":9999},"start":{"line":116,"character":0}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"line":117,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":117},{"definition":"my","line":118,"localvar":"my","containerName":"new","kind":13,"name":"$self"},{"name":"$class","kind":13,"containerName":"new","line":118},{"kind":13,"containerName":"new","name":"@args","line":118},{"line":120,"containerName":"new","localvar":"my","kind":13,"name":"$typemap","definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":121},{"line":121,"name":"_rearrange","containerName":"new","kind":12},{"line":123,"name":"@args","containerName":"new","kind":13},{"line":125,"containerName":"new","kind":13,"name":"$typemap"},{"name":"$self","containerName":"new","kind":13,"line":125},{"name":"typemap","kind":12,"containerName":"new","line":125},{"line":125,"name":"$typemap","kind":13,"containerName":"new"},{"line":126,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::"},{"containerName":"new","kind":12,"name":"SUPER","line":118},{"name":"typemap","containerName":"main::","children":[{"localvar":"my","containerName":"typemap","kind":13,"name":"$self","line":142,"definition":"my"},{"line":144,"name":"$self","containerName":"typemap","kind":13},{"line":145,"name":"$self","containerName":"typemap","kind":13}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":141},"end":{"character":9999,"line":146}},"line":141},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"map_types","children":[{"line":162,"localvar":"my","kind":13,"containerName":"map_types","name":"$self","definition":"my"},{"line":162,"containerName":"map_types","kind":13,"name":"@args"},{"line":164,"kind":13,"localvar":"my","containerName":"map_types","name":"$sf","definition":"my"},{"line":164,"name":"$seq","kind":13,"containerName":"map_types"},{"containerName":"map_types","kind":13,"name":"$type_map","line":164},{"line":164,"name":"$undefmap","containerName":"map_types","kind":13},{"name":"$self","kind":13,"containerName":"map_types","line":165},{"line":165,"name":"_rearrange","kind":12,"containerName":"map_types"},{"name":"@args","kind":13,"containerName":"map_types","line":170},{"line":171,"kind":13,"containerName":"map_types","name":"$sf"},{"name":"$seq","containerName":"map_types","kind":13,"line":171},{"line":172,"kind":13,"containerName":"map_types","name":"$self"},{"line":172,"name":"throw","containerName":"map_types","kind":12},{"name":"@sfs","containerName":"map_types","localvar":"my","kind":13,"line":175,"definition":"my"},{"line":175,"name":"$sf","containerName":"map_types","kind":13},{"line":176,"containerName":"map_types","kind":13,"name":"$seq"},{"line":177,"name":"$seq","containerName":"map_types","kind":13},{"name":"isa","containerName":"map_types","kind":12,"line":177},{"containerName":"map_types","kind":13,"name":"$self","line":177},{"line":177,"kind":12,"containerName":"map_types","name":"throw"},{"name":"@sfs","containerName":"map_types","kind":13,"line":178},{"kind":13,"containerName":"map_types","name":"$seq","line":178},{"containerName":"map_types","kind":12,"name":"get_all_SeqFeatures","line":178},{"line":180,"name":"$type_map","containerName":"map_types","kind":13},{"line":180,"name":"$type_map","containerName":"map_types","kind":13},{"containerName":"map_types","kind":13,"name":"$self","line":180},{"name":"typemap","kind":12,"containerName":"map_types","line":180},{"definition":"my","name":"$sf","localvar":"my","containerName":"map_types","kind":13,"line":181},{"name":"@sfs","kind":13,"containerName":"map_types","line":181},{"line":183,"containerName":"map_types","kind":13,"name":"$sf"},{"kind":12,"containerName":"map_types","name":"isa","line":183},{"line":183,"name":"$self","containerName":"map_types","kind":13},{"containerName":"map_types","kind":12,"name":"throw","line":183},{"line":184,"kind":13,"containerName":"map_types","name":"$sf"},{"containerName":"map_types","kind":12,"name":"isa","line":184},{"line":184,"name":"$self","containerName":"map_types","kind":13},{"name":"throw","kind":12,"containerName":"map_types","line":184},{"line":186,"name":"$type","kind":13,"localvar":"my","containerName":"map_types","definition":"my"},{"line":186,"kind":13,"containerName":"map_types","name":"$sf"},{"line":186,"name":"primary_tag","containerName":"map_types","kind":12},{"name":"$mtype","kind":13,"localvar":"my","containerName":"map_types","line":187,"definition":"my"},{"containerName":"map_types","kind":13,"name":"$type_map","line":187},{"kind":13,"containerName":"map_types","name":"$type","line":187},{"name":"$mtype","kind":13,"containerName":"map_types","line":188},{"line":189,"kind":13,"containerName":"map_types","name":"$mtype"},{"kind":13,"containerName":"map_types","name":"$mtype","line":190},{"containerName":"map_types","kind":13,"name":"$mtype","line":191},{"line":191,"kind":13,"containerName":"map_types","name":"$mtype"},{"line":191,"kind":13,"containerName":"map_types","name":"$sf"},{"name":"$self","containerName":"map_types","kind":13,"line":194},{"line":194,"kind":12,"containerName":"map_types","name":"throw"},{"name":"$undefmap","containerName":"map_types","kind":13,"line":197},{"line":197,"containerName":"map_types","kind":13,"name":"$mtype"},{"line":198,"name":"$mtype","containerName":"map_types","kind":13},{"line":198,"name":"$undefmap","containerName":"map_types","kind":13},{"line":200,"kind":13,"containerName":"map_types","name":"$sf"},{"name":"primary_tag","kind":12,"containerName":"map_types","line":200},{"line":200,"name":"$mtype","containerName":"map_types","kind":13}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($typemap) =\n\t$self->_rearrange([qw(TYPEMAP\n\t\t\t     )],\n                          @args);\n\n    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 typemap\n\n Title   : typemap\n Usage   : $obj->typemap($newval)\n Function: \n Example : \n Returns : value of typemap (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub typemap{\n    my $self = shift;\n\n    return $self->{'typemap'} = shift if @_;\n    return $self->{'typemap'};\n}\n\n=head2 map_types\n\n Title   : map_types\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n dgg: added -undefined => \"region\" option to produce all valid SO mappings.","label":"map_types($self,@args)"},"kind":12,"range":{"end":{"line":204,"character":9999},"start":{"character":0,"line":161}},"line":161},{"definition":"sub","children":[],"containerName":"main::","name":"FT_SO_map","line":235,"range":{"end":{"character":9999,"line":328},"start":{"line":235,"character":0}},"kind":12},{"name":"misc_RNA","kind":12,"line":319},{"line":322,"kind":12,"name":"source"},{"kind":12,"name":"rep_origin","line":324},{"kind":12,"name":"Protein","line":326},{"children":[{"definition":"my","line":331,"containerName":"map_types_to_SO","localvar":"my","kind":13,"name":"$self"},{"line":331,"name":"@args","kind":13,"containerName":"map_types_to_SO"},{"name":"@args","containerName":"map_types_to_SO","kind":13,"line":333},{"containerName":"map_types_to_SO","kind":13,"name":"$self","line":333},{"line":333,"kind":12,"containerName":"map_types_to_SO","name":"FT_SO_map"},{"line":334,"name":"$self","containerName":"map_types_to_SO","kind":13},{"line":334,"name":"map_types","containerName":"map_types_to_SO","kind":12},{"name":"@args","containerName":"map_types_to_SO","kind":13,"line":334}],"containerName":"main::","name":"map_types_to_SO","definition":"sub","detail":"($self,@args)","line":330,"range":{"start":{"character":0,"line":330},"end":{"character":9999,"line":335}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"map_types_to_SO($self,@args)"}},{"line":368,"kind":12,"range":{"end":{"character":9999,"line":384},"start":{"character":0,"line":368}},"signature":{"documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($typemap) =\n\t$self->_rearrange([qw(TYPEMAP\n\t\t\t     )],\n                          @args);\n\n    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 typemap\n\n Title   : typemap\n Usage   : $obj->typemap($newval)\n Function: \n Example : \n Returns : value of typemap (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub typemap{\n    my $self = shift;\n\n    return $self->{'typemap'} = shift if @_;\n    return $self->{'typemap'};\n}\n\n=head2 map_types\n\n Title   : map_types\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n dgg: added -undefined => \"region\" option to produce all valid SO mappings.\n\n\nsub map_types{\n   my ($self,@args) = @_;\n\n   my($sf, $seq, $type_map, $undefmap) =\n     $self->_rearrange([qw(FEATURE\n                           SEQ\n\t\t\t   TYPE_MAP\n\t\t\t   UNDEFINED\n                          )],\n                          @args);\n   if (!$sf && !$seq) {\n       $self->throw(\"you need to pass in either -feature or -seq\");\n   }\n\n   my @sfs = ($sf);\n   if ($seq) {\n       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n       @sfs = $seq->get_all_SeqFeatures;\n   }\n   $type_map = $type_map || $self->typemap; # dgg: was type_map;\n   foreach my $sf (@sfs) {\n\n       $sf->isa(\"Bio::SeqFeatureI\") || $self->throw(\"$sf NOT A SeqFeatureI\");\n       $sf->isa(\"Bio::FeatureHolderI\") || $self->throw(\"$sf NOT A FeatureHolderI\");\n\n       my $type = $sf->primary_tag;\n       my $mtype = $type_map->{$type};\n       if ($mtype) {\n\t   if (ref($mtype)) {\n\t       if (ref($mtype) eq 'CODE') {\n\t\t   $mtype = $mtype->($sf);\n\t       }\n\t       else {\n\t\t   $self->throw('must be scalar or CODE ref');\n\t       }\n\t   }\n\t   elsif ($undefmap && $mtype eq 'undefined') { # dgg\n\t      $mtype= $undefmap;\n\t      }\n\t   $sf->primary_tag($mtype);\n       }\n   }\n   return;\n}\n\n=head2 map_types_to_SO\n\n Title   : map_types_to_SO\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\nhardcodes the genbank to SO mapping\n\nBased on revision 1.22 of SO\n\nPlease see the actual code for the mappings\n\nTaken from\n\nL<http://sequenceontology.org/resources/mapping/FT_SO.txt>\n\ndgg: separated out FT_SO_map for caller changes. Update with:\n\n  open(FTSO,\"curl -s http://sequenceontology.org/resources/mapping/FT_SO.txt|\");\n  while(<FTSO>){\n    chomp; ($ft,$so,$sid,$ftdef,$sodef)= split\"\\t\";\n    print \"     '$ft' => '$so',\\n\" if($ft && $so && $ftdef);             \n  }\n\n\nsub FT_SO_map  {\n  # $self= shift;\n  # note : some of the FT_SO mappings are commented out and overriden...\n  return {\n     \"FT term\" => \"SO term\",\n     \"-\" => \"located_sequence_feature\",\n     \"-10_signal\" => \"minus_10_signal\",\n     \"-35_signal\" => \"minus_35_signal\",\n     \"3'UTR\" => \"three_prime_UTR\",\n     \"3'clip\" => \"three_prime_clip\",\n     \"5'UTR\" => \"five_prime_UTR\",\n     \"5'clip\" => \"five_prime_clip\",\n     \"CAAT_signal\" => \"CAAT_signal\",\n     \"CDS\" => \"CDS\",\n     \"C_region\" => \"undefined\",\n     \"D-loop\" => \"D_loop\",\n     \"D_segment\" => \"D_gene\",\n     \"GC_signal\" => \"GC_rich_region\",\n     \"J_segment\" => \"undefined\",\n     \"LTR\" => \"long_terminal_repeat\",\n     \"N_region\" => \"undefined\",\n     \"RBS\" => \"ribosome_entry_site\",\n     \"STS\" => \"STS\",\n     \"S_region\" => \"undefined\",\n     \"TATA_signal\" => \"TATA_box\",\n     \"V_region\" => \"undefined\",\n     \"V_segment\" => \"undefined\",\n     \"attenuator\" => \"attenuator\",\n     \"conflict\" => \"undefined\",\n     \"enhancer\" => \"enhancer\",\n     \"exon\" => \"exon\",\n     \"gap\" => \"gap\",\n     \"gene\" => \"gene\",\n     \"iDNA\" => \"iDNA\",\n     \"intron\" => \"intron\",\n     \"mRNA\" => \"mRNA\",\n     \"mat_peptide\" => \"mature_protein_region\",\n     \"mature_peptide\" => \"mature_protein_region\",\n#                     \"misc_RNA\" => \"transcript\",\n     \"misc_binding\" => \"binding_site\",\n     \"misc_difference\" => \"sequence_difference\",\n     \"misc_feature\" => \"region\",\n     \"misc_recomb\" => \"recombination_feature\",\n     \"misc_signal\" => \"regulatory_region\",\n     \"misc_structure\" => \"sequence_secondary_structure\",\n     \"modified_base\" => \"modified_base_site\",\n     \"old_sequence\" => \"undefined\",\n     \"operon\" => \"operon\",\n     \"oriT\" => \"origin_of_transfer\",\n     \"polyA_signal\" => \"polyA_signal_sequence\",\n     \"polyA_site\" => \"polyA_site\",\n     \"precursor_RNA\" => \"primary_transcript\",\n     \"prim_transcript\" => \"primary_transcript\",\n     \"primer_bind\" => \"primer_binding_site\",\n     \"promoter\" => \"promoter\",\n     \"protein_bind\" => \"protein_binding_site\",\n     \"rRNA\" => \"rRNA\",\n     \"repeat_region\" => \"repeat_region\",\n     \"repeat_unit\" => \"repeat_unit\",\n     \"satellite\" => \"satellite_DNA\",\n     \"scRNA\" => \"scRNA\",\n     \"sig_peptide\" => \"signal_peptide\",\n     \"snRNA\" => \"snRNA\",\n     \"snoRNA\" => \"snoRNA\",\n#                     \"source\" => \"databank_entry\",\n     \"stem_loop\" => \"stem_loop\",\n     \"tRNA\" => \"tRNA\",\n     \"terminator\" => \"terminator\",\n     \"transit_peptide\" => \"transit_peptide\",\n     \"unsure\" => \"undefined\",\n     \"variation\" => \"sequence_variant\",\n\n      \"pseudomRNA\" => \"pseudogenic_transcript\", ## has parent = pseudogene ; dgg\n      \"pseudotranscript\" => \"pseudogenic_transcript\", ## from Unflattener misc_RNA ; dgg\n      \"pseudoexon\" => \"pseudogenic_exon\",\n      \"pseudoCDS\"  => \"pseudogenic_exon\",\n      \"pseudomisc_feature\" => \"pseudogenic_region\",\n      \"pseudointron\" => \"pseudogenic_region\",\n      \n      ## \"undefined\" => \"region\",\n\n      # this is the most generic form for RNAs;\n      # we always represent the processed form of\n      # the transcript\n      misc_RNA=>'processed_transcript',\n      \n      # not sure about this one...\n      source=>'contig',\n      \n      rep_origin=>'origin_of_replication',\n      \n      Protein=>'protein',\n      };\n}\n\nsub map_types_to_SO{\n   my ($self,@args) = @_;\n\n   push(@args, (-type_map=> $self->FT_SO_map() ) );\n   return $self->map_types(@args);\n}\n\n=head2 get_relationship_type_by_parent_child\n\n Title   : get_relationship_type_by_parent_child\n Usage   : $type = $tm->get_relationship_type_by_parent_child($parent_sf, $child_sf);\n Usage   : $type = $tm->get_relationship_type_by_parent_child('mRNA', 'protein');\n Function: given two features where the parent contains the child,\n           will determine what the relationship between them in\n Example :\n Returns : \n Args    : parent SeqFeature, child SeqFeature OR\n           parent type string, child type string OR\n\nbioperl Seq::FeatureHolderI hierarchies are equivalent to unlabeled\ngraphs (where parent nodes are the containers, and child nodes are the\nfeatures being contained). For example, a feature of type mRNA can\ncontain features of type exon.\n\nSome external representations (eg chadoxml or chaosxml) require that\nthe edges in the feature relationship graph are labeled. For example,\nthe type between mRNA and exon would be B<part_of>. Although it\nstretches the bioperl notion of containment, we could have a CDS\ncontained by an mRNA (for example, the\nL<Bio::SeqFeature::Tools::Unflattener> module takes genbank records\nand makes these kind of links. The relationship here would be\nB<produced_by>\n\nIn chado speak, the child is the B<subject> feature and the parent is\nthe B<object> feature","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"}],"label":"get_relationship_type_by_parent_child($self,$parent,$child)"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_relationship_type_by_parent_child","line":369,"definition":"my"},{"line":369,"name":"$parent","kind":13,"containerName":"get_relationship_type_by_parent_child"},{"containerName":"get_relationship_type_by_parent_child","kind":13,"name":"$child","line":369},{"line":370,"name":"$parent","containerName":"get_relationship_type_by_parent_child","kind":13},{"line":370,"containerName":"get_relationship_type_by_parent_child","kind":13,"name":"$parent"},{"name":"$parent","kind":13,"containerName":"get_relationship_type_by_parent_child","line":370},{"line":370,"kind":12,"containerName":"get_relationship_type_by_parent_child","name":"primary_tag"},{"name":"$parent","containerName":"get_relationship_type_by_parent_child","kind":13,"line":370},{"line":371,"name":"$child","containerName":"get_relationship_type_by_parent_child","kind":13},{"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$child","line":371},{"line":371,"name":"$child","containerName":"get_relationship_type_by_parent_child","kind":13},{"containerName":"get_relationship_type_by_parent_child","kind":12,"name":"primary_tag","line":371},{"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$child","line":371},{"line":373,"localvar":"my","kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$type","definition":"my"},{"name":"$child","containerName":"get_relationship_type_by_parent_child","kind":13,"line":377},{"line":378,"name":"$type","containerName":"get_relationship_type_by_parent_child","kind":13},{"line":380,"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$child"},{"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$type","line":381},{"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$type","line":383}],"containerName":"main::","name":"get_relationship_type_by_parent_child","definition":"sub","detail":"($self,$parent,$child)"}],"version":5}