{"vars":[{"line":145,"kind":2,"containerName":"","name":"vars"},{"line":148,"kind":13,"containerName":null,"name":"@RES"},{"line":150,"kind":13,"localvar":"my","containerName":null,"name":"$attr","definition":"my"},{"line":150,"containerName":null,"kind":13,"name":"@RES"},{"name":"%OK_FIELD","kind":13,"containerName":null,"line":150},{"name":"$attr","kind":13,"containerName":null,"line":150},{"kind":2,"containerName":"","name":"base","line":153},{"line":155,"name":"$ID","containerName":null,"kind":13},{"kind":12,"range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":164}},"line":157,"containerName":"main::","name":"AUTOLOAD","children":[{"line":158,"localvar":"my","containerName":"AUTOLOAD","kind":13,"name":"$self","definition":"my"},{"line":159,"localvar":"my","kind":13,"containerName":"AUTOLOAD","name":"$attr","definition":"my"},{"name":"$AUTOLOAD","kind":13,"containerName":"AUTOLOAD","line":159},{"name":"$attr","containerName":"AUTOLOAD","kind":13,"line":160},{"kind":13,"containerName":"AUTOLOAD","name":"$self","line":161},{"name":"throw","containerName":"AUTOLOAD","kind":12,"line":161},{"line":161,"containerName":"AUTOLOAD","kind":13,"name":"$OK_FIELD"},{"name":"$attr","kind":13,"containerName":"AUTOLOAD","line":161},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":162},{"line":162,"name":"$attr","kind":13,"containerName":"AUTOLOAD"},{"line":163,"containerName":"AUTOLOAD","kind":13,"name":"$self"},{"name":"$attr","containerName":"AUTOLOAD","kind":13,"line":163}],"definition":"sub"},{"range":{"end":{"line":199,"character":9999},"start":{"line":177,"character":0}},"kind":12,"line":177,"signature":{"parameters":[{"label":"$class"},{"label":"%args"}],"documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. ","label":"new($class,%args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":181,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"%args","line":181},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":182,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":182},{"name":"%args","containerName":"new","kind":13,"line":182},{"line":186,"name":"$argument","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":186,"kind":13,"containerName":"new","name":"%args"},{"line":187,"containerName":"new","kind":13,"name":"$argument"},{"line":187,"name":"$argument","containerName":"new","kind":13},{"line":187,"name":"$argument","containerName":"new","kind":13},{"line":188,"containerName":"new","kind":13,"name":"$args"},{"line":188,"name":"$argument","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":188},{"line":188,"kind":13,"containerName":"new","name":"$args"},{"name":"$argument","containerName":"new","kind":13,"line":188},{"kind":13,"containerName":"new","name":"$args","line":190},{"line":190,"kind":13,"containerName":"new","name":"$args"},{"line":191,"name":"$self","containerName":"new","kind":13},{"name":"new","containerName":"new","kind":12,"line":191},{"kind":13,"containerName":"new","name":"$args","line":191},{"containerName":"new","kind":13,"name":"$argument","line":191},{"name":"$args","containerName":"new","kind":13,"line":191},{"name":"$self","containerName":"new","kind":13,"line":193},{"name":"$argument","kind":13,"containerName":"new","line":193},{"line":193,"containerName":"new","kind":13,"name":"$self"},{"line":194,"containerName":"new","kind":13,"name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":197},{"name":"$argument","containerName":"new","kind":13,"line":197},{"name":"$args","containerName":"new","kind":13,"line":197},{"containerName":"new","kind":13,"name":"$argument","line":197},{"line":198,"name":"$self","kind":13,"containerName":"new"},{"line":198,"name":"$argument","containerName":"new","kind":13}],"detail":"($class,%args)","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":182},{"kind":12,"name":"seq","line":188},{"line":191,"kind":12,"name":"seq"},{"line":191,"name":"Bio","kind":12,"containerName":"Seq"},{"line":193,"name":"seq","kind":12},{"kind":12,"name":"arguments","line":194},{"line":198,"kind":12,"name":"arguments"},{"line":203,"kind":13,"containerName":null,"name":"%self"},{"line":203,"kind":12,"name":"seq"},{"name":"$self","containerName":null,"kind":13,"line":203},{"name":"throw","kind":12,"containerName":"main::","line":203},{"containerName":null,"kind":13,"name":"$self","line":213},{"line":213,"containerName":"main::","kind":12,"name":"Tm"},{"containerName":null,"kind":13,"name":"$self","line":214},{"name":"seq","containerName":"main::","children":[{"definition":"my","line":229,"name":"$self","containerName":"seq","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"seq","line":230}],"definition":"sub","range":{"start":{"character":0,"line":228},"end":{"character":9999,"line":231}},"kind":12,"line":228},{"line":230,"kind":12,"name":"seq"},{"name":"primary_tag","containerName":"main::","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":235},"start":{"character":0,"line":233}},"line":233},{"definition":"sub","detail":"($self,$insource)","children":[{"line":249,"name":"$self","containerName":"source_tag","localvar":"my","kind":13,"definition":"my"},{"name":"$insource","kind":13,"containerName":"source_tag","line":249},{"name":"$insource","kind":13,"containerName":"source_tag","line":250},{"line":250,"containerName":"source_tag","kind":13,"name":"$self"},{"line":250,"containerName":"source_tag","kind":13,"name":"$insource"},{"kind":13,"containerName":"source_tag","name":"$self","line":251}],"containerName":"main::","name":"source_tag","signature":{"label":"source_tag($self,$insource)","documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.","parameters":[{"label":"$self"},{"label":"$insource"}]},"line":248,"range":{"end":{"character":9999,"line":252},"start":{"character":0,"line":248}},"kind":12},{"line":250,"name":"source","kind":12},{"name":"source","kind":12,"line":251},{"signature":{"label":"location($self,$location)","parameters":[{"label":"$self"},{"label":"$location"}],"documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location"},"range":{"start":{"line":271,"character":0},"end":{"line":276,"character":9999}},"kind":12,"line":271,"detail":"($self,$location)","definition":"sub","name":"location","containerName":"main::","children":[{"definition":"my","line":272,"localvar":"my","containerName":"location","kind":13,"name":"$self"},{"containerName":"location","kind":13,"name":"$location","line":272},{"line":273,"containerName":"location","kind":13,"name":"$location"},{"line":273,"containerName":"location","kind":13,"name":"$self"},{"kind":13,"containerName":"location","name":"$location","line":273},{"line":274,"kind":13,"containerName":"location","name":"$self"},{"line":274,"kind":13,"containerName":"location","name":"$self"}]},{"line":273,"name":"location","kind":12},{"name":"location","kind":12,"line":274},{"name":"location","kind":12,"line":274},{"range":{"end":{"line":294,"character":9999},"start":{"line":289,"character":0}},"kind":12,"line":289,"signature":{"label":"start($self,$start)","documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.","parameters":[{"label":"$self"},{"label":"$start"}]},"containerName":"main::","name":"start","children":[{"line":290,"containerName":"start","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"start","kind":13,"name":"$start","line":290},{"line":291,"kind":13,"containerName":"start","name":"$start"},{"line":291,"containerName":"start","kind":13,"name":"$self"},{"containerName":"start","kind":13,"name":"$start","line":291},{"line":292,"kind":13,"containerName":"start","name":"$self"},{"line":292,"containerName":"start","kind":13,"name":"$self"}],"detail":"($self,$start)","definition":"sub"},{"line":291,"name":"start_position","kind":12},{"name":"start_position","kind":12,"line":292},{"name":"start_position","kind":12,"line":292},{"detail":"($self,$end)","definition":"sub","name":"end","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"end","line":308},{"line":308,"containerName":"end","kind":13,"name":"$end"},{"line":309,"kind":13,"containerName":"end","name":"$end"},{"line":309,"kind":13,"containerName":"end","name":"$self"},{"line":309,"containerName":"end","kind":13,"name":"$end"},{"name":"$self","kind":13,"containerName":"end","line":310},{"line":310,"name":"$self","containerName":"end","kind":13}],"signature":{"label":"end($self,$end)","documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.\n\n\nsub start {\n     my ($self,$start) = @_;\n     if ($start) {$self->{start_position} = $start}\n     if ($self->{start_position}) {return $self->{start_position}}\n     else {return 0}\n}\n\n=head2 end()\n\n Title   : end()\n Usage   : $end_position = $primer->end($new_position);\n Function: Return the end position of this primer.\n           This is the rightmost base, regardless of whether it is a left or right primer.\n Returns : The end position of this primer.\n Args    : If supplied will set an end position.","parameters":[{"label":"$self"},{"label":"$end"}]},"kind":12,"range":{"start":{"character":0,"line":307},"end":{"character":9999,"line":312}},"line":307},{"line":309,"kind":12,"name":"end_position"},{"line":310,"name":"end_position","kind":12},{"kind":12,"name":"end_position","line":310},{"kind":12,"range":{"start":{"line":324,"character":0},"end":{"character":9999,"line":332}},"line":324,"signature":{"parameters":[{"label":"$self"},{"label":"$strand"}],"documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.\n\n\nsub start {\n     my ($self,$start) = @_;\n     if ($start) {$self->{start_position} = $start}\n     if ($self->{start_position}) {return $self->{start_position}}\n     else {return 0}\n}\n\n=head2 end()\n\n Title   : end()\n Usage   : $end_position = $primer->end($new_position);\n Function: Return the end position of this primer.\n           This is the rightmost base, regardless of whether it is a left or right primer.\n Returns : The end position of this primer.\n Args    : If supplied will set an end position.\n\n\nsub end {\n     my ($self,$end) = @_;\n     if ($end) {$self->{end_position} = $end}\n     if ($self->{end_position}) {return $self->{end_position}}\n     else {return 0}\n}\n\n=head2 strand()\n\n Title   : strand()\n Usage   : $strand=$primer->strand()\n Function: Get or set the strand.\n Returns : The strand that the primer binds to.\n Args    :  If an argument is supplied will set the strand, otherwise will return it. Should be 1, 0 (not set), or -1","label":"strand($self,$strand)"},"name":"strand","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"strand","line":325,"definition":"my"},{"line":325,"name":"$strand","containerName":"strand","kind":13},{"line":326,"name":"$strand","containerName":"strand","kind":13},{"name":"$strand","kind":13,"containerName":"strand","line":327},{"name":"$strand","kind":13,"containerName":"strand","line":327},{"line":327,"name":"$strand","kind":13,"containerName":"strand"},{"line":327,"containerName":"strand","kind":13,"name":"$self"},{"line":327,"name":"throw","containerName":"strand","kind":12},{"line":328,"containerName":"strand","kind":13,"name":"$self"},{"name":"$strand","containerName":"strand","kind":13,"line":328},{"name":"$self","kind":13,"containerName":"strand","line":330},{"name":"$self","kind":13,"containerName":"strand","line":330}],"detail":"($self,$strand)","definition":"sub"},{"name":"strand","kind":12,"line":328},{"name":"strand","kind":12,"line":330},{"line":330,"kind":12,"name":"strand"},{"definition":"sub","detail":"($self,$newid)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"display_id","line":346},{"line":346,"containerName":"display_id","kind":13,"name":"$newid"},{"name":"$newid","kind":13,"containerName":"display_id","line":347},{"line":347,"kind":13,"containerName":"display_id","name":"$self"},{"line":347,"name":"seq","kind":12,"containerName":"display_id"},{"line":347,"name":"display_id","containerName":"display_id","kind":12},{"line":347,"name":"$newid","containerName":"display_id","kind":13},{"line":348,"name":"$self","containerName":"display_id","kind":13},{"kind":12,"containerName":"display_id","name":"seq","line":348},{"line":348,"name":"display_id","containerName":"display_id","kind":12}],"containerName":"main::","name":"display_id","signature":{"documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.\n\n\nsub start {\n     my ($self,$start) = @_;\n     if ($start) {$self->{start_position} = $start}\n     if ($self->{start_position}) {return $self->{start_position}}\n     else {return 0}\n}\n\n=head2 end()\n\n Title   : end()\n Usage   : $end_position = $primer->end($new_position);\n Function: Return the end position of this primer.\n           This is the rightmost base, regardless of whether it is a left or right primer.\n Returns : The end position of this primer.\n Args    : If supplied will set an end position.\n\n\nsub end {\n     my ($self,$end) = @_;\n     if ($end) {$self->{end_position} = $end}\n     if ($self->{end_position}) {return $self->{end_position}}\n     else {return 0}\n}\n\n=head2 strand()\n\n Title   : strand()\n Usage   : $strand=$primer->strand()\n Function: Get or set the strand.\n Returns : The strand that the primer binds to.\n Args    :  If an argument is supplied will set the strand, otherwise will return it. Should be 1, 0 (not set), or -1\n\n\nsub strand {\n     my ($self, $strand) = @_;\n     if ($strand) {\n      unless ($strand == -1 || $strand == 0 ||$strand == 1) {$self->throw(\"Strand must be either 1, 0, or -1 not $strand\")}\n      $self->{strand}=$strand;\n     }\n     if ($self->{strand}) {return $self->{strand}}\n     else {return 0}\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id = $primer->display_id($new_id)\n Function: Returns the display ID for this Primer feature\n Returns : A scalar.\n Args    : If an argument is provided, the display_id of this primer is\n           set to that value.","parameters":[{"label":"$self"},{"label":"$newid"}],"label":"display_id($self,$newid)"},"line":345,"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"line":345,"character":0}}},{"signature":{"label":"Tm($self,%args)","documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.\n\n\nsub start {\n     my ($self,$start) = @_;\n     if ($start) {$self->{start_position} = $start}\n     if ($self->{start_position}) {return $self->{start_position}}\n     else {return 0}\n}\n\n=head2 end()\n\n Title   : end()\n Usage   : $end_position = $primer->end($new_position);\n Function: Return the end position of this primer.\n           This is the rightmost base, regardless of whether it is a left or right primer.\n Returns : The end position of this primer.\n Args    : If supplied will set an end position.\n\n\nsub end {\n     my ($self,$end) = @_;\n     if ($end) {$self->{end_position} = $end}\n     if ($self->{end_position}) {return $self->{end_position}}\n     else {return 0}\n}\n\n=head2 strand()\n\n Title   : strand()\n Usage   : $strand=$primer->strand()\n Function: Get or set the strand.\n Returns : The strand that the primer binds to.\n Args    :  If an argument is supplied will set the strand, otherwise will return it. Should be 1, 0 (not set), or -1\n\n\nsub strand {\n     my ($self, $strand) = @_;\n     if ($strand) {\n      unless ($strand == -1 || $strand == 0 ||$strand == 1) {$self->throw(\"Strand must be either 1, 0, or -1 not $strand\")}\n      $self->{strand}=$strand;\n     }\n     if ($self->{strand}) {return $self->{strand}}\n     else {return 0}\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id = $primer->display_id($new_id)\n Function: Returns the display ID for this Primer feature\n Returns : A scalar.\n Args    : If an argument is provided, the display_id of this primer is\n           set to that value.\n\n\nsub display_id {\n     my ($self,$newid) = @_;\n     if ($newid) {$self->seq()->display_id($newid)}\n     return $self->seq()->display_id();\n}\n\n\n=head2 Tm()\n\n  Title   : Tm()\n  Usage   : $tm = $primer->Tm(-salt=>'0.05', -oligo=>'0.0000001')\n  Function: Calculates and returns the Tm (melting temperature) of the primer\n  Returns : A scalar containing the Tm.\n  Args    : -salt  : set the Na+ concentration on which to base the calculation\n                     (default=0.05 molar).\n          : -oligo : set the oligo concentration on which to base the\n                     calculation (default=0.00000025 molar).\n  Notes   : Calculation of Tm as per Allawi et. al Biochemistry 1997\n            36:10581-10594. Also see documentation at\n            http://www.idtdna.com/Scitools/Scitools.aspx as they use this\n            formula and have a couple nice help pages. These Tm values will be\n            about are about 0.5-3 degrees off from those of the idtdna web tool.\n            I don't know why.\n\n            This was suggested by Barry Moore (thanks!). See the discussion on\n            the bioperl-l with the subject \"Bio::SeqFeature::Primer Calculating\n            the PrimerTM\"","parameters":[{"label":"$self"},{"label":"%args"}]},"line":375,"range":{"start":{"character":0,"line":375},"end":{"line":449,"character":9999}},"kind":12,"definition":"sub","detail":"($self,%args)","children":[{"definition":"my","line":376,"name":"$self","containerName":"Tm","localvar":"my","kind":13},{"line":376,"containerName":"Tm","kind":13,"name":"%args"},{"line":377,"name":"$salt_conc","containerName":"Tm","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":378,"name":"$oligo_conc","kind":13,"localvar":"my","containerName":"Tm"},{"line":379,"name":"$args","kind":13,"containerName":"Tm"},{"containerName":"Tm","kind":13,"name":"$salt_conc","line":379},{"line":379,"name":"$args","containerName":"Tm","kind":13},{"line":380,"containerName":"Tm","kind":13,"name":"$args"},{"name":"$oligo_conc","containerName":"Tm","kind":13,"line":380},{"name":"$args","containerName":"Tm","kind":13,"line":380},{"name":"$seqobj","localvar":"my","containerName":"Tm","kind":13,"line":381,"definition":"my"},{"line":381,"kind":13,"containerName":"Tm","name":"$self"},{"name":"seq","containerName":"Tm","kind":12,"line":381},{"name":"$length","containerName":"Tm","localvar":"my","kind":13,"line":382,"definition":"my"},{"kind":13,"containerName":"Tm","name":"$seqobj","line":382},{"name":"length","containerName":"Tm","kind":12,"line":382},{"name":"$sequence","containerName":"Tm","localvar":"my","kind":13,"line":383,"definition":"my"},{"line":383,"name":"$seqobj","containerName":"Tm","kind":13},{"line":383,"kind":12,"containerName":"Tm","name":"seq"},{"definition":"my","line":384,"name":"@dinucleotides","kind":13,"localvar":"my","containerName":"Tm"},{"definition":"my","localvar":"my","containerName":"Tm","kind":13,"name":"$enthalpy","line":385},{"name":"$entropy","kind":13,"localvar":"my","containerName":"Tm","line":386,"definition":"my"},{"line":388,"containerName":"Tm","kind":13,"name":"$sequence"},{"name":"@dinucleotides","containerName":"Tm","kind":13,"line":389},{"line":392,"name":"%thermo_values","localvar":"my","kind":13,"containerName":"Tm","definition":"my"},{"kind":13,"containerName":"Tm","name":"@dinucleotides","line":434},{"line":435,"containerName":"Tm","kind":13,"name":"$enthalpy"},{"line":435,"name":"$thermo_values","containerName":"Tm","kind":13},{"line":436,"name":"$entropy","kind":13,"containerName":"Tm"},{"containerName":"Tm","kind":13,"name":"$thermo_values","line":436},{"kind":13,"containerName":"Tm","name":"$enthalpy","line":439},{"containerName":"Tm","kind":13,"name":"$thermo_values","line":439},{"line":439,"containerName":"Tm","kind":13,"name":"$sequence"},{"line":440,"containerName":"Tm","kind":13,"name":"$entropy"},{"name":"$thermo_values","kind":13,"containerName":"Tm","line":440},{"kind":13,"containerName":"Tm","name":"$sequence","line":440},{"line":441,"containerName":"Tm","kind":13,"name":"$enthalpy"},{"line":441,"name":"$thermo_values","containerName":"Tm","kind":13},{"name":"$sequence","containerName":"Tm","kind":13,"line":441},{"kind":13,"containerName":"Tm","name":"$entropy","line":442},{"name":"$thermo_values","containerName":"Tm","kind":13,"line":442},{"containerName":"Tm","kind":13,"name":"$sequence","line":442},{"line":444,"name":"$entropy","kind":13,"containerName":"Tm"},{"line":445,"kind":13,"localvar":"my","containerName":"Tm","name":"$r","definition":"my"},{"name":"$tm","kind":13,"localvar":"my","containerName":"Tm","line":446,"definition":"my"},{"name":"$enthalpy","kind":13,"containerName":"Tm","line":446},{"name":"$entropy","kind":13,"containerName":"Tm","line":446},{"name":"$r","kind":13,"containerName":"Tm","line":446},{"line":446,"kind":13,"containerName":"Tm","name":"$oligo_conc"},{"name":"$salt_conc","kind":13,"containerName":"Tm","line":446},{"name":"$self","kind":13,"containerName":"Tm","line":447},{"line":447,"containerName":"Tm","kind":13,"name":"$tm"},{"line":448,"name":"$tm","kind":13,"containerName":"Tm"}],"name":"Tm","containerName":"main::"},{"line":435,"kind":12,"name":"enthalpy"},{"line":436,"kind":12,"name":"entropy"},{"line":439,"kind":12,"name":"enthalpy"},{"name":"entropy","kind":12,"line":440},{"kind":12,"name":"enthalpy","line":441},{"line":442,"kind":12,"name":"entropy"},{"range":{"end":{"line":515,"character":9999},"start":{"line":482,"character":0}},"kind":12,"line":482,"signature":{"label":"Tm_estimate($self,%args)","parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: Primer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Primer\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Primer - Primer Generic SeqFeature\n\n=head1 SYNOPSIS\n\n # set up a single primer that can be used in a PCR reaction\n\n use Bio::SeqFeature::Primer;\n\n # initiate a primer with raw sequence\n my $primer=Bio::SeqFeature::Primer->new(-seq=>'CTTTTCATTCTGACTGCAACG');\n\n # get the primery tag for the primer # should return Primer\n my $tag=$primer->primary_tag;\n\n # get or set the location that the primer binds to the target at\n $primer->location(500);\n my $location=$primer->location(500);\n\n # get or set the 5' end of the primer homology, as the primer doesn't \n # have to be the same as the target sequence\n $primer->start(2);\n my $start=$primer->start;\n\n # get or set the 3' end of the primer homology\n $primer->end(19);\n my $end = $primer->end;\n\n # get or set the strand of the primer. Strand should be 1, 0, or -1\n $primer->strand(-1);\n my $strand=$primer->strand;\n\n # get or set the id of the primer\n $primer->display_id('test_id');\n my $id=$primer->display_id;\n\n # get the tm of the primer. This is calculated for you by the software.\n # however, see the docs.\n my $tm = $primer->Tm;\n\n print \"These are the details of the primer:\\n\\tTag:\\t\\t$tag\\n\\tLocation\\t$location\\n\\tStart:\\t\\t$start\\n\";\n print \"\\tEnd:\\t\\t$end\\n\\tStrand:\\t\\t$strand\\n\\tID:\\t\\t$id\\n\\tTm:\\t\\t$tm\\n\";\n\n\n\n=head1 DESCRIPTION\n\nHandle primer sequences. This will allow you to generate a primer\nobject required for a Bio::Seq::PrimedSeq object. This module is\ndesigned to integrate with Bio::Tools::Primer3 and\nBio::Seq::PrimedSeq.\n\nIn addition, you can calculate the melting temperature of the primer.\n\nThis module is supposed to implement location and range, presumably\nthrough generic.pm, but does not do so yet. However, it does allow you\nto set primers, and use those objects as the basis for\nBio::Seq::PrimedSeq objects.\n\nSee also the POD for Bio::Seq::PrimedSeq and\nBio::Tools::Nucleotide::Analysis::Primer3\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nRob Edwards, redwards@utmem.edu\n\nThe original concept and much of the code was written by\nChad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\n\tThe rest of the documentation details each of the object\n\tmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Primer;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Tools::SeqStats;\n\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nBEGIN {\n @RES=qw(); # nothing here yet, not sure what we want!\n\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\n$ID = 'Bio::SeqFeature::Primer';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n=head2 new()\n\n Title   : new()\n Usage   : $primer = Bio::SeqFeature::Primer(-seq=>sequence_object);\n Function: Instantiate a new object\n Returns : A SeqPrimer object\n Args    : You must pass either a sequence object (preferable) or a sequence. \n\n\n\nsub new {\n  # I have changed some of Chad's code. I hope he doesn't mind. Mine is more stupid than his, but my simple mind gets it.\n  # I also removed from of the generic.pm things, but we can put them back....\n\n  my ($class, %args) = @_;  \n  my $self = $class->SUPER::new(%args);\n  # i am going to keep an array of the things that have been passed\n  # into the object on construction. this will aid retrieval of these\n  # things later\n  foreach my $argument (keys %args) {\n   if ($argument eq \"-SEQUENCE\" || $argument eq \"-sequence\" || $argument eq \"-seq\") {\n    if (ref($args{$argument}) eq \"Bio::Seq\") {$self->{seq} = $args{$argument}}\n    else {\n     unless ($args{-id}) {$args{-id}=\"SeqFeature Primer object\"}\n     $self->{seq} = Bio::Seq->new( -seq => $args{$argument}, -id => $args{-id});\n    }\n    $self->{$argument} = $self->{seq};\n    push (@{$self->{arguments}}, \"seq\");\n   }\n   else {\n    $self->{$argument} = $args{$argument};\n    push (@{$self->{arguments}}, $argument); # note need to check the BioPerl way of doing this.\n   }\n  }\n\n  # now error check and make sure that we at least got a sequence\n  if (!$self->{seq}) {$self->throw(\"You must pass in a sequence to construct this object.\")}\n\n   # a bunch of things now need to be set for this SeqFeature\n   # things like:\n   # TARGET=513,26\n   # PRIMER_FIRST_BASE_INDEX=1\n   # PRIMER_LEFT=484,20\n\n   # these can be added in, and we won't demand them, but provide a mechanism to check that they exist\n\n   $self->Tm();\n   return $self;\n}\n\n\n=head2 seq()\n\n Title   : seq()\n Usage   : $seq = $primer->seq();\n Function: Return the sequence associated with this Primer. \n Returns : A Bio::Seq object\n Args    : None.\n\n\nsub seq {\n     my $self = shift;\n     return $self->{seq};\n}\n\nsub primary_tag {\n     return \"Primer\";\n}\n\n=head2 source_tag()\n\n Title   : source_tag()\n Usage   : $tag = $feature->source_tag();\n Function: Returns the source of this tag.\n Returns : A string.\n Args    : If an argument is provided, the source of this SeqFeature\n           is set to that argument.\n\n\nsub source_tag {\n     my ($self,$insource) = @_;\n     if ($insource) { $self->{source} = $insource; }\n     return $self->{source};\n}\n\n=head2 location()\n\n Title   : location()\n Usage   : $tag = $primer->location();\n Function: Gets or sets the location of the primer on the sequence  \n Returns : If the location is set, returns that, if not returns 0. \n           Note: At the moment I am using the primer3 notation of location\n\t   (although you can set whatever you want). \n\t   In this form, both primers are given from their 5' ends and a length.\n\t   In this case, the left primer is given from the leftmost end, but\n\t   the right primer is given from the rightmost end.\n\t   You can use start() and end() to get the leftmost and rightmost base\n\t   of each sequence.\n Args    : If supplied will set a location\n\n\nsub location {\n     my ($self, $location) = @_;\n     if ($location) {$self->{location}=$location}\n     if ($self->{location}) {return $self->{location}}\n     else {return 0}\n}\n\n=head2 start()\n\n Title   : start()\n Usage   : $start_position = $primer->start($new_position);\n Function: Return the start position of this Primer.\n           This is the leftmost base, regardless of whether it is a left or right primer.\n Returns : The start position of this primer or 0 if not set.\n Args    : If supplied will set a start position.\n\n\nsub start {\n     my ($self,$start) = @_;\n     if ($start) {$self->{start_position} = $start}\n     if ($self->{start_position}) {return $self->{start_position}}\n     else {return 0}\n}\n\n=head2 end()\n\n Title   : end()\n Usage   : $end_position = $primer->end($new_position);\n Function: Return the end position of this primer.\n           This is the rightmost base, regardless of whether it is a left or right primer.\n Returns : The end position of this primer.\n Args    : If supplied will set an end position.\n\n\nsub end {\n     my ($self,$end) = @_;\n     if ($end) {$self->{end_position} = $end}\n     if ($self->{end_position}) {return $self->{end_position}}\n     else {return 0}\n}\n\n=head2 strand()\n\n Title   : strand()\n Usage   : $strand=$primer->strand()\n Function: Get or set the strand.\n Returns : The strand that the primer binds to.\n Args    :  If an argument is supplied will set the strand, otherwise will return it. Should be 1, 0 (not set), or -1\n\n\nsub strand {\n     my ($self, $strand) = @_;\n     if ($strand) {\n      unless ($strand == -1 || $strand == 0 ||$strand == 1) {$self->throw(\"Strand must be either 1, 0, or -1 not $strand\")}\n      $self->{strand}=$strand;\n     }\n     if ($self->{strand}) {return $self->{strand}}\n     else {return 0}\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id = $primer->display_id($new_id)\n Function: Returns the display ID for this Primer feature\n Returns : A scalar.\n Args    : If an argument is provided, the display_id of this primer is\n           set to that value.\n\n\nsub display_id {\n     my ($self,$newid) = @_;\n     if ($newid) {$self->seq()->display_id($newid)}\n     return $self->seq()->display_id();\n}\n\n\n=head2 Tm()\n\n  Title   : Tm()\n  Usage   : $tm = $primer->Tm(-salt=>'0.05', -oligo=>'0.0000001')\n  Function: Calculates and returns the Tm (melting temperature) of the primer\n  Returns : A scalar containing the Tm.\n  Args    : -salt  : set the Na+ concentration on which to base the calculation\n                     (default=0.05 molar).\n          : -oligo : set the oligo concentration on which to base the\n                     calculation (default=0.00000025 molar).\n  Notes   : Calculation of Tm as per Allawi et. al Biochemistry 1997\n            36:10581-10594. Also see documentation at\n            http://www.idtdna.com/Scitools/Scitools.aspx as they use this\n            formula and have a couple nice help pages. These Tm values will be\n            about are about 0.5-3 degrees off from those of the idtdna web tool.\n            I don't know why.\n\n            This was suggested by Barry Moore (thanks!). See the discussion on\n            the bioperl-l with the subject \"Bio::SeqFeature::Primer Calculating\n            the PrimerTM\"\n\n\nsub Tm  {\n     my ($self, %args) = @_;\n     my $salt_conc = 0.05; #salt concentration (molar units)\n     my $oligo_conc = 0.00000025; #oligo concentration (molar units)\n     if ($args{'-salt'}) {$salt_conc = $args{'-salt'}} #accept object defined salt concentration\n     if ($args{'-oligo'}) {$oligo_conc = $args{'-oligo'}} #accept object defined oligo concentration\n     my $seqobj = $self->seq();\n     my $length = $seqobj->length();\n     my $sequence = uc $seqobj->seq();\n     my @dinucleotides;\n     my $enthalpy;\n     my $entropy;\n     #Break sequence string into an array of all possible dinucleotides\n     while ($sequence =~ /(.)(?=(.))/g) {\n         push @dinucleotides, $1.$2;\n     }\n     #Build a hash with the thermodynamic values\n     my %thermo_values = ('AA' => {'enthalpy' => -7.9,\n                                   'entropy'  => -22.2},\n                          'AC' => {'enthalpy' => -8.4,\n                                   'entropy'  => -22.4},\n                          'AG' => {'enthalpy' => -7.8,\n                                   'entropy'  => -21},\n                          'AT' => {'enthalpy' => -7.2,\n                                   'entropy'  => -20.4},\n                          'CA' => {'enthalpy' => -8.5,\n                                   'entropy'  => -22.7},\n                          'CC' => {'enthalpy' => -8,\n                                   'entropy'  => -19.9},\n                          'CG' => {'enthalpy' => -10.6,\n                                   'entropy'  => -27.2},\n                          'CT' => {'enthalpy' => -7.8,\n                                   'entropy'  => -21},\n                          'GA' => {'enthalpy' => -8.2,\n                                   'entropy'  => -22.2},\n                          'GC' => {'enthalpy' => -9.8,\n                                   'entropy'  => -24.4},\n                          'GG' => {'enthalpy' => -8,\n                                   'entropy'  => -19.9},\n                          'GT' => {'enthalpy' => -8.4,\n                                   'entropy'  => -22.4},\n                          'TA' => {'enthalpy' => -7.2,\n                                   'entropy'  => -21.3},\n                          'TC' => {'enthalpy' => -8.2,\n                                   'entropy'  => -22.2},\n                          'TG' => {'enthalpy' => -8.5,\n                                   'entropy'  => -22.7},\n                          'TT' => {'enthalpy' => -7.9,\n                                   'entropy'  => -22.2},\n                          'A' =>  {'enthalpy' => 2.3,\n                                   'entropy'  => 4.1},\n                          'C' =>  {'enthalpy' => 0.1,\n                                   'entropy'  => -2.8},\n                          'G' =>  {'enthalpy' => 0.1,\n                                   'entropy'  => -2.8},\n                          'T' =>  {'enthalpy' => 2.3,\n                                   'entropy'  => 4.1}\n                         );\n     #Loop through dinucleotides and calculate cumulative enthalpy and entropy values\n     for (@dinucleotides) {\n        $enthalpy += $thermo_values{$_}{enthalpy};\n        $entropy += $thermo_values{$_}{entropy};\n     }\n     #Account for initiation parameters\n     $enthalpy += $thermo_values{substr($sequence, 0, 1)}{enthalpy};\n     $entropy += $thermo_values{substr($sequence, 0, 1)}{entropy};\n     $enthalpy += $thermo_values{substr($sequence, -1, 1)}{enthalpy};\n     $entropy += $thermo_values{substr($sequence, -1, 1)}{entropy};\n     #Symmetry correction\n     $entropy -= 1.4;\n     my $r = 1.987; #molar gas constant\n     my $tm = ($enthalpy * 1000 / ($entropy + ($r * log($oligo_conc))) - 273.15 + (12* (log($salt_conc)/log(10))));\n     $self->{'Tm'}=$tm;\n     return $tm;\n }\n\n=head2 Tm_estimate\n\n Title   : Tm_estimate\n Usage   : $tm = $primer->Tm_estimate(-salt=>'0.05')\n Function: Calculates and returns the Tm (melting temperature) of the primer\n Returns : A scalar containing the Tm.\n Args    : -salt set the Na+ concentration on which to base the calculation.\n Notes   : This is an estimate of the Tm that is kept in for comparative reasons.\n           You should probably use Tm instead!\n\n\t   This Tm calculations are taken from the Primer3 docs: They are\n\t   based on Bolton and McCarthy, PNAS 84:1390 (1962) \n\t   as presented in Sambrook, Fritsch and Maniatis,\n\t   Molecular Cloning, p 11.46 (1989, CSHL Press).\n\n\t   Tm = 81.5 + 16.6(log10([Na+])) + .41*(%GC) - 600/length\n\n\t   where [Na+] is the molar sodium concentration, %GC is the\n\t   %G+C of the sequence, and length is the length of the sequence.\n\n\t   However.... I can never get this calculation to give me the same result\n\t   as primer3 does. Don't ask why, I never figured it out. But I did \n\t   want to include a Tm calculation here becuase I use these modules for \n\t   other things besides reading primer3 output.\n\n\t   The primer3 calculation is saved as 'PRIMER_LEFT_TM' or 'PRIMER_RIGHT_TM'\n\t   and this calculation is saved as $primer->Tm so you can get both and\n\t   average them!"},"containerName":"main::","name":"Tm_estimate","children":[{"line":486,"containerName":"Tm_estimate","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"%args","kind":13,"containerName":"Tm_estimate","line":486},{"line":487,"localvar":"my","containerName":"Tm_estimate","kind":13,"name":"$salt","definition":"my"},{"line":488,"name":"$args","containerName":"Tm_estimate","kind":13},{"line":488,"name":"$salt","containerName":"Tm_estimate","kind":13},{"line":488,"name":"$args","containerName":"Tm_estimate","kind":13},{"definition":"my","line":489,"name":"$seqobj","localvar":"my","kind":13,"containerName":"Tm_estimate"},{"line":489,"containerName":"Tm_estimate","kind":13,"name":"$self"},{"line":489,"kind":12,"containerName":"Tm_estimate","name":"seq"},{"definition":"my","line":490,"name":"$length","localvar":"my","kind":13,"containerName":"Tm_estimate"},{"line":490,"containerName":"Tm_estimate","kind":13,"name":"$seqobj"},{"kind":12,"containerName":"Tm_estimate","name":"length","line":490},{"containerName":"Tm_estimate","localvar":"my","kind":13,"name":"$seqdata","line":491,"definition":"my"},{"line":491,"kind":12,"containerName":"Tm_estimate","name":"count_monomers"},{"line":491,"name":"$seqobj","containerName":"Tm_estimate","kind":13},{"name":"$gc","containerName":"Tm_estimate","localvar":"my","kind":13,"line":492,"definition":"my"},{"definition":"my","line":493,"name":"$percent_gc","localvar":"my","kind":13,"containerName":"Tm_estimate"},{"line":493,"containerName":"Tm_estimate","kind":13,"name":"$gc"},{"name":"$length","kind":13,"containerName":"Tm_estimate","line":493},{"line":496,"name":"$tm","containerName":"Tm_estimate","localvar":"my","kind":13,"definition":"my"},{"line":496,"name":"$salt","containerName":"Tm_estimate","kind":13},{"line":496,"name":"$percent_gc","containerName":"Tm_estimate","kind":13},{"kind":13,"containerName":"Tm_estimate","name":"$length","line":496},{"kind":13,"containerName":"Tm_estimate","name":"$self","line":513},{"line":513,"name":"$tm","containerName":"Tm_estimate","kind":13},{"line":514,"name":"$tm","containerName":"Tm_estimate","kind":13}],"detail":"($self,%args)","definition":"sub"},{"line":491,"name":"Bio","kind":12,"containerName":"Tools::SeqStats"},{"kind":12,"name":"seqdata","line":492},{"line":492,"name":"seqdata","kind":12}],"version":5}