{"version":5,"vars":[{"line":77,"name":"base","kind":2,"containerName":""},{"kind":12,"range":{"end":{"line":98,"character":9999},"start":{"line":95,"character":0}},"line":95,"signature":{"label":"transcripts($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : "},"containerName":"main::","name":"transcripts","children":[{"localvar":"my","containerName":"transcripts","kind":13,"name":"$self","line":96,"definition":"my"},{"line":97,"name":"$self","kind":13,"containerName":"transcripts"},{"line":97,"name":"throw_not_implemented","kind":12,"containerName":"transcripts"}],"detail":"($self)","definition":"sub"},{"name":"promoters","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"promoters","name":"$self","line":117},{"line":118,"name":"$self","containerName":"promoters","kind":13},{"name":"throw_not_implemented","kind":12,"containerName":"promoters","line":118}],"detail":"($self)","definition":"sub","range":{"start":{"line":116,"character":0},"end":{"character":9999,"line":119}},"kind":12,"line":116,"signature":{"label":"promoters($self)","documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : ","parameters":[{"label":"$self"}]}},{"name":"exons","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"exons","name":"$self","line":142},{"name":"$type","containerName":"exons","kind":13,"line":142},{"containerName":"exons","kind":13,"name":"$self","line":143},{"containerName":"exons","kind":12,"name":"throw_not_implemented","line":143}],"detail":"($self,$type)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":144},"start":{"line":141,"character":0}},"line":141,"signature":{"label":"exons($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon."}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : ","label":"introns($self)"},"range":{"end":{"character":9999,"line":161},"start":{"line":158,"character":0}},"kind":12,"line":158,"detail":"($self)","definition":"sub","name":"introns","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"introns","line":159},{"line":160,"containerName":"introns","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"introns","kind":12,"line":160}]},{"definition":"sub","detail":"($self)","children":[{"line":176,"kind":13,"localvar":"my","containerName":"poly_A_sites","name":"$self","definition":"my"},{"line":177,"containerName":"poly_A_sites","kind":13,"name":"$self"},{"line":177,"kind":12,"containerName":"poly_A_sites","name":"throw_not_implemented"}],"containerName":"main::","name":"poly_A_sites","signature":{"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation features/sites of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           poly-adenylation regions or sites.\n Args    : ","parameters":[{"label":"$self"}],"label":"poly_A_sites($self)"},"line":175,"kind":12,"range":{"end":{"line":178,"character":9999},"start":{"character":0,"line":175}}},{"detail":"($self)","definition":"sub","name":"utrs","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"utrs","kind":13,"name":"$self","line":197},{"name":"$self","containerName":"utrs","kind":13,"line":198},{"line":198,"containerName":"utrs","kind":12,"name":"throw_not_implemented"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation features/sites of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           poly-adenylation regions or sites.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs();\n Function: Get the UTR features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : ","label":"utrs($self)"},"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":199}},"kind":12,"line":196}]}