{"vars":[{"line":85,"kind":2,"containerName":"","name":"base"},{"children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":99,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":99},{"definition":"my","line":100,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"line":100,"kind":13,"containerName":"new","name":"$class"},{"line":100,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":101,"name":"$type","kind":13,"localvar":"my","containerName":"new"},{"line":101,"kind":13,"containerName":"new","name":"$self"},{"line":101,"kind":12,"containerName":"new","name":"_rearrange"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"line":102,"kind":13,"containerName":"new","name":"$type"},{"line":103,"containerName":"new","kind":13,"name":"$type"},{"containerName":"new","kind":13,"name":"$self","line":105},{"line":105,"name":"type","kind":12,"containerName":"new"},{"name":"$type","kind":13,"containerName":"new","line":105},{"line":106,"name":"$self","containerName":"new","kind":13}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":98,"range":{"end":{"character":9999,"line":107},"start":{"character":0,"line":98}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.","label":"new($class,@args)"}},{"containerName":"new","kind":12,"name":"SUPER","line":100},{"name":"create","containerName":"main::","children":[{"line":127,"name":"$self","localvar":"my","containerName":"create","kind":13,"definition":"my"},{"name":"@args","containerName":"create","kind":13,"line":127},{"name":"$self","containerName":"create","kind":13,"line":128},{"line":128,"kind":12,"containerName":"create","name":"type"},{"name":"new","containerName":"create","kind":12,"line":128},{"line":128,"containerName":"create","kind":13,"name":"$self"},{"line":128,"kind":12,"containerName":"create","name":"verbose"},{"line":128,"name":"@args","containerName":"create","kind":13}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"line":126,"character":0},"end":{"character":9999,"line":129}},"line":126,"signature":{"documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)], @args);\n  if( ! defined $type ) { \n      $type = 'Bio::PrimarySeq';\n  }\n  $self->type($type);\n  return $self;\n}\n\n\n=head2 create\n\n Title   : create\n Usage   : my $seq = $seqbuilder->create(-seq => 'CAGT', -id => 'name');\n Function: Instantiates new Bio::SeqI (or one of its child classes)\n           This object allows us to genericize the instantiation of sequence\n           objects.\n Returns : Bio::PrimarySeq object (default)\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of sequence\n           object we want.  Typically \n           -seq        => $str,\n           -display_id => $name","parameters":[{"label":"$self"},{"label":"@args"}],"label":"create($self,@args)"}},{"name":"type","containerName":"main::","children":[{"definition":"my","line":143,"localvar":"my","containerName":"type","kind":13,"name":"$self"},{"name":"$value","containerName":"type","kind":13,"line":143},{"line":144,"name":"$value","kind":13,"containerName":"type"},{"line":146,"containerName":"type","kind":13,"name":"$self"},{"kind":12,"containerName":"type","name":"throw","line":146},{"definition":"my","line":148,"containerName":"type","localvar":"my","kind":13,"name":"$a"},{"kind":13,"containerName":"type","name":"$value","line":148},{"name":"$a","containerName":"type","kind":13,"line":149},{"line":149,"name":"isa","kind":12,"containerName":"type"},{"containerName":"type","kind":13,"name":"$a","line":150},{"kind":12,"containerName":"type","name":"isa","line":150},{"name":"$self","kind":13,"containerName":"type","line":151},{"containerName":"type","kind":12,"name":"throw","line":151},{"line":153,"kind":13,"containerName":"type","name":"$self"},{"line":153,"containerName":"type","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"type","line":155}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"line":142,"character":0},"end":{"line":156,"character":9999}},"line":142,"signature":{"label":"type($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)], @args);\n  if( ! defined $type ) { \n      $type = 'Bio::PrimarySeq';\n  }\n  $self->type($type);\n  return $self;\n}\n\n\n=head2 create\n\n Title   : create\n Usage   : my $seq = $seqbuilder->create(-seq => 'CAGT', -id => 'name');\n Function: Instantiates new Bio::SeqI (or one of its child classes)\n           This object allows us to genericize the instantiation of sequence\n           objects.\n Returns : Bio::PrimarySeq object (default)\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of sequence\n           object we want.  Typically \n           -seq        => $str,\n           -display_id => $name\n\n\nsub create {\n   my ($self,@args) = @_;\n   return $self->type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $obj->type($newval)\n Function: \n Returns : value of type\n Args    : newvalue (optional)"}}],"version":5}