{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":133},{"line":135,"name":"%slot_param_map","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"%param_slot_map","containerName":null,"localvar":"my","kind":13,"line":137,"definition":"my"},{"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":151},{"name":"@args","kind":13,"containerName":"new","line":151},{"definition":"my","line":153,"name":"$self","containerName":"new","localvar":"my","kind":13},{"containerName":"new","kind":13,"name":"$class","line":153},{"name":"@args","kind":13,"containerName":"new","line":153},{"line":155,"containerName":"new","kind":13,"name":"$self"},{"kind":13,"containerName":"new","name":"$self","line":156},{"name":"$self","containerName":"new","kind":13,"line":157},{"line":158,"name":"$self","containerName":"new","kind":13},{"line":159,"containerName":"new","kind":13,"name":"$self"},{"name":"want_all","containerName":"new","kind":12,"line":159},{"line":161,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)","line":150,"range":{"end":{"character":9999,"line":162},"start":{"line":150,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]}},{"name":"SUPER","containerName":"new","kind":12,"line":153},{"line":192,"kind":12,"range":{"start":{"character":0,"line":192},"end":{"line":221,"character":9999}},"signature":{"label":"want_slot($self,$slot)","parameters":[{"label":"$self"},{"label":"$slot"}],"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"want_slot","line":193,"definition":"my"},{"name":"$slot","containerName":"want_slot","kind":13,"line":193},{"name":"$ok","localvar":"my","kind":13,"containerName":"want_slot","line":194,"definition":"my"},{"name":"$slot","kind":13,"containerName":"want_slot","line":196},{"kind":13,"containerName":"want_slot","name":"$slot","line":196},{"kind":13,"containerName":"want_slot","name":"$slot","line":196},{"line":197,"name":"$self","containerName":"want_slot","kind":13},{"line":197,"name":"want_all","containerName":"want_slot","kind":12},{"name":"$self","kind":13,"containerName":"want_slot","line":198},{"line":198,"kind":12,"containerName":"want_slot","name":"get_unwanted_slots"},{"containerName":"want_slot","kind":13,"name":"$slot","line":200},{"line":202,"kind":13,"containerName":"want_slot","name":"$self"},{"name":"$self","containerName":"want_slot","kind":13,"line":203},{"containerName":"want_slot","kind":13,"name":"$self","line":203},{"kind":12,"containerName":"want_slot","name":"sequence_factory","line":203},{"containerName":"want_slot","kind":12,"name":"create_object","line":203},{"name":"$param_slot_map","kind":13,"containerName":"want_slot","line":205},{"line":205,"kind":13,"containerName":"want_slot","name":"$slot"},{"kind":13,"containerName":"want_slot","name":"$ok","line":206},{"name":"$self","containerName":"want_slot","kind":13,"line":206},{"line":206,"name":"can","kind":12,"containerName":"want_slot"},{"line":206,"kind":13,"containerName":"want_slot","name":"$param_slot_map"},{"line":206,"containerName":"want_slot","kind":13,"name":"$slot"},{"line":208,"name":"$ok","containerName":"want_slot","kind":13},{"line":208,"name":"$self","containerName":"want_slot","kind":13},{"line":208,"name":"can","kind":12,"containerName":"want_slot"},{"name":"$slot","kind":13,"containerName":"want_slot","line":208},{"line":210,"containerName":"want_slot","kind":13,"name":"$ok"},{"line":210,"name":"$ok","kind":13,"containerName":"want_slot"},{"name":"$self","kind":13,"containerName":"want_slot","line":214},{"name":"get_wanted_slots","containerName":"want_slot","kind":12,"line":214},{"containerName":"want_slot","kind":13,"name":"$slot","line":215},{"line":216,"containerName":"want_slot","kind":13,"name":"$ok"},{"line":220,"kind":13,"containerName":"want_slot","name":"$ok"}],"name":"want_slot","containerName":"main::","definition":"sub","detail":"($self,$slot)"},{"line":264,"kind":12,"range":{"end":{"character":9999,"line":285},"start":{"character":0,"line":264}},"signature":{"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.","parameters":[{"label":"$self"},{"label":"$slot"},{"label":"@args"}],"label":"add_slot_value($self,$slot,@args)"},"children":[{"definition":"my","line":265,"name":"$self","kind":13,"localvar":"my","containerName":"add_slot_value"},{"name":"$slot","containerName":"add_slot_value","kind":13,"line":265},{"name":"@args","kind":13,"containerName":"add_slot_value","line":265},{"definition":"my","line":267,"localvar":"my","containerName":"add_slot_value","kind":13,"name":"$h"},{"line":267,"kind":13,"containerName":"add_slot_value","name":"$self"},{"line":268,"containerName":"add_slot_value","kind":13,"name":"$h"},{"line":270,"name":"@args","containerName":"add_slot_value","kind":13},{"kind":13,"containerName":"add_slot_value","name":"@args","line":270},{"line":270,"kind":13,"containerName":"add_slot_value","name":"$slot"},{"line":271,"containerName":"add_slot_value","kind":13,"name":"@args"},{"line":271,"name":"$slot","containerName":"add_slot_value","kind":13},{"line":272,"name":"@args","containerName":"add_slot_value","kind":13},{"definition":"my","line":273,"containerName":"add_slot_value","localvar":"my","kind":13,"name":"$key"},{"line":273,"containerName":"add_slot_value","kind":13,"name":"@args"},{"line":274,"kind":13,"containerName":"add_slot_value","name":"$h"},{"name":"$key","containerName":"add_slot_value","kind":13,"line":274},{"line":274,"containerName":"add_slot_value","kind":13,"name":"@args"},{"kind":13,"containerName":"add_slot_value","name":"$slot","line":277},{"line":278,"kind":13,"containerName":"add_slot_value","name":"$slot"},{"name":"$slot_param_map","kind":13,"containerName":"add_slot_value","line":278},{"line":278,"containerName":"add_slot_value","kind":13,"name":"$slot"},{"name":"$h","containerName":"add_slot_value","kind":13,"line":279},{"line":279,"name":"$slot","kind":13,"containerName":"add_slot_value"},{"name":"$h","containerName":"add_slot_value","kind":13,"line":279},{"kind":13,"containerName":"add_slot_value","name":"$slot","line":279},{"kind":13,"containerName":"add_slot_value","name":"$h","line":280},{"name":"$slot","kind":13,"containerName":"add_slot_value","line":280},{"line":280,"containerName":"add_slot_value","kind":13,"name":"@args"},{"line":282,"name":"$slot","containerName":"add_slot_value","kind":13},{"line":282,"kind":13,"containerName":"add_slot_value","name":"$slot"},{"line":282,"name":"$slot","kind":13,"containerName":"add_slot_value"},{"name":"$h","kind":13,"containerName":"add_slot_value","line":283},{"kind":13,"containerName":"add_slot_value","name":"$slot","line":283},{"kind":13,"containerName":"add_slot_value","name":"$args","line":283}],"containerName":"main::","name":"add_slot_value","definition":"sub","detail":"($self,$slot,@args)"},{"range":{"start":{"character":0,"line":311},"end":{"character":9999,"line":321}},"kind":12,"line":311,"name":"want_object","containerName":"main::","children":[{"line":312,"kind":13,"localvar":"my","containerName":"want_object","name":"$self","definition":"my"},{"definition":"my","name":"$ok","kind":13,"localvar":"my","containerName":"want_object","line":314},{"containerName":"want_object","localvar":"my","kind":13,"name":"$cond","line":315,"definition":"my"},{"line":315,"name":"$self","kind":13,"containerName":"want_object"},{"line":315,"containerName":"want_object","kind":12,"name":"get_object_conditions"},{"name":"$ok","containerName":"want_object","kind":13,"line":316},{"line":316,"name":"$self","kind":13,"containerName":"want_object"},{"line":317,"containerName":"want_object","kind":13,"name":"$ok"},{"line":319,"name":"$self","containerName":"want_object","kind":13},{"line":319,"name":"$ok","containerName":"want_object","kind":13},{"kind":13,"containerName":"want_object","name":"$ok","line":320}],"definition":"sub"},{"name":"cond","kind":12,"line":316},{"line":345,"range":{"start":{"line":345,"character":0},"end":{"line":349,"character":9999}},"kind":12,"definition":"sub","children":[{"line":346,"name":"$self","containerName":"make_object","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":348,"kind":13,"localvar":"my","containerName":"make_object","name":"$obj"},{"line":349,"name":"$self","containerName":"make_object","kind":13},{"name":"$self","kind":13,"containerName":"make_object","line":349}],"name":"make_object","containerName":"main::"},{"line":350,"name":"$obj","kind":13,"containerName":null},{"line":350,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"sequence_factory","line":350},{"line":350,"kind":12,"containerName":"main::","name":"create_object"},{"name":"%self","containerName":null,"kind":13,"line":350},{"containerName":null,"kind":13,"name":"%self","line":352},{"line":353,"name":"$obj","kind":13,"containerName":null},{"definition":"sub","containerName":"main::","name":"get_wanted_slots","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_wanted_slots","kind":13,"line":397},{"line":399,"containerName":"get_wanted_slots","kind":13,"name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":399},"start":{"character":0,"line":396}},"line":396},{"name":"add_wanted_slot","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"add_wanted_slot","kind":13,"line":414,"definition":"my"},{"name":"@slots","kind":13,"containerName":"add_wanted_slot","line":414},{"definition":"my","kind":13,"localvar":"my","containerName":"add_wanted_slot","name":"$myslots","line":416},{"line":416,"kind":13,"containerName":"add_wanted_slot","name":"$self"},{"definition":"my","line":417,"localvar":"my","containerName":"add_wanted_slot","kind":13,"name":"$slot"},{"name":"@slots","containerName":"add_wanted_slot","kind":13,"line":417},{"containerName":"add_wanted_slot","kind":13,"name":"$slot","line":418},{"line":418,"name":"$myslots","containerName":"add_wanted_slot","kind":13},{"name":"$myslots","kind":13,"containerName":"add_wanted_slot","line":419},{"kind":13,"containerName":"add_wanted_slot","name":"$slot","line":419}],"detail":"($self,@slots)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":423},"start":{"line":413,"character":0}},"line":413,"signature":{"parameters":[{"label":"$self"},{"label":"@slots"}],"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)","label":"add_wanted_slot($self,@slots)"}},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"remove_wanted_slots","name":"$self","line":438},{"definition":"my","name":"@slots","localvar":"my","kind":13,"containerName":"remove_wanted_slots","line":439},{"name":"$self","kind":13,"containerName":"remove_wanted_slots","line":439},{"line":439,"name":"get_wanted_slots","containerName":"remove_wanted_slots","kind":12},{"line":440,"name":"$self","containerName":"remove_wanted_slots","kind":13},{"kind":13,"containerName":"remove_wanted_slots","name":"@slots","line":441}],"name":"remove_wanted_slots","containerName":"main::","line":437,"range":{"start":{"character":0,"line":437},"end":{"character":9999,"line":442}},"kind":12},{"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"get_unwanted_slots","name":"$self","line":456,"definition":"my"},{"name":"$self","containerName":"get_unwanted_slots","kind":13,"line":458}],"name":"get_unwanted_slots","containerName":"main::","line":455,"range":{"end":{"line":458,"character":9999},"start":{"line":455,"character":0}},"kind":12},{"definition":"sub","detail":"($self,@slots)","children":[{"definition":"my","line":473,"localvar":"my","containerName":"add_unwanted_slot","kind":13,"name":"$self"},{"name":"@slots","containerName":"add_unwanted_slot","kind":13,"line":473},{"definition":"my","line":475,"kind":13,"localvar":"my","containerName":"add_unwanted_slot","name":"$myslots"},{"containerName":"add_unwanted_slot","kind":13,"name":"$self","line":475},{"line":476,"containerName":"add_unwanted_slot","localvar":"my","kind":13,"name":"$slot","definition":"my"},{"name":"@slots","containerName":"add_unwanted_slot","kind":13,"line":476},{"name":"$slot","kind":13,"containerName":"add_unwanted_slot","line":477},{"kind":13,"containerName":"add_unwanted_slot","name":"$myslots","line":477},{"name":"$myslots","containerName":"add_unwanted_slot","kind":13,"line":478},{"line":478,"name":"$slot","containerName":"add_unwanted_slot","kind":13}],"containerName":"main::","name":"add_unwanted_slot","signature":{"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_wanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'wanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_wanted_slots\n\n Title   : remove_wanted_slots\n Usage   :\n Function: Removes all wanted slots added previously through\n           add_wanted_slots().\n Example :\n Returns : the previous list of wanted slot names\n Args    : none\n\n\nsub remove_wanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_wanted_slots();\n\t$self->{'wanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 get_unwanted_slots\n\n Title   : get_unwanted_slots\n Usage   : $obj->get_unwanted_slots($newval)\n Function: Get the list of unwanted slots.\n Example : \n Returns : a list of strings\n Args    : none\n\n\nsub get_unwanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'unwanted_slots'}};\n}\n\n=head2 add_unwanted_slot\n\n Title   : add_unwanted_slot\n Usage   :\n Function: Adds the specified slots to the list of unwanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)","parameters":[{"label":"$self"},{"label":"@slots"}],"label":"add_unwanted_slot($self,@slots)"},"line":472,"range":{"end":{"character":9999,"line":482},"start":{"line":472,"character":0}},"kind":12},{"definition":"sub","name":"remove_unwanted_slots","containerName":"main::","children":[{"line":497,"name":"$self","localvar":"my","kind":13,"containerName":"remove_unwanted_slots","definition":"my"},{"line":498,"localvar":"my","containerName":"remove_unwanted_slots","kind":13,"name":"@slots","definition":"my"},{"line":498,"containerName":"remove_unwanted_slots","kind":13,"name":"$self"},{"line":498,"name":"get_unwanted_slots","containerName":"remove_unwanted_slots","kind":12},{"line":499,"name":"$self","containerName":"remove_unwanted_slots","kind":13},{"containerName":"remove_unwanted_slots","kind":13,"name":"@slots","line":500}],"kind":12,"range":{"start":{"character":0,"line":496},"end":{"line":501,"character":9999}},"line":496},{"line":521,"range":{"end":{"character":9999,"line":528},"start":{"character":0,"line":521}},"kind":12,"definition":"sub","children":[{"line":522,"localvar":"my","containerName":"want_none","kind":13,"name":"$self","definition":"my"},{"line":524,"containerName":"want_none","kind":13,"name":"$self"},{"line":524,"name":"want_all","containerName":"want_none","kind":12},{"line":525,"name":"$self","containerName":"want_none","kind":13},{"line":525,"containerName":"want_none","kind":12,"name":"remove_wanted_slots"},{"line":526,"kind":13,"containerName":"want_none","name":"$self"},{"line":526,"containerName":"want_none","kind":12,"name":"remove_unwanted_slots"}],"containerName":"main::","name":"want_none"},{"kind":12,"range":{"end":{"character":9999,"line":555},"start":{"character":0,"line":550}},"line":550,"definition":"sub","containerName":"main::","name":"want_all","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"want_all","line":551},{"containerName":"want_all","kind":13,"name":"$self","line":553},{"line":554,"name":"$self","kind":13,"containerName":"want_all"}]},{"kind":12,"range":{"start":{"character":0,"line":578},"end":{"character":9999,"line":581}},"line":578,"containerName":"main::","name":"get_object_conditions","children":[{"name":"$self","containerName":"get_object_conditions","localvar":"my","kind":13,"line":579,"definition":"my"},{"name":"$self","containerName":"get_object_conditions","kind":13,"line":581}],"definition":"sub"},{"definition":"sub","detail":"($self,@conds)","children":[{"definition":"my","line":607,"kind":13,"localvar":"my","containerName":"add_object_condition","name":"$self"},{"line":607,"containerName":"add_object_condition","kind":13,"name":"@conds"},{"containerName":"add_object_condition","kind":13,"name":"@conds","line":609},{"kind":13,"containerName":"add_object_condition","name":"$self","line":610},{"containerName":"add_object_condition","kind":12,"name":"throw","line":610},{"line":613,"kind":13,"containerName":"add_object_condition","name":"$self"}],"name":"add_object_condition","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@conds"}],"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_wanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'wanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_wanted_slots\n\n Title   : remove_wanted_slots\n Usage   :\n Function: Removes all wanted slots added previously through\n           add_wanted_slots().\n Example :\n Returns : the previous list of wanted slot names\n Args    : none\n\n\nsub remove_wanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_wanted_slots();\n\t$self->{'wanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 get_unwanted_slots\n\n Title   : get_unwanted_slots\n Usage   : $obj->get_unwanted_slots($newval)\n Function: Get the list of unwanted slots.\n Example : \n Returns : a list of strings\n Args    : none\n\n\nsub get_unwanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'unwanted_slots'}};\n}\n\n=head2 add_unwanted_slot\n\n Title   : add_unwanted_slot\n Usage   :\n Function: Adds the specified slots to the list of unwanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_unwanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'unwanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_unwanted_slots\n\n Title   : remove_unwanted_slots\n Usage   :\n Function: Removes the list of unwanted slots added previously through\n           add_unwanted_slots().\n Example :\n Returns : the previous list of unwanted slot names\n Args    : none\n\n\nsub remove_unwanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_unwanted_slots();\n\t$self->{'unwanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 want_none\n\n Title   : want_none\n Usage   :\n Function: Disables all slots. After calling this method, want_slot()\n           will return FALSE regardless of slot name.\n\n           This is different from removed_wanted_slots() in that it\n           also sets want_all() to FALSE. Note that it also resets the\n           list of unwanted slots in order to avoid slots being in\n           both lists.\n\n Example :\n Returns : TRUE\n Args    : none\n\n\nsub want_none{\n\tmy $self = shift;\n\n\t$self->want_all(0);\n\t$self->remove_wanted_slots();\n\t$self->remove_unwanted_slots();\n\treturn 1;\n}\n\n=head2 want_all\n\n Title   : want_all\n Usage   : $obj->want_all($newval)\n Function: Whether or not this sequence object builder wants to\n           populate all slots that the object has. Whether an object\n           supports a slot is generally determined by what can()\n           returns. You can add additional 'virtual' slots by calling\n           add_wanted_slot.\n\n           This will be ON by default. Call $obj->want_none() to\n           disable all slots.\n\n Example : \n Returns : TRUE if this builder wants to populate all slots, and\n           FALSE otherwise.\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub want_all{\n\tmy $self = shift;\n\n\treturn $self->{'want_all'} = shift if @_;\n\treturn $self->{'want_all'};\n}\n\n=head2 get_object_conditions\n\n Title   : get_object_conditions\n Usage   :\n Function: Get the list of conditions an object must meet in order to\n           be 'wanted.' See want_object() for where this is used.\n\n           Conditions in this implementation are closures (anonymous\n           functions) which are passed one parameter, a hash reference\n           the keys of which are equal to initialization\n           paramaters. The closure must return TRUE to make the object\n           'wanted.'\n\n           Conditions will be implicitly ANDed.\n\n Example :\n Returns : a list of closures\n Args    : none\n\n\nsub get_object_conditions{\n\tmy $self = shift;\n\n\treturn @{$self->{'object_conds'}};\n}\n\n=head2 add_object_condition\n\n Title   : add_object_condition\n Usage   :\n Function: Adds a condition an object must meet in order to be 'wanted.'\n           See want_object() for where this is used.\n\n           Conditions in this implementation must be closures\n           (anonymous functions). These will be passed one parameter,\n           which is a hash reference with the sequence object\n           initialization paramters being the keys.\n\n           Conditions are implicitly ANDed. If you want other\n           operators, perform those tests inside of one closure\n           instead of multiple.  This will also be more efficient.\n\n Example :\n Returns : TRUE\n Args    : the list of conditions","label":"add_object_condition($self,@conds)"},"line":606,"range":{"end":{"character":9999,"line":613},"start":{"character":0,"line":606}},"kind":12},{"containerName":null,"kind":13,"name":"@conds","line":613},{"children":[{"definition":"my","line":630,"containerName":"remove_object_conditions","localvar":"my","kind":13,"name":"$self"},{"line":631,"name":"@conds","kind":13,"localvar":"my","containerName":"remove_object_conditions","definition":"my"},{"kind":13,"containerName":"remove_object_conditions","name":"$self","line":631},{"containerName":"remove_object_conditions","kind":12,"name":"get_object_conditions","line":631},{"containerName":"remove_object_conditions","kind":13,"name":"$self","line":632},{"name":"@conds","containerName":"remove_object_conditions","kind":13,"line":633}],"containerName":"main::","name":"remove_object_conditions","definition":"sub","line":629,"range":{"start":{"line":629,"character":0},"end":{"line":634,"character":9999}},"kind":12},{"name":"sequence_factory","containerName":"main::","children":[{"line":654,"name":"$self","kind":13,"localvar":"my","containerName":"sequence_factory","definition":"my"},{"line":657,"kind":13,"containerName":"sequence_factory","name":"$self"},{"name":"$self","containerName":"sequence_factory","kind":13,"line":658},{"kind":13,"containerName":"sequence_factory","name":"$self","line":660}],"definition":"sub","range":{"end":{"character":9999,"line":661},"start":{"line":653,"character":0}},"kind":12,"line":653}]}