{"vars":[{"line":96,"containerName":"","kind":2,"name":"vars"},{"kind":2,"containerName":"","name":"base","line":101},{"detail":"($caller,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":121,"name":"$caller","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":121},{"line":122,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$caller","kind":13,"containerName":"new","line":122},{"line":122,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":124},{"name":"$self","containerName":"new","kind":13,"line":125},{"definition":"my","line":127,"name":"$dates","localvar":"my","kind":13,"containerName":"new"},{"line":127,"name":"$xtra","kind":13,"containerName":"new"},{"line":127,"containerName":"new","kind":13,"name":"$sv"},{"name":"$keywords","containerName":"new","kind":13,"line":128},{"name":"$pid","kind":13,"containerName":"new","line":128},{"kind":13,"containerName":"new","name":"$mol","line":128},{"line":129,"kind":13,"containerName":"new","name":"$division"},{"line":129,"name":"$self","containerName":"new","kind":13},{"name":"_rearrange","kind":12,"containerName":"new","line":129},{"name":"@args","containerName":"new","kind":13,"line":137},{"kind":13,"containerName":"new","name":"$division","line":138},{"line":138,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"division","line":138},{"kind":13,"containerName":"new","name":"$division","line":138},{"kind":13,"containerName":"new","name":"$mol","line":139},{"line":139,"kind":13,"containerName":"new","name":"$self"},{"line":139,"name":"molecule","containerName":"new","kind":12},{"line":139,"containerName":"new","kind":13,"name":"$mol"},{"kind":13,"containerName":"new","name":"$keywords","line":140},{"containerName":"new","kind":13,"name":"$keywords","line":141},{"line":141,"name":"$keywords","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":142},{"kind":12,"containerName":"new","name":"add_keyword","line":142},{"kind":13,"containerName":"new","name":"$keywords","line":142},{"kind":13,"containerName":"new","name":"$self","line":145},{"kind":12,"containerName":"new","name":"keywords","line":145},{"line":145,"name":"$keywords","kind":13,"containerName":"new"},{"line":148,"name":"$sv","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":148},{"kind":12,"containerName":"new","name":"seq_version","line":148},{"name":"$sv","containerName":"new","kind":13,"line":148},{"name":"$pid","containerName":"new","kind":13,"line":149},{"name":"$self","containerName":"new","kind":13,"line":149},{"line":149,"name":"pid","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$pid","line":149},{"name":"$dates","containerName":"new","kind":13,"line":151},{"line":152,"kind":13,"containerName":"new","name":"$dates"},{"line":153,"name":"$dates","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":154},{"line":154,"containerName":"new","kind":12,"name":"add_date"},{"line":157,"containerName":"new","kind":13,"name":"$self"},{"name":"add_date","kind":12,"containerName":"new","line":157},{"name":"$dates","kind":13,"containerName":"new","line":157},{"line":161,"name":"$xtra","kind":13,"containerName":"new"},{"name":"$xtra","kind":13,"containerName":"new","line":162},{"name":"$xtra","containerName":"new","kind":13,"line":163},{"containerName":"new","kind":13,"name":"$self","line":164},{"kind":12,"containerName":"new","name":"add_secondary_accession","line":164},{"line":167,"name":"$self","containerName":"new","kind":13},{"line":167,"name":"add_secondary_accession","containerName":"new","kind":12},{"line":167,"name":"$xtra","kind":13,"containerName":"new"},{"line":171,"name":"$self","containerName":"new","kind":13}],"signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: RichSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeq - Module implementing a sequence created from a rich\nsequence database entry\n\n=head1 SYNOPSIS\n\nSee L<Bio::Seq::RichSeqI> and documentation of methods.\n\n=head1 DESCRIPTION\n\nThis module implements Bio::Seq::RichSeqI, an interface for sequences\ncreated from or created for entries from/of rich sequence databanks,\nlike EMBL, GenBank, and SwissProt. Methods added to the Bio::SeqI\ninterface therefore focus on databank-specific information. Note that\nnot every rich databank format may use all of the properties provided.\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Seq::RichSeqI\n\nNote that this includes implementing Bio::PrimarySeqI and Bio::SeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\n\nuse base qw(Bio::Seq Bio::Seq::RichSeqI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::Seq::RichSeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                             -id  => 'human_id',\n\t\t\t\t             -accession_number => 'AL000012',\n\t\t\t\t            );\n\n Function: Returns a new seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq::RichSeq object","parameters":[{"label":"$caller"},{"label":"@args"}]},"range":{"end":{"character":9999,"line":172},"start":{"line":119,"character":0}},"kind":12,"line":119},{"containerName":"new","kind":12,"name":"SUPER","line":122},{"line":186,"range":{"start":{"line":186,"character":0},"end":{"line":194,"character":9999}},"kind":12,"children":[{"definition":"my","line":187,"kind":13,"localvar":"my","containerName":"division","name":"$obj"},{"definition":"my","localvar":"my","containerName":"division","kind":13,"name":"$value","line":189},{"name":"$obj","kind":13,"containerName":"division","line":190},{"containerName":"division","kind":13,"name":"$value","line":190},{"line":192,"name":"$obj","kind":13,"containerName":"division"}],"name":"division","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":215},"start":{"line":207,"character":0}},"line":207,"containerName":"main::","name":"molecule","children":[{"definition":"my","line":208,"localvar":"my","containerName":"molecule","kind":13,"name":"$obj"},{"definition":"my","kind":13,"localvar":"my","containerName":"molecule","name":"$value","line":210},{"line":211,"name":"$obj","kind":13,"containerName":"molecule"},{"line":211,"containerName":"molecule","kind":13,"name":"$value"},{"line":213,"name":"$obj","kind":13,"containerName":"molecule"}],"definition":"sub"},{"definition":"sub","children":[{"line":235,"kind":12,"containerName":"add_date","name":"_add_annotation_value"}],"name":"add_date","containerName":"main::","line":234,"range":{"start":{"character":0,"line":234},"end":{"line":236,"character":9999}},"kind":12},{"range":{"end":{"line":252,"character":9999},"start":{"character":0,"line":250}},"kind":12,"line":250,"name":"get_dates","containerName":"main::","children":[{"line":251,"containerName":"get_dates","kind":12,"name":"_get_annotation_values"}],"definition":"sub"},{"range":{"end":{"line":272,"character":9999},"start":{"line":267,"character":0}},"kind":12,"line":267,"definition":"sub","name":"pid","containerName":"main::","children":[{"definition":"my","line":268,"kind":13,"localvar":"my","containerName":"pid","name":"$self"},{"kind":13,"containerName":"pid","name":"$self","line":270},{"containerName":"pid","kind":13,"name":"$self","line":271}]},{"kind":12,"range":{"start":{"line":291,"character":0},"end":{"line":294,"character":9999}},"line":291,"signature":{"label":"accession($obj,@args)","parameters":[{"label":"$obj"},{"label":"@args"}],"documentation":"1;\n# $Id: RichSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeq - Module implementing a sequence created from a rich\nsequence database entry\n\n=head1 SYNOPSIS\n\nSee L<Bio::Seq::RichSeqI> and documentation of methods.\n\n=head1 DESCRIPTION\n\nThis module implements Bio::Seq::RichSeqI, an interface for sequences\ncreated from or created for entries from/of rich sequence databanks,\nlike EMBL, GenBank, and SwissProt. Methods added to the Bio::SeqI\ninterface therefore focus on databank-specific information. Note that\nnot every rich databank format may use all of the properties provided.\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Seq::RichSeqI\n\nNote that this includes implementing Bio::PrimarySeqI and Bio::SeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\n\nuse base qw(Bio::Seq Bio::Seq::RichSeqI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::Seq::RichSeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                             -id  => 'human_id',\n\t\t\t\t             -accession_number => 'AL000012',\n\t\t\t\t            );\n\n Function: Returns a new seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq::RichSeq object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    \n    $self->{'_dates'} = [];\n    $self->{'_secondary_accession'} = [];\n\n    my ($dates, $xtra, $sv,\n\t$keywords, $pid, $mol, \n\t$division ) = $self->_rearrange([qw(DATES \n\t\t\t\t\t    SECONDARY_ACCESSIONS\n\t\t\t\t\t    SEQ_VERSION \n\t\t\t\t\t    KEYWORDS\n\t\t\t\t\t    PID\n\t\t\t\t\t    MOLECULE\n\t\t\t\t\t    DIVISION\n\t\t\t\t\t    )],\n\t\t\t\t\t@args);\n    defined $division && $self->division($division);\n    defined $mol && $self->molecule($mol);\n    if(defined($keywords)) {\n\tif(ref($keywords) && (ref($keywords) eq \"ARRAY\")) {\n\t    $self->add_keyword(@$keywords);\n\t} else {\n\t    # got a string - use the old API\n\t    $self->keywords($keywords);\n\t}\n    }\n    defined $sv && $self->seq_version($sv);\n    defined $pid && $self->pid($pid);\n\n    if( defined $dates ) {\n\tif( ref($dates) eq \"ARRAY\" ) {\n\t    foreach ( @$dates) {\n\t\t$self->add_date($_);\n\t    } \n\t} else { \n\t    $self->add_date($dates);\n\t}\n    }\n\n    if( defined $xtra ) {\n\tif( ref($xtra) eq \"ARRAY\" ) {\n\t    foreach ( @$xtra) {\n\t\t$self->add_secondary_accession($_);\n\t    } \n\t} else { \n\t    $self->add_secondary_accession($xtra);\n\t}\n    }\n    \n    return $self;\n}\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: \n Returns : value of division\n Args    : newvalue (optional)\n\n\n\nsub division {\n   my $obj = shift;\n   if( @_ ) {\n      my $value = shift;\n      $obj->{'_division'} = $value;\n    }\n    return $obj->{'_division'};\n\n}\n\n=head2 molecule\n\n Title   : molecule\n Usage   : $obj->molecule($newval)\n Function: \n Returns : type of molecule (DNA, mRNA)\n Args    : newvalue (optional)\n\n\n\nsub molecule {\n   my $obj = shift;\n   if( @_ ) {\n      my $value = shift;\n      $obj->{'_molecule'} = $value;\n    }\n    return $obj->{'_molecule'};\n\n}\n\n=head2 add_date\n\n Title   : add_date\n Usage   : $self->add_date($datestr)\n Function: adds one or more dates\n\n           This implementation stores dates as keyed annotation, the\n           key being 'date_changed'. You can take advantage of this\n           fact when accessing the annotation collection directly.\n\n Example :\n Returns : \n Args    : a date string or an array of such strings\n\n\n\nsub add_date {\n    return shift->_add_annotation_value('date_changed',@_);\n}\n\n=head2 get_dates\n\n Title   : get_dates\n Usage   : my @dates = $seq->get_dates;\n Function: Get the dates of the sequence (usually, when it was created and\n           changed.\n Returns : an array of date strings\n Args    :\n\n\n\nsub get_dates{\n    return shift->_get_annotation_values('date_changed');\n}\n\n\n=head2 pid\n\n Title   : pid\n Usage   : my $pid = $seq->pid();\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Returns : a string\n Args    :\n\n\n\nsub pid{\n    my $self = shift;\n\n    return $self->{'_pid'} = shift if @_;\n    return $self->{'_pid'};\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $obj->accession($newval)\n Function: Whilst the underlying sequence object does not \n           have an accession, so we need one here.\n\n           In this implementation this is merely a synonym for\n           accession_number().\n Example : \n Returns : value of accession\n Args    : newvalue (optional)"},"containerName":"main::","name":"accession","children":[{"definition":"my","line":292,"kind":13,"localvar":"my","containerName":"accession","name":"$obj"},{"line":292,"kind":13,"containerName":"accession","name":"@args"},{"name":"$obj","kind":13,"containerName":"accession","line":293},{"line":293,"name":"accession_number","containerName":"accession","kind":12},{"name":"@args","containerName":"accession","kind":13,"line":293}],"detail":"($obj,@args)","definition":"sub"},{"name":"add_secondary_accession","containerName":"main::","children":[{"line":315,"name":"_add_annotation_value","kind":12,"containerName":"add_secondary_accession"}],"definition":"sub","range":{"start":{"character":0,"line":314},"end":{"character":9999,"line":316}},"kind":12,"line":314},{"children":[{"name":"_get_annotation_values","kind":12,"containerName":"get_secondary_accessions","line":330}],"name":"get_secondary_accessions","containerName":"main::","definition":"sub","line":329,"range":{"start":{"line":329,"character":0},"end":{"character":9999,"line":331}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":349},"start":{"line":344,"character":0}},"line":344,"definition":"sub","containerName":"main::","name":"seq_version","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"seq_version","kind":13,"line":345},{"line":347,"containerName":"seq_version","kind":13,"name":"$self"},{"kind":13,"containerName":"seq_version","name":"$self","line":348}]},{"definition":"sub","name":"add_keyword","containerName":"main::","children":[{"name":"_add_annotation_value","kind":12,"containerName":"add_keyword","line":369}],"kind":12,"range":{"start":{"character":0,"line":368},"end":{"character":9999,"line":370}},"line":368},{"line":383,"kind":12,"range":{"end":{"line":385,"character":9999},"start":{"line":383,"character":0}},"children":[{"line":384,"kind":12,"containerName":"get_keywords","name":"_get_annotation_values"}],"containerName":"main::","name":"get_keywords","definition":"sub"},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_add_annotation_value","name":"$self","line":404},{"definition":"my","line":405,"localvar":"my","kind":13,"containerName":"_add_annotation_value","name":"$key"},{"line":407,"name":"$val","localvar":"my","containerName":"_add_annotation_value","kind":13,"definition":"my"},{"line":408,"name":"$self","kind":13,"containerName":"_add_annotation_value"},{"line":408,"containerName":"_add_annotation_value","kind":12,"name":"annotation"},{"name":"add_Annotation","containerName":"_add_annotation_value","kind":12,"line":408},{"kind":12,"containerName":"_add_annotation_value","name":"new","line":409},{"containerName":"_add_annotation_value","kind":13,"name":"$key","line":409},{"containerName":"_add_annotation_value","kind":13,"name":"$val","line":410}],"name":"_add_annotation_value","containerName":"main::","definition":"sub","line":403,"kind":12,"range":{"end":{"character":9999,"line":413},"start":{"line":403,"character":0}}},{"line":409,"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue"},{"kind":12,"range":{"start":{"character":0,"line":429},"end":{"line":433,"character":9999}},"line":429,"definition":"sub","containerName":"main::","name":"_get_annotation_values","children":[{"definition":"my","line":430,"name":"$self","localvar":"my","kind":13,"containerName":"_get_annotation_values"},{"containerName":"_get_annotation_values","kind":12,"name":"value","line":432},{"line":432,"name":"$self","containerName":"_get_annotation_values","kind":13},{"name":"annotation","containerName":"_get_annotation_values","kind":12,"line":432},{"line":432,"kind":12,"containerName":"_get_annotation_values","name":"get_Annotations"}]},{"line":441,"kind":12,"range":{"start":{"line":441,"character":0},"end":{"character":9999,"line":454}},"definition":"sub","children":[{"definition":"my","line":442,"name":"$self","localvar":"my","kind":13,"containerName":"keywords"},{"name":"$kwd","containerName":"keywords","localvar":"my","kind":13,"line":447,"definition":"my"},{"name":"$self","kind":13,"containerName":"keywords","line":448},{"line":448,"name":"add_keyword","containerName":"keywords","kind":12},{"line":448,"name":"$kwd","containerName":"keywords","kind":13},{"line":452,"kind":13,"containerName":"keywords","name":"$self"},{"line":452,"name":"get_keywords","kind":12,"containerName":"keywords"}],"containerName":"main::","name":"keywords"},{"detail":"($self)","definition":"sub","name":"each_date","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"each_date","line":457,"definition":"my"},{"line":458,"containerName":"each_date","kind":13,"name":"$self"},{"line":458,"kind":12,"containerName":"each_date","name":"warn"},{"line":459,"kind":13,"containerName":"each_date","name":"$self"},{"line":459,"kind":12,"containerName":"each_date","name":"get_dates"}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"each_date($self)"},"kind":12,"range":{"start":{"line":456,"character":0},"end":{"character":9999,"line":460}},"line":456},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"each_secondary_accession($self)"},"line":463,"kind":12,"range":{"end":{"line":468,"character":9999},"start":{"line":463,"character":0}},"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"each_secondary_accession","line":464,"definition":"my"},{"line":465,"name":"$self","containerName":"each_secondary_accession","kind":13},{"line":465,"name":"warn","kind":12,"containerName":"each_secondary_accession"},{"line":466,"name":"$self","containerName":"each_secondary_accession","kind":13},{"line":466,"name":"get_secondary_accessions","kind":12,"containerName":"each_secondary_accession"}],"name":"each_secondary_accession","containerName":"main::"},{"children":[{"definition":"my","name":"$obj","kind":13,"localvar":"my","containerName":"sv","line":471},{"name":"$value","containerName":"sv","kind":13,"line":471},{"name":"$obj","kind":13,"containerName":"sv","line":472},{"line":472,"kind":12,"containerName":"sv","name":"warn"},{"line":473,"containerName":"sv","kind":13,"name":"$obj"},{"line":473,"kind":12,"containerName":"sv","name":"seq_version"},{"line":473,"name":"$value","containerName":"sv","kind":13}],"containerName":"main::","name":"sv","definition":"sub","detail":"($obj,$value)","line":470,"kind":12,"range":{"end":{"line":474,"character":9999},"start":{"line":470,"character":0}},"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"","label":"sv($obj,$value)"}}],"version":5}