{"version":5,"vars":[{"line":194,"kind":2,"containerName":"","name":"vars"},{"line":199,"name":"base","kind":2,"containerName":""},{"line":204,"name":"$DEFAULT_NAME","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$GAP","line":205},{"containerName":null,"kind":13,"name":"$META_GAP","line":206},{"kind":12,"range":{"start":{"line":225,"character":0},"end":{"line":248,"character":9999}},"line":225,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object","label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"definition":"my","line":226,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"line":226,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":228,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":13,"name":"$class","line":228},{"containerName":"new","kind":13,"name":"@args","line":228},{"definition":"my","name":"$meta","kind":13,"localvar":"my","containerName":"new","line":230},{"kind":13,"containerName":"new","name":"$forceflush","line":230},{"line":230,"containerName":"new","kind":13,"name":"$nm"},{"line":231,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_rearrange","line":231},{"containerName":"new","kind":13,"name":"@args","line":234},{"line":237,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$DEFAULT_NAME","line":237},{"name":"$meta","containerName":"new","kind":13,"line":239},{"kind":13,"containerName":"new","name":"$self","line":239},{"line":239,"name":"meta","kind":12,"containerName":"new"},{"line":239,"containerName":"new","kind":13,"name":"$meta"},{"line":240,"name":"$nm","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$nm","line":240},{"line":241,"name":"$name","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$meta","containerName":"new","kind":13,"line":241},{"name":"$nm","containerName":"new","kind":13,"line":241},{"kind":13,"containerName":"new","name":"$self","line":242},{"line":242,"containerName":"new","kind":12,"name":"named_meta"},{"name":"$name","containerName":"new","kind":13,"line":242},{"line":242,"name":"$meta","containerName":"new","kind":13},{"name":"$forceflush","kind":13,"containerName":"new","line":245},{"line":245,"name":"$self","containerName":"new","kind":13},{"line":245,"kind":12,"containerName":"new","name":"force_flush"},{"name":"$forceflush","kind":13,"containerName":"new","line":245},{"line":247,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":228,"containerName":"new","kind":12,"name":"SUPER"},{"definition":"sub","containerName":"main::","name":"meta","children":[{"name":"named_meta","kind":12,"containerName":"meta","line":270},{"line":270,"containerName":"meta","kind":13,"name":"$DEFAULT_NAME"}],"range":{"start":{"character":0,"line":269},"end":{"character":9999,"line":271}},"kind":12,"line":269},{"name":"meta_text","containerName":"main::","children":[{"line":285,"kind":12,"containerName":"meta_text","name":"meta"}],"definition":"sub","range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":286}},"kind":12,"line":284},{"name":"named_meta","containerName":"main::","children":[{"definition":"my","line":301,"localvar":"my","containerName":"named_meta","kind":13,"name":"$self"},{"containerName":"named_meta","kind":13,"name":"$name","line":301},{"name":"$value","containerName":"named_meta","kind":13,"line":301},{"containerName":"named_meta","kind":13,"name":"$name","line":303},{"name":"$DEFAULT_NAME","kind":13,"containerName":"named_meta","line":303},{"line":304,"name":"$value","containerName":"named_meta","kind":13},{"line":306,"name":"$self","kind":13,"containerName":"named_meta"},{"containerName":"named_meta","kind":12,"name":"throw","line":306},{"line":306,"name":"$value","kind":13,"containerName":"named_meta"},{"line":307,"containerName":"named_meta","kind":13,"name":"$value"},{"definition":"my","name":"$diff","containerName":"named_meta","localvar":"my","kind":13,"line":310},{"line":310,"containerName":"named_meta","kind":13,"name":"$self"},{"line":310,"containerName":"named_meta","kind":12,"name":"length"},{"line":310,"name":"$value","kind":13,"containerName":"named_meta"},{"line":311,"containerName":"named_meta","kind":13,"name":"$diff"},{"line":312,"name":"$value","kind":13,"containerName":"named_meta"},{"containerName":"named_meta","kind":13,"name":"$diff","line":312},{"kind":13,"containerName":"named_meta","name":"$self","line":315},{"name":"$name","kind":13,"containerName":"named_meta","line":315},{"line":315,"kind":13,"containerName":"named_meta","name":"$value"},{"kind":13,"containerName":"named_meta","name":"$self","line":320},{"line":320,"name":"length","containerName":"named_meta","kind":12},{"line":321,"name":"$self","kind":13,"containerName":"named_meta"},{"line":321,"kind":12,"containerName":"named_meta","name":"force_flush"},{"kind":13,"containerName":"named_meta","name":"$self","line":321},{"line":321,"name":"$name","kind":13,"containerName":"named_meta"},{"containerName":"named_meta","kind":13,"name":"$self","line":324},{"line":324,"name":"_do_flush","kind":12,"containerName":"named_meta"},{"containerName":"named_meta","kind":13,"name":"$self","line":324},{"name":"force_flush","containerName":"named_meta","kind":12,"line":324},{"line":326,"name":"$self","containerName":"named_meta","kind":13},{"containerName":"named_meta","kind":13,"name":"$name","line":326}],"detail":"($self,$name,$value)","definition":"sub","range":{"end":{"character":9999,"line":327},"start":{"character":0,"line":300}},"kind":12,"line":300,"signature":{"label":"named_meta($self,$name,$value)","documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}]}},{"line":310,"containerName":"length","kind":12,"name":"CORE"},{"definition":"sub","children":[{"definition":"my","line":348,"name":"$self","localvar":"my","containerName":"_test_gap_positions","kind":13},{"name":"$name","localvar":"my","containerName":"_test_gap_positions","kind":13,"line":349,"definition":"my"},{"line":350,"name":"$success","localvar":"my","kind":13,"containerName":"_test_gap_positions","definition":"my"},{"line":352,"name":"$self","containerName":"_test_gap_positions","kind":13},{"line":352,"containerName":"_test_gap_positions","kind":12,"name":"seq"},{"name":"$success","kind":13,"containerName":"_test_gap_positions","line":352},{"definition":"my","line":353,"name":"$len","localvar":"my","containerName":"_test_gap_positions","kind":13},{"line":353,"kind":13,"containerName":"_test_gap_positions","name":"$self"},{"name":"seq","containerName":"_test_gap_positions","kind":12,"line":353},{"name":"$i","kind":13,"localvar":"my","containerName":"_test_gap_positions","line":354,"definition":"my"},{"kind":13,"containerName":"_test_gap_positions","name":"$i","line":354},{"kind":13,"containerName":"_test_gap_positions","name":"$len","line":354},{"containerName":"_test_gap_positions","kind":13,"name":"$i","line":354},{"name":"$s","localvar":"my","kind":13,"containerName":"_test_gap_positions","line":355,"definition":"my"},{"line":355,"name":"$self","kind":13,"containerName":"_test_gap_positions"},{"line":355,"name":"$i","kind":13,"containerName":"_test_gap_positions"},{"definition":"my","name":"$m","localvar":"my","containerName":"_test_gap_positions","kind":13,"line":356},{"line":356,"name":"$self","kind":13,"containerName":"_test_gap_positions"},{"name":"$name","kind":13,"containerName":"_test_gap_positions","line":356},{"name":"$i","kind":13,"containerName":"_test_gap_positions","line":356},{"line":357,"kind":13,"containerName":"_test_gap_positions","name":"$self"},{"name":"warn","kind":12,"containerName":"_test_gap_positions","line":357},{"kind":13,"containerName":"_test_gap_positions","name":"$i","line":357},{"line":357,"name":"$self","containerName":"_test_gap_positions","kind":13},{"line":357,"name":"id","kind":12,"containerName":"_test_gap_positions"},{"line":358,"containerName":"_test_gap_positions","kind":13,"name":"$success"},{"line":359,"kind":13,"containerName":"_test_gap_positions","name":"$s"},{"containerName":"_test_gap_positions","kind":13,"name":"$META_GAP","line":359},{"line":359,"name":"$s","kind":13,"containerName":"_test_gap_positions"},{"containerName":"_test_gap_positions","kind":13,"name":"$m","line":359},{"line":361,"name":"$success","containerName":"_test_gap_positions","kind":13}],"name":"_test_gap_positions","containerName":"main::","line":347,"kind":12,"range":{"end":{"character":9999,"line":362},"start":{"character":0,"line":347}}},{"line":353,"name":"CORE","containerName":"length","kind":12},{"kind":12,"name":"seq","line":355},{"kind":12,"name":"_meta","line":356},{"definition":"sub","children":[{"name":"named_meta","containerName":"named_meta_text","kind":12,"line":378}],"name":"named_meta_text","containerName":"main::","line":377,"range":{"start":{"character":0,"line":377},"end":{"line":379,"character":9999}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":411},"start":{"character":0,"line":409}},"line":409,"definition":"sub","name":"submeta","containerName":"main::","children":[{"name":"named_submeta","kind":12,"containerName":"submeta","line":410},{"line":410,"name":"$DEFAULT_NAME","containerName":"submeta","kind":13}]},{"kind":12,"range":{"end":{"character":9999,"line":427},"start":{"character":0,"line":425}},"line":425,"name":"submeta_text","containerName":"main::","children":[{"line":426,"kind":12,"containerName":"submeta_text","name":"submeta"}],"definition":"sub"},{"range":{"end":{"character":9999,"line":486},"start":{"character":0,"line":444}},"kind":12,"line":444,"signature":{"label":"named_submeta($self,$name,$start,$end,$value)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$start"},{"label":"$end"},{"label":"$value"}],"documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional"},"containerName":"main::","name":"named_submeta","children":[{"definition":"my","line":445,"localvar":"my","kind":13,"containerName":"named_submeta","name":"$self"},{"name":"$name","containerName":"named_submeta","kind":13,"line":445},{"line":445,"containerName":"named_submeta","kind":13,"name":"$start"},{"containerName":"named_submeta","kind":13,"name":"$end","line":445},{"line":445,"kind":13,"containerName":"named_submeta","name":"$value"},{"line":447,"containerName":"named_submeta","kind":13,"name":"$name"},{"line":447,"name":"$DEFAULT_NAME","kind":13,"containerName":"named_submeta"},{"line":448,"kind":13,"containerName":"named_submeta","name":"$start"},{"line":451,"name":"$start","containerName":"named_submeta","kind":13},{"line":451,"containerName":"named_submeta","kind":13,"name":"$start"},{"name":"$self","kind":13,"containerName":"named_submeta","line":452},{"line":452,"name":"throw","containerName":"named_submeta","kind":12},{"line":454,"kind":13,"containerName":"named_submeta","name":"$value"},{"kind":13,"containerName":"named_submeta","name":"$end","line":455},{"name":"$start","kind":13,"containerName":"named_submeta","line":455},{"name":"$value","kind":13,"containerName":"named_submeta","line":455},{"line":456,"name":"$self","kind":13,"containerName":"named_submeta"},{"containerName":"named_submeta","kind":12,"name":"warn","line":456},{"line":457,"kind":13,"containerName":"named_submeta","name":"$self"},{"line":457,"kind":12,"containerName":"named_submeta","name":"seq"},{"containerName":"named_submeta","kind":13,"name":"$self","line":457},{"line":457,"containerName":"named_submeta","kind":12,"name":"id"},{"line":458,"name":"$start","kind":13,"containerName":"named_submeta"},{"containerName":"named_submeta","kind":13,"name":"$self","line":458},{"line":458,"kind":12,"containerName":"named_submeta","name":"seq"},{"name":"$self","containerName":"named_submeta","kind":13,"line":461},{"line":461,"name":"$name","containerName":"named_submeta","kind":13},{"containerName":"named_submeta","kind":13,"name":"$self","line":461},{"kind":13,"containerName":"named_submeta","name":"$name","line":461},{"line":462,"kind":13,"containerName":"named_submeta","name":"$self"},{"name":"$name","kind":13,"containerName":"named_submeta","line":462},{"line":462,"kind":13,"containerName":"named_submeta","name":"$start"},{"line":463,"name":"$self","containerName":"named_submeta","kind":13},{"kind":13,"containerName":"named_submeta","name":"$name","line":463},{"name":"$start","kind":13,"containerName":"named_submeta","line":463},{"line":463,"containerName":"named_submeta","kind":13,"name":"$self"},{"line":463,"containerName":"named_submeta","kind":13,"name":"$name"},{"line":466,"name":"$tail","localvar":"my","kind":13,"containerName":"named_submeta","definition":"my"},{"kind":13,"containerName":"named_submeta","name":"$tail","line":467},{"line":467,"containerName":"named_submeta","kind":13,"name":"$self"},{"line":467,"containerName":"named_submeta","kind":13,"name":"$name"},{"line":467,"kind":13,"containerName":"named_submeta","name":"$start"},{"line":467,"name":"$value","containerName":"named_submeta","kind":13},{"line":468,"containerName":"named_submeta","kind":13,"name":"$self"},{"kind":13,"containerName":"named_submeta","name":"$name","line":468},{"line":468,"name":"$start","kind":13,"containerName":"named_submeta"},{"kind":13,"containerName":"named_submeta","name":"$value","line":468},{"name":"$self","kind":13,"containerName":"named_submeta","line":470},{"line":470,"name":"$name","containerName":"named_submeta","kind":13},{"line":470,"containerName":"named_submeta","kind":13,"name":"$start"},{"name":"$value","containerName":"named_submeta","kind":13,"line":470},{"name":"$self","containerName":"named_submeta","kind":13,"line":471},{"name":"$name","containerName":"named_submeta","kind":13,"line":471},{"line":471,"name":"$tail","kind":13,"containerName":"named_submeta"},{"name":"$self","kind":13,"containerName":"named_submeta","line":473},{"line":473,"kind":13,"containerName":"named_submeta","name":"$name"},{"line":473,"name":"$start","containerName":"named_submeta","kind":13},{"line":473,"containerName":"named_submeta","kind":13,"name":"$end"},{"line":473,"kind":13,"containerName":"named_submeta","name":"$start"},{"line":477,"containerName":"named_submeta","kind":13,"name":"$end"},{"line":477,"containerName":"named_submeta","kind":13,"name":"$end"},{"name":"$self","containerName":"named_submeta","kind":13,"line":477},{"line":477,"kind":12,"containerName":"named_submeta","name":"seq"},{"line":480,"name":"$self","containerName":"named_submeta","kind":13},{"line":480,"name":"$name","kind":13,"containerName":"named_submeta"},{"line":480,"kind":13,"containerName":"named_submeta","name":"$end"},{"line":481,"name":"$self","kind":13,"containerName":"named_submeta"},{"line":481,"name":"$name","containerName":"named_submeta","kind":13},{"name":"$start","containerName":"named_submeta","kind":13,"line":481},{"kind":13,"containerName":"named_submeta","name":"$self","line":481},{"line":481,"name":"$name","kind":13,"containerName":"named_submeta"},{"name":"$self","containerName":"named_submeta","kind":13,"line":484},{"containerName":"named_submeta","kind":13,"name":"$name","line":484},{"line":484,"kind":13,"containerName":"named_submeta","name":"$start"},{"line":484,"containerName":"named_submeta","kind":13,"name":"$end"},{"name":"$start","kind":13,"containerName":"named_submeta","line":484}],"detail":"($self,$name,$start,$end,$value)","definition":"sub"},{"line":461,"kind":12,"name":"_meta"},{"kind":12,"name":"_meta","line":461},{"name":"_meta","kind":12,"line":462},{"name":"_meta","kind":12,"line":467},{"kind":12,"name":"_meta","line":468},{"line":470,"name":"_meta","kind":12},{"kind":12,"name":"_meta","line":471},{"line":473,"kind":12,"name":"_meta"},{"kind":12,"name":"_meta","line":480},{"line":484,"name":"_meta","kind":12},{"line":503,"kind":12,"range":{"start":{"line":503,"character":0},"end":{"character":9999,"line":505}},"children":[{"name":"named_submeta","kind":12,"containerName":"named_submeta_text","line":504}],"containerName":"main::","name":"named_submeta_text","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"meta_names","localvar":"my","kind":13,"line":519,"definition":"my"},{"name":"@r","containerName":"meta_names","localvar":"my","kind":13,"line":521,"definition":"my"},{"kind":13,"containerName":"meta_names","name":"$self","line":522}],"name":"meta_names","containerName":"main::","signature":{"label":"meta_names($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none"},"line":518,"kind":12,"range":{"start":{"line":518,"character":0},"end":{"line":522,"character":9999}}},{"name":"@r","kind":13,"containerName":null,"line":523},{"line":523,"kind":13,"containerName":null,"name":"$DEFAULT_NAME"},{"line":525,"containerName":null,"kind":13,"name":"@r"},{"kind":13,"containerName":null,"name":"$DEFAULT_NAME","line":525},{"kind":13,"containerName":null,"name":"%self","line":525},{"containerName":null,"kind":13,"name":"$DEFAULT_NAME","line":525},{"line":526,"name":"@r","containerName":null,"kind":13},{"containerName":"main::","name":"meta_length","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"meta_length","name":"$self","line":541},{"line":542,"kind":13,"containerName":"meta_length","name":"$self"},{"name":"named_meta_length","kind":12,"containerName":"meta_length","line":542},{"line":542,"name":"$DEFAULT_NAME","kind":13,"containerName":"meta_length"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":543,"character":9999},"start":{"character":0,"line":540}},"line":540,"signature":{"label":"meta_length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meeta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -"}},{"signature":{"label":"named_meta_length($self,$name)","documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meeta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -","parameters":[{"label":"$self"},{"label":"$name"}]},"line":556,"kind":12,"range":{"start":{"character":0,"line":556},"end":{"character":9999,"line":560}},"definition":"sub","detail":"($self,$name)","children":[{"line":557,"name":"$self","localvar":"my","containerName":"named_meta_length","kind":13,"definition":"my"},{"line":557,"containerName":"named_meta_length","kind":13,"name":"$name"},{"line":558,"name":"$name","kind":13,"containerName":"named_meta_length"},{"containerName":"named_meta_length","kind":13,"name":"$DEFAULT_NAME","line":558},{"name":"$self","kind":13,"containerName":"named_meta_length","line":559},{"name":"$name","kind":13,"containerName":"named_meta_length","line":559}],"containerName":"main::","name":"named_meta_length"},{"kind":12,"range":{"end":{"line":589,"character":9999},"start":{"line":577,"character":0}},"line":577,"signature":{"label":"force_flush($self,$value)","documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meeta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return length ($self->{'_meta'}->{$name});\n}\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","name":"force_flush","children":[{"definition":"my","containerName":"force_flush","localvar":"my","kind":13,"name":"$self","line":578},{"line":578,"kind":13,"containerName":"force_flush","name":"$value"},{"name":"$value","containerName":"force_flush","kind":13,"line":580},{"kind":13,"containerName":"force_flush","name":"$value","line":581},{"name":"$self","containerName":"force_flush","kind":13,"line":582},{"line":583,"kind":13,"containerName":"force_flush","name":"$self"},{"line":583,"name":"_do_flush","containerName":"force_flush","kind":12},{"containerName":"force_flush","kind":13,"name":"$self","line":585},{"name":"$self","containerName":"force_flush","kind":13,"line":588}],"detail":"($self,$value)","definition":"sub"},{"line":582,"name":"force_flush","kind":12},{"line":585,"name":"force_flush","kind":12},{"line":588,"name":"force_flush","kind":12},{"line":604,"range":{"start":{"character":0,"line":604},"end":{"character":9999,"line":619}},"kind":12,"signature":{"documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meeta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return length ($self->{'_meta'}->{$name});\n}\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same \n           length as the sequence . Called from L<force_flush>\n Returns : \n Args    : ","parameters":[{"label":"$self"}],"label":"_do_flush($self)"},"children":[{"name":"$self","containerName":"_do_flush","localvar":"my","kind":13,"line":605,"definition":"my"},{"line":607,"localvar":"my","kind":13,"containerName":"_do_flush","name":"$name","definition":"my"},{"name":"$self","kind":13,"containerName":"_do_flush","line":607},{"line":607,"name":"meta_names","kind":12,"containerName":"_do_flush"},{"line":610,"kind":13,"containerName":"_do_flush","name":"$self"},{"line":610,"name":"length","containerName":"_do_flush","kind":12},{"line":610,"containerName":"_do_flush","kind":13,"name":"$self"},{"name":"named_meta_length","containerName":"_do_flush","kind":12,"line":610},{"line":610,"kind":13,"containerName":"_do_flush","name":"$name"},{"kind":13,"containerName":"_do_flush","name":"$self","line":611},{"name":"$name","containerName":"_do_flush","kind":13,"line":611},{"name":"$META_GAP","kind":13,"containerName":"_do_flush","line":611},{"name":"$self","containerName":"_do_flush","kind":13,"line":611},{"line":611,"kind":12,"containerName":"_do_flush","name":"length"},{"line":611,"containerName":"_do_flush","kind":13,"name":"$self"},{"name":"named_meta_length","kind":12,"containerName":"_do_flush","line":611},{"line":611,"kind":13,"containerName":"_do_flush","name":"$name"},{"name":"$self","containerName":"_do_flush","kind":13,"line":614},{"line":614,"name":"length","containerName":"_do_flush","kind":12},{"line":614,"name":"$self","kind":13,"containerName":"_do_flush"},{"line":614,"containerName":"_do_flush","kind":12,"name":"named_meta_length"},{"line":614,"kind":13,"containerName":"_do_flush","name":"$name"},{"line":615,"kind":13,"containerName":"_do_flush","name":"$self"},{"line":615,"name":"$name","containerName":"_do_flush","kind":13},{"kind":13,"containerName":"_do_flush","name":"$self","line":615},{"name":"$name","kind":13,"containerName":"_do_flush","line":615},{"containerName":"_do_flush","kind":13,"name":"$self","line":615},{"line":615,"containerName":"_do_flush","kind":12,"name":"length"}],"name":"_do_flush","containerName":"main::","definition":"sub","detail":"($self)"},{"line":615,"kind":12,"name":"_meta"},{"line":615,"name":"_meta","kind":12},{"children":[{"line":639,"kind":13,"localvar":"my","containerName":"is_flush","name":"$self","definition":"my"},{"line":639,"name":"$name","containerName":"is_flush","kind":13},{"line":641,"name":"$self","kind":13,"containerName":"is_flush"},{"line":641,"containerName":"is_flush","kind":12,"name":"force_flush"},{"definition":"my","line":643,"name":"$sticky","localvar":"my","containerName":"is_flush","kind":13},{"line":646,"name":"$name","containerName":"is_flush","kind":13},{"name":"$sticky","containerName":"is_flush","kind":13,"line":647},{"containerName":"is_flush","kind":13,"name":"$self","line":647},{"name":"length","containerName":"is_flush","kind":12,"line":647},{"line":647,"containerName":"is_flush","kind":13,"name":"$self"},{"containerName":"is_flush","kind":12,"name":"named_meta_length","line":647},{"line":647,"name":"$name","containerName":"is_flush","kind":13},{"definition":"my","localvar":"my","containerName":"is_flush","kind":13,"name":"$m","line":649},{"kind":13,"containerName":"is_flush","name":"$self","line":649},{"containerName":"is_flush","kind":12,"name":"meta_names","line":649},{"name":"$sticky","kind":13,"containerName":"is_flush","line":650},{"name":"$self","kind":13,"containerName":"is_flush","line":650},{"kind":12,"containerName":"is_flush","name":"length","line":650},{"name":"$self","containerName":"is_flush","kind":13,"line":650},{"line":650,"name":"named_meta_length","kind":12,"containerName":"is_flush"},{"kind":13,"containerName":"is_flush","name":"$m","line":650},{"line":654,"name":"$sticky","containerName":"is_flush","kind":13},{"line":655,"containerName":"is_flush","kind":13,"name":"$self"},{"line":655,"name":"verbose","containerName":"is_flush","kind":12}],"containerName":"main::","name":"is_flush","definition":"sub","line":637,"range":{"start":{"line":637,"character":0},"end":{"line":660,"character":9999}},"kind":12},{"children":[{"definition":"my","containerName":"revcom","localvar":"my","kind":13,"name":"$self","line":680},{"line":682,"kind":13,"containerName":"revcom","name":"$self"},{"containerName":"revcom","kind":12,"name":"throw","line":682},{"line":683,"kind":13,"containerName":"revcom","name":"$self"},{"line":683,"kind":12,"containerName":"revcom","name":"is_flush"},{"name":"$new","localvar":"my","kind":13,"containerName":"revcom","line":685,"definition":"my"},{"name":"$self","containerName":"revcom","kind":13,"line":685},{"name":"$self","kind":13,"containerName":"revcom","line":686}],"containerName":"main::","name":"revcom","definition":"sub","line":679,"range":{"start":{"character":0,"line":679},"end":{"line":686,"character":9999}},"kind":12},{"name":"SUPER","containerName":"revcom","kind":12,"line":686},{"line":686,"name":"_meta","kind":12},{"name":"$new","containerName":null,"kind":13,"line":687},{"line":687,"kind":12,"containerName":"main::","name":"named_meta"},{"line":687,"containerName":null,"kind":13,"name":"%self"},{"line":687,"kind":12,"name":"_meta"},{"line":689,"kind":13,"containerName":null,"name":"$new"},{"name":"trunc","containerName":"main::","children":[{"containerName":"trunc","localvar":"my","kind":13,"name":"$self","line":703,"definition":"my"},{"containerName":"trunc","kind":13,"name":"$start","line":703},{"kind":13,"containerName":"trunc","name":"$end","line":703},{"name":"$start","kind":13,"containerName":"trunc","line":706},{"kind":13,"containerName":"trunc","name":"$start","line":706},{"name":"$self","containerName":"trunc","kind":13,"line":707},{"kind":12,"containerName":"trunc","name":"throw","line":707},{"line":708,"kind":13,"containerName":"trunc","name":"$end"},{"name":"$end","containerName":"trunc","kind":13,"line":708},{"line":709,"name":"$self","containerName":"trunc","kind":13},{"kind":12,"containerName":"trunc","name":"throw","line":709},{"name":"$end","kind":13,"containerName":"trunc","line":710},{"line":710,"name":"$start","kind":13,"containerName":"trunc"},{"name":"$self","containerName":"trunc","kind":13,"line":711},{"name":"throw","kind":12,"containerName":"trunc","line":711},{"line":712,"name":"$end","kind":13,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$self","line":712},{"kind":12,"containerName":"trunc","name":"length","line":712},{"kind":13,"containerName":"trunc","name":"$self","line":713},{"line":713,"name":"throw","containerName":"trunc","kind":12},{"containerName":"trunc","localvar":"my","kind":13,"name":"$new","line":715,"definition":"my"},{"name":"$self","containerName":"trunc","kind":13,"line":715},{"line":715,"kind":13,"containerName":"trunc","name":"$start"},{"name":"$end","kind":13,"containerName":"trunc","line":715},{"line":716,"name":"$start","kind":13,"containerName":"trunc"},{"name":"$self","kind":13,"containerName":"trunc","line":717}],"detail":"($self,$start,$end)","definition":"sub","kind":12,"range":{"start":{"line":702,"character":0},"end":{"line":717,"character":9999}},"line":702,"signature":{"label":"trunc($self,$start,$end)","documentation":"1;\n# $Id: Meta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta - Generic superclass for sequence objects with\nresidue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta;\n  use Bio::Tools::OddCodes;\n  use Bio::SeqIO;\n\n  my $seq = Bio::Seq::Meta->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -end=>2443,\n                                   -strand=>1,\n                                   -verbose=>1, # to see warnings\n                                  );\n\n  # the existing sequence object can be a Bio::PrimarySeq, too\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta\");\n\n\n  $seq->meta('1234567890');\n  $seq = Bio::Seq::Meta->new(-id=>'test',\n                             -seq=>'HACILMIFGT',\n                             -start=>2434,\n                             -end=>2443,\n                             -strand=>1,\n                             -meta=>'1234567890',\n                             -verbose=>1, # to see warnings\n                            );\n\n  # accessors\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n  # storing output from Bio::Tools::OddCodes as meta data\n  my $protcodes = Bio::Tools::OddCodes->new(-seq => $seq);\n  my @codes = qw(structural chemical functional charge hydrophobic);\n  map { $seq->named_meta($_, ${$protcodes->$_($seq) } )} @codes;\n\n  my $out = Bio::SeqIO->new(-format=>'metafasta');\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class is always one character per residue\nlong and blank values are space characters (ASCII 32).\n\nAfter the latest rewrite, the meta information no longer covers all\nthe residues automatically. Methods to check the length of meta\ninformation (L<meta_length>)and to see if the ends are flushed to the\nsequence have been added (L<is_flush>). To force the old\nfunctionality, set L<force_flush> to true.\n\nIt is assumed that meta data values do not depend on the nucleotide\nsequence strand value.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nL<Bio::Seq::Meta::Array> allows for more complex meta values (scalars\nor objects) to be used.\n\n=head2 Method naming\n\nCharacter based meta data is read and set by method meta() and its\nvariants. These are the suffixes and prefixes used in the variants:\n\n    [named_] [sub] meta [_text]\n\n=over 3\n\n* _text\n\nSuffix B<_text> guaranties that output is a string. Note that it does\nnot limit the input.\n\nIn this implementation, the output is always text, so these methods\nare redundant.\n\n* sub\n\nPrefix B<sub>, like in subseq(), means that the method applies to sub\nregion of the sequence range and takes start and end as arguments.\nUnlike subseq(), these methods are able to set values.  If the range\nis not defined, it defaults to the complete sequence.\n\n* named\n\nPrefix B<named_> in method names allows the used to attach multiple\nmeta strings to one sequence by explicitly naming them. The name is\nalways the first argument to the method. The \"unnamed\" methods use the\nclass wide default name for the meta data and are thus special cases\n\"named\" methods.\n\nNote that internally names are keys in a hash and any misspelling of a\nname will silently store the data under a wrong name. The used names\n(keys) can be retrieved using method meta_names(). See L<meta_names>.\n\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>, \nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\n\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq::MetaI);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $forceflush, $nm) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              NAMED_META)],\n                          @args);\n\n    #$self->{'_meta'} = {};\n    $self->{'_meta'}->{$DEFAULT_NAME} = \"\";\n\n    $meta && $self->meta($meta);\n    if ($nm && ref($nm) eq 'HASH') {\n        while (my ($name, $meta) = each %$nm) {\n            $self->named_meta($name, $meta);\n        }\n    }\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence, if force_flush() is set. See L<force_flush>.\n\n Returns : meta data in a string\n Args    : new value, string, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub meta_text {\n    shift->meta(shift);\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n   if( defined $value) {\n\n       $self->throw(\"I need a scalar value, not [\". ref($value). \"]\")\n\t   if ref($value);\n\n       # test for length\n       my $diff = $self->length - CORE::length($value);\n       if ($diff > 0) {\n           $value .= (\" \" x $diff);\n       }\n\n       $self->{'_meta'}->{$name} = $value;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   return \" \" x $self->length \n    if $self->force_flush && not defined $self->{'_meta'}->{$name};\n\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name};\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch [$m/$s] in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($s eq $META_GAP) && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, optional\n\n\nsub named_meta_text {\n    shift->named_meta(@_);\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implementation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual \n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\n\nsub submeta_text {\n    shift->submeta(@_);\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n\n\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n\n    if ($value) {\n        $end ||= $start+length($value)-1;\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start > length $self->seq;\n\n        # pad meta data if needed\n        $self->{_meta}->{$name} = () unless defined $self->{_meta}->{$name};\n        if (length($self->{_meta}->{$name}) < $start) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}) -1);\n        }\n\n        my $tail = '';\n        $tail = substr ($self->{_meta}->{$name}, $start-1+length($value))\n            if length($self->{_meta}->{$name}) >= $start-1+length($value);\n        \n        substr ($self->{_meta}->{$name}, --$start) = $value;\n        $self->{_meta}->{$name} .= $tail;\n\n        return substr ($self->{_meta}->{$name}, $start, $end - $start + 1);\n\n    } else {\n\n        $end or $end = length $self->seq;\n\n        # pad meta data if needed\n        if (length($self->{_meta}->{$name}) < $end) {\n            $self->{'_meta'}->{$name} .=  \" \" x ( $start - length($self->{'_meta'}->{$name}));\n        }\n\n        return substr ($self->{_meta}->{$name}, $start-1, $end - $start + 1)\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, optional\n\n\nsub named_submeta_text {\n    shift->named_submeta(@_);\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrieves an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meeta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return length ($self->{'_meta'}->{$name});\n}\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same \n           length as the sequence . Called from L<force_flush>\n Returns : \n Args    : \n\n\n\nsub _do_flush {\n    my ($self) = @_;\n\n    foreach my $name ( ('DEFAULT', $self->meta_names) ) {\n\n        # elongnation\n        if ($self->length > $self->named_meta_length($name)) {\n            $self->{'_meta'}->{$name} .= $META_GAP x ($self->length - $self->named_meta_length($name)) ;\n        }\n        # truncation\n        elsif ( $self->length < $self->named_meta_length($name) ) {\n            $self->{_meta}->{$name} = substr($self->{_meta}->{$name}, 0, $self->length-1);\n        }\n    }\n\n}\n\n\n=head2 is_flush\n\n Title   : is_flush\n Usage   : $is_flush  = $obj->is_flush()\n           or  $is_flush = $obj->is_flush($my_meta_name)\n Function: Boolean to tell if all meta values are in\n           flush with the sequence length.\n           Returns true if force_flush() is set\n           Set verbosity to a positive value to see failed meta sets\n Returns : boolean 1 or 0\n Args    : optional name of the meta set\n\n\n\nsub is_flush {\n\n    my ($self, $name) = shift;\n\n    return 1 if $self->force_flush;\n\n    my $sticky = '';\n\n\n    if ($name) {\n        $sticky .= \"$name \" if $self->length != $self->named_meta_length($name);\n    } else {\n        foreach my $m ($self->meta_names) {\n            $sticky .= \"$m \" if $self->length != $self->named_meta_length($m);\n        }\n    }\n\n    if ($sticky) {\n        print \"These meta set are not flush: $sticky\\n\" if $self->verbose; \n        return 0;\n    }\n\n    return 1;\n}\n\n\n=head1 Bio::PrimarySeqI methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $newseq = $seq->revcom();\n Function: Produces a new Bio::Seq::MetaI implementing object where\n           the order of residues and their meta information is reversed.\n Returns : A new (fresh) Bio::Seq::Meta object\n Args    : none\n Throws  : if the object returns false on is_flush()\n\nNote: The method does nothing to meta values, it reorders them, only.\n\n\nsub revcom {\n    my $self = shift;\n\n    $self->throw(\"Can not get a reverse complement. The object is not flush.\")\n        unless $self->is_flush;\n\n    my $new = $self->SUPER::revcom;\n    foreach (keys %{$self->{_meta}}) {\n        $new->named_meta($_, scalar reverse $self->{_meta}->{$_} );\n    };\n    return $new;\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $seq->trunc(10,100);\n Function: Provides a truncation of a sequence together with meta data\n Returns : a fresh Bio::Seq::Meta implementing object\n Args    : Two integers denoting first and last residue of the sub-sequence.","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]}},{"line":715,"name":"SUPER","containerName":"trunc","kind":12},{"name":"_meta","kind":12,"line":717},{"name":"$new","kind":13,"containerName":null,"line":718},{"line":718,"name":"named_meta","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%self","line":719},{"kind":12,"name":"_meta","line":719},{"line":719,"name":"$start","kind":13,"containerName":null},{"line":719,"name":"$end","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$start","line":719},{"line":722,"name":"$new","containerName":null,"kind":13},{"range":{"end":{"line":731,"character":9999},"start":{"line":726,"character":0}},"kind":12,"line":726,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"to_string($self)"},"containerName":"main::","name":"to_string","children":[{"line":727,"name":"$self","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"definition":"my","line":728,"containerName":"to_string","localvar":"my","kind":13,"name":"$out"},{"containerName":"to_string","kind":12,"name":"new","line":728},{"containerName":"to_string","kind":13,"name":"$out","line":729},{"kind":12,"containerName":"to_string","name":"write_seq","line":729},{"line":729,"name":"$self","kind":13,"containerName":"to_string"}],"detail":"($self)","definition":"sub"},{"line":728,"name":"Bio","kind":12,"containerName":"SeqIO"}]}