{"version":5,"vars":[{"line":85,"kind":2,"containerName":"","name":"vars"},{"name":"base","containerName":"","kind":2,"line":89},{"line":91,"range":{"start":{"character":0,"line":91},"end":{"line":113,"character":9999}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"%params"}],"label":"new($class,%params)"},"children":[{"definition":"my","line":92,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"%params","line":92},{"kind":13,"localvar":"my","containerName":"new","name":"$seq","line":97,"definition":"my"},{"line":97,"name":"$params","kind":13,"containerName":"new"},{"line":97,"containerName":"new","kind":13,"name":"$params"},{"line":98,"kind":13,"containerName":"new","name":"$seq"},{"containerName":"new","kind":13,"name":"$params","line":99},{"line":100,"kind":13,"containerName":"new","name":"$params"},{"line":102,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":102},{"line":102,"name":"%params","kind":13,"containerName":"new"},{"line":103,"name":"$self","containerName":"new","kind":13},{"line":103,"name":"_initialize_io","kind":12,"containerName":"new"},{"line":103,"containerName":"new","kind":13,"name":"%params"},{"containerName":"new","localvar":"my","kind":13,"name":"$tempdir","line":104,"definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":104},{"line":104,"kind":12,"containerName":"new","name":"tempdir"},{"definition":"my","line":105,"localvar":"my","containerName":"new","kind":13,"name":"$tfh"},{"line":105,"name":"$file","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":105},{"kind":12,"containerName":"new","name":"tempfile","line":105},{"line":105,"name":"$tempdir","containerName":"new","kind":13},{"line":106,"name":"$self","kind":13,"containerName":"new"},{"line":106,"name":"$tempdir","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$tfh","line":107},{"name":"$self","kind":13,"containerName":"new","line":107},{"line":107,"containerName":"new","kind":12,"name":"_fh"},{"line":107,"name":"$tfh","containerName":"new","kind":13},{"line":108,"name":"$file","kind":13,"containerName":"new"},{"line":108,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_filename","line":108},{"line":108,"name":"$file","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":109},{"line":109,"containerName":"new","kind":12,"name":"length"},{"line":110,"name":"$seq","kind":13,"containerName":"new"},{"line":110,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"seq","line":110},{"containerName":"new","kind":13,"name":"$seq","line":110},{"line":112,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,%params)"},{"kind":12,"containerName":"new","name":"SUPER","line":102},{"name":"CLEANUP","kind":12,"line":104},{"kind":12,"name":"DIR","line":105},{"name":"tempdir","kind":12,"line":106},{"signature":{"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"length($obj,$value)"},"kind":12,"range":{"start":{"character":0,"line":128},"end":{"line":134,"character":9999}},"line":128,"detail":"($obj,$value)","definition":"sub","containerName":"main::","name":"length","children":[{"name":"$obj","kind":13,"localvar":"my","containerName":"length","line":129,"definition":"my"},{"containerName":"length","kind":13,"name":"$value","line":129},{"name":"$value","containerName":"length","kind":13,"line":130},{"kind":13,"containerName":"length","name":"$obj","line":131},{"line":131,"name":"$value","containerName":"length","kind":13},{"line":133,"name":"$obj","containerName":"length","kind":13},{"line":133,"kind":13,"containerName":"length","name":"$obj"}]},{"line":148,"range":{"end":{"line":158,"character":9999},"start":{"line":148,"character":0}},"kind":12,"signature":{"label":"seq($self,$data)","documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$data"}]},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"seq","line":149,"definition":"my"},{"line":149,"containerName":"seq","kind":13,"name":"$data"},{"line":150,"kind":13,"containerName":"seq","name":"$data"},{"name":"$self","kind":13,"containerName":"seq","line":151},{"containerName":"seq","kind":12,"name":"length","line":151},{"line":152,"name":"$self","kind":13,"containerName":"seq"},{"line":152,"containerName":"seq","kind":12,"name":"add_sequence_as_string"},{"line":152,"name":"$data","kind":13,"containerName":"seq"},{"line":154,"containerName":"seq","kind":13,"name":"$self"},{"line":154,"containerName":"seq","kind":12,"name":"warn"},{"containerName":"seq","kind":13,"name":"$self","line":157},{"name":"subseq","kind":12,"containerName":"seq","line":157},{"kind":13,"containerName":"seq","name":"$self","line":157},{"line":157,"containerName":"seq","kind":12,"name":"length"}],"containerName":"main::","name":"seq","definition":"sub","detail":"($self,$data)"},{"name":"subseq","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"subseq","name":"$self","line":173},{"line":173,"name":"$start","containerName":"subseq","kind":13},{"line":173,"name":"$end","containerName":"subseq","kind":13},{"line":174,"name":"$string","localvar":"my","kind":13,"containerName":"subseq","definition":"my"},{"definition":"my","containerName":"subseq","localvar":"my","kind":13,"name":"$fh","line":175},{"name":"$self","containerName":"subseq","kind":13,"line":175},{"name":"_fh","containerName":"subseq","kind":12,"line":175},{"name":"$start","kind":13,"containerName":"subseq","line":177},{"containerName":"subseq","kind":13,"name":"$start","line":177},{"line":177,"kind":12,"containerName":"subseq","name":"isa"},{"line":178,"localvar":"my","containerName":"subseq","kind":13,"name":"$loc","definition":"my"},{"line":178,"name":"$start","containerName":"subseq","kind":13},{"containerName":"subseq","kind":13,"name":"$loc","line":179},{"line":179,"name":"length","containerName":"subseq","kind":12},{"line":180,"name":"$self","kind":13,"containerName":"subseq"},{"line":180,"kind":12,"containerName":"subseq","name":"warn"},{"line":182,"name":"$loc","kind":13,"containerName":"subseq"},{"line":182,"name":"end","kind":12,"containerName":"subseq"},{"containerName":"subseq","kind":13,"name":"$loc","line":182},{"containerName":"subseq","kind":12,"name":"start","line":182},{"line":184,"kind":13,"containerName":"subseq","name":"$self"},{"name":"warn","kind":12,"containerName":"subseq","line":184},{"definition":"my","line":186,"name":"$seq","kind":13,"localvar":"my","containerName":"subseq"},{"line":187,"name":"$loc","kind":13,"containerName":"subseq"},{"containerName":"subseq","kind":12,"name":"isa","line":187},{"definition":"my","name":"$subloc","containerName":"subseq","localvar":"my","kind":13,"line":188},{"line":188,"containerName":"subseq","kind":13,"name":"$loc"},{"name":"sub_Location","containerName":"subseq","kind":12,"line":188},{"line":189,"containerName":"subseq","kind":13,"name":"$fh"},{"name":"$subloc","kind":13,"containerName":"subseq","line":189},{"kind":12,"containerName":"subseq","name":"start","line":189},{"line":190,"name":"$self","containerName":"subseq","kind":13},{"kind":12,"containerName":"subseq","name":"throw","line":190},{"line":192,"name":"$ret","localvar":"my","kind":13,"containerName":"subseq","definition":"my"},{"name":"$fh","kind":13,"containerName":"subseq","line":192},{"kind":13,"containerName":"subseq","name":"$string","line":192},{"containerName":"subseq","kind":13,"name":"$subloc","line":192},{"line":192,"kind":12,"containerName":"subseq","name":"length"},{"name":"$ret","kind":13,"containerName":"subseq","line":193},{"kind":13,"containerName":"subseq","name":"$self","line":194},{"name":"throw","kind":12,"containerName":"subseq","line":194},{"kind":13,"containerName":"subseq","name":"$subloc","line":196},{"line":196,"name":"strand","kind":12,"containerName":"subseq"},{"name":"$string","containerName":"subseq","kind":13,"line":197},{"line":197,"name":"new","containerName":"subseq","kind":12},{"line":197,"kind":13,"containerName":"subseq","name":"$string"},{"name":"revcom","kind":12,"containerName":"subseq","line":197},{"containerName":"subseq","kind":12,"name":"seq","line":197},{"name":"$seq","kind":13,"containerName":"subseq","line":199},{"line":199,"containerName":"subseq","kind":13,"name":"$string"},{"name":"$fh","kind":13,"containerName":"subseq","line":202},{"name":"$loc","kind":13,"containerName":"subseq","line":202},{"line":202,"name":"start","kind":12,"containerName":"subseq"},{"line":203,"containerName":"subseq","kind":13,"name":"$self"},{"name":"throw","containerName":"subseq","kind":12,"line":203},{"line":203,"name":"$loc","containerName":"subseq","kind":13},{"line":203,"kind":12,"containerName":"subseq","name":"start"},{"kind":13,"containerName":"subseq","name":"$loc","line":204},{"name":"end","containerName":"subseq","kind":12,"line":204},{"containerName":"subseq","localvar":"my","kind":13,"name":"$ret","line":206,"definition":"my"},{"line":206,"name":"$fh","containerName":"subseq","kind":13},{"line":206,"containerName":"subseq","kind":13,"name":"$string"},{"line":206,"name":"$loc","kind":13,"containerName":"subseq"},{"line":206,"name":"length","containerName":"subseq","kind":12},{"containerName":"subseq","kind":13,"name":"$ret","line":207},{"kind":13,"containerName":"subseq","name":"$self","line":208},{"line":208,"containerName":"subseq","kind":12,"name":"throw"},{"name":"$loc","kind":13,"containerName":"subseq","line":208},{"line":208,"containerName":"subseq","kind":12,"name":"start"},{"line":209,"name":"$loc","containerName":"subseq","kind":13},{"containerName":"subseq","kind":12,"name":"end","line":209},{"line":211,"name":"$seq","containerName":"subseq","kind":13},{"name":"$string","containerName":"subseq","kind":13,"line":211},{"name":"$loc","kind":13,"containerName":"subseq","line":213},{"kind":12,"containerName":"subseq","name":"strand","line":213},{"line":214,"kind":13,"containerName":"subseq","name":"$loc"},{"name":"strand","kind":12,"containerName":"subseq","line":214},{"line":215,"name":"$seq","containerName":"subseq","kind":13},{"line":215,"name":"new","kind":12,"containerName":"subseq"},{"name":"$seq","kind":13,"containerName":"subseq","line":215},{"line":215,"name":"revcom","kind":12,"containerName":"subseq"},{"kind":12,"containerName":"subseq","name":"seq","line":215},{"name":"$seq","kind":13,"containerName":"subseq","line":217},{"line":219,"name":"$start","containerName":"subseq","kind":13},{"line":219,"containerName":"subseq","kind":13,"name":"$end"},{"name":"$self","kind":13,"containerName":"subseq","line":219},{"name":"length","containerName":"subseq","kind":12,"line":219},{"name":"$self","containerName":"subseq","kind":13,"line":220},{"name":"throw","containerName":"subseq","kind":12,"line":220},{"line":221,"name":"$self","kind":13,"containerName":"subseq"},{"name":"length","kind":12,"containerName":"subseq","line":221},{"containerName":"subseq","kind":13,"name":"$end","line":223},{"line":223,"kind":13,"containerName":"subseq","name":"$start"},{"kind":13,"containerName":"subseq","name":"$self","line":224},{"line":224,"name":"throw","containerName":"subseq","kind":12},{"kind":13,"containerName":"subseq","name":"$fh","line":227},{"name":"$start","kind":13,"containerName":"subseq","line":227},{"name":"$self","containerName":"subseq","kind":13,"line":228},{"line":228,"name":"throw","kind":12,"containerName":"subseq"},{"definition":"my","line":230,"kind":13,"localvar":"my","containerName":"subseq","name":"$ret"},{"line":230,"kind":13,"containerName":"subseq","name":"$fh"},{"kind":13,"containerName":"subseq","name":"$string","line":230},{"name":"$end","kind":13,"containerName":"subseq","line":230},{"containerName":"subseq","kind":13,"name":"$start","line":230},{"containerName":"subseq","kind":13,"name":"$ret","line":231},{"line":232,"containerName":"subseq","kind":13,"name":"$self"},{"kind":12,"containerName":"subseq","name":"throw","line":232},{"line":234,"kind":13,"containerName":"subseq","name":"$string"}],"detail":"($self,$start,$end)","definition":"sub","range":{"start":{"character":0,"line":172},"end":{"character":9999,"line":235}},"kind":12,"line":172,"signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"subseq($self,$start,$end)"}},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":197},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":215},{"detail":"($self,$str)","definition":"sub","containerName":"main::","name":"add_sequence_as_string","children":[{"containerName":"add_sequence_as_string","localvar":"my","kind":13,"name":"$self","line":250,"definition":"my"},{"kind":13,"containerName":"add_sequence_as_string","name":"$str","line":250},{"definition":"my","line":251,"kind":13,"localvar":"my","containerName":"add_sequence_as_string","name":"$len"},{"name":"$self","containerName":"add_sequence_as_string","kind":13,"line":251},{"containerName":"add_sequence_as_string","kind":12,"name":"length","line":251},{"line":251,"containerName":"add_sequence_as_string","kind":13,"name":"$str"},{"name":"$fh","containerName":"add_sequence_as_string","localvar":"my","kind":13,"line":252,"definition":"my"},{"name":"$self","containerName":"add_sequence_as_string","kind":13,"line":252},{"containerName":"add_sequence_as_string","kind":12,"name":"_fh","line":252},{"kind":13,"containerName":"add_sequence_as_string","name":"$fh","line":253},{"containerName":"add_sequence_as_string","kind":13,"name":"$self","line":254},{"name":"throw","kind":12,"containerName":"add_sequence_as_string","line":254},{"containerName":"add_sequence_as_string","kind":13,"name":"$self","line":256},{"line":256,"containerName":"add_sequence_as_string","kind":12,"name":"_print"},{"line":256,"name":"$str","containerName":"add_sequence_as_string","kind":13},{"containerName":"add_sequence_as_string","kind":13,"name":"$self","line":257},{"line":257,"name":"length","containerName":"add_sequence_as_string","kind":12},{"line":257,"kind":13,"containerName":"add_sequence_as_string","name":"$len"}],"signature":{"label":"add_sequence_as_string($self,$str)","parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append"},"kind":12,"range":{"start":{"line":249,"character":0},"end":{"character":9999,"line":258}},"line":249},{"line":251,"kind":12,"containerName":"length","name":"CORE"},{"line":273,"kind":12,"range":{"end":{"line":280,"character":9999},"start":{"character":0,"line":273}},"signature":{"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function: \n Example : \n Returns : value of _filename\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"_filename($obj,$value)"},"children":[{"name":"$obj","localvar":"my","kind":13,"containerName":"_filename","line":274,"definition":"my"},{"containerName":"_filename","kind":13,"name":"$value","line":274},{"line":275,"name":"$value","kind":13,"containerName":"_filename"},{"line":276,"containerName":"_filename","kind":13,"name":"$obj"},{"kind":13,"containerName":"_filename","name":"$value","line":276},{"line":278,"containerName":"_filename","kind":13,"name":"$obj"}],"name":"_filename","containerName":"main::","definition":"sub","detail":"($obj,$value)"},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":296,"kind":13,"localvar":"my","containerName":"alphabet","name":"$self"},{"containerName":"alphabet","kind":13,"name":"$value","line":296},{"name":"$value","containerName":"alphabet","kind":13,"line":297},{"name":"$self","kind":13,"containerName":"alphabet","line":298},{"line":298,"name":"$value","kind":13,"containerName":"alphabet"},{"name":"$self","containerName":"alphabet","kind":13,"line":300}],"containerName":"main::","name":"alphabet","signature":{"label":"alphabet($self,$value)","documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function: \n Example : \n Returns : value of _filename\n Args    : newvalue (optional)\n\n\n\nsub _filename{\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'_filename'} = $value;\n    }\n    return $obj->{'_filename'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet($newval)\n Function: \n Example : \n Returns : value of alphabet\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":295,"kind":12,"range":{"start":{"line":295,"character":0},"end":{"character":9999,"line":302}}},{"name":"SUPER","kind":12,"containerName":"alphabet","line":298},{"name":"SUPER","kind":12,"containerName":"alphabet","line":300},{"line":304,"kind":12,"range":{"start":{"line":304,"character":0},"end":{"line":313,"character":9999}},"children":[{"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","line":305,"definition":"my"},{"line":306,"name":"$fh","localvar":"my","kind":13,"containerName":"DESTROY","definition":"my"},{"name":"$self","kind":13,"containerName":"DESTROY","line":306},{"line":306,"containerName":"DESTROY","kind":12,"name":"_fh"},{"kind":13,"containerName":"DESTROY","name":"$fh","line":307},{"line":307,"name":"$fh","kind":13,"containerName":"DESTROY"},{"containerName":"DESTROY","kind":13,"name":"$self","line":309},{"name":"_filename","kind":12,"containerName":"DESTROY","line":309},{"name":"$self","containerName":"DESTROY","kind":13,"line":309},{"name":"_filename","kind":12,"containerName":"DESTROY","line":309},{"line":309,"name":"$self","kind":13,"containerName":"DESTROY"},{"containerName":"DESTROY","kind":12,"name":"_filename","line":309},{"line":311,"kind":13,"containerName":"DESTROY","name":"$self"},{"line":311,"name":"$self","kind":13,"containerName":"DESTROY"},{"line":311,"containerName":"DESTROY","kind":13,"name":"$self"},{"containerName":"DESTROY","kind":13,"name":"$self","line":312}],"name":"DESTROY","containerName":"main::","definition":"sub"},{"name":"tempdir","kind":12,"line":311},{"kind":12,"name":"tempdir","line":311},{"line":311,"kind":12,"name":"tempdir"},{"containerName":"DESTROY","kind":12,"name":"SUPER","line":312}]}