{"version":5,"vars":[{"line":95,"containerName":"","kind":2,"name":"vars"},{"line":99,"name":"base","kind":2,"containerName":""},{"detail":"($class,%params)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":114,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"name":"%params","containerName":"new","kind":13,"line":114},{"definition":"my","line":119,"kind":13,"localvar":"my","containerName":"new","name":"$seq"},{"containerName":"new","kind":13,"name":"$params","line":119},{"name":"$params","kind":13,"containerName":"new","line":119},{"containerName":"new","kind":13,"name":"$seq","line":120},{"line":121,"name":"$params","containerName":"new","kind":13},{"name":"$params","kind":13,"containerName":"new","line":122},{"line":124,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":124,"name":"$class","containerName":"new","kind":13},{"line":124,"name":"%params","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$mapping","line":125},{"name":"$params","containerName":"new","kind":13,"line":125},{"name":"$params","containerName":"new","kind":13,"line":125},{"name":"$self","containerName":"new","kind":13,"line":126},{"line":126,"name":"mapping","kind":12,"containerName":"new"},{"line":126,"kind":13,"containerName":"new","name":"$mapping"},{"line":127,"name":"$self","kind":13,"containerName":"new"},{"name":"_initialize_io","containerName":"new","kind":12,"line":127},{"name":"%params","kind":13,"containerName":"new","line":127},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$tempdir","line":128},{"kind":13,"containerName":"new","name":"$self","line":128},{"kind":12,"containerName":"new","name":"tempdir","line":128},{"line":129,"name":"$tfh","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":129,"containerName":"new","kind":13,"name":"$file"},{"line":129,"name":"$self","containerName":"new","kind":13},{"line":129,"name":"tempfile","containerName":"new","kind":12},{"name":"$tempdir","kind":13,"containerName":"new","line":129},{"line":131,"containerName":"new","kind":13,"name":"$tfh"},{"line":131,"name":"$self","containerName":"new","kind":13},{"name":"_fh","kind":12,"containerName":"new","line":131},{"line":131,"kind":13,"containerName":"new","name":"$tfh"},{"line":132,"kind":13,"containerName":"new","name":"$file"},{"line":132,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_filename","line":132},{"line":132,"containerName":"new","kind":13,"name":"$file"},{"name":"$self","containerName":"new","kind":13,"line":133},{"kind":12,"containerName":"new","name":"length","line":133},{"line":134,"name":"$seq","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":134},{"name":"seq","kind":12,"containerName":"new","line":134},{"line":134,"containerName":"new","kind":13,"name":"$seq"},{"line":136,"name":"$self","kind":13,"containerName":"new"}],"signature":{"label":"new($class,%params)","parameters":[{"label":"$class"},{"label":"%params"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :"},"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":113}},"kind":12,"line":113},{"kind":12,"containerName":"new","name":"SUPER","line":124},{"kind":12,"name":"CLEANUP","line":128},{"name":"DIR","kind":12,"line":129},{"detail":"($obj,$value)","definition":"sub","containerName":"main::","name":"length","children":[{"definition":"my","name":"$obj","localvar":"my","containerName":"length","kind":13,"line":153},{"containerName":"length","kind":13,"name":"$value","line":153},{"kind":13,"containerName":"length","name":"$value","line":154},{"kind":13,"containerName":"length","name":"$obj","line":155},{"name":"$value","kind":13,"containerName":"length","line":155},{"line":158,"kind":13,"containerName":"length","name":"$obj"},{"line":158,"kind":13,"containerName":"length","name":"$obj"}],"signature":{"label":"length($obj,$value)","documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$obj"},{"label":"$value"}]},"kind":12,"range":{"start":{"line":152,"character":0},"end":{"character":9999,"line":159}},"line":152},{"signature":{"label":"seq($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"kind":12,"range":{"start":{"character":0,"line":173},"end":{"line":183,"character":9999}},"line":173,"detail":"($self,$data)","definition":"sub","name":"seq","containerName":"main::","children":[{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"$self","line":174},{"kind":13,"containerName":"seq","name":"$data","line":174},{"kind":13,"containerName":"seq","name":"$data","line":175},{"kind":13,"containerName":"seq","name":"$self","line":176},{"name":"length","kind":12,"containerName":"seq","line":176},{"name":"$self","containerName":"seq","kind":13,"line":177},{"line":177,"name":"add_sequence_as_string","kind":12,"containerName":"seq"},{"kind":13,"containerName":"seq","name":"$data","line":177},{"name":"$self","containerName":"seq","kind":13,"line":179},{"line":179,"name":"warn","containerName":"seq","kind":12},{"containerName":"seq","kind":13,"name":"$self","line":182},{"containerName":"seq","kind":12,"name":"subseq","line":182},{"containerName":"seq","kind":13,"name":"$self","line":182},{"line":182,"kind":12,"containerName":"seq","name":"length"}]},{"kind":12,"range":{"start":{"character":0,"line":198},"end":{"character":9999,"line":263}},"line":198,"signature":{"label":"subseq($self,$start,$end)","documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]},"containerName":"main::","name":"subseq","children":[{"definition":"my","line":199,"localvar":"my","kind":13,"containerName":"subseq","name":"$self"},{"name":"$start","containerName":"subseq","kind":13,"line":199},{"line":199,"kind":13,"containerName":"subseq","name":"$end"},{"definition":"my","localvar":"my","containerName":"subseq","kind":13,"name":"$string","line":200},{"name":"$fh","localvar":"my","kind":13,"containerName":"subseq","line":201,"definition":"my"},{"containerName":"subseq","kind":13,"name":"$self","line":201},{"name":"_fh","kind":12,"containerName":"subseq","line":201},{"line":203,"name":"$start","kind":13,"containerName":"subseq"},{"containerName":"subseq","kind":13,"name":"$start","line":203},{"name":"isa","containerName":"subseq","kind":12,"line":203},{"localvar":"my","kind":13,"containerName":"subseq","name":"$loc","line":204,"definition":"my"},{"line":204,"name":"$start","kind":13,"containerName":"subseq"},{"line":205,"name":"$loc","kind":13,"containerName":"subseq"},{"line":205,"name":"length","containerName":"subseq","kind":12},{"containerName":"subseq","kind":13,"name":"$self","line":206},{"containerName":"subseq","kind":12,"name":"warn","line":206},{"containerName":"subseq","kind":13,"name":"$loc","line":208},{"name":"end","kind":12,"containerName":"subseq","line":208},{"name":"$loc","kind":13,"containerName":"subseq","line":208},{"line":208,"kind":12,"containerName":"subseq","name":"start"},{"line":210,"kind":13,"containerName":"subseq","name":"$self"},{"line":210,"name":"warn","kind":12,"containerName":"subseq"},{"definition":"my","line":212,"kind":13,"localvar":"my","containerName":"subseq","name":"$seq"},{"name":"$loc","containerName":"subseq","kind":13,"line":213},{"line":213,"name":"isa","kind":12,"containerName":"subseq"},{"definition":"my","name":"$subloc","localvar":"my","kind":13,"containerName":"subseq","line":214},{"name":"$loc","kind":13,"containerName":"subseq","line":214},{"line":214,"containerName":"subseq","kind":12,"name":"sub_Location"},{"kind":13,"containerName":"subseq","name":"$fh","line":215},{"line":215,"kind":13,"containerName":"subseq","name":"$subloc"},{"name":"start","kind":12,"containerName":"subseq","line":215},{"name":"$self","kind":13,"containerName":"subseq","line":216},{"line":216,"kind":12,"containerName":"subseq","name":"throw"},{"definition":"my","name":"$ret","localvar":"my","containerName":"subseq","kind":13,"line":218},{"line":218,"name":"$fh","containerName":"subseq","kind":13},{"kind":13,"containerName":"subseq","name":"$string","line":218},{"line":218,"name":"$subloc","kind":13,"containerName":"subseq"},{"line":218,"name":"length","containerName":"subseq","kind":12},{"line":219,"name":"$ret","kind":13,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$self","line":220},{"line":220,"containerName":"subseq","kind":12,"name":"throw"},{"containerName":"subseq","kind":13,"name":"$subloc","line":222},{"containerName":"subseq","kind":12,"name":"strand","line":222},{"line":224,"kind":13,"containerName":"subseq","name":"$string"},{"containerName":"subseq","kind":12,"name":"new","line":224},{"name":"$string","containerName":"subseq","kind":13,"line":224},{"line":224,"containerName":"subseq","kind":12,"name":"revcom"},{"name":"seq","containerName":"subseq","kind":12,"line":224},{"name":"$seq","kind":13,"containerName":"subseq","line":226},{"name":"$string","kind":13,"containerName":"subseq","line":226},{"line":229,"containerName":"subseq","kind":13,"name":"$fh"},{"name":"$loc","kind":13,"containerName":"subseq","line":229},{"name":"start","containerName":"subseq","kind":12,"line":229},{"kind":13,"containerName":"subseq","name":"$self","line":230},{"line":230,"name":"throw","containerName":"subseq","kind":12},{"line":230,"name":"$loc","kind":13,"containerName":"subseq"},{"kind":12,"containerName":"subseq","name":"start","line":230},{"line":231,"name":"$loc","kind":13,"containerName":"subseq"},{"kind":12,"containerName":"subseq","name":"end","line":231},{"localvar":"my","kind":13,"containerName":"subseq","name":"$ret","line":233,"definition":"my"},{"line":233,"containerName":"subseq","kind":13,"name":"$fh"},{"name":"$string","kind":13,"containerName":"subseq","line":233},{"containerName":"subseq","kind":13,"name":"$loc","line":233},{"line":233,"name":"length","containerName":"subseq","kind":12},{"kind":13,"containerName":"subseq","name":"$ret","line":234},{"name":"$self","kind":13,"containerName":"subseq","line":235},{"containerName":"subseq","kind":12,"name":"throw","line":235},{"line":235,"name":"$loc","containerName":"subseq","kind":13},{"kind":12,"containerName":"subseq","name":"start","line":235},{"containerName":"subseq","kind":13,"name":"$loc","line":236},{"line":236,"name":"end","kind":12,"containerName":"subseq"},{"line":238,"name":"$seq","kind":13,"containerName":"subseq"},{"line":238,"name":"$string","containerName":"subseq","kind":13},{"name":"$loc","containerName":"subseq","kind":13,"line":240},{"line":240,"name":"strand","containerName":"subseq","kind":12},{"line":241,"name":"$loc","containerName":"subseq","kind":13},{"name":"strand","kind":12,"containerName":"subseq","line":241},{"line":243,"name":"$seq","kind":13,"containerName":"subseq"},{"line":243,"kind":12,"containerName":"subseq","name":"new"},{"name":"$seq","kind":13,"containerName":"subseq","line":243},{"line":243,"kind":12,"containerName":"subseq","name":"revcom"},{"kind":12,"containerName":"subseq","name":"seq","line":243},{"name":"$seq","containerName":"subseq","kind":13,"line":245},{"line":247,"kind":13,"containerName":"subseq","name":"$start"},{"line":247,"kind":13,"containerName":"subseq","name":"$end"},{"name":"$self","containerName":"subseq","kind":13,"line":247},{"line":247,"name":"length","kind":12,"containerName":"subseq"},{"line":248,"containerName":"subseq","kind":13,"name":"$self"},{"line":248,"name":"throw","kind":12,"containerName":"subseq"},{"line":249,"kind":13,"containerName":"subseq","name":"$self"},{"line":249,"name":"length","kind":12,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$end","line":251},{"name":"$start","kind":13,"containerName":"subseq","line":251},{"line":252,"name":"$self","containerName":"subseq","kind":13},{"containerName":"subseq","kind":12,"name":"throw","line":252},{"line":255,"name":"$fh","containerName":"subseq","kind":13},{"line":255,"name":"$start","kind":13,"containerName":"subseq"},{"name":"$self","kind":13,"containerName":"subseq","line":256},{"name":"throw","containerName":"subseq","kind":12,"line":256},{"line":258,"kind":13,"localvar":"my","containerName":"subseq","name":"$ret","definition":"my"},{"line":258,"name":"$fh","containerName":"subseq","kind":13},{"name":"$string","containerName":"subseq","kind":13,"line":258},{"containerName":"subseq","kind":13,"name":"$end","line":258},{"line":258,"name":"$start","kind":13,"containerName":"subseq"},{"line":259,"kind":13,"containerName":"subseq","name":"$ret"},{"line":260,"name":"$self","containerName":"subseq","kind":13},{"name":"throw","containerName":"subseq","kind":12,"line":260},{"name":"$string","containerName":"subseq","kind":13,"line":262}],"detail":"($self,$start,$end)","definition":"sub"},{"line":224,"kind":12,"containerName":"Seq::LargePrimarySeq","name":"Bio"},{"line":243,"name":"Bio","kind":12,"containerName":"Seq::LargePrimarySeq"},{"definition":"sub","detail":"($self,$str)","children":[{"definition":"my","line":279,"name":"$self","localvar":"my","kind":13,"containerName":"add_sequence_as_string"},{"name":"$str","kind":13,"containerName":"add_sequence_as_string","line":279},{"name":"$len","kind":13,"localvar":"my","containerName":"add_sequence_as_string","line":280,"definition":"my"},{"line":280,"kind":13,"containerName":"add_sequence_as_string","name":"$self"},{"kind":12,"containerName":"add_sequence_as_string","name":"length","line":280},{"line":280,"containerName":"add_sequence_as_string","kind":13,"name":"$str"},{"line":281,"name":"$fh","localvar":"my","kind":13,"containerName":"add_sequence_as_string","definition":"my"},{"line":281,"containerName":"add_sequence_as_string","kind":13,"name":"$self"},{"name":"_fh","kind":12,"containerName":"add_sequence_as_string","line":281},{"name":"$fh","kind":13,"containerName":"add_sequence_as_string","line":282},{"line":283,"name":"$self","containerName":"add_sequence_as_string","kind":13},{"name":"throw","containerName":"add_sequence_as_string","kind":12,"line":283},{"name":"$self","kind":13,"containerName":"add_sequence_as_string","line":285},{"line":285,"containerName":"add_sequence_as_string","kind":12,"name":"_print"},{"kind":13,"containerName":"add_sequence_as_string","name":"$str","line":285},{"line":286,"name":"$self","kind":13,"containerName":"add_sequence_as_string"},{"name":"length","containerName":"add_sequence_as_string","kind":12,"line":286},{"line":286,"name":"$len","containerName":"add_sequence_as_string","kind":13}],"containerName":"main::","name":"add_sequence_as_string","signature":{"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append","parameters":[{"label":"$self"},{"label":"$str"}],"label":"add_sequence_as_string($self,$str)"},"line":278,"kind":12,"range":{"start":{"line":278,"character":0},"end":{"line":287,"character":9999}}},{"line":280,"name":"CORE","containerName":"length","kind":12},{"children":[{"kind":13,"localvar":"my","containerName":"_filename","name":"$obj","line":303,"definition":"my"},{"name":"$value","kind":13,"containerName":"_filename","line":303},{"line":304,"name":"$value","kind":13,"containerName":"_filename"},{"kind":13,"containerName":"_filename","name":"$obj","line":305},{"line":305,"containerName":"_filename","kind":13,"name":"$value"},{"name":"$obj","containerName":"_filename","kind":13,"line":307}],"containerName":"main::","name":"_filename","definition":"sub","detail":"($obj,$value)","line":302,"range":{"start":{"line":302,"character":0},"end":{"line":309,"character":9999}},"kind":12,"signature":{"label":"_filename($obj,$value)","documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function:\n Example :\n Returns : value of _filename\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}]}},{"children":[{"definition":"my","line":325,"containerName":"alphabet","localvar":"my","kind":13,"name":"$self"},{"line":325,"name":"$value","kind":13,"containerName":"alphabet"},{"name":"$value","containerName":"alphabet","kind":13,"line":326},{"line":327,"kind":13,"containerName":"alphabet","name":"$self"},{"name":"$value","containerName":"alphabet","kind":13,"line":327},{"line":329,"name":"$self","containerName":"alphabet","kind":13}],"containerName":"main::","name":"alphabet","definition":"sub","detail":"($self,$value)","line":324,"kind":12,"range":{"end":{"line":331,"character":9999},"start":{"character":0,"line":324}},"signature":{"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function:\n Example :\n Returns : value of _filename\n Args    : newvalue (optional)\n\n\n\nsub _filename{\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'_filename'} = $value;\n    }\n    return $obj->{'_filename'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet($newval)\n Function:\n Example :\n Returns : value of alphabet\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"alphabet($self,$value)"}},{"line":327,"containerName":"alphabet","kind":12,"name":"SUPER"},{"line":329,"kind":12,"containerName":"alphabet","name":"SUPER"},{"range":{"end":{"line":340,"character":9999},"start":{"character":0,"line":333}},"kind":12,"line":333,"name":"DESTROY","containerName":"main::","children":[{"containerName":"DESTROY","localvar":"my","kind":13,"name":"$self","line":334,"definition":"my"},{"line":335,"name":"$fh","localvar":"my","kind":13,"containerName":"DESTROY","definition":"my"},{"kind":13,"containerName":"DESTROY","name":"$self","line":335},{"line":335,"kind":12,"containerName":"DESTROY","name":"_fh"},{"name":"$fh","kind":13,"containerName":"DESTROY","line":336},{"line":336,"name":"$fh","kind":13,"containerName":"DESTROY"},{"line":338,"name":"$self","containerName":"DESTROY","kind":13},{"line":338,"name":"_filename","containerName":"DESTROY","kind":12},{"line":338,"name":"$self","kind":13,"containerName":"DESTROY"},{"name":"_filename","kind":12,"containerName":"DESTROY","line":338},{"line":338,"name":"$self","kind":13,"containerName":"DESTROY"},{"line":338,"kind":12,"containerName":"DESTROY","name":"_filename"},{"kind":13,"containerName":"DESTROY","name":"$self","line":339}],"definition":"sub"},{"line":339,"containerName":"DESTROY","kind":12,"name":"SUPER"}]}