{"version":5,"vars":[{"line":78,"name":"vars","kind":2,"containerName":""},{"line":83,"name":"base","containerName":"","kind":2},{"kind":13,"containerName":null,"name":"%MODEMAP","line":85},{"containerName":null,"kind":13,"name":"%MAPPING","line":89},{"line":119,"name":"$DEFAULT_WRITER_CLASS","containerName":null,"kind":13},{"kind":12,"range":{"end":{"character":9999,"line":171},"start":{"line":136,"character":0}},"line":136,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object","label":"_initialize($self,@args)"},"containerName":"main::","name":"_initialize","children":[{"definition":"my","line":137,"name":"$self","localvar":"my","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"@args","line":137},{"containerName":"_initialize","localvar":"my","kind":13,"name":"$wisetype","line":138,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"$file","line":138},{"line":138,"name":"$fh","kind":13,"containerName":"_initialize"},{"line":139,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":139},{"line":139,"kind":13,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","localvar":"my","kind":13,"name":"@newargs","line":140,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":141},{"definition":"my","line":142,"containerName":"_initialize","localvar":"my","kind":13,"name":"$a"},{"kind":13,"containerName":"_initialize","name":"@args","line":142},{"line":143,"name":"$a","kind":13,"containerName":"_initialize"},{"line":144,"name":"@args","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"@newargs","line":147},{"line":147,"kind":13,"containerName":"_initialize","name":"$a"},{"containerName":"_initialize","kind":13,"name":"@args","line":147},{"line":149,"name":"$self","containerName":"_initialize","kind":13},{"name":"@newargs","containerName":"_initialize","kind":13,"line":149},{"line":153,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":153},{"containerName":"_initialize","kind":12,"name":"_eventHandler","line":153},{"containerName":"_initialize","kind":13,"name":"$self","line":155},{"kind":12,"containerName":"_initialize","name":"wisetype","line":155},{"line":155,"name":"$wisetype","kind":13,"containerName":"_initialize"},{"line":156,"name":"@ioargs","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"line":157,"containerName":"_initialize","kind":13,"name":"$fh"},{"line":158,"name":"@ioargs","containerName":"_initialize","kind":13},{"line":158,"kind":13,"containerName":"_initialize","name":"$fh"},{"line":159,"kind":13,"containerName":"_initialize","name":"$file"},{"line":160,"kind":13,"containerName":"_initialize","name":"@ioargs"},{"line":160,"kind":13,"containerName":"_initialize","name":"$file"},{"line":163,"name":"$wisetype","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":164},{"kind":12,"containerName":"_initialize","name":"wise","line":164},{"line":164,"kind":12,"containerName":"_initialize","name":"new"},{"line":164,"name":"@ioargs","containerName":"_initialize","kind":13},{"line":165,"name":"$wisetype","containerName":"_initialize","kind":13},{"line":166,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"wise","kind":12,"containerName":"_initialize","line":166},{"name":"new","kind":12,"containerName":"_initialize","line":166},{"name":"@ioargs","kind":13,"containerName":"_initialize","line":166},{"name":"$self","kind":13,"containerName":"_initialize","line":168},{"containerName":"_initialize","kind":12,"name":"throw","line":168},{"line":168,"name":"$self","kind":13,"containerName":"_initialize"},{"line":170,"containerName":"_initialize","kind":13,"name":"$self"}],"detail":"($self,@args)","definition":"sub"},{"containerName":"Bio::Tools::Genewise::Bio::Tools","kind":2,"name":"Genomewise","line":137},{"name":"SUPER","kind":12,"containerName":"_initialize","line":149},{"line":164,"name":"Bio","kind":12,"containerName":"Tools::Genewise"},{"name":"Bio","kind":12,"containerName":"Tools::Genomewise","line":166},{"containerName":"main::","name":"next_result","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$self","line":185},{"name":"$self","kind":13,"containerName":"next_result","line":189},{"name":"wise","containerName":"next_result","kind":12,"line":189},{"name":"$prediction","localvar":"my","kind":13,"containerName":"next_result","line":190,"definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":190},{"line":190,"name":"wise","containerName":"next_result","kind":12},{"kind":12,"containerName":"next_result","name":"next_prediction","line":190},{"name":"$prediction","containerName":"next_result","kind":13,"line":191},{"kind":13,"containerName":"next_result","name":"$self","line":192},{"line":192,"kind":13,"containerName":"next_result","name":"$self"},{"line":192,"name":"wisetype","kind":12,"containerName":"next_result"},{"line":193,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"start_element","line":193},{"kind":13,"containerName":"next_result","name":"$self","line":194},{"line":194,"name":"element","containerName":"next_result","kind":12},{"line":195,"name":"$self","containerName":"next_result","kind":13},{"line":195,"kind":12,"containerName":"next_result","name":"wisetype"},{"kind":13,"containerName":"next_result","name":"$self","line":196},{"name":"element","kind":12,"containerName":"next_result","line":196},{"line":197,"containerName":"next_result","kind":13,"name":"$self"},{"line":197,"kind":12,"containerName":"next_result","name":"wise"},{"kind":12,"containerName":"next_result","name":"_prot_id","line":197},{"line":198,"localvar":"my","containerName":"next_result","kind":13,"name":"@transcripts","definition":"my"},{"name":"$prediction","kind":13,"containerName":"next_result","line":198},{"containerName":"next_result","kind":12,"name":"transcripts","line":198},{"line":200,"name":"$transcript","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"name":"@transcripts","kind":13,"containerName":"next_result","line":200},{"line":201,"localvar":"my","containerName":"next_result","kind":13,"name":"@exons","definition":"my"},{"line":201,"kind":13,"containerName":"next_result","name":"$transcript"},{"line":201,"name":"exons","kind":12,"containerName":"next_result"},{"localvar":"my","containerName":"next_result","kind":13,"name":"$protid","line":202,"definition":"my"},{"line":203,"name":"$self","kind":13,"containerName":"next_result"},{"line":203,"name":"start_element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$exons","line":205},{"line":205,"kind":12,"containerName":"next_result","name":"has_tag"},{"localvar":"my","kind":13,"containerName":"next_result","name":"$supporting_feature","line":206,"definition":"my"},{"name":"$exons","containerName":"next_result","kind":13,"line":206},{"line":206,"name":"get_tag_values","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$protid","line":207},{"line":207,"kind":13,"containerName":"next_result","name":"$supporting_feature"},{"name":"feature2","kind":12,"containerName":"next_result","line":207},{"kind":12,"containerName":"next_result","name":"seq_id","line":207},{"line":208,"kind":13,"containerName":"next_result","name":"$self"},{"line":208,"name":"element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":209},{"line":209,"kind":12,"containerName":"next_result","name":"wise"},{"line":209,"name":"_target_id","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":211},{"kind":12,"containerName":"next_result","name":"element","line":211},{"name":"$self","containerName":"next_result","kind":13,"line":212},{"line":212,"name":"wise","kind":12,"containerName":"next_result"},{"line":212,"name":"_score","kind":12,"containerName":"next_result"},{"definition":"my","line":213,"name":"$exon","containerName":"next_result","localvar":"my","kind":13},{"name":"@exons","containerName":"next_result","kind":13,"line":213},{"name":"$self","containerName":"next_result","kind":13,"line":214},{"line":214,"name":"start_element","kind":12,"containerName":"next_result"},{"line":215,"containerName":"next_result","kind":13,"name":"$exon"},{"containerName":"next_result","kind":12,"name":"strand","line":215},{"line":216,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":216},{"name":"$exon","kind":13,"containerName":"next_result","line":217},{"line":217,"name":"end","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":218},{"line":218,"containerName":"next_result","kind":12,"name":"element"},{"name":"$exon","kind":13,"containerName":"next_result","line":219},{"line":219,"containerName":"next_result","kind":12,"name":"start"},{"line":221,"kind":13,"containerName":"next_result","name":"$self"},{"line":221,"name":"element","kind":12,"containerName":"next_result"},{"line":222,"name":"$exon","kind":13,"containerName":"next_result"},{"name":"start","kind":12,"containerName":"next_result","line":222},{"line":223,"name":"$self","containerName":"next_result","kind":13},{"line":223,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$exon","line":224},{"line":224,"containerName":"next_result","kind":12,"name":"end"},{"line":226,"kind":13,"containerName":"next_result","name":"$self"},{"line":226,"name":"element","kind":12,"containerName":"next_result"},{"line":227,"kind":13,"containerName":"next_result","name":"$self"},{"line":227,"name":"wise","containerName":"next_result","kind":12},{"kind":12,"containerName":"next_result","name":"_score","line":227},{"line":228,"kind":13,"containerName":"next_result","name":"$exon"},{"name":"has_tag","containerName":"next_result","kind":12,"line":228},{"line":229,"name":"$sf","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"line":229,"containerName":"next_result","kind":13,"name":"$exon"},{"name":"get_tag_values","containerName":"next_result","kind":12,"line":229},{"line":230,"containerName":"next_result","localvar":"my","kind":13,"name":"$protein","definition":"my"},{"line":230,"containerName":"next_result","kind":13,"name":"$sf"},{"line":230,"containerName":"next_result","kind":12,"name":"feature2"},{"kind":13,"containerName":"next_result","name":"$protein","line":231},{"kind":12,"containerName":"next_result","name":"strand","line":231},{"containerName":"next_result","kind":13,"name":"$self","line":232},{"containerName":"next_result","kind":12,"name":"element","line":232},{"kind":13,"containerName":"next_result","name":"$protein","line":233},{"line":233,"name":"end","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":234},{"kind":12,"containerName":"next_result","name":"element","line":234},{"line":235,"kind":13,"containerName":"next_result","name":"$protein"},{"name":"start","containerName":"next_result","kind":12,"line":235},{"containerName":"next_result","kind":13,"name":"$self","line":237},{"line":237,"name":"element","containerName":"next_result","kind":12},{"line":238,"name":"$protein","kind":13,"containerName":"next_result"},{"name":"start","kind":12,"containerName":"next_result","line":238},{"line":239,"kind":13,"containerName":"next_result","name":"$self"},{"line":239,"name":"element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$protein","line":240},{"kind":12,"containerName":"next_result","name":"end","line":240},{"name":"$self","containerName":"next_result","kind":13,"line":243},{"name":"element","kind":12,"containerName":"next_result","line":243},{"line":245,"name":"$self","containerName":"next_result","kind":13},{"line":245,"name":"element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":247},{"containerName":"next_result","kind":12,"name":"end_element","line":247},{"name":"$self","kind":13,"containerName":"next_result","line":249},{"kind":12,"containerName":"next_result","name":"end_element","line":249},{"name":"$self","containerName":"next_result","kind":13,"line":251},{"line":251,"kind":12,"containerName":"next_result","name":"end_element"},{"line":252,"containerName":"next_result","kind":13,"name":"$self"},{"name":"end_document","containerName":"next_result","kind":12,"line":252}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":184,"character":0},"end":{"line":253,"character":9999}},"line":184,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"next_result($self)"}},{"name":"start_element","containerName":"main::","children":[{"containerName":"start_element","localvar":"my","kind":13,"name":"$self","line":267,"definition":"my"},{"name":"$data","containerName":"start_element","kind":13,"line":267},{"line":269,"name":"$nm","localvar":"my","kind":13,"containerName":"start_element","definition":"my"},{"line":269,"kind":13,"containerName":"start_element","name":"$data"},{"definition":"my","line":270,"name":"$type","kind":13,"localvar":"my","containerName":"start_element"},{"kind":13,"containerName":"start_element","name":"$MODEMAP","line":270},{"containerName":"start_element","kind":13,"name":"$nm","line":270},{"line":272,"kind":13,"containerName":"start_element","name":"$type"},{"line":273,"containerName":"start_element","kind":13,"name":"$self"},{"line":273,"name":"_eventHandler","containerName":"start_element","kind":12},{"kind":12,"containerName":"start_element","name":"will_handle","line":273},{"name":"$type","kind":13,"containerName":"start_element","line":273},{"line":274,"name":"$func","localvar":"my","kind":13,"containerName":"start_element","definition":"my"},{"name":"$type","kind":13,"containerName":"start_element","line":274},{"name":"$self","kind":13,"containerName":"start_element","line":275},{"containerName":"start_element","kind":12,"name":"_eventHandler","line":275},{"line":275,"containerName":"start_element","kind":13,"name":"$func"},{"line":275,"kind":13,"containerName":"start_element","name":"$data"},{"name":"$self","containerName":"start_element","kind":13,"line":277},{"line":277,"containerName":"start_element","kind":13,"name":"$type"},{"line":279,"name":"$type","containerName":"start_element","kind":13},{"line":280,"name":"$self","kind":13,"containerName":"start_element"},{"containerName":"start_element","kind":13,"name":"$self","line":281}],"detail":"($self,$data)","definition":"sub","range":{"start":{"character":0,"line":266},"end":{"line":283,"character":9999}},"kind":12,"line":266,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"}},{"containerName":"main::","name":"end_element","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"end_element","name":"$self","line":299},{"line":299,"name":"$data","kind":13,"containerName":"end_element"},{"definition":"my","line":300,"name":"$nm","containerName":"end_element","localvar":"my","kind":13},{"kind":13,"containerName":"end_element","name":"$data","line":300},{"line":301,"localvar":"my","kind":13,"containerName":"end_element","name":"$type","definition":"my"},{"containerName":"end_element","kind":13,"name":"$MODEMAP","line":301},{"name":"$nm","containerName":"end_element","kind":13,"line":301},{"line":302,"name":"$rc","containerName":"end_element","localvar":"my","kind":13,"definition":"my"},{"name":"$type","kind":13,"containerName":"end_element","line":304},{"line":304,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"line":304,"name":"$nm","kind":13,"containerName":"end_element"},{"line":305,"containerName":"end_element","kind":13,"name":"$self"},{"line":305,"name":"_eventHandler","containerName":"end_element","kind":12},{"kind":12,"containerName":"end_element","name":"will_handle","line":305},{"line":305,"containerName":"end_element","kind":13,"name":"$type"},{"kind":13,"localvar":"my","containerName":"end_element","name":"$func","line":306,"definition":"my"},{"containerName":"end_element","kind":13,"name":"$type","line":306},{"line":307,"kind":13,"containerName":"end_element","name":"$rc"},{"name":"$self","containerName":"end_element","kind":13,"line":307},{"name":"_eventHandler","kind":12,"containerName":"end_element","line":307},{"containerName":"end_element","kind":13,"name":"$func","line":307},{"line":307,"containerName":"end_element","kind":13,"name":"$self"},{"name":"$self","containerName":"end_element","kind":13,"line":308},{"name":"$self","containerName":"end_element","kind":13,"line":310}],"detail":"($self,$data)","definition":"sub","kind":12,"range":{"end":{"line":312,"character":9999},"start":{"line":298,"character":0}},"line":298,"signature":{"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"}},{"name":"%MAPPING","containerName":null,"kind":13,"line":312},{"containerName":null,"kind":13,"name":"%nm","line":312},{"kind":13,"containerName":null,"name":"%MAPPING","line":314},{"name":"%nm","kind":13,"containerName":null,"line":314},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$key","line":315},{"line":315,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":315,"name":"@nm","containerName":null,"kind":13},{"line":316,"kind":13,"containerName":null,"name":"%self"},{"line":316,"kind":13,"containerName":null,"name":"%key"},{"line":316,"containerName":null,"kind":13,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"%nm","line":316},{"name":"$key","kind":13,"containerName":null,"line":316},{"line":316,"kind":13,"containerName":null,"name":"%self"},{"line":318,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%MAPPING","line":318},{"name":"$nm","kind":13,"containerName":null,"line":318},{"name":"%self","kind":13,"containerName":null,"line":318},{"name":"$self","kind":13,"containerName":null,"line":321},{"name":"debug","containerName":"main::","kind":12,"line":321},{"line":323,"containerName":null,"kind":13,"name":"%self"},{"line":325,"containerName":null,"kind":13,"name":"%self"},{"name":"$rc","containerName":null,"kind":13,"line":325},{"containerName":null,"kind":13,"name":"$type","line":325},{"line":325,"name":"$type","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$rc","line":326},{"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"line":340,"range":{"start":{"character":0,"line":340},"end":{"line":345,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$data)","children":[{"localvar":"my","kind":13,"containerName":"element","name":"$self","line":341,"definition":"my"},{"kind":13,"containerName":"element","name":"$data","line":341},{"line":342,"name":"$self","containerName":"element","kind":13},{"name":"start_element","containerName":"element","kind":12,"line":342},{"name":"$data","kind":13,"containerName":"element","line":342},{"line":343,"containerName":"element","kind":13,"name":"$self"},{"line":343,"kind":12,"containerName":"element","name":"characters"},{"name":"$data","kind":13,"containerName":"element","line":343},{"line":344,"name":"$self","kind":13,"containerName":"element"},{"line":344,"containerName":"element","kind":12,"name":"end_element"},{"line":344,"name":"$data","containerName":"element","kind":13}],"containerName":"main::","name":"element"},{"detail":"($self,$data)","definition":"sub","name":"characters","containerName":"main::","children":[{"line":359,"kind":13,"localvar":"my","containerName":"characters","name":"$self","definition":"my"},{"line":359,"kind":13,"containerName":"characters","name":"$data"},{"name":"$data","containerName":"characters","kind":13,"line":361},{"name":"$data","kind":13,"containerName":"characters","line":361},{"line":363,"kind":13,"containerName":"characters","name":"$self"},{"line":363,"containerName":"characters","kind":13,"name":"$data"}],"signature":{"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"kind":12,"range":{"start":{"character":0,"line":358},"end":{"character":9999,"line":364}},"line":358},{"containerName":"main::","name":"within_element","children":[{"definition":"my","line":380,"localvar":"my","kind":13,"containerName":"within_element","name":"$self"},{"line":380,"name":"$name","containerName":"within_element","kind":13},{"line":381,"kind":13,"containerName":"within_element","name":"$name"},{"name":"$self","kind":13,"containerName":"within_element","line":382},{"line":383,"kind":13,"containerName":"within_element","name":"$self"}],"detail":"($self,$name)","definition":"sub","range":{"end":{"line":383,"character":9999},"start":{"line":379,"character":0}},"kind":12,"line":379,"signature":{"label":"within_element($self,$name)","documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","parameters":[{"label":"$self"},{"label":"$name"}]}},{"line":384,"containerName":null,"kind":13,"name":"%self"},{"line":385,"name":"%name","containerName":null,"kind":13},{"detail":"($self,$name)","definition":"sub","name":"in_element","containerName":"main::","children":[{"definition":"my","line":407,"localvar":"my","kind":13,"containerName":"in_element","name":"$self"},{"containerName":"in_element","kind":13,"name":"$name","line":407},{"line":408,"name":"$self","containerName":"in_element","kind":13},{"name":"$self","containerName":"in_element","kind":13,"line":409},{"line":409,"containerName":"in_element","kind":13,"name":"$name"}],"signature":{"label":"in_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name"},"kind":12,"range":{"start":{"line":406,"character":0},"end":{"character":9999,"line":410}},"line":406},{"detail":"($self)","definition":"sub","name":"start_document","containerName":"main::","children":[{"definition":"my","containerName":"start_document","localvar":"my","kind":13,"name":"$self","line":424},{"name":"$self","kind":13,"containerName":"start_document","line":425},{"name":"$self","kind":13,"containerName":"start_document","line":426},{"line":427,"name":"$self","kind":13,"containerName":"start_document"},{"kind":13,"containerName":"start_document","name":"$self","line":428},{"containerName":"start_document","kind":13,"name":"$self","line":429}],"signature":{"label":"start_document($self)","documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":430},"start":{"line":423,"character":0}},"line":423},{"signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_elements'} = [];\n    $self->{'_reporttype'} = 'exonerate';\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"kind":12,"range":{"end":{"character":9999,"line":447},"start":{"character":0,"line":444}},"line":444,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"end_document","children":[{"definition":"my","line":445,"kind":13,"localvar":"my","containerName":"end_document","name":"$self"},{"line":445,"name":"@args","kind":13,"containerName":"end_document"},{"name":"$self","containerName":"end_document","kind":13,"line":446}]},{"name":"write_result","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"write_result","line":451,"definition":"my"},{"kind":13,"containerName":"write_result","name":"$blast","line":451},{"line":451,"containerName":"write_result","kind":13,"name":"@args"},{"line":453,"name":"$self","kind":13,"containerName":"write_result"},{"containerName":"write_result","kind":12,"name":"writer","line":453},{"line":454,"name":"$self","containerName":"write_result","kind":13},{"line":454,"kind":12,"containerName":"write_result","name":"warn"},{"line":455,"kind":13,"containerName":"write_result","name":"$self"},{"line":455,"name":"writer","containerName":"write_result","kind":12},{"kind":13,"containerName":"write_result","name":"$DEFAULT_WRITER_CLASS","line":455},{"containerName":"write_result","kind":12,"name":"new","line":455},{"line":457,"kind":13,"containerName":"write_result","name":"$self"},{"containerName":"write_result","kind":13,"name":"$blast","line":457},{"line":457,"kind":13,"containerName":"write_result","name":"@args"}],"detail":"($self,$blast,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":450},"end":{"character":9999,"line":458}},"line":450,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"label":"write_result($self,$blast,@args)"}},{"line":457,"name":"SUPER","kind":12,"containerName":"write_result"},{"containerName":"main::","name":"result_count","children":[{"definition":"my","localvar":"my","containerName":"result_count","kind":13,"name":"$self","line":461},{"line":462,"name":"$self","containerName":"result_count","kind":13}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":460},"end":{"character":9999,"line":463}},"line":460},{"children":[{"name":"result_count","containerName":"report_count","kind":12,"line":465}],"name":"report_count","containerName":"main::","definition":"sub","line":465,"range":{"end":{"line":465,"character":9999},"start":{"character":0,"line":465}},"kind":12},{"line":479,"kind":12,"range":{"end":{"character":9999,"line":483},"start":{"character":0,"line":479}},"children":[{"localvar":"my","containerName":"wise","kind":13,"name":"$self","line":480,"definition":"my"},{"name":"$self","containerName":"wise","kind":13,"line":481},{"line":482,"name":"$self","kind":13,"containerName":"wise"}],"containerName":"main::","name":"wise","definition":"sub"},{"kind":12,"range":{"end":{"line":501,"character":9999},"start":{"character":0,"line":496}},"line":496,"containerName":"main::","name":"wisetype","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"wisetype","line":497},{"line":499,"containerName":"wisetype","kind":13,"name":"$self"},{"containerName":"wisetype","kind":13,"name":"$self","line":500}],"definition":"sub"}]}