{"vars":[{"name":"vars","containerName":"","kind":2,"line":84},{"line":97,"name":"$IDLENGTH","containerName":null,"kind":13},{"containerName":"strict::Bio::Factory","kind":2,"name":"ObjectFactory","line":97},{"name":"%MODEMAP","kind":13,"containerName":null,"line":100},{"line":109,"name":"%MAPPING","containerName":null,"kind":13},{"containerName":"","kind":2,"name":"base","line":166},{"containerName":"main::","name":"_initialize","children":[{"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","line":183,"definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":183},{"line":184,"name":"$self","kind":13,"containerName":"_initialize"},{"line":184,"name":"@args","containerName":"_initialize","kind":13},{"name":"@args","containerName":"_initialize","kind":13,"line":185},{"line":186,"name":"$idlength","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"line":186,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":186},{"kind":13,"containerName":"_initialize","name":"@args","line":186},{"containerName":"_initialize","kind":13,"name":"$self","line":187},{"name":"idlength","kind":12,"containerName":"_initialize","line":187},{"line":187,"name":"$idlength","containerName":"_initialize","kind":13},{"line":187,"containerName":"_initialize","kind":13,"name":"$IDLENGTH"},{"containerName":"_initialize","kind":13,"name":"$self","line":188},{"line":188,"kind":12,"containerName":"_initialize","name":"_eventHandler"},{"line":188,"kind":12,"containerName":"_initialize","name":"register_factory"},{"containerName":"_initialize","kind":12,"name":"new","line":190}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":196}},"line":182,"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"SUPER","kind":12,"containerName":"_initialize","line":184},{"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio","line":190},{"signature":{"label":"next_result($self)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]},"line":208,"range":{"start":{"line":208,"character":0},"end":{"line":1352,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$self","line":209},{"line":213,"localvar":"my","kind":13,"containerName":"next_result","name":"$data","definition":"my"},{"line":214,"kind":13,"localvar":"my","containerName":"next_result","name":"$seentop","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$current_hsp","line":215},{"containerName":"next_result","kind":13,"name":"$self","line":216},{"line":216,"kind":12,"containerName":"next_result","name":"start_document"},{"definition":"my","name":"@hit_signifs","localvar":"my","kind":13,"containerName":"next_result","line":217},{"name":"$self","kind":13,"containerName":"next_result","line":218},{"name":"_readline","kind":12,"containerName":"next_result","line":218},{"containerName":"next_result","kind":13,"name":"$self","line":219},{"name":"in_element","kind":12,"containerName":"next_result","line":219},{"line":225,"kind":13,"containerName":"next_result","name":"$self"},{"line":225,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"containerName":"next_result","name":"$seentop","line":230},{"line":231,"containerName":"next_result","kind":13,"name":"$self"},{"name":"_pushback","kind":12,"containerName":"next_result","line":231},{"kind":13,"containerName":"next_result","name":"$self","line":232},{"containerName":"next_result","kind":12,"name":"end_element","line":232},{"line":233,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"end_document","line":233},{"containerName":"next_result","kind":13,"name":"$self","line":235},{"line":236,"name":"$self","containerName":"next_result","kind":13},{"line":236,"name":"start_element","containerName":"next_result","kind":12},{"line":237,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$seentop","containerName":"next_result","kind":13,"line":238},{"kind":13,"containerName":"next_result","name":"$self","line":240},{"line":240,"name":"element","kind":12,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":243},{"line":246,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"_readline","line":246},{"line":247,"name":"$version","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"name":"$version","kind":13,"containerName":"next_result","line":248},{"name":"$version","kind":13,"containerName":"next_result","line":248},{"containerName":"next_result","kind":13,"name":"$self","line":249},{"line":249,"name":"$version","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":250},{"name":"element","kind":12,"containerName":"next_result","line":250},{"line":254,"containerName":"next_result","kind":13,"name":"$version"},{"definition":"my","line":257,"name":"$last","localvar":"my","containerName":"next_result","kind":13},{"line":257,"name":"$leadin","containerName":"next_result","kind":13},{"name":"$type","containerName":"next_result","kind":13,"line":257},{"line":257,"name":"$querylen","kind":13,"containerName":"next_result"},{"line":257,"containerName":"next_result","kind":13,"name":"$querytype"},{"line":257,"name":"$querydef","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":259},{"line":259,"containerName":"next_result","kind":12,"name":"_readline"},{"name":"$leadin","kind":13,"containerName":"next_result","line":269},{"line":269,"name":"$querydef","containerName":"next_result","kind":13},{"name":"$leadin","containerName":"next_result","kind":13,"line":270},{"name":"$querydef","kind":13,"containerName":"next_result","line":271},{"name":"$querydef","kind":13,"containerName":"next_result","line":274},{"kind":13,"containerName":"next_result","name":"$querylen","line":274},{"kind":13,"containerName":"next_result","name":"$querytype","line":274},{"containerName":"next_result","kind":13,"name":"$last","line":280},{"line":281,"kind":13,"containerName":"next_result","name":"$querylen"},{"name":"$querytype","kind":13,"containerName":"next_result","line":281},{"line":282,"containerName":"next_result","kind":13,"name":"$querydef"},{"line":288,"name":"$last","kind":13,"containerName":"next_result"},{"line":289,"name":"$querydef","kind":13,"containerName":"next_result"},{"name":"$querylen","kind":13,"containerName":"next_result","line":289},{"line":289,"name":"$querytype","containerName":"next_result","kind":13},{"line":293,"kind":13,"containerName":"next_result","name":"$last"},{"line":295,"kind":13,"containerName":"next_result","name":"$self"},{"line":296,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$querytype","line":298},{"name":"$self","containerName":"next_result","kind":13,"line":299},{"line":301,"kind":13,"containerName":"next_result","name":"$querytype"},{"line":302,"kind":13,"containerName":"next_result","name":"$self"},{"line":305,"containerName":"next_result","localvar":"my","kind":13,"name":"$name","definition":"my"},{"line":305,"name":"$descr","kind":13,"containerName":"next_result"},{"line":305,"containerName":"next_result","kind":13,"name":"$querydef"},{"line":306,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":306},{"name":"$name","kind":13,"containerName":"next_result","line":310},{"kind":13,"containerName":"next_result","name":"$self","line":312},{"containerName":"next_result","kind":12,"name":"element","line":312},{"line":316,"kind":13,"containerName":"next_result","name":"$descr"},{"kind":13,"containerName":"next_result","name":"$querylen","line":318},{"name":"$self","containerName":"next_result","kind":13,"line":319},{"name":"element","containerName":"next_result","kind":12,"line":319},{"name":"$querylen","containerName":"next_result","kind":13,"line":323},{"line":327,"name":"$self","containerName":"next_result","kind":13},{"name":"warn","containerName":"next_result","kind":12,"line":327},{"containerName":"next_result","kind":13,"name":"$last","line":330},{"kind":13,"containerName":"next_result","name":"$last","line":331},{"name":"$last","containerName":"next_result","kind":13,"line":332},{"name":"$self","kind":13,"containerName":"next_result","line":338},{"line":338,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"containerName":"next_result","name":"$self","line":342},{"line":342,"name":"element","kind":12,"containerName":"next_result"},{"line":352,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"_readline","line":352},{"line":358,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":358},{"kind":13,"containerName":"next_result","name":"$self","line":364},{"containerName":"next_result","kind":12,"name":"element","line":364},{"name":"$self","containerName":"next_result","kind":13,"line":370},{"line":370,"kind":12,"containerName":"next_result","name":"element"},{"line":376,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":376},{"containerName":"next_result","kind":13,"name":"$self","line":384},{"line":384,"name":"element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":392},{"name":"element","containerName":"next_result","kind":12,"line":392},{"kind":13,"containerName":"next_result","name":"$self","line":400},{"line":400,"containerName":"next_result","kind":12,"name":"element"},{"name":"$self","kind":13,"containerName":"next_result","line":406},{"name":"element","containerName":"next_result","kind":12,"line":406},{"line":412,"name":"$self","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":414},{"containerName":"next_result","kind":12,"name":"element","line":414},{"line":417,"name":"$self","containerName":"next_result","kind":13},{"definition":"my","line":422,"kind":13,"localvar":"my","containerName":"next_result","name":"$rel"},{"line":423,"kind":13,"localvar":"my","containerName":"next_result","name":"@labels","definition":"my"},{"line":424,"name":"@labels","containerName":"next_result","kind":13},{"line":427,"kind":13,"containerName":"next_result","name":"$self"},{"line":427,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"@labels","line":434},{"line":434,"name":"$rel","kind":13,"containerName":"next_result"},{"line":436,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"_readline","line":436},{"containerName":"next_result","localvar":"my","kind":13,"name":"@line","line":439,"definition":"my"},{"line":441,"kind":13,"containerName":"next_result","name":"$line"},{"line":441,"kind":13,"containerName":"next_result","name":"$labels"},{"name":"@labels","containerName":"next_result","kind":13,"line":444},{"definition":"my","line":447,"containerName":"next_result","localvar":"my","kind":13,"name":"%data"},{"line":448,"name":"@data","kind":13,"containerName":"next_result"},{"line":448,"containerName":"next_result","kind":13,"name":"@labels"},{"kind":13,"containerName":"next_result","name":"@line","line":448},{"line":448,"name":"@line","kind":13,"containerName":"next_result"},{"line":448,"name":"@labels","containerName":"next_result","kind":13},{"name":"$line","kind":13,"containerName":"next_result","line":449},{"line":450,"kind":13,"localvar":"my","containerName":"next_result","name":"$fr","definition":"my"},{"line":451,"kind":13,"containerName":"next_result","name":"$data"},{"containerName":"next_result","kind":13,"name":"$fr","line":452},{"kind":13,"containerName":"next_result","name":"$fr","line":453},{"name":"$fr","kind":13,"containerName":"next_result","line":454},{"name":"@line","containerName":"next_result","kind":13,"line":456},{"line":459,"name":"$data","containerName":"next_result","kind":13},{"name":"$line","containerName":"next_result","kind":13,"line":462},{"containerName":"next_result","kind":13,"name":"$data","line":463},{"containerName":"next_result","kind":13,"name":"@line","line":464},{"line":465,"containerName":"next_result","kind":13,"name":"$line"},{"name":"@line","kind":13,"containerName":"next_result","line":466},{"line":470,"containerName":"next_result","kind":13,"name":"$data"},{"definition":"my","line":476,"kind":13,"localvar":"my","containerName":"next_result","name":"$id"},{"line":476,"kind":13,"containerName":"next_result","name":"$desc"},{"line":477,"name":"@pieces","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"kind":13,"containerName":"next_result","name":"$id","line":477},{"definition":"my","line":478,"containerName":"next_result","localvar":"my","kind":13,"name":"$acc"},{"line":478,"kind":13,"containerName":"next_result","name":"@pieces"},{"name":"$acc","containerName":"next_result","kind":13,"line":479},{"containerName":"next_result","kind":13,"name":"@data","line":481},{"line":481,"name":"$id","kind":13,"containerName":"next_result"},{"line":481,"name":"$desc","kind":13,"containerName":"next_result"},{"line":481,"name":"$acc","containerName":"next_result","kind":13},{"line":483,"name":"@hit_signifs","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"%data","line":483},{"containerName":"next_result","kind":13,"name":"$self","line":491},{"containerName":"next_result","kind":12,"name":"element","line":491},{"line":497,"kind":13,"containerName":"next_result","name":"$self"},{"line":497,"name":"element","containerName":"next_result","kind":12},{"line":503,"name":"$self","kind":13,"containerName":"next_result"},{"line":503,"containerName":"next_result","kind":12,"name":"element"},{"line":509,"name":"$self","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":510},{"line":512,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":512},{"kind":13,"containerName":"next_result","name":"$self","line":515},{"kind":13,"containerName":"next_result","name":"$self","line":520},{"name":"$self","kind":13,"containerName":"next_result","line":521},{"name":"$self","kind":13,"containerName":"next_result","line":526},{"line":526,"containerName":"next_result","kind":12,"name":"element"},{"kind":13,"containerName":"next_result","name":"$self","line":532},{"kind":12,"containerName":"next_result","name":"element","line":532},{"name":"$self","containerName":"next_result","kind":13,"line":538},{"line":538,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"containerName":"next_result","name":"$self","line":549},{"line":549,"name":"element","kind":12,"containerName":"next_result"},{"line":555,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":555},{"line":561,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":561},{"line":569,"localvar":"my","containerName":"next_result","kind":13,"name":"$hit_id","definition":"my"},{"kind":13,"containerName":"next_result","name":"$len","line":569},{"name":"$alphabet","kind":13,"containerName":"next_result","line":569},{"line":570,"containerName":"next_result","kind":13,"name":"$len"},{"line":570,"kind":13,"containerName":"next_result","name":"$alphabet"},{"line":572,"name":"$self","kind":13,"containerName":"next_result"},{"line":572,"name":"_readline","containerName":"next_result","kind":12},{"line":574,"name":"$len","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$alphabet","line":574},{"line":575,"kind":13,"containerName":"next_result","name":"$hit_id"},{"line":579,"kind":13,"containerName":"next_result","name":"$self"},{"line":579,"name":"throw","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":583},{"name":"in_element","kind":12,"containerName":"next_result","line":583},{"line":584,"containerName":"next_result","kind":13,"name":"$self"},{"line":584,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":586},{"name":"in_element","containerName":"next_result","kind":12,"line":586},{"line":587,"containerName":"next_result","kind":13,"name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":587},{"line":590,"kind":13,"containerName":"next_result","name":"$self"},{"line":590,"containerName":"next_result","kind":12,"name":"start_element"},{"name":"$self","kind":13,"containerName":"next_result","line":591},{"line":591,"kind":12,"containerName":"next_result","name":"element"},{"line":595,"name":"$len","kind":13,"containerName":"next_result"},{"definition":"my","line":597,"name":"$id","kind":13,"localvar":"my","containerName":"next_result"},{"name":"$desc","kind":13,"containerName":"next_result","line":597},{"containerName":"next_result","kind":13,"name":"$hit_id","line":597},{"name":"$self","kind":13,"containerName":"next_result","line":598},{"kind":12,"containerName":"next_result","name":"element","line":598},{"line":602,"name":"$id","containerName":"next_result","kind":13},{"definition":"my","name":"@pieces","containerName":"next_result","localvar":"my","kind":13,"line":606},{"line":606,"kind":13,"containerName":"next_result","name":"$id"},{"definition":"my","line":607,"name":"$acc","localvar":"my","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"@pieces","line":607},{"line":608,"name":"$acc","containerName":"next_result","kind":13},{"line":609,"name":"$self","containerName":"next_result","kind":13},{"line":609,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$acc","line":613},{"line":615,"name":"$self","kind":13,"containerName":"next_result"},{"line":615,"name":"element","containerName":"next_result","kind":12},{"line":619,"name":"$desc","containerName":"next_result","kind":13},{"line":622,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"_readline","line":622},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$score","line":623},{"name":"$bits","kind":13,"containerName":"next_result","line":623},{"line":623,"name":"$e","kind":13,"containerName":"next_result"},{"line":626,"name":"$bits","kind":13,"containerName":"next_result"},{"name":"$score","containerName":"next_result","kind":13,"line":626},{"line":626,"name":"$bits","kind":13,"containerName":"next_result"},{"localvar":"my","kind":13,"containerName":"next_result","name":"$v","line":628,"definition":"my"},{"line":628,"kind":13,"containerName":"next_result","name":"@hit_signifs"},{"kind":13,"containerName":"next_result","name":"$v","line":629},{"kind":13,"containerName":"next_result","name":"$v","line":630},{"line":630,"name":"$e","containerName":"next_result","kind":13},{"line":630,"kind":13,"containerName":"next_result","name":"$bits"},{"name":"$score","kind":13,"containerName":"next_result","line":630},{"line":632,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":632},{"line":635,"name":"$v","containerName":"next_result","kind":13},{"name":"$v","kind":13,"containerName":"next_result","line":635},{"line":636,"name":"$e","kind":13,"containerName":"next_result"},{"line":638,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":638},{"line":641,"name":"$v","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$v","line":641},{"line":642,"name":"$bits","kind":13,"containerName":"next_result"},{"line":644,"kind":13,"containerName":"next_result","name":"$self"},{"line":644,"name":"start_element","kind":12,"containerName":"next_result"},{"line":646,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":646},{"name":"$v","kind":13,"containerName":"next_result","line":649},{"name":"$v","kind":13,"containerName":"next_result","line":649},{"name":"$score","containerName":"next_result","kind":13,"line":650},{"containerName":"next_result","kind":13,"name":"$self","line":652},{"name":"element","containerName":"next_result","kind":12,"line":652},{"line":655,"name":"$v","containerName":"next_result","kind":13},{"line":655,"name":"$v","containerName":"next_result","kind":13},{"line":656,"containerName":"next_result","kind":13,"name":"$e"},{"name":"$self","kind":13,"containerName":"next_result","line":658},{"containerName":"next_result","kind":12,"name":"element","line":658},{"kind":13,"containerName":"next_result","name":"$v","line":661},{"line":661,"kind":13,"containerName":"next_result","name":"$v"},{"line":662,"name":"$bits","kind":13,"containerName":"next_result"},{"line":664,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","kind":12,"containerName":"next_result","line":664},{"name":"$self","kind":13,"containerName":"next_result","line":667},{"name":"element","containerName":"next_result","kind":12,"line":667},{"name":"$identper","kind":13,"localvar":"my","containerName":"next_result","line":682,"definition":"my"},{"containerName":"next_result","kind":13,"name":"$gapper","line":682},{"line":682,"containerName":"next_result","kind":13,"name":"$len"},{"line":682,"kind":13,"containerName":"next_result","name":"$querystart"},{"line":682,"kind":13,"containerName":"next_result","name":"$queryend"},{"line":683,"name":"$hitstart","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$hitend","line":683},{"line":685,"localvar":"my","containerName":"next_result","kind":13,"name":"$ident","definition":"my"},{"line":685,"name":"$identper","containerName":"next_result","kind":13},{"line":685,"name":"$len","kind":13,"containerName":"next_result"},{"definition":"my","name":"$positive","containerName":"next_result","localvar":"my","kind":13,"line":686},{"name":"$gapper","containerName":"next_result","kind":13,"line":686},{"name":"$len","containerName":"next_result","kind":13,"line":686},{"kind":13,"containerName":"next_result","name":"$self","line":688},{"line":688,"name":"element","containerName":"next_result","kind":12},{"name":"$ident","containerName":"next_result","kind":13,"line":692},{"line":694,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":694},{"kind":13,"containerName":"next_result","name":"$positive","line":698},{"kind":13,"containerName":"next_result","name":"$self","line":700},{"line":700,"containerName":"next_result","kind":12,"name":"element"},{"name":"$len","kind":13,"containerName":"next_result","line":704},{"line":707,"name":"$self","kind":13,"containerName":"next_result"},{"line":707,"name":"element","containerName":"next_result","kind":12},{"line":711,"name":"$querystart","kind":13,"containerName":"next_result"},{"line":713,"name":"$self","kind":13,"containerName":"next_result"},{"line":713,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$queryend","line":717},{"line":719,"kind":13,"containerName":"next_result","name":"$self"},{"line":719,"kind":12,"containerName":"next_result","name":"element"},{"line":723,"kind":13,"containerName":"next_result","name":"$hitstart"},{"name":"$self","containerName":"next_result","kind":13,"line":725},{"name":"element","containerName":"next_result","kind":12,"line":725},{"line":729,"name":"$hitend","kind":13,"containerName":"next_result"},{"line":734,"kind":13,"containerName":"next_result","name":"$v"},{"line":735,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":735},{"kind":13,"containerName":"next_result","name":"$v","line":736},{"name":"$v","containerName":"next_result","kind":13,"line":737},{"line":738,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"element","line":738},{"name":"$v","kind":13,"containerName":"next_result","line":739},{"line":740,"kind":13,"containerName":"next_result","name":"$v"},{"containerName":"next_result","kind":13,"name":"$self","line":742},{"name":"$v","kind":13,"containerName":"next_result","line":743},{"kind":13,"containerName":"next_result","name":"$v","line":746},{"containerName":"next_result","kind":13,"name":"$v","line":746},{"name":"$self","containerName":"next_result","kind":13,"line":747},{"line":747,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$self","line":756},{"line":756,"name":"element","containerName":"next_result","kind":12},{"line":764,"name":"$v","containerName":"next_result","kind":13},{"name":"$v","kind":13,"containerName":"next_result","line":764},{"containerName":"next_result","kind":13,"name":"$self","line":765},{"line":765,"kind":12,"containerName":"next_result","name":"element"},{"line":774,"kind":13,"containerName":"next_result","name":"$self"},{"line":774,"name":"element","kind":12,"containerName":"next_result"},{"line":784,"name":"$self","kind":13,"containerName":"next_result"},{"line":784,"name":"element","kind":12,"containerName":"next_result"},{"line":787,"kind":13,"containerName":"next_result","name":"$v"},{"name":"$self","containerName":"next_result","kind":13,"line":790},{"kind":12,"containerName":"next_result","name":"element","line":790},{"kind":13,"containerName":"next_result","name":"$self","line":795},{"name":"element","containerName":"next_result","kind":12,"line":795},{"containerName":"next_result","kind":13,"name":"$self","line":797},{"line":797,"kind":12,"containerName":"next_result","name":"element"},{"line":798,"name":"$v","kind":13,"containerName":"next_result"},{"line":803,"name":"$self","containerName":"next_result","kind":13},{"line":803,"name":"warn","containerName":"next_result","kind":12},{"line":807,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"in_element","line":807},{"containerName":"next_result","kind":13,"name":"$self","line":808},{"line":808,"kind":12,"containerName":"next_result","name":"end_element"},{"line":810,"name":"$self","containerName":"next_result","kind":13},{"name":"in_element","kind":12,"containerName":"next_result","line":810},{"name":"$self","containerName":"next_result","kind":13,"line":811},{"containerName":"next_result","kind":12,"name":"end_element","line":811},{"line":819,"name":"$self","kind":13,"containerName":"next_result"},{"name":"_readline","containerName":"next_result","kind":12,"line":819},{"containerName":"next_result","kind":13,"name":"$self","line":826},{"line":826,"kind":12,"containerName":"next_result","name":"_pushback"},{"kind":13,"containerName":"next_result","name":"@hit_signifs","line":830},{"kind":13,"localvar":"my","containerName":"next_result","name":"$h","line":833,"definition":"my"},{"containerName":"next_result","kind":13,"name":"@hit_signifs","line":833},{"kind":13,"containerName":"next_result","name":"$self","line":840},{"line":840,"name":"start_element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":841},{"line":841,"kind":12,"containerName":"next_result","name":"element"},{"line":844,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"containerName":"next_result","name":"$h","line":846},{"containerName":"next_result","kind":13,"name":"$self","line":847},{"kind":12,"containerName":"next_result","name":"element","line":847},{"kind":13,"containerName":"next_result","name":"$h","line":850},{"line":852,"kind":13,"containerName":"next_result","name":"$h"},{"containerName":"next_result","kind":13,"name":"$self","line":853},{"containerName":"next_result","kind":12,"name":"element","line":853},{"line":856,"name":"$h","kind":13,"containerName":"next_result"},{"name":"$h","kind":13,"containerName":"next_result","line":858},{"line":859,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":859},{"line":862,"name":"$h","kind":13,"containerName":"next_result"},{"line":864,"name":"$h","containerName":"next_result","kind":13},{"line":865,"name":"$self","kind":13,"containerName":"next_result"},{"line":865,"name":"element","kind":12,"containerName":"next_result"},{"line":868,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","kind":13,"containerName":"next_result","line":870},{"name":"$self","containerName":"next_result","kind":13,"line":871},{"name":"element","kind":12,"containerName":"next_result","line":871},{"kind":13,"containerName":"next_result","name":"$h","line":874},{"name":"$h","containerName":"next_result","kind":13,"line":876},{"line":878,"containerName":"next_result","kind":13,"name":"$self"},{"line":878,"name":"start_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":879},{"line":879,"containerName":"next_result","kind":12,"name":"element"},{"line":880,"name":"$h","containerName":"next_result","kind":13},{"line":881,"kind":13,"containerName":"next_result","name":"$h"},{"containerName":"next_result","kind":13,"name":"$self","line":882},{"line":882,"name":"element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$h","line":883},{"kind":13,"containerName":"next_result","name":"$h","line":884},{"kind":13,"containerName":"next_result","name":"$self","line":885},{"line":885,"name":"element","kind":12,"containerName":"next_result"},{"line":886,"name":"$h","kind":13,"containerName":"next_result"},{"name":"$h","containerName":"next_result","kind":13,"line":887},{"kind":13,"containerName":"next_result","name":"$self","line":888},{"name":"element","kind":12,"containerName":"next_result","line":888},{"name":"$h","containerName":"next_result","kind":13,"line":889},{"line":890,"name":"$h","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":891},{"name":"element","kind":12,"containerName":"next_result","line":891},{"name":"$h","containerName":"next_result","kind":13,"line":892},{"containerName":"next_result","kind":13,"name":"$h","line":893},{"line":894,"containerName":"next_result","kind":13,"name":"$self"},{"line":894,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$h","line":898},{"name":"$h","kind":13,"containerName":"next_result","line":898},{"line":900,"name":"$h","containerName":"next_result","kind":13},{"name":"$h","kind":13,"containerName":"next_result","line":900},{"line":902,"containerName":"next_result","kind":13,"name":"$h"},{"containerName":"next_result","kind":13,"name":"$self","line":903},{"name":"element","kind":12,"containerName":"next_result","line":903},{"line":907,"containerName":"next_result","kind":13,"name":"$h"},{"line":907,"containerName":"next_result","kind":13,"name":"$h"},{"kind":13,"containerName":"next_result","name":"$h","line":909},{"name":"$h","kind":13,"containerName":"next_result","line":909},{"line":912,"name":"$self","kind":13,"containerName":"next_result"},{"line":912,"kind":12,"containerName":"next_result","name":"element"},{"line":916,"name":"$h","containerName":"next_result","kind":13},{"line":916,"name":"$h","kind":13,"containerName":"next_result"},{"line":918,"kind":13,"containerName":"next_result","name":"$h"},{"line":918,"containerName":"next_result","kind":13,"name":"$h"},{"kind":13,"containerName":"next_result","name":"$self","line":920},{"kind":12,"containerName":"next_result","name":"element","line":920},{"line":921,"name":"$h","kind":13,"containerName":"next_result"},{"name":"$h","containerName":"next_result","kind":13,"line":922},{"kind":13,"containerName":"next_result","name":"$self","line":923},{"kind":12,"containerName":"next_result","name":"element","line":923},{"kind":13,"containerName":"next_result","name":"$h","line":924},{"line":925,"containerName":"next_result","kind":13,"name":"$h"},{"name":"$self","containerName":"next_result","kind":13,"line":926},{"kind":12,"containerName":"next_result","name":"element","line":926},{"line":927,"kind":13,"containerName":"next_result","name":"$h"},{"line":928,"containerName":"next_result","kind":13,"name":"$h"},{"line":929,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":929},{"containerName":"next_result","kind":13,"name":"$h","line":930},{"line":931,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"containerName":"next_result","name":"$self","line":932},{"line":932,"name":"element","kind":12,"containerName":"next_result"},{"line":933,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","kind":13,"line":934},{"kind":13,"containerName":"next_result","name":"$self","line":936},{"line":936,"kind":12,"containerName":"next_result","name":"element"},{"name":"$h","containerName":"next_result","kind":13,"line":937},{"line":938,"containerName":"next_result","kind":13,"name":"$h"},{"containerName":"next_result","kind":13,"name":"$self","line":939},{"line":939,"containerName":"next_result","kind":12,"name":"element"},{"line":940,"containerName":"next_result","kind":13,"name":"$h"},{"name":"$h","containerName":"next_result","kind":13,"line":941},{"name":"$self","kind":13,"containerName":"next_result","line":943},{"line":944,"name":"$h","containerName":"next_result","kind":13},{"line":947,"kind":13,"containerName":"next_result","name":"$h"},{"line":947,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$self","kind":13,"containerName":"next_result","line":948},{"line":948,"name":"element","kind":12,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":957},{"line":957,"kind":12,"containerName":"next_result","name":"element"},{"line":965,"containerName":"next_result","kind":13,"name":"$h"},{"line":965,"name":"$h","kind":13,"containerName":"next_result"},{"line":966,"name":"$self","kind":13,"containerName":"next_result"},{"line":966,"containerName":"next_result","kind":12,"name":"element"},{"line":975,"containerName":"next_result","kind":13,"name":"$self"},{"line":975,"kind":12,"containerName":"next_result","name":"element"},{"name":"$self","kind":13,"containerName":"next_result","line":985},{"line":985,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$h","line":988},{"containerName":"next_result","kind":13,"name":"$self","line":991},{"name":"element","containerName":"next_result","kind":12,"line":991},{"name":"$self","containerName":"next_result","kind":13,"line":996},{"line":996,"kind":12,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":998},{"line":998,"kind":12,"containerName":"next_result","name":"element"},{"line":1001,"name":"$h","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":1006},{"line":1006,"name":"end_element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1007},{"name":"end_element","containerName":"next_result","kind":12,"line":1007},{"line":1010,"name":"$self","kind":13,"containerName":"next_result"},{"name":"end_element","kind":12,"containerName":"next_result","line":1010},{"line":1011,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_document","kind":12,"containerName":"next_result","line":1011},{"line":1014,"containerName":"next_result","kind":13,"name":"$self"},{"name":"within_element","kind":12,"containerName":"next_result","line":1014},{"line":1015,"kind":13,"containerName":"next_result","name":"$self"},{"line":1015,"name":"in_element","containerName":"next_result","kind":12},{"name":"$self","kind":13,"containerName":"next_result","line":1016},{"kind":12,"containerName":"next_result","name":"end_element","line":1016},{"line":1018,"kind":13,"containerName":"next_result","name":"$self"},{"line":1018,"name":"in_element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":1019},{"line":1019,"name":"end_element","kind":12,"containerName":"next_result"},{"line":1022,"name":"@hit_signifs","kind":13,"containerName":"next_result"},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$h","line":1025},{"kind":13,"containerName":"next_result","name":"@hit_signifs","line":1025},{"line":1026,"name":"$self","kind":13,"containerName":"next_result"},{"line":1026,"containerName":"next_result","kind":12,"name":"start_element"},{"name":"$self","kind":13,"containerName":"next_result","line":1027},{"kind":12,"containerName":"next_result","name":"element","line":1027},{"name":"$h","containerName":"next_result","kind":13,"line":1030},{"kind":13,"containerName":"next_result","name":"$h","line":1032},{"name":"$self","kind":13,"containerName":"next_result","line":1033},{"name":"element","kind":12,"containerName":"next_result","line":1033},{"name":"$h","kind":13,"containerName":"next_result","line":1036},{"line":1038,"name":"$h","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":1039},{"line":1039,"kind":12,"containerName":"next_result","name":"element"},{"line":1042,"name":"$h","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$h","line":1044},{"line":1045,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1045},{"containerName":"next_result","kind":13,"name":"$h","line":1048},{"containerName":"next_result","kind":13,"name":"$h","line":1050},{"kind":13,"containerName":"next_result","name":"$self","line":1051},{"line":1051,"name":"element","containerName":"next_result","kind":12},{"line":1054,"kind":13,"containerName":"next_result","name":"$h"},{"line":1056,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"containerName":"next_result","name":"$self","line":1057},{"line":1057,"name":"element","kind":12,"containerName":"next_result"},{"name":"$h","kind":13,"containerName":"next_result","line":1060},{"line":1062,"kind":13,"containerName":"next_result","name":"$h"},{"line":1064,"containerName":"next_result","kind":13,"name":"$self"},{"name":"start_element","kind":12,"containerName":"next_result","line":1064},{"name":"$self","kind":13,"containerName":"next_result","line":1065},{"line":1065,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$h","line":1066},{"line":1067,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"containerName":"next_result","name":"$self","line":1068},{"containerName":"next_result","kind":12,"name":"element","line":1068},{"containerName":"next_result","kind":13,"name":"$h","line":1069},{"line":1070,"containerName":"next_result","kind":13,"name":"$h"},{"line":1071,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":1071},{"line":1072,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","kind":13,"line":1073},{"line":1074,"name":"$self","kind":13,"containerName":"next_result"},{"line":1074,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$h","line":1075},{"name":"$h","kind":13,"containerName":"next_result","line":1076},{"name":"$self","containerName":"next_result","kind":13,"line":1077},{"containerName":"next_result","kind":12,"name":"element","line":1077},{"line":1078,"name":"$h","kind":13,"containerName":"next_result"},{"name":"$h","kind":13,"containerName":"next_result","line":1079},{"line":1080,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1080},{"line":1084,"containerName":"next_result","kind":13,"name":"$h"},{"line":1084,"kind":13,"containerName":"next_result","name":"$h"},{"line":1086,"name":"$h","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$h","line":1086},{"name":"$h","kind":13,"containerName":"next_result","line":1088},{"line":1089,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":1089},{"name":"$h","containerName":"next_result","kind":13,"line":1093},{"line":1093,"name":"$h","kind":13,"containerName":"next_result"},{"line":1095,"name":"$h","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$h","line":1095},{"line":1098,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":1098},{"line":1102,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","kind":13,"containerName":"next_result","line":1102},{"name":"$h","containerName":"next_result","kind":13,"line":1104},{"name":"$h","kind":13,"containerName":"next_result","line":1104},{"line":1106,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":1106},{"line":1107,"name":"$h","kind":13,"containerName":"next_result"},{"line":1108,"name":"$h","kind":13,"containerName":"next_result"},{"line":1109,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":1109},{"name":"$h","containerName":"next_result","kind":13,"line":1110},{"line":1111,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$self","kind":13,"containerName":"next_result","line":1112},{"name":"element","containerName":"next_result","kind":12,"line":1112},{"containerName":"next_result","kind":13,"name":"$h","line":1113},{"name":"$h","containerName":"next_result","kind":13,"line":1114},{"containerName":"next_result","kind":13,"name":"$self","line":1115},{"line":1115,"containerName":"next_result","kind":12,"name":"element"},{"line":1116,"containerName":"next_result","kind":13,"name":"$h"},{"line":1117,"kind":13,"containerName":"next_result","name":"$h"},{"line":1118,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":1118},{"name":"$h","kind":13,"containerName":"next_result","line":1119},{"line":1120,"kind":13,"containerName":"next_result","name":"$h"},{"line":1122,"kind":13,"containerName":"next_result","name":"$self"},{"line":1122,"name":"element","kind":12,"containerName":"next_result"},{"name":"$h","kind":13,"containerName":"next_result","line":1125},{"containerName":"next_result","kind":13,"name":"$h","line":1127},{"kind":13,"containerName":"next_result","name":"$self","line":1128},{"line":1128,"name":"element","kind":12,"containerName":"next_result"},{"line":1129,"name":"$h","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$h","line":1130},{"name":"$self","kind":13,"containerName":"next_result","line":1132},{"line":1133,"name":"$h","kind":13,"containerName":"next_result"},{"line":1136,"name":"$h","containerName":"next_result","kind":13},{"name":"$h","containerName":"next_result","kind":13,"line":1136},{"containerName":"next_result","kind":13,"name":"$self","line":1137},{"name":"element","containerName":"next_result","kind":12,"line":1137},{"line":1145,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1145},{"line":1152,"containerName":"next_result","kind":13,"name":"$h"},{"kind":13,"containerName":"next_result","name":"$h","line":1152},{"name":"$self","containerName":"next_result","kind":13,"line":1153},{"containerName":"next_result","kind":12,"name":"element","line":1153},{"line":1161,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1161},{"line":1170,"name":"$self","containerName":"next_result","kind":13},{"kind":12,"containerName":"next_result","name":"element","line":1170},{"name":"$h","kind":13,"containerName":"next_result","line":1173},{"line":1176,"name":"$self","kind":13,"containerName":"next_result"},{"line":1176,"kind":12,"containerName":"next_result","name":"element"},{"line":1182,"containerName":"next_result","kind":13,"name":"$self"},{"line":1182,"kind":12,"containerName":"next_result","name":"element"},{"name":"$self","kind":13,"containerName":"next_result","line":1184},{"line":1184,"containerName":"next_result","kind":12,"name":"element"},{"kind":13,"containerName":"next_result","name":"$h","line":1187},{"line":1192,"name":"$self","kind":13,"containerName":"next_result"},{"line":1192,"name":"end_element","kind":12,"containerName":"next_result"},{"line":1193,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"end_element","line":1193},{"name":"$self","kind":13,"containerName":"next_result","line":1196},{"line":1196,"kind":12,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","kind":13,"name":"$self","line":1197},{"line":1197,"containerName":"next_result","kind":12,"name":"_pushback"},{"name":"$self","kind":13,"containerName":"next_result","line":1198},{"kind":12,"containerName":"next_result","name":"end_document","line":1198},{"line":1201,"name":"$self","containerName":"next_result","kind":13},{"name":"start_element","kind":12,"containerName":"next_result","line":1201},{"name":"$self","kind":13,"containerName":"next_result","line":1202},{"containerName":"next_result","kind":13,"name":"$seentop","line":1203},{"line":1204,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1204},{"name":"$self","kind":13,"containerName":"next_result","line":1207},{"line":1210,"name":"$self","kind":13,"containerName":"next_result"},{"line":1210,"name":"element","containerName":"next_result","kind":12},{"line":1213,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$type","localvar":"my","kind":13,"containerName":"next_result","line":1217,"definition":"my"},{"line":1217,"containerName":"next_result","kind":13,"name":"$querylen"},{"name":"$querytype","containerName":"next_result","kind":13,"line":1217},{"line":1217,"containerName":"next_result","kind":13,"name":"$querydef"},{"name":"$querydef","containerName":"next_result","kind":13,"line":1220},{"line":1221,"name":"$querydef","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$querydef","line":1223},{"containerName":"next_result","kind":13,"name":"$querylen","line":1223},{"kind":13,"containerName":"next_result","name":"$querytype","line":1223},{"name":"$self","kind":13,"containerName":"next_result","line":1227},{"name":"$self","kind":13,"containerName":"next_result","line":1228},{"kind":13,"containerName":"next_result","name":"$querytype","line":1230},{"kind":13,"containerName":"next_result","name":"$self","line":1231},{"line":1233,"name":"$querytype","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1234},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$name","line":1237},{"line":1237,"name":"$descr","containerName":"next_result","kind":13},{"line":1238,"name":"$querydef","containerName":"next_result","kind":13},{"line":1239,"name":"$self","kind":13,"containerName":"next_result"},{"line":1239,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$name","line":1243},{"line":1245,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1245},{"line":1249,"name":"$descr","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$querylen","line":1251},{"kind":13,"containerName":"next_result","name":"$self","line":1252},{"containerName":"next_result","kind":12,"name":"element","line":1252},{"line":1256,"kind":13,"containerName":"next_result","name":"$querylen"},{"line":1260,"containerName":"next_result","kind":13,"name":"$self"},{"line":1260,"name":"warn","containerName":"next_result","kind":12},{"line":1262,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","containerName":"next_result","kind":12,"line":1262},{"containerName":"next_result","kind":13,"name":"$self","line":1265},{"line":1265,"kind":12,"containerName":"next_result","name":"element"},{"line":1275,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"in_element","line":1275},{"definition":"my","line":1276,"localvar":"my","kind":13,"containerName":"next_result","name":"@data"},{"definition":"my","line":1277,"kind":13,"localvar":"my","containerName":"next_result","name":"$count"},{"containerName":"next_result","localvar":"my","kind":13,"name":"$len","line":1278,"definition":"my"},{"line":1278,"name":"$self","kind":13,"containerName":"next_result"},{"name":"idlength","kind":12,"containerName":"next_result","line":1278},{"name":"$seq1_id","containerName":"next_result","localvar":"my","kind":13,"line":1279,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":1284},{"kind":12,"containerName":"next_result","name":"_pushback","line":1284},{"containerName":"next_result","kind":13,"name":"$self","line":1288},{"containerName":"next_result","kind":12,"name":"end_element","line":1288},{"kind":13,"containerName":"next_result","name":"$self","line":1292},{"kind":12,"containerName":"next_result","name":"_pushback","line":1292},{"containerName":"next_result","kind":13,"name":"$self","line":1296},{"line":1296,"name":"_pushback","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$count","line":1299},{"line":1301,"containerName":"next_result","kind":13,"name":"$self"},{"line":1301,"kind":12,"containerName":"next_result","name":"_pushback"},{"line":1302,"name":"$count","kind":13,"containerName":"next_result"},{"line":1309,"kind":13,"containerName":"next_result","name":"$count"},{"line":1312,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"_pushback","line":1312},{"line":1313,"name":"$count","kind":13,"containerName":"next_result"},{"name":"$count","kind":13,"containerName":"next_result","line":1316},{"line":1316,"containerName":"next_result","kind":13,"name":"$count"},{"name":"$len","containerName":"next_result","kind":13,"line":1318},{"name":"$len","containerName":"next_result","kind":13,"line":1318},{"containerName":"next_result","kind":13,"name":"$data","line":1320},{"line":1320,"kind":13,"containerName":"next_result","name":"$count"},{"line":1320,"containerName":"next_result","kind":13,"name":"$len"},{"line":1323,"name":"$count","kind":13,"containerName":"next_result"},{"line":1324,"name":"$self","kind":13,"containerName":"next_result"},{"name":"_pushback","kind":12,"containerName":"next_result","line":1324},{"line":1327,"kind":13,"containerName":"next_result","name":"$count"},{"name":"$self","kind":13,"containerName":"next_result","line":1332},{"line":1332,"kind":12,"containerName":"next_result","name":"throw"},{"line":1336,"name":"$count","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":1338},{"line":1338,"kind":12,"containerName":"next_result","name":"warn"},{"line":1338,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"verbose","line":1338},{"line":1343,"kind":13,"containerName":"next_result","name":"$data"},{"name":"$data","kind":13,"containerName":"next_result","line":1343},{"name":"$count","containerName":"next_result","kind":13,"line":1344},{"containerName":"next_result","kind":13,"name":"$len","line":1349},{"name":"$data","containerName":"next_result","kind":13,"line":1350},{"containerName":"next_result","kind":13,"name":"$count","line":1350},{"line":1350,"containerName":"next_result","kind":13,"name":"$len"}],"containerName":"main::","name":"next_result"},{"kind":12,"name":"labels","line":434},{"line":451,"name":"lframe","kind":12},{"line":459,"name":"lframe","kind":12},{"name":"hit_len","kind":12,"line":463},{"name":"hit_len","kind":12,"line":470},{"kind":12,"name":"WRAPPED","line":571},{"kind":12,"name":"WRAPPED","line":576},{"kind":12,"name":"evalue","line":635},{"kind":12,"name":"bits","line":641},{"kind":12,"name":"evalue","line":655},{"name":"bits","kind":12,"line":661},{"name":"qgaps","kind":12,"line":736},{"line":737,"kind":12,"name":"qgaps"},{"line":739,"name":"lgaps","kind":12},{"line":740,"kind":12,"name":"lgaps"},{"name":"ax0","kind":12,"line":746},{"line":746,"kind":12,"name":"an0"},{"line":764,"kind":12,"name":"ax1"},{"name":"an1","kind":12,"line":764},{"kind":12,"name":"lframe","line":787},{"line":798,"name":"lframe","kind":12},{"line":844,"name":"hit_len","kind":12},{"name":"hit_len","kind":12,"line":846},{"kind":12,"name":"id","line":850},{"kind":12,"name":"id","line":852},{"line":856,"kind":12,"name":"acc"},{"line":858,"kind":12,"name":"acc"},{"kind":12,"name":"desc","line":862},{"kind":12,"name":"desc","line":864},{"kind":12,"name":"evalue","line":868},{"line":870,"kind":12,"name":"evalue"},{"kind":12,"name":"bits","line":874},{"name":"bits","kind":12,"line":876},{"name":"evalue","kind":12,"line":883},{"kind":12,"name":"evalue","line":884},{"line":886,"kind":12,"name":"bits"},{"name":"bits","kind":12,"line":887},{"line":889,"name":"sw","kind":12},{"line":890,"name":"sw","kind":12},{"name":"alen","kind":12,"line":898},{"line":900,"kind":12,"name":"alen"},{"name":"alen","kind":12,"line":907},{"line":909,"name":"alen","kind":12},{"line":916,"name":"alen","kind":12},{"line":918,"kind":12,"name":"alen"},{"name":"alen","kind":12,"line":921},{"line":922,"kind":12,"name":"alen"},{"line":924,"name":"an0","kind":12},{"line":925,"name":"an0","kind":12},{"line":927,"kind":12,"name":"ax0"},{"line":928,"kind":12,"name":"ax0"},{"line":930,"kind":12,"name":"an1"},{"line":931,"name":"an1","kind":12},{"line":933,"name":"ax1","kind":12},{"line":934,"kind":12,"name":"ax1"},{"kind":12,"name":"qgaps","line":937},{"line":938,"kind":12,"name":"qgaps"},{"line":940,"kind":12,"name":"lgaps"},{"line":941,"kind":12,"name":"lgaps"},{"name":"ax0","kind":12,"line":947},{"line":947,"kind":12,"name":"an0"},{"name":"ax1","kind":12,"line":965},{"line":965,"name":"an1","kind":12},{"name":"lframe","kind":12,"line":988},{"name":"lframe","kind":12,"line":1001},{"kind":12,"name":"hit_len","line":1030},{"line":1032,"kind":12,"name":"hit_len"},{"kind":12,"name":"id","line":1036},{"name":"id","kind":12,"line":1038},{"line":1042,"kind":12,"name":"acc"},{"line":1044,"name":"acc","kind":12},{"name":"desc","kind":12,"line":1048},{"name":"desc","kind":12,"line":1050},{"kind":12,"name":"evalue","line":1054},{"line":1056,"kind":12,"name":"evalue"},{"line":1060,"name":"bits","kind":12},{"name":"bits","kind":12,"line":1062},{"kind":12,"name":"evalue","line":1069},{"kind":12,"name":"evalue","line":1070},{"kind":12,"name":"bits","line":1072},{"name":"bits","kind":12,"line":1073},{"name":"sw","kind":12,"line":1075},{"line":1076,"name":"sw","kind":12},{"kind":12,"name":"alen","line":1084},{"kind":12,"name":"alen","line":1086},{"line":1093,"name":"alen","kind":12},{"name":"alen","kind":12,"line":1095},{"name":"alen","kind":12,"line":1102},{"name":"alen","kind":12,"line":1104},{"name":"alen","kind":12,"line":1107},{"line":1108,"kind":12,"name":"alen"},{"line":1110,"name":"an0","kind":12},{"line":1111,"kind":12,"name":"an0"},{"name":"ax0","kind":12,"line":1113},{"line":1114,"kind":12,"name":"ax0"},{"line":1116,"kind":12,"name":"an1"},{"line":1117,"kind":12,"name":"an1"},{"line":1119,"name":"ax1","kind":12},{"kind":12,"name":"ax1","line":1120},{"line":1125,"name":"qgaps","kind":12},{"kind":12,"name":"qgaps","line":1127},{"line":1129,"name":"lgaps","kind":12},{"name":"lgaps","kind":12,"line":1130},{"name":"ax0","kind":12,"line":1136},{"line":1136,"kind":12,"name":"an0"},{"line":1152,"name":"ax1","kind":12},{"line":1152,"name":"an1","kind":12},{"kind":12,"name":"lframe","line":1173},{"line":1187,"kind":12,"name":"lframe"},{"kind":12,"name":"Name","line":1288},{"name":"CORE","containerName":"length","kind":12,"line":1318},{"containerName":"length","kind":12,"name":"CORE","line":1318},{"line":1354,"name":"$count","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":1355},{"line":1355,"kind":12,"containerName":"main::","name":"_readline"},{"line":1357,"name":"@data","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@data","line":1357},{"kind":13,"containerName":null,"name":"$self","line":1358},{"containerName":"main::","kind":12,"name":"characters","line":1358},{"containerName":null,"kind":13,"name":"@data","line":1361},{"line":1364,"kind":13,"containerName":null,"name":"$self"},{"name":"characters","kind":12,"containerName":"main::","line":1364},{"line":1367,"name":"@data","kind":13,"containerName":null},{"line":1370,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"characters","line":1370},{"line":1373,"name":"@data","kind":13,"containerName":null},{"line":1379,"name":"%seentop","kind":13,"containerName":null},{"line":1380,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"debug","line":1380},{"line":1386,"kind":13,"containerName":null,"name":"$self"},{"line":1386,"name":"in_element","kind":12,"containerName":"main::"},{"line":1387,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"in_element","line":1387},{"line":1388,"kind":13,"containerName":null,"name":"$self"},{"line":1388,"kind":12,"containerName":"main::","name":"end_element"},{"line":1390,"name":"$self","containerName":null,"kind":13},{"name":"in_element","containerName":"main::","kind":12,"line":1390},{"line":1391,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"end_element","line":1391},{"name":"$self","containerName":null,"kind":13,"line":1393},{"kind":12,"containerName":"main::","name":"end_element","line":1393},{"line":1395,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"end_document","line":1395},{"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"},"line":1409,"range":{"end":{"character":9999,"line":1421},"start":{"character":0,"line":1409}},"kind":12,"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","line":1410,"name":"$self","kind":13,"localvar":"my","containerName":"start_element"},{"line":1410,"containerName":"start_element","kind":13,"name":"$data"},{"name":"$nm","localvar":"my","containerName":"start_element","kind":13,"line":1413,"definition":"my"},{"containerName":"start_element","kind":13,"name":"$data","line":1413},{"definition":"my","line":1414,"containerName":"start_element","localvar":"my","kind":13,"name":"$type"},{"name":"$MODEMAP","containerName":"start_element","kind":13,"line":1414},{"kind":13,"containerName":"start_element","name":"$nm","line":1414},{"line":1415,"name":"$self","kind":13,"containerName":"start_element"},{"name":"_mode","kind":12,"containerName":"start_element","line":1415},{"line":1415,"name":"$type","kind":13,"containerName":"start_element"},{"kind":13,"localvar":"my","containerName":"start_element","name":"$handler","line":1416,"definition":"my"},{"line":1416,"name":"$self","containerName":"start_element","kind":13},{"line":1416,"kind":12,"containerName":"start_element","name":"_will_handle"},{"kind":13,"containerName":"start_element","name":"$type","line":1416},{"definition":"my","line":1417,"localvar":"my","containerName":"start_element","kind":13,"name":"$func"},{"name":"$type","kind":13,"containerName":"start_element","line":1417},{"name":"$handler","kind":13,"containerName":"start_element","line":1418},{"line":1418,"name":"$func","containerName":"start_element","kind":13},{"line":1418,"containerName":"start_element","kind":13,"name":"$data"},{"line":1420,"name":"$self","containerName":"start_element","kind":13},{"line":1420,"containerName":"start_element","kind":13,"name":"$type"}],"name":"start_element","containerName":"main::"},{"containerName":null,"kind":13,"name":"%nm","line":1422},{"kind":13,"containerName":null,"name":"%self","line":1423},{"line":1424,"containerName":null,"kind":13,"name":"%self"},{"line":1425,"kind":13,"containerName":null,"name":"%self"},{"line":1441,"kind":12,"range":{"end":{"line":1467,"character":9999},"start":{"character":0,"line":1441}},"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"end_element($self,$data)"},"children":[{"definition":"my","line":1442,"kind":13,"localvar":"my","containerName":"end_element","name":"$self"},{"line":1442,"name":"$data","containerName":"end_element","kind":13},{"definition":"my","name":"$nm","localvar":"my","kind":13,"containerName":"end_element","line":1443},{"containerName":"end_element","kind":13,"name":"$data","line":1443},{"line":1444,"name":"$rc","containerName":"end_element","localvar":"my","kind":13,"definition":"my"},{"name":"$nm","kind":13,"containerName":"end_element","line":1448},{"line":1450,"kind":13,"containerName":"end_element","name":"$self"},{"line":1450,"kind":12,"containerName":"end_element","name":"element"},{"name":"$self","containerName":"end_element","kind":13,"line":1453},{"line":1457,"containerName":"end_element","kind":13,"name":"$self"},{"definition":"my","line":1460,"name":"$type","containerName":"end_element","localvar":"my","kind":13},{"containerName":"end_element","kind":13,"name":"$MODEMAP","line":1460},{"line":1460,"kind":13,"containerName":"end_element","name":"$nm"},{"name":"$handler","containerName":"end_element","localvar":"my","kind":13,"line":1461,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$self","line":1461},{"name":"_will_handle","containerName":"end_element","kind":12,"line":1461},{"containerName":"end_element","kind":13,"name":"$type","line":1461},{"definition":"my","line":1462,"containerName":"end_element","localvar":"my","kind":13,"name":"$func"},{"line":1462,"name":"$type","containerName":"end_element","kind":13},{"line":1463,"kind":13,"containerName":"end_element","name":"$rc"},{"kind":13,"containerName":"end_element","name":"$handler","line":1463},{"name":"$func","kind":13,"containerName":"end_element","line":1463},{"containerName":"end_element","kind":13,"name":"$self","line":1463},{"containerName":"end_element","kind":13,"name":"$self","line":1463},{"name":"$self","containerName":"end_element","kind":13,"line":1465}],"name":"end_element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"line":1468,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":1468,"name":"%nm","kind":13,"containerName":null},{"line":1469,"name":"%MAPPING","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%nm","line":1469},{"definition":"my","line":1470,"name":"$key","localvar":"my","containerName":null,"kind":13},{"line":1470,"name":"%MAPPING","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@nm","line":1470},{"name":"%self","kind":13,"containerName":null,"line":1471},{"name":"%key","containerName":null,"kind":13,"line":1471},{"line":1471,"name":"%MAPPING","containerName":null,"kind":13},{"name":"%nm","containerName":null,"kind":13,"line":1471},{"line":1471,"name":"$key","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":1472},{"line":1475,"name":"%self","kind":13,"containerName":null},{"line":1475,"containerName":null,"kind":13,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"$nm","line":1475},{"name":"%self","containerName":null,"kind":13,"line":1475},{"line":1479,"containerName":null,"kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"main::","line":1479},{"name":"%self","kind":13,"containerName":null,"line":1481},{"line":1483,"name":"%self","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$rc","line":1483},{"line":1483,"name":"$nm","kind":13,"containerName":null},{"name":"$rc","kind":13,"containerName":null,"line":1484},{"definition":"sub","detail":"($self,$data)","children":[{"localvar":"my","kind":13,"containerName":"element","name":"$self","line":1500,"definition":"my"},{"line":1500,"name":"$data","kind":13,"containerName":"element"},{"name":"$self","containerName":"element","kind":13,"line":1501},{"containerName":"element","kind":12,"name":"start_element","line":1501},{"name":"$data","kind":13,"containerName":"element","line":1501},{"line":1502,"containerName":"element","kind":13,"name":"$self"},{"containerName":"element","kind":12,"name":"characters","line":1502},{"line":1502,"name":"$data","containerName":"element","kind":13},{"line":1503,"name":"$self","kind":13,"containerName":"element"},{"kind":12,"containerName":"element","name":"end_element","line":1503},{"kind":13,"containerName":"element","name":"$data","line":1503}],"containerName":"main::","name":"element","signature":{"label":"element($self,$data)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}]},"line":1499,"range":{"end":{"line":1504,"character":9999},"start":{"line":1499,"character":0}},"kind":12},{"signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]},"line":1517,"kind":12,"range":{"end":{"line":1533,"character":9999},"start":{"character":0,"line":1517}},"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","localvar":"my","containerName":"characters","kind":13,"name":"$self","line":1518},{"kind":13,"containerName":"characters","name":"$data","line":1518},{"line":1520,"name":"$data","kind":13,"containerName":"characters"},{"name":"$data","containerName":"characters","kind":13,"line":1521},{"line":1522,"name":"$data","containerName":"characters","kind":13},{"containerName":"characters","kind":13,"name":"$self","line":1525},{"line":1525,"kind":12,"containerName":"characters","name":"in_element"},{"name":"$data","containerName":"characters","kind":13,"line":1526},{"kind":13,"containerName":"characters","name":"$self","line":1529},{"line":1529,"name":"$data","kind":13,"containerName":"characters"},{"line":1529,"kind":13,"containerName":"characters","name":"$data"},{"containerName":"characters","kind":13,"name":"$self","line":1532},{"name":"$data","containerName":"characters","kind":13,"line":1532}],"containerName":"main::","name":"characters"},{"kind":12,"range":{"end":{"character":9999,"line":1553},"start":{"character":0,"line":1547}},"line":1547,"signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_mode($self,$value)"},"containerName":"main::","name":"_mode","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_mode","name":"$self","line":1548},{"line":1548,"containerName":"_mode","kind":13,"name":"$value"},{"line":1549,"name":"$value","kind":13,"containerName":"_mode"},{"kind":13,"containerName":"_mode","name":"$self","line":1550},{"kind":13,"containerName":"_mode","name":"$value","line":1550},{"containerName":"_mode","kind":13,"name":"$self","line":1552}],"detail":"($self,$value)","definition":"sub"},{"definition":"sub","detail":"($self,$name)","children":[{"localvar":"my","kind":13,"containerName":"within_element","name":"$self","line":1569,"definition":"my"},{"line":1569,"name":"$name","kind":13,"containerName":"within_element"},{"name":"$name","kind":13,"containerName":"within_element","line":1571},{"line":1571,"name":"$self","kind":13,"containerName":"within_element"},{"line":1572,"containerName":"within_element","kind":13,"name":"$self"}],"containerName":"main::","name":"within_element","signature":{"label":"within_element($self,$name)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"line":1568,"range":{"end":{"line":1572,"character":9999},"start":{"line":1568,"character":0}},"kind":12},{"name":"%self","kind":13,"containerName":null,"line":1573},{"line":1574,"containerName":null,"kind":13,"name":"$name"},{"name":"%MODEMAP","containerName":null,"kind":13,"line":1574},{"line":1574,"name":"%name","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$name)","children":[{"definition":"my","localvar":"my","containerName":"in_element","kind":13,"name":"$self","line":1595},{"line":1595,"kind":13,"containerName":"in_element","name":"$name"},{"name":"$self","containerName":"in_element","kind":13,"line":1596},{"name":"$self","containerName":"in_element","kind":13,"line":1598},{"name":"$name","kind":13,"containerName":"in_element","line":1599},{"name":"$MODEMAP","containerName":"in_element","kind":13,"line":1599},{"kind":13,"containerName":"in_element","name":"$name","line":1599},{"line":1600,"name":"$self","containerName":"in_element","kind":13},{"containerName":"in_element","kind":13,"name":"$MODEMAP","line":1600},{"name":"$name","kind":13,"containerName":"in_element","line":1600}],"name":"in_element","containerName":"main::","signature":{"label":"in_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name "},"line":1594,"range":{"start":{"character":0,"line":1594},"end":{"character":9999,"line":1602}},"kind":12},{"line":1615,"range":{"start":{"line":1615,"character":0},"end":{"character":9999,"line":1622}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","label":"start_document($self)"},"children":[{"line":1616,"kind":13,"localvar":"my","containerName":"start_document","name":"$self","definition":"my"},{"kind":13,"containerName":"start_document","name":"$self","line":1617},{"line":1618,"kind":13,"containerName":"start_document","name":"$self"},{"line":1619,"containerName":"start_document","kind":13,"name":"$self"},{"kind":13,"containerName":"start_document","name":"$self","line":1620},{"line":1621,"name":"$self","containerName":"start_document","kind":13}],"name":"start_document","containerName":"main::","definition":"sub","detail":"($self)"},{"kind":12,"range":{"start":{"line":1635,"character":0},"end":{"character":9999,"line":1638}},"line":1635,"signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"end_document($self,@args)"},"name":"end_document","containerName":"main::","children":[{"definition":"my","containerName":"end_document","localvar":"my","kind":13,"name":"$self","line":1636},{"name":"@args","kind":13,"containerName":"end_document","line":1636},{"name":"$self","containerName":"end_document","kind":13,"line":1637}],"detail":"($self,@args)","definition":"sub"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"idlength","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"idlength","name":"$self","line":1654},{"name":"$value","kind":13,"containerName":"idlength","line":1654},{"name":"$value","containerName":"idlength","kind":13,"line":1655},{"line":1656,"containerName":"idlength","kind":13,"name":"$self"},{"line":1656,"name":"$value","kind":13,"containerName":"idlength"},{"line":1658,"kind":13,"containerName":"idlength","name":"$self"},{"line":1658,"kind":13,"containerName":"idlength","name":"$IDLENGTH"}],"signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document {\n    my ( $self, @args ) = @_;\n    return $self->{'_result'};\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : $obj->idlength($newval)\n Function: Internal storage of the length of the ID desc\n           in the HSP alignment blocks.  Defaults to\n           $IDLENGTH class variable value\n Returns : value of idlength\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"idlength($self,$value)"},"kind":12,"range":{"start":{"line":1653,"character":0},"end":{"line":1659,"character":9999}},"line":1653},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"result_count","localvar":"my","kind":13,"line":1672},{"containerName":"result_count","kind":13,"name":"$self","line":1673}],"name":"result_count","containerName":"main::","line":1671,"kind":12,"range":{"end":{"line":1674,"character":9999},"start":{"character":0,"line":1671}}},{"kind":12,"range":{"end":{"character":9999,"line":1686},"start":{"character":0,"line":1676}},"line":1676,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$handler"}],"label":"attach_EventHandler($self,$handler)"},"containerName":"main::","name":"attach_EventHandler","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"attach_EventHandler","line":1677},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":1677},{"line":1679,"containerName":"attach_EventHandler","kind":13,"name":"$self"},{"line":1679,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"kind":13,"containerName":"attach_EventHandler","name":"$self","line":1684},{"line":1684,"name":"$handler","kind":13,"containerName":"attach_EventHandler"}],"detail":"($self,$handler)","definition":"sub"},{"line":1679,"name":"SUPER","containerName":"attach_EventHandler","kind":12},{"detail":"($self,$type)","definition":"sub","name":"_will_handle","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_will_handle","name":"$self","line":1727},{"line":1727,"name":"$type","kind":13,"containerName":"_will_handle"},{"definition":"my","name":"$handler","localvar":"my","containerName":"_will_handle","kind":13,"line":1728},{"containerName":"_will_handle","kind":13,"name":"$self","line":1728},{"definition":"my","name":"$will_handle","localvar":"my","kind":13,"containerName":"_will_handle","line":1729},{"line":1730,"kind":13,"containerName":"_will_handle","name":"$self"},{"line":1730,"kind":13,"containerName":"_will_handle","name":"$type"},{"line":1731,"name":"$self","containerName":"_will_handle","kind":13},{"kind":13,"containerName":"_will_handle","name":"$type","line":1731},{"line":1732,"name":"$self","kind":13,"containerName":"_will_handle"},{"line":1732,"name":"$type","containerName":"_will_handle","kind":13},{"line":1733,"containerName":"_will_handle","kind":13,"name":"$handler"},{"kind":12,"containerName":"_will_handle","name":"will_handle","line":1733},{"kind":13,"containerName":"_will_handle","name":"$type","line":1733},{"line":1735,"kind":13,"containerName":"_will_handle","name":"$will_handle"},{"containerName":"_will_handle","kind":13,"name":"$handler","line":1735}],"signature":{"label":"_will_handle($self,$type)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document {\n    my ( $self, @args ) = @_;\n    return $self->{'_result'};\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : $obj->idlength($newval)\n Function: Internal storage of the length of the ID desc\n           in the HSP alignment blocks.  Defaults to\n           $IDLENGTH class variable value\n Returns : value of idlength\n Args    : newvalue (optional)\n\n\n\nsub idlength {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_idlength'} = $value;\n    }\n    return $self->{'_idlength'} || $IDLENGTH;\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\nsub attach_EventHandler {\n    my ( $self, $handler ) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);\n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","parameters":[{"label":"$self"},{"label":"$type"}]},"range":{"end":{"character":9999,"line":1736},"start":{"line":1726,"character":0}},"kind":12,"line":1726}],"version":5}