{"version":5,"vars":[{"line":121,"name":"base","containerName":"","kind":2},{"name":"$DEBUG","kind":13,"containerName":"main::","line":128,"definition":"our"},{"name":"%VALID_TYPE","localvar":"my","containerName":null,"kind":13,"line":130,"definition":"my"},{"line":130,"name":"IteratedSearchResultEventBuilder","kind":2,"containerName":"Bio::Root::Root::XML::SAX::IO::File::Bio::SearchIO::XML::BlastHandler::Bio::SearchIO"},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":161,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self"},{"line":161,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":162},{"line":162,"name":"@args","kind":13,"containerName":"_initialize"},{"line":163,"containerName":"_initialize","localvar":"my","kind":13,"name":"$usetempfile","definition":"my"},{"line":163,"name":"$blasttype","containerName":"_initialize","kind":13},{"line":163,"name":"$xmlcompact","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":163},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":163},{"line":167,"name":"@args","containerName":"_initialize","kind":13},{"name":"$blasttype","kind":13,"containerName":"_initialize","line":168},{"line":169,"containerName":"_initialize","kind":13,"name":"$self"},{"line":169,"containerName":"_initialize","kind":13,"name":"$xmlcompact"},{"line":170,"name":"$self","containerName":"_initialize","kind":13},{"line":170,"kind":12,"containerName":"_initialize","name":"blasttype"},{"line":170,"containerName":"_initialize","kind":13,"name":"$blasttype"},{"line":171,"containerName":"_initialize","kind":13,"name":"$usetempfile"},{"kind":13,"containerName":"_initialize","name":"$self","line":171},{"line":171,"name":"use_tempfile","containerName":"_initialize","kind":12},{"containerName":"_initialize","kind":13,"name":"$usetempfile","line":171},{"line":172,"containerName":"_initialize","kind":13,"name":"$self"},{"line":174,"name":"$DEBUG","kind":13,"containerName":"_initialize"},{"line":175,"name":"$DEBUG","containerName":"_initialize","kind":13},{"line":175,"containerName":"_initialize","kind":13,"name":"$DEBUG"},{"line":175,"kind":13,"containerName":"_initialize","name":"$self"},{"line":175,"name":"verbose","kind":12,"containerName":"_initialize"}],"containerName":"main::","name":"_initialize","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: blastxml.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blastxml\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blastxml - A SearchIO implementation of NCBI Blast XML parsing. \n\n=head1 SYNOPSIS\n\n    use Bio::SearchIO;\n    my $searchin = Bio::SearchIO->new(-format => 'blastxml',\n\t\t\t\t     -file   => 't/data/plague_yeast.bls.xml');\n    while( my $result = $searchin->next_result ) {\n    }\n\n    # one can also request that the parser NOT keep the XML data in memory\n    # by using the tempfile initialization flag.\n    my $searchin = Bio::SearchIO->new(-tempfile => 1,\n\t\t\t\t     -format => 'blastxml',\n\t\t\t\t     -file   => 't/data/plague_yeast.bls.xml');\n    while( my $result = $searchin->next_result ) {\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a NCBI Blast XML parser.  It requires XML::SAX; it is\nalso recommended (for faster parsing) that XML::SAX::ExpatXS or XML::LibXML\nbe installed.  Either 'XML::SAX::ExpatXS' or 'XML::LibXML::SAX::Parser' should\nbe set as the default parser in ParserDetails.ini.  This file is located in the\nSAX subdirectory of XML in your local perl library (normally in the 'site'\ndirectory).\n\nCurrently, XML::SAX::Expat will not work and will not be supported.\n\nThere is one additional initialization flag from the SearchIO defaults-\nthat is the -tempfile flag.  If specified as true, then the parser\nwill write out each report to a temporary filehandle rather than\nholding the entire report as a string in memory.  The reason this is\ndone in the first place is NCBI reports have an uncessary E<lt>?xml\nversion=\"1.0\"?E<gt> at the beginning of each report and RPS-BLAST reports\nhave an additional unecessary RPS-BLAST tag at the top of each report.\nSo we currently have implemented the work around by preparsing the\nfile (yes it makes the process slower, but it works).\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX\n\nIt is also recommended that XML::SAX::ExpatXS be installed and made the default\nXML::SAX parser using , along with the Expat library () for faster parsing.\nXML::SAX::Expat is not recommended; XML::SAX::ExpatXS is considered the current\nreplacement for XML::SAX:Expat and is actively being considered to replace\nXML::SAX::Expat. XML::SAX::Expat will work, but only if you have local copies of\nthe NCBI BLAST DTDs. This is due to issues with NCBI's BLAST XML format. The\nDTDs and the web address to obtain them are:\n\n  NCBI_BlastOutput.dtd\t    \n  NCBI_BlastOutput.mod.dtd\n\n  http://www.ncbi.nlm.nih.gov/data_specs/dtd/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::blastxml;\nuse strict;\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\nuse Bio::Root::Root;\nuse XML::SAX;\nuse IO::File;\nuse Bio::SearchIO::XML::BlastHandler;\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\n\nour $DEBUG;\n\nmy %VALID_TYPE = (\n    'BLAST'      => 'Bio::SearchIO::XML::BlastHandler',\n    'PSIBLAST'   => 'Bio::SearchIO::XML::PsiBlastHandler',\n    'PSI-BLAST'  => 'Bio::SearchIO::XML::PsiBlastHandler'\n    );\n\n# mapping of NCBI Blast terms to Bioperl hash keys\n\n=head2 new\n\n Title   : new\n Usage   : my $searchio = Bio::SearchIO->new(-format => 'blastxml',\n\t\t\t\t\t    -file   => 'filename',\n\t\t\t\t\t    -tempfile => 1);\n Function: Initializes the object - this is chained through new in SearchIO\n Returns : Bio::SearchIO::blastxml object\n Args    : One additional argument from the format and file/fh parameters.\n           -tempfile    => boolean.  Defaults to false.  Write out XML data\n                           to a temporary filehandle to send to PerlSAX parser.\n\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : private\n Function: Initializes the object - this is chained through new in SearchIO","label":"_initialize($self,@args)"},"line":160,"range":{"end":{"character":9999,"line":176},"start":{"line":160,"character":0}},"kind":12},{"kind":12,"containerName":"_initialize","name":"SUPER","line":162},{"line":169,"kind":12,"name":"_xml_compact"},{"name":"_result_count","kind":12,"line":172},{"line":174,"name":"Time","kind":12,"containerName":"HiRes"},{"range":{"start":{"character":0,"line":188},"end":{"character":9999,"line":255}},"kind":12,"line":188,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"next_result($self)"},"name":"next_result","containerName":"main::","children":[{"name":"$self","containerName":"next_result","localvar":"my","kind":13,"line":189,"definition":"my"},{"line":191,"name":"$result","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":193,"kind":13,"localvar":"my","containerName":"next_result","name":"$tfh"},{"containerName":"next_result","kind":13,"name":"$self","line":198},{"line":199,"containerName":"next_result","kind":13,"name":"$self"},{"line":199,"kind":12,"containerName":"next_result","name":"debug"},{"definition":"my","line":200,"kind":13,"localvar":"my","containerName":"next_result","name":"$tfh2"},{"line":200,"kind":13,"containerName":"next_result","name":"$filename"},{"kind":12,"containerName":"next_result","name":"new_tmpfile","line":200},{"name":"$self","kind":13,"containerName":"next_result","line":200},{"line":200,"name":"throw","containerName":"next_result","kind":12},{"line":201,"name":"$tfh2","containerName":"next_result","kind":13},{"line":201,"name":"autoflush","kind":12,"containerName":"next_result"},{"line":202,"localvar":"my","containerName":"next_result","kind":13,"name":"$fh","definition":"my"},{"line":202,"kind":13,"containerName":"next_result","name":"$self"},{"line":202,"name":"_fh","containerName":"next_result","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$line","line":203},{"name":"$fh","kind":13,"containerName":"next_result","line":203},{"line":204,"name":"$line","kind":13,"containerName":"next_result"},{"name":"$tfh2","kind":13,"containerName":"next_result","line":205},{"containerName":"next_result","kind":13,"name":"$line","line":205},{"line":207,"containerName":"next_result","kind":13,"name":"$tfh2"},{"name":"$fh","kind":13,"containerName":"next_result","line":208},{"name":"$self","containerName":"next_result","kind":13,"line":210},{"kind":12,"containerName":"next_result","name":"_fh","line":210},{"name":"$tfh2","containerName":"next_result","kind":13,"line":210},{"line":213,"name":"$self","kind":13,"containerName":"next_result"},{"line":213,"name":"use_tempfile","kind":12,"containerName":"next_result"},{"line":214,"containerName":"next_result","kind":13,"name":"$tfh"},{"line":214,"name":"new_tmpfile","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":214},{"line":214,"name":"throw","containerName":"next_result","kind":12},{"line":215,"name":"$tfh","containerName":"next_result","kind":13},{"line":215,"name":"autoflush","kind":12,"containerName":"next_result"},{"line":218,"localvar":"my","kind":13,"containerName":"next_result","name":"$okaytoprocess","definition":"my"},{"line":218,"name":"$self","kind":13,"containerName":"next_result"},{"name":"blasttype","kind":12,"containerName":"next_result","line":218},{"kind":13,"containerName":"next_result","name":"$self","line":218},{"name":"_chunk_psiblast","kind":12,"containerName":"next_result","line":218},{"kind":13,"containerName":"next_result","name":"$tfh","line":218},{"containerName":"next_result","kind":13,"name":"$self","line":219},{"kind":12,"containerName":"next_result","name":"_chunk_normalblast","line":219},{"line":219,"name":"$tfh","containerName":"next_result","kind":13},{"line":221,"name":"$okaytoprocess","containerName":"next_result","kind":13},{"line":223,"containerName":"next_result","localvar":"my","kind":13,"name":"%parser_args","definition":"my"},{"name":"$tfh","containerName":"next_result","kind":13,"line":224},{"kind":13,"containerName":"next_result","name":"$tfh","line":225},{"line":226,"name":"%parser_args","containerName":"next_result","kind":13},{"name":"$tfh","containerName":"next_result","kind":13,"line":226},{"kind":13,"containerName":"next_result","name":"%parser_args","line":228},{"line":228,"name":"$self","kind":13,"containerName":"next_result"},{"line":231,"name":"$starttime","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":232,"name":"$DEBUG","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$starttime","line":232},{"containerName":"next_result","kind":13,"name":"$result","line":235},{"name":"$self","kind":13,"containerName":"next_result","line":235},{"line":235,"name":"parse","kind":12,"containerName":"next_result"},{"name":"%parser_args","kind":13,"containerName":"next_result","line":235},{"name":"$self","containerName":"next_result","kind":13,"line":239},{"line":239,"containerName":"next_result","kind":12,"name":"warn"},{"line":240,"kind":13,"containerName":"next_result","name":"$result"},{"line":242,"name":"$DEBUG","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":243},{"line":243,"name":"debug","kind":12,"containerName":"next_result"},{"line":243,"name":"$starttime","kind":13,"containerName":"next_result"},{"name":"$result","kind":13,"containerName":"next_result","line":247},{"line":250,"name":"$self","containerName":"next_result","kind":13},{"line":251,"containerName":"next_result","kind":13,"name":"$result"}],"detail":"($self)","definition":"sub"},{"kind":12,"name":"_xml_compact","line":198},{"line":200,"name":"IO","containerName":"File","kind":12},{"line":214,"name":"IO","containerName":"File","kind":12},{"name":"Time","kind":12,"containerName":"HiRes::gettimeofday","line":232},{"line":243,"containerName":"HiRes::tv_interval","kind":12,"name":"Time"},{"line":250,"name":"_result_count","kind":12},{"name":"result_count","containerName":"main::","children":[{"containerName":"result_count","localvar":"my","kind":13,"name":"$self","line":271,"definition":"my"},{"name":"$self","containerName":"result_count","kind":13,"line":272}],"definition":"sub","kind":12,"range":{"start":{"line":270,"character":0},"end":{"character":9999,"line":273}},"line":270},{"name":"_result_count","kind":12,"line":272},{"signature":{"label":"use_tempfile($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]},"line":286,"kind":12,"range":{"end":{"character":9999,"line":292},"start":{"character":0,"line":286}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":287,"localvar":"my","containerName":"use_tempfile","kind":13,"name":"$self"},{"line":287,"kind":13,"containerName":"use_tempfile","name":"$value"},{"line":288,"name":"$value","kind":13,"containerName":"use_tempfile"},{"line":289,"name":"$self","containerName":"use_tempfile","kind":13},{"line":289,"name":"$value","containerName":"use_tempfile","kind":13},{"line":291,"name":"$self","kind":13,"containerName":"use_tempfile"}],"name":"use_tempfile","containerName":"main::"},{"range":{"start":{"line":307,"character":0},"end":{"line":342,"character":9999}},"kind":12,"line":307,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"blasttype($self,$value)"},"name":"blasttype","containerName":"main::","children":[{"line":308,"name":"$self","containerName":"blasttype","localvar":"my","kind":13,"definition":"my"},{"line":308,"name":"$value","kind":13,"containerName":"blasttype"},{"line":309,"name":"$value","kind":13,"containerName":"blasttype"},{"name":"$self","kind":13,"containerName":"blasttype","line":310},{"line":310,"containerName":"blasttype","kind":12,"name":"throw"},{"line":310,"kind":13,"containerName":"blasttype","name":"$VALID_TYPE"},{"containerName":"blasttype","kind":13,"name":"$value","line":310},{"definition":"my","name":"$ok","containerName":"blasttype","localvar":"my","kind":13,"line":311},{"line":313,"containerName":"blasttype","kind":13,"name":"$ok"},{"line":313,"containerName":"blasttype","kind":13,"name":"$self"},{"name":"_load_module","kind":12,"containerName":"blasttype","line":313},{"name":"$VALID_TYPE","kind":13,"containerName":"blasttype","line":313},{"name":"$value","kind":13,"containerName":"blasttype","line":313},{"line":321,"containerName":"blasttype","kind":13,"name":"$ok"},{"definition":"my","localvar":"my","containerName":"blasttype","kind":13,"name":"$xmlhandler","line":324},{"line":324,"name":"$VALID_TYPE","containerName":"blasttype","kind":13},{"containerName":"blasttype","kind":13,"name":"$value","line":324},{"name":"new","containerName":"blasttype","kind":12,"line":324},{"kind":13,"containerName":"blasttype","name":"$self","line":324},{"line":324,"name":"verbose","kind":12,"containerName":"blasttype"},{"containerName":"blasttype","kind":13,"name":"$value","line":327},{"line":328,"containerName":"blasttype","localvar":"my","kind":13,"name":"$handler","definition":"my"},{"containerName":"blasttype","kind":12,"name":"new","line":328},{"line":329,"containerName":"blasttype","kind":13,"name":"$self"},{"name":"$handler","containerName":"blasttype","kind":13,"line":329},{"line":331,"kind":13,"containerName":"blasttype","name":"$xmlhandler"},{"line":331,"containerName":"blasttype","kind":12,"name":"eventHandler"},{"line":331,"containerName":"blasttype","kind":13,"name":"$self"},{"line":331,"kind":12,"containerName":"blasttype","name":"_eventHandler"},{"line":334,"kind":13,"localvar":"my","containerName":"blasttype","name":"$parserfactory","definition":"my"},{"line":334,"containerName":"blasttype","kind":12,"name":"parser"},{"line":335,"name":"$xmlhandler","kind":13,"containerName":"blasttype"},{"containerName":"blasttype","kind":13,"name":"$self","line":336},{"kind":13,"containerName":"blasttype","name":"$parserfactory","line":336},{"line":337,"kind":13,"containerName":"blasttype","name":"$self"},{"name":"saxparser","kind":12,"containerName":"blasttype","line":337},{"name":"$parserfactory","kind":13,"containerName":"blasttype","line":337},{"line":339,"kind":13,"containerName":"blasttype","name":"$self"},{"line":339,"name":"$value","containerName":"blasttype","kind":13},{"line":341,"kind":13,"containerName":"blasttype","name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"line":328,"name":"Bio","kind":12,"containerName":"SearchIO::IteratedSearchResultEventBuilder"},{"containerName":"SAX::ParserFactory","kind":12,"name":"XML","line":334},{"line":335,"kind":12,"name":"Handler"},{"definition":"sub","children":[{"line":345,"localvar":"my","kind":13,"containerName":"saxparser","name":"$self","definition":"my"},{"line":346,"name":"$self","kind":13,"containerName":"saxparser"}],"containerName":"main::","name":"saxparser","line":344,"kind":12,"range":{"start":{"line":344,"character":0},"end":{"line":347,"character":9999}}},{"signature":{"label":"_chunk_normalblast($self,$tfh)","documentation":"","parameters":[{"label":"$self"},{"label":"$tfh"}]},"range":{"end":{"character":9999,"line":404},"start":{"character":0,"line":349}},"kind":12,"line":349,"detail":"($self,$tfh)","definition":"sub","name":"_chunk_normalblast","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_chunk_normalblast","kind":13,"name":"$self","line":350},{"line":350,"name":"$tfh","kind":13,"containerName":"_chunk_normalblast"},{"name":"$self","containerName":"_chunk_normalblast","kind":13,"line":354},{"definition":"my","line":356,"name":"$sawxmlheader","kind":13,"localvar":"my","containerName":"_chunk_normalblast"},{"line":356,"kind":13,"containerName":"_chunk_normalblast","name":"$okaytoprocess"},{"definition":"my","line":358,"name":"$mode","localvar":"my","kind":13,"containerName":"_chunk_normalblast"},{"localvar":"my","kind":13,"containerName":"_chunk_normalblast","name":"$tail","line":360,"definition":"my"},{"definition":"my","containerName":"_chunk_normalblast","localvar":"my","kind":13,"name":"$fh","line":366},{"line":366,"name":"$self","containerName":"_chunk_normalblast","kind":13},{"line":366,"name":"_fh","containerName":"_chunk_normalblast","kind":12},{"definition":"my","line":369,"kind":13,"localvar":"my","containerName":"_chunk_normalblast","name":"$line"},{"kind":13,"containerName":"_chunk_normalblast","name":"$fh","line":369},{"containerName":"_chunk_normalblast","kind":13,"name":"$line","line":370},{"line":370,"containerName":"_chunk_normalblast","kind":13,"name":"$line"},{"line":371,"name":"$line","containerName":"_chunk_normalblast","kind":13},{"line":372,"containerName":"_chunk_normalblast","kind":13,"name":"$self"},{"line":374,"name":"$line","containerName":"_chunk_normalblast","kind":13},{"name":"$self","kind":13,"containerName":"_chunk_normalblast","line":375},{"kind":13,"containerName":"_chunk_normalblast","name":"$self","line":375},{"line":376,"containerName":"_chunk_normalblast","kind":13,"name":"$sawxmlheader"},{"line":377,"name":"$mode","kind":13,"containerName":"_chunk_normalblast"},{"line":378,"kind":13,"containerName":"_chunk_normalblast","name":"$line"},{"kind":13,"containerName":"_chunk_normalblast","name":"$sawxmlheader","line":379},{"line":380,"name":"$tfh","kind":13,"containerName":"_chunk_normalblast"},{"name":"$tfh","kind":13,"containerName":"_chunk_normalblast","line":381},{"line":381,"name":"$self","kind":13,"containerName":"_chunk_normalblast"},{"name":"$self","kind":13,"containerName":"_chunk_normalblast","line":383},{"line":383,"containerName":"_chunk_normalblast","kind":13,"name":"$self"},{"containerName":"_chunk_normalblast","kind":13,"name":"$mode","line":386},{"name":"$line","kind":13,"containerName":"_chunk_normalblast","line":387},{"line":388,"name":"$tfh","kind":13,"containerName":"_chunk_normalblast"},{"line":389,"name":"$tfh","containerName":"_chunk_normalblast","kind":13},{"line":389,"containerName":"_chunk_normalblast","kind":13,"name":"$line"},{"line":389,"name":"$tail","kind":13,"containerName":"_chunk_normalblast"},{"line":391,"name":"$self","kind":13,"containerName":"_chunk_normalblast"},{"line":391,"kind":13,"containerName":"_chunk_normalblast","name":"$line"},{"kind":13,"containerName":"_chunk_normalblast","name":"$tail","line":391},{"kind":13,"containerName":"_chunk_normalblast","name":"$okaytoprocess","line":393},{"kind":13,"containerName":"_chunk_normalblast","name":"$tfh","line":396},{"line":397,"kind":13,"containerName":"_chunk_normalblast","name":"$tfh"},{"name":"$line","containerName":"_chunk_normalblast","kind":13,"line":397},{"line":399,"kind":13,"containerName":"_chunk_normalblast","name":"$self"},{"line":399,"kind":13,"containerName":"_chunk_normalblast","name":"$line"},{"line":401,"containerName":"_chunk_normalblast","kind":13,"name":"$self"},{"kind":13,"containerName":"_chunk_normalblast","name":"$line","line":401},{"line":401,"containerName":"_chunk_normalblast","kind":13,"name":"$mode"},{"line":403,"name":"$okaytoprocess","containerName":"_chunk_normalblast","kind":13}]},{"detail":"($self,$tfh)","definition":"sub","containerName":"main::","name":"_chunk_psiblast","children":[{"definition":"my","name":"$self","containerName":"_chunk_psiblast","localvar":"my","kind":13,"line":407},{"containerName":"_chunk_psiblast","kind":13,"name":"$tfh","line":407},{"name":"$self","containerName":"_chunk_psiblast","kind":13,"line":411},{"localvar":"my","containerName":"_chunk_psiblast","kind":13,"name":"$sawxmlheader","line":413,"definition":"my"},{"name":"$okaytoprocess","kind":13,"containerName":"_chunk_psiblast","line":413},{"definition":"my","line":416,"localvar":"my","kind":13,"containerName":"_chunk_psiblast","name":"$fh"},{"line":416,"kind":13,"containerName":"_chunk_psiblast","name":"$self"},{"name":"_fh","kind":12,"containerName":"_chunk_psiblast","line":416},{"definition":"my","line":419,"name":"$line","kind":13,"localvar":"my","containerName":"_chunk_psiblast"},{"line":419,"name":"$fh","containerName":"_chunk_psiblast","kind":13},{"kind":13,"containerName":"_chunk_psiblast","name":"$tfh","line":420},{"line":421,"containerName":"_chunk_psiblast","kind":13,"name":"$tfh"},{"line":421,"containerName":"_chunk_psiblast","kind":13,"name":"$line"},{"line":423,"kind":13,"containerName":"_chunk_psiblast","name":"$self"},{"line":423,"containerName":"_chunk_psiblast","kind":13,"name":"$line"},{"containerName":"_chunk_psiblast","kind":13,"name":"$line","line":426},{"line":427,"kind":13,"containerName":"_chunk_psiblast","name":"$okaytoprocess"},{"line":432,"kind":13,"containerName":"_chunk_psiblast","name":"$okaytoprocess"}],"signature":{"label":"_chunk_psiblast($self,$tfh)","documentation":"","parameters":[{"label":"$self"},{"label":"$tfh"}]},"range":{"end":{"character":9999,"line":433},"start":{"line":406,"character":0}},"kind":12,"line":406}]}