{"vars":[{"line":90,"name":"base","kind":2,"containerName":""},{"line":112,"kind":12,"range":{"start":{"character":0,"line":112},"end":{"line":147,"character":9999}},"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: blast_pull.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast_pull\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blast_pull - A parser for BLAST output\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n                               -file   => 't/data/new_blastn.txt');\n    while (my $result = $in->next_result) {\n        # this is a Bio::Search::Result::BlastPullResult object\n        print \"Results for \", $result->query_name(), \"\\n\";\n        while (my $hit = $result->next_hit) {\n            print $hit->name(), \"\\n\";\n            while (my $hsp = $hit->next_hsp) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a pull-parser for BLAST output. It is fast since it\nonly does work on request (hence 'pull').\n\nCurrently only NCBI BLASTN and BLASTP are supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::blast_pull;\n\nuse strict;\nuse Bio::Search::Result::BlastPullResult;\n\nuse base qw(Bio::SearchIO Bio::PullParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast_pull->new();\n Function: Builds a new Bio::SearchIO::blast_pull object \n Returns : Bio::SearchIO::blast_pull\n Args    : -fh/-file => BLAST output filename\n           -format   => 'blast_pull'\n           -evalue   => float or scientific notation number to be used\n                        as an evalue cutoff for hits\n           -score    => integer or scientific notation number to be used\n                        as a score value cutoff for hits\n           -piped_behaviour => 'temp_file'|'memory'|'sequential_read'\n\n           -piped_behaviour defines what the parser should do if the input is\n            an unseekable filehandle (eg. piped input), see\n            Bio::PullParserI::chunk for details. Default is 'memory'."},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":113},{"line":113,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$writer","kind":13,"localvar":"my","containerName":"_initialize","line":117,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"$file","line":117},{"line":117,"name":"$fh","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$piped_behaviour","line":117},{"line":117,"name":"$evalue","containerName":"_initialize","kind":13},{"line":117,"containerName":"_initialize","kind":13,"name":"$score"},{"name":"$self","kind":13,"containerName":"_initialize","line":118},{"line":118,"containerName":"_initialize","kind":12,"name":"_rearrange"},{"line":122,"kind":13,"containerName":"_initialize","name":"@args"},{"line":123,"kind":13,"containerName":"_initialize","name":"$self"},{"line":123,"containerName":"_initialize","kind":12,"name":"writer"},{"line":123,"name":"$writer","kind":13,"containerName":"_initialize"},{"line":123,"kind":13,"containerName":"_initialize","name":"$writer"},{"line":125,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"_fields","line":125},{"line":136,"name":"$self","containerName":"_initialize","kind":13},{"kind":12,"containerName":"_initialize","name":"_fields","line":136},{"containerName":"_initialize","kind":13,"name":"$evalue","line":136},{"kind":13,"containerName":"_initialize","name":"$evalue","line":136},{"line":137,"name":"$self","containerName":"_initialize","kind":13},{"kind":12,"containerName":"_initialize","name":"_fields","line":137},{"line":137,"kind":13,"containerName":"_initialize","name":"$score"},{"name":"$score","kind":13,"containerName":"_initialize","line":137},{"line":139,"name":"$self","containerName":"_initialize","kind":13},{"line":139,"name":"_dependencies","kind":12,"containerName":"_initialize"},{"line":145,"kind":13,"containerName":"_initialize","name":"$self"},{"line":145,"containerName":"_initialize","kind":12,"name":"chunk"},{"line":145,"name":"$file","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$fh","line":145},{"line":145,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"throw","containerName":"_initialize","kind":12,"line":145},{"line":146,"kind":13,"containerName":"_initialize","name":"$piped_behaviour"}],"containerName":"main::","name":"_initialize","definition":"sub","detail":"($self,@args)"},{"name":"header","kind":12,"line":125},{"line":126,"kind":12,"name":"algorithm"},{"name":"algorithm_version","kind":12,"line":127},{"kind":12,"name":"algorithm_reference","line":128},{"line":129,"name":"database_name","kind":12},{"kind":12,"name":"database_letters","line":130},{"name":"database_entries","kind":12,"line":131},{"line":132,"kind":12,"name":"next_result"},{"kind":12,"name":"evalue_cutoff","line":133},{"kind":12,"name":"score_cutoff","line":134},{"kind":12,"name":"evalue_cutoff","line":136},{"line":137,"kind":12,"name":"score_cutoff"},{"line":139,"kind":12,"name":"algorithm"},{"line":140,"kind":12,"name":"algorithm_version"},{"kind":12,"name":"database_name","line":141},{"line":142,"name":"database_letters","kind":12},{"name":"database_entries","kind":12,"line":143},{"kind":12,"range":{"start":{"line":149,"character":0},"end":{"character":9999,"line":179}},"line":149,"definition":"sub","name":"_discover_header","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_discover_header","localvar":"my","kind":13,"line":150},{"line":151,"containerName":"_discover_header","kind":13,"name":"$self"},{"kind":12,"containerName":"_discover_header","name":"_chunk_seek","line":151},{"line":152,"name":"$header","containerName":"_discover_header","localvar":"my","kind":13,"definition":"my"},{"line":152,"containerName":"_discover_header","kind":13,"name":"$self"},{"containerName":"_discover_header","kind":12,"name":"_get_chunk_by_end","line":152},{"line":153,"name":"$self","containerName":"_discover_header","kind":13},{"line":153,"name":"$self","kind":13,"containerName":"_discover_header"},{"line":153,"kind":12,"containerName":"_discover_header","name":"_chunk_tell"},{"line":156,"name":"$header","kind":13,"containerName":"_discover_header"},{"kind":13,"containerName":"_discover_header","name":"$self","line":157},{"line":157,"containerName":"_discover_header","kind":12,"name":"_fields"},{"name":"$self","kind":13,"containerName":"_discover_header","line":158},{"line":158,"name":"_fields","containerName":"_discover_header","kind":12},{"line":160,"name":"$database","localvar":"my","containerName":"_discover_header","kind":13,"definition":"my"},{"name":"$header","containerName":"_discover_header","kind":13,"line":160},{"line":162,"kind":13,"containerName":"_discover_header","name":"$database"},{"definition":"my","name":"$header2","localvar":"my","containerName":"_discover_header","kind":13,"line":164},{"name":"$self","kind":13,"containerName":"_discover_header","line":164},{"containerName":"_discover_header","kind":12,"name":"_get_chunk_by_end","line":164},{"name":"$database","kind":13,"containerName":"_discover_header","line":165},{"name":"$header2","containerName":"_discover_header","kind":13,"line":165},{"line":168,"containerName":"_discover_header","kind":13,"name":"$database"},{"name":"$entries","localvar":"my","kind":13,"containerName":"_discover_header","line":169,"definition":"my"},{"definition":"my","line":170,"name":"$letters","kind":13,"localvar":"my","containerName":"_discover_header"},{"name":"$database","containerName":"_discover_header","kind":13,"line":171},{"line":172,"kind":13,"containerName":"_discover_header","name":"$entries"},{"name":"$letters","containerName":"_discover_header","kind":13,"line":173},{"containerName":"_discover_header","kind":13,"name":"$self","line":174},{"name":"_fields","containerName":"_discover_header","kind":12,"line":174},{"name":"$database","kind":13,"containerName":"_discover_header","line":174},{"line":175,"name":"$self","containerName":"_discover_header","kind":13},{"kind":12,"containerName":"_discover_header","name":"_fields","line":175},{"kind":13,"containerName":"_discover_header","name":"$entries","line":175},{"name":"$self","containerName":"_discover_header","kind":13,"line":176},{"kind":12,"containerName":"_discover_header","name":"_fields","line":176},{"line":176,"name":"$letters","kind":13,"containerName":"_discover_header"},{"line":178,"containerName":"_discover_header","kind":13,"name":"$self"},{"name":"_fields","containerName":"_discover_header","kind":12,"line":178}]},{"kind":12,"name":"_after_header","line":153},{"line":157,"name":"algorithm","kind":12},{"name":"algorithm_version","kind":12,"line":158},{"line":174,"kind":12,"name":"database_name"},{"kind":12,"name":"database_entries","line":175},{"name":"database_letters","kind":12,"line":176},{"name":"header","kind":12,"line":178},{"definition":"sub","containerName":"main::","name":"_discover_next_result","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_discover_next_result","line":182,"definition":"my"},{"line":183,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"definition":"my","line":184,"name":"$type","containerName":"_discover_next_result","localvar":"my","kind":13},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":184},{"name":"get_field","containerName":"_discover_next_result","kind":12,"line":184},{"name":"$type","kind":13,"containerName":"_discover_next_result","line":186},{"line":186,"containerName":"_discover_next_result","kind":13,"name":"$type"},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":187},{"line":187,"name":"_sequential","containerName":"_discover_next_result","kind":12},{"line":188,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"name":"_chunk_seek","kind":12,"containerName":"_discover_next_result","line":188},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":188},{"line":188,"containerName":"_discover_next_result","kind":13,"name":"$self"},{"definition":"my","line":190,"name":"$start","localvar":"my","kind":13,"containerName":"_discover_next_result"},{"kind":13,"containerName":"_discover_next_result","name":"$end","line":190},{"line":190,"containerName":"_discover_next_result","kind":13,"name":"$self"},{"name":"_find_chunk_by_end","kind":12,"containerName":"_discover_next_result","line":190},{"line":191,"name":"$start","containerName":"_discover_next_result","kind":13},{"line":191,"containerName":"_discover_next_result","kind":13,"name":"$end"},{"containerName":"_discover_next_result","kind":13,"name":"$end","line":193},{"line":194,"kind":13,"containerName":"_discover_next_result","name":"$start"},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":194},{"line":194,"name":"$self","kind":13,"containerName":"_discover_next_result"},{"kind":13,"containerName":"_discover_next_result","name":"$end","line":195},{"line":198,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"line":198,"name":"_fields","kind":12,"containerName":"_discover_next_result"},{"name":"new","containerName":"_discover_next_result","kind":12,"line":198},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":198},{"line":198,"name":"chunk","containerName":"_discover_next_result","kind":12},{"line":198,"name":"$start","kind":13,"containerName":"_discover_next_result"},{"name":"$end","containerName":"_discover_next_result","kind":13,"line":198},{"line":199,"containerName":"_discover_next_result","kind":13,"name":"$self"},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":201},{"line":201,"name":"$end","containerName":"_discover_next_result","kind":13},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":205},{"line":205,"name":"throw","containerName":"_discover_next_result","kind":12},{"line":206,"name":"$chunk","localvar":"my","containerName":"_discover_next_result","kind":13,"definition":"my"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":206},{"containerName":"_discover_next_result","kind":12,"name":"_get_chunk_by_end","line":206},{"line":207,"containerName":"_discover_next_result","kind":13,"name":"$chunk"},{"containerName":"_discover_next_result","kind":13,"name":"$self","line":208},{"name":"_fields","kind":12,"containerName":"_discover_next_result","line":208},{"line":208,"containerName":"_discover_next_result","kind":12,"name":"new"},{"kind":13,"containerName":"_discover_next_result","name":"$chunk","line":208},{"line":209,"containerName":"_discover_next_result","kind":13,"name":"$self"},{"line":213,"name":"$self","kind":13,"containerName":"_discover_next_result"},{"kind":12,"containerName":"_discover_next_result","name":"throw","line":213}],"kind":12,"range":{"end":{"line":215,"character":9999},"start":{"line":181,"character":0}},"line":181},{"kind":12,"name":"_after_results","line":183},{"name":"_end_of_previous_result","kind":12,"line":188},{"kind":12,"name":"_after_header","line":188},{"kind":12,"name":"_end_of_previous_result","line":194},{"kind":12,"name":"_after_header","line":194},{"line":198,"kind":12,"name":"next_result"},{"line":198,"name":"Bio","containerName":"Search::Result::BlastPullResult","kind":12},{"line":201,"name":"_end_of_previous_result","kind":12},{"line":208,"name":"next_result","kind":12},{"containerName":"Search::Result::BlastPullResult","kind":12,"name":"Bio","line":208},{"range":{"start":{"line":227,"character":0},"end":{"character":9999,"line":235}},"kind":12,"line":227,"name":"next_result","containerName":"main::","children":[{"definition":"my","line":228,"kind":13,"localvar":"my","containerName":"next_result","name":"$self"},{"line":229,"localvar":"my","containerName":"next_result","kind":13,"name":"$result","definition":"my"},{"line":229,"kind":13,"containerName":"next_result","name":"$self"},{"line":229,"containerName":"next_result","kind":12,"name":"get_field"},{"line":231,"name":"$self","kind":13,"containerName":"next_result"},{"line":231,"name":"_fields","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":233},{"name":"$result","containerName":"next_result","kind":13,"line":234}],"definition":"sub"},{"line":231,"name":"next_result","kind":12},{"range":{"end":{"character":9999,"line":250},"start":{"character":0,"line":247}},"kind":12,"line":247,"definition":"sub","name":"result_count","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"result_count","name":"$self","line":248,"definition":"my"},{"line":249,"name":"$self","kind":13,"containerName":"result_count"}]},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rewind","line":270,"definition":"my"},{"kind":13,"containerName":"rewind","name":"$self","line":271}],"name":"rewind","containerName":"main::","line":269,"range":{"end":{"character":9999,"line":272},"start":{"character":0,"line":269}},"kind":12},{"line":271,"kind":12,"name":"_end_of_previous_result"}],"version":5}