{"vars":[{"line":108,"name":"vars","kind":2,"containerName":""},{"name":"$Revision","containerName":null,"kind":13,"line":114},{"line":115,"kind":13,"containerName":null,"name":"$DATE"},{"name":"%RemoteURLDefault","kind":13,"containerName":null,"line":116},{"line":120,"name":"$MaxDescLen","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$AlignmentLineWidth","line":121},{"name":"base","kind":2,"containerName":"","line":125},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) "},"line":144,"range":{"end":{"line":164,"character":9999},"start":{"line":144,"character":0}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":145,"definition":"my"},{"line":145,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","containerName":"new","kind":13,"name":"$self","line":147,"definition":"my"},{"line":147,"name":"$class","kind":13,"containerName":"new"},{"line":147,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$p","line":148},{"containerName":"new","kind":13,"name":"$n","line":148},{"line":148,"kind":13,"containerName":"new","name":"$filters"},{"kind":13,"containerName":"new","name":"$nowublastlinks","line":149},{"name":"$self","kind":13,"containerName":"new","line":149},{"kind":12,"containerName":"new","name":"_rearrange","line":149},{"line":152,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":153},{"kind":12,"containerName":"new","name":"remote_database_url","line":153},{"line":153,"name":"$p","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$RemoteURLDefault","line":153},{"line":154,"name":"$self","containerName":"new","kind":13},{"name":"remote_database_url","kind":12,"containerName":"new","line":154},{"line":154,"kind":13,"containerName":"new","name":"$n"},{"line":154,"containerName":"new","kind":13,"name":"$RemoteURLDefault"},{"kind":13,"containerName":"new","name":"$self","line":155},{"kind":12,"containerName":"new","name":"no_wublastlinks","line":155},{"name":"$nowublastlinks","containerName":"new","kind":13,"line":155},{"line":156,"kind":13,"containerName":"new","name":"$filters"},{"name":"$filters","kind":13,"containerName":"new","line":157},{"containerName":"new","kind":13,"name":"$self","line":158},{"name":"warn","kind":12,"containerName":"new","line":158},{"kind":13,"localvar":"my","containerName":"new","name":"$type","line":160,"definition":"my"},{"line":160,"containerName":"new","kind":13,"name":"$code"},{"line":160,"kind":13,"containerName":"new","name":"$filters"},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"filter","line":161},{"line":161,"name":"$type","kind":13,"containerName":"new"},{"line":161,"kind":13,"containerName":"new","name":"$code"}],"name":"new","containerName":"main::"},{"line":147,"kind":12,"containerName":"new","name":"SUPER"},{"line":166,"name":"$self","containerName":null,"kind":13},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"remote_database_url","line":184,"definition":"my"},{"line":184,"name":"$type","containerName":"remote_database_url","kind":13},{"containerName":"remote_database_url","kind":13,"name":"$value","line":184},{"line":185,"kind":13,"containerName":"remote_database_url","name":"$type"},{"line":185,"kind":13,"containerName":"remote_database_url","name":"$type"},{"line":186,"containerName":"remote_database_url","kind":13,"name":"$self"},{"containerName":"remote_database_url","kind":12,"name":"warn","line":186},{"kind":13,"containerName":"remote_database_url","name":"$type","line":189},{"line":190,"kind":13,"containerName":"remote_database_url","name":"$value"},{"line":191,"containerName":"remote_database_url","kind":13,"name":"$self"},{"line":191,"containerName":"remote_database_url","kind":13,"name":"$type"},{"line":191,"name":"$value","kind":13,"containerName":"remote_database_url"},{"containerName":"remote_database_url","kind":13,"name":"$self","line":193},{"name":"$type","containerName":"remote_database_url","kind":13,"line":193}],"name":"remote_database_url","containerName":"main::","definition":"sub","detail":"($self,$type,$value)","line":183,"kind":12,"range":{"start":{"line":183,"character":0},"end":{"character":9999,"line":194}},"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]","label":"remote_database_url($self,$type,$value)"}},{"definition":"sub","detail":"($self,$result,$num)","children":[{"line":212,"localvar":"my","kind":13,"containerName":"to_string","name":"$self","definition":"my"},{"kind":13,"containerName":"to_string","name":"$result","line":212},{"line":212,"containerName":"to_string","kind":13,"name":"$num"},{"line":213,"name":"$num","kind":13,"containerName":"to_string"},{"line":214,"name":"$result","containerName":"to_string","kind":13},{"line":215,"localvar":"my","containerName":"to_string","kind":13,"name":"$links","definition":"my"},{"kind":13,"containerName":"to_string","name":"$self","line":215},{"line":215,"name":"no_wublastlinks","kind":12,"containerName":"to_string"},{"definition":"my","line":216,"name":"$resultfilter","kind":13,"localvar":"my","containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$hitfilter","line":216},{"kind":13,"containerName":"to_string","name":"$hspfilter","line":216},{"line":216,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"filter","line":216},{"name":"$self","kind":13,"containerName":"to_string","line":217},{"line":217,"name":"filter","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$self","line":218},{"containerName":"to_string","kind":12,"name":"filter","line":218},{"line":219,"containerName":"to_string","kind":13,"name":"$resultfilter"},{"line":219,"name":"$resultfilter","containerName":"to_string","kind":13}],"containerName":"main::","name":"to_string","signature":{"label":"to_string($self,$result,$num)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}]},"line":211,"range":{"end":{"line":219,"character":9999},"start":{"line":211,"character":0}},"kind":12},{"name":"$result","kind":13,"containerName":null,"line":219},{"definition":"my","line":221,"name":"$qtype","kind":13,"localvar":"my","containerName":null},{"name":"$dbtype","containerName":null,"kind":13,"line":221},{"containerName":null,"kind":13,"name":"$dbseqtype","line":221},{"name":"$type","containerName":null,"kind":13,"line":221},{"definition":"my","name":"$alg","localvar":"my","kind":13,"containerName":null,"line":222},{"line":222,"containerName":null,"kind":13,"name":"$result"},{"containerName":"main::","kind":12,"name":"algorithm","line":222},{"name":"%alg","containerName":null,"kind":13,"line":224},{"name":"$qtype","containerName":null,"kind":13,"line":225},{"line":225,"kind":13,"containerName":null,"name":"$dbtype"},{"line":226,"containerName":null,"kind":13,"name":"$dbseqtype"},{"line":226,"name":"$type","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%alg","line":227},{"containerName":null,"kind":13,"name":"$qtype","line":228},{"containerName":null,"kind":13,"name":"$dbtype","line":229},{"line":230,"kind":13,"containerName":null,"name":"$type"},{"line":231,"containerName":null,"kind":13,"name":"$dbseqtype"},{"containerName":null,"kind":13,"name":"$alg","line":232},{"containerName":null,"kind":13,"name":"%alg","line":233},{"name":"$qtype","containerName":null,"kind":13,"line":234},{"containerName":null,"kind":13,"name":"$dbtype","line":234},{"name":"$type","containerName":null,"kind":13,"line":235},{"line":235,"kind":13,"containerName":null,"name":"$dbseqtype"},{"name":"$alg","containerName":null,"kind":13,"line":236},{"name":"%alg","kind":13,"containerName":null,"line":237},{"line":238,"kind":13,"containerName":null,"name":"$qtype"},{"line":238,"name":"$dbtype","kind":13,"containerName":null},{"name":"$type","containerName":null,"kind":13,"line":239},{"kind":13,"containerName":null,"name":"$dbseqtype","line":239},{"containerName":null,"kind":13,"name":"%alg","line":240},{"kind":13,"containerName":null,"name":"$qtype","line":241},{"line":242,"kind":13,"containerName":null,"name":"$dbtype"},{"line":243,"name":"$dbseqtype","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%type","line":243},{"name":"$self","kind":13,"containerName":null,"line":245},{"name":"warn","kind":12,"containerName":"main::","line":245},{"line":245,"kind":13,"containerName":null,"name":"$result"},{"line":245,"kind":12,"containerName":"main::","name":"algorithm"},{"name":"%baselens","containerName":null,"localvar":"my","kind":13,"line":249,"definition":"my"},{"kind":13,"containerName":null,"name":"$dbtype","line":249},{"kind":13,"containerName":null,"name":"$qtype","line":250},{"line":252,"name":"$str","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":253,"containerName":null,"kind":13,"name":"%num"},{"containerName":null,"kind":13,"name":"$str","line":254},{"line":254,"name":"$self","containerName":null,"kind":13},{"line":254,"name":"start_report","kind":12,"containerName":"main::"},{"name":"$result","kind":13,"containerName":null,"line":254},{"line":257,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"containerName":null,"name":"$self","line":257},{"line":257,"name":"title","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$result","line":257},{"line":259,"name":"$str","containerName":null,"kind":13},{"line":259,"name":"$result","kind":13,"containerName":null},{"line":259,"name":"algorithm_reference","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":259},{"kind":12,"containerName":"main::","name":"algorithm_reference","line":259},{"name":"$result","containerName":null,"kind":13,"line":259},{"name":"$str","containerName":null,"kind":13,"line":260},{"line":260,"name":"$self","containerName":null,"kind":13},{"name":"introduction","kind":12,"containerName":"main::","line":260},{"line":260,"name":"$result","kind":13,"containerName":null},{"line":262,"name":"$str","kind":13,"containerName":null},{"definition":"my","name":"$hspstr","localvar":"my","containerName":null,"kind":13,"line":266},{"containerName":null,"kind":13,"name":"$result","line":267},{"line":267,"name":"can","kind":12,"containerName":"main::"},{"line":268,"name":"$result","containerName":null,"kind":13},{"line":268,"name":"rewind","containerName":"main::","kind":12},{"definition":"my","line":271,"name":"$hit","localvar":"my","containerName":null,"kind":13},{"line":271,"containerName":null,"kind":13,"name":"$result"},{"line":271,"kind":12,"containerName":"main::","name":"next_hit"},{"containerName":null,"kind":13,"name":"$hitfilter","line":272},{"line":272,"kind":13,"containerName":null,"name":"$hitfilter"},{"kind":13,"containerName":null,"name":"$hit","line":272},{"line":273,"localvar":"my","containerName":null,"kind":13,"name":"$nm","definition":"my"},{"line":273,"name":"$hit","kind":13,"containerName":null},{"line":273,"name":"name","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$self","line":275},{"name":"debug","containerName":"main::","kind":12,"line":275},{"containerName":null,"kind":13,"name":"$hit","line":275},{"containerName":"main::","kind":12,"name":"description","line":275},{"line":276,"name":"$nm","containerName":null,"kind":13},{"definition":"my","line":277,"name":"$gi","localvar":"my","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$acc","line":277},{"line":277,"name":"$self","kind":13,"containerName":null},{"line":277,"kind":12,"containerName":"main::","name":"id_parser"},{"line":277,"containerName":null,"kind":13,"name":"$nm"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$p","line":278},{"line":279,"name":"$descsub","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":280,"kind":13,"containerName":null,"name":"$hit"},{"line":280,"name":"description","kind":12,"containerName":"main::"},{"line":280,"name":"%MaxDescLen","kind":13,"containerName":null},{"line":281,"kind":13,"containerName":null,"name":"$descsub"},{"line":281,"kind":13,"containerName":null,"name":"$p"},{"kind":13,"containerName":null,"name":"$hit","line":282},{"line":282,"name":"description","containerName":"main::","kind":12},{"line":282,"name":"%MaxDescLen","kind":13,"containerName":null},{"line":284,"name":"$descsub","kind":13,"containerName":null},{"name":"$p","kind":13,"containerName":null,"line":284},{"name":"$hit","kind":13,"containerName":null,"line":284},{"line":284,"kind":12,"containerName":"main::","name":"description"},{"definition":"my","name":"$url_desc","localvar":"my","containerName":null,"kind":13,"line":287},{"containerName":null,"kind":13,"name":"$self","line":287},{"name":"hit_link_desc","kind":12,"containerName":"main::","line":287},{"line":287,"kind":13,"containerName":null,"name":"$self"},{"kind":13,"containerName":null,"name":"$hit","line":287},{"line":287,"name":"$result","kind":13,"containerName":null},{"definition":"my","name":"$url_align","kind":13,"localvar":"my","containerName":null,"line":288},{"line":288,"name":"$self","containerName":null,"kind":13},{"name":"hit_link_align","kind":12,"containerName":"main::","line":288},{"line":288,"kind":13,"containerName":null,"name":"$self"},{"kind":13,"containerName":null,"name":"$hit","line":288},{"line":288,"kind":13,"containerName":null,"name":"$result"},{"name":"@hsps","localvar":"my","containerName":null,"kind":13,"line":290,"definition":"my"},{"line":290,"containerName":null,"kind":13,"name":"$hit"},{"name":"hsps","kind":12,"containerName":"main::","line":290},{"kind":13,"containerName":null,"name":"@hsps","line":292},{"line":294,"kind":13,"containerName":null,"name":"$str"},{"containerName":null,"kind":13,"name":"$url_desc","line":295},{"containerName":null,"kind":13,"name":"$descsub","line":295},{"containerName":null,"kind":13,"name":"$hit","line":296},{"line":296,"kind":12,"containerName":"main::","name":"bits"},{"name":"$hit","containerName":null,"kind":13,"line":296},{"line":296,"containerName":"main::","kind":12,"name":"bits"},{"name":"@hsps","containerName":null,"kind":13,"line":297},{"containerName":null,"kind":13,"name":"@hsps","line":297},{"name":"bits","containerName":"main::","kind":12,"line":297},{"line":298,"name":"$hit","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"significance","line":298},{"line":298,"name":"$hit","kind":13,"containerName":null},{"line":298,"kind":12,"containerName":"main::","name":"significance"},{"line":299,"containerName":null,"kind":13,"name":"@hsps"},{"containerName":null,"kind":13,"name":"@hsps","line":299},{"name":"evalue","kind":12,"containerName":"main::","line":299},{"line":305,"containerName":null,"kind":13,"name":"$str"},{"containerName":null,"kind":13,"name":"$url_desc","line":306},{"line":306,"containerName":null,"kind":13,"name":"$descsub"},{"containerName":null,"kind":13,"name":"$hit","line":307},{"line":307,"containerName":"main::","kind":12,"name":"bits"},{"line":307,"name":"$hit","containerName":null,"kind":13},{"line":307,"name":"bits","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"@hsps","line":308},{"line":308,"name":"@hsps","kind":13,"containerName":null},{"line":308,"kind":12,"containerName":"main::","name":"bits"},{"kind":13,"containerName":null,"name":"$acc","line":309},{"line":310,"name":"$hit","containerName":null,"kind":13},{"line":310,"kind":12,"containerName":"main::","name":"significance"},{"line":310,"name":"$hit","containerName":null,"kind":13},{"line":310,"kind":12,"containerName":"main::","name":"significance"},{"line":311,"name":"@hsps","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@hsps","line":311},{"kind":12,"containerName":"main::","name":"evalue","line":311},{"kind":13,"localvar":"my","containerName":null,"name":"$dline","line":313,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":313},{"kind":12,"containerName":"main::","name":"hit_desc_line","line":313},{"line":313,"name":"$self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$hit","line":313},{"line":313,"name":"$result","kind":13,"containerName":null},{"line":314,"kind":13,"containerName":null,"name":"$hspstr"},{"kind":13,"containerName":null,"name":"$url_align","line":315},{"kind":13,"containerName":null,"name":"$dline","line":316},{"line":316,"kind":12,"name":"_numwithcommas"},{"name":"$hit","containerName":null,"kind":13,"line":316},{"containerName":"main::","kind":12,"name":"length","line":316},{"definition":"my","line":317,"name":"$ct","containerName":null,"localvar":"my","kind":13},{"definition":"my","name":"$hsp","kind":13,"localvar":"my","containerName":null,"line":318},{"line":318,"name":"@hsps","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$hspfilter","line":319},{"name":"$hspfilter","kind":13,"containerName":null,"line":319},{"line":319,"containerName":null,"kind":13,"name":"$hsp"},{"line":320,"kind":13,"containerName":null,"name":"$hspstr"},{"kind":13,"containerName":null,"name":"$hsp","line":321},{"line":321,"kind":12,"containerName":"main::","name":"bits"},{"line":321,"kind":13,"containerName":null,"name":"$hsp"},{"name":"score","containerName":"main::","kind":12,"line":321},{"containerName":null,"kind":13,"name":"$hsp","line":322},{"containerName":"main::","kind":12,"name":"score","line":322},{"name":"$hsp","kind":13,"containerName":null,"line":322},{"name":"bits","kind":12,"containerName":"main::","line":322},{"name":"$hsp","kind":13,"containerName":null,"line":323},{"containerName":"main::","kind":12,"name":"evalue","line":323},{"name":"$hsp","containerName":null,"kind":13,"line":324},{"line":324,"containerName":"main::","kind":12,"name":"pvalue"},{"line":325,"kind":13,"containerName":null,"name":"$hspstr"},{"name":"$hsp","containerName":null,"kind":13,"line":325},{"line":325,"containerName":"main::","kind":12,"name":"pvalue"},{"containerName":null,"kind":13,"name":"$hspstr","line":327},{"containerName":null,"kind":13,"name":"$hspstr","line":328},{"line":329,"containerName":null,"kind":13,"name":"$hsp"},{"name":"frac_identical","kind":12,"containerName":"main::","line":329},{"containerName":null,"kind":13,"name":"$hsp","line":330},{"line":330,"name":"length","kind":12,"containerName":"main::"},{"line":331,"kind":13,"containerName":null,"name":"$hsp"},{"line":331,"name":"length","containerName":"main::","kind":12},{"line":332,"containerName":null,"kind":13,"name":"$hsp"},{"name":"frac_identical","kind":12,"containerName":"main::","line":332},{"line":334,"name":"%type","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$hspstr","line":335},{"line":336,"name":"$hsp","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"frac_conserved","line":336},{"name":"$hsp","containerName":null,"kind":13,"line":337},{"line":337,"containerName":"main::","kind":12,"name":"length"},{"name":"$hsp","kind":13,"containerName":null,"line":338},{"containerName":"main::","kind":12,"name":"length","line":338},{"line":339,"name":"$hsp","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"frac_conserved","line":339},{"line":341,"name":"$hsp","kind":13,"containerName":null},{"line":341,"containerName":"main::","kind":12,"name":"gaps"},{"line":342,"kind":13,"containerName":null,"name":"$hspstr"},{"name":"$hsp","containerName":null,"kind":13,"line":343},{"name":"gaps","kind":12,"containerName":"main::","line":343},{"line":344,"name":"$hsp","kind":13,"containerName":null},{"name":"length","kind":12,"containerName":"main::","line":344},{"line":345,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"containerName":"main::","name":"gaps","line":345},{"line":346,"name":"$hsp","kind":13,"containerName":null},{"line":346,"name":"length","kind":12,"containerName":"main::"},{"line":349,"name":"$hframe","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"$qframe","kind":13,"containerName":null,"line":349},{"line":349,"kind":13,"containerName":null,"name":"$hsp"},{"line":349,"kind":12,"containerName":"main::","name":"hit"},{"name":"frame","kind":12,"containerName":"main::","line":349},{"kind":13,"containerName":null,"name":"$hsp","line":349},{"line":349,"containerName":"main::","kind":12,"name":"query"},{"containerName":"main::","kind":12,"name":"frame","line":349},{"definition":"my","line":350,"name":"$hstrand","containerName":null,"localvar":"my","kind":13},{"kind":13,"containerName":null,"name":"$qstrand","line":350},{"kind":13,"containerName":null,"name":"$hsp","line":350},{"line":350,"kind":12,"containerName":"main::","name":"hit"},{"kind":12,"containerName":"main::","name":"strand","line":350},{"name":"$hsp","kind":13,"containerName":null,"line":350},{"line":350,"name":"query","containerName":"main::","kind":12},{"line":350,"name":"strand","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$hstrand","line":354},{"name":"%qstrand","kind":13,"containerName":null,"line":354},{"kind":13,"containerName":null,"name":"$hspstr","line":355},{"definition":"my","line":356,"localvar":"my","containerName":null,"kind":13,"name":"$signq"},{"containerName":null,"kind":13,"name":"$signh","line":356},{"line":357,"name":"%hstrand","kind":13,"containerName":null},{"name":"%hframe","kind":13,"containerName":null,"line":358},{"line":362,"name":"$signh","kind":13,"containerName":null},{"line":362,"containerName":null,"kind":13,"name":"$hstrand"},{"name":"%qstrand","containerName":null,"kind":13,"line":364},{"containerName":null,"kind":13,"name":"%qframe","line":365},{"kind":13,"containerName":null,"name":"$signq","line":368},{"name":"$qstrand","containerName":null,"kind":13,"line":368},{"name":"$hframe","containerName":null,"kind":13,"line":373},{"line":373,"name":"%qframe","containerName":null,"kind":13},{"line":374,"name":"$hspstr","containerName":null,"kind":13},{"line":374,"name":"$hframe","containerName":null,"kind":13},{"line":375,"name":"$qframe","kind":13,"containerName":null},{"line":375,"name":"%hframe","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$hspstr","line":376},{"name":"%qframe","kind":13,"containerName":null,"line":376},{"containerName":null,"kind":13,"name":"$hspstr","line":378},{"name":"$signq","containerName":null,"kind":13,"line":379},{"line":379,"name":"$qframe","kind":13,"containerName":null},{"line":380,"name":"$signh","containerName":null,"kind":13},{"name":"$hframe","containerName":null,"kind":13,"line":380},{"line":383,"containerName":null,"kind":13,"name":"$links"},{"line":384,"containerName":null,"kind":13,"name":"$hsp"},{"line":384,"containerName":"main::","kind":12,"name":"can"},{"name":"$lnks","containerName":null,"localvar":"my","kind":13,"line":384,"definition":"my"},{"name":"$hsp","containerName":null,"kind":13,"line":384},{"kind":12,"containerName":"main::","name":"links","line":384},{"name":"$hspstr","kind":13,"containerName":null,"line":385},{"line":385,"name":"$lnks","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$hspstr","line":388},{"line":390,"name":"@hspvals","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$hsp","line":391},{"name":"query_string","kind":12,"containerName":"main::","line":391},{"line":392,"kind":13,"containerName":null,"name":"$qstrand"},{"name":"$hsp","kind":13,"containerName":null,"line":393},{"line":393,"name":"query","kind":12,"containerName":"main::"},{"line":393,"kind":12,"containerName":"main::","name":"start"},{"name":"$hsp","kind":13,"containerName":null,"line":394},{"name":"query","kind":12,"containerName":"main::","line":394},{"containerName":"main::","kind":12,"name":"end","line":394},{"kind":13,"containerName":null,"name":"$qstrand","line":395},{"kind":13,"containerName":null,"name":"$hsp","line":396},{"name":"query","kind":12,"containerName":"main::","line":396},{"name":"end","kind":12,"containerName":"main::","line":396},{"line":397,"kind":13,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","kind":12,"line":397},{"line":397,"name":"start","containerName":"main::","kind":12},{"line":399,"containerName":null,"kind":13,"name":"%qstrand"},{"kind":12,"name":"x6","line":401},{"kind":13,"containerName":null,"name":"$hsp","line":402},{"kind":12,"containerName":"main::","name":"homology_string","line":402},{"name":"$hsp","kind":13,"containerName":null,"line":409},{"kind":12,"containerName":"main::","name":"hit_string","line":409},{"line":410,"name":"$hstrand","kind":13,"containerName":null},{"line":411,"kind":13,"containerName":null,"name":"$hsp"},{"name":"hit","containerName":"main::","kind":12,"line":411},{"name":"start","kind":12,"containerName":"main::","line":411},{"kind":13,"containerName":null,"name":"$hsp","line":412},{"name":"hit","kind":12,"containerName":"main::","line":412},{"kind":12,"containerName":"main::","name":"end","line":412},{"name":"$hstrand","containerName":null,"kind":13,"line":413},{"containerName":null,"kind":13,"name":"$hsp","line":414},{"line":414,"containerName":"main::","kind":12,"name":"hit"},{"name":"end","kind":12,"containerName":"main::","line":414},{"line":415,"name":"$hsp","kind":13,"containerName":null},{"line":415,"kind":12,"containerName":"main::","name":"hit"},{"name":"start","containerName":"main::","kind":12,"line":415},{"line":417,"name":"$hstrand","containerName":null,"kind":13},{"definition":"my","line":426,"name":"%numwidth","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$b","line":426},{"name":"$a","containerName":null,"kind":13,"line":426},{"line":426,"containerName":null,"kind":13,"name":"@hspvals"},{"line":427,"containerName":null,"kind":13,"name":"@hspvals"},{"name":"@hspvals","containerName":null,"kind":13,"line":428},{"line":429,"name":"@hspvals","kind":13,"containerName":null},{"definition":"my","line":430,"containerName":null,"localvar":"my","kind":13,"name":"$count"},{"kind":13,"containerName":null,"name":"$count","line":431},{"containerName":null,"kind":13,"name":"$hsp","line":431},{"containerName":"main::","kind":12,"name":"length","line":431},{"name":"$v","localvar":"my","kind":13,"containerName":null,"line":432,"definition":"my"},{"line":432,"containerName":null,"kind":13,"name":"@hspvals"},{"line":433,"localvar":"my","containerName":null,"kind":13,"name":"$piece","definition":"my"},{"name":"%v","containerName":null,"kind":13,"line":433},{"line":433,"containerName":null,"kind":13,"name":"%v"},{"line":433,"name":"$count","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$AlignmentLineWidth","line":434},{"line":435,"kind":13,"localvar":"my","containerName":null,"name":"$cp","definition":"my"},{"kind":13,"containerName":null,"name":"$piece","line":435},{"definition":"my","line":436,"containerName":null,"localvar":"my","kind":13,"name":"$plen"},{"line":436,"containerName":null,"kind":13,"name":"$cp"},{"definition":"my","line":437,"kind":13,"localvar":"my","containerName":null,"name":"$start"},{"line":437,"name":"$end","kind":13,"containerName":null},{"name":"%v","kind":13,"containerName":null,"line":438},{"kind":13,"containerName":null,"name":"$start","line":439},{"kind":13,"containerName":null,"name":"%v","line":439},{"definition":"my","name":"$d","kind":13,"localvar":"my","containerName":null,"line":442},{"name":"%v","containerName":null,"kind":13,"line":442},{"line":442,"name":"$AlignmentLineWidth","kind":13,"containerName":null},{"line":442,"name":"$plen","kind":13,"containerName":null},{"name":"%baselens","kind":13,"containerName":null,"line":443},{"line":443,"kind":13,"containerName":null,"name":"%v"},{"name":"$piece","kind":13,"containerName":null,"line":444},{"line":444,"containerName":null,"kind":13,"name":"%AlignmentLineWidth"},{"line":445,"containerName":null,"kind":13,"name":"$d"},{"line":445,"containerName":null,"kind":13,"name":"$piece"},{"line":445,"kind":13,"containerName":null,"name":"$plen"},{"line":445,"name":"%v","kind":13,"containerName":null},{"name":"%baselens","kind":13,"containerName":null,"line":446},{"line":446,"kind":13,"containerName":null,"name":"%v"},{"kind":13,"containerName":null,"name":"$end","line":448},{"line":448,"name":"%v","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$d","line":448},{"line":448,"kind":13,"containerName":null,"name":"%v"},{"line":449,"name":"%v","kind":13,"containerName":null},{"line":449,"kind":13,"containerName":null,"name":"$d"},{"name":"$hspstr","kind":13,"containerName":null,"line":451},{"line":451,"containerName":null,"kind":13,"name":"$numwidth"},{"line":452,"containerName":null,"kind":13,"name":"%v"},{"containerName":null,"kind":13,"name":"$start","line":453},{"line":454,"name":"$piece","kind":13,"containerName":null},{"line":456,"name":"$end","kind":13,"containerName":null},{"line":458,"kind":13,"containerName":null,"name":"$count"},{"name":"$AlignmentLineWidth","containerName":null,"kind":13,"line":458},{"line":459,"name":"$hspstr","containerName":null,"kind":13},{"line":461,"name":"$hspstr","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$str","line":467},{"containerName":null,"kind":13,"name":"$hspstr","line":467},{"definition":"my","line":468,"name":"$pav","localvar":"my","containerName":null,"kind":13},{"line":468,"containerName":null,"kind":13,"name":"$sav"},{"line":468,"containerName":null,"kind":13,"name":"$result"},{"line":468,"name":"available_parameters","kind":12,"containerName":"main::"},{"line":468,"containerName":null,"kind":13,"name":"$result"},{"line":468,"name":"available_statistics","kind":12,"containerName":"main::"},{"name":"$pav","kind":13,"containerName":null,"line":469},{"line":469,"containerName":null,"kind":13,"name":"%sav"},{"name":"$str","containerName":null,"kind":13,"line":471},{"line":472,"kind":13,"containerName":null,"name":"%pav"},{"line":473,"containerName":null,"kind":13,"name":"$str"},{"definition":"my","name":"$param","localvar":"my","containerName":null,"kind":13,"line":474},{"name":"$result","containerName":null,"kind":13,"line":474},{"line":474,"containerName":"main::","kind":12,"name":"available_parameters"},{"containerName":null,"kind":13,"name":"$str","line":475},{"kind":13,"containerName":null,"name":"$result","line":475},{"line":475,"containerName":"main::","kind":12,"name":"get_parameter"},{"kind":13,"containerName":null,"name":"$param","line":475},{"kind":13,"containerName":null,"name":"$str","line":477},{"line":480,"name":"%sav","kind":13,"containerName":null},{"name":"$str","containerName":null,"kind":13,"line":481},{"name":"$stat","localvar":"my","kind":13,"containerName":null,"line":482,"definition":"my"},{"line":482,"name":"$result","kind":13,"containerName":null},{"line":482,"kind":12,"containerName":"main::","name":"available_statistics"},{"kind":13,"containerName":null,"name":"$str","line":483},{"name":"$result","kind":13,"containerName":null,"line":483},{"line":483,"name":"get_statistic","kind":12,"containerName":"main::"},{"line":483,"name":"$stat","kind":13,"containerName":null},{"line":485,"kind":13,"containerName":null,"name":"$str"},{"line":488,"name":"$str","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":488},{"name":"footer","kind":12,"containerName":"main::","line":488},{"name":"$str","kind":13,"containerName":null,"line":489},{"detail":"($self,$code)","definition":"sub","containerName":"main::","name":"hit_link_desc","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hit_link_desc","line":509,"definition":"my"},{"containerName":"hit_link_desc","kind":13,"name":"$code","line":509},{"line":510,"kind":13,"containerName":"hit_link_desc","name":"$code"},{"line":511,"name":"$self","kind":13,"containerName":"hit_link_desc"},{"kind":13,"containerName":"hit_link_desc","name":"$code","line":511},{"line":513,"name":"$self","containerName":"hit_link_desc","kind":13}],"signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>","parameters":[{"label":"$self"},{"label":"$code"}],"label":"hit_link_desc($self,$code)"},"range":{"end":{"line":514,"character":9999},"start":{"character":0,"line":508}},"kind":12,"line":508},{"line":513,"kind":12,"name":"default_hit_link_desc"},{"children":[{"line":540,"name":"$self","kind":13,"localvar":"my","containerName":"default_hit_link_desc","definition":"my"},{"line":540,"containerName":"default_hit_link_desc","kind":13,"name":"$hit"},{"line":540,"containerName":"default_hit_link_desc","kind":13,"name":"$result"},{"definition":"my","name":"$type","localvar":"my","containerName":"default_hit_link_desc","kind":13,"line":541},{"line":541,"containerName":"default_hit_link_desc","kind":13,"name":"$result"},{"name":"algorithm","kind":12,"containerName":"default_hit_link_desc","line":541},{"definition":"my","line":542,"localvar":"my","containerName":"default_hit_link_desc","kind":13,"name":"$gi"},{"name":"$acc","containerName":"default_hit_link_desc","kind":13,"line":542},{"line":542,"containerName":"default_hit_link_desc","kind":13,"name":"$self"},{"line":542,"name":"id_parser","containerName":"default_hit_link_desc","kind":12}],"containerName":"main::","name":"default_hit_link_desc","definition":"sub","detail":"($self,$hit,$result)","line":539,"range":{"start":{"line":539,"character":0},"end":{"line":542,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>","parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$result"}],"label":"default_hit_link_desc($self,$hit,$result)"}},{"name":"$hit","kind":13,"containerName":null,"line":542},{"line":542,"containerName":"main::","kind":12,"name":"name"},{"definition":"my","line":544,"kind":13,"localvar":"my","containerName":null,"name":"$url"},{"line":544,"containerName":null,"kind":13,"name":"$self"},{"name":"remote_database_url","kind":12,"containerName":"main::","line":544},{"name":"$type","containerName":null,"kind":13,"line":544},{"name":"$self","kind":13,"containerName":null,"line":546},{"containerName":"main::","kind":12,"name":"remote_database_url","line":546},{"line":546,"name":"$type","containerName":null,"kind":13},{"name":"$gi","kind":13,"containerName":null,"line":546},{"kind":13,"containerName":null,"name":"$acc","line":546},{"line":547,"name":"$hit","containerName":null,"kind":13},{"name":"name","kind":12,"containerName":"main::","line":547},{"line":547,"name":"$hit","kind":13,"containerName":null},{"line":547,"kind":12,"containerName":"main::","name":"name"},{"name":"$url","containerName":null,"kind":13,"line":549},{"signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>","parameters":[{"label":"$self"},{"label":"$code"}],"label":"hit_link_align($self,$code)"},"kind":12,"range":{"end":{"line":580,"character":9999},"start":{"line":574,"character":0}},"line":574,"detail":"($self,$code)","definition":"sub","containerName":"main::","name":"hit_link_align","children":[{"localvar":"my","kind":13,"containerName":"hit_link_align","name":"$self","line":575,"definition":"my"},{"name":"$code","kind":13,"containerName":"hit_link_align","line":575},{"name":"$code","kind":13,"containerName":"hit_link_align","line":576},{"line":577,"name":"$self","containerName":"hit_link_align","kind":13},{"line":577,"name":"$code","kind":13,"containerName":"hit_link_align"},{"kind":13,"containerName":"hit_link_align","name":"$self","line":579}]},{"definition":"sub","detail":"($self,$code)","children":[{"line":596,"localvar":"my","containerName":"hit_desc_line","kind":13,"name":"$self","definition":"my"},{"line":596,"containerName":"hit_desc_line","kind":13,"name":"$code"},{"line":597,"kind":13,"containerName":"hit_desc_line","name":"$code"},{"name":"$self","containerName":"hit_desc_line","kind":13,"line":598},{"line":598,"name":"$code","kind":13,"containerName":"hit_desc_line"},{"name":"$self","containerName":"hit_desc_line","kind":13,"line":600}],"containerName":"main::","name":"hit_desc_line","signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>","label":"hit_desc_line($self,$code)"},"line":595,"range":{"end":{"line":601,"character":9999},"start":{"character":0,"line":595}},"kind":12},{"line":600,"name":"default_hit_desc_line","kind":12},{"signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>","parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$result"}],"label":"default_hit_desc_line($self,$hit,$result)"},"kind":12,"range":{"start":{"character":0,"line":625},"end":{"line":653,"character":9999}},"line":625,"detail":"($self,$hit,$result)","definition":"sub","name":"default_hit_desc_line","containerName":"main::","children":[{"line":626,"containerName":"default_hit_desc_line","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"default_hit_desc_line","name":"$hit","line":626},{"containerName":"default_hit_desc_line","kind":13,"name":"$result","line":626},{"definition":"my","line":627,"name":"$type","localvar":"my","containerName":"default_hit_desc_line","kind":13},{"containerName":"default_hit_desc_line","kind":13,"name":"$result","line":627},{"line":627,"containerName":"default_hit_desc_line","kind":12,"name":"algorithm"},{"line":628,"localvar":"my","containerName":"default_hit_desc_line","kind":13,"name":"@descs","definition":"my"},{"kind":13,"containerName":"default_hit_desc_line","name":"$hit","line":628},{"line":628,"name":"description","containerName":"default_hit_desc_line","kind":12},{"name":"$descline","localvar":"my","containerName":"default_hit_desc_line","kind":13,"line":630,"definition":"my"},{"line":632,"name":"$sec","containerName":"default_hit_desc_line","localvar":"my","kind":13,"definition":"my"},{"name":"@descs","kind":13,"containerName":"default_hit_desc_line","line":632},{"kind":13,"localvar":"my","containerName":"default_hit_desc_line","name":"$url","line":633,"definition":"my"},{"line":634,"kind":13,"containerName":"default_hit_desc_line","name":"$sec"},{"line":637,"containerName":"default_hit_desc_line","localvar":"my","kind":13,"name":"$name","definition":"my"},{"line":637,"kind":13,"containerName":"default_hit_desc_line","name":"$gi"},{"line":637,"containerName":"default_hit_desc_line","kind":13,"name":"$db"},{"name":"$acc","containerName":"default_hit_desc_line","kind":13,"line":637},{"line":639,"containerName":"default_hit_desc_line","kind":13,"name":"$acc"},{"line":640,"containerName":"default_hit_desc_line","kind":13,"name":"$acc"},{"line":641,"containerName":"default_hit_desc_line","kind":13,"name":"$url"},{"line":642,"containerName":"default_hit_desc_line","kind":13,"name":"$self"},{"name":"remote_database_url","containerName":"default_hit_desc_line","kind":12,"line":642},{"name":"$type","containerName":"default_hit_desc_line","kind":13,"line":642},{"kind":13,"containerName":"default_hit_desc_line","name":"$self","line":644},{"line":644,"containerName":"default_hit_desc_line","kind":12,"name":"remote_database_url"},{"name":"$type","containerName":"default_hit_desc_line","kind":13,"line":644},{"line":645,"containerName":"default_hit_desc_line","kind":13,"name":"$gi"},{"line":645,"name":"$acc","containerName":"default_hit_desc_line","kind":13},{"name":"$db","kind":13,"containerName":"default_hit_desc_line","line":645},{"name":"$name","containerName":"default_hit_desc_line","kind":13,"line":646},{"line":646,"name":"$sec","kind":13,"containerName":"default_hit_desc_line"},{"containerName":"default_hit_desc_line","kind":13,"name":"$sec","line":646},{"line":648,"name":"$url","kind":13,"containerName":"default_hit_desc_line"},{"name":"$sec","kind":13,"containerName":"default_hit_desc_line","line":648},{"line":650,"kind":13,"containerName":"default_hit_desc_line","name":"$descline"},{"line":652,"name":"$descline","kind":13,"containerName":"default_hit_desc_line"}]},{"signature":{"label":"start_report($self,$code)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}]},"line":674,"range":{"start":{"character":0,"line":674},"end":{"line":680,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$code)","children":[{"localvar":"my","containerName":"start_report","kind":13,"name":"$self","line":675,"definition":"my"},{"line":675,"kind":13,"containerName":"start_report","name":"$code"},{"name":"$code","containerName":"start_report","kind":13,"line":676},{"containerName":"start_report","kind":13,"name":"$self","line":677},{"name":"$code","kind":13,"containerName":"start_report","line":677},{"line":679,"containerName":"start_report","kind":13,"name":"$self"}],"name":"start_report","containerName":"main::"},{"name":"default_start_report","kind":12,"line":679},{"signature":{"label":"default_start_report($result)","parameters":[{"label":"$result"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI"},"line":692,"range":{"start":{"character":0,"line":692},"end":{"line":705,"character":9999}},"kind":12,"definition":"sub","detail":"($result)","children":[{"definition":"my","line":693,"localvar":"my","containerName":"default_start_report","kind":13,"name":"$result"},{"line":703,"containerName":"default_start_report","kind":13,"name":"$result"},{"containerName":"default_start_report","kind":12,"name":"algorithm","line":703},{"kind":13,"containerName":"default_start_report","name":"$Revision","line":703}],"containerName":"main::","name":"default_start_report"},{"name":"title","containerName":"main::","children":[{"line":725,"name":"$self","localvar":"my","containerName":"title","kind":13,"definition":"my"},{"name":"$code","containerName":"title","kind":13,"line":725},{"name":"$code","containerName":"title","kind":13,"line":726},{"line":727,"name":"$self","kind":13,"containerName":"title"},{"name":"$code","containerName":"title","kind":13,"line":727},{"line":729,"name":"$self","containerName":"title","kind":13}],"detail":"($self,$code)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":724},"end":{"line":730,"character":9999}},"line":724,"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","label":"title($self,$code)"}},{"name":"default_title","kind":12,"line":729},{"containerName":"main::","name":"default_title","children":[{"definition":"my","line":748,"name":"$result","localvar":"my","containerName":"default_title","kind":13},{"containerName":"default_title","kind":13,"name":"$result","line":752},{"line":752,"name":"algorithm","containerName":"default_title","kind":12},{"name":"$result","containerName":"default_title","kind":13,"line":753},{"name":"query_name","kind":12,"containerName":"default_title","line":753}],"detail":"($result)","definition":"sub","range":{"end":{"character":9999,"line":754},"start":{"line":747,"character":0}},"kind":12,"line":747,"signature":{"parameters":[{"label":"$result"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI","label":"default_title($result)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_title {\n    my ($result) = @_;\n\n    return sprintf(\n        qq{<CENTER><H1><a href=\"http://bioperl.org\">Bioperl</a> Reformatted HTML of %s Search Report<br> for %s</H1></CENTER>},\n\t\t    $result->algorithm,\n\t\t    $result->query_name());\n}\n\n\n=head2 introduction\n\n Title   : introduction\n Usage   : $self->introduction($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report detailing the query and the\n            database information.\n            Useful for (for instance) specifying\n            routines returning alternative introductions.\n            Returns \\&default_introduction (see below) if not\n            set. \n  Example : $index->introduction( \\&my_introduction )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","label":"introduction($self,$code)"},"kind":12,"range":{"end":{"line":781,"character":9999},"start":{"line":775,"character":0}},"line":775,"detail":"($self,$code)","definition":"sub","name":"introduction","containerName":"main::","children":[{"definition":"my","line":776,"localvar":"my","kind":13,"containerName":"introduction","name":"$self"},{"name":"$code","containerName":"introduction","kind":13,"line":776},{"line":777,"name":"$code","containerName":"introduction","kind":13},{"line":778,"containerName":"introduction","kind":13,"name":"$self"},{"kind":13,"containerName":"introduction","name":"$code","line":778},{"line":780,"containerName":"introduction","kind":13,"name":"$self"}]},{"kind":12,"name":"default_introduction","line":780},{"definition":"sub","detail":"($result)","children":[{"containerName":"default_introduction","localvar":"my","kind":13,"name":"$result","line":796,"definition":"my"},{"name":"$result","kind":13,"containerName":"default_introduction","line":806},{"name":"query_name","containerName":"default_introduction","kind":12,"line":806},{"containerName":"default_introduction","kind":13,"name":"$result","line":807},{"line":807,"containerName":"default_introduction","kind":12,"name":"query_description"},{"line":808,"name":"$result","containerName":"default_introduction","kind":13},{"line":808,"name":"query_length","containerName":"default_introduction","kind":12},{"line":809,"kind":13,"containerName":"default_introduction","name":"$result"},{"name":"database_name","kind":12,"containerName":"default_introduction","line":809},{"name":"$result","kind":13,"containerName":"default_introduction","line":810},{"line":810,"containerName":"default_introduction","kind":12,"name":"database_entries"},{"name":"$result","containerName":"default_introduction","kind":13,"line":811},{"name":"database_letters","containerName":"default_introduction","kind":12,"line":811}],"name":"default_introduction","containerName":"main::","signature":{"label":"default_introduction($result)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_title {\n    my ($result) = @_;\n\n    return sprintf(\n        qq{<CENTER><H1><a href=\"http://bioperl.org\">Bioperl</a> Reformatted HTML of %s Search Report<br> for %s</H1></CENTER>},\n\t\t    $result->algorithm,\n\t\t    $result->query_name());\n}\n\n\n=head2 introduction\n\n Title   : introduction\n Usage   : $self->introduction($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report detailing the query and the\n            database information.\n            Useful for (for instance) specifying\n            routines returning alternative introductions.\n            Returns \\&default_introduction (see below) if not\n            set. \n  Example : $index->introduction( \\&my_introduction )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub introduction {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_introduction'} = $code;\n    }\n    return $self->{'_introduction'} || \\&default_introduction;\n}\n\n=head2 default_introduction\n\n Title   : default_introduction\n Usage   : $self->default_introduction($result)\n Function: Outputs HTML to provide the query\n           and the database information\n Returns : string containing HTML\n Args    : First argument is a Bio::Search::Result::ResultI\n           Second argument is string holding literature citation","parameters":[{"label":"$result"}]},"line":795,"kind":12,"range":{"end":{"character":9999,"line":813},"start":{"line":795,"character":0}}},{"kind":12,"name":"_numwithcommas","line":808},{"line":810,"kind":12,"name":"_numwithcommas"},{"name":"_numwithcommas","kind":12,"line":811},{"definition":"sub","name":"end_report","containerName":"main::","children":[],"range":{"start":{"line":828,"character":0},"end":{"line":830,"character":9999}},"kind":12,"line":828},{"line":854,"range":{"start":{"line":854,"character":0},"end":{"character":9999,"line":861}},"kind":12,"signature":{"label":"id_parser($self,$code)","documentation":"","parameters":[{"label":"$self"},{"label":"$code"}]},"children":[{"localvar":"my","kind":13,"containerName":"id_parser","name":"$self","line":855,"definition":"my"},{"line":855,"containerName":"id_parser","kind":13,"name":"$code"},{"name":"$code","kind":13,"containerName":"id_parser","line":857},{"kind":13,"containerName":"id_parser","name":"$self","line":858},{"kind":13,"containerName":"id_parser","name":"$code","line":858},{"name":"$self","kind":13,"containerName":"id_parser","line":860}],"name":"id_parser","containerName":"main::","definition":"sub","detail":"($self,$code)"},{"name":"default_id_parser","kind":12,"line":860},{"line":881,"kind":12,"range":{"end":{"line":895,"character":9999},"start":{"line":881,"character":0}},"signature":{"label":"default_id_parser($string)","documentation":"","parameters":[{"label":"$string"}]},"children":[{"definition":"my","containerName":"default_id_parser","localvar":"my","kind":13,"name":"$string","line":882},{"name":"$gi","localvar":"my","kind":13,"containerName":"default_id_parser","line":883,"definition":"my"},{"line":883,"kind":13,"containerName":"default_id_parser","name":"$acc"},{"kind":13,"containerName":"default_id_parser","name":"$string","line":884},{"containerName":"default_id_parser","kind":13,"name":"$gi","line":885},{"containerName":"default_id_parser","kind":13,"name":"$acc","line":885},{"name":"$string","kind":13,"containerName":"default_id_parser","line":887},{"name":"$acc","kind":13,"containerName":"default_id_parser","line":888},{"line":890,"containerName":"default_id_parser","kind":13,"name":"$acc"},{"kind":13,"containerName":"default_id_parser","name":"$string","line":890},{"name":"$acc","kind":13,"containerName":"default_id_parser","line":891},{"line":892,"name":"$acc","containerName":"default_id_parser","kind":13},{"kind":13,"containerName":"default_id_parser","name":"$gi","line":894},{"line":894,"containerName":"default_id_parser","kind":13,"name":"$acc"}],"containerName":"main::","name":"default_id_parser","definition":"sub","detail":"($string)"},{"definition":"sub","children":[{"name":"$a","kind":13,"containerName":"MIN","line":897},{"line":897,"kind":13,"containerName":"MIN","name":"$b"},{"kind":13,"containerName":"MIN","name":"$a","line":897},{"line":897,"kind":13,"containerName":"MIN","name":"$b"}],"name":"MIN","containerName":"main::","line":897,"kind":12,"range":{"start":{"line":897,"character":0},"end":{"character":9999,"line":897}}},{"line":898,"range":{"start":{"character":0,"line":898},"end":{"line":898,"character":9999}},"kind":12,"definition":"sub","children":[{"line":898,"containerName":"MAX","kind":13,"name":"$a"},{"containerName":"MAX","kind":13,"name":"$b","line":898},{"kind":13,"containerName":"MAX","name":"$b","line":898},{"kind":13,"containerName":"MAX","name":"$a","line":898}],"name":"MAX","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"footer($self)"},"line":900,"range":{"start":{"character":0,"line":900},"end":{"line":904,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":901,"kind":13,"localvar":"my","containerName":"footer","name":"$self"},{"line":902,"containerName":"footer","kind":13,"name":"$self"}],"containerName":"main::","name":"footer"},{"line":918,"kind":12,"range":{"start":{"character":0,"line":918},"end":{"character":9999,"line":943}},"signature":{"parameters":[{"label":"$self"},{"label":"$result"}],"documentation":"","label":"algorithm_reference($self,$result)"},"children":[{"definition":"my","containerName":"algorithm_reference","localvar":"my","kind":13,"name":"$self","line":919},{"line":919,"kind":13,"containerName":"algorithm_reference","name":"$result"},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":920},{"line":920,"name":"$result","kind":13,"containerName":"algorithm_reference"},{"line":921,"name":"$result","containerName":"algorithm_reference","kind":13},{"line":921,"containerName":"algorithm_reference","kind":12,"name":"isa"},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":922},{"name":"algorithm","containerName":"algorithm_reference","kind":12,"line":922},{"line":923,"localvar":"my","containerName":"algorithm_reference","kind":13,"name":"$res","definition":"my"},{"line":923,"kind":13,"containerName":"algorithm_reference","name":"$result"},{"name":"algorithm","containerName":"algorithm_reference","kind":12,"line":923},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":923},{"kind":12,"containerName":"algorithm_reference","name":"algorithm_version","line":923},{"kind":13,"containerName":"algorithm_reference","name":"$result","line":924},{"containerName":"algorithm_reference","kind":12,"name":"algorithm_version","line":924},{"containerName":"algorithm_reference","kind":13,"name":"$res","line":925},{"line":930,"kind":13,"containerName":"algorithm_reference","name":"$res"},{"containerName":"algorithm_reference","kind":13,"name":"$result","line":937},{"line":937,"containerName":"algorithm_reference","kind":12,"name":"algorithm"},{"line":938,"name":"$result","kind":13,"containerName":"algorithm_reference"},{"line":938,"name":"algorithm","containerName":"algorithm_reference","kind":12},{"kind":13,"containerName":"algorithm_reference","name":"$result","line":938},{"kind":12,"containerName":"algorithm_reference","name":"algorithm_version","line":938}],"containerName":"main::","name":"algorithm_reference","definition":"sub","detail":"($self,$result)"},{"range":{"end":{"character":9999,"line":950},"start":{"line":946,"character":0}},"kind":12,"line":946,"name":"_numwithcommas","containerName":"main::","children":[{"definition":"my","line":947,"name":"$num","containerName":"_numwithcommas","localvar":"my","kind":13},{"kind":13,"containerName":"_numwithcommas","name":"$num","line":948},{"line":949,"kind":13,"containerName":"_numwithcommas","name":"$num"}],"definition":"sub"},{"children":[{"localvar":"my","kind":13,"containerName":"no_wublastlinks","name":"$self","line":983,"definition":"my"},{"line":985,"name":"$self","containerName":"no_wublastlinks","kind":13},{"kind":13,"containerName":"no_wublastlinks","name":"$self","line":986}],"containerName":"main::","name":"no_wublastlinks","definition":"sub","line":982,"range":{"start":{"character":0,"line":982},"end":{"character":9999,"line":987}},"kind":12}],"version":5}