{"version":5,"vars":[{"line":81,"kind":2,"containerName":"","name":"vars"},{"line":84,"kind":13,"containerName":null,"name":"%Defaults"},{"line":84,"name":"strict","kind":2,"containerName":""},{"kind":13,"containerName":null,"name":"%Defaults","line":85},{"name":"%Defaults","containerName":null,"kind":13,"line":86},{"containerName":"","kind":2,"name":"base","line":88},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":103,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":103},{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"new","line":105},{"kind":13,"containerName":"new","name":"$class","line":105},{"name":"@args","containerName":"new","kind":13,"line":105},{"name":"$self","kind":13,"containerName":"new","line":106},{"line":107,"containerName":"new","kind":13,"name":"$self"},{"line":108,"containerName":"new","kind":13,"name":"$self"},{"line":109,"name":"$self","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":109},{"name":"_rearrange","containerName":"new","kind":12,"line":109},{"line":110,"name":"@args","containerName":"new","kind":13},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","kind":13,"containerName":"new","line":112},{"name":"$self","kind":13,"containerName":"new","line":113},{"line":114,"containerName":"new","kind":13,"name":"$self"},{"line":114,"name":"$Defaults","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":115}],"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: GbrowseGFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::SearchIO::Writer::GbrowseGFF.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Wilkinson <markw@illuminae.com>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::Writer::GbrowseGFF - Interface for outputting parsed search results in Gbrowse GFF format\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',      \n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'GbrowseGFF',\n                              -output_cigar   => 1,\n                              -output_signif  => 1,\n                              -file           => \">result.gff\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis writer produces Gbrowse flavour GFF from a Search::Result object.\n\n=head1 AUTHOR  Mark Wilkinson\n\nEmail markw-at-illuminae-dot-com\n\n=head1 CONTRIBUTORS\n\nSusan Miller sjmiller at email-DOT-arizon-DOT-edu\nJason Stajich jason at bioperl-dot-org\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::GbrowseGFF;\nuse vars qw(%Defaults);\nuse strict;\n\n$Defaults{'Prefix'}   = 'EST';\n$Defaults{'HSPTag'}   = 'HSP';\n$Defaults{'MatchTag'} = 'match';\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::GbrowseGFF->new(@args);\n Function: Builds a new Bio::SearchIO::Writer::GbrowseGFF object \n Returns : an instance of Bio::SearchIO::Writer::GbrowseGFF\n Args    :  -e_value => 10   : set e_value parsing cutoff (default undef)\n            (note the -e_value flag is deprecated.)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"end":{"line":116,"character":9999},"start":{"character":0,"line":102}},"line":102},{"name":"SUPER","containerName":"new","kind":12,"line":105},{"line":112,"kind":12,"name":"Gbrowse_HSPID"},{"name":"Gbrowse_HITID","kind":12,"line":113},{"line":118,"kind":12,"range":{"start":{"character":0,"line":118},"end":{"character":9999,"line":121}},"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_incrementHSP($self)"},"children":[{"line":119,"kind":13,"localvar":"my","containerName":"_incrementHSP","name":"$self","definition":"my"},{"line":120,"name":"$self","kind":13,"containerName":"_incrementHSP"}],"containerName":"main::","name":"_incrementHSP","definition":"sub","detail":"($self)"},{"name":"Gbrowse_HSPID","kind":12,"line":120},{"line":123,"range":{"start":{"character":0,"line":123},"end":{"character":9999,"line":126}},"kind":12,"signature":{"label":"_incrementHIT($self)","documentation":"","parameters":[{"label":"$self"}]},"children":[{"localvar":"my","containerName":"_incrementHIT","kind":13,"name":"$self","line":124,"definition":"my"},{"line":125,"kind":13,"containerName":"_incrementHIT","name":"$self"}],"name":"_incrementHIT","containerName":"main::","definition":"sub","detail":"($self)"},{"line":125,"kind":12,"name":"Gbrowse_HITID"},{"signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: GbrowseGFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::SearchIO::Writer::GbrowseGFF.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Wilkinson <markw@illuminae.com>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::Writer::GbrowseGFF - Interface for outputting parsed search results in Gbrowse GFF format\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',      \n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'GbrowseGFF',\n                              -output_cigar   => 1,\n                              -output_signif  => 1,\n                              -file           => \">result.gff\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis writer produces Gbrowse flavour GFF from a Search::Result object.\n\n=head1 AUTHOR  Mark Wilkinson\n\nEmail markw-at-illuminae-dot-com\n\n=head1 CONTRIBUTORS\n\nSusan Miller sjmiller at email-DOT-arizon-DOT-edu\nJason Stajich jason at bioperl-dot-org\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::GbrowseGFF;\nuse vars qw(%Defaults);\nuse strict;\n\n$Defaults{'Prefix'}   = 'EST';\n$Defaults{'HSPTag'}   = 'HSP';\n$Defaults{'MatchTag'} = 'match';\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::GbrowseGFF->new(@args);\n Function: Builds a new Bio::SearchIO::Writer::GbrowseGFF object \n Returns : an instance of Bio::SearchIO::Writer::GbrowseGFF\n Args    :  -e_value => 10   : set e_value parsing cutoff (default undef)\n            (note the -e_value flag is deprecated.)\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    ($self->{'_evalue'},\n     $self->{'_cigar'},\n     $self->{'_prefix'},\n     $self->{'_signif'} ) = $self->_rearrange([qw(E_VALUE OUTPUT_CIGAR PREFIX\n\t\t\t\t\t\t OUTPUT_SIGNIF)], @args);\n    $self->{'_evalue'} && warn( \"Use of the -e_value argument is deprecated.\\nIn future, use \\$writer->filter(\\\"type\\\", \\&code) instead.\\n\\tparsing will proceed correctly with this e_value\\n\");\n    $self->{Gbrowse_HSPID} = 0;\n    $self->{Gbrowse_HITID} = 0;\n    $self->{'_prefix'} ||= $Defaults{'Prefix'};\n    return $self;\n}\n\nsub _incrementHSP {\n    my ($self) = @_;\n    return ++$self->{Gbrowse_HSPID};\n}\n\nsub _incrementHIT {\n    my ($self) = @_;\n    return ++$self->{Gbrowse_HITID}\n}\n# according to the GFF3 spec:\n#\"match\".  In addition to the generic \"match\"\n#type, there are the subclasses \"cDNA_match,\" \"EST_match,\"\n#\"translated_nucleotide_match,\" \"nucleotide_to_protein_match,\" and\n#\"nucleotide_motif.\"\n\n=head2 to_string\n\n Purpose   : Produce the Gbrowse format GFF lines for a Result\n Usage     : print $writer->to_string( $result_obj, @args);\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n             -version => 1|2|2.5|3  ; the GFF format you want to output (default 3)\n             -match_tag => match|cDNA_match|EST_match|translated_nucleotide_match\n                           nucleotide_to_protein_match|nucleotide_motif\n                           This is the SO term to be placed in GFF column 3.\n             -prefix => String to prefix the group by, default is EST \n                        (see %Defaults class variable) A default can also\n                        be set on object init\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n-reference => 'hit'|'query' ; whether the hit sequence name or the\n                              query sequence name is used as the\n                              'reference' sequence (GFF column 1)","label":"to_string($self,$result,@args)"},"line":155,"kind":12,"range":{"start":{"character":0,"line":155},"end":{"line":188,"character":9999}},"definition":"sub","detail":"($self,$result,@args)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"to_string","name":"$self","line":156},{"line":156,"containerName":"to_string","kind":13,"name":"$result"},{"name":"@args","containerName":"to_string","kind":13,"line":156},{"line":157,"name":"$format","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"line":157,"containerName":"to_string","kind":13,"name":"$reference"},{"line":158,"name":"$match_tag","containerName":"to_string","kind":13},{"kind":13,"containerName":"to_string","name":"$hsp_tag","line":158},{"name":"$prefix","containerName":"to_string","kind":13,"line":159},{"line":159,"name":"$self","containerName":"to_string","kind":13},{"name":"_rearrange","containerName":"to_string","kind":12,"line":159},{"line":163,"name":"@args","kind":13,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$self","line":164},{"name":"warn","containerName":"to_string","kind":12,"line":164},{"containerName":"to_string","kind":13,"name":"$reference","line":164},{"line":164,"kind":13,"containerName":"to_string","name":"$reference"},{"kind":13,"containerName":"to_string","name":"$reference","line":165},{"name":"$match_tag","containerName":"to_string","kind":13,"line":166},{"line":166,"kind":13,"containerName":"to_string","name":"$Defaults"},{"name":"$hsp_tag","kind":13,"containerName":"to_string","line":167},{"line":167,"name":"$Defaults","containerName":"to_string","kind":13},{"line":168,"containerName":"to_string","kind":13,"name":"$prefix"},{"line":168,"kind":13,"containerName":"to_string","name":"$self"},{"line":169,"name":"$self","containerName":"to_string","kind":13},{"name":"throw","kind":12,"containerName":"to_string","line":169},{"kind":13,"containerName":"to_string","name":"$reference","line":169},{"line":175,"name":"$format","containerName":"to_string","kind":13},{"definition":"my","line":176,"containerName":"to_string","localvar":"my","kind":13,"name":"$gffio"},{"containerName":"to_string","kind":12,"name":"new","line":176},{"line":176,"name":"$format","kind":13,"containerName":"to_string"},{"line":179,"name":"$gffio","containerName":"to_string","kind":13},{"line":182,"name":"$GFF","containerName":"to_string","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$cigar","line":182},{"name":"$score","kind":13,"containerName":"to_string","line":182},{"line":183,"name":"$resultfilter","kind":13,"localvar":"my","containerName":"to_string","definition":"my"},{"kind":13,"containerName":"to_string","name":"$hitfilter","line":183},{"line":183,"name":"$hspfilter","kind":13,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$self","line":184},{"kind":12,"containerName":"to_string","name":"filter","line":184},{"line":185,"name":"$self","containerName":"to_string","kind":13},{"line":185,"kind":12,"containerName":"to_string","name":"filter"},{"name":"$self","kind":13,"containerName":"to_string","line":186},{"line":186,"name":"filter","containerName":"to_string","kind":12},{"name":"$result","containerName":"to_string","kind":13,"line":187},{"line":187,"name":"can","kind":12,"containerName":"to_string"},{"line":187,"name":"$result","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"rewind","line":187},{"line":188,"name":"$resultfilter","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$resultfilter","line":188}],"containerName":"main::","name":"to_string"},{"name":"Bio","containerName":"Tools::GFF","kind":12,"line":176},{"line":188,"containerName":null,"kind":13,"name":"$result"},{"line":190,"localvar":"my","containerName":null,"kind":13,"name":"$hit","definition":"my"},{"line":190,"kind":13,"containerName":null,"name":"$result"},{"containerName":"main::","kind":12,"name":"next_hit","line":190},{"line":192,"containerName":null,"kind":13,"name":"%self"},{"name":"_evalue","kind":12,"line":192},{"name":"$hit","kind":13,"containerName":null,"line":193},{"name":"significance","containerName":"main::","kind":12,"line":193},{"line":193,"name":"%self","containerName":null,"kind":13},{"line":193,"kind":12,"name":"_evalue"},{"name":"$hitfilter","containerName":null,"kind":13,"line":195},{"line":195,"kind":13,"containerName":null,"name":"$hitfilter"},{"name":"$hit","kind":13,"containerName":null,"line":195},{"definition":"my","line":197,"name":"$refseq","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$reference","line":197},{"line":197,"containerName":null,"kind":13,"name":"$hit"},{"containerName":"main::","kind":12,"name":"name","line":197},{"containerName":null,"kind":13,"name":"$result","line":197},{"kind":12,"containerName":"main::","name":"query_name","line":197},{"definition":"my","line":198,"localvar":"my","containerName":null,"kind":13,"name":"$seqname"},{"containerName":null,"kind":13,"name":"$reference","line":198},{"name":"$result","kind":13,"containerName":null,"line":198},{"kind":12,"containerName":"main::","name":"query_name","line":198},{"line":198,"name":"$hit","containerName":null,"kind":13},{"name":"name","containerName":"main::","kind":12,"line":198},{"line":199,"kind":13,"containerName":null,"name":"%self"},{"name":"_signif","kind":12,"line":199},{"kind":13,"containerName":null,"name":"$score","line":200},{"line":200,"name":"$hit","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"significance","line":200},{"name":"$score","kind":13,"containerName":null,"line":202},{"containerName":null,"kind":13,"name":"$hit","line":202},{"containerName":"main::","kind":12,"name":"raw_score","line":202},{"kind":13,"containerName":null,"name":"$self","line":204},{"line":204,"containerName":"main::","kind":12,"name":"throw"},{"line":204,"name":"$refseq","kind":13,"containerName":null},{"definition":"my","line":205,"name":"$source","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$hit","line":205},{"line":205,"kind":12,"containerName":"main::","name":"algorithm"},{"name":"$self","containerName":null,"kind":13,"line":206},{"line":206,"containerName":"main::","kind":12,"name":"throw"},{"line":206,"kind":13,"containerName":null,"name":"$refseq"},{"name":"$self","containerName":null,"kind":13,"line":207},{"line":207,"containerName":"main::","kind":12,"name":"throw"},{"line":207,"name":"$source","kind":13,"containerName":null},{"line":209,"kind":13,"localvar":"my","containerName":null,"name":"@plus_hsps","definition":"my"},{"kind":13,"localvar":"my","containerName":null,"name":"@minus_hsps","line":210,"definition":"my"},{"kind":13,"localvar":"my","containerName":null,"name":"$qpmin","line":215,"definition":"my"},{"line":215,"name":"$qpmax","kind":13,"containerName":null},{"name":"$qmmin","kind":13,"containerName":null,"line":215},{"containerName":null,"kind":13,"name":"$qmmax","line":215},{"kind":13,"containerName":null,"name":"$spmin","line":215},{"line":215,"name":"$spmax","kind":13,"containerName":null},{"line":215,"name":"$smmin","containerName":null,"kind":13},{"line":215,"name":"$smmax","containerName":null,"kind":13},{"definition":"my","name":"$hsp","localvar":"my","kind":13,"containerName":null,"line":216},{"name":"$hit","kind":13,"containerName":null,"line":216},{"line":216,"containerName":"main::","kind":12,"name":"next_hsp"},{"containerName":null,"kind":13,"name":"%self","line":217},{"line":217,"name":"_evalue","kind":12},{"containerName":null,"kind":13,"name":"$hsp","line":219},{"containerName":"main::","kind":12,"name":"significance","line":219},{"name":"%self","containerName":null,"kind":13,"line":219},{"line":219,"name":"_evalue","kind":12},{"line":221,"kind":13,"containerName":null,"name":"$hspfilter"},{"line":221,"containerName":null,"kind":13,"name":"$hspfilter"},{"containerName":null,"kind":13,"name":"$hsp","line":221},{"line":222,"name":"$hsp","kind":13,"containerName":null},{"line":222,"name":"hit","containerName":"main::","kind":12},{"line":222,"name":"strand","containerName":"main::","kind":12},{"name":"@plus_hsps","containerName":null,"kind":13,"line":223},{"kind":13,"containerName":null,"name":"$hsp","line":223},{"name":"%qpmin","kind":13,"containerName":null,"line":224},{"kind":13,"containerName":null,"name":"$qpmin","line":225},{"name":"$hsp","containerName":null,"kind":13,"line":225},{"containerName":"main::","kind":12,"name":"query","line":225},{"line":225,"name":"start","containerName":"main::","kind":12},{"name":"$hsp","containerName":null,"kind":13,"line":225},{"line":225,"containerName":"main::","kind":12,"name":"query"},{"name":"start","kind":12,"containerName":"main::","line":225},{"line":225,"containerName":null,"kind":13,"name":"$qpmin"},{"name":"$qpmax","containerName":null,"kind":13,"line":226},{"line":226,"name":"$hsp","containerName":null,"kind":13},{"line":226,"name":"query","kind":12,"containerName":"main::"},{"line":226,"name":"end","kind":12,"containerName":"main::"},{"name":"$hsp","containerName":null,"kind":13,"line":226},{"name":"query","containerName":"main::","kind":12,"line":226},{"name":"end","kind":12,"containerName":"main::","line":226},{"name":"$qpmax","kind":13,"containerName":null,"line":226},{"containerName":null,"kind":13,"name":"$spmin","line":227},{"line":227,"kind":13,"containerName":null,"name":"$hsp"},{"line":227,"kind":12,"containerName":"main::","name":"hit"},{"name":"start","containerName":"main::","kind":12,"line":227},{"line":227,"name":"$hsp","containerName":null,"kind":13},{"line":227,"name":"hit","kind":12,"containerName":"main::"},{"containerName":"main::","kind":12,"name":"start","line":227},{"kind":13,"containerName":null,"name":"$spmin","line":227},{"name":"$spmax","kind":13,"containerName":null,"line":228},{"name":"$hsp","containerName":null,"kind":13,"line":228},{"line":228,"containerName":"main::","kind":12,"name":"hit"},{"kind":12,"containerName":"main::","name":"end","line":228},{"line":228,"name":"$hsp","containerName":null,"kind":13},{"name":"hit","containerName":"main::","kind":12,"line":228},{"line":228,"name":"end","kind":12,"containerName":"main::"},{"name":"%spmax","containerName":null,"kind":13,"line":228},{"containerName":null,"kind":13,"name":"$qpmin","line":230},{"line":230,"name":"$hsp","kind":13,"containerName":null},{"line":230,"kind":12,"containerName":"main::","name":"query"},{"line":230,"name":"start","kind":12,"containerName":"main::"},{"line":231,"kind":13,"containerName":null,"name":"$qpmax"},{"line":231,"name":"$hsp","kind":13,"containerName":null},{"line":231,"kind":12,"containerName":"main::","name":"query"},{"kind":12,"containerName":"main::","name":"end","line":231},{"name":"$spmin","kind":13,"containerName":null,"line":232},{"kind":13,"containerName":null,"name":"$hsp","line":232},{"name":"hit","containerName":"main::","kind":12,"line":232},{"kind":12,"containerName":"main::","name":"start","line":232},{"line":233,"name":"$spmax","kind":13,"containerName":null},{"name":"$hsp","containerName":null,"kind":13,"line":233},{"line":233,"name":"hit","containerName":"main::","kind":12},{"kind":12,"containerName":"main::","name":"end","line":233},{"name":"$hsp","containerName":null,"kind":13,"line":236},{"line":236,"name":"hit","kind":12,"containerName":"main::"},{"line":236,"name":"strand","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"@minus_hsps","line":237},{"line":237,"name":"$hsp","containerName":null,"kind":13},{"line":238,"name":"%qmmin","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$qmmin","line":239},{"line":239,"kind":13,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","kind":12,"line":239},{"containerName":"main::","kind":12,"name":"start","line":239},{"name":"$hsp","kind":13,"containerName":null,"line":239},{"line":239,"name":"query","containerName":"main::","kind":12},{"containerName":"main::","kind":12,"name":"start","line":239},{"line":239,"name":"$qmmin","containerName":null,"kind":13},{"line":240,"kind":13,"containerName":null,"name":"$qmmax"},{"line":240,"name":"$hsp","kind":13,"containerName":null},{"line":240,"name":"query","kind":12,"containerName":"main::"},{"line":240,"name":"end","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$hsp","line":240},{"name":"query","containerName":"main::","kind":12,"line":240},{"line":240,"containerName":"main::","kind":12,"name":"end"},{"name":"$qmmax","containerName":null,"kind":13,"line":240},{"line":241,"kind":13,"containerName":null,"name":"$smmin"},{"containerName":null,"kind":13,"name":"$hsp","line":241},{"line":241,"name":"hit","containerName":"main::","kind":12},{"containerName":"main::","kind":12,"name":"start","line":241},{"line":241,"name":"$hsp","kind":13,"containerName":null},{"name":"hit","kind":12,"containerName":"main::","line":241},{"containerName":"main::","kind":12,"name":"start","line":241},{"line":241,"name":"$smmin","containerName":null,"kind":13},{"line":242,"kind":13,"containerName":null,"name":"$smmax"},{"name":"$hsp","kind":13,"containerName":null,"line":242},{"line":242,"name":"hit","containerName":"main::","kind":12},{"line":242,"kind":12,"containerName":"main::","name":"end"},{"line":242,"kind":13,"containerName":null,"name":"$hsp"},{"line":242,"name":"hit","containerName":"main::","kind":12},{"name":"end","containerName":"main::","kind":12,"line":242},{"name":"%smmax","kind":13,"containerName":null,"line":242},{"line":244,"containerName":null,"kind":13,"name":"$qmmin"},{"name":"$hsp","kind":13,"containerName":null,"line":244},{"line":244,"kind":12,"containerName":"main::","name":"query"},{"containerName":"main::","kind":12,"name":"start","line":244},{"name":"$qmmax","containerName":null,"kind":13,"line":245},{"line":245,"kind":13,"containerName":null,"name":"$hsp"},{"line":245,"name":"query","containerName":"main::","kind":12},{"name":"end","containerName":"main::","kind":12,"line":245},{"kind":13,"containerName":null,"name":"$smmin","line":246},{"line":246,"containerName":null,"kind":13,"name":"$hsp"},{"line":246,"containerName":"main::","kind":12,"name":"hit"},{"name":"start","kind":12,"containerName":"main::","line":246},{"kind":13,"containerName":null,"name":"$smmax","line":247},{"name":"$hsp","kind":13,"containerName":null,"line":247},{"line":247,"kind":12,"containerName":"main::","name":"hit"},{"line":247,"kind":12,"containerName":"main::","name":"end"},{"line":252,"kind":13,"containerName":null,"name":"@plus_hsps"},{"kind":13,"containerName":null,"name":"@minus_hsps","line":252},{"definition":"my","line":253,"kind":13,"localvar":"my","containerName":null,"name":"$ID"},{"line":253,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_incrementHIT","line":253},{"line":261,"name":"@plus_hsps","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"%tags","line":262,"definition":"my"},{"line":264,"name":"%format","kind":13,"containerName":null},{"line":265,"containerName":null,"kind":13,"name":"%tags"},{"kind":13,"containerName":null,"name":"%tags","line":266},{"line":266,"name":"$qmmin","containerName":null,"kind":13},{"line":267,"containerName":null,"kind":13,"name":"%tags"},{"name":"%qmmax","containerName":null,"kind":13,"line":267},{"line":269,"name":"%tags","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":271},{"name":"%tags","kind":13,"containerName":null,"line":272},{"line":272,"containerName":null,"kind":13,"name":"$cigar"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$feat","line":274},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":274},{"line":274,"containerName":"main::","kind":12,"name":"new"},{"line":275,"containerName":null,"kind":13,"name":"$refseq"},{"name":"$source","kind":13,"containerName":null,"line":276},{"kind":13,"containerName":null,"name":"$match_tag","line":277},{"line":278,"name":"$spmin","kind":13,"containerName":null},{"line":279,"containerName":null,"kind":13,"name":"$spmax"},{"name":"$score","containerName":null,"kind":13,"line":280},{"name":"%tags","containerName":null,"kind":13,"line":283},{"line":287,"localvar":"my","containerName":null,"kind":13,"name":"$formatter","definition":"my"},{"line":287,"kind":12,"containerName":"Tools::GFF","name":"Bio"},{"containerName":"main::","kind":12,"name":"new","line":287},{"containerName":null,"kind":13,"name":"$format","line":287},{"line":288,"name":"$GFF","containerName":null,"kind":13},{"name":"$feat","kind":13,"containerName":null,"line":288},{"line":288,"name":"gff_string","kind":12,"containerName":"main::"},{"line":288,"containerName":null,"kind":13,"name":"$formatter"},{"name":"@minus_hsps","containerName":null,"kind":13,"line":290},{"line":291,"kind":13,"localvar":"my","containerName":null,"name":"%tags","definition":"my"},{"containerName":null,"kind":13,"name":"%format","line":293},{"kind":13,"containerName":null,"name":"%tags","line":294},{"line":295,"name":"%tags","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$qpmax","line":295},{"name":"%tags","containerName":null,"kind":13,"line":296},{"kind":13,"containerName":null,"name":"%qpmin","line":296},{"name":"%tags","containerName":null,"kind":13,"line":299},{"name":"$feat","kind":13,"localvar":"my","containerName":null,"line":301,"definition":"my"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":301},{"line":301,"containerName":"main::","kind":12,"name":"new"},{"name":"$refseq","kind":13,"containerName":null,"line":302},{"line":303,"name":"$source","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$match_tag","line":304},{"name":"$smmin","kind":13,"containerName":null,"line":305},{"name":"$smmax","containerName":null,"kind":13,"line":306},{"name":"$score","containerName":null,"kind":13,"line":307},{"kind":13,"containerName":null,"name":"%tags","line":310},{"line":313,"kind":13,"localvar":"my","containerName":null,"name":"$formatter","definition":"my"},{"name":"Bio","kind":12,"containerName":"Tools::GFF","line":313},{"name":"new","kind":12,"containerName":"main::","line":313},{"line":313,"kind":13,"containerName":null,"name":"$format"},{"name":"$GFF","kind":13,"containerName":null,"line":314},{"line":314,"name":"$feat","kind":13,"containerName":null},{"line":314,"kind":12,"containerName":"main::","name":"gff_string"},{"line":314,"name":"$formatter","containerName":null,"kind":13},{"line":318,"kind":13,"localvar":"my","containerName":null,"name":"$hsp","definition":"my"},{"line":318,"name":"@plus_hsps","containerName":null,"kind":13},{"line":319,"name":"$hspID","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":319,"name":"$self","containerName":null,"kind":13},{"line":319,"name":"_incrementHSP","kind":12,"containerName":"main::"},{"definition":"my","line":320,"localvar":"my","containerName":null,"kind":13,"name":"$qstart"},{"name":"$hsp","containerName":null,"kind":13,"line":320},{"line":320,"containerName":"main::","kind":12,"name":"query"},{"line":320,"name":"start","containerName":"main::","kind":12},{"definition":"my","line":321,"name":"$qend","localvar":"my","kind":13,"containerName":null},{"name":"$hsp","containerName":null,"kind":13,"line":321},{"name":"query","kind":12,"containerName":"main::","line":321},{"containerName":"main::","kind":12,"name":"end","line":321},{"definition":"my","line":322,"localvar":"my","containerName":null,"kind":13,"name":"$sstart"},{"name":"$hsp","kind":13,"containerName":null,"line":322},{"name":"hit","kind":12,"containerName":"main::","line":322},{"kind":12,"containerName":"main::","name":"start","line":322},{"definition":"my","name":"$send","localvar":"my","containerName":null,"kind":13,"line":323},{"line":323,"name":"$hsp","containerName":null,"kind":13},{"line":323,"containerName":"main::","kind":12,"name":"hit"},{"line":323,"containerName":"main::","kind":12,"name":"end"},{"definition":"my","line":324,"localvar":"my","kind":13,"containerName":null,"name":"$score"},{"line":324,"name":"$hsp","containerName":null,"kind":13},{"line":324,"containerName":"main::","kind":12,"name":"score"},{"definition":"my","line":326,"name":"%tags","kind":13,"localvar":"my","containerName":null},{"line":329,"containerName":null,"kind":13,"name":"%format"},{"line":330,"name":"%tags","containerName":null,"kind":13},{"line":331,"kind":13,"containerName":null,"name":"%tags"},{"kind":13,"containerName":null,"name":"$qstart","line":331},{"line":332,"name":"%tags","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%qend","line":332},{"line":335,"name":"%tags","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%self","line":337},{"containerName":null,"kind":13,"name":"%tags","line":338},{"line":338,"kind":13,"containerName":null,"name":"$hsp"},{"line":338,"containerName":"main::","kind":12,"name":"cigar_string"},{"definition":"my","name":"$feat","kind":13,"localvar":"my","containerName":null,"line":341},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":341},{"line":341,"containerName":"main::","kind":12,"name":"new"},{"line":342,"kind":13,"containerName":null,"name":"$refseq"},{"containerName":null,"kind":13,"name":"$source","line":343},{"containerName":null,"kind":13,"name":"$hsp_tag","line":344},{"kind":13,"containerName":null,"name":"$sstart","line":345},{"line":346,"containerName":null,"kind":13,"name":"$send"},{"name":"$score","containerName":null,"kind":13,"line":347},{"name":"%tags","kind":13,"containerName":null,"line":350},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$formatter","line":353},{"line":353,"kind":12,"containerName":"Tools::GFF","name":"Bio"},{"line":353,"name":"new","kind":12,"containerName":"main::"},{"line":353,"kind":13,"containerName":null,"name":"$format"},{"line":354,"name":"$GFF","kind":13,"containerName":null},{"line":354,"kind":13,"containerName":null,"name":"$feat"},{"line":354,"name":"gff_string","kind":12,"containerName":"main::"},{"line":354,"name":"$formatter","containerName":null,"kind":13},{"name":"$hsp","kind":13,"localvar":"my","containerName":null,"line":357,"definition":"my"},{"name":"@minus_hsps","containerName":null,"kind":13,"line":357},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$hspID","line":358},{"name":"$self","containerName":null,"kind":13,"line":358},{"line":358,"kind":12,"containerName":"main::","name":"_incrementHSP"},{"line":359,"localvar":"my","containerName":null,"kind":13,"name":"$qstart","definition":"my"},{"containerName":null,"kind":13,"name":"$hsp","line":359},{"containerName":"main::","kind":12,"name":"query","line":359},{"containerName":"main::","kind":12,"name":"start","line":359},{"definition":"my","name":"$qend","localvar":"my","kind":13,"containerName":null,"line":360},{"line":360,"containerName":null,"kind":13,"name":"$hsp"},{"kind":12,"containerName":"main::","name":"query","line":360},{"line":360,"containerName":"main::","kind":12,"name":"end"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$sstart","line":361},{"name":"$hsp","kind":13,"containerName":null,"line":361},{"name":"hit","kind":12,"containerName":"main::","line":361},{"kind":12,"containerName":"main::","name":"start","line":361},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$send","line":362},{"containerName":null,"kind":13,"name":"$hsp","line":362},{"line":362,"containerName":"main::","kind":12,"name":"hit"},{"line":362,"containerName":"main::","kind":12,"name":"end"},{"line":363,"localvar":"my","kind":13,"containerName":null,"name":"$score","definition":"my"},{"line":363,"containerName":null,"kind":13,"name":"$hsp"},{"line":363,"name":"score","containerName":"main::","kind":12},{"kind":13,"localvar":"my","containerName":null,"name":"%tags","line":365,"definition":"my"},{"line":368,"name":"%format","containerName":null,"kind":13},{"line":369,"containerName":null,"kind":13,"name":"%tags"},{"line":370,"kind":13,"containerName":null,"name":"%tags"},{"line":370,"name":"$qend","kind":13,"containerName":null},{"line":371,"containerName":null,"kind":13,"name":"%tags"},{"line":371,"kind":13,"containerName":null,"name":"%qstart"},{"name":"%tags","kind":13,"containerName":null,"line":374},{"line":376,"name":"%self","containerName":null,"kind":13},{"line":377,"containerName":null,"kind":13,"name":"%tags"},{"line":377,"kind":13,"containerName":null,"name":"$hsp"},{"line":377,"name":"cigar_string","containerName":"main::","kind":12},{"line":380,"kind":13,"localvar":"my","containerName":null,"name":"$feat","definition":"my"},{"line":380,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":380,"name":"new","containerName":"main::","kind":12},{"name":"$refseq","kind":13,"containerName":null,"line":381},{"name":"$source","containerName":null,"kind":13,"line":382},{"line":383,"containerName":null,"kind":13,"name":"$hsp_tag"},{"name":"$sstart","kind":13,"containerName":null,"line":384},{"containerName":null,"kind":13,"name":"$send","line":385},{"line":386,"containerName":null,"kind":13,"name":"$score"},{"name":"%tags","kind":13,"containerName":null,"line":389},{"definition":"my","line":392,"kind":13,"localvar":"my","containerName":null,"name":"$formatter"},{"line":392,"kind":12,"containerName":"Tools::GFF","name":"Bio"},{"line":392,"name":"new","kind":12,"containerName":"main::"},{"line":392,"kind":13,"containerName":null,"name":"$format"},{"line":393,"kind":13,"containerName":null,"name":"$GFF"},{"line":393,"name":"$feat","kind":13,"containerName":null},{"name":"gff_string","kind":12,"containerName":"main::","line":393},{"line":393,"name":"$formatter","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$GFF","line":396},{"detail":"($self,$method,$code)","definition":"sub","containerName":"main::","name":"significance_filter","children":[{"line":400,"name":"$self","containerName":"significance_filter","localvar":"my","kind":13,"definition":"my"},{"name":"$method","containerName":"significance_filter","kind":13,"line":400},{"kind":13,"containerName":"significance_filter","name":"$code","line":400},{"line":401,"containerName":"significance_filter","kind":13,"name":"$method"},{"name":"$method","kind":13,"containerName":"significance_filter","line":402},{"line":402,"name":"$method","containerName":"significance_filter","kind":13},{"line":403,"name":"$method","containerName":"significance_filter","kind":13},{"kind":13,"containerName":"significance_filter","name":"$method","line":404},{"name":"$method","containerName":"significance_filter","kind":13,"line":405},{"name":"$self","containerName":"significance_filter","kind":13,"line":406},{"containerName":"significance_filter","kind":12,"name":"warn","line":406},{"kind":13,"containerName":"significance_filter","name":"$code","line":409},{"line":410,"kind":13,"containerName":"significance_filter","name":"$self"},{"name":"throw","kind":12,"containerName":"significance_filter","line":410},{"line":410,"name":"$code","containerName":"significance_filter","kind":13},{"line":411,"containerName":"significance_filter","kind":13,"name":"$self"},{"line":411,"containerName":"significance_filter","kind":13,"name":"$method"},{"line":411,"containerName":"significance_filter","kind":13,"name":"$code"},{"line":413,"containerName":"significance_filter","kind":13,"name":"$self"},{"line":413,"kind":13,"containerName":"significance_filter","name":"$method"}],"signature":{"parameters":[{"label":"$self"},{"label":"$method"},{"label":"$code"}],"documentation":"","label":"significance_filter($self,$method,$code)"},"kind":12,"range":{"start":{"line":399,"character":0},"end":{"line":414,"character":9999}},"line":399},{"definition":"sub","children":[],"containerName":"main::","name":"start_report","line":426,"range":{"start":{"line":426,"character":0},"end":{"line":426,"character":9999}},"kind":12},{"definition":"sub","containerName":"main::","name":"end_report","children":[],"kind":12,"range":{"start":{"line":439,"character":0},"end":{"line":439,"character":9999}},"line":439}]}