{"version":5,"vars":[{"line":120,"containerName":"strict::Bio::Ext","kind":2,"name":"Align"},{"line":128,"name":"base","containerName":"","kind":2},{"line":130,"kind":12,"range":{"end":{"character":9999,"line":151},"start":{"line":130,"character":0}},"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"line":131,"containerName":"new","localvar":"my","kind":13,"name":"$class","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":131},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":132},{"name":"$class","kind":13,"containerName":"new","line":132},{"line":132,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":133,"localvar":"my","kind":13,"containerName":"new","name":"$min"},{"name":"$max","kind":13,"containerName":"new","line":133},{"line":133,"name":"$lump","kind":13,"containerName":"new"},{"line":134,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","kind":12,"containerName":"new","line":134},{"line":134,"name":"@args","kind":13,"containerName":"new"},{"line":136,"name":"$min","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$min","line":137},{"line":140,"name":"$max","containerName":"new","kind":13},{"line":141,"name":"$max","containerName":"new","kind":13},{"line":144,"name":"$lump","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$lump","line":145},{"line":148,"containerName":"new","kind":13,"name":"$self"},{"name":"_engine","containerName":"new","kind":12,"line":148},{"line":148,"containerName":"new","kind":13,"name":"$min"},{"line":148,"name":"$max","containerName":"new","kind":13},{"line":148,"containerName":"new","kind":13,"name":"$lump"},{"kind":13,"containerName":"new","name":"$self","line":150}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"kind":12,"containerName":"new","name":"SUPER","line":132},{"line":148,"name":"Bio","kind":12,"containerName":"Ext::Align::new_Histogram"},{"detail":"($self,$score)","definition":"sub","name":"add_score","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_score","line":165,"definition":"my"},{"line":165,"name":"$score","kind":13,"containerName":"add_score"},{"definition":"my","localvar":"my","kind":13,"containerName":"add_score","name":"$eng","line":166},{"name":"$eng","kind":13,"containerName":"add_score","line":167},{"line":167,"name":"$self","kind":13,"containerName":"add_score"},{"containerName":"add_score","kind":12,"name":"_engine","line":167},{"line":169,"kind":13,"containerName":"add_score","name":"$eng"},{"kind":12,"containerName":"add_score","name":"add","line":169},{"containerName":"add_score","kind":13,"name":"$score","line":169}],"signature":{"label":"add_score($self,$score)","documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :","parameters":[{"label":"$self"},{"label":"$score"}]},"kind":12,"range":{"end":{"character":9999,"line":170},"start":{"line":164,"character":0}},"line":164},{"line":183,"kind":12,"range":{"end":{"character":9999,"line":187},"start":{"character":0,"line":183}},"signature":{"label":"fit_evd($self,@args)","documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"line":184,"name":"$self","containerName":"fit_evd","localvar":"my","kind":13,"definition":"my"},{"name":"@args","containerName":"fit_evd","kind":13,"line":184},{"line":186,"name":"$self","kind":13,"containerName":"fit_evd"},{"line":186,"containerName":"fit_evd","kind":12,"name":"_engine"},{"name":"fit_EVD","kind":12,"containerName":"fit_evd","line":186}],"name":"fit_evd","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"containerName":"main::","name":"fit_Gaussian","children":[{"line":202,"name":"$self","localvar":"my","kind":13,"containerName":"fit_Gaussian","definition":"my"},{"line":202,"name":"$high","containerName":"fit_Gaussian","kind":13},{"line":204,"name":"$high","containerName":"fit_Gaussian","kind":13},{"line":205,"name":"$high","kind":13,"containerName":"fit_Gaussian"},{"line":208,"name":"$self","kind":13,"containerName":"fit_Gaussian"},{"containerName":"fit_Gaussian","kind":12,"name":"_engine","line":208},{"name":"fit_Gaussian","kind":12,"containerName":"fit_Gaussian","line":208},{"containerName":"fit_Gaussian","kind":13,"name":"$high","line":208}],"detail":"($self,$high)","definition":"sub","range":{"end":{"character":9999,"line":209},"start":{"line":201,"character":0}},"kind":12,"line":201,"signature":{"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$high"}],"label":"fit_Gaussian($self,$high)"}},{"signature":{"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub fit_Gaussian{\n   my ($self,$high) = @_;\n\n   if( ! defined $high ) {\n       $high = 10000;\n   }\n\n   return $self->_engine()->fit_Gaussian($high);\n}\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : $eval = $dis->evalue($score)\n Function: Returns the evalue of this score\n Returns : float\n Args    :","parameters":[{"label":"$self"},{"label":"$score"}],"label":"evalue($self,$score)"},"kind":12,"range":{"end":{"line":228,"character":9999},"start":{"character":0,"line":223}},"line":223,"detail":"($self,$score)","definition":"sub","name":"evalue","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"evalue","name":"$self","line":224},{"name":"$score","containerName":"evalue","kind":13,"line":224},{"line":226,"containerName":"evalue","kind":13,"name":"$self"},{"containerName":"evalue","kind":12,"name":"_engine","line":226},{"name":"evalue","containerName":"evalue","kind":12,"line":226},{"line":226,"name":"$score","kind":13,"containerName":"evalue"}]},{"line":243,"range":{"end":{"character":9999,"line":249},"start":{"line":243,"character":0}},"kind":12,"signature":{"label":"_engine($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub fit_Gaussian{\n   my ($self,$high) = @_;\n\n   if( ! defined $high ) {\n       $high = 10000;\n   }\n\n   return $self->_engine()->fit_Gaussian($high);\n}\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : $eval = $dis->evalue($score)\n Function: Returns the evalue of this score\n Returns : float\n Args    :\n\n\n\nsub evalue{\n   my ($self,$score) = @_;\n\n   return $self->_engine()->evalue($score);\n\n}\n\n\n\n=head2 _engine\n\n Title   : _engine\n Usage   : $obj->_engine($newval)\n Function: underlyine bp_sw:: histogram engine\n Returns : value of _engine\n Args    : newvalue (optional)"},"children":[{"line":244,"name":"$self","kind":13,"localvar":"my","containerName":"_engine","definition":"my"},{"containerName":"_engine","kind":13,"name":"$value","line":244},{"line":245,"kind":13,"containerName":"_engine","name":"$value"},{"name":"$self","kind":13,"containerName":"_engine","line":246},{"name":"$value","kind":13,"containerName":"_engine","line":246},{"containerName":"_engine","kind":13,"name":"$self","line":248}],"containerName":"main::","name":"_engine","definition":"sub","detail":"($self,$value)"}]}