{"vars":[{"line":104,"name":"base","containerName":"","kind":2},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :","label":"identities($self,@args)"},"line":174,"range":{"start":{"line":174,"character":0},"end":{"character":9999,"line":177}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","localvar":"my","containerName":"identities","kind":13,"name":"$self","line":175},{"name":"@args","containerName":"identities","kind":13,"line":175},{"containerName":"identities","kind":13,"name":"$self","line":176},{"line":176,"kind":12,"containerName":"identities","name":"throw_not_implemented"}],"name":"identities","containerName":"main::"},{"name":"num_identical","containerName":"main::","children":[{"line":180,"name":"identities","containerName":"num_identical","kind":12}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":180},"start":{"line":180,"character":0}},"line":180},{"line":195,"range":{"start":{"character":0,"line":195},"end":{"character":9999,"line":198}},"kind":12,"signature":{"label":"conserved($self,@args)","documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"line":196,"containerName":"conserved","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":196,"kind":13,"containerName":"conserved","name":"@args"},{"containerName":"conserved","kind":13,"name":"$self","line":197},{"name":"throw_not_implemented","containerName":"conserved","kind":12,"line":197}],"containerName":"main::","name":"conserved","definition":"sub","detail":"($self,@args)"},{"definition":"sub","name":"num_conserved","containerName":"main::","children":[{"line":201,"name":"conserved","containerName":"num_conserved","kind":12}],"range":{"start":{"line":201,"character":0},"end":{"character":9999,"line":201}},"kind":12,"line":201},{"detail":"($self,$type,@args)","definition":"sub","name":"length","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"length","line":215},{"name":"$type","kind":13,"containerName":"length","line":215},{"containerName":"length","kind":13,"name":"@args","line":215},{"line":216,"containerName":"length","kind":13,"name":"$self"},{"kind":12,"containerName":"length","name":"throw_not_implemented","line":216}],"signature":{"label":"length($self,$type,@args)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'"},"range":{"end":{"line":217,"character":9999},"start":{"line":214,"character":0}},"kind":12,"line":214},{"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)","label":"frac_identical($self,$type,@args)"},"kind":12,"range":{"start":{"line":233,"character":0},"end":{"character":9999,"line":236}},"line":233,"detail":"($self,$type,@args)","definition":"sub","name":"frac_identical","containerName":"main::","children":[{"line":234,"localvar":"my","kind":13,"containerName":"frac_identical","name":"$self","definition":"my"},{"line":234,"name":"$type","containerName":"frac_identical","kind":13},{"containerName":"frac_identical","kind":13,"name":"@args","line":234},{"line":235,"name":"$self","containerName":"frac_identical","kind":13},{"line":235,"name":"throw_not_implemented","containerName":"frac_identical","kind":12}]},{"signature":{"label":"percent_identity($self,$type,@args)","documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}]},"line":249,"range":{"start":{"character":0,"line":249},"end":{"line":252,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$type,@args)","children":[{"line":250,"localvar":"my","kind":13,"containerName":"percent_identity","name":"$self","definition":"my"},{"name":"$type","kind":13,"containerName":"percent_identity","line":250},{"line":250,"name":"@args","kind":13,"containerName":"percent_identity"},{"name":"$self","containerName":"percent_identity","kind":13,"line":251},{"name":"frac_identical","containerName":"percent_identity","kind":12,"line":251},{"line":251,"name":"$type","containerName":"percent_identity","kind":13},{"line":251,"containerName":"percent_identity","kind":13,"name":"@args"}],"name":"percent_identity","containerName":"main::"},{"range":{"start":{"line":268,"character":0},"end":{"line":271,"character":9999}},"kind":12,"line":268,"signature":{"label":"frac_conserved($self,$type,@args)","documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}]},"name":"frac_conserved","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"frac_conserved","line":269},{"line":269,"name":"$type","containerName":"frac_conserved","kind":13},{"name":"@args","containerName":"frac_conserved","kind":13,"line":269},{"containerName":"frac_conserved","kind":13,"name":"$self","line":270},{"containerName":"frac_conserved","kind":12,"name":"throw_not_implemented","line":270}],"detail":"($self,$type,@args)","definition":"sub"},{"line":284,"kind":12,"range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":287}},"signature":{"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"label":"percent_conserved($self,$type,@args)"},"children":[{"line":285,"kind":13,"localvar":"my","containerName":"percent_conserved","name":"$self","definition":"my"},{"name":"$type","containerName":"percent_conserved","kind":13,"line":285},{"line":285,"name":"@args","kind":13,"containerName":"percent_conserved"},{"line":286,"kind":13,"containerName":"percent_conserved","name":"$self"},{"line":286,"name":"frac_conserved","containerName":"percent_conserved","kind":12},{"name":"$type","kind":13,"containerName":"percent_conserved","line":286},{"line":286,"name":"@args","kind":13,"containerName":"percent_conserved"}],"containerName":"main::","name":"percent_conserved","definition":"sub","detail":"($self,$type,@args)"},{"detail":"($self,$type,@args)","definition":"sub","name":"frac_aligned","containerName":"main::","children":[{"definition":"my","line":304,"localvar":"my","kind":13,"containerName":"frac_aligned","name":"$self"},{"line":304,"name":"$type","kind":13,"containerName":"frac_aligned"},{"kind":13,"containerName":"frac_aligned","name":"@args","line":304},{"name":"$self","containerName":"frac_aligned","kind":13,"line":305},{"name":"throw_not_implemented","containerName":"frac_aligned","kind":12,"line":305}],"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_conserved {\n    my ($self, $type, @args) = @_;\n    return $self->frac_conserved($type, @args) * 100;\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Usage   : $tiling->frac_aligned($type)\n Function: Return the fraction of B<input> sequence length consisting\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)","label":"frac_aligned($self,$type,@args)"},"range":{"end":{"character":9999,"line":306},"start":{"character":0,"line":303}},"kind":12,"line":303},{"line":309,"kind":12,"range":{"start":{"character":0,"line":309},"end":{"character":9999,"line":309}},"definition":"sub","children":[{"line":309,"name":"frac_aligned","containerName":"frac_aligned_query","kind":12}],"containerName":"main::","name":"frac_aligned_query"},{"kind":12,"range":{"start":{"character":0,"line":310},"end":{"line":310,"character":9999}},"line":310,"name":"frac_aligned_hit","containerName":"main::","children":[{"name":"frac_aligned","containerName":"frac_aligned_hit","kind":12,"line":310}],"definition":"sub"},{"definition":"sub","detail":"($self,$type,@args)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"range","kind":13,"line":324},{"name":"$type","containerName":"range","kind":13,"line":324},{"line":324,"kind":13,"containerName":"range","name":"@args"},{"name":"$self","containerName":"range","kind":13,"line":325},{"line":325,"kind":12,"containerName":"range","name":"throw_not_implemented"}],"containerName":"main::","name":"range","signature":{"label":"range($self,$type,@args)","documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_conserved {\n    my ($self, $type, @args) = @_;\n    return $self->frac_conserved($type, @args) * 100;\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Usage   : $tiling->frac_aligned($type)\n Function: Return the fraction of B<input> sequence length consisting\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_aligned{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n# aliases for back compat\nsub frac_aligned_query { shift->frac_aligned('query', @_) }\nsub frac_aligned_hit { shift->frac_aligned('hit', @_) }\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range($type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : scalar $type, one of 'hit', 'subject', 'query'","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}]},"line":323,"range":{"start":{"line":323,"character":0},"end":{"line":326,"character":9999}},"kind":12},{"signature":{"label":"next_tiling($self,$type,@args)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_conserved {\n    my ($self, $type, @args) = @_;\n    return $self->frac_conserved($type, @args) * 100;\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Usage   : $tiling->frac_aligned($type)\n Function: Return the fraction of B<input> sequence length consisting\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_aligned{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n# aliases for back compat\nsub frac_aligned_query { shift->frac_aligned('query', @_) }\nsub frac_aligned_hit { shift->frac_aligned('hit', @_) }\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range($type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub range {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling of HSPs over the $type ('hit', 'subject',\n           'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'"},"range":{"start":{"character":0,"line":343},"end":{"character":9999,"line":346}},"kind":12,"line":343,"detail":"($self,$type,@args)","definition":"sub","containerName":"main::","name":"next_tiling","children":[{"definition":"my","line":344,"name":"$self","localvar":"my","containerName":"next_tiling","kind":13},{"line":344,"name":"$type","containerName":"next_tiling","kind":13},{"line":344,"name":"@args","kind":13,"containerName":"next_tiling"},{"line":345,"kind":13,"containerName":"next_tiling","name":"$self"},{"kind":12,"containerName":"next_tiling","name":"throw_not_implemented","line":345}]},{"name":"rewind_tilings","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"rewind_tilings","kind":13,"line":361,"definition":"my"},{"line":361,"kind":13,"containerName":"rewind_tilings","name":"$type"},{"line":361,"name":"@args","kind":13,"containerName":"rewind_tilings"},{"name":"$self","kind":13,"containerName":"rewind_tilings","line":362},{"line":362,"name":"throw_not_implemented","containerName":"rewind_tilings","kind":12}],"detail":"($self,$type,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":363},"start":{"line":360,"character":0}},"line":360,"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"@args"}],"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_conserved {\n    my ($self, $type, @args) = @_;\n    return $self->frac_conserved($type, @args) * 100;\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Usage   : $tiling->frac_aligned($type)\n Function: Return the fraction of B<input> sequence length consisting\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_aligned{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n# aliases for back compat\nsub frac_aligned_query { shift->frac_aligned('query', @_) }\nsub frac_aligned_hit { shift->frac_aligned('hit', @_) }\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range($type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub range {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling of HSPs over the $type ('hit', 'subject',\n           'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my ($self,$type,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'","label":"rewind_tilings($self,$type,@args)"}},{"line":366,"kind":12,"range":{"end":{"character":9999,"line":366},"start":{"character":0,"line":366}},"children":[{"line":366,"name":"rewind_tilings","containerName":"rewind","kind":12}],"name":"rewind","containerName":"main::","definition":"sub"},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"algorithm","line":382,"definition":"my"},{"kind":13,"containerName":"algorithm","name":"@args","line":382},{"line":383,"name":"$self","containerName":"algorithm","kind":13},{"name":"throw_not_implemented","containerName":"algorithm","kind":12,"line":383}],"containerName":"main::","name":"algorithm","signature":{"documentation":"1;\n# $Id: TilingI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::TilingI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::TilingI - Abstract interface for an HSP tiling module\n\n=head1 SYNOPSIS\n\nNot used directly. Useful POD here for developers, however.\n\nThe interface is desgined to make the following code conversion as\nsimple as possible:\n\nFrom:\n\n # Bio::Search::SearchUtils-based\n while ( local $_ = $result->next_hit ) {\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $hit->frac_aligned_query, $hit->num_identical);\n }\n\nTo:\n\n # TilingI-based\n while ( local $_ = $result->next_hit ) {\n    my $tiling = Bio::Search::Tiling::MyTiling($_);\n    printf( \"E-value: %g; Fraction aligned: %f; Number identical: %d\\n\",\n      $hit->significance, $tiling->frac_aligned_query, $tiling->num_identical);\n }\n\n\n\n=head1 DESCRIPTION\n\nThis module provides strong suggestions for any intended HSP tiling\nobject implementation. An object subclassing TilingI should override\nthe methods defined here according to their descriptions below.\n\nSee the section STATISTICS METHODS for hints on implementing methods\nthat are valid across different algorithms and report types.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::TilingI;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::Root);\n\n=head2 STATISTICS METHODS\n\nThe tiling statistics can be thought of as global counterparts to\nsimilar statistics defined for the individual HSPs. We therefore\nprescribe definitions for many of the synonymous methods defined in\nL<Bio::Search::HSP::HSPI>.\n\nThe tiling statistics must be able to keep track of the coordinate\nsystems in which both the query and subject sequences exist; i.e.,\neither nucleotide or amino acid. This information is typically\ninferred from the name of the algorithm used to perform the original\nsearch (contained in C<$hit_object-E<gt>algorithm>). Here is a table\nof algorithm information that may be useful (if you trust us).\n\n algorithm   query on hit   coordinates(q/h)\n ---------   ------------   ---------------\n  blastn      dna on dna         dna/dna\n  blastp      aa  on aa           aa/aa\n  blastx      xna on aa          dna/aa\n tblastn      aa  on xna          aa/dna\n tblastx      xna on xna         dna/dna\n   fasta      dna on dna         dna/dna\n   fasta      aa  on aa           aa/aa\n   fastx      xna on aa          dna/aa\n   fasty      xna on aa          dna/aa\n  tfasta      aa  on xna          aa/dna\n  tfasty      aa  on xna          aa/dna\n megablast    dna on dna         dna/dna\n\n  xna: translated nucleotide data\n\nStatistics methods must also be aware of differences in reporting\namong the algorithms. Hit attributes are not necessarily normalized\nover all algorithms. Devs, please feel free to add examples to the\nlist below.\n\n\n* NCBI BLAST vs WU-BLAST (AB-BLAST) lengths\n\nThe total length of the alignment is reported differently between these two flavors. C<$hit_object-E<gt>length()> will contain the number in the denominator of the stats line; i.e., 120 in \n\n Identical = 34/120 Positives = 67/120\n\nNCBI BLAST uses the total length of the query sequence as input by the user (a.k.a. \"with gaps\"). WU-BLAST uses the length of the query sequence actually aligned by the algorithm (a.k.a. \"without gaps\").\n\n\nFinally, developers should remember that sequence data may or may not\nbe associated with the HSPs contained in the hit object. This will\ntypically depend on whether a full report (e.g, C<blastall -m0>) or a\nsummary (e.g., C<blastall -m8>) was parsed. Statistics methods that\ndepend directly on the sequence data will need to check that\nthat data is present.\n\n=head2 identities\n\n Title   : identities\n Alias   : num_identical\n Usage   : $num_identities = $tiling->identities()\n Function: Return the estimated or exact number of identities in the\n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of identical residue pairs\n Args    :\n\n\nsub identities{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_identical { shift->identities( @_ ) }\n\n=head2 conserved\n\n Title   : conserved\n Alias   : num_conserved\n Usage   : $num_conserved = $tiling->conserved()\n Function: Return the estimated or exact number of conserved sites in the \n           tiling, accounting for overlapping HSPs\n Example : \n Returns : number of conserved residue pairs\n Args    :\n\n\nsub conserved{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n#HSPI synonym\nsub num_conserved { shift->conserved( @_ ) }\n\n=head2 length\n\n Title   : length\n Usage   : $max_length = $tiling->length($type)\n Function: Return the total number of residues of the subject or query\n           sequence covered by the tiling\n Returns : number of \"logical\" residues covered\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub length{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_identical {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : $tiling->percent_identity($type)\n Function: Return the fraction of sequence length consisting\n           of identical pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_identity {\n    my ($self, $type, @args) = @_;\n    return $self->frac_identical($type, @args) * 100;\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_conserved{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 percent_conserved\n\n Title   : percent_conserved\n Usage   : $tiling->percent_conserved($type)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs as a percentage\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub percent_conserved {\n    my ($self, $type, @args) = @_;\n    return $self->frac_conserved($type, @args) * 100;\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Usage   : $tiling->frac_aligned($type)\n Function: Return the fraction of B<input> sequence length consisting\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n Note    : This method must take account of the $type coordinate\n           system and the length reporting method (see STATISTICS\n           METHODS above)\n\n\nsub frac_aligned{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n# aliases for back compat\nsub frac_aligned_query { shift->frac_aligned('query', @_) }\nsub frac_aligned_hit { shift->frac_aligned('hit', @_) }\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range($type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n\n\nsub range {\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling of HSPs over the $type ('hit', 'subject',\n           'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my ($self,$type,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub rewind_tilings{\n    my ($self, $type, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n#alias\nsub rewind { shift->rewind_tilings(@_) }\n\n=head1 INFORMATIONAL ACCESSORS\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}],"label":"algorithm($self,@args)"},"line":381,"kind":12,"range":{"start":{"line":381,"character":0},"end":{"character":9999,"line":384}}}],"version":5}