{"version":5,"vars":[{"line":147,"name":"base","containerName":"","kind":2},{"kind":12,"range":{"end":{"line":201,"character":9999},"start":{"character":0,"line":166}},"line":166,"definition":"sub","name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":167,"definition":"my"},{"kind":13,"localvar":"my","containerName":"new","name":"@args","line":168,"definition":"my"},{"line":169,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":169,"name":"$class","containerName":"new","kind":13},{"line":169,"name":"@args","containerName":"new","kind":13},{"line":170,"localvar":"my","kind":13,"containerName":"new","name":"$hit","definition":"my"},{"line":170,"containerName":"new","kind":13,"name":"$filter"},{"line":170,"name":"$self","containerName":"new","kind":13},{"line":170,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","kind":13,"containerName":"new","line":170},{"name":"$self","kind":13,"containerName":"new","line":172},{"line":172,"name":"throw","kind":12,"containerName":"new"},{"line":172,"containerName":"new","kind":13,"name":"$hit"},{"line":173,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":173},{"line":173,"name":"$hit","kind":13,"containerName":"new"},{"line":173,"containerName":"new","kind":13,"name":"$hit"},{"kind":12,"containerName":"new","name":"isa","line":173},{"line":174,"kind":13,"containerName":"new","name":"$self"},{"line":174,"kind":13,"containerName":"new","name":"$hit"},{"line":175,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"_set_attributes","line":175},{"line":176,"containerName":"new","kind":13,"name":"$self"},{"line":176,"containerName":"new","kind":13,"name":"$hit"},{"line":176,"kind":12,"containerName":"new","name":"algorithm"},{"definition":"my","line":178,"containerName":"new","localvar":"my","kind":13,"name":"@hsps"},{"containerName":"new","kind":13,"name":"$hit","line":178},{"line":178,"name":"hsps","kind":12,"containerName":"new"},{"line":180,"name":"$filter","containerName":"new","kind":13},{"line":181,"name":"$filter","kind":13,"containerName":"new"},{"line":182,"containerName":"new","kind":13,"name":"@hsps"},{"name":"$filter","containerName":"new","kind":13,"line":182},{"kind":13,"containerName":"new","name":"@hsps","line":182},{"name":"$self","containerName":"new","kind":13,"line":185},{"name":"warn","kind":12,"containerName":"new","line":185},{"definition":"my","line":190,"name":"$t","localvar":"my","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"%contexts","line":191},{"definition":"my","line":192,"name":"$i","containerName":"new","localvar":"my","kind":13},{"name":"$ctxt","localvar":"my","containerName":"new","kind":13,"line":193,"definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":193},{"name":"_context","kind":12,"containerName":"new","line":193},{"line":194,"kind":13,"containerName":"new","name":"$t"},{"containerName":"new","kind":13,"name":"$hsps","line":195},{"name":"$i","containerName":"new","kind":13,"line":195},{"name":"strand","kind":12,"containerName":"new","line":195},{"line":195,"name":"$t","kind":13,"containerName":"new"},{"line":196,"kind":13,"containerName":"new","name":"$hsps"},{"line":196,"name":"$i","containerName":"new","kind":13},{"name":"frame","kind":12,"containerName":"new","line":196},{"line":196,"name":"$t","kind":13,"containerName":"new"},{"line":197,"kind":13,"containerName":"new","name":"$contexts"},{"containerName":"new","kind":13,"name":"$ctxt","line":197},{"line":198,"kind":13,"containerName":"new","name":"$contexts"},{"name":"$ctxt","containerName":"new","kind":13,"line":198},{"line":198,"name":"$i","kind":13,"containerName":"new"},{"line":200,"name":"$self","kind":13,"containerName":"new"},{"line":200,"name":"%contexts","kind":13,"containerName":"new"}]},{"kind":12,"containerName":"new","name":"SUPER","line":169},{"kind":12,"name":"hit","line":174},{"line":192,"kind":12,"name":"hsps"},{"line":203,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":203},{"line":203,"containerName":null,"kind":13,"name":"@hsps"},{"name":"$self","kind":13,"containerName":null,"line":204},{"containerName":"main::","kind":12,"name":"hsps","line":204},{"name":"@hsps","containerName":null,"kind":13,"line":204},{"line":205,"containerName":null,"kind":13,"name":"$self"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_tiling","line":227,"definition":"my"},{"name":"$type","containerName":"next_tiling","localvar":"my","kind":13,"line":228,"definition":"my"},{"line":228,"name":"$context","containerName":"next_tiling","kind":13},{"kind":13,"containerName":"next_tiling","name":"$self","line":229},{"line":229,"name":"_check_type_arg","containerName":"next_tiling","kind":12},{"line":229,"containerName":"next_tiling","kind":13,"name":"$type"},{"line":230,"name":"$self","containerName":"next_tiling","kind":13},{"line":230,"name":"_check_context_arg","containerName":"next_tiling","kind":12},{"name":"$type","kind":13,"containerName":"next_tiling","line":230},{"containerName":"next_tiling","kind":13,"name":"$context","line":230},{"line":231,"kind":13,"containerName":"next_tiling","name":"$self"},{"name":"_tiling_iterator","containerName":"next_tiling","kind":12,"line":231},{"name":"$type","kind":13,"containerName":"next_tiling","line":231},{"line":231,"containerName":"next_tiling","kind":13,"name":"$context"}],"containerName":"main::","name":"next_tiling","definition":"sub","detail":"($type,$context)","line":226,"range":{"end":{"character":9999,"line":232},"start":{"character":0,"line":226}},"kind":12,"signature":{"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'","parameters":[{"label":"$type"},{"label":"$context"}],"label":"next_tiling($type,$context)"}},{"name":"rewind_tilings","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rewind_tilings","line":247,"definition":"my"},{"definition":"my","line":248,"containerName":"rewind_tilings","localvar":"my","kind":13,"name":"$type"},{"name":"$context","kind":13,"containerName":"rewind_tilings","line":248},{"kind":13,"containerName":"rewind_tilings","name":"$self","line":249},{"line":249,"name":"_check_type_arg","containerName":"rewind_tilings","kind":12},{"kind":13,"containerName":"rewind_tilings","name":"$type","line":249},{"containerName":"rewind_tilings","kind":13,"name":"$self","line":250},{"line":250,"name":"_check_context_arg","kind":12,"containerName":"rewind_tilings"},{"line":250,"containerName":"rewind_tilings","kind":13,"name":"$type"},{"containerName":"rewind_tilings","kind":13,"name":"$context","line":250},{"name":"$self","containerName":"rewind_tilings","kind":13,"line":251},{"name":"_tiling_iterator","containerName":"rewind_tilings","kind":12,"line":251},{"kind":13,"containerName":"rewind_tilings","name":"$type","line":251},{"containerName":"rewind_tilings","kind":13,"name":"$context","line":251}],"detail":"($type,$context)","definition":"sub","kind":12,"range":{"start":{"line":246,"character":0},"end":{"line":252,"character":9999}},"line":246,"signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'","label":"rewind_tilings($type,$context)"}},{"children":[{"localvar":"my","containerName":"identities","kind":13,"name":"$self","line":273,"definition":"my"},{"name":"$type","kind":13,"localvar":"my","containerName":"identities","line":274,"definition":"my"},{"line":274,"name":"$action","kind":13,"containerName":"identities"},{"name":"$context","containerName":"identities","kind":13,"line":274},{"line":275,"kind":13,"containerName":"identities","name":"$self"},{"line":275,"kind":12,"containerName":"identities","name":"_check_type_arg"},{"line":275,"containerName":"identities","kind":13,"name":"$type"},{"kind":13,"containerName":"identities","name":"$self","line":276},{"name":"_check_action_arg","containerName":"identities","kind":12,"line":276},{"line":276,"name":"$action","kind":13,"containerName":"identities"},{"line":277,"name":"$self","kind":13,"containerName":"identities"},{"line":277,"name":"_check_context_arg","kind":12,"containerName":"identities"},{"kind":13,"containerName":"identities","name":"$type","line":277},{"line":277,"name":"$context","containerName":"identities","kind":13},{"containerName":"identities","kind":13,"name":"$self","line":278},{"line":279,"kind":13,"containerName":"identities","name":"$self"},{"line":279,"containerName":"identities","kind":12,"name":"_calc_stats"},{"name":"$type","containerName":"identities","kind":13,"line":279},{"line":279,"containerName":"identities","kind":13,"name":"$action"},{"line":279,"containerName":"identities","kind":13,"name":"$context"},{"containerName":"identities","kind":13,"name":"$self","line":281}],"name":"identities","containerName":"main::","definition":"sub","detail":"($type,$action,$context)","line":272,"range":{"start":{"line":272,"character":0},"end":{"line":282,"character":9999}},"kind":12,"signature":{"label":"identities($type,$action,$context)","parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only"}},{"name":"conserved","containerName":"main::","children":[{"line":301,"containerName":"conserved","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$type","containerName":"conserved","localvar":"my","kind":13,"line":302},{"kind":13,"containerName":"conserved","name":"$action","line":302},{"line":302,"containerName":"conserved","kind":13,"name":"$context"},{"containerName":"conserved","kind":13,"name":"$self","line":303},{"kind":12,"containerName":"conserved","name":"_check_type_arg","line":303},{"line":303,"name":"$type","containerName":"conserved","kind":13},{"line":304,"kind":13,"containerName":"conserved","name":"$self"},{"name":"_check_action_arg","kind":12,"containerName":"conserved","line":304},{"line":304,"kind":13,"containerName":"conserved","name":"$action"},{"line":305,"name":"$self","containerName":"conserved","kind":13},{"containerName":"conserved","kind":12,"name":"_check_context_arg","line":305},{"name":"$type","containerName":"conserved","kind":13,"line":305},{"line":305,"containerName":"conserved","kind":13,"name":"$context"},{"line":306,"name":"$self","containerName":"conserved","kind":13},{"name":"$self","containerName":"conserved","kind":13,"line":307},{"line":307,"name":"_calc_stats","containerName":"conserved","kind":12},{"line":307,"name":"$type","kind":13,"containerName":"conserved"},{"line":307,"name":"$action","containerName":"conserved","kind":13},{"line":307,"name":"$context","containerName":"conserved","kind":13},{"name":"$self","containerName":"conserved","kind":13,"line":309}],"detail":"($type,$action,$context)","definition":"sub","kind":12,"range":{"start":{"line":300,"character":0},"end":{"line":310,"character":9999}},"line":300,"signature":{"parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only ","label":"conserved($type,$action,$context)"}},{"signature":{"parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only ","label":"length($type,$action,$context)"},"range":{"start":{"character":0,"line":329},"end":{"line":339,"character":9999}},"kind":12,"line":329,"detail":"($type,$action,$context)","definition":"sub","name":"length","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"length","line":330,"definition":"my"},{"definition":"my","line":331,"localvar":"my","kind":13,"containerName":"length","name":"$type"},{"containerName":"length","kind":13,"name":"$action","line":331},{"containerName":"length","kind":13,"name":"$context","line":331},{"line":332,"containerName":"length","kind":13,"name":"$self"},{"containerName":"length","kind":12,"name":"_check_type_arg","line":332},{"kind":13,"containerName":"length","name":"$type","line":332},{"line":333,"name":"$self","containerName":"length","kind":13},{"line":333,"containerName":"length","kind":12,"name":"_check_action_arg"},{"name":"$action","kind":13,"containerName":"length","line":333},{"containerName":"length","kind":13,"name":"$self","line":334},{"name":"_check_context_arg","containerName":"length","kind":12,"line":334},{"line":334,"name":"$type","kind":13,"containerName":"length"},{"line":334,"name":"$context","containerName":"length","kind":13},{"line":335,"name":"$self","containerName":"length","kind":13},{"line":336,"kind":13,"containerName":"length","name":"$self"},{"line":336,"name":"_calc_stats","kind":12,"containerName":"length"},{"line":336,"name":"$type","containerName":"length","kind":13},{"containerName":"length","kind":13,"name":"$action","line":336},{"kind":13,"containerName":"length","name":"$context","line":336},{"kind":13,"containerName":"length","name":"$self","line":338}]},{"line":364,"kind":12,"range":{"end":{"character":9999,"line":411},"start":{"line":364,"character":0}},"definition":"sub","children":[{"name":"$self","containerName":"frac","localvar":"my","kind":13,"line":365,"definition":"my"},{"definition":"my","line":366,"name":"@args","containerName":"frac","localvar":"my","kind":13},{"name":"$type","localvar":"my","containerName":"frac","kind":13,"line":367,"definition":"my"},{"line":367,"kind":13,"containerName":"frac","name":"$denom"},{"line":367,"containerName":"frac","kind":13,"name":"$action"},{"name":"$context","kind":13,"containerName":"frac","line":367},{"line":367,"name":"$method","kind":13,"containerName":"frac"},{"line":367,"name":"$self","kind":13,"containerName":"frac"},{"kind":12,"containerName":"frac","name":"_rearrange","line":367},{"line":367,"containerName":"frac","kind":13,"name":"@args"},{"kind":13,"containerName":"frac","name":"$self","line":368},{"name":"_check_type_arg","kind":12,"containerName":"frac","line":368},{"line":368,"kind":13,"containerName":"frac","name":"$type"},{"containerName":"frac","kind":13,"name":"$self","line":369},{"kind":12,"containerName":"frac","name":"_check_action_arg","line":369},{"line":369,"name":"$action","containerName":"frac","kind":13},{"line":370,"name":"$self","containerName":"frac","kind":13},{"line":370,"name":"_check_context_arg","containerName":"frac","kind":12},{"line":370,"name":"$type","containerName":"frac","kind":13},{"line":370,"name":"$context","kind":13,"containerName":"frac"},{"line":371,"kind":13,"containerName":"frac","name":"$method"},{"name":"$self","kind":13,"containerName":"frac","line":372},{"line":372,"kind":12,"containerName":"frac","name":"throw"},{"containerName":"frac","kind":13,"name":"$denom","line":374},{"line":376,"name":"$self","containerName":"frac","kind":13},{"containerName":"frac","kind":12,"name":"throw","line":376},{"definition":"my","localvar":"my","containerName":"frac","kind":13,"name":"$key","line":378},{"name":"$stat","containerName":"frac","localvar":"my","kind":13,"line":379,"definition":"my"},{"line":380,"name":"$method","containerName":"frac","kind":13},{"line":382,"name":"$stat","kind":13,"containerName":"frac"},{"name":"$self","containerName":"frac","kind":13,"line":382},{"containerName":"frac","kind":12,"name":"identities","line":382},{"line":382,"kind":13,"containerName":"frac","name":"$type"},{"kind":13,"containerName":"frac","name":"$action","line":382},{"line":382,"containerName":"frac","kind":13,"name":"$context"},{"name":"$stat","kind":13,"containerName":"frac","line":386},{"containerName":"frac","kind":13,"name":"$self","line":386},{"containerName":"frac","kind":12,"name":"conserved","line":386},{"containerName":"frac","kind":13,"name":"$type","line":386},{"name":"$action","containerName":"frac","kind":13,"line":386},{"containerName":"frac","kind":13,"name":"$context","line":386},{"containerName":"frac","kind":13,"name":"$self","line":390},{"line":390,"kind":12,"containerName":"frac","name":"throw"},{"name":"$self","containerName":"frac","kind":13,"line":393},{"line":393,"name":"$key","containerName":"frac","kind":13},{"line":394,"name":"$denom","kind":13,"containerName":"frac"},{"line":396,"containerName":"frac","kind":13,"name":"$self"},{"name":"$key","containerName":"frac","kind":13,"line":396},{"line":397,"name":"$stat","kind":13,"containerName":"frac"},{"name":"$self","containerName":"frac","kind":13,"line":397},{"containerName":"frac","kind":12,"name":"_reported_length","line":397},{"name":"$type","kind":13,"containerName":"frac","line":397},{"line":401,"kind":13,"containerName":"frac","name":"$self"},{"line":401,"name":"$key","containerName":"frac","kind":13},{"line":402,"name":"$stat","containerName":"frac","kind":13},{"line":402,"kind":13,"containerName":"frac","name":"$self"},{"line":402,"name":"length","kind":12,"containerName":"frac"},{"containerName":"frac","kind":13,"name":"$type","line":402},{"name":"$action","containerName":"frac","kind":13,"line":402},{"containerName":"frac","kind":13,"name":"$context","line":402},{"kind":13,"containerName":"frac","name":"$self","line":406},{"name":"throw","containerName":"frac","kind":12,"line":406},{"line":410,"kind":13,"containerName":"frac","name":"$self"},{"line":410,"name":"$key","containerName":"frac","kind":13}],"containerName":"main::","name":"frac"},{"line":435,"kind":12,"range":{"start":{"line":435,"character":0},"end":{"line":440,"character":9999}},"definition":"sub","children":[{"line":436,"kind":13,"localvar":"my","containerName":"frac_identical","name":"$self","definition":"my"},{"line":437,"name":"@args","containerName":"frac_identical","localvar":"my","kind":13,"definition":"my"},{"line":438,"kind":13,"localvar":"my","containerName":"frac_identical","name":"$type","definition":"my"},{"line":438,"containerName":"frac_identical","kind":13,"name":"$denom"},{"kind":13,"containerName":"frac_identical","name":"$action","line":438},{"line":438,"containerName":"frac_identical","kind":13,"name":"$context"},{"containerName":"frac_identical","kind":13,"name":"$self","line":438},{"containerName":"frac_identical","kind":12,"name":"_rearrange","line":438},{"line":438,"containerName":"frac_identical","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"frac_identical","line":439},{"line":439,"name":"frac","kind":12,"containerName":"frac_identical"},{"name":"$type","kind":13,"containerName":"frac_identical","line":439},{"line":439,"name":"$denom","kind":13,"containerName":"frac_identical"},{"containerName":"frac_identical","kind":13,"name":"$action","line":439},{"name":"$context","containerName":"frac_identical","kind":13,"line":439}],"containerName":"main::","name":"frac_identical"},{"kind":12,"range":{"start":{"line":464,"character":0},"end":{"character":9999,"line":469}},"line":464,"definition":"sub","containerName":"main::","name":"frac_conserved","children":[{"definition":"my","containerName":"frac_conserved","localvar":"my","kind":13,"name":"$self","line":465},{"containerName":"frac_conserved","localvar":"my","kind":13,"name":"@args","line":466,"definition":"my"},{"definition":"my","line":467,"name":"$type","containerName":"frac_conserved","localvar":"my","kind":13},{"name":"$denom","containerName":"frac_conserved","kind":13,"line":467},{"line":467,"containerName":"frac_conserved","kind":13,"name":"$action"},{"name":"$context","containerName":"frac_conserved","kind":13,"line":467},{"line":467,"name":"$self","kind":13,"containerName":"frac_conserved"},{"name":"_rearrange","containerName":"frac_conserved","kind":12,"line":467},{"line":467,"name":"@args","containerName":"frac_conserved","kind":13},{"line":468,"name":"$self","kind":13,"containerName":"frac_conserved"},{"line":468,"containerName":"frac_conserved","kind":12,"name":"frac"},{"line":468,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":468,"name":"$denom","kind":13,"containerName":"frac_conserved"},{"name":"$action","containerName":"frac_conserved","kind":13,"line":468},{"kind":13,"containerName":"frac_conserved","name":"$context","line":468}]},{"signature":{"label":"frac_aligned($self,@args)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string","parameters":[{"label":"$self"},{"label":"@args"}]},"line":488,"range":{"end":{"line":498,"character":9999},"start":{"character":0,"line":488}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"frac_aligned","kind":13,"line":489},{"line":489,"name":"@args","containerName":"frac_aligned","kind":13},{"localvar":"my","kind":13,"containerName":"frac_aligned","name":"$type","line":490,"definition":"my"},{"line":490,"name":"$action","containerName":"frac_aligned","kind":13},{"line":490,"containerName":"frac_aligned","kind":13,"name":"$context"},{"name":"$self","kind":13,"containerName":"frac_aligned","line":490},{"name":"_rearrange","kind":12,"containerName":"frac_aligned","line":490},{"line":490,"kind":13,"containerName":"frac_aligned","name":"@args"},{"kind":13,"containerName":"frac_aligned","name":"$self","line":491},{"line":491,"kind":12,"containerName":"frac_aligned","name":"_check_type_arg"},{"line":491,"containerName":"frac_aligned","kind":13,"name":"$type"},{"line":492,"containerName":"frac_aligned","kind":13,"name":"$self"},{"kind":12,"containerName":"frac_aligned","name":"_check_action_arg","line":492},{"line":492,"name":"$action","containerName":"frac_aligned","kind":13},{"line":493,"containerName":"frac_aligned","kind":13,"name":"$self"},{"name":"_check_context_arg","containerName":"frac_aligned","kind":12,"line":493},{"line":493,"kind":13,"containerName":"frac_aligned","name":"$type"},{"line":493,"name":"$context","kind":13,"containerName":"frac_aligned"},{"name":"$self","kind":13,"containerName":"frac_aligned","line":494},{"line":495,"name":"$self","kind":13,"containerName":"frac_aligned"},{"name":"$self","containerName":"frac_aligned","kind":13,"line":495},{"name":"num_aligned","containerName":"frac_aligned","kind":12,"line":495},{"containerName":"frac_aligned","kind":13,"name":"$type","line":495},{"name":"$action","containerName":"frac_aligned","kind":13,"line":495},{"line":495,"name":"$context","containerName":"frac_aligned","kind":13},{"line":495,"name":"$self","containerName":"frac_aligned","kind":13},{"kind":12,"containerName":"frac_aligned","name":"_reported_length","line":495},{"name":"$type","containerName":"frac_aligned","kind":13,"line":495},{"line":497,"name":"$self","kind":13,"containerName":"frac_aligned"}],"name":"frac_aligned","containerName":"main::"},{"definition":"sub","name":"frac_aligned_query","containerName":"main::","children":[{"line":500,"name":"frac_aligned","containerName":"frac_aligned_query","kind":12}],"range":{"start":{"character":0,"line":500},"end":{"line":500,"character":9999}},"kind":12,"line":500},{"kind":12,"range":{"end":{"line":501,"character":9999},"start":{"line":501,"character":0}},"line":501,"containerName":"main::","name":"frac_aligned_hit","children":[{"containerName":"frac_aligned_hit","kind":12,"name":"frac_aligned","line":501}],"definition":"sub"},{"line":521,"range":{"end":{"line":521,"character":9999},"start":{"line":521,"character":0}},"kind":12,"children":[{"line":521,"containerName":"num_aligned","kind":12,"name":"length"}],"containerName":"main::","name":"num_aligned","definition":"sub"},{"definition":"sub","detail":"($type,$action,$context)","children":[{"line":540,"name":"$self","kind":13,"localvar":"my","containerName":"num_unaligned","definition":"my"},{"definition":"my","name":"$type","kind":13,"localvar":"my","containerName":"num_unaligned","line":541},{"line":541,"containerName":"num_unaligned","kind":13,"name":"$action"},{"line":541,"kind":13,"containerName":"num_unaligned","name":"$context"},{"definition":"my","line":542,"name":"$ret","localvar":"my","kind":13,"containerName":"num_unaligned"},{"kind":13,"containerName":"num_unaligned","name":"$self","line":543},{"name":"_check_type_arg","kind":12,"containerName":"num_unaligned","line":543},{"containerName":"num_unaligned","kind":13,"name":"$type","line":543},{"line":544,"containerName":"num_unaligned","kind":13,"name":"$self"},{"name":"_check_action_arg","kind":12,"containerName":"num_unaligned","line":544},{"name":"$action","containerName":"num_unaligned","kind":13,"line":544},{"line":545,"containerName":"num_unaligned","kind":13,"name":"$self"},{"line":545,"containerName":"num_unaligned","kind":12,"name":"_check_context_arg"},{"name":"$type","containerName":"num_unaligned","kind":13,"line":545},{"line":545,"kind":13,"containerName":"num_unaligned","name":"$context"},{"line":546,"kind":13,"containerName":"num_unaligned","name":"$self"},{"line":547,"kind":13,"containerName":"num_unaligned","name":"$self"},{"name":"$self","kind":13,"containerName":"num_unaligned","line":547},{"kind":12,"containerName":"num_unaligned","name":"_reported_length","line":547},{"containerName":"num_unaligned","kind":13,"name":"$type","line":547},{"name":"$self","kind":13,"containerName":"num_unaligned","line":547},{"containerName":"num_unaligned","kind":12,"name":"num_aligned","line":547},{"name":"$type","containerName":"num_unaligned","kind":13,"line":547},{"line":547,"name":"$action","kind":13,"containerName":"num_unaligned"},{"name":"$context","kind":13,"containerName":"num_unaligned","line":547},{"name":"$self","kind":13,"containerName":"num_unaligned","line":549}],"name":"num_unaligned","containerName":"main::","signature":{"parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"","label":"num_unaligned($type,$action,$context)"},"line":539,"kind":12,"range":{"end":{"line":550,"character":9999},"start":{"line":539,"character":0}}},{"detail":"($self,$type,$context)","definition":"sub","containerName":"main::","name":"range","children":[{"definition":"my","line":566,"localvar":"my","containerName":"range","kind":13,"name":"$self"},{"line":566,"name":"$type","containerName":"range","kind":13},{"line":566,"name":"$context","kind":13,"containerName":"range"},{"line":567,"kind":13,"containerName":"range","name":"$self"},{"line":567,"containerName":"range","kind":12,"name":"_check_type_arg"},{"name":"$type","kind":13,"containerName":"range","line":567},{"line":568,"kind":13,"containerName":"range","name":"$self"},{"name":"_check_context_arg","containerName":"range","kind":12,"line":568},{"line":568,"containerName":"range","kind":13,"name":"$type"},{"line":568,"name":"$context","containerName":"range","kind":13},{"line":569,"localvar":"my","containerName":"range","kind":13,"name":"@a","definition":"my"},{"name":"$self","containerName":"range","kind":13,"line":569},{"line":569,"name":"_contig_intersection","kind":12,"containerName":"range"},{"name":"$type","containerName":"range","kind":13,"line":569},{"name":"$context","kind":13,"containerName":"range","line":569},{"name":"$a","kind":13,"containerName":"range","line":570},{"name":"$a","containerName":"range","kind":13,"line":570}],"signature":{"label":"range($self,$type,$context)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$context"}]},"kind":12,"range":{"start":{"character":0,"line":565},"end":{"line":571,"character":9999}},"line":565},{"signature":{"label":"coverage_map($type,$context)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter ","parameters":[{"label":"$type"},{"label":"$context"}]},"line":592,"range":{"start":{"line":592,"character":0},"end":{"line":608,"character":9999}},"kind":12,"definition":"sub","detail":"($type,$context)","children":[{"definition":"my","line":593,"name":"$self","containerName":"coverage_map","localvar":"my","kind":13},{"line":594,"containerName":"coverage_map","localvar":"my","kind":13,"name":"$type","definition":"my"},{"line":594,"containerName":"coverage_map","kind":13,"name":"$context"},{"containerName":"coverage_map","kind":13,"name":"$self","line":595},{"line":595,"name":"_check_type_arg","kind":12,"containerName":"coverage_map"},{"line":595,"name":"$type","containerName":"coverage_map","kind":13},{"kind":13,"containerName":"coverage_map","name":"$self","line":596},{"name":"_check_context_arg","containerName":"coverage_map","kind":12,"line":596},{"containerName":"coverage_map","kind":13,"name":"$type","line":596},{"name":"$context","kind":13,"containerName":"coverage_map","line":596},{"kind":13,"containerName":"coverage_map","name":"$self","line":598},{"kind":13,"containerName":"coverage_map","name":"$self","line":601},{"line":601,"kind":12,"containerName":"coverage_map","name":"_calc_coverage_map"},{"line":601,"name":"$type","containerName":"coverage_map","kind":13},{"containerName":"coverage_map","kind":13,"name":"$context","line":601},{"line":604,"name":"$self","containerName":"coverage_map","kind":13},{"kind":13,"containerName":"coverage_map","name":"$self","line":605},{"kind":12,"containerName":"coverage_map","name":"warn","line":605},{"name":"$self","containerName":"coverage_map","kind":13,"line":608}],"containerName":"main::","name":"coverage_map"},{"range":{"end":{"character":9999,"line":646},"start":{"line":627,"character":0}},"kind":12,"line":627,"signature":{"label":"coverage_map_as_text($type,$context,$legend_q)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);","parameters":[{"label":"$type"},{"label":"$context"},{"label":"$legend_q"}]},"containerName":"main::","name":"coverage_map_as_text","children":[{"definition":"my","line":628,"localvar":"my","kind":13,"containerName":"coverage_map_as_text","name":"$self"},{"definition":"my","line":629,"name":"$type","localvar":"my","containerName":"coverage_map_as_text","kind":13},{"name":"$context","kind":13,"containerName":"coverage_map_as_text","line":629},{"name":"$legend_q","containerName":"coverage_map_as_text","kind":13,"line":629},{"name":"$self","containerName":"coverage_map_as_text","kind":13,"line":630},{"kind":12,"containerName":"coverage_map_as_text","name":"_check_type_arg","line":630},{"name":"$type","containerName":"coverage_map_as_text","kind":13,"line":630},{"name":"$self","containerName":"coverage_map_as_text","kind":13,"line":631},{"name":"_check_context_arg","containerName":"coverage_map_as_text","kind":12,"line":631},{"line":631,"containerName":"coverage_map_as_text","kind":13,"name":"$type"},{"line":631,"kind":13,"containerName":"coverage_map_as_text","name":"$context"},{"definition":"my","kind":13,"localvar":"my","containerName":"coverage_map_as_text","name":"@map","line":633},{"line":633,"containerName":"coverage_map_as_text","kind":13,"name":"$self"},{"kind":12,"containerName":"coverage_map_as_text","name":"coverage_map","line":633},{"line":633,"kind":13,"containerName":"coverage_map_as_text","name":"$type"},{"line":633,"name":"$context","containerName":"coverage_map_as_text","kind":13},{"definition":"my","line":634,"name":"@ret","containerName":"coverage_map_as_text","localvar":"my","kind":13},{"name":"@hsps","localvar":"my","kind":13,"containerName":"coverage_map_as_text","line":635,"definition":"my"},{"line":635,"kind":13,"containerName":"coverage_map_as_text","name":"$self"},{"containerName":"coverage_map_as_text","kind":12,"name":"hit","line":635},{"name":"hsps","containerName":"coverage_map_as_text","kind":12,"line":635},{"definition":"my","line":636,"name":"%hsps_i","kind":13,"localvar":"my","containerName":"coverage_map_as_text"},{"line":638,"kind":13,"containerName":"coverage_map_as_text","name":"%hsps_i"},{"containerName":"coverage_map_as_text","kind":13,"name":"@hsps_i","line":639},{"line":639,"containerName":"coverage_map_as_text","kind":13,"name":"@hsps"},{"definition":"my","line":640,"localvar":"my","containerName":"coverage_map_as_text","kind":13,"name":"@mx"},{"definition":"my","localvar":"my","kind":13,"containerName":"coverage_map_as_text","name":"@hspx","line":642},{"kind":13,"containerName":"coverage_map_as_text","name":"@hsps","line":642},{"containerName":"coverage_map_as_text","localvar":"my","kind":13,"name":"@these_hsps","line":643,"definition":"my"},{"name":"$map","containerName":"coverage_map_as_text","kind":13,"line":643},{"line":644,"containerName":"coverage_map_as_text","kind":13,"name":"@hspx"},{"containerName":"coverage_map_as_text","kind":13,"name":"@hsps_i","line":644},{"line":644,"kind":13,"containerName":"coverage_map_as_text","name":"@these_hsps"},{"line":644,"containerName":"coverage_map_as_text","kind":13,"name":"@these_hsps"},{"name":"$mx","kind":13,"containerName":"coverage_map_as_text","line":645},{"name":"@hspx","containerName":"coverage_map_as_text","kind":13,"line":645}],"detail":"($type,$context,$legend_q)","definition":"sub"},{"line":638,"containerName":"RefHash","kind":12,"name":"Tie"},{"name":"hsps","kind":12,"line":639},{"name":"map","kind":12,"line":641},{"line":647,"name":"%hsps_i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@ret","line":649},{"line":650,"name":"@ret","containerName":null,"kind":13},{"line":650,"name":"map","kind":12},{"definition":"my","name":"$h","localvar":"my","containerName":null,"kind":13,"line":651},{"kind":12,"name":"hsps","line":651},{"containerName":null,"kind":13,"name":"@ret","line":652},{"line":652,"containerName":null,"kind":13,"name":"%h"},{"name":"@mx","kind":13,"containerName":null,"line":652},{"line":652,"kind":13,"containerName":null,"name":"$h"},{"name":"map","kind":12,"line":652},{"name":"%legend_q","containerName":null,"kind":13,"line":654},{"line":655,"name":"@ret","containerName":null,"kind":13},{"name":"map","kind":12,"line":656},{"line":657,"containerName":null,"kind":13,"name":"@ret"},{"name":"@map","kind":13,"containerName":null,"line":657},{"line":659,"name":"@ret","kind":13,"containerName":null},{"definition":"my","line":660,"localvar":"my","kind":13,"containerName":null,"name":"@ints"},{"kind":12,"name":"get_intervals_from_hsps","line":660},{"kind":13,"containerName":null,"name":"$type","line":660},{"containerName":null,"kind":13,"name":"@hsps","line":660},{"line":661,"kind":12,"name":"hsps"},{"name":"@ret","containerName":null,"kind":13,"line":662},{"kind":13,"containerName":null,"name":"@ints","line":662},{"line":665,"name":"@ret","kind":13,"containerName":null},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hit","line":681,"definition":"my"},{"line":682,"name":"$self","kind":13,"containerName":"hit"},{"containerName":"hit","kind":12,"name":"warn","line":682},{"containerName":"hit","kind":13,"name":"$self","line":683}],"name":"hit","containerName":"main::","line":680,"range":{"end":{"line":684,"character":9999},"start":{"character":0,"line":680}},"kind":12},{"range":{"start":{"line":697,"character":0},"end":{"character":9999,"line":700}},"kind":12,"line":697,"name":"hsps","containerName":"main::","children":[{"line":698,"containerName":"hsps","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"hsps","line":699},{"name":"$self","containerName":"hsps","kind":13,"line":700}],"definition":"sub"},{"definition":"sub","detail":"($type,$context)","children":[{"definition":"my","line":720,"name":"$self","localvar":"my","containerName":"contexts","kind":13},{"kind":13,"localvar":"my","containerName":"contexts","name":"$type","line":721,"definition":"my"},{"kind":13,"containerName":"contexts","name":"$context","line":721},{"containerName":"contexts","kind":13,"name":"$self","line":722},{"kind":12,"containerName":"contexts","name":"_check_type_arg","line":722},{"name":"$type","containerName":"contexts","kind":13,"line":722},{"name":"$self","kind":13,"containerName":"contexts","line":723}],"containerName":"main::","name":"contexts","signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string","label":"contexts($type,$context)"},"line":719,"kind":12,"range":{"end":{"line":723,"character":9999},"start":{"character":0,"line":719}}},{"containerName":null,"kind":13,"name":"$context","line":723},{"kind":13,"containerName":null,"name":"%self","line":724},{"containerName":null,"kind":13,"name":"$context","line":724},{"containerName":null,"kind":13,"name":"%self","line":725},{"line":725,"name":"$context","kind":13,"containerName":null},{"definition":"sub","containerName":"main::","name":"mapping","children":[{"line":741,"name":"$self","localvar":"my","kind":13,"containerName":"mapping","definition":"my"},{"definition":"my","line":742,"localvar":"my","kind":13,"containerName":"mapping","name":"$type"},{"line":743,"containerName":"mapping","kind":13,"name":"$self"},{"line":743,"name":"_check_type_arg","containerName":"mapping","kind":12},{"kind":13,"containerName":"mapping","name":"$type","line":743},{"line":744,"name":"$self","containerName":"mapping","kind":13}],"range":{"start":{"line":740,"character":0},"end":{"line":745,"character":9999}},"kind":12,"line":740},{"containerName":"main::","name":"default_context","children":[{"definition":"my","line":760,"name":"$self","kind":13,"localvar":"my","containerName":"default_context"},{"definition":"my","line":761,"name":"$type","localvar":"my","containerName":"default_context","kind":13},{"name":"$self","containerName":"default_context","kind":13,"line":762},{"line":762,"kind":12,"containerName":"default_context","name":"_check_type_arg"},{"name":"$type","containerName":"default_context","kind":13,"line":762},{"name":"$self","kind":13,"containerName":"default_context","line":763}],"definition":"sub","kind":12,"range":{"start":{"line":759,"character":0},"end":{"character":9999,"line":764}},"line":759},{"containerName":"main::","name":"algorithm","children":[{"definition":"my","name":"$self","containerName":"algorithm","localvar":"my","kind":13,"line":779},{"containerName":"algorithm","kind":13,"name":"$self","line":780},{"line":780,"kind":12,"containerName":"algorithm","name":"warn"},{"line":781,"name":"$self","kind":13,"containerName":"algorithm"}],"definition":"sub","range":{"start":{"character":0,"line":778},"end":{"character":9999,"line":782}},"kind":12,"line":778},{"children":[{"definition":"my","name":"$self","containerName":"_calc_coverage_map","localvar":"my","kind":13,"line":816},{"line":817,"name":"$type","localvar":"my","kind":13,"containerName":"_calc_coverage_map","definition":"my"},{"kind":13,"containerName":"_calc_coverage_map","name":"$self","line":818},{"line":818,"name":"_check_type_arg","kind":12,"containerName":"_calc_coverage_map"},{"kind":13,"containerName":"_calc_coverage_map","name":"$type","line":818},{"containerName":"_calc_coverage_map","kind":13,"name":"$self","line":822},{"line":823,"containerName":"_calc_coverage_map","kind":13,"name":"$self"},{"line":823,"name":"warn","containerName":"_calc_coverage_map","kind":12},{"line":827,"localvar":"my","kind":13,"containerName":"_calc_coverage_map","name":"@map","definition":"my"},{"line":827,"kind":13,"containerName":"_calc_coverage_map","name":"@hsps"},{"kind":13,"containerName":"_calc_coverage_map","name":"%filters","line":827},{"line":827,"containerName":"_calc_coverage_map","kind":13,"name":"@intervals"},{"definition":"my","name":"$c","localvar":"my","containerName":"_calc_coverage_map","kind":13,"line":831},{"line":831,"containerName":"_calc_coverage_map","kind":13,"name":"$self"},{"name":"mapping","kind":12,"containerName":"_calc_coverage_map","line":831},{"line":831,"name":"$type","kind":13,"containerName":"_calc_coverage_map"},{"definition":"my","name":"$context","localvar":"my","containerName":"_calc_coverage_map","kind":13,"line":834},{"line":834,"containerName":"_calc_coverage_map","kind":13,"name":"$self"},{"line":834,"containerName":"_calc_coverage_map","kind":12,"name":"contexts"},{"line":834,"name":"$type","kind":13,"containerName":"_calc_coverage_map"},{"line":835,"name":"@map","kind":13,"containerName":"_calc_coverage_map"},{"line":836,"kind":13,"containerName":"_calc_coverage_map","name":"@hsps"},{"line":836,"name":"$self","containerName":"_calc_coverage_map","kind":13},{"line":836,"containerName":"_calc_coverage_map","kind":12,"name":"hsps"},{"line":836,"kind":13,"containerName":"_calc_coverage_map","name":"$self"},{"line":836,"kind":12,"containerName":"_calc_coverage_map","name":"contexts"},{"line":836,"kind":13,"containerName":"_calc_coverage_map","name":"$type"},{"name":"$context","kind":13,"containerName":"_calc_coverage_map","line":836},{"line":837,"kind":13,"containerName":"_calc_coverage_map","name":"@intervals"},{"line":837,"name":"$type","kind":13,"containerName":"_calc_coverage_map"},{"line":837,"name":"@hsps","containerName":"_calc_coverage_map","kind":13},{"name":"$f","localvar":"my","kind":13,"containerName":"_calc_coverage_map","line":839,"definition":"my"},{"line":839,"name":"$intervals","containerName":"_calc_coverage_map","kind":13},{"kind":13,"containerName":"_calc_coverage_map","name":"$c","line":839},{"kind":13,"containerName":"_calc_coverage_map","name":"@intervals","line":842},{"line":843,"kind":13,"containerName":"_calc_coverage_map","name":"$f"},{"line":843,"name":"$c","kind":13,"containerName":"_calc_coverage_map"},{"name":"$c","kind":13,"containerName":"_calc_coverage_map","line":843},{"containerName":"_calc_coverage_map","kind":13,"name":"$f","line":844},{"containerName":"_calc_coverage_map","kind":13,"name":"$c","line":844},{"name":"@dj_set","localvar":"my","containerName":"_calc_coverage_map","kind":13,"line":849,"definition":"my"},{"containerName":"_calc_coverage_map","kind":13,"name":"@intervals","line":849},{"line":854,"localvar":"my","kind":13,"containerName":"_calc_coverage_map","name":"$i","definition":"my"},{"kind":13,"localvar":"my","containerName":"_calc_coverage_map","name":"@decomp","line":855,"definition":"my"},{"definition":"my","line":856,"name":"$dj_elt","kind":13,"localvar":"my","containerName":"_calc_coverage_map"},{"name":"@dj_set","containerName":"_calc_coverage_map","kind":13,"line":856},{"name":"$covering","kind":13,"localvar":"my","containerName":"_calc_coverage_map","line":857,"definition":"my"},{"line":857,"name":"$indices","containerName":"_calc_coverage_map","kind":13},{"containerName":"_calc_coverage_map","kind":13,"name":"$dj_elt","line":857},{"definition":"my","line":858,"name":"@covering_hsps","localvar":"my","containerName":"_calc_coverage_map","kind":13},{"name":"@hsps","containerName":"_calc_coverage_map","kind":13,"line":858},{"name":"$indices","kind":13,"containerName":"_calc_coverage_map","line":858},{"definition":"my","name":"@coverers","localvar":"my","containerName":"_calc_coverage_map","kind":13,"line":859},{"containerName":"_calc_coverage_map","kind":13,"name":"@intervals","line":859},{"name":"$indices","containerName":"_calc_coverage_map","kind":13,"line":859},{"kind":13,"containerName":"_calc_coverage_map","name":"@decomp","line":860},{"line":860,"kind":13,"containerName":"_calc_coverage_map","name":"@coverers"},{"kind":13,"containerName":"_calc_coverage_map","name":"@decomp","line":861},{"localvar":"my","containerName":"_calc_coverage_map","kind":13,"name":"$component","line":862,"definition":"my"},{"containerName":"_calc_coverage_map","kind":13,"name":"$container_indices","line":862},{"line":863,"name":"@map","kind":13,"containerName":"_calc_coverage_map"},{"line":863,"name":"$component","containerName":"_calc_coverage_map","kind":13},{"line":864,"kind":13,"containerName":"_calc_coverage_map","name":"@covering_hsps"},{"line":864,"kind":13,"containerName":"_calc_coverage_map","name":"$container_indices"},{"name":"@map","containerName":"_calc_coverage_map","kind":13,"line":871},{"name":"$c","containerName":"_calc_coverage_map","kind":13,"line":872},{"line":872,"name":"$c","containerName":"_calc_coverage_map","kind":13},{"name":"$f","containerName":"_calc_coverage_map","kind":13,"line":872},{"kind":13,"containerName":"_calc_coverage_map","name":"$c","line":873},{"kind":13,"containerName":"_calc_coverage_map","name":"$f","line":873},{"line":875,"name":"@dj_set","containerName":"_calc_coverage_map","kind":13},{"line":876,"name":"$c","containerName":"_calc_coverage_map","kind":13},{"containerName":"_calc_coverage_map","kind":13,"name":"$c","line":876},{"line":876,"containerName":"_calc_coverage_map","kind":13,"name":"$f"},{"line":877,"kind":13,"containerName":"_calc_coverage_map","name":"$c"},{"kind":13,"containerName":"_calc_coverage_map","name":"$f","line":877},{"line":881,"name":"@map","kind":13,"containerName":"_calc_coverage_map"},{"line":881,"name":"$a","containerName":"_calc_coverage_map","kind":13},{"line":881,"name":"$b","containerName":"_calc_coverage_map","kind":13},{"line":881,"kind":13,"containerName":"_calc_coverage_map","name":"@map"},{"line":882,"kind":13,"containerName":"_calc_coverage_map","name":"$self"},{"line":882,"kind":13,"containerName":"_calc_coverage_map","name":"@map"},{"name":"$self","kind":13,"containerName":"_calc_coverage_map","line":884},{"kind":13,"containerName":"_calc_coverage_map","name":"@dj_set","line":884}],"containerName":"main::","name":"_calc_coverage_map","definition":"sub","detail":"($type)","line":815,"range":{"start":{"character":0,"line":815},"end":{"character":9999,"line":885}},"kind":12,"signature":{"label":"_calc_coverage_map($type)","parameters":[{"label":"$type"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit"}},{"kind":12,"name":"get_intervals_from_hsps","line":837},{"line":849,"kind":12,"name":"interval_tiling"},{"name":"decompose_interval","kind":12,"line":860},{"signature":{"parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  ","label":"_calc_stats($type,$action,$context)"},"range":{"end":{"line":1006,"character":9999},"start":{"character":0,"line":927}},"kind":12,"line":927,"detail":"($type,$action,$context)","definition":"sub","containerName":"main::","name":"_calc_stats","children":[{"definition":"my","line":928,"localvar":"my","kind":13,"containerName":"_calc_stats","name":"$self"},{"line":929,"containerName":"_calc_stats","localvar":"my","kind":13,"name":"$type","definition":"my"},{"line":929,"name":"$action","kind":13,"containerName":"_calc_stats"},{"line":929,"kind":13,"containerName":"_calc_stats","name":"$context"},{"line":931,"name":"$self","containerName":"_calc_stats","kind":13},{"containerName":"_calc_stats","kind":12,"name":"_check_type_arg","line":931},{"containerName":"_calc_stats","kind":13,"name":"$type","line":931},{"name":"$self","kind":13,"containerName":"_calc_stats","line":932},{"containerName":"_calc_stats","kind":12,"name":"_check_action_arg","line":932},{"name":"$action","kind":13,"containerName":"_calc_stats","line":932},{"line":933,"kind":13,"containerName":"_calc_stats","name":"$self"},{"line":933,"name":"_check_context_arg","kind":12,"containerName":"_calc_stats"},{"line":933,"name":"$type","kind":13,"containerName":"_calc_stats"},{"line":933,"name":"$context","containerName":"_calc_stats","kind":13},{"name":"$ident","kind":13,"localvar":"my","containerName":"_calc_stats","line":934,"definition":"my"},{"name":"$cons","containerName":"_calc_stats","kind":13,"line":934},{"name":"$length","containerName":"_calc_stats","kind":13,"line":934},{"name":"$action","containerName":"_calc_stats","kind":13,"line":940},{"line":941,"localvar":"my","containerName":"_calc_stats","kind":13,"name":"@hsps","definition":"my"},{"name":"$self","kind":13,"containerName":"_calc_stats","line":941},{"line":941,"containerName":"_calc_stats","kind":12,"name":"hit"},{"name":"hsps","containerName":"_calc_stats","kind":12,"line":941},{"containerName":"_calc_stats","kind":13,"name":"@hsps","line":942},{"containerName":"_calc_stats","kind":13,"name":"@hsps","line":942},{"name":"$self","kind":13,"containerName":"_calc_stats","line":942},{"line":942,"name":"contexts","kind":12,"containerName":"_calc_stats"},{"kind":13,"containerName":"_calc_stats","name":"$type","line":942},{"containerName":"_calc_stats","kind":13,"name":"$context","line":942},{"line":944,"localvar":"my","containerName":"_calc_stats","kind":13,"name":"@wt","definition":"my"},{"line":944,"name":"length","kind":12,"containerName":"_calc_stats"},{"name":"$type","kind":13,"containerName":"_calc_stats","line":944},{"name":"@hsps","containerName":"_calc_stats","kind":13,"line":944},{"line":945,"containerName":"_calc_stats","localvar":"my","kind":13,"name":"$sum","definition":"my"},{"line":945,"containerName":"_calc_stats","kind":13,"name":"@wt"},{"line":946,"kind":13,"containerName":"_calc_stats","name":"$sum"},{"line":946,"name":"@wt","kind":13,"containerName":"_calc_stats"},{"line":947,"name":"@hsps","kind":13,"containerName":"_calc_stats"},{"definition":"my","containerName":"_calc_stats","localvar":"my","kind":13,"name":"$wt","line":948},{"line":948,"containerName":"_calc_stats","kind":13,"name":"@wt"},{"line":949,"containerName":"_calc_stats","kind":13,"name":"$ident"},{"line":949,"name":"$wt","kind":13,"containerName":"_calc_stats"},{"name":"matches_MT","kind":12,"containerName":"_calc_stats","line":949},{"line":949,"name":"$type","kind":13,"containerName":"_calc_stats"},{"name":"$cons","kind":13,"containerName":"_calc_stats","line":950},{"line":950,"kind":13,"containerName":"_calc_stats","name":"$wt"},{"kind":12,"containerName":"_calc_stats","name":"matches_MT","line":950},{"line":950,"name":"$type","kind":13,"containerName":"_calc_stats"},{"name":"$length","kind":13,"containerName":"_calc_stats","line":951},{"containerName":"_calc_stats","kind":13,"name":"$wt","line":951},{"name":"length","containerName":"_calc_stats","kind":12,"line":951},{"line":951,"name":"$type","containerName":"_calc_stats","kind":13},{"line":960,"containerName":"_calc_stats","kind":13,"name":"$action"},{"line":961,"name":"$self","containerName":"_calc_stats","kind":13},{"name":"coverage_map","kind":12,"containerName":"_calc_stats","line":961},{"line":961,"containerName":"_calc_stats","kind":13,"name":"$type"},{"line":961,"name":"$context","kind":13,"containerName":"_calc_stats"},{"definition":"my","containerName":"_calc_stats","localvar":"my","kind":13,"name":"$intvl","line":962},{"kind":13,"containerName":"_calc_stats","name":"$hsps","line":962},{"definition":"my","localvar":"my","containerName":"_calc_stats","kind":13,"name":"$len","line":963},{"definition":"my","localvar":"my","containerName":"_calc_stats","kind":13,"name":"$ncover","line":964},{"name":"$action","containerName":"_calc_stats","kind":13,"line":964},{"definition":"my","localvar":"my","containerName":"_calc_stats","kind":13,"name":"$acc_i","line":965},{"name":"$acc_c","kind":13,"containerName":"_calc_stats","line":965},{"definition":"my","containerName":"_calc_stats","localvar":"my","kind":13,"name":"$hsp","line":966},{"line":967,"kind":13,"containerName":"_calc_stats","name":"$action"},{"line":969,"name":"$inc_i","kind":13,"localvar":"my","containerName":"_calc_stats","definition":"my"},{"line":969,"containerName":"_calc_stats","kind":13,"name":"$inc_c"},{"line":969,"kind":13,"containerName":"_calc_stats","name":"$hsp"},{"name":"matches_MT","kind":12,"containerName":"_calc_stats","line":969},{"line":970,"name":"$type","containerName":"_calc_stats","kind":13},{"line":973,"localvar":"my","containerName":"_calc_stats","kind":13,"name":"$frac","definition":"my"},{"line":973,"containerName":"_calc_stats","kind":13,"name":"$len"},{"name":"$hsp","containerName":"_calc_stats","kind":13,"line":973},{"name":"length","kind":12,"containerName":"_calc_stats","line":973},{"line":973,"name":"$type","containerName":"_calc_stats","kind":13},{"name":"$acc_i","containerName":"_calc_stats","kind":13,"line":974},{"name":"$inc_i","containerName":"_calc_stats","kind":13,"line":974},{"containerName":"_calc_stats","kind":13,"name":"$frac","line":974},{"line":975,"name":"$acc_c","kind":13,"containerName":"_calc_stats"},{"kind":13,"containerName":"_calc_stats","name":"$inc_c","line":975},{"line":975,"name":"$frac","kind":13,"containerName":"_calc_stats"},{"localvar":"my","containerName":"_calc_stats","kind":13,"name":"$inc_i","line":979,"definition":"my"},{"line":979,"containerName":"_calc_stats","kind":13,"name":"$inc_c"},{"kind":13,"containerName":"_calc_stats","name":"$hsp","line":979},{"line":979,"name":"matches_MT","kind":12,"containerName":"_calc_stats"},{"name":"$type","containerName":"_calc_stats","kind":13,"line":980},{"line":985,"name":"$acc_i","containerName":"_calc_stats","kind":13},{"kind":13,"containerName":"_calc_stats","name":"$acc_i","line":985},{"name":"$inc_i","containerName":"_calc_stats","kind":13,"line":985},{"name":"$acc_i","kind":13,"containerName":"_calc_stats","line":985},{"line":985,"name":"$inc_i","kind":13,"containerName":"_calc_stats"},{"kind":13,"containerName":"_calc_stats","name":"$acc_c","line":986},{"name":"$acc_c","containerName":"_calc_stats","kind":13,"line":986},{"line":986,"kind":13,"containerName":"_calc_stats","name":"$inc_c"},{"line":986,"name":"$acc_c","containerName":"_calc_stats","kind":13},{"name":"$inc_c","containerName":"_calc_stats","kind":13,"line":986},{"definition":"my","name":"$inc_i","kind":13,"localvar":"my","containerName":"_calc_stats","line":990},{"line":990,"name":"$inc_c","kind":13,"containerName":"_calc_stats"},{"line":990,"name":"$hsp","kind":13,"containerName":"_calc_stats"},{"name":"matches_MT","kind":12,"containerName":"_calc_stats","line":990},{"name":"$type","kind":13,"containerName":"_calc_stats","line":991},{"line":996,"name":"$acc_i","kind":13,"containerName":"_calc_stats"},{"line":996,"name":"$inc_i","kind":13,"containerName":"_calc_stats"},{"name":"$acc_c","containerName":"_calc_stats","kind":13,"line":997},{"line":997,"containerName":"_calc_stats","kind":13,"name":"$inc_c"},{"containerName":"_calc_stats","kind":13,"name":"$ident","line":1002},{"containerName":"_calc_stats","kind":13,"name":"$acc_i","line":1002},{"containerName":"_calc_stats","kind":13,"name":"$ncover","line":1002},{"line":1003,"kind":13,"containerName":"_calc_stats","name":"$cons"},{"line":1003,"name":"$acc_c","containerName":"_calc_stats","kind":13},{"line":1003,"kind":13,"containerName":"_calc_stats","name":"$ncover"},{"line":1004,"name":"$length","containerName":"_calc_stats","kind":13},{"kind":13,"containerName":"_calc_stats","name":"$len","line":1004}]},{"line":963,"name":"intvl","kind":12},{"line":963,"kind":12,"name":"intvl"},{"kind":12,"name":"intvl","line":982},{"name":"intvl","kind":12,"line":983},{"line":993,"name":"intvl","kind":12},{"name":"intvl","kind":12,"line":994},{"line":1008,"kind":13,"containerName":null,"name":"%self"},{"name":"$ident","containerName":null,"kind":13,"line":1008},{"line":1009,"containerName":null,"kind":13,"name":"%self"},{"line":1009,"name":"$cons","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":1010},{"containerName":null,"kind":13,"name":"$length","line":1010},{"range":{"start":{"line":1044,"character":0},"end":{"line":1095,"character":9999}},"kind":12,"line":1044,"signature":{"label":"_make_tiling_iterator($type,$context)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  \n\n\nsub _calc_stats {\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    # need to check args here, in case method is called internally.\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    my ($ident, $cons, $length) = (0,0,0);\n\n    # fast : avoid coverage map altogether, get a pretty damn\n    # good estimate with a weighted average of reported hsp\n    # statistics\n\n    ($action eq 'fast') && do {\n\tmy @hsps = $self->hit->hsps;\n\t@hsps = @hsps[$self->contexts($type, $context)];\n\t# weights for averages\n\tmy @wt = map {$_->length($type)} @hsps;\n\tmy $sum = eval( join('+',@wt) );\n\t$_ /= $sum for (@wt);\n\tfor (@hsps) { \n\t    my $wt = shift @wt;\n\t    $ident  += $wt*$_->matches_MT($type,'identities');\n\t    $cons   += $wt*$_->matches_MT($type,'conserved');\n\t    $length += $wt*$_->length($type);\n\t}\n    };\n\n    # or, do tiling\n\n    # calculate identities/conserved sites in tiling\n    # estimate based on the fraction of the component interval covered\n    # and ident/cons reported by the HSPs\n    ($action ne 'fast') && do {\n\tforeach ($self->coverage_map($type, $context)) {\n\t    my ($intvl, $hsps) = @{$_};\n\t    my $len = ($$intvl[1]-$$intvl[0]+1);\n\t    my $ncover = ($action eq 'max') ? 1 : scalar @$hsps;\n\t    my ($acc_i, $acc_c) = (0,0);\n\t    foreach my $hsp (@$hsps) {\n\t\tfor ($action) {\n\t\t    ($_ eq 'est') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    );\n\t\t\tmy $frac = $len/$hsp->length($type);\n\t\t\t$acc_i += $inc_i * $frac;\n\t\t\t$acc_c += $inc_c * $frac;\n\t\t\tlast;\n\t\t    };\n\t\t    ($_ eq 'max') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    -start => $$intvl[0], \n\t\t\t    -end   => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i = ($acc_i > $inc_i) ? $acc_i : $inc_i;\n\t\t\t$acc_c = ($acc_c > $inc_c) ? $acc_c : $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t    (!$_ || ($_ eq 'exact')) && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type, \n\t\t\t    -action => 'searchutils',\n\t\t\t    -start  => $$intvl[0], \n\t\t\t    -end    => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i += $inc_i;\n\t\t\t$acc_c += $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t}\n\t    }\n\t    $ident += ($acc_i/$ncover);\n\t    $cons  += ($acc_c/$ncover);\n\t    $length += $len;\n\t}\n    };\n    \n    $self->{\"identities_${type}_${action}_${context}\"} = $ident;\n    $self->{\"conserved_${type}_${action}_${context}\"} = $cons;\n    $self->{\"length_${type}_${action}_${context}\"} = $length;\n    \n    return 1;\n}\n\n=head2 Tiling Helper Methods\n\n\n# coverage_map is of the form\n# ( [ $interval, \\@containing_hsps ], ... )\n\n# so, for each interval, pick one of the containing hsps,\n# and return the union of all the picks.\n\n# use the combinatorial generating iterator, with \n# the urns containing the @containing_hsps for each\n# interval\n\n=head2 _make_tiling_iterator\n\n Title   : _make_tiling_iterator\n Usage   : $self->_make_tiling_iterator($type)\n Function: Create an iterator code ref that will step through all \n           minimal combinations of HSPs that produce complete coverage\n           of the $type ('hit', 'subject', 'query') sequence, \n           and set the correct iterator property of the invocant\n Example :\n Returns : True on success\n Args    : scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'","parameters":[{"label":"$type"},{"label":"$context"}]},"name":"_make_tiling_iterator","containerName":"main::","children":[{"line":1046,"name":"$self","localvar":"my","kind":13,"containerName":"_make_tiling_iterator","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_make_tiling_iterator","name":"$type","line":1047},{"name":"$context","kind":13,"containerName":"_make_tiling_iterator","line":1047},{"containerName":"_make_tiling_iterator","kind":13,"name":"$self","line":1048},{"line":1048,"containerName":"_make_tiling_iterator","kind":12,"name":"_check_type_arg"},{"line":1048,"name":"$type","containerName":"_make_tiling_iterator","kind":13},{"containerName":"_make_tiling_iterator","kind":13,"name":"$self","line":1049},{"line":1049,"name":"_check_context_arg","containerName":"_make_tiling_iterator","kind":12},{"line":1049,"kind":13,"containerName":"_make_tiling_iterator","name":"$type"},{"line":1049,"containerName":"_make_tiling_iterator","kind":13,"name":"$context"},{"localvar":"my","containerName":"_make_tiling_iterator","kind":13,"name":"@urns","line":1052,"definition":"my"},{"name":"$self","containerName":"_make_tiling_iterator","kind":13,"line":1052},{"line":1052,"kind":12,"containerName":"_make_tiling_iterator","name":"coverage_map"},{"name":"$type","kind":13,"containerName":"_make_tiling_iterator","line":1052},{"kind":13,"containerName":"_make_tiling_iterator","name":"$context","line":1052},{"line":1054,"localvar":"my","containerName":"_make_tiling_iterator","kind":13,"name":"$FINISHED","definition":"my"},{"line":1055,"containerName":"_make_tiling_iterator","localvar":"my","kind":13,"name":"$iter","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_make_tiling_iterator","name":"$rewind","line":1057},{"line":1059,"name":"@urns","containerName":"_make_tiling_iterator","kind":13},{"line":1060,"kind":13,"containerName":"_make_tiling_iterator","name":"$FINISHED"},{"line":1064,"name":"$FINISHED","containerName":"_make_tiling_iterator","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_make_tiling_iterator","name":"$finished_incrementing","line":1066},{"name":"@ret","localvar":"my","kind":13,"containerName":"_make_tiling_iterator","line":1068,"definition":"my"},{"definition":"my","line":1070,"localvar":"my","kind":13,"containerName":"_make_tiling_iterator","name":"$urn"},{"kind":13,"containerName":"_make_tiling_iterator","name":"@urns","line":1070},{"definition":"my","line":1071,"localvar":"my","containerName":"_make_tiling_iterator","kind":13,"name":"$n"},{"kind":13,"containerName":"_make_tiling_iterator","name":"$hsps","line":1071},{"line":1071,"name":"$urn","kind":13,"containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","kind":13,"name":"@ret","line":1072},{"containerName":"_make_tiling_iterator","kind":13,"name":"$n","line":1072},{"name":"$finished_incrementing","kind":13,"containerName":"_make_tiling_iterator","line":1073},{"line":1074,"kind":13,"containerName":"_make_tiling_iterator","name":"$n"},{"line":1074,"name":"$hsps","containerName":"_make_tiling_iterator","kind":13},{"containerName":"_make_tiling_iterator","kind":13,"name":"$finished_incrementing","line":1075},{"line":1080,"kind":13,"containerName":"_make_tiling_iterator","name":"$FINISHED"},{"line":1080,"name":"$finished_incrementing","containerName":"_make_tiling_iterator","kind":13},{"containerName":"_make_tiling_iterator","localvar":"my","kind":13,"name":"%order","line":1085,"definition":"my"},{"line":1085,"kind":13,"containerName":"_make_tiling_iterator","name":"%uniq"},{"line":1086,"name":"@order","containerName":"_make_tiling_iterator","kind":13},{"name":"@ret","kind":13,"containerName":"_make_tiling_iterator","line":1086},{"containerName":"_make_tiling_iterator","kind":13,"name":"$uniq","line":1087},{"line":1087,"containerName":"_make_tiling_iterator","kind":13,"name":"$order"},{"line":1087,"containerName":"_make_tiling_iterator","kind":12,"name":"rank"},{"line":1088,"containerName":"_make_tiling_iterator","kind":13,"name":"@ret"},{"line":1088,"name":"@order","containerName":"_make_tiling_iterator","kind":13},{"name":"$a","containerName":"_make_tiling_iterator","kind":13,"line":1088},{"line":1088,"kind":13,"containerName":"_make_tiling_iterator","name":"$b"},{"name":"%uniq","kind":13,"containerName":"_make_tiling_iterator","line":1088},{"name":"@ret","kind":13,"containerName":"_make_tiling_iterator","line":1090},{"line":1093,"kind":13,"containerName":"_make_tiling_iterator","name":"$self"},{"line":1093,"name":"$iter","containerName":"_make_tiling_iterator","kind":13}],"detail":"($type,$context)","definition":"sub"},{"line":1074,"name":"urn","kind":12},{"name":"urn","kind":12,"line":1075},{"line":1086,"kind":12,"name":"ret"},{"name":"ret","kind":12,"line":1087},{"signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  \n\n\nsub _calc_stats {\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    # need to check args here, in case method is called internally.\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    my ($ident, $cons, $length) = (0,0,0);\n\n    # fast : avoid coverage map altogether, get a pretty damn\n    # good estimate with a weighted average of reported hsp\n    # statistics\n\n    ($action eq 'fast') && do {\n\tmy @hsps = $self->hit->hsps;\n\t@hsps = @hsps[$self->contexts($type, $context)];\n\t# weights for averages\n\tmy @wt = map {$_->length($type)} @hsps;\n\tmy $sum = eval( join('+',@wt) );\n\t$_ /= $sum for (@wt);\n\tfor (@hsps) { \n\t    my $wt = shift @wt;\n\t    $ident  += $wt*$_->matches_MT($type,'identities');\n\t    $cons   += $wt*$_->matches_MT($type,'conserved');\n\t    $length += $wt*$_->length($type);\n\t}\n    };\n\n    # or, do tiling\n\n    # calculate identities/conserved sites in tiling\n    # estimate based on the fraction of the component interval covered\n    # and ident/cons reported by the HSPs\n    ($action ne 'fast') && do {\n\tforeach ($self->coverage_map($type, $context)) {\n\t    my ($intvl, $hsps) = @{$_};\n\t    my $len = ($$intvl[1]-$$intvl[0]+1);\n\t    my $ncover = ($action eq 'max') ? 1 : scalar @$hsps;\n\t    my ($acc_i, $acc_c) = (0,0);\n\t    foreach my $hsp (@$hsps) {\n\t\tfor ($action) {\n\t\t    ($_ eq 'est') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    );\n\t\t\tmy $frac = $len/$hsp->length($type);\n\t\t\t$acc_i += $inc_i * $frac;\n\t\t\t$acc_c += $inc_c * $frac;\n\t\t\tlast;\n\t\t    };\n\t\t    ($_ eq 'max') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    -start => $$intvl[0], \n\t\t\t    -end   => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i = ($acc_i > $inc_i) ? $acc_i : $inc_i;\n\t\t\t$acc_c = ($acc_c > $inc_c) ? $acc_c : $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t    (!$_ || ($_ eq 'exact')) && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type, \n\t\t\t    -action => 'searchutils',\n\t\t\t    -start  => $$intvl[0], \n\t\t\t    -end    => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i += $inc_i;\n\t\t\t$acc_c += $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t}\n\t    }\n\t    $ident += ($acc_i/$ncover);\n\t    $cons  += ($acc_c/$ncover);\n\t    $length += $len;\n\t}\n    };\n    \n    $self->{\"identities_${type}_${action}_${context}\"} = $ident;\n    $self->{\"conserved_${type}_${action}_${context}\"} = $cons;\n    $self->{\"length_${type}_${action}_${context}\"} = $length;\n    \n    return 1;\n}\n\n=head2 Tiling Helper Methods\n\n\n# coverage_map is of the form\n# ( [ $interval, \\@containing_hsps ], ... )\n\n# so, for each interval, pick one of the containing hsps,\n# and return the union of all the picks.\n\n# use the combinatorial generating iterator, with \n# the urns containing the @containing_hsps for each\n# interval\n\n=head2 _make_tiling_iterator\n\n Title   : _make_tiling_iterator\n Usage   : $self->_make_tiling_iterator($type)\n Function: Create an iterator code ref that will step through all \n           minimal combinations of HSPs that produce complete coverage\n           of the $type ('hit', 'subject', 'query') sequence, \n           and set the correct iterator property of the invocant\n Example :\n Returns : True on success\n Args    : scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub _make_tiling_iterator {\n    ### create the urns\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    # initialize the urns\n    my @urns = map { [0,  $$_[1]] } $self->coverage_map($type, $context);\n\n    my $FINISHED = 0;\n    my $iter = sub {\n\t# rewind?\n\tif (my $rewind = shift) {\n\t    # reinitialize urn indices\n\t    $$_[0] = 0 for (@urns);\n\t    $FINISHED = 0;\n\t    return 1;\n\t}\t    \n\t# check if done...\n        return if $FINISHED;\n\n        my $finished_incrementing = 0;\n\t# @ret is the collector of urn choices\n\tmy @ret;\n\n\tfor my $urn (@urns) {\n\t    my ($n, $hsps) = @$urn;\n\t    push @ret, $$hsps[$n];\n\t    unless ($finished_incrementing) {\n\t\tif ($n == $#$hsps) { $$urn[0] = 0; }\n\t\telse { ($$urn[0])++; $finished_incrementing = 1 }\n\t    }\n\t}\n\n\t# backstop...\n        $FINISHED = 1 unless $finished_incrementing;\n\t# uniquify @ret\n\t# $hsp->rank is a unique identifier for an hsp in a hit.\n\t# preserve order in @ret\n\t\n\tmy (%order, %uniq);\n\t@order{(0..$#ret)} = @ret;\n\t$uniq{$order{$_}->rank} = $_ for (0..$#ret);\n\t@ret = @order{ sort {$a<=>$b} values %uniq };\n\n        return @ret;\n    };\n\n    $self->{\"_tiling_iterator_${type}_${context}\"} = $iter;\n    return 1;\n}\n\n=head2 _tiling_iterator\n\n Title   : _tiling_iterator\n Usage   : $tiling->_tiling_iterator($type,$context)\n Function: Retrieve the tiling iterator coderef for the requested \n           $type ('hit', 'subject', 'query')\n Example : \n Returns : coderef to the desired iterator\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $context: strand/frame context string\n Note    : getter only","label":"_tiling_iterator($type,$context)"},"kind":12,"range":{"start":{"character":0,"line":1112},"end":{"line":1122,"character":9999}},"line":1112,"detail":"($type,$context)","definition":"sub","containerName":"main::","name":"_tiling_iterator","children":[{"line":1113,"kind":13,"localvar":"my","containerName":"_tiling_iterator","name":"$self","definition":"my"},{"line":1114,"name":"$type","kind":13,"localvar":"my","containerName":"_tiling_iterator","definition":"my"},{"name":"$context","kind":13,"containerName":"_tiling_iterator","line":1114},{"name":"$self","containerName":"_tiling_iterator","kind":13,"line":1115},{"line":1115,"kind":12,"containerName":"_tiling_iterator","name":"_check_type_arg"},{"containerName":"_tiling_iterator","kind":13,"name":"$type","line":1115},{"line":1116,"name":"$self","containerName":"_tiling_iterator","kind":13},{"name":"_check_context_arg","containerName":"_tiling_iterator","kind":12,"line":1116},{"line":1116,"name":"$type","containerName":"_tiling_iterator","kind":13},{"line":1116,"kind":13,"containerName":"_tiling_iterator","name":"$context"},{"kind":13,"containerName":"_tiling_iterator","name":"$self","line":1118},{"line":1119,"kind":13,"containerName":"_tiling_iterator","name":"$self"},{"line":1119,"name":"_make_tiling_iterator","containerName":"_tiling_iterator","kind":12},{"line":1119,"containerName":"_tiling_iterator","kind":13,"name":"$type"},{"containerName":"_tiling_iterator","kind":13,"name":"$context","line":1119},{"line":1121,"kind":13,"containerName":"_tiling_iterator","name":"$self"}]},{"definition":"sub","children":[{"definition":"my","line":1131,"containerName":"_check_type_arg","localvar":"my","kind":13,"name":"$self"},{"containerName":"_check_type_arg","localvar":"my","kind":13,"name":"$typeref","line":1132,"definition":"my"},{"name":"$self","kind":13,"containerName":"_check_type_arg","line":1134},{"kind":12,"containerName":"_check_type_arg","name":"throw","line":1134}],"name":"_check_type_arg","containerName":"main::","line":1130,"kind":12,"range":{"end":{"character":9999,"line":1137},"start":{"line":1130,"character":0}}},{"line":1133,"name":"typeref","kind":12},{"line":1135,"name":"typeref","kind":12},{"line":1135,"kind":12,"name":"typeref"},{"children":[{"definition":"my","line":1140,"localvar":"my","kind":13,"containerName":"_check_action_arg","name":"$self"},{"definition":"my","name":"$actionref","localvar":"my","containerName":"_check_action_arg","kind":13,"line":1141},{"kind":13,"containerName":"_check_action_arg","name":"$self","line":1143},{"name":"_has_sequence_data","containerName":"_check_action_arg","kind":12,"line":1143},{"name":"$self","kind":13,"containerName":"_check_action_arg","line":1146},{"containerName":"_check_action_arg","kind":12,"name":"throw","line":1146},{"line":1147,"name":"$self","kind":13,"containerName":"_check_action_arg"},{"kind":12,"containerName":"_check_action_arg","name":"_has_sequence_data","line":1147},{"line":1148,"containerName":"_check_action_arg","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"_check_action_arg","line":1148}],"containerName":"main::","name":"_check_action_arg","definition":"sub","line":1139,"range":{"end":{"line":1153,"character":9999},"start":{"line":1139,"character":0}},"kind":12},{"name":"actionref","kind":12,"line":1142},{"line":1143,"name":"actionref","kind":12},{"line":1147,"name":"actionref","kind":12},{"kind":12,"name":"actionref","line":1149},{"signature":{"parameters":[{"label":"$type"},{"label":"$contextref"}],"documentation":"","label":"_check_context_arg($type,$contextref)"},"line":1155,"kind":12,"range":{"start":{"line":1155,"character":0},"end":{"character":9999,"line":1169}},"definition":"sub","detail":"($type,$contextref)","children":[{"definition":"my","line":1156,"name":"$self","kind":13,"localvar":"my","containerName":"_check_context_arg"},{"name":"$type","kind":13,"localvar":"my","containerName":"_check_context_arg","line":1157,"definition":"my"},{"line":1157,"name":"$contextref","kind":13,"containerName":"_check_context_arg"},{"kind":13,"containerName":"_check_context_arg","name":"$self","line":1159},{"line":1159,"name":"throw","containerName":"_check_context_arg","kind":12},{"line":1159,"containerName":"_check_context_arg","kind":13,"name":"$self"},{"kind":12,"containerName":"_check_context_arg","name":"algorithm","line":1159},{"kind":13,"containerName":"_check_context_arg","name":"$self","line":1159},{"line":1159,"name":"mapping","containerName":"_check_context_arg","kind":12},{"line":1159,"name":"$type","kind":13,"containerName":"_check_context_arg"},{"name":"$self","containerName":"_check_context_arg","kind":13,"line":1161},{"line":1161,"name":"default_context","kind":12,"containerName":"_check_context_arg"},{"kind":13,"containerName":"_check_context_arg","name":"$type","line":1161},{"line":1165,"name":"$self","kind":13,"containerName":"_check_context_arg"},{"line":1165,"kind":12,"containerName":"_check_context_arg","name":"throw"}],"name":"_check_context_arg","containerName":"main::"},{"name":"contextref","kind":12,"line":1158},{"line":1161,"name":"contextref","kind":12},{"name":"contextref","kind":12,"line":1164},{"kind":12,"name":"contextref","line":1164},{"kind":12,"name":"contextref","line":1166},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_make_context_key","name":"$self","line":1187},{"line":1188,"name":"@args","localvar":"my","containerName":"_make_context_key","kind":13,"definition":"my"},{"line":1189,"localvar":"my","kind":13,"containerName":"_make_context_key","name":"$type","definition":"my"},{"kind":13,"containerName":"_make_context_key","name":"$strand","line":1189},{"name":"$frame","containerName":"_make_context_key","kind":13,"line":1189},{"line":1189,"containerName":"_make_context_key","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"_make_context_key","kind":12,"line":1189},{"name":"@args","containerName":"_make_context_key","kind":13,"line":1189},{"containerName":"_make_context_key","kind":13,"name":"$type","line":1190},{"line":1191,"name":"$strand","containerName":"_make_context_key","kind":13},{"name":"$frame","kind":13,"containerName":"_make_context_key","line":1191},{"name":"$strand","kind":13,"containerName":"_make_context_key","line":1192},{"containerName":"_make_context_key","kind":13,"name":"$self","line":1192},{"name":"_has_strand","kind":12,"containerName":"_make_context_key","line":1192},{"name":"$type","kind":13,"containerName":"_make_context_key","line":1192},{"containerName":"_make_context_key","kind":13,"name":"$frame","line":1193},{"containerName":"_make_context_key","kind":13,"name":"$self","line":1193},{"line":1193,"name":"_has_frame","kind":12,"containerName":"_make_context_key"},{"line":1193,"containerName":"_make_context_key","kind":13,"name":"$type"},{"containerName":"_make_context_key","kind":13,"name":"$strand","line":1194},{"line":1194,"kind":13,"containerName":"_make_context_key","name":"$frame"},{"line":1197,"containerName":"_make_context_key","kind":13,"name":"$strand"},{"name":"$frame","containerName":"_make_context_key","kind":13,"line":1201},{"name":"$self","kind":13,"containerName":"_make_context_key","line":1201},{"kind":12,"containerName":"_make_context_key","name":"_has_frame","line":1201},{"kind":13,"containerName":"_make_context_key","name":"$type","line":1201},{"kind":13,"containerName":"_make_context_key","name":"$self","line":1202},{"line":1202,"name":"warn","containerName":"_make_context_key","kind":12},{"line":1203,"name":"$frame","kind":13,"containerName":"_make_context_key"}],"containerName":"main::","name":"_make_context_key","line":1186,"kind":12,"range":{"start":{"character":0,"line":1186},"end":{"character":9999,"line":1209}}},{"definition":"sub","children":[{"name":"_make_context_key","kind":12,"containerName":"_context","line":1226}],"containerName":"main::","name":"_context","line":1226,"kind":12,"range":{"end":{"line":1226,"character":9999},"start":{"character":0,"line":1226}}},{"children":[{"line":1240,"name":"$self","localvar":"my","containerName":"_has_sequence_data","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"_has_sequence_data","line":1241},{"line":1241,"containerName":"_has_sequence_data","kind":12,"name":"throw"},{"line":1241,"name":"$self","containerName":"_has_sequence_data","kind":13},{"line":1241,"containerName":"_has_sequence_data","kind":12,"name":"hit"},{"line":1242,"containerName":"_has_sequence_data","kind":13,"name":"$self"},{"line":1242,"name":"hit","kind":12,"containerName":"_has_sequence_data"},{"name":"hsps","containerName":"_has_sequence_data","kind":12,"line":1242},{"containerName":"_has_sequence_data","kind":12,"name":"seq_str","line":1242}],"name":"_has_sequence_data","containerName":"main::","definition":"sub","line":1239,"range":{"end":{"character":9999,"line":1243},"start":{"line":1239,"character":0}},"kind":12},{"line":1249,"kind":12,"range":{"end":{"character":9999,"line":1256},"start":{"character":0,"line":1249}},"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_has_logical_length","line":1250},{"line":1251,"kind":13,"localvar":"my","containerName":"_has_logical_length","name":"$type","definition":"my"},{"kind":13,"containerName":"_has_logical_length","name":"$self","line":1252},{"line":1252,"kind":12,"containerName":"_has_logical_length","name":"_check_type_arg"},{"kind":13,"containerName":"_has_logical_length","name":"$type","line":1252},{"kind":13,"containerName":"_has_logical_length","name":"$self","line":1254},{"line":1254,"kind":12,"containerName":"_has_logical_length","name":"throw"},{"name":"$self","containerName":"_has_logical_length","kind":13,"line":1254},{"line":1254,"name":"mapping","kind":12,"containerName":"_has_logical_length"},{"containerName":"_has_logical_length","kind":13,"name":"$type","line":1254},{"line":1255,"kind":13,"containerName":"_has_logical_length","name":"$self"},{"line":1255,"name":"mapping","containerName":"_has_logical_length","kind":12},{"containerName":"_has_logical_length","kind":13,"name":"$type","line":1255}],"name":"_has_logical_length","containerName":"main::"},{"line":1262,"range":{"start":{"character":0,"line":1262},"end":{"character":9999,"line":1267}},"kind":12,"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_has_strand","line":1263,"definition":"my"},{"line":1264,"localvar":"my","kind":13,"containerName":"_has_strand","name":"$type","definition":"my"},{"line":1265,"containerName":"_has_strand","kind":13,"name":"$self"},{"line":1265,"containerName":"_has_strand","kind":12,"name":"_check_type_arg"},{"line":1265,"kind":13,"containerName":"_has_strand","name":"$type"},{"line":1266,"name":"$self","kind":13,"containerName":"_has_strand"}],"containerName":"main::","name":"_has_strand"},{"definition":"sub","children":[{"line":1274,"name":"$self","localvar":"my","containerName":"_has_frame","kind":13,"definition":"my"},{"line":1275,"name":"$type","localvar":"my","kind":13,"containerName":"_has_frame","definition":"my"},{"name":"$self","kind":13,"containerName":"_has_frame","line":1276},{"line":1276,"containerName":"_has_frame","kind":12,"name":"_check_type_arg"},{"kind":13,"containerName":"_has_frame","name":"$type","line":1276},{"name":"$self","kind":13,"containerName":"_has_frame","line":1277}],"name":"_has_frame","containerName":"main::","line":1273,"kind":12,"range":{"start":{"character":0,"line":1273},"end":{"character":9999,"line":1278}}},{"signature":{"documentation":"","parameters":[{"label":"$type"},{"label":"$context"}],"label":"_contig_intersection($type,$context)"},"range":{"start":{"character":0,"line":1295},"end":{"character":9999,"line":1303}},"kind":12,"line":1295,"detail":"($type,$context)","definition":"sub","containerName":"main::","name":"_contig_intersection","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_contig_intersection","kind":13,"line":1296},{"definition":"my","line":1297,"localvar":"my","containerName":"_contig_intersection","kind":13,"name":"$type"},{"line":1297,"containerName":"_contig_intersection","kind":13,"name":"$context"},{"line":1298,"name":"$self","containerName":"_contig_intersection","kind":13},{"line":1298,"name":"_check_type_arg","kind":12,"containerName":"_contig_intersection"},{"kind":13,"containerName":"_contig_intersection","name":"$type","line":1298},{"kind":13,"containerName":"_contig_intersection","name":"$self","line":1299},{"line":1299,"containerName":"_contig_intersection","kind":12,"name":"_check_context_arg"},{"kind":13,"containerName":"_contig_intersection","name":"$type","line":1299},{"containerName":"_contig_intersection","kind":13,"name":"$context","line":1299},{"name":"$self","containerName":"_contig_intersection","kind":13,"line":1300},{"line":1301,"name":"$self","containerName":"_contig_intersection","kind":13},{"line":1301,"kind":12,"containerName":"_contig_intersection","name":"_calc_coverage_map"},{"line":1301,"name":"$type","kind":13,"containerName":"_contig_intersection"},{"line":1303,"kind":13,"containerName":"_contig_intersection","name":"$self"}]},{"line":1325,"kind":12,"range":{"end":{"line":1331,"character":9999},"start":{"line":1325,"character":0}},"children":[{"kind":13,"localvar":"my","containerName":"_reported_length","name":"$self","line":1326,"definition":"my"},{"line":1327,"localvar":"my","kind":13,"containerName":"_reported_length","name":"$type","definition":"my"},{"line":1328,"name":"$self","kind":13,"containerName":"_reported_length"},{"containerName":"_reported_length","kind":12,"name":"_check_type_arg","line":1328},{"kind":13,"containerName":"_reported_length","name":"$type","line":1328},{"localvar":"my","kind":13,"containerName":"_reported_length","name":"$key","line":1329,"definition":"my"},{"line":1329,"name":"$type","containerName":"_reported_length","kind":13},{"line":1330,"kind":13,"containerName":"_reported_length","name":"$self"},{"line":1330,"name":"hsps","kind":12,"containerName":"_reported_length"},{"kind":13,"containerName":"_reported_length","name":"$key","line":1330}],"containerName":"main::","name":"_reported_length","definition":"sub"}]}