{"version":5,"vars":[{"line":90,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":119,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":119},{"definition":"my","line":120,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"name":"$class","kind":13,"containerName":"new","line":120},{"name":"@args","containerName":"new","kind":13,"line":120},{"definition":"my","line":122,"kind":13,"localvar":"my","containerName":"new","name":"$hmm"},{"line":122,"kind":13,"containerName":"new","name":"$seqfile"},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"line":122,"containerName":"new","kind":12,"name":"_rearrange"},{"line":123,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$seqfile","line":125},{"containerName":"new","kind":13,"name":"$self","line":125},{"line":125,"name":"sequence_file","kind":12,"containerName":"new"},{"line":125,"name":"$seqfile","containerName":"new","kind":13},{"name":"$hmm","kind":13,"containerName":"new","line":126},{"kind":13,"containerName":"new","name":"$self","line":126},{"line":126,"kind":12,"containerName":"new","name":"hmm_name"},{"containerName":"new","kind":13,"name":"$hmm","line":126},{"line":128,"kind":13,"containerName":"new","name":"$self"}],"name":"new","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HMMERResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HMMERResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HMMERResult - A Result object for HMMER results\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Result::HMMERResult;\n    my $result = Bio::Search::Result::HMMERResult->new\n    ( -hmm_name => 'pfam',\n      -sequence_file => 'roa1.pep',\n      -hits => \\@hits);\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n\t\t\t       -file   => 'result.hmmer');\n    while( my $result = $in->next_result ) {\n\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is a specialization of L<Bio::Search::Result::GenericResult>.\nThere are a few extra methods, specifically L<sequence_file>,\nL<hmm_name>, L<next_models>, and L<models>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::HMMERResult;\nuse strict;\n\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::HMMERResult->new();\n Function: Builds a new Bio::Search::Result::HMMERResult object \n Returns : Bio::Search::Result::HMMERResult\n Args    : -hmm_name => string, name of hmm file\n           -sequence_file => name of the sequence file\n\nplus Bio::Search::Result::GenericResult parameters\n\n           -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version => version of the algorithm (2.1.2)\n           -program_reference => literature reference string for this algorithm","label":"new($class,@args)"},"line":118,"range":{"start":{"line":118,"character":0},"end":{"character":9999,"line":129}},"kind":12},{"line":120,"name":"SUPER","containerName":"new","kind":12},{"signature":{"label":"hmm_name($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: HMMERResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HMMERResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HMMERResult - A Result object for HMMER results\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Result::HMMERResult;\n    my $result = Bio::Search::Result::HMMERResult->new\n    ( -hmm_name => 'pfam',\n      -sequence_file => 'roa1.pep',\n      -hits => \\@hits);\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n\t\t\t       -file   => 'result.hmmer');\n    while( my $result = $in->next_result ) {\n\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is a specialization of L<Bio::Search::Result::GenericResult>.\nThere are a few extra methods, specifically L<sequence_file>,\nL<hmm_name>, L<next_models>, and L<models>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::HMMERResult;\nuse strict;\n\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::HMMERResult->new();\n Function: Builds a new Bio::Search::Result::HMMERResult object \n Returns : Bio::Search::Result::HMMERResult\n Args    : -hmm_name => string, name of hmm file\n           -sequence_file => name of the sequence file\n\nplus Bio::Search::Result::GenericResult parameters\n\n           -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version => version of the algorithm (2.1.2)\n           -program_reference => literature reference string for this algorithm\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($hmm,$seqfile) = $self->_rearrange([qw(HMM_NAME SEQUENCE_FILE)],\n\t\t\t\t\t @args);\n  \n  defined( $seqfile) && $self->sequence_file($seqfile);\n  defined( $hmm) && $self->hmm_name($hmm);\n\n  return $self;\n}\n\n\n=head2 hmm_name\n\n Title   : hmm_name\n Usage   : $obj->hmm_name($newval)\n Function: Get/Set the value of hmm_name\n Returns : value of hmm_name\n Args    : newvalue (optional)"},"line":143,"kind":12,"range":{"start":{"line":143,"character":0},"end":{"character":9999,"line":149}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","containerName":"hmm_name","localvar":"my","kind":13,"line":144,"definition":"my"},{"name":"$value","kind":13,"containerName":"hmm_name","line":144},{"containerName":"hmm_name","kind":13,"name":"$value","line":145},{"line":146,"kind":13,"containerName":"hmm_name","name":"$self"},{"name":"$value","kind":13,"containerName":"hmm_name","line":146},{"containerName":"hmm_name","kind":13,"name":"$self","line":148}],"containerName":"main::","name":"hmm_name"},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":164,"localvar":"my","kind":13,"containerName":"sequence_file","name":"$self"},{"line":164,"containerName":"sequence_file","kind":13,"name":"$value"},{"containerName":"sequence_file","kind":13,"name":"$value","line":165},{"kind":13,"containerName":"sequence_file","name":"$self","line":166},{"name":"$value","kind":13,"containerName":"sequence_file","line":166},{"kind":13,"containerName":"sequence_file","name":"$self","line":168}],"name":"sequence_file","containerName":"main::","signature":{"documentation":"1;\n# $Id: HMMERResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HMMERResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HMMERResult - A Result object for HMMER results\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Result::HMMERResult;\n    my $result = Bio::Search::Result::HMMERResult->new\n    ( -hmm_name => 'pfam',\n      -sequence_file => 'roa1.pep',\n      -hits => \\@hits);\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n\t\t\t       -file   => 'result.hmmer');\n    while( my $result = $in->next_result ) {\n\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is a specialization of L<Bio::Search::Result::GenericResult>.\nThere are a few extra methods, specifically L<sequence_file>,\nL<hmm_name>, L<next_models>, and L<models>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::HMMERResult;\nuse strict;\n\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::HMMERResult->new();\n Function: Builds a new Bio::Search::Result::HMMERResult object \n Returns : Bio::Search::Result::HMMERResult\n Args    : -hmm_name => string, name of hmm file\n           -sequence_file => name of the sequence file\n\nplus Bio::Search::Result::GenericResult parameters\n\n           -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version => version of the algorithm (2.1.2)\n           -program_reference => literature reference string for this algorithm\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($hmm,$seqfile) = $self->_rearrange([qw(HMM_NAME SEQUENCE_FILE)],\n\t\t\t\t\t @args);\n  \n  defined( $seqfile) && $self->sequence_file($seqfile);\n  defined( $hmm) && $self->hmm_name($hmm);\n\n  return $self;\n}\n\n\n=head2 hmm_name\n\n Title   : hmm_name\n Usage   : $obj->hmm_name($newval)\n Function: Get/Set the value of hmm_name\n Returns : value of hmm_name\n Args    : newvalue (optional)\n\n\n\nsub hmm_name{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_hmm_name'} = $value;\n    }\n    return $self->{'_hmm_name'};\n}\n\n\n=head2 sequence_file\n\n Title   : sequence_file\n Usage   : $obj->sequence_file($newval)\n Function: Get/Set the value of sequence_file\n Returns : value of sequence_file\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"sequence_file($self,$value)"},"line":163,"kind":12,"range":{"end":{"character":9999,"line":170},"start":{"character":0,"line":163}}},{"name":"next_model","containerName":"main::","children":[{"name":"next_hit","kind":12,"containerName":"next_model","line":185}],"definition":"sub","kind":12,"range":{"end":{"line":185,"character":9999},"start":{"line":185,"character":0}},"line":185},{"definition":"sub","containerName":"main::","name":"models","children":[{"line":199,"name":"hits","containerName":"models","kind":12}],"range":{"start":{"line":199,"character":0},"end":{"line":199,"character":9999}},"kind":12,"line":199},{"signature":{"label":"rewind($self)","documentation":"1;\n# $Id: HMMERResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HMMERResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HMMERResult - A Result object for HMMER results\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Result::HMMERResult;\n    my $result = Bio::Search::Result::HMMERResult->new\n    ( -hmm_name => 'pfam',\n      -sequence_file => 'roa1.pep',\n      -hits => \\@hits);\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n\t\t\t       -file   => 'result.hmmer');\n    while( my $result = $in->next_result ) {\n\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is a specialization of L<Bio::Search::Result::GenericResult>.\nThere are a few extra methods, specifically L<sequence_file>,\nL<hmm_name>, L<next_models>, and L<models>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::HMMERResult;\nuse strict;\n\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::HMMERResult->new();\n Function: Builds a new Bio::Search::Result::HMMERResult object \n Returns : Bio::Search::Result::HMMERResult\n Args    : -hmm_name => string, name of hmm file\n           -sequence_file => name of the sequence file\n\nplus Bio::Search::Result::GenericResult parameters\n\n           -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version => version of the algorithm (2.1.2)\n           -program_reference => literature reference string for this algorithm\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($hmm,$seqfile) = $self->_rearrange([qw(HMM_NAME SEQUENCE_FILE)],\n\t\t\t\t\t @args);\n  \n  defined( $seqfile) && $self->sequence_file($seqfile);\n  defined( $hmm) && $self->hmm_name($hmm);\n\n  return $self;\n}\n\n\n=head2 hmm_name\n\n Title   : hmm_name\n Usage   : $obj->hmm_name($newval)\n Function: Get/Set the value of hmm_name\n Returns : value of hmm_name\n Args    : newvalue (optional)\n\n\n\nsub hmm_name{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_hmm_name'} = $value;\n    }\n    return $self->{'_hmm_name'};\n}\n\n\n=head2 sequence_file\n\n Title   : sequence_file\n Usage   : $obj->sequence_file($newval)\n Function: Get/Set the value of sequence_file\n Returns : value of sequence_file\n Args    : newvalue (optional)\n\n\n\nsub sequence_file{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_sequence_file'} = $value;\n    }\n    return $self->{'_sequence_file'};\n\n}\n\n\n=head2 next_model\n\n Title   : next_model\n Usage   : my $domain = $result->next_model\n Function: Returns the next domain - this\n           is an alias for next_hit\n Returns : L<Bio::Search::Hit::HitI> object\n Args    : none\n\n\n\nsub next_model{ shift->next_hit }\n\n=head2 models\n\n Title   : models\n Usage   : my @domains = $result->models;\n Function: Returns the list of HMM models seen - this\n           is an alias for hits()\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n\n\n\nsub models{ shift->hits }\n\n=head2 Bio::Search::Result::GenericResult inherited methods\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\n=head2 Bio::Search::Result::GenericResult specific methods\n\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iteration to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"line":390,"character":9999},"start":{"line":387,"character":0}},"kind":12,"line":387,"detail":"($self)","definition":"sub","name":"rewind","containerName":"main::","children":[{"definition":"my","line":388,"kind":13,"localvar":"my","containerName":"rewind","name":"$self"},{"kind":13,"containerName":"rewind","name":"$self","line":389}]}]}