{"version":5,"vars":[{"line":148,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":175,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":175},{"line":177,"name":"$self","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":177},{"line":177,"name":"@args","kind":13,"containerName":"new"},{"line":179,"name":"$self","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":180},{"line":181,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"new","line":181},{"line":182,"kind":13,"containerName":"new","name":"$self"},{"line":182,"name":"new","containerName":"new","kind":12},{"name":"$qname","localvar":"my","kind":13,"containerName":"new","line":184,"definition":"my"},{"name":"$qacc","containerName":"new","kind":13,"line":184},{"line":184,"kind":13,"containerName":"new","name":"$qdesc"},{"line":184,"name":"$qlen","containerName":"new","kind":13},{"name":"$qgi","kind":13,"containerName":"new","line":184},{"name":"$dbname","containerName":"new","kind":13,"line":185},{"containerName":"new","kind":13,"name":"$dblet","line":185},{"line":185,"name":"$dbent","kind":13,"containerName":"new"},{"line":185,"name":"$params","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$stats","line":186},{"line":186,"name":"$hits","kind":13,"containerName":"new"},{"line":186,"kind":13,"containerName":"new","name":"$algo"},{"line":186,"containerName":"new","kind":13,"name":"$algo_v"},{"line":187,"containerName":"new","kind":13,"name":"$prog_ref"},{"kind":13,"containerName":"new","name":"$algo_r","line":187},{"line":187,"kind":13,"containerName":"new","name":"$hit_factory"},{"name":"$self","containerName":"new","kind":13,"line":187},{"containerName":"new","kind":12,"name":"_rearrange","line":187},{"line":203,"containerName":"new","kind":13,"name":"@args"},{"name":"$algo_r","kind":13,"containerName":"new","line":205},{"line":205,"name":"$prog_ref","containerName":"new","kind":13},{"line":206,"name":"$algo","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":206},{"line":206,"kind":12,"containerName":"new","name":"algorithm"},{"kind":13,"containerName":"new","name":"$algo","line":206},{"line":207,"containerName":"new","kind":13,"name":"$algo_v"},{"line":207,"containerName":"new","kind":13,"name":"$self"},{"line":207,"kind":12,"containerName":"new","name":"algorithm_version"},{"line":207,"kind":13,"containerName":"new","name":"$algo_v"},{"line":208,"kind":13,"containerName":"new","name":"$algo_r"},{"line":208,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"algorithm_reference","line":208},{"kind":13,"containerName":"new","name":"$algo_r","line":208},{"line":210,"name":"$qname","containerName":"new","kind":13},{"line":210,"name":"$self","containerName":"new","kind":13},{"name":"query_name","containerName":"new","kind":12,"line":210},{"line":210,"containerName":"new","kind":13,"name":"$qname"},{"line":211,"containerName":"new","kind":13,"name":"$qacc"},{"name":"$self","kind":13,"containerName":"new","line":211},{"line":211,"name":"query_accession","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$qacc","line":211},{"containerName":"new","kind":13,"name":"$qdesc","line":212},{"line":212,"kind":13,"containerName":"new","name":"$self"},{"line":212,"kind":12,"containerName":"new","name":"query_description"},{"line":212,"containerName":"new","kind":13,"name":"$qdesc"},{"containerName":"new","kind":13,"name":"$qlen","line":213},{"line":213,"containerName":"new","kind":13,"name":"$self"},{"line":213,"kind":12,"containerName":"new","name":"query_length"},{"containerName":"new","kind":13,"name":"$qlen","line":213},{"name":"$qgi","containerName":"new","kind":13,"line":214},{"line":214,"containerName":"new","kind":13,"name":"$self"},{"line":214,"name":"query_gi","kind":12,"containerName":"new"},{"name":"$qgi","containerName":"new","kind":13,"line":214},{"line":215,"name":"$dbname","kind":13,"containerName":"new"},{"line":215,"name":"$self","kind":13,"containerName":"new"},{"name":"database_name","containerName":"new","kind":12,"line":215},{"line":215,"kind":13,"containerName":"new","name":"$dbname"},{"line":216,"kind":13,"containerName":"new","name":"$dblet"},{"name":"$self","containerName":"new","kind":13,"line":216},{"line":216,"name":"database_letters","containerName":"new","kind":12},{"line":216,"name":"$dblet","kind":13,"containerName":"new"},{"name":"$dbent","containerName":"new","kind":13,"line":217},{"line":217,"containerName":"new","kind":13,"name":"$self"},{"line":217,"kind":12,"containerName":"new","name":"database_entries"},{"line":217,"containerName":"new","kind":13,"name":"$dbent"},{"name":"$hit_factory","containerName":"new","kind":13,"line":219},{"line":219,"name":"$self","kind":13,"containerName":"new"},{"line":219,"name":"hit_factory","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$hit_factory","line":219},{"line":221,"name":"$params","containerName":"new","kind":13},{"name":"$params","containerName":"new","kind":13,"line":222},{"name":"$self","kind":13,"containerName":"new","line":223},{"containerName":"new","kind":12,"name":"throw","line":223},{"definition":"my","line":225,"containerName":"new","localvar":"my","kind":13,"name":"$key"},{"line":225,"name":"$value","kind":13,"containerName":"new"},{"name":"$params","containerName":"new","kind":13,"line":225},{"name":"$self","containerName":"new","kind":13,"line":226},{"line":226,"name":"set_parameter","kind":12,"containerName":"new"},{"line":226,"name":"$key","kind":13,"containerName":"new"},{"line":226,"name":"$value","containerName":"new","kind":13}],"name":"new","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects","label":"new($class,@args)"},"line":174,"range":{"end":{"line":229,"character":9999},"start":{"line":174,"character":0}},"kind":12},{"line":177,"name":"SUPER","kind":12,"containerName":"new"},{"line":181,"containerName":"Search::GenericStatistics","kind":12,"name":"Bio"},{"line":182,"name":"Bio","containerName":"Tools::Run::GenericParameters","kind":12},{"line":230,"name":"%stats","containerName":null,"kind":13},{"line":231,"containerName":null,"kind":13,"name":"%stats"},{"name":"$self","kind":13,"containerName":null,"line":232},{"containerName":"main::","kind":12,"name":"throw","line":232},{"definition":"my","line":234,"localvar":"my","containerName":null,"kind":13,"name":"$key"},{"line":234,"name":"$value","kind":13,"containerName":null},{"name":"%stats","kind":13,"containerName":null,"line":234},{"containerName":null,"kind":13,"name":"%self","line":235},{"line":235,"containerName":"main::","kind":12,"name":"set_statistic"},{"line":235,"name":"$key","kind":13,"containerName":null},{"line":235,"kind":13,"containerName":null,"name":"$value"},{"kind":13,"containerName":null,"name":"%hits","line":240},{"kind":13,"containerName":null,"name":"$self","line":241},{"name":"throw","containerName":"main::","kind":12,"line":241},{"kind":13,"containerName":null,"name":"$hits","line":241},{"definition":"my","line":243,"name":"$s","localvar":"my","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%hits","line":243},{"containerName":null,"kind":13,"name":"$self","line":244},{"name":"add_hit","containerName":"main::","kind":12,"line":244},{"line":244,"kind":13,"containerName":null,"name":"$s"},{"containerName":null,"kind":13,"name":"$self","line":247},{"definition":"sub","detail":"($self,$value)","children":[{"kind":13,"localvar":"my","containerName":"algorithm","name":"$self","line":261,"definition":"my"},{"containerName":"algorithm","kind":13,"name":"$value","line":261},{"name":"$previous","localvar":"my","containerName":"algorithm","kind":13,"line":262,"definition":"my"},{"line":262,"name":"$self","kind":13,"containerName":"algorithm"},{"containerName":"algorithm","kind":13,"name":"$value","line":263},{"name":"$previous","kind":13,"containerName":"algorithm","line":263},{"name":"$value","kind":13,"containerName":"algorithm","line":264},{"line":264,"containerName":"algorithm","kind":13,"name":"$previous"},{"line":264,"kind":13,"containerName":"algorithm","name":"$value"},{"name":"$self","kind":13,"containerName":"algorithm","line":265},{"containerName":"algorithm","kind":13,"name":"$value","line":265},{"containerName":"algorithm","kind":13,"name":"$previous","line":267}],"containerName":"main::","name":"algorithm","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value","label":"algorithm($self,$value)"},"line":260,"range":{"end":{"character":9999,"line":268},"start":{"line":260,"character":0}},"kind":12},{"signature":{"label":"algorithm_version($self,$value)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"character":9999,"line":289},"start":{"line":280,"character":0}},"line":280,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"algorithm_version","children":[{"line":281,"containerName":"algorithm_version","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"algorithm_version","kind":13,"name":"$value","line":281},{"localvar":"my","containerName":"algorithm_version","kind":13,"name":"$previous","line":282,"definition":"my"},{"kind":13,"containerName":"algorithm_version","name":"$self","line":282},{"containerName":"algorithm_version","kind":13,"name":"$value","line":283},{"line":283,"containerName":"algorithm_version","kind":13,"name":"$previous"},{"line":284,"kind":13,"containerName":"algorithm_version","name":"$value"},{"name":"$previous","kind":13,"containerName":"algorithm_version","line":284},{"name":"$value","containerName":"algorithm_version","kind":13,"line":284},{"line":285,"containerName":"algorithm_version","kind":13,"name":"$self"},{"kind":13,"containerName":"algorithm_version","name":"$value","line":285},{"name":"$previous","kind":13,"containerName":"algorithm_version","line":288}]},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","localvar":"my","containerName":"next_hit","kind":13,"name":"$self","line":308},{"line":308,"name":"@args","kind":13,"containerName":"next_hit"},{"definition":"my","name":"$index","kind":13,"localvar":"my","containerName":"next_hit","line":309},{"line":309,"kind":13,"containerName":"next_hit","name":"$self"},{"kind":12,"containerName":"next_hit","name":"_nexthitindex","line":309},{"line":310,"containerName":"next_hit","kind":13,"name":"$index"},{"line":310,"name":"$self","containerName":"next_hit","kind":13}],"name":"next_hit","containerName":"main::","signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_hit($self,@args)"},"line":307,"kind":12,"range":{"start":{"line":307,"character":0},"end":{"character":9999,"line":310}}},{"definition":"my","line":312,"name":"$hit","localvar":"my","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":312},{"line":312,"name":"$index","containerName":null,"kind":13},{"line":313,"name":"%hit","containerName":null,"kind":13},{"definition":"my","name":"$factory","kind":13,"localvar":"my","containerName":null,"line":314},{"containerName":null,"kind":13,"name":"$self","line":314},{"line":314,"name":"hit_factory","kind":12,"containerName":"main::"},{"line":314,"name":"$self","kind":13,"containerName":null},{"line":314,"containerName":"main::","kind":12,"name":"throw"},{"name":"$hit","containerName":null,"kind":13,"line":315},{"line":315,"name":"$factory","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"create_object","line":315},{"line":315,"name":"$hit","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":316},{"kind":13,"containerName":null,"name":"$index","line":316},{"line":316,"name":"$hit","containerName":null,"kind":13},{"line":317,"kind":13,"containerName":null,"name":"%self"},{"line":317,"kind":12,"name":"_hashes"},{"kind":13,"containerName":null,"name":"$index","line":317},{"line":319,"kind":13,"containerName":null,"name":"$hit"},{"containerName":"main::","name":"query_name","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"query_name","line":334},{"line":334,"name":"$value","containerName":"query_name","kind":13},{"name":"$previous","localvar":"my","containerName":"query_name","kind":13,"line":335,"definition":"my"},{"line":335,"kind":13,"containerName":"query_name","name":"$self"},{"line":336,"name":"$value","containerName":"query_name","kind":13},{"line":336,"name":"$previous","containerName":"query_name","kind":13},{"name":"$value","containerName":"query_name","kind":13,"line":337},{"containerName":"query_name","kind":13,"name":"$previous","line":337},{"kind":13,"containerName":"query_name","name":"$value","line":337},{"name":"$self","containerName":"query_name","kind":13,"line":338},{"containerName":"query_name","kind":13,"name":"$value","line":338},{"name":"$previous","containerName":"query_name","kind":13,"line":340}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":333},"end":{"line":341,"character":9999}},"kind":12,"line":333,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name","label":"query_name($self,$value)"}},{"line":353,"kind":12,"range":{"end":{"character":9999,"line":361},"start":{"character":0,"line":353}},"signature":{"label":"query_accession($self,$value)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"definition":"my","line":354,"name":"$self","containerName":"query_accession","localvar":"my","kind":13},{"containerName":"query_accession","kind":13,"name":"$value","line":354},{"definition":"my","kind":13,"localvar":"my","containerName":"query_accession","name":"$previous","line":355},{"line":355,"containerName":"query_accession","kind":13,"name":"$self"},{"line":356,"containerName":"query_accession","kind":13,"name":"$value"},{"name":"$previous","containerName":"query_accession","kind":13,"line":356},{"line":357,"kind":13,"containerName":"query_accession","name":"$value"},{"line":357,"name":"$previous","containerName":"query_accession","kind":13},{"line":357,"name":"$value","containerName":"query_accession","kind":13},{"line":358,"name":"$self","containerName":"query_accession","kind":13},{"name":"$value","kind":13,"containerName":"query_accession","line":358},{"containerName":"query_accession","kind":13,"name":"$previous","line":360}],"name":"query_accession","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"range":{"start":{"line":374,"character":0},"end":{"line":382,"character":9999}},"kind":12,"line":374,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"query_gi($self,$value)"},"containerName":"main::","name":"query_gi","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"query_gi","kind":13,"line":375},{"kind":13,"containerName":"query_gi","name":"$value","line":375},{"line":376,"name":"$value","kind":13,"containerName":"query_gi"},{"line":377,"name":"$self","kind":13,"containerName":"query_gi"},{"line":377,"kind":13,"containerName":"query_gi","name":"$value"},{"line":379,"containerName":"query_gi","kind":13,"name":"$self"},{"containerName":"query_gi","kind":13,"name":"$self","line":379},{"line":379,"containerName":"query_gi","kind":12,"name":"query_name"},{"name":"$self","kind":13,"containerName":"query_gi","line":381}],"detail":"($self,$value)","definition":"sub"},{"line":395,"kind":12,"range":{"end":{"character":9999,"line":403},"start":{"line":395,"character":0}},"signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length","parameters":[{"label":"$self"},{"label":"$value"}],"label":"query_length($self,$value)"},"children":[{"line":396,"kind":13,"localvar":"my","containerName":"query_length","name":"$self","definition":"my"},{"line":396,"containerName":"query_length","kind":13,"name":"$value"},{"definition":"my","name":"$previous","containerName":"query_length","localvar":"my","kind":13,"line":397},{"kind":13,"containerName":"query_length","name":"$self","line":397},{"line":398,"kind":13,"containerName":"query_length","name":"$value"},{"containerName":"query_length","kind":13,"name":"$previous","line":398},{"name":"$value","kind":13,"containerName":"query_length","line":399},{"containerName":"query_length","kind":13,"name":"$previous","line":399},{"line":399,"kind":13,"containerName":"query_length","name":"$value"},{"name":"$self","containerName":"query_length","kind":13,"line":400},{"line":400,"name":"$value","kind":13,"containerName":"query_length"},{"kind":13,"containerName":"query_length","name":"$previous","line":402}],"name":"query_length","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":416,"kind":12,"range":{"end":{"line":424,"character":9999},"start":{"character":0,"line":416}},"signature":{"label":"query_description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description"},"children":[{"line":417,"name":"$self","containerName":"query_description","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"query_description","name":"$value","line":417},{"definition":"my","line":418,"localvar":"my","kind":13,"containerName":"query_description","name":"$previous"},{"kind":13,"containerName":"query_description","name":"$self","line":418},{"line":419,"kind":13,"containerName":"query_description","name":"$value"},{"line":419,"kind":13,"containerName":"query_description","name":"$previous"},{"line":420,"name":"$value","kind":13,"containerName":"query_description"},{"line":420,"name":"$previous","kind":13,"containerName":"query_description"},{"kind":13,"containerName":"query_description","name":"$value","line":420},{"containerName":"query_description","kind":13,"name":"$self","line":421},{"containerName":"query_description","kind":13,"name":"$value","line":421},{"name":"$previous","kind":13,"containerName":"query_description","line":423}],"name":"query_description","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name","label":"database_name($self,$value)"},"line":438,"kind":12,"range":{"start":{"line":438,"character":0},"end":{"character":9999,"line":446}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":439,"name":"$self","localvar":"my","kind":13,"containerName":"database_name"},{"containerName":"database_name","kind":13,"name":"$value","line":439},{"definition":"my","line":440,"name":"$previous","localvar":"my","containerName":"database_name","kind":13},{"line":440,"kind":13,"containerName":"database_name","name":"$self"},{"line":441,"kind":13,"containerName":"database_name","name":"$value"},{"line":441,"containerName":"database_name","kind":13,"name":"$previous"},{"kind":13,"containerName":"database_name","name":"$value","line":442},{"kind":13,"containerName":"database_name","name":"$previous","line":442},{"name":"$value","containerName":"database_name","kind":13,"line":442},{"kind":13,"containerName":"database_name","name":"$self","line":443},{"line":443,"containerName":"database_name","kind":13,"name":"$value"},{"kind":13,"containerName":"database_name","name":"$previous","line":445}],"name":"database_name","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"database_letters","children":[{"line":462,"localvar":"my","containerName":"database_letters","kind":13,"name":"$self","definition":"my"},{"line":462,"containerName":"database_letters","kind":13,"name":"$value"},{"definition":"my","line":463,"name":"$previous","localvar":"my","kind":13,"containerName":"database_letters"},{"name":"$self","containerName":"database_letters","kind":13,"line":463},{"line":464,"kind":13,"containerName":"database_letters","name":"$value"},{"name":"$previous","containerName":"database_letters","kind":13,"line":464},{"kind":13,"containerName":"database_letters","name":"$value","line":465},{"line":465,"name":"$previous","containerName":"database_letters","kind":13},{"kind":13,"containerName":"database_letters","name":"$value","line":465},{"kind":13,"containerName":"database_letters","name":"$self","line":466},{"kind":13,"containerName":"database_letters","name":"$value","line":466},{"containerName":"database_letters","kind":13,"name":"$previous","line":468}],"signature":{"label":"database_letters($self,$value)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db ","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"character":0,"line":461},"end":{"line":469,"character":9999}},"kind":12,"line":461},{"children":[{"line":484,"name":"$self","kind":13,"localvar":"my","containerName":"database_entries","definition":"my"},{"containerName":"database_entries","kind":13,"name":"$value","line":484},{"name":"$previous","localvar":"my","containerName":"database_entries","kind":13,"line":485,"definition":"my"},{"line":485,"kind":13,"containerName":"database_entries","name":"$self"},{"line":486,"kind":13,"containerName":"database_entries","name":"$value"},{"name":"$previous","containerName":"database_entries","kind":13,"line":486},{"name":"$value","kind":13,"containerName":"database_entries","line":487},{"line":487,"name":"$previous","containerName":"database_entries","kind":13},{"name":"$value","containerName":"database_entries","kind":13,"line":487},{"line":488,"kind":13,"containerName":"database_entries","name":"$self"},{"name":"$value","containerName":"database_entries","kind":13,"line":488},{"line":490,"containerName":"database_entries","kind":13,"name":"$previous"}],"containerName":"main::","name":"database_entries","definition":"sub","detail":"($self,$value)","line":483,"kind":12,"range":{"end":{"character":9999,"line":491},"start":{"line":483,"character":0}},"signature":{"label":"database_entries($self,$value)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db","parameters":[{"label":"$self"},{"label":"$value"}]}},{"signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_parameter($self,$name)"},"kind":12,"range":{"end":{"line":507,"character":9999},"start":{"character":0,"line":504}},"line":504,"detail":"($self,$name)","definition":"sub","containerName":"main::","name":"get_parameter","children":[{"line":505,"name":"$self","kind":13,"localvar":"my","containerName":"get_parameter","definition":"my"},{"containerName":"get_parameter","kind":13,"name":"$name","line":505},{"name":"$self","kind":13,"containerName":"get_parameter","line":506},{"containerName":"get_parameter","kind":12,"name":"get_parameter","line":506},{"containerName":"get_parameter","kind":13,"name":"$name","line":506}]},{"line":519,"range":{"end":{"character":9999,"line":522},"start":{"line":519,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none","label":"available_parameters($self)"},"children":[{"definition":"my","line":520,"name":"$self","localvar":"my","kind":13,"containerName":"available_parameters"},{"containerName":"available_parameters","kind":13,"name":"$self","line":521},{"line":521,"name":"available_parameters","kind":12,"containerName":"available_parameters"}],"name":"available_parameters","containerName":"main::","definition":"sub","detail":"($self)"},{"detail":"($self,$key)","definition":"sub","name":"get_statistic","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"get_statistic","name":"$self","line":537,"definition":"my"},{"name":"$key","containerName":"get_statistic","kind":13,"line":537},{"kind":13,"containerName":"get_statistic","name":"$self","line":538},{"name":"get_statistic","containerName":"get_statistic","kind":12,"line":538},{"line":538,"name":"$key","kind":13,"containerName":"get_statistic"}],"signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)","parameters":[{"label":"$self"},{"label":"$key"}],"label":"get_statistic($self,$key)"},"range":{"end":{"character":9999,"line":539},"start":{"character":0,"line":536}},"kind":12,"line":536},{"detail":"($self)","definition":"sub","containerName":"main::","name":"available_statistics","children":[{"line":552,"localvar":"my","kind":13,"containerName":"available_statistics","name":"$self","definition":"my"},{"name":"$self","containerName":"available_statistics","kind":13,"line":553},{"line":553,"name":"available_statistics","containerName":"available_statistics","kind":12}],"signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none","parameters":[{"label":"$self"}],"label":"available_statistics($self)"},"range":{"start":{"line":551,"character":0},"end":{"line":554,"character":9999}},"kind":12,"line":551},{"name":"add_hit","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"add_hit","name":"$self","line":571,"definition":"my"},{"kind":13,"containerName":"add_hit","name":"$s","line":571},{"line":572,"kind":13,"containerName":"add_hit","name":"$s"},{"line":572,"kind":13,"containerName":"add_hit","name":"$s"},{"line":572,"name":"isa","containerName":"add_hit","kind":12},{"line":573,"name":"$self","containerName":"add_hit","kind":13},{"line":573,"containerName":"add_hit","kind":13,"name":"$s"}],"detail":"($self,$s)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":570},"end":{"character":9999,"line":574}},"line":570,"signature":{"label":"add_hit($self,$s)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI","parameters":[{"label":"$self"},{"label":"$s"}]}},{"containerName":null,"kind":13,"name":"$self","line":576},{"kind":12,"containerName":"main::","name":"throw","line":576},{"line":576,"name":"$s","containerName":null,"kind":13},{"name":"%s","containerName":null,"kind":13,"line":579},{"containerName":null,"kind":13,"name":"%self","line":580},{"name":"_hashes","kind":12,"line":580},{"name":"%self","containerName":null,"kind":13,"line":580},{"containerName":null,"kind":13,"name":"%self","line":582},{"definition":"sub","containerName":"main::","name":"hit_factory","children":[{"definition":"my","line":596,"containerName":"hit_factory","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"hit_factory","kind":13,"line":597},{"name":"$self","containerName":"hit_factory","kind":13,"line":598}],"kind":12,"range":{"end":{"line":599,"character":9999},"start":{"line":595,"character":0}},"line":595},{"line":597,"kind":12,"name":"_hit_factory"},{"name":"_hit_factory","kind":12,"line":598},{"signature":{"label":"rewind($self)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"line":615,"character":9999},"start":{"line":612,"character":0}},"kind":12,"line":612,"detail":"($self)","definition":"sub","containerName":"main::","name":"rewind","children":[{"definition":"my","containerName":"rewind","localvar":"my","kind":13,"name":"$self","line":613},{"line":614,"containerName":"rewind","kind":13,"name":"$self"}]},{"signature":{"label":"_nexthitindex($self,@args)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private","parameters":[{"label":"$self"},{"label":"@args"}]},"line":625,"kind":12,"range":{"start":{"character":0,"line":625},"end":{"line":628,"character":9999}},"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","containerName":"_nexthitindex","localvar":"my","kind":13,"line":626},{"kind":13,"containerName":"_nexthitindex","name":"@args","line":626},{"line":627,"containerName":"_nexthitindex","kind":13,"name":"$self"}],"containerName":"main::","name":"_nexthitindex"},{"name":"add_parameter","containerName":"main::","children":[{"line":643,"kind":13,"localvar":"my","containerName":"add_parameter","name":"$self","definition":"my"},{"line":643,"kind":13,"containerName":"add_parameter","name":"$key"},{"line":643,"containerName":"add_parameter","kind":13,"name":"$value"},{"line":644,"name":"$self","kind":13,"containerName":"add_parameter"},{"name":"set_parameter","kind":12,"containerName":"add_parameter","line":644},{"kind":13,"containerName":"add_parameter","name":"$key","line":644},{"kind":13,"containerName":"add_parameter","name":"$value","line":644}],"detail":"($self,$key,$value)","definition":"sub","kind":12,"range":{"end":{"line":645,"character":9999},"start":{"character":0,"line":642}},"line":642,"signature":{"label":"add_parameter($self,$key,$value)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter"}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_statistic","line":660,"definition":"my"},{"line":660,"kind":13,"containerName":"add_statistic","name":"$key"},{"line":660,"containerName":"add_statistic","kind":13,"name":"$value"},{"kind":13,"containerName":"add_statistic","name":"$self","line":661},{"line":661,"kind":12,"containerName":"add_statistic","name":"set_statistic"},{"name":"$key","kind":13,"containerName":"add_statistic","line":661},{"name":"$value","kind":13,"containerName":"add_statistic","line":661}],"name":"add_statistic","containerName":"main::","definition":"sub","detail":"($self,$key,$value)","line":659,"kind":12,"range":{"start":{"line":659,"character":0},"end":{"character":9999,"line":663}},"signature":{"label":"add_statistic($self,$key,$value)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n   my ($self,$key,$value) = @_;\n   $self->{'_parameters'}->set_parameter($key => $value);\n}\n\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $report->add_statistic('lambda', 2.3);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter"}},{"definition":"sub","name":"num_hits","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"num_hits","name":"$self","line":677,"definition":"my"},{"line":678,"name":"$self","kind":13,"containerName":"num_hits"},{"name":"$self","kind":13,"containerName":"num_hits","line":679},{"kind":12,"containerName":"num_hits","name":"throw","line":679},{"line":681,"name":"$self","containerName":"num_hits","kind":13}],"kind":12,"range":{"start":{"character":0,"line":676},"end":{"character":9999,"line":681}},"line":676},{"line":696,"range":{"end":{"character":9999,"line":699},"start":{"character":0,"line":696}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"hits","name":"$self","line":697},{"line":699,"containerName":"hits","localvar":"my","kind":13,"name":"$i","definition":"my"},{"line":699,"containerName":"hits","kind":13,"name":"$self"}],"name":"hits","containerName":"main::"},{"name":"_hashes","kind":12,"line":699},{"line":700,"containerName":null,"localvar":"my","kind":13,"name":"$factory","definition":"my"},{"line":700,"name":"$self","kind":13,"containerName":null},{"name":"hit_factory","kind":12,"containerName":"main::","line":700},{"name":"$self","containerName":null,"kind":13,"line":700},{"kind":12,"containerName":"main::","name":"throw","line":700},{"line":701,"name":"%self","kind":13,"containerName":null},{"line":701,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$factory","line":701},{"line":701,"kind":12,"containerName":"main::","name":"create_object"},{"name":"%self","kind":13,"containerName":null,"line":701},{"line":701,"containerName":null,"kind":13,"name":"$i"},{"line":702,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"_hashes","line":702},{"line":702,"kind":13,"containerName":null,"name":"$i"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@hits","line":705},{"name":"%self","containerName":null,"kind":13,"line":706},{"kind":13,"containerName":null,"name":"@hits","line":707},{"line":707,"name":"%self","containerName":null,"kind":13},{"name":"@hits","kind":13,"containerName":null,"line":709},{"kind":12,"range":{"end":{"character":9999,"line":730},"start":{"character":0,"line":724}},"line":724,"signature":{"label":"algorithm_reference($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n   my ($self,$key,$value) = @_;\n   $self->{'_parameters'}->set_parameter($key => $value);\n}\n\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $report->add_statistic('lambda', 2.3);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_statistic {\n   my ($self,$key,$value) = @_;\n   $self->{'_statistics'}->set_statistic($key => $value);\n   return;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits{\n   my ($self) = shift;\n   if (not defined $self->{'_hits'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar(@{$self->{'_hits'}});\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n\n\n\nsub hits {\n    my ($self) = shift;\n    \n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $self->{'_hits'}->[$i] = $factory->create_object(%{$self->{'_hits'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    my @hits = ();\n    if (ref $self->{'_hits'}) {\n        @hits = @{$self->{'_hits'}};\n    }\n    return @hits;   \n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : string containing literature reference for the algorithm\n Args    : newvalue string (optional)\n Comments: Formerly named program_reference(), which is still supported\n           for backwards compatibility."},"containerName":"main::","name":"algorithm_reference","children":[{"definition":"my","line":725,"name":"$self","localvar":"my","kind":13,"containerName":"algorithm_reference"},{"kind":13,"containerName":"algorithm_reference","name":"$value","line":725},{"line":726,"name":"$value","kind":13,"containerName":"algorithm_reference"},{"name":"$self","kind":13,"containerName":"algorithm_reference","line":727},{"line":727,"name":"$value","kind":13,"containerName":"algorithm_reference"},{"name":"$self","containerName":"algorithm_reference","kind":13,"line":729}],"detail":"($self,$value)","definition":"sub"},{"range":{"start":{"character":0,"line":743},"end":{"line":743,"character":9999}},"kind":12,"line":743,"definition":"sub","name":"program_reference","containerName":"main::","children":[{"line":743,"kind":12,"containerName":"program_reference","name":"algorithm_reference"}]},{"line":752,"kind":12,"range":{"end":{"line":760,"character":9999},"start":{"character":0,"line":752}},"definition":"sub","children":[{"definition":"my","line":753,"name":"$self","containerName":"no_hits_found","localvar":"my","kind":13},{"line":759,"containerName":"no_hits_found","kind":13,"name":"$self"}],"containerName":"main::","name":"no_hits_found"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"set_no_hits_found","line":770},{"line":771,"kind":13,"containerName":"set_no_hits_found","name":"$self"}],"name":"set_no_hits_found","containerName":"main::","definition":"sub","line":769,"range":{"end":{"line":772,"character":9999},"start":{"character":0,"line":769}},"kind":12},{"range":{"end":{"line":794,"character":9999},"start":{"character":0,"line":790}},"kind":12,"line":790,"definition":"sub","name":"to_string","containerName":"main::","children":[{"localvar":"my","containerName":"to_string","kind":13,"name":"$self","line":791,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"to_string","name":"$str","line":792},{"line":792,"name":"$self","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":792},{"kind":12,"containerName":"to_string","name":"algorithm","line":792},{"kind":13,"containerName":"to_string","name":"$self","line":792},{"kind":12,"containerName":"to_string","name":"query_name","line":792},{"line":792,"name":"$self","kind":13,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"query_description","line":792},{"line":792,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","kind":12,"name":"database_name","line":792},{"line":793,"containerName":"to_string","kind":13,"name":"$str"}]}]}