{"version":5,"vars":[{"line":101,"name":"base","kind":2,"containerName":""},{"line":117,"kind":12,"range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":117}},"signature":{"label":"new($class,@args)","documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)","parameters":[{"label":"$class"},{"label":"@args"}]},"children":[{"definition":"my","line":118,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":118},{"line":120,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":120},{"line":120,"name":"@args","kind":13,"containerName":"new"},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":123},{"name":"$self","containerName":"new","kind":13,"line":124},{"definition":"my","name":"$iters","localvar":"my","containerName":"new","kind":13,"line":126},{"name":"$ithresh","containerName":"new","kind":13,"line":126},{"containerName":"new","kind":13,"name":"$self","line":126},{"line":126,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":127},{"name":"$self","kind":13,"containerName":"new","line":129},{"line":129,"name":"$ithresh","containerName":"new","kind":13},{"name":"$iters","containerName":"new","kind":13,"line":131},{"name":"$self","kind":13,"containerName":"new","line":132},{"name":"throw","kind":12,"containerName":"new","line":132},{"line":132,"kind":13,"containerName":"new","name":"$iters"},{"line":134,"name":"$i","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$iters","line":134},{"name":"$self","kind":13,"containerName":"new","line":135},{"containerName":"new","kind":12,"name":"add_iteration","line":135},{"name":"$i","containerName":"new","kind":13,"line":135}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":120},{"name":"%self","kind":13,"containerName":null,"line":141},{"line":145,"name":"$self","kind":13,"containerName":null},{"children":[{"definition":"my","line":162,"name":"$self","localvar":"my","containerName":"hits","kind":13},{"line":163,"name":"$self","kind":13,"containerName":"hits"},{"line":164,"name":"$self","containerName":"hits","kind":13},{"line":166,"localvar":"my","kind":13,"containerName":"hits","name":"@hits","definition":"my"},{"definition":"my","name":"$it","localvar":"my","kind":13,"containerName":"hits","line":167},{"name":"$self","kind":13,"containerName":"hits","line":167},{"line":167,"name":"iterations","containerName":"hits","kind":12},{"name":"@hits","containerName":"hits","kind":13,"line":168},{"line":168,"kind":13,"containerName":"hits","name":"$it"},{"line":168,"kind":12,"containerName":"hits","name":"hits"},{"containerName":"hits","kind":13,"name":"@hits","line":170}],"name":"hits","containerName":"main::","definition":"sub","line":161,"kind":12,"range":{"end":{"line":171,"character":9999},"start":{"line":161,"character":0}}},{"containerName":"hits","kind":12,"name":"SUPER","line":166},{"definition":"sub","detail":"($self,@args)","children":[{"line":186,"kind":13,"localvar":"my","containerName":"next_hit","name":"$self","definition":"my"},{"line":186,"containerName":"next_hit","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"next_hit","line":187},{"line":188,"name":"$self","kind":13,"containerName":"next_hit"},{"name":"@args","containerName":"next_hit","kind":13,"line":188},{"definition":"my","line":191,"kind":13,"localvar":"my","containerName":"next_hit","name":"$iter_index"},{"kind":13,"containerName":"next_hit","name":"$self","line":192},{"containerName":"next_hit","kind":13,"name":"$iter_index","line":193},{"line":193,"name":"$self","containerName":"next_hit","kind":13},{"name":"$self","containerName":"next_hit","kind":13,"line":193},{"containerName":"next_hit","kind":12,"name":"_next_iteration_index","line":193},{"name":"$iter_index","kind":13,"containerName":"next_hit","line":195},{"kind":13,"containerName":"next_hit","name":"$self","line":195},{"line":198,"name":"$iter_index","containerName":"next_hit","kind":13},{"name":"$self","containerName":"next_hit","kind":13,"line":198}],"name":"next_hit","containerName":"main::","signature":{"label":"next_hit($self,@args)","documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>","parameters":[{"label":"$self"},{"label":"@args"}]},"line":185,"kind":12,"range":{"start":{"character":0,"line":185},"end":{"character":9999,"line":198}}},{"name":"SUPER","containerName":"next_hit","kind":12,"line":188},{"localvar":"my","containerName":null,"kind":13,"name":"$it","line":200,"definition":"my"},{"line":200,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"$iter_index","line":200},{"definition":"my","line":201,"name":"$hit","containerName":null,"localvar":"my","kind":13},{"line":201,"containerName":null,"kind":13,"name":"%self"},{"line":201,"name":"$it","kind":13,"containerName":null},{"name":"next_hit","kind":12,"containerName":"main::","line":201},{"line":203,"name":"$hit","kind":13,"containerName":null},{"line":203,"name":"$hit","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$self","line":203},{"line":203,"kind":12,"containerName":"main::","name":"next_hit"},{"definition":"sub","containerName":"main::","name":"num_hits","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"num_hits","line":221,"definition":"my"},{"line":222,"containerName":"num_hits","kind":13,"name":"$self"},{"line":223,"name":"$self","kind":13,"containerName":"num_hits"},{"line":225,"name":"$self","containerName":"num_hits","kind":13},{"name":"$self","kind":13,"containerName":"num_hits","line":226},{"line":226,"containerName":"num_hits","kind":12,"name":"throw"},{"line":228,"kind":13,"containerName":"num_hits","name":"$self"},{"kind":12,"containerName":"num_hits","name":"hits","line":228}],"range":{"end":{"character":9999,"line":229},"start":{"line":220,"character":0}},"kind":12,"line":220},{"kind":12,"containerName":"num_hits","name":"SUPER","line":225},{"detail":"($self,$i)","definition":"sub","name":"add_iteration","containerName":"main::","children":[{"line":242,"name":"$self","containerName":"add_iteration","localvar":"my","kind":13,"definition":"my"},{"line":242,"name":"$i","kind":13,"containerName":"add_iteration"},{"name":"$i","kind":13,"containerName":"add_iteration","line":243},{"line":243,"name":"isa","kind":12,"containerName":"add_iteration"},{"line":244,"kind":13,"containerName":"add_iteration","name":"$self"},{"line":244,"name":"$i","kind":13,"containerName":"add_iteration"},{"containerName":"add_iteration","kind":13,"name":"$self","line":245}],"signature":{"label":"add_iteration($self,$i)","documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI","parameters":[{"label":"$self"},{"label":"$i"}]},"range":{"start":{"line":241,"character":0},"end":{"character":9999,"line":246}},"kind":12,"line":241},{"containerName":null,"kind":13,"name":"$self","line":247},{"line":247,"name":"throw","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$i","line":247},{"line":250,"name":"%self","containerName":null,"kind":13},{"signature":{"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none","parameters":[{"label":"$self"}],"label":"next_iteration($self)"},"range":{"end":{"character":9999,"line":272},"start":{"line":265,"character":0}},"kind":12,"line":265,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_iteration","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_iteration","line":266,"definition":"my"},{"line":268,"name":"$self","kind":13,"containerName":"next_iteration"},{"name":"$self","kind":13,"containerName":"next_iteration","line":269},{"containerName":"next_iteration","kind":13,"name":"$self","line":269},{"containerName":"next_iteration","kind":12,"name":"iterations","line":269},{"line":270,"kind":13,"containerName":"next_iteration","name":"$self"},{"line":272,"containerName":"next_iteration","kind":13,"name":"$self"}]},{"children":[{"definition":"my","line":289,"name":"$self","containerName":"iteration","localvar":"my","kind":13},{"line":289,"containerName":"iteration","kind":13,"name":"$num"},{"name":"$num","kind":13,"containerName":"iteration","line":290},{"line":290,"name":"$self","kind":13,"containerName":"iteration"}],"name":"iteration","containerName":"main::","definition":"sub","detail":"($self,$num)","line":288,"kind":12,"range":{"end":{"character":9999,"line":290},"start":{"character":0,"line":288}},"signature":{"label":"iteration($self,$num)","documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1","parameters":[{"label":"$self"},{"label":"$num"}]}},{"name":"$num","kind":13,"containerName":null,"line":290},{"line":291,"containerName":null,"kind":13,"name":"$num"},{"line":291,"name":"$num","containerName":null,"kind":13},{"line":291,"containerName":null,"kind":13,"name":"%self"},{"name":"$self","containerName":null,"kind":13,"line":292},{"line":292,"name":"throw","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$num","line":294},{"name":"%self","kind":13,"containerName":null,"line":296},{"line":296,"kind":13,"containerName":null,"name":"$num"},{"children":[],"name":"num_iterations","containerName":"main::","definition":"sub","line":308,"range":{"end":{"character":9999,"line":308},"start":{"character":0,"line":308}},"kind":12},{"children":[{"line":319,"name":"num_iterations","containerName":"number_of_iterations","kind":12}],"containerName":"main::","name":"number_of_iterations","definition":"sub","line":319,"range":{"start":{"line":319,"character":0},"end":{"character":9999,"line":319}},"kind":12},{"line":327,"kind":12,"range":{"start":{"character":0,"line":327},"end":{"line":327,"character":9999}},"definition":"sub","children":[{"name":"iteration","containerName":"round","kind":12,"line":327}],"name":"round","containerName":"main::"},{"range":{"end":{"character":9999,"line":345},"start":{"character":0,"line":340}},"kind":12,"line":340,"definition":"sub","containerName":"main::","name":"iterations","children":[{"line":341,"localvar":"my","kind":13,"containerName":"iterations","name":"$self","definition":"my"},{"line":342,"name":"@its","localvar":"my","containerName":"iterations","kind":13,"definition":"my"},{"line":343,"containerName":"iterations","kind":13,"name":"$self"},{"line":344,"name":"@its","kind":13,"containerName":"iterations"},{"name":"$self","containerName":"iterations","kind":13,"line":344}]},{"line":346,"name":"@its","containerName":null,"kind":13},{"kind":12,"range":{"start":{"line":370,"character":0},"end":{"character":9999,"line":399}},"line":370,"signature":{"parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found.","label":"no_hits_found($self,$round)"},"containerName":"main::","name":"no_hits_found","children":[{"definition":"my","line":371,"localvar":"my","containerName":"no_hits_found","kind":13,"name":"$self"},{"line":371,"name":"$round","containerName":"no_hits_found","kind":13},{"definition":"my","line":373,"name":"$result","kind":13,"localvar":"my","containerName":"no_hits_found"},{"kind":13,"containerName":"no_hits_found","name":"$round","line":380},{"name":"$self","containerName":"no_hits_found","kind":13,"line":381},{"name":"$result","containerName":"no_hits_found","kind":13,"line":382},{"definition":"my","name":"$i","localvar":"my","containerName":"no_hits_found","kind":13,"line":383},{"kind":13,"containerName":"no_hits_found","name":"$self","line":383},{"line":384,"name":"$self","kind":13,"containerName":"no_hits_found"},{"name":"$result","kind":13,"containerName":"no_hits_found","line":385},{"name":"$result","kind":13,"containerName":"no_hits_found","line":391},{"line":391,"containerName":"no_hits_found","kind":13,"name":"$self"},{"line":395,"name":"$result","kind":13,"containerName":"no_hits_found"},{"line":395,"name":"$self","containerName":"no_hits_found","kind":13},{"line":398,"name":"$result","kind":13,"containerName":"no_hits_found"}],"detail":"($self,$round)","definition":"sub"},{"kind":12,"range":{"start":{"line":412,"character":0},"end":{"character":9999,"line":416}},"line":412,"signature":{"parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (CrossMatch)","label":"set_no_hits_found($self,$round)"},"containerName":"main::","name":"set_no_hits_found","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"set_no_hits_found","line":413,"definition":"my"},{"line":413,"name":"$round","containerName":"set_no_hits_found","kind":13},{"line":414,"containerName":"set_no_hits_found","kind":13,"name":"$round"},{"name":"$self","containerName":"set_no_hits_found","kind":13,"line":415}],"detail":"($self,$round)","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":428},"start":{"line":425,"character":0}},"line":425,"signature":{"documentation":"#$Header$\npackage Bio::Search::Result::CrossMatchResult;\n# $Id: CrossMatchResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::CrossMatchResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::CrossMatchResult - CrossMatch-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       CrossMatchResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::CrossMatchResult;\nuse strict;\n\nuse Bio::Search::Result::GenericResult;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::CrossMatchResult->new();\n Function: Builds a new Bio::Search::Result::CrossMatchResult object\n Returns : Bio::Search::Result::CrossMatchResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to CrossMatchResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     CrossMatch score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      #print STDERR \"CrossMatchResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  #$self->SUPER::algorithm('cross_match');\n  return $self;\n}\n\n\n=head2 hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, all 'new' hits for all iterations are returned.\nThese are the hits that did not occur in a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\nThis method overrides L<Bio::Search::Result::GenericResult::next_hit> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling next_hit() traverses the\nall of the hits, old and new, for each iteration, calling next_hit() on each iteration. \n\nSee Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\nThis method overrides L<Bio::Search::Result::GenericResult::num_hits> to take \ninto account the possibility of multiple iterations, as occurs in CrossMatch reports.\n\nIf there are multiple iterations, calling num_hits() returns the number of\n'new' hits for each iteration. These are the hits that did not occur\nin a previous iteration.\n\nSee Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given CrossMatch iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (CrossMatch).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (CrossMatch).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\nSame as L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\nSame as L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n             If iteration number is not specified and this is a CrossMatch result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (CrossMatch)\n\n\nsub set_no_hits_found {\n    my ($self, $round) = @_;\n    $round ||= 1;\n    $self->{\"_iteration_$round\"}->{'_no_hits_found'} = 1;\n}\n\n=head2 _next_iteration_index\n\n Title   : _next_iteration_index\n Usage   : private","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_next_iteration_index($self,@args)"},"name":"_next_iteration_index","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_next_iteration_index","localvar":"my","kind":13,"line":426},{"containerName":"_next_iteration_index","kind":13,"name":"@args","line":426},{"containerName":"_next_iteration_index","kind":13,"name":"$self","line":427}],"detail":"($self,@args)","definition":"sub"},{"children":[{"definition":"my","localvar":"my","containerName":"rewind","kind":13,"name":"$self","line":443},{"line":444,"name":"$self","kind":13,"containerName":"rewind"},{"kind":13,"containerName":"rewind","name":"$self","line":445},{"name":"$self","kind":13,"containerName":"rewind","line":446},{"kind":12,"containerName":"rewind","name":"iterations","line":446},{"line":447,"name":"rewind","containerName":"rewind","kind":12}],"containerName":"main::","name":"rewind","definition":"sub","line":442,"kind":12,"range":{"start":{"character":0,"line":442},"end":{"character":9999,"line":449}}},{"line":444,"name":"SUPER","kind":12,"containerName":"rewind"},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"inclusion_threshold","kind":13,"line":465},{"line":466,"name":"$self","kind":13,"containerName":"inclusion_threshold"}],"containerName":"main::","name":"inclusion_threshold","line":464,"kind":12,"range":{"start":{"character":0,"line":464},"end":{"character":9999,"line":467}}},{"name":"algorithm_old","containerName":"main::","children":[{"line":471,"containerName":"algorithm_old","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"localvar":"my","containerName":"algorithm_old","line":472,"definition":"my"},{"line":473,"name":"$value","containerName":"algorithm_old","kind":13},{"name":"$self","kind":13,"containerName":"algorithm_old","line":475},{"name":"$self","containerName":"algorithm_old","kind":13,"line":477}],"definition":"sub","range":{"end":{"character":9999,"line":479},"start":{"character":0,"line":470}},"kind":12,"line":470},{"line":477,"name":"SUPER","kind":12,"containerName":"algorithm"}]}