{"version":5,"vars":[{"line":108,"name":"base","containerName":"","kind":2},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":145,"definition":"my"},{"line":145,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":147,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":147},{"name":"@args","containerName":"new","kind":13,"line":147},{"line":148,"name":"$number","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":148,"name":"$newhits_unclassified","kind":13,"containerName":"new"},{"line":148,"name":"$newhits_below","containerName":"new","kind":13},{"line":148,"kind":13,"containerName":"new","name":"$newhits_not_below"},{"line":149,"containerName":"new","kind":13,"name":"$oldhits_below"},{"line":149,"containerName":"new","kind":13,"name":"$oldhits_newly_below"},{"name":"$oldhits_not_below","kind":13,"containerName":"new","line":149},{"containerName":"new","kind":13,"name":"$converged","line":149},{"line":150,"containerName":"new","kind":13,"name":"$h_f"},{"containerName":"new","kind":13,"name":"$self","line":151},{"line":151,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","containerName":"new","kind":13,"line":160},{"containerName":"new","kind":13,"name":"$number","line":162},{"line":163,"name":"$self","containerName":"new","kind":13},{"line":163,"containerName":"new","kind":12,"name":"throw"},{"line":166,"name":"$self","containerName":"new","kind":13},{"line":166,"containerName":"new","kind":12,"name":"number"},{"containerName":"new","kind":13,"name":"$number","line":166},{"line":169,"containerName":"new","kind":13,"name":"$converged"},{"line":169,"name":"$self","kind":13,"containerName":"new"},{"line":169,"containerName":"new","kind":12,"name":"converged"},{"line":169,"containerName":"new","kind":13,"name":"$converged"},{"line":176,"name":"$newhits_unclassified","kind":13,"containerName":"new"},{"line":177,"containerName":"new","kind":13,"name":"$newhits_unclassified"},{"line":178,"kind":13,"containerName":"new","name":"$self"},{"line":178,"kind":13,"containerName":"new","name":"$newhits_unclassified"}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects"},"kind":12,"range":{"start":{"character":0,"line":144},"end":{"character":9999,"line":179}},"line":144},{"line":147,"name":"SUPER","kind":12,"containerName":"new"},{"name":"$self","kind":13,"containerName":null,"line":180},{"line":180,"name":"throw","containerName":"main::","kind":12},{"line":184,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"%newhits_below","line":187},{"line":188,"name":"%newhits_below","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":189},{"line":189,"name":"%newhits_below","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":191},{"line":191,"name":"throw","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"%self","line":195},{"name":"%newhits_not_below","containerName":null,"kind":13,"line":198},{"line":199,"kind":13,"containerName":null,"name":"%newhits_not_below"},{"name":"%self","kind":13,"containerName":null,"line":200},{"line":200,"containerName":null,"kind":13,"name":"%newhits_not_below"},{"line":202,"name":"$self","kind":13,"containerName":null},{"line":202,"kind":12,"containerName":"main::","name":"throw"},{"name":"%self","containerName":null,"kind":13,"line":206},{"line":209,"name":"%oldhits_below","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%oldhits_below","line":210},{"name":"%self","containerName":null,"kind":13,"line":211},{"line":211,"name":"%oldhits_below","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":213},{"line":213,"name":"throw","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"%self","line":217},{"name":"%oldhits_newly_below","kind":13,"containerName":null,"line":220},{"name":"%oldhits_newly_below","containerName":null,"kind":13,"line":221},{"name":"%self","containerName":null,"kind":13,"line":222},{"name":"%oldhits_newly_below","containerName":null,"kind":13,"line":222},{"line":224,"name":"$self","kind":13,"containerName":null},{"line":224,"name":"throw","containerName":"main::","kind":12},{"line":228,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%oldhits_not_below","line":231},{"name":"%oldhits_not_below","kind":13,"containerName":null,"line":232},{"line":233,"name":"%self","kind":13,"containerName":null},{"line":233,"kind":13,"containerName":null,"name":"%oldhits_not_below"},{"line":235,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"throw","line":235},{"line":239,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"$self","line":242},{"kind":12,"containerName":"main::","name":"hit_factory","line":242},{"line":242,"name":"$h_f","containerName":null,"kind":13},{"line":242,"name":"$h_f","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":244},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"number","children":[{"line":255,"name":"$self","localvar":"my","containerName":"number","kind":13,"definition":"my"},{"name":"$value","containerName":"number","kind":13,"line":255},{"line":256,"name":"$previous","localvar":"my","containerName":"number","kind":13,"definition":"my"},{"line":256,"containerName":"number","kind":13,"name":"$self"},{"line":257,"containerName":"number","kind":13,"name":"$value"},{"containerName":"number","kind":13,"name":"$previous","line":257},{"name":"$value","kind":13,"containerName":"number","line":258},{"line":258,"containerName":"number","kind":13,"name":"$previous"},{"name":"$value","containerName":"number","kind":13,"line":258},{"line":259,"kind":13,"containerName":"number","name":"$self"},{"line":259,"containerName":"number","kind":13,"name":"$value"},{"line":261,"name":"$previous","kind":13,"containerName":"number"}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.","label":"number($self,$value)"},"kind":12,"range":{"end":{"character":9999,"line":262},"start":{"line":254,"character":0}},"line":254},{"kind":12,"range":{"start":{"line":270,"character":0},"end":{"line":278,"character":9999}},"line":270,"signature":{"label":"converged($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI."},"containerName":"main::","name":"converged","children":[{"definition":"my","name":"$self","containerName":"converged","localvar":"my","kind":13,"line":271},{"line":271,"name":"$value","containerName":"converged","kind":13},{"line":272,"name":"$previous","localvar":"my","kind":13,"containerName":"converged","definition":"my"},{"name":"$self","containerName":"converged","kind":13,"line":272},{"kind":13,"containerName":"converged","name":"$value","line":273},{"kind":13,"containerName":"converged","name":"$previous","line":273},{"line":274,"containerName":"converged","kind":13,"name":"$value"},{"line":274,"kind":13,"containerName":"converged","name":"$previous"},{"line":274,"kind":13,"containerName":"converged","name":"$value"},{"line":275,"containerName":"converged","kind":13,"name":"$self"},{"line":275,"kind":13,"containerName":"converged","name":"$value"},{"name":"$previous","kind":13,"containerName":"converged","line":277}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":295}},"line":291,"definition":"sub","containerName":"main::","name":"hit_factory","children":[{"definition":"my","line":292,"name":"$self","localvar":"my","containerName":"hit_factory","kind":13},{"kind":13,"containerName":"hit_factory","name":"$self","line":293},{"kind":13,"containerName":"hit_factory","name":"$self","line":294}]},{"kind":12,"name":"_hit_factory","line":293},{"line":294,"kind":12,"name":"_hit_factory"},{"kind":12,"range":{"end":{"character":9999,"line":313},"start":{"line":306,"character":0}},"line":306,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.","label":"next_hit($self)"},"name":"next_hit","containerName":"main::","children":[{"definition":"my","line":307,"name":"$self","localvar":"my","kind":13,"containerName":"next_hit"},{"name":"$self","kind":13,"containerName":"next_hit","line":309},{"containerName":"next_hit","kind":13,"name":"$self","line":310},{"name":"$self","kind":13,"containerName":"next_hit","line":310},{"line":310,"containerName":"next_hit","kind":12,"name":"oldhits"},{"name":"$self","kind":13,"containerName":"next_hit","line":310},{"line":310,"name":"newhits","containerName":"next_hit","kind":12},{"line":311,"name":"$self","containerName":"next_hit","kind":13},{"line":313,"name":"$self","containerName":"next_hit","kind":13}],"detail":"($self)","definition":"sub"},{"signature":{"label":"next_hit_new($self)","documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.","parameters":[{"label":"$self"}]},"line":322,"kind":12,"range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":322}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":323,"localvar":"my","containerName":"next_hit_new","kind":13,"name":"$self"},{"line":325,"kind":13,"containerName":"next_hit_new","name":"$self"},{"containerName":"next_hit_new","kind":13,"name":"$self","line":326},{"kind":13,"containerName":"next_hit_new","name":"$self","line":326},{"line":326,"kind":12,"containerName":"next_hit_new","name":"newhits"},{"line":327,"containerName":"next_hit_new","kind":13,"name":"$self"},{"line":329,"kind":13,"containerName":"next_hit_new","name":"$self"}],"name":"next_hit_new","containerName":"main::"},{"range":{"start":{"character":0,"line":338},"end":{"character":9999,"line":345}},"kind":12,"line":338,"signature":{"parameters":[{"label":"$self"},{"label":"$found_again"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.","label":"next_hit_old($self,$found_again)"},"containerName":"main::","name":"next_hit_old","children":[{"line":339,"containerName":"next_hit_old","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":339,"containerName":"next_hit_old","kind":13,"name":"$found_again"},{"name":"$self","kind":13,"containerName":"next_hit_old","line":341},{"kind":13,"containerName":"next_hit_old","name":"$self","line":342},{"line":342,"kind":13,"containerName":"next_hit_old","name":"$self"},{"name":"oldhits","containerName":"next_hit_old","kind":12,"line":342},{"kind":13,"containerName":"next_hit_old","name":"$self","line":343},{"line":345,"name":"$self","containerName":"next_hit_old","kind":13}],"detail":"($self,$found_again)","definition":"sub"},{"definition":"sub","children":[{"containerName":"rewind","localvar":"my","kind":13,"name":"$self","line":360,"definition":"my"},{"line":361,"kind":13,"containerName":"rewind","name":"$self"},{"containerName":"rewind","kind":13,"name":"$self","line":362},{"line":363,"kind":13,"containerName":"rewind","name":"$self"},{"line":364,"name":"$self","kind":13,"containerName":"rewind"},{"kind":12,"containerName":"rewind","name":"hits","line":364},{"line":365,"kind":12,"containerName":"rewind","name":"rewind"}],"name":"rewind","containerName":"main::","line":359,"range":{"start":{"line":359,"character":0},"end":{"character":9999,"line":367}},"kind":12},{"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"num_hits","kind":13,"line":377,"definition":"my"},{"name":"$self","kind":13,"containerName":"num_hits","line":379},{"containerName":"num_hits","kind":12,"name":"num_hits_old","line":379},{"line":379,"kind":13,"containerName":"num_hits","name":"$self"},{"line":379,"kind":12,"containerName":"num_hits","name":"num_hits_new"}],"containerName":"main::","name":"num_hits","line":376,"kind":12,"range":{"end":{"line":380,"character":9999},"start":{"character":0,"line":376}}},{"range":{"end":{"character":9999,"line":392},"start":{"line":388,"character":0}},"kind":12,"line":388,"name":"num_hits_new","containerName":"main::","children":[{"definition":"my","line":389,"localvar":"my","kind":13,"containerName":"num_hits_new","name":"$self"},{"line":391,"name":"$self","kind":13,"containerName":"num_hits_new"},{"name":"newhits","kind":12,"containerName":"num_hits_new","line":391}],"definition":"sub"},{"signature":{"label":"num_hits_old($self,$found_again)","parameters":[{"label":"$self"},{"label":"$found_again"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>."},"line":400,"kind":12,"range":{"start":{"character":0,"line":400},"end":{"line":404,"character":9999}},"definition":"sub","detail":"($self,$found_again)","children":[{"definition":"my","line":401,"localvar":"my","kind":13,"containerName":"num_hits_old","name":"$self"},{"name":"$found_again","containerName":"num_hits_old","kind":13,"line":401},{"line":403,"name":"$self","kind":13,"containerName":"num_hits_old"},{"line":403,"name":"oldhits","kind":12,"containerName":"num_hits_old"}],"name":"num_hits_old","containerName":"main::"},{"definition":"sub","detail":"($self,@args)","children":[{"kind":13,"localvar":"my","containerName":"add_hit","name":"$self","line":413,"definition":"my"},{"line":413,"name":"@args","kind":13,"containerName":"add_hit"},{"localvar":"my","containerName":"add_hit","kind":13,"name":"$hit","line":414,"definition":"my"},{"kind":13,"containerName":"add_hit","name":"$old","line":414},{"line":414,"containerName":"add_hit","kind":13,"name":"$below"},{"line":414,"containerName":"add_hit","kind":13,"name":"$newly_below"},{"line":415,"name":"$self","containerName":"add_hit","kind":13},{"kind":12,"containerName":"add_hit","name":"_rearrange","line":415},{"line":419,"name":"@args","kind":13,"containerName":"add_hit"},{"definition":"my","line":420,"localvar":"my","containerName":"add_hit","kind":13,"name":"$count"},{"kind":13,"containerName":"add_hit","name":"$hit","line":422},{"line":422,"containerName":"add_hit","kind":13,"name":"$hit"},{"line":422,"name":"isa","kind":12,"containerName":"add_hit"},{"name":"$self","kind":13,"containerName":"add_hit","line":423},{"kind":12,"containerName":"add_hit","name":"throw","line":423},{"line":424,"kind":13,"containerName":"add_hit","name":"$hit"},{"name":"$old","containerName":"add_hit","kind":13,"line":428},{"name":"$newly_below","containerName":"add_hit","kind":13,"line":429},{"kind":13,"containerName":"add_hit","name":"$self","line":430},{"line":430,"name":"$hit","containerName":"add_hit","kind":13},{"line":431,"containerName":"add_hit","kind":13,"name":"$count"},{"line":431,"kind":13,"containerName":"add_hit","name":"$self"}],"name":"add_hit","containerName":"main::","signature":{"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_old {\n   my ($self,$found_again) = @_;\n\n   return scalar $self->oldhits();\n}\n\n=head2 add_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::add_hit()|Bio::Search::Iteration::IterationI>.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"add_hit($self,@args)"},"line":412,"range":{"end":{"character":9999,"line":432},"start":{"line":412,"character":0}},"kind":12},{"name":"%below","containerName":null,"kind":13,"line":432},{"line":433,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$hit","line":433},{"containerName":null,"kind":13,"name":"$count","line":434},{"name":"%self","containerName":null,"kind":13,"line":434},{"line":436,"name":"%self","containerName":null,"kind":13},{"line":436,"name":"$hit","containerName":null,"kind":13},{"name":"$count","containerName":null,"kind":13,"line":437},{"name":"%self","containerName":null,"kind":13,"line":437},{"kind":13,"containerName":null,"name":"%old","line":439},{"line":441,"name":"%below","kind":13,"containerName":null},{"line":442,"containerName":null,"kind":13,"name":"%self"},{"name":"$hit","kind":13,"containerName":null,"line":442},{"name":"$count","containerName":null,"kind":13,"line":443},{"line":443,"containerName":null,"kind":13,"name":"%self"},{"name":"%below","kind":13,"containerName":null,"line":444},{"line":445,"kind":13,"containerName":null,"name":"%self"},{"line":445,"name":"$hit","kind":13,"containerName":null},{"line":446,"kind":13,"containerName":null,"name":"$count"},{"line":446,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%self","line":449},{"name":"$hit","containerName":null,"kind":13,"line":449},{"line":450,"name":"$count","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":450},{"name":"%self","containerName":null,"kind":13,"line":454},{"line":454,"name":"$hit","kind":13,"containerName":null},{"name":"$count","kind":13,"containerName":null,"line":455},{"line":455,"containerName":null,"kind":13,"name":"%self"},{"name":"$count","kind":13,"containerName":null,"line":457},{"line":466,"kind":12,"range":{"end":{"character":9999,"line":472},"start":{"character":0,"line":466}},"children":[{"name":"$self","localvar":"my","containerName":"hits","kind":13,"line":467,"definition":"my"},{"definition":"my","line":469,"kind":13,"localvar":"my","containerName":"hits","name":"@new"},{"kind":13,"containerName":"hits","name":"$self","line":469},{"containerName":"hits","kind":12,"name":"newhits","line":469},{"definition":"my","line":470,"name":"@old","localvar":"my","containerName":"hits","kind":13},{"name":"$self","containerName":"hits","kind":13,"line":470},{"kind":12,"containerName":"hits","name":"oldhits","line":470},{"line":471,"name":"@new","kind":13,"containerName":"hits"},{"containerName":"hits","kind":13,"name":"@old","line":471}],"name":"hits","containerName":"main::","definition":"sub"},{"line":486,"range":{"start":{"character":0,"line":486},"end":{"character":9999,"line":492}},"kind":12,"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"newhits","line":487,"definition":"my"},{"definition":"my","name":"@hits","localvar":"my","containerName":"newhits","kind":13,"line":488},{"line":488,"kind":13,"containerName":"newhits","name":"$self"},{"line":488,"containerName":"newhits","kind":12,"name":"newhits_below_threshold"},{"name":"@hits","kind":13,"containerName":"newhits","line":489},{"line":489,"kind":13,"containerName":"newhits","name":"$self"},{"line":489,"kind":12,"containerName":"newhits","name":"newhits_not_below_threshold"},{"name":"@hits","kind":13,"containerName":"newhits","line":490},{"line":490,"name":"$self","containerName":"newhits","kind":13},{"line":490,"containerName":"newhits","kind":12,"name":"newhits_unclassified"},{"name":"@hits","kind":13,"containerName":"newhits","line":491}],"containerName":"main::","name":"newhits","definition":"sub"},{"definition":"sub","containerName":"main::","name":"newhits_below_threshold","children":[{"name":"$self","localvar":"my","containerName":"newhits_below_threshold","kind":13,"line":501,"definition":"my"},{"line":502,"name":"$self","containerName":"newhits_below_threshold","kind":13},{"definition":"my","localvar":"my","containerName":"newhits_below_threshold","kind":13,"name":"$factory","line":503},{"name":"$self","containerName":"newhits_below_threshold","kind":13,"line":503},{"containerName":"newhits_below_threshold","kind":12,"name":"hit_factory","line":503},{"name":"$self","kind":13,"containerName":"newhits_below_threshold","line":503},{"name":"$self","kind":13,"containerName":"newhits_below_threshold","line":504}],"range":{"start":{"character":0,"line":500},"end":{"line":504,"character":9999}},"kind":12,"line":500},{"kind":13,"containerName":null,"name":"%self","line":505},{"line":506,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$factory","line":506},{"name":"create_object","kind":12,"containerName":"main::","line":506},{"line":506,"containerName":null,"kind":13,"name":"%self"},{"line":508,"name":"%self","containerName":null,"kind":13},{"range":{"end":{"line":523,"character":9999},"start":{"character":0,"line":519}},"kind":12,"line":519,"definition":"sub","containerName":"main::","name":"newhits_not_below_threshold","children":[{"kind":13,"localvar":"my","containerName":"newhits_not_below_threshold","name":"$self","line":520,"definition":"my"},{"line":521,"name":"$self","containerName":"newhits_not_below_threshold","kind":13},{"containerName":"newhits_not_below_threshold","localvar":"my","kind":13,"name":"$factory","line":522,"definition":"my"},{"name":"$self","containerName":"newhits_not_below_threshold","kind":13,"line":522},{"name":"hit_factory","kind":12,"containerName":"newhits_not_below_threshold","line":522},{"line":522,"kind":13,"containerName":"newhits_not_below_threshold","name":"$self"},{"name":"$self","containerName":"newhits_not_below_threshold","kind":13,"line":523}]},{"containerName":null,"kind":13,"name":"%self","line":524},{"line":525,"containerName":null,"kind":13,"name":"%self"},{"line":525,"name":"$factory","containerName":null,"kind":13},{"name":"create_object","containerName":"main::","kind":12,"line":525},{"name":"%self","containerName":null,"kind":13,"line":525},{"containerName":null,"kind":13,"name":"%self","line":527},{"children":[{"definition":"my","line":544,"name":"$self","containerName":"newhits_unclassified","localvar":"my","kind":13},{"line":545,"kind":13,"containerName":"newhits_unclassified","name":"$self"},{"line":546,"localvar":"my","kind":13,"containerName":"newhits_unclassified","name":"$factory","definition":"my"},{"line":546,"containerName":"newhits_unclassified","kind":13,"name":"$self"},{"line":546,"kind":12,"containerName":"newhits_unclassified","name":"hit_factory"},{"line":546,"containerName":"newhits_unclassified","kind":13,"name":"$self"},{"line":547,"name":"$self","kind":13,"containerName":"newhits_unclassified"}],"containerName":"main::","name":"newhits_unclassified","definition":"sub","line":543,"range":{"end":{"character":9999,"line":547},"start":{"character":0,"line":543}},"kind":12},{"name":"%self","containerName":null,"kind":13,"line":548},{"kind":13,"containerName":null,"name":"%self","line":549},{"line":549,"kind":13,"containerName":null,"name":"$factory"},{"line":549,"containerName":"main::","kind":12,"name":"create_object"},{"name":"%self","containerName":null,"kind":13,"line":549},{"line":551,"containerName":null,"kind":13,"name":"%self"},{"range":{"end":{"character":9999,"line":574},"start":{"line":568,"character":0}},"kind":12,"line":568,"containerName":"main::","name":"oldhits","children":[{"localvar":"my","kind":13,"containerName":"oldhits","name":"$self","line":569,"definition":"my"},{"definition":"my","line":570,"kind":13,"localvar":"my","containerName":"oldhits","name":"@hits"},{"name":"$self","kind":13,"containerName":"oldhits","line":570},{"line":570,"kind":12,"containerName":"oldhits","name":"oldhits_below_threshold"},{"line":571,"name":"@hits","containerName":"oldhits","kind":13},{"line":571,"name":"$self","kind":13,"containerName":"oldhits"},{"line":571,"name":"oldhits_newly_below_threshold","containerName":"oldhits","kind":12},{"name":"@hits","containerName":"oldhits","kind":13,"line":572},{"name":"$self","kind":13,"containerName":"oldhits","line":572},{"line":572,"name":"oldhits_not_below_threshold","kind":12,"containerName":"oldhits"},{"line":573,"name":"@hits","kind":13,"containerName":"oldhits"}],"definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":583,"containerName":"oldhits_below_threshold","localvar":"my","kind":13,"name":"$self"},{"containerName":"oldhits_below_threshold","kind":13,"name":"$self","line":584},{"definition":"my","line":585,"name":"$factory","localvar":"my","containerName":"oldhits_below_threshold","kind":13},{"kind":13,"containerName":"oldhits_below_threshold","name":"$self","line":585},{"name":"hit_factory","kind":12,"containerName":"oldhits_below_threshold","line":585},{"line":585,"name":"$self","containerName":"oldhits_below_threshold","kind":13},{"kind":13,"containerName":"oldhits_below_threshold","name":"$self","line":586}],"name":"oldhits_below_threshold","containerName":"main::","line":582,"range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":586}},"kind":12},{"containerName":null,"kind":13,"name":"%self","line":587},{"containerName":null,"kind":13,"name":"%self","line":588},{"name":"$factory","containerName":null,"kind":13,"line":588},{"line":588,"kind":12,"containerName":"main::","name":"create_object"},{"kind":13,"containerName":null,"name":"%self","line":588},{"line":590,"name":"%self","containerName":null,"kind":13},{"definition":"sub","name":"oldhits_newly_below_threshold","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"oldhits_newly_below_threshold","name":"$self","line":602},{"containerName":"oldhits_newly_below_threshold","kind":13,"name":"$self","line":603},{"definition":"my","line":604,"name":"$factory","containerName":"oldhits_newly_below_threshold","localvar":"my","kind":13},{"containerName":"oldhits_newly_below_threshold","kind":13,"name":"$self","line":604},{"kind":12,"containerName":"oldhits_newly_below_threshold","name":"hit_factory","line":604},{"line":604,"containerName":"oldhits_newly_below_threshold","kind":13,"name":"$self"},{"line":605,"kind":13,"containerName":"oldhits_newly_below_threshold","name":"$self"}],"kind":12,"range":{"start":{"line":601,"character":0},"end":{"character":9999,"line":605}},"line":601},{"line":606,"name":"%self","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":607},{"kind":13,"containerName":null,"name":"$factory","line":607},{"kind":12,"containerName":"main::","name":"create_object","line":607},{"name":"%self","kind":13,"containerName":null,"line":607},{"name":"%self","kind":13,"containerName":null,"line":609},{"definition":"sub","containerName":"main::","name":"oldhits_not_below_threshold","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"oldhits_not_below_threshold","kind":13,"line":621},{"line":622,"containerName":"oldhits_not_below_threshold","kind":13,"name":"$self"},{"kind":13,"localvar":"my","containerName":"oldhits_not_below_threshold","name":"$factory","line":623,"definition":"my"},{"line":623,"containerName":"oldhits_not_below_threshold","kind":13,"name":"$self"},{"name":"hit_factory","containerName":"oldhits_not_below_threshold","kind":12,"line":623},{"kind":13,"containerName":"oldhits_not_below_threshold","name":"$self","line":623},{"kind":13,"containerName":"oldhits_not_below_threshold","name":"$self","line":624}],"range":{"start":{"character":0,"line":620},"end":{"line":624,"character":9999}},"kind":12,"line":620},{"line":625,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":626},{"name":"$factory","containerName":null,"kind":13,"line":626},{"kind":12,"containerName":"main::","name":"create_object","line":626},{"containerName":null,"kind":13,"name":"%self","line":626},{"line":628,"containerName":null,"kind":13,"name":"%self"},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hits_below_threshold","kind":13,"line":640},{"definition":"my","line":641,"name":"@hits","kind":13,"localvar":"my","containerName":"hits_below_threshold"},{"line":641,"name":"$self","containerName":"hits_below_threshold","kind":13},{"containerName":"hits_below_threshold","kind":12,"name":"newhits_below_threshold","line":641},{"name":"@hits","containerName":"hits_below_threshold","kind":13,"line":642},{"line":642,"kind":13,"containerName":"hits_below_threshold","name":"$self"},{"kind":12,"containerName":"hits_below_threshold","name":"oldhits_newly_below_threshold","line":642},{"kind":13,"containerName":"hits_below_threshold","name":"@hits","line":643}],"containerName":"main::","name":"hits_below_threshold","line":639,"range":{"start":{"line":639,"character":0},"end":{"character":9999,"line":644}},"kind":12},{"containerName":"main::","name":"get_hit","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_hit","line":659,"definition":"my"},{"line":659,"name":"$name","containerName":"get_hit","kind":13},{"line":660,"containerName":"get_hit","kind":13,"name":"$self"},{"name":"_create_hit_lookup","kind":12,"containerName":"get_hit","line":660},{"name":"$self","containerName":"get_hit","kind":13,"line":660},{"name":"$self","containerName":"get_hit","kind":13,"line":662}],"detail":"($self,$name)","definition":"sub","range":{"start":{"character":0,"line":658},"end":{"character":9999,"line":663}},"kind":12,"line":658,"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: GenericIteration.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Iteration::GenericIteration\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# TODO: Consider calling this BlastIteration (strongly) and maybe simplifying IterationI.\n\n=head1 NAME\n\nBio::Search::Iteration::GenericIteration - A generic implementation of the Bio::Search::Iteration::IterationI interface.\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Iteration::GenericIteration;\n    my $it = Bio::Search::GenericIteration->new(\n                              -number => 1,\n                              -converged => 0,\n                              -newhits_unclassified => [@newhits_unclass],\n                              -newhits_below => [@newhits_below_threshold],\n                              -newhits_not_below => [@newhits_not_below_threshold],\n                              -oldhits_below => [@oldhits_below_threshold],\n                              -oldhits_newly_below => [@oldhits_newly_below_threshold],\n                              -oldhits_not_below => [@oldhits_not_below_threshold],\n                                        );\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericIteration objects.\n\n\n=head1 DESCRIPTION\n\nThis module acts as a container for Bio::Search::Hit::HitI objects,\nallowing a Search::Result::ResultI object to partition its hits based\non which iteration the hit occurred in (e.g., a PSI-BLAST round).\n\nUnless you're writing a parser, you won't ever need to create a\nGenericIteration or any other IterationI-implementing object. If you use\nthe SearchIO system, IterationI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the IterationI objects via the ResultI API.\n\nFor documentation on what you can do with GenericIteration (and other IterationI\nobjects), please see the API documentation in\nL<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>.\n\nBio::Search::Iteration::GenericIteration is similar in spirit to the deprecated\nBio::Tools::BPlite::Iteration modules in bioperl releases prior to 1.6, except\nthat Bio::Search::Iteration::GenericIteration is a pure container, without any\nparsing functionality as is in Bio::Tools::BPlite::Iteration.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::GenericIteration;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Search::Iteration::IterationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Iteration->new(%args);\n Function: Builds a new Bio::Search::Iteration object \n Returns : Bio::Search::Iteration::GenericIteration object\n Args    : -number => integer for the number of this iteration (required)\n           -converged => boolean value whether or not the iteration converged\n           -newhits_unclassified => array reference to hits that were not found\n                       in a previous iteration for the iteration and have not been \n                       classified with regard to the inclusion threshold\n\n           # The following are only used for PSI-BLAST reports:\n\n           -newhits_below => array reference to hits were not found in a \n                        previous iteration and are below the inclusion threshold.\n           -newhits_not_below => array reference to hits that were not found in a \n                        previous iteration below threshold that and are not below \n                        the inclusion threshold threshold.\n           -oldhits_below => array reference to hits that were found\n                        in a previous iteration below inclusion threshold and are\n                        still below threshold in the current iteration.\n           -oldhits_newly_below => array reference to hits that were found\n                        in a previous iteration above threshold but are below\n                        threshold in the current iteration.\n           -oldhits_not_below => array reference to hits that were found in a\n                        previous iteration above threshold that and are still above\n                        the inclusion threshold threshold.\n\n           -hit_factory => Bio::Factory::ObjectFactoryI capable of making\n                        Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($number, $newhits_unclassified, $newhits_below, $newhits_not_below,\n      $oldhits_below, $oldhits_newly_below, $oldhits_not_below, $converged,\n      $h_f) =\n      $self->_rearrange([qw(NUMBER\n                            NEWHITS_UNCLASSIFIED\n                            NEWHITS_BELOW\n                            NEWHITS_NOT_BELOW\n                            OLDHITS_BELOW\n                            OLDHITS_NEWLY_BELOW\n                            OLDHITS_NOT_BELOW\n                            CONVERGED\n                            HIT_FACTORY\n                           )], @args);\n\n  if( ! defined $number ) { \n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Iteration number not specified.\");\n  } else { \n      $self->number($number);\n  }\n\n  defined $converged && $self->converged($converged);\n\n  # TODO: Performance optimization test calling add_hit() vs. simple assignment:\n  #       push @{$self->{'_hits_new'}}, @{$newhits};\n  #             vs.\n  #       foreach(@{$newhits_below}) {$self->add_hit(-hit=>$_, -old=>0, -below=>1);}\n\n  if(defined $newhits_unclassified ) {\n    if( ref($newhits_unclassified) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_unclassified'}}, @{$newhits_unclassified};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS is not an array ref: $newhits_unclassified\");\n    }\n  } else {\n      $self->{'_newhits_unclassified'} = [];\n  }\n\n  if(defined $newhits_below ) {\n    if( ref($newhits_below) =~ /ARRAY/i) {\n        push @{$self->{'_newhits_below_threshold'}}, @{$newhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_BELOW is not an array ref: $newhits_below\");\n    }\n  } else {\n      $self->{'_newhits_below_threshold'} = [];\n  }\n\n  if(defined $newhits_not_below ) {\n    if( ref($newhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_newhits_not_below_threshold'}}, @{$newhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter NEWHITS_NOT_BELOW is not an array ref: $newhits_not_below\");\n    }\n  } else {\n      $self->{'_newhits_not_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_below ) {\n    if( ref($oldhits_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_below_threshold'}}, @{$oldhits_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_BELOW is not an array ref: $oldhits_below\");\n    }\n  } else {\n      $self->{'_oldhits_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_newly_below ) {\n    if( ref($oldhits_newly_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_newly_below_threshold'}}, @{$oldhits_newly_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NEWLY_BELOW is not an array ref: $oldhits_newly_below\");\n    }\n  } else {\n      $self->{'_oldhits_newly_below_threshold'} = [];\n  }\n\n  if(defined $oldhits_not_below ) {\n    if( ref($oldhits_not_below) =~ /ARRAY/i) {\n         push @{$self->{'_oldhits_not_below_threshold'}}, @{$oldhits_not_below};\n    } else {\n      $self->throw(-class=>'Bio::Root::BadParameter',\n                   -text=>\"Parameter OLDHITS_NOT_BELOW is not an array ref: $oldhits_not_below\");\n    }\n  } else {\n      $self->{'_oldhits_not_below_threshold'} = [];\n  }\n  \n  $self->hit_factory($h_f) if $h_f;\n  \n  return $self;\n}\n\n\n=head2 number\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub number {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_number'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_number'} = $value;\n    } \n    return $previous;\n}\n\n=head2 converged\n\nSee documentation in Bio::Search::Iteration::IterationI.\n\n\nsub converged {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_converged'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_converged'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 next_hit\n\nThis iterates through all old hits as returned by L<oldhits> \nfollowed by all new hits as returned by L<newhits>.\n\nFor more documentation see L<Bio::Search::Iteration::IterationI::next_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_started'}) {\n       $self->{'_hit_queue'} = ( [$self->oldhits(), $self->newhits()] );\n       $self->{'_hit_queue_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue'}};\n}\n\n=head2 next_hit_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_new {\n   my ($self) = @_;\n\n   unless($self->{'_hit_queue_new_started'}) {\n       $self->{'_hit_queue_new'} = [$self->newhits()];\n       $self->{'_hit_queue_new_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_new'}};\n}\n\n=head2 next_hit_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::next_hit_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub next_hit_old {\n   my ($self,$found_again) = @_;\n\n   unless($self->{'_hit_queue_old_started'}) {\n       $self->{'_hit_queue_old'} = [$self->oldhits()];\n       $self->{'_hit_queue_old_started'} = 1;\n   }\n   return shift @{$self->{'_hit_queue_old'}};\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $iteration->rewind;\n Function: Allow one to reset the Hit iterators to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   my $self = shift;\n   $self->{'_hit_queue_started'} = 0;\n   $self->{'_hit_queue_new_started'} = 0;\n   $self->{'_hit_queue_old_started'} = 0;\n   foreach ($self->hits) {\n      $_->rewind;\n   }\n}\n\n\n=head2 num_hits\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits {\n   my $self = shift;\n\n   return $self->num_hits_old + $self->num_hits_new;\n}\n\n=head2 num_hits_new\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_new()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_new {\n   my $self = shift;\n\n    return scalar $self->newhits();\n}\n\n=head2 num_hits_old\n\nSee documentation in L<Bio::Search::Iteration::IterationI::num_hits_old()|Bio::Search::Iteration::IterationI>.\n\n\nsub num_hits_old {\n   my ($self,$found_again) = @_;\n\n   return scalar $self->oldhits();\n}\n\n=head2 add_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::add_hit()|Bio::Search::Iteration::IterationI>.\n\n\nsub add_hit { \n    my ($self,@args) = @_;\n    my( $hit, $old, $below, $newly_below ) = \n        $self->_rearrange([qw(HIT\n                              OLD\n                              BELOW_THRESHOLD\n                              NEWLY_BELOW\n                             )], @args);\n    my $count = 0;\n\n    unless( ref($hit) eq 'HASH' || $hit->isa('Bio::Search::Hit::HitI') ) { \n        $self->throw(-class=>'Bio::Root::BadParameter',\n                     -text=>\"Passed in \" .ref($hit). \n                    \" as a Hit which is not a Bio::Search::Hit::HitI.\");\n    }\n\n    if($old) {\n        if ($newly_below) {\n            push @{$self->{'_oldhits_newly_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_newly_below_threshold'}};\n        } elsif ($below) {\n            push @{$self->{'_oldhits_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_below_threshold'}};\n        } else {\n            push @{$self->{'_oldhits_not_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_oldhits_not_below_threshold'}};\n        }\n    } elsif (defined $old) {\n        # -old is defined but false, so this is a new PSI-BLAST hit\n        if ($below) {\n            push @{$self->{'_newhits_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_newhits_below_threshold'}};\n        } elsif (defined $below) {\n            push @{$self->{'_newhits_not_below_threshold'}}, $hit;\n            $count = scalar @{$self->{'_newhits_not_below_threshold'}};\n        } else {\n            # -below not defined, PSI-BLAST threshold may not be known\n            push @{$self->{'_newhits_unclassified'}}, $hit;\n            $count = scalar @{$self->{'_newhits_unclassified'}};\n        }\n    } else {\n        # -old not defined, so it's non-PSI-BLAST\n        push @{$self->{'_newhits_unclassified'}}, $hit;\n        $count = scalar @{$self->{'_newhits_unclassified'}};\n    }\n    return $count;\n}\n\n=head2 hits\n\nSee Documentation in InterfaceI.\n\n\nsub hits  { \n    my $self = shift;\n#    print STDERR \"Called GenericIteration::hits()\\n\";\n    my @new = $self->newhits;\n    my @old = $self->oldhits;\n    return ( @new, @old );\n}\n\n=head2 newhits\n\nReturns a list containing all newhits in this order:\n\nnewhits_below_threshold\nnewhits_not_below_threshold\nnewhits_unclassified\n\nSee more documentation in InterfaceI.\n\n\nsub newhits  { \n    my $self = shift;\n    my @hits = $self->newhits_below_threshold;\n    push @hits, $self->newhits_not_below_threshold;\n    push @hits, $self->newhits_unclassified;\n    return @hits;\n}\n\n=head2 newhits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::newhits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub newhits_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_newhits_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_below_threshold'}};\n        for (0..$#{$self->{'_newhits_below_threshold'}}) {\n            ref(${$self->{'_newhits_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_newhits_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_newhits_below_threshold'}};\n    }\n    return;\n}\n\n=head2 newhits_not_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::newhits_not_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub newhits_not_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_newhits_not_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_not_below_threshold'}};\n        for (0..$#{$self->{'_newhits_not_below_threshold'}}) {\n            ref(${$self->{'_newhits_not_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_not_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_newhits_not_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_newhits_not_below_threshold'}};\n    }\n    return;\n}\n\n=head2 newhits_unclassified\n\n Title   : newhits_unclassified\n Usage   : foreach( $iteration->hits_unclassified ) {...}\n Function: Gets all newhits that have not been partitioned into\n           sets relative to the inclusion threshold.\n Returns : Array of Bio::Search::Hit::HitI objects.\n Args    : none\n\n\nsub newhits_unclassified  { \n    my $self = shift;\n    if (ref $self->{'_newhits_unclassified'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_newhits_unclassified'}};\n        for (0..$#{$self->{'_newhits_unclassified'}}) {\n            ref(${$self->{'_newhits_unclassified'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_newhits_unclassified'}}[$_] = $factory->create_object(%{${$self->{'_newhits_unclassified'}}[$_]});\n        }\n        return @{$self->{'_newhits_unclassified'}};\n    }\n    return;\n}\n\n=head2 oldhits\n\nReturns a list containing all oldhits in this order:\n\noldhits_below_threshold\noldhits_newly_below_threshold\noldhits_not_below_threshold\n\nSee more documentation in InterfaceI.\n\n\nsub oldhits  { \n    my $self = shift;\n    my @hits = $self->oldhits_below_threshold;\n    push @hits, $self->oldhits_newly_below_threshold;\n    push @hits, $self->oldhits_not_below_threshold;\n    return @hits;\n}\n\n=head2 oldhits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_below_threshold'}}) {\n            ref(${$self->{'_oldhits_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_below_threshold'}};\n    }\n    return;\n}\n\n=head2 oldhits_newly_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_newly_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_newly_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_newly_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_newly_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_newly_below_threshold'}}) {\n            ref(${$self->{'_oldhits_newly_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_newly_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_newly_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_newly_below_threshold'}};\n    }\n    return;\n}\n\n=head2 oldhits_not_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::oldhits_not_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub oldhits_not_below_threshold  { \n    my $self = shift;\n    if (ref $self->{'_oldhits_not_below_threshold'} ) {\n        my $factory = $self->hit_factory || return @{$self->{'_oldhits_not_below_threshold'}};\n        for (0..$#{$self->{'_oldhits_not_below_threshold'}}) {\n            ref(${$self->{'_oldhits_not_below_threshold'}}[$_]) eq 'HASH' || next;\n            ${$self->{'_oldhits_not_below_threshold'}}[$_] = $factory->create_object(%{${$self->{'_oldhits_not_below_threshold'}}[$_]});\n        }\n        return @{$self->{'_oldhits_not_below_threshold'}};\n    }\n    return;\n}\n\n=head2 hits_below_threshold\n\nSee documentation in L<Bio::Search::Iteration::IterationI::hits_below_threshold()|Bio::Search::Iteration::IterationI>.\n\n\nsub hits_below_threshold  {\n    my $self = shift;\n    my @hits = $self->newhits_below_threshold;\n    push @hits, $self->oldhits_newly_below_threshold;\n    return @hits;\n}\n\n=head2 get_hit\n\nSee documentation in L<Bio::Search::Iteration::IterationI::get_hit()|Bio::Search::Iteration::IterationI>.\n\nTo free up the memory used by the get_hit() functionality, call free_hit_lookup().\n\nThis functionality might be useful at the Result level, too.\nBlastResult::get_hit() would return a list of HitI objects for hits \nthat occur in multiple iterations.","label":"get_hit($self,$name)"}},{"line":666,"kind":12,"range":{"end":{"character":9999,"line":672},"start":{"character":0,"line":666}},"definition":"sub","children":[{"line":667,"name":"$self","localvar":"my","containerName":"_create_hit_lookup","kind":13,"definition":"my"},{"kind":13,"containerName":"_create_hit_lookup","name":"$self","line":668},{"line":668,"name":"hits","containerName":"_create_hit_lookup","kind":12},{"definition":"my","line":669,"name":"$hname","localvar":"my","containerName":"_create_hit_lookup","kind":13},{"containerName":"_create_hit_lookup","kind":12,"name":"name","line":669},{"containerName":"_create_hit_lookup","kind":13,"name":"$self","line":670}],"containerName":"main::","name":"_create_hit_lookup"},{"definition":"sub","children":[{"line":682,"containerName":"free_hit_lookup","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":683,"kind":13,"containerName":"free_hit_lookup","name":"$self"}],"name":"free_hit_lookup","containerName":"main::","line":681,"kind":12,"range":{"start":{"character":0,"line":681},"end":{"character":9999,"line":684}}}]}