{"vars":[{"line":79,"name":"base","containerName":"","kind":2},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA","label":"new($class,@args)"},"kind":12,"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":91}},"line":91,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":92,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":92},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$len","line":95},{"kind":13,"containerName":"new","name":"$qs","line":95},{"name":"$hs","kind":13,"containerName":"new","line":95},{"line":95,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","kind":13,"containerName":"new","line":97},{"line":98,"name":"$len","kind":13,"containerName":"new"},{"name":"$qs","containerName":"new","kind":13,"line":98},{"name":"warn","containerName":"new","kind":12,"line":99},{"name":"$len","kind":13,"containerName":"new","line":100},{"line":100,"kind":13,"containerName":"new","name":"$qs"},{"name":"$homol_seq","localvar":"my","containerName":"new","kind":13,"line":102,"definition":"my"},{"line":102,"containerName":"new","kind":13,"name":"$gapct"},{"line":102,"name":"$identical","kind":13,"containerName":"new"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"new","line":104},{"name":"$i","containerName":"new","kind":13,"line":104},{"kind":13,"containerName":"new","name":"$len","line":104},{"containerName":"new","kind":13,"name":"$i","line":104},{"definition":"my","name":"$q","localvar":"my","kind":13,"containerName":"new","line":105},{"line":105,"containerName":"new","kind":13,"name":"$qs"},{"line":105,"containerName":"new","kind":13,"name":"$i"},{"line":106,"name":"$h","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$hs","line":106},{"line":106,"name":"$i","kind":13,"containerName":"new"},{"name":"$q","containerName":"new","kind":13,"line":107},{"name":"$h","containerName":"new","kind":13,"line":107},{"line":108,"name":"$homol_seq","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$gapct","line":109},{"line":110,"name":"$q","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$h","line":110},{"line":111,"containerName":"new","kind":13,"name":"$homol_seq"},{"line":112,"containerName":"new","kind":13,"name":"$identical"},{"kind":13,"containerName":"new","name":"$homol_seq","line":114},{"definition":"my","line":117,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":117,"containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"$identical","line":117},{"line":118,"name":"$identical","kind":13,"containerName":"new"},{"name":"$gapct","containerName":"new","kind":13,"line":119},{"kind":13,"containerName":"new","name":"$homol_seq","line":120},{"line":121,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","containerName":"new","kind":13,"name":"$hmmst","line":123,"definition":"my"},{"line":123,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":123},{"line":123,"name":"@args","kind":13,"containerName":"new"},{"line":124,"kind":13,"containerName":"new","name":"$hmmst"},{"containerName":"new","kind":13,"name":"$self","line":124},{"line":124,"name":"hmmstate_string","containerName":"new","kind":12},{"line":124,"kind":13,"containerName":"new","name":"$hmmst"},{"containerName":"new","kind":13,"name":"$self","line":126},{"kind":12,"containerName":"new","name":"add_tag_value","line":126},{"line":126,"containerName":"new","kind":13,"name":"$self"},{"name":"hit","containerName":"new","kind":12,"line":126},{"line":126,"containerName":"new","kind":12,"name":"seq_id"},{"line":127,"name":"$self","containerName":"new","kind":13},{"line":127,"containerName":"new","kind":12,"name":"hit"},{"line":127,"containerName":"new","kind":12,"name":"start"},{"name":"$self","kind":13,"containerName":"new","line":127},{"kind":12,"containerName":"new","name":"hit","line":127},{"line":127,"kind":12,"containerName":"new","name":"end"},{"kind":13,"containerName":"new","name":"$self","line":129}]},{"kind":12,"containerName":"Root::RootI","name":"Bio","line":95},{"containerName":"Root::RootI","kind":12,"name":"Bio","line":99},{"name":"SUPER","kind":12,"containerName":"new","line":117},{"detail":"($self,$val)","definition":"sub","name":"hmmstate_string","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hmmstate_string","line":144,"definition":"my"},{"line":144,"name":"$val","containerName":"hmmstate_string","kind":13},{"line":145,"containerName":"hmmstate_string","kind":13,"name":"$val"},{"name":"$self","containerName":"hmmstate_string","kind":13,"line":146},{"name":"$val","kind":13,"containerName":"hmmstate_string","line":146},{"name":"$self","kind":13,"containerName":"hmmstate_string","line":148}],"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA\n\n\nsub new {\n  my($class,@args) = @_;\n\n  # gotta do some preprocessing before we send the arguments to the superclass\n  my ($len,$qs,$hs) = Bio::Root::RootI->_rearrange([qw(HSP_LENGTH\n\t\t\t\t\t\t       QUERY_SEQ \n\t\t\t\t\t\t       HIT_SEQ)],@args);  \n  if( $len != length($qs) ) {\n    Bio::Root::RootI->warn(\"HSP_LENGTH must equal length of query_seq string, using value from QUERY_SEQ\\n\");\n      $len = length($qs);\n  }\n  my( $homol_seq,$gapct,$identical) = ('',0,0);\n  \n  for(my $i=0;$i<$len;$i++) {\n      my $q = substr($qs,$i,1);\n      my $h = substr($hs,$i,1);\n      if( $q eq '-' || $h eq '-' ) {\n\t  $homol_seq .= ' ';\n\t  $gapct ++;\n      } elsif( $q eq $h ) { \n\t  $homol_seq .= '|';\n\t  $identical++;\n      } else { \n\t  $homol_seq .= ' ';\n      }\n  }\n  my $self = $class->SUPER::new('-conserved' => $identical,\n\t\t\t\t'-identical' => $identical,\n\t\t\t\t'-gaps'      => $gapct,\n\t\t\t\t'-homology_seq' => $homol_seq,\n\t\t\t\t@args);\n    \n  my ($hmmst) = $self->_rearrange([qw(HMMSTATE_SEQ)],@args);\n  defined $hmmst && $self->hmmstate_string($hmmst);\n  \n  $self->add_tag_value('Target' , join(\" \",\"Sequence:\".$self->hit->seq_id, \n\t\t\t\t       $self->hit->start, $self->hit->end));\n\n  return $self;\n}\n\n=head2 hmmstate_string\n\n Title   : hmmstate_string\n Usage   : my $hmmseq = $wabahsp->hmmstate_string();\n Function: Get/Set the WABA HMM stateseq\n Returns : string\n Args    : [optional] string","label":"hmmstate_string($self,$val)"},"range":{"start":{"line":143,"character":0},"end":{"character":9999,"line":149}},"kind":12,"line":143},{"name":"homology_string","containerName":"main::","children":[{"definition":"my","line":164,"localvar":"my","kind":13,"containerName":"homology_string","name":"$self"}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":163},"end":{"character":9999,"line":166}},"kind":12,"line":163,"signature":{"label":"homology_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA\n\n\nsub new {\n  my($class,@args) = @_;\n\n  # gotta do some preprocessing before we send the arguments to the superclass\n  my ($len,$qs,$hs) = Bio::Root::RootI->_rearrange([qw(HSP_LENGTH\n\t\t\t\t\t\t       QUERY_SEQ \n\t\t\t\t\t\t       HIT_SEQ)],@args);  \n  if( $len != length($qs) ) {\n    Bio::Root::RootI->warn(\"HSP_LENGTH must equal length of query_seq string, using value from QUERY_SEQ\\n\");\n      $len = length($qs);\n  }\n  my( $homol_seq,$gapct,$identical) = ('',0,0);\n  \n  for(my $i=0;$i<$len;$i++) {\n      my $q = substr($qs,$i,1);\n      my $h = substr($hs,$i,1);\n      if( $q eq '-' || $h eq '-' ) {\n\t  $homol_seq .= ' ';\n\t  $gapct ++;\n      } elsif( $q eq $h ) { \n\t  $homol_seq .= '|';\n\t  $identical++;\n      } else { \n\t  $homol_seq .= ' ';\n      }\n  }\n  my $self = $class->SUPER::new('-conserved' => $identical,\n\t\t\t\t'-identical' => $identical,\n\t\t\t\t'-gaps'      => $gapct,\n\t\t\t\t'-homology_seq' => $homol_seq,\n\t\t\t\t@args);\n    \n  my ($hmmst) = $self->_rearrange([qw(HMMSTATE_SEQ)],@args);\n  defined $hmmst && $self->hmmstate_string($hmmst);\n  \n  $self->add_tag_value('Target' , join(\" \",\"Sequence:\".$self->hit->seq_id, \n\t\t\t\t       $self->hit->start, $self->hit->end));\n\n  return $self;\n}\n\n=head2 hmmstate_string\n\n Title   : hmmstate_string\n Usage   : my $hmmseq = $wabahsp->hmmstate_string();\n Function: Get/Set the WABA HMM stateseq\n Returns : string\n Args    : [optional] string\n\n\n\nsub hmmstate_string{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_hmmstate_string'} = $val;\n   }\n   return $self->{'_hmmstate_string'};\n}\n\n=head2 homology_string\n\n Title   : homolgy_string\n Usage   : my $homology_str = $hsp->homology_string();\n Function: Homology string must be calculated for a WABA HSP so we can do\n           so here and cache the result so it is only done once\n Returns : string\n Args    : none"}}],"version":5}