{"vars":[{"containerName":"","kind":2,"name":"base","line":128},{"containerName":"main::","name":"_setup","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_setup","kind":13,"line":142},{"name":"@args","kind":13,"containerName":"_setup","line":142},{"containerName":"_setup","kind":13,"name":"$self","line":145},{"kind":12,"containerName":"_setup","name":"_fields","line":145},{"localvar":"my","containerName":"_setup","kind":13,"name":"$parent","line":173,"definition":"my"},{"line":173,"kind":13,"containerName":"_setup","name":"$chunk"},{"containerName":"_setup","kind":13,"name":"$hsp_data","line":173},{"containerName":"_setup","kind":13,"name":"$self","line":173},{"line":173,"name":"_rearrange","containerName":"_setup","kind":12},{"containerName":"_setup","kind":13,"name":"@args","line":175},{"line":177,"containerName":"_setup","kind":13,"name":"$self"},{"line":177,"containerName":"_setup","kind":12,"name":"throw"},{"line":177,"name":"$parent","kind":13,"containerName":"_setup"},{"line":177,"kind":13,"containerName":"_setup","name":"$chunk"},{"line":179,"name":"$self","containerName":"_setup","kind":13},{"containerName":"_setup","kind":12,"name":"parent","line":179},{"name":"$parent","kind":13,"containerName":"_setup","line":179},{"containerName":"_setup","kind":13,"name":"$parent","line":179},{"kind":13,"containerName":"_setup","name":"$chunk","line":181},{"definition":"my","name":"$io","localvar":"my","containerName":"_setup","kind":13,"line":182},{"kind":13,"containerName":"_setup","name":"$start","line":182},{"line":182,"name":"$end","containerName":"_setup","kind":13},{"line":183,"name":"$chunk","containerName":"_setup","kind":13},{"line":184,"containerName":"_setup","kind":13,"name":"$io"},{"containerName":"_setup","kind":13,"name":"$start","line":184},{"line":184,"kind":13,"containerName":"_setup","name":"$end"},{"line":184,"name":"$chunk","containerName":"_setup","kind":13},{"containerName":"_setup","kind":13,"name":"$io","line":187},{"containerName":"_setup","kind":13,"name":"$chunk","line":187},{"line":189,"containerName":"_setup","kind":13,"name":"$self"},{"name":"chunk","containerName":"_setup","kind":12,"line":189},{"name":"$io","kind":13,"containerName":"_setup","line":189},{"containerName":"_setup","kind":13,"name":"$start","line":189},{"name":"$end","kind":13,"containerName":"_setup","line":189}],"detail":"($self,@args)","definition":"sub","range":{"end":{"line":190,"character":9999},"start":{"character":0,"line":141}},"kind":12,"line":141,"signature":{"label":"_setup($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new()."}},{"line":145,"name":"hsp_length","kind":12},{"line":146,"name":"identical","kind":12},{"name":"percent_identity","kind":12,"line":147},{"name":"conserved","kind":12,"line":148},{"line":149,"name":"hsp_gaps","kind":12},{"name":"query_gaps","kind":12,"line":150},{"kind":12,"name":"hit_gaps","line":151},{"kind":12,"name":"evalue","line":152},{"kind":12,"name":"pvalue","line":153},{"line":154,"kind":12,"name":"score"},{"line":155,"kind":12,"name":"query_start"},{"line":156,"name":"query_end","kind":12},{"name":"query_string","kind":12,"line":157},{"name":"hit_start","kind":12,"line":158},{"name":"hit_end","kind":12,"line":159},{"line":160,"name":"hit_string","kind":12},{"line":161,"kind":12,"name":"homology_string"},{"kind":12,"name":"rank","line":162},{"line":163,"kind":12,"name":"seq_inds"},{"line":164,"name":"hit_identical_inds","kind":12},{"name":"hit_conserved_inds","kind":12,"line":165},{"line":166,"name":"hit_nomatch_inds","kind":12},{"name":"hit_gap_inds","kind":12,"line":167},{"name":"query_identical_inds","kind":12,"line":168},{"line":169,"kind":12,"name":"query_conserved_inds"},{"line":170,"name":"query_nomatch_inds","kind":12},{"line":171,"name":"query_gap_inds","kind":12},{"line":192,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_raw_hsp_data","line":192},{"line":192,"containerName":null,"kind":13,"name":"$hsp_data"},{"name":"$hsp_data","kind":13,"containerName":null,"line":192},{"name":"$self","containerName":null,"kind":13,"line":194},{"line":197,"range":{"start":{"character":0,"line":197},"end":{"character":9999,"line":203}},"kind":12,"definition":"sub","children":[{"definition":"my","line":198,"name":"$self","kind":13,"localvar":"my","containerName":"_raw_hsp_data"},{"kind":13,"containerName":"_raw_hsp_data","name":"$self","line":200},{"name":"$self","containerName":"_raw_hsp_data","kind":13,"line":202}],"name":"_raw_hsp_data","containerName":"main::"},{"kind":12,"name":"_raw_hsp_data","line":200},{"kind":12,"name":"_raw_hsp_data","line":202},{"range":{"start":{"character":0,"line":221},"end":{"character":9999,"line":223}},"kind":12,"line":221,"definition":"sub","containerName":"main::","name":"algorithm","children":[{"containerName":"algorithm","kind":12,"name":"get_field","line":222}]},{"kind":12,"range":{"end":{"line":237,"character":9999},"start":{"line":235,"character":0}},"line":235,"definition":"sub","name":"pvalue","containerName":"main::","children":[{"name":"get_field","kind":12,"containerName":"pvalue","line":236}]},{"definition":"sub","children":[{"line":250,"kind":12,"containerName":"evalue","name":"get_field"}],"name":"evalue","containerName":"main::","line":249,"range":{"start":{"line":249,"character":0},"end":{"character":9999,"line":251}},"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' ","label":"frac_identical($self,$type)"},"line":268,"kind":12,"range":{"end":{"character":9999,"line":277},"start":{"line":268,"character":0}},"definition":"sub","detail":"($self,$type)","children":[{"line":269,"localvar":"my","kind":13,"containerName":"frac_identical","name":"$self","definition":"my"},{"line":269,"containerName":"frac_identical","kind":13,"name":"$type"},{"name":"$type","kind":13,"containerName":"frac_identical","line":271},{"name":"$type","kind":13,"containerName":"frac_identical","line":271},{"containerName":"frac_identical","kind":13,"name":"$type","line":271},{"line":272,"kind":13,"containerName":"frac_identical","name":"$type"},{"line":272,"containerName":"frac_identical","kind":13,"name":"$type"},{"name":"$type","containerName":"frac_identical","kind":13,"line":272},{"kind":13,"containerName":"frac_identical","name":"$type","line":273},{"line":273,"name":"$type","containerName":"frac_identical","kind":13},{"line":273,"kind":13,"containerName":"frac_identical","name":"$type"},{"line":273,"name":"$type","containerName":"frac_identical","kind":13},{"line":275,"localvar":"my","kind":13,"containerName":"frac_identical","name":"$ratio","definition":"my"},{"line":275,"name":"$self","kind":13,"containerName":"frac_identical"},{"containerName":"frac_identical","kind":12,"name":"num_identical","line":275},{"line":275,"containerName":"frac_identical","kind":13,"name":"$type"},{"kind":13,"containerName":"frac_identical","name":"$self","line":275},{"name":"length","kind":12,"containerName":"frac_identical","line":275},{"line":275,"name":"$type","containerName":"frac_identical","kind":13},{"line":276,"name":"$ratio","containerName":"frac_identical","kind":13}],"name":"frac_identical","containerName":"main::"},{"signature":{"label":"frac_conserved($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' "},"kind":12,"range":{"start":{"character":0,"line":294},"end":{"character":9999,"line":303}},"line":294,"detail":"($self,$type)","definition":"sub","name":"frac_conserved","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"frac_conserved","kind":13,"line":295,"definition":"my"},{"line":295,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":297,"containerName":"frac_conserved","kind":13,"name":"$type"},{"kind":13,"containerName":"frac_conserved","name":"$type","line":297},{"line":297,"name":"$type","containerName":"frac_conserved","kind":13},{"line":298,"containerName":"frac_conserved","kind":13,"name":"$type"},{"name":"$type","containerName":"frac_conserved","kind":13,"line":298},{"line":298,"name":"$type","containerName":"frac_conserved","kind":13},{"line":299,"containerName":"frac_conserved","kind":13,"name":"$type"},{"kind":13,"containerName":"frac_conserved","name":"$type","line":299},{"containerName":"frac_conserved","kind":13,"name":"$type","line":299},{"name":"$type","kind":13,"containerName":"frac_conserved","line":299},{"containerName":"frac_conserved","localvar":"my","kind":13,"name":"$ratio","line":301,"definition":"my"},{"line":301,"containerName":"frac_conserved","kind":13,"name":"$self"},{"name":"num_conserved","containerName":"frac_conserved","kind":12,"line":301},{"line":301,"name":"$type","containerName":"frac_conserved","kind":13},{"line":301,"kind":13,"containerName":"frac_conserved","name":"$self"},{"line":301,"name":"length","kind":12,"containerName":"frac_conserved"},{"containerName":"frac_conserved","kind":13,"name":"$type","line":301},{"kind":13,"containerName":"frac_conserved","name":"$ratio","line":302}]},{"definition":"sub","children":[{"definition":"my","line":316,"name":"$self","localvar":"my","containerName":"num_identical","kind":13},{"name":"$self","kind":13,"containerName":"num_identical","line":317},{"line":317,"containerName":"num_identical","kind":12,"name":"seq_inds"}],"name":"num_identical","containerName":"main::","line":315,"kind":12,"range":{"end":{"line":318,"character":9999},"start":{"character":0,"line":315}}},{"kind":12,"range":{"start":{"line":330,"character":0},"end":{"line":333,"character":9999}},"line":330,"definition":"sub","name":"num_conserved","containerName":"main::","children":[{"definition":"my","line":331,"containerName":"num_conserved","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"num_conserved","line":332},{"line":332,"name":"seq_inds","containerName":"num_conserved","kind":12}]},{"children":[{"line":346,"name":"$self","containerName":"gaps","localvar":"my","kind":13,"definition":"my"},{"line":346,"kind":13,"containerName":"gaps","name":"$type"},{"name":"$type","kind":13,"containerName":"gaps","line":347},{"line":347,"name":"$type","containerName":"gaps","kind":13},{"name":"$type","kind":13,"containerName":"gaps","line":347},{"name":"$type","containerName":"gaps","kind":13,"line":348},{"line":348,"name":"$type","kind":13,"containerName":"gaps"},{"line":348,"name":"$type","containerName":"gaps","kind":13},{"line":348,"name":"$type","kind":13,"containerName":"gaps"},{"name":"$type","kind":13,"containerName":"gaps","line":349},{"name":"$type","kind":13,"containerName":"gaps","line":349},{"name":"$type","containerName":"gaps","kind":13,"line":351},{"name":"$self","kind":13,"containerName":"gaps","line":352},{"kind":12,"containerName":"gaps","name":"seq_inds","line":352},{"line":352,"name":"$self","containerName":"gaps","kind":13},{"line":352,"containerName":"gaps","kind":12,"name":"seq_inds"},{"line":354,"containerName":"gaps","kind":13,"name":"$self"},{"line":354,"name":"seq_inds","containerName":"gaps","kind":12},{"kind":13,"containerName":"gaps","name":"$type","line":354}],"name":"gaps","containerName":"main::","definition":"sub","detail":"($self,$type)","line":345,"kind":12,"range":{"start":{"character":0,"line":345},"end":{"line":355,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' ","label":"gaps($self,$type)"}},{"range":{"end":{"line":369,"character":9999},"start":{"line":367,"character":0}},"kind":12,"line":367,"definition":"sub","containerName":"main::","name":"query_string","children":[{"containerName":"query_string","kind":12,"name":"get_field","line":368}]},{"children":[{"line":382,"containerName":"hit_string","kind":12,"name":"get_field"}],"containerName":"main::","name":"hit_string","definition":"sub","line":381,"kind":12,"range":{"start":{"line":381,"character":0},"end":{"character":9999,"line":383}}},{"name":"homology_string","containerName":"main::","children":[{"containerName":"homology_string","kind":12,"name":"get_field","line":399}],"definition":"sub","kind":12,"range":{"start":{"line":398,"character":0},"end":{"character":9999,"line":400}},"line":398},{"signature":{"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none","parameters":[{"label":"$self"},{"label":"$type"}],"label":"length($self,$type)"},"line":418,"range":{"end":{"line":432,"character":9999},"start":{"line":418,"character":0}},"kind":12,"definition":"sub","detail":"($self,$type)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"length","kind":13,"line":419},{"kind":13,"containerName":"length","name":"$type","line":419},{"line":420,"name":"$type","kind":13,"containerName":"length"},{"name":"$type","containerName":"length","kind":13,"line":420},{"line":421,"containerName":"length","kind":13,"name":"$type"},{"line":421,"containerName":"length","kind":13,"name":"$type"},{"kind":13,"containerName":"length","name":"$type","line":423},{"line":424,"kind":13,"containerName":"length","name":"$self"},{"name":"query","containerName":"length","kind":12,"line":424},{"containerName":"length","kind":12,"name":"length","line":424},{"line":426,"name":"$type","kind":13,"containerName":"length"},{"line":427,"containerName":"length","kind":13,"name":"$self"},{"line":427,"kind":12,"containerName":"length","name":"hit"},{"name":"length","kind":12,"containerName":"length","line":427},{"name":"$self","containerName":"length","kind":13,"line":430},{"line":430,"kind":12,"containerName":"length","name":"hit"},{"name":"length","kind":12,"containerName":"length","line":430},{"line":430,"name":"$self","containerName":"length","kind":13},{"containerName":"length","kind":12,"name":"gaps","line":430}],"containerName":"main::","name":"length"},{"line":444,"kind":12,"range":{"end":{"line":446,"character":9999},"start":{"line":444,"character":0}},"children":[{"containerName":"hsp_length","kind":12,"name":"length","line":445}],"name":"hsp_length","containerName":"main::","definition":"sub"},{"children":[{"definition":"my","line":459,"localvar":"my","containerName":"percent_identity","kind":13,"name":"$self"},{"name":"$self","containerName":"percent_identity","kind":13,"line":460},{"line":460,"name":"frac_identical","kind":12,"containerName":"percent_identity"}],"name":"percent_identity","containerName":"main::","definition":"sub","detail":"($self)","line":458,"range":{"end":{"character":9999,"line":461},"start":{"line":458,"character":0}},"kind":12,"signature":{"label":"percent_identity($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none"}},{"kind":12,"range":{"start":{"character":0,"line":473},"end":{"line":487,"character":9999}},"line":473,"definition":"sub","name":"get_aln","containerName":"main::","children":[{"definition":"my","line":474,"localvar":"my","containerName":"get_aln","kind":13,"name":"$self"},{"definition":"my","line":478,"name":"$aln","containerName":"get_aln","localvar":"my","kind":13},{"line":478,"containerName":"get_aln","kind":12,"name":"new"},{"name":"$hs","localvar":"my","kind":13,"containerName":"get_aln","line":479,"definition":"my"},{"kind":13,"containerName":"get_aln","name":"$self","line":479},{"name":"seq","containerName":"get_aln","kind":12,"line":479},{"definition":"my","name":"$qs","localvar":"my","containerName":"get_aln","kind":13,"line":480},{"line":480,"name":"$self","kind":13,"containerName":"get_aln"},{"line":480,"kind":12,"containerName":"get_aln","name":"seq"},{"containerName":"get_aln","kind":13,"name":"$hs","line":481},{"line":481,"name":"$qs","containerName":"get_aln","kind":13},{"line":482,"kind":13,"containerName":"get_aln","name":"$aln"},{"line":482,"name":"add_seq","containerName":"get_aln","kind":12},{"name":"$hs","containerName":"get_aln","kind":13,"line":482},{"name":"$aln","containerName":"get_aln","kind":13,"line":483},{"name":"add_seq","containerName":"get_aln","kind":12,"line":483},{"name":"$qs","containerName":"get_aln","kind":13,"line":483},{"name":"$aln","containerName":"get_aln","kind":13,"line":484}]},{"line":478,"kind":12,"containerName":"LocatableSeq::Bio::SimpleAlign","name":"Bio"},{"name":"Bio","kind":12,"containerName":"SimpleAlign","line":478},{"name":"seq_inds","containerName":"main::","children":[{"line":519,"localvar":"my","kind":13,"containerName":"seq_inds","name":"$self","definition":"my"},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":519},{"containerName":"seq_inds","kind":13,"name":"$class","line":519},{"name":"$collapse","kind":13,"containerName":"seq_inds","line":519},{"kind":13,"containerName":"seq_inds","name":"$seqType","line":521},{"kind":13,"containerName":"seq_inds","name":"$class","line":522},{"line":523,"kind":13,"containerName":"seq_inds","name":"$collapse"},{"line":524,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":524},{"name":"$class","kind":13,"containerName":"seq_inds","line":525},{"name":"$class","containerName":"seq_inds","kind":13,"line":525},{"line":526,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"kind":13,"containerName":"seq_inds","name":"$seqType","line":526},{"definition":"my","line":528,"containerName":"seq_inds","localvar":"my","kind":13,"name":"$t"},{"line":528,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"line":529,"containerName":"seq_inds","kind":13,"name":"$t"},{"line":530,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"line":532,"name":"$t","containerName":"seq_inds","kind":13},{"line":532,"name":"$t","containerName":"seq_inds","kind":13},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":533},{"name":"$self","containerName":"seq_inds","kind":13,"line":536},{"containerName":"seq_inds","kind":12,"name":"warn","line":536},{"line":537,"containerName":"seq_inds","kind":13,"name":"$seqType"},{"line":540,"containerName":"seq_inds","kind":13,"name":"$t"},{"containerName":"seq_inds","kind":13,"name":"$class","line":540},{"kind":13,"containerName":"seq_inds","name":"$t","line":541},{"kind":13,"containerName":"seq_inds","name":"$class","line":542},{"line":543,"name":"$class","containerName":"seq_inds","kind":13},{"containerName":"seq_inds","kind":13,"name":"$class","line":546},{"kind":13,"containerName":"seq_inds","name":"$t","line":549},{"name":"$class","containerName":"seq_inds","kind":13,"line":550},{"name":"$t","containerName":"seq_inds","kind":13,"line":552},{"line":553,"kind":13,"containerName":"seq_inds","name":"$class"},{"line":555,"name":"$t","containerName":"seq_inds","kind":13},{"line":556,"containerName":"seq_inds","kind":13,"name":"$class"},{"line":559,"containerName":"seq_inds","kind":13,"name":"$self"},{"line":559,"containerName":"seq_inds","kind":12,"name":"warn"},{"kind":13,"containerName":"seq_inds","name":"$class","line":560},{"line":563,"containerName":"seq_inds","kind":13,"name":"$seqType"},{"name":"$class","kind":13,"containerName":"seq_inds","line":564},{"localvar":"my","kind":13,"containerName":"seq_inds","name":"@ary","line":566,"definition":"my"},{"kind":13,"containerName":"seq_inds","name":"$class","line":567},{"line":568,"kind":13,"localvar":"my","containerName":"seq_inds","name":"%tmp","definition":"my"},{"name":"$self","containerName":"seq_inds","kind":13,"line":568},{"containerName":"seq_inds","kind":12,"name":"get_field","line":568},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":568},{"line":569,"kind":13,"containerName":"seq_inds","name":"$self"},{"name":"get_field","kind":12,"containerName":"seq_inds","line":569},{"line":569,"name":"$seqType","kind":13,"containerName":"seq_inds"}],"detail":"($self,$seqType,$class,$collapse)","definition":"sub","range":{"start":{"line":518,"character":0},"end":{"line":569,"character":9999}},"kind":12,"line":518,"signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}]}},{"kind":13,"containerName":null,"name":"@ary","line":570},{"name":"$a","kind":13,"containerName":null,"line":570},{"line":570,"name":"$b","kind":13,"containerName":null},{"line":570,"name":"%tmp","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@ary","line":573},{"name":"$self","kind":13,"containerName":null,"line":573},{"kind":12,"containerName":"main::","name":"get_field","line":573},{"line":573,"containerName":null,"kind":13,"name":"$seqType"},{"name":"$class","kind":13,"containerName":null,"line":573},{"line":576,"kind":13,"containerName":null,"name":"$collapse"},{"line":576,"name":"Bio","kind":12,"containerName":"Search::SearchUtils::collapse_nums"},{"line":576,"containerName":null,"kind":13,"name":"@ary"},{"kind":13,"containerName":null,"name":"@ary","line":576},{"definition":"sub","name":"significance","containerName":"main::","children":[{"name":"get_field","kind":12,"containerName":"significance","line":613}],"kind":12,"range":{"start":{"line":612,"character":0},"end":{"line":614,"character":9999}},"line":612},{"definition":"sub","children":[{"name":"get_field","kind":12,"containerName":"score","line":627}],"containerName":"main::","name":"score","line":626,"range":{"end":{"line":628,"character":9999},"start":{"line":626,"character":0}},"kind":12},{"line":640,"kind":12,"range":{"start":{"character":0,"line":640},"end":{"character":9999,"line":642}},"definition":"sub","children":[{"line":641,"name":"get_field","kind":12,"containerName":"bits"}],"containerName":"main::","name":"bits"},{"range":{"end":{"character":9999,"line":677},"start":{"character":0,"line":658}},"kind":12,"line":658,"name":"strand","containerName":"main::","children":[{"localvar":"my","containerName":"strand","kind":13,"name":"$self","line":659,"definition":"my"},{"definition":"my","line":660,"name":"$val","localvar":"my","containerName":"strand","kind":13},{"name":"$val","containerName":"strand","kind":13,"line":661},{"line":661,"kind":13,"containerName":"strand","name":"$val"},{"kind":13,"containerName":"strand","name":"$val","line":662},{"containerName":"strand","kind":13,"name":"$val","line":664},{"name":"$self","containerName":"strand","kind":13,"line":665},{"line":665,"kind":12,"containerName":"strand","name":"query"},{"name":"strand","containerName":"strand","kind":12,"line":665},{"line":667,"name":"$val","containerName":"strand","kind":13},{"name":"$self","kind":13,"containerName":"strand","line":668},{"name":"hit","containerName":"strand","kind":12,"line":668},{"containerName":"strand","kind":12,"name":"strand","line":668},{"line":670,"kind":13,"containerName":"strand","name":"$val"},{"containerName":"strand","kind":13,"name":"$self","line":671},{"line":671,"kind":12,"containerName":"strand","name":"query"},{"line":671,"kind":12,"containerName":"strand","name":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":671},{"name":"hit","kind":12,"containerName":"strand","line":671},{"name":"strand","kind":12,"containerName":"strand","line":671},{"line":674,"containerName":"strand","kind":13,"name":"$self"},{"containerName":"strand","kind":12,"name":"warn","line":674}],"definition":"sub"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"start","line":692,"definition":"my"},{"definition":"my","line":693,"localvar":"my","containerName":"start","kind":13,"name":"$val"},{"kind":13,"containerName":"start","name":"$val","line":694},{"line":694,"name":"$val","kind":13,"containerName":"start"},{"line":695,"name":"$val","containerName":"start","kind":13},{"line":697,"name":"$val","containerName":"start","kind":13},{"line":698,"containerName":"start","kind":13,"name":"$self"},{"line":698,"name":"query","kind":12,"containerName":"start"},{"name":"start","containerName":"start","kind":12,"line":698},{"line":700,"name":"$val","kind":13,"containerName":"start"},{"name":"$self","containerName":"start","kind":13,"line":701},{"kind":12,"containerName":"start","name":"hit","line":701},{"line":701,"containerName":"start","kind":12,"name":"start"},{"name":"$val","containerName":"start","kind":13,"line":703},{"name":"$self","kind":13,"containerName":"start","line":704},{"line":704,"name":"query","containerName":"start","kind":12},{"name":"start","containerName":"start","kind":12,"line":704},{"name":"$self","kind":13,"containerName":"start","line":704},{"name":"hit","kind":12,"containerName":"start","line":704},{"containerName":"start","kind":12,"name":"start","line":704},{"line":707,"containerName":"start","kind":13,"name":"$self"},{"line":707,"kind":12,"containerName":"start","name":"warn"}],"containerName":"main::","name":"start","line":691,"range":{"start":{"line":691,"character":0},"end":{"line":710,"character":9999}},"kind":12},{"definition":"sub","children":[{"localvar":"my","containerName":"end","kind":13,"name":"$self","line":725,"definition":"my"},{"line":726,"name":"$val","localvar":"my","containerName":"end","kind":13,"definition":"my"},{"line":727,"name":"$val","containerName":"end","kind":13},{"kind":13,"containerName":"end","name":"$val","line":727},{"line":728,"name":"$val","kind":13,"containerName":"end"},{"line":730,"name":"$val","containerName":"end","kind":13},{"containerName":"end","kind":13,"name":"$self","line":731},{"line":731,"name":"query","containerName":"end","kind":12},{"line":731,"name":"end","kind":12,"containerName":"end"},{"containerName":"end","kind":13,"name":"$val","line":733},{"containerName":"end","kind":13,"name":"$self","line":734},{"line":734,"name":"hit","containerName":"end","kind":12},{"containerName":"end","kind":12,"name":"end","line":734},{"name":"$val","kind":13,"containerName":"end","line":736},{"line":737,"name":"$self","containerName":"end","kind":13},{"line":737,"name":"query","kind":12,"containerName":"end"},{"containerName":"end","kind":12,"name":"end","line":737},{"line":737,"kind":13,"containerName":"end","name":"$self"},{"kind":12,"containerName":"end","name":"hit","line":737},{"containerName":"end","kind":12,"name":"end","line":737},{"containerName":"end","kind":13,"name":"$self","line":740},{"line":740,"name":"warn","kind":12,"containerName":"end"}],"name":"end","containerName":"main::","line":724,"range":{"end":{"character":9999,"line":743},"start":{"line":724,"character":0}},"kind":12},{"line":757,"range":{"start":{"line":757,"character":0},"end":{"line":776,"character":9999}},"kind":12,"signature":{"label":"seq($self,$seqType)","documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'","parameters":[{"label":"$self"},{"label":"$seqType"}]},"children":[{"definition":"my","line":758,"name":"$self","localvar":"my","containerName":"seq","kind":13},{"name":"$seqType","containerName":"seq","kind":13,"line":758},{"name":"$seqType","containerName":"seq","kind":13,"line":759},{"name":"$seqType","kind":13,"containerName":"seq","line":760},{"kind":13,"containerName":"seq","name":"$seqType","line":760},{"line":761,"name":"$seqType","kind":13,"containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":762},{"line":762,"containerName":"seq","kind":12,"name":"throw"},{"localvar":"my","containerName":"seq","kind":13,"name":"$str","line":765,"definition":"my"},{"line":765,"kind":13,"containerName":"seq","name":"$self"},{"kind":12,"containerName":"seq","name":"seq_str","line":765},{"line":765,"kind":13,"containerName":"seq","name":"$seqType"},{"localvar":"my","containerName":"seq","kind":13,"name":"$id","line":767,"definition":"my"},{"kind":13,"containerName":"seq","name":"$seqType","line":767},{"line":767,"name":"$self","kind":13,"containerName":"seq"},{"line":767,"name":"query","containerName":"seq","kind":12},{"line":767,"name":"seq_id","kind":12,"containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":767},{"line":767,"kind":12,"containerName":"seq","name":"hit"},{"line":767,"name":"seq_id","kind":12,"containerName":"seq"},{"name":"new","containerName":"seq","kind":12,"line":768},{"line":768,"kind":13,"containerName":"seq","name":"$id"},{"name":"$str","containerName":"seq","kind":13,"line":769},{"containerName":"seq","kind":13,"name":"$self","line":770},{"line":770,"containerName":"seq","kind":12,"name":"start"},{"line":770,"name":"$seqType","kind":13,"containerName":"seq"},{"line":771,"name":"$self","kind":13,"containerName":"seq"},{"line":771,"name":"end","kind":12,"containerName":"seq"},{"containerName":"seq","kind":13,"name":"$seqType","line":771},{"name":"$self","containerName":"seq","kind":13,"line":772},{"name":"strand","kind":12,"containerName":"seq","line":772},{"line":772,"kind":13,"containerName":"seq","name":"$seqType"},{"kind":13,"containerName":"seq","name":"$id","line":773}],"containerName":"main::","name":"seq","definition":"sub","detail":"($self,$seqType)"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":767},{"containerName":"LocatableSeq","kind":12,"name":"Bio","line":768},{"range":{"start":{"line":796,"character":0},"end":{"character":9999,"line":813}},"kind":12,"line":796,"name":"seq_str","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"seq_str","name":"$self","line":797},{"localvar":"my","kind":13,"containerName":"seq_str","name":"$type","line":798,"definition":"my"},{"line":800,"name":"$type","kind":13,"containerName":"seq_str"},{"name":"$self","containerName":"seq_str","kind":13,"line":801},{"line":801,"name":"query_string","containerName":"seq_str","kind":12},{"line":803,"name":"$type","containerName":"seq_str","kind":13},{"line":804,"containerName":"seq_str","kind":13,"name":"$self"},{"containerName":"seq_str","kind":12,"name":"hit_string","line":804},{"name":"$type","containerName":"seq_str","kind":13,"line":806},{"name":"$self","kind":13,"containerName":"seq_str","line":807},{"kind":12,"containerName":"seq_str","name":"homology_string","line":807},{"line":810,"kind":13,"containerName":"seq_str","name":"$self"},{"line":810,"containerName":"seq_str","kind":12,"name":"warn"}],"definition":"sub"},{"line":825,"kind":12,"range":{"start":{"line":825,"character":0},"end":{"character":9999,"line":827}},"children":[{"kind":12,"containerName":"rank","name":"get_field","line":826}],"name":"rank","containerName":"main::","definition":"sub"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"matches","children":[{"line":850,"name":"$self","localvar":"my","kind":13,"containerName":"matches","definition":"my"},{"name":"@args","kind":13,"containerName":"matches","line":850},{"definition":"my","localvar":"my","containerName":"matches","kind":13,"name":"$seqType","line":851},{"name":"$beg","kind":13,"containerName":"matches","line":851},{"kind":13,"containerName":"matches","name":"$end","line":851},{"name":"$self","kind":13,"containerName":"matches","line":851},{"name":"_rearrange","containerName":"matches","kind":12,"line":851},{"line":851,"name":"@args","containerName":"matches","kind":13},{"line":852,"name":"$seqType","containerName":"matches","kind":13},{"kind":13,"containerName":"matches","name":"$seqType","line":853},{"line":853,"kind":13,"containerName":"matches","name":"$seqType"},{"containerName":"matches","localvar":"my","kind":13,"name":"@data","line":855,"definition":"my"},{"name":"$beg","kind":13,"containerName":"matches","line":856},{"name":"$end","containerName":"matches","kind":13,"line":856},{"name":"$self","containerName":"matches","kind":13,"line":856},{"name":"seq_str","containerName":"matches","kind":12,"line":856},{"line":857,"name":"@data","kind":13,"containerName":"matches"},{"line":857,"containerName":"matches","kind":13,"name":"$self"},{"line":857,"name":"num_identical","containerName":"matches","kind":12},{"name":"$self","kind":13,"containerName":"matches","line":857},{"line":857,"name":"num_conserved","containerName":"matches","kind":12},{"containerName":"matches","kind":13,"name":"$beg","line":860},{"containerName":"matches","kind":13,"name":"$end","line":861},{"name":"$start","localvar":"my","containerName":"matches","kind":13,"line":862,"definition":"my"},{"containerName":"matches","kind":13,"name":"$stop","line":862},{"kind":13,"containerName":"matches","name":"$self","line":862},{"name":"range","containerName":"matches","kind":12,"line":862},{"kind":13,"containerName":"matches","name":"$seqType","line":862},{"line":864,"name":"$beg","containerName":"matches","kind":13},{"name":"$beg","kind":13,"containerName":"matches","line":865},{"kind":13,"containerName":"matches","name":"$start","line":865},{"name":"$end","containerName":"matches","kind":13,"line":866},{"kind":13,"containerName":"matches","name":"$beg","line":866},{"kind":13,"containerName":"matches","name":"$end","line":866},{"line":868,"containerName":"matches","kind":13,"name":"$end"},{"name":"$end","kind":13,"containerName":"matches","line":869},{"name":"$stop","containerName":"matches","kind":13,"line":869},{"line":870,"name":"$beg","kind":13,"containerName":"matches"},{"line":870,"name":"$end","containerName":"matches","kind":13},{"line":870,"containerName":"matches","kind":13,"name":"$beg"},{"line":873,"name":"$end","kind":13,"containerName":"matches"},{"line":873,"kind":13,"containerName":"matches","name":"$stop"},{"line":874,"name":"$end","containerName":"matches","kind":13},{"containerName":"matches","kind":13,"name":"$stop","line":874},{"name":"$end","containerName":"matches","kind":13,"line":877},{"name":"$beg","containerName":"matches","kind":13,"line":879},{"line":879,"containerName":"matches","kind":13,"name":"$start"},{"name":"$beg","kind":13,"containerName":"matches","line":880},{"line":880,"name":"$start","containerName":"matches","kind":13},{"name":"$seq","kind":13,"localvar":"my","containerName":"matches","line":883,"definition":"my"},{"name":"$self","kind":13,"containerName":"matches","line":883},{"line":883,"name":"seq_str","kind":12,"containerName":"matches"},{"kind":13,"containerName":"matches","name":"$beg","line":883},{"kind":13,"containerName":"matches","name":"$start","line":883},{"line":883,"name":"$end","containerName":"matches","kind":13},{"line":883,"containerName":"matches","kind":13,"name":"$beg"},{"kind":13,"containerName":"matches","name":"$seq","line":885},{"line":886,"kind":13,"containerName":"matches","name":"$self"},{"name":"throw","containerName":"matches","kind":12,"line":886},{"name":"$seq","containerName":"matches","kind":13,"line":889},{"localvar":"my","containerName":"matches","kind":13,"name":"$len_cons","line":890,"definition":"my"},{"name":"$seq","containerName":"matches","kind":13,"line":890},{"line":891,"kind":13,"containerName":"matches","name":"$seq"},{"definition":"my","localvar":"my","kind":13,"containerName":"matches","name":"$len_id","line":892},{"name":"$seq","containerName":"matches","kind":13,"line":892},{"line":893,"containerName":"matches","kind":13,"name":"@data"},{"kind":13,"containerName":"matches","name":"$len_id","line":893},{"line":893,"containerName":"matches","kind":13,"name":"$len_cons"},{"line":896,"kind":13,"containerName":"matches","name":"@data"}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n\n\nsub seq {\n    my ($self, $seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    if ($seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n\t\n    my $str = $self->seq_str($seqType) || return;\n    require Bio::LocatableSeq;\n    my $id = ($seqType =~ /^q/i) ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L<seq()|seq>, L<seq_inds()|seq_inds>, B<_set_match_seq()>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if ($type =~ /^q/i) {\n        return $self->query_string(@_);\n    }\n    elsif ($type =~ /^(s)|(hi)/i) {\n        return $self->hit_string(@_);\n    }\n    elsif ($type =~ /^(ho)|(ma)/i) {\n        return $self->homology_string(@_);\n    }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)","label":"matches($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":897},"start":{"line":849,"character":0}},"line":849},{"containerName":"length","kind":12,"name":"CORE","line":885},{"line":891,"kind":12,"containerName":"length","name":"CORE"},{"kind":12,"containerName":"length","name":"CORE","line":893},{"definition":"sub","name":"n","containerName":"main::","children":[{"name":"get_field","containerName":"n","kind":12,"line":914}],"kind":12,"range":{"start":{"character":0,"line":913},"end":{"character":9999,"line":915}},"line":913},{"line":933,"kind":12,"range":{"start":{"character":0,"line":933},"end":{"character":9999,"line":947}},"signature":{"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n\n\nsub seq {\n    my ($self, $seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    if ($seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n\t\n    my $str = $self->seq_str($seqType) || return;\n    require Bio::LocatableSeq;\n    my $id = ($seqType =~ /^q/i) ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L<seq()|seq>, L<seq_inds()|seq_inds>, B<_set_match_seq()>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if ($type =~ /^q/i) {\n        return $self->query_string(@_);\n    }\n    elsif ($type =~ /^(s)|(hi)/i) {\n        return $self->hit_string(@_);\n    }\n    elsif ($type =~ /^(ho)|(ma)/i) {\n        return $self->homology_string(@_);\n    }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n\n\nsub matches {\n    my ($self, @args) = @_;\n    my($seqType, $beg, $end) = $self->_rearrange([qw(SEQ START STOP)], @args);\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n\t\n    my @data;\n    if ((!defined $beg && !defined $end) || ! $self->seq_str('match')) {\n        push @data, ($self->num_identical, $self->num_conserved);\n    }\n\telse {\n        $beg ||= 0;\n        $end ||= 0;\n        my ($start, $stop) = $self->range($seqType);\n\t\t\n        if ($beg == 0) {\n\t\t\t$beg = $start;\n\t\t\t$end = $beg+$end;\n\t\t}\n        elsif ($end == 0) {\n\t\t\t$end = $stop;\n\t\t\t$beg = $end-$beg;\n\t\t}\n\t\t\n        if ($end >= $stop) {\n\t\t\t$end = $stop;\n\t\t}\n        else {\n\t\t\t$end += 1;\n\t\t}\n        if ($beg < $start) {\n\t\t\t$beg = $start;\n\t\t}\n        \n        my $seq = substr($self->seq_str('homology'), $beg-$start, ($end-$beg));\n        \n        if (!CORE::length $seq) {\n            $self->throw(\"Undefined sub-sequence ($beg,$end). Valid range = $start - $stop\");\n        }\n        ## Get data for a substring.\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n    }\n\t\n    return @data;\n}\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit') \n Throws    : n/a\n Comments  : This is a convenience method for constructions such as\n             ($hsp->query->start, $hsp->query->end)","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"range($self,$seqType)"},"children":[{"localvar":"my","containerName":"range","kind":13,"name":"$self","line":934,"definition":"my"},{"containerName":"range","kind":13,"name":"$seqType","line":934},{"line":935,"name":"$seqType","containerName":"range","kind":13},{"definition":"my","line":937,"localvar":"my","kind":13,"containerName":"range","name":"$start"},{"kind":13,"containerName":"range","name":"$end","line":937},{"name":"$seqType","kind":13,"containerName":"range","line":938},{"line":939,"name":"$start","containerName":"range","kind":13},{"kind":13,"containerName":"range","name":"$self","line":939},{"kind":12,"containerName":"range","name":"query","line":939},{"name":"start","containerName":"range","kind":12,"line":939},{"line":940,"name":"$end","kind":13,"containerName":"range"},{"line":940,"name":"$self","containerName":"range","kind":13},{"name":"query","kind":12,"containerName":"range","line":940},{"line":940,"containerName":"range","kind":12,"name":"end"},{"containerName":"range","kind":13,"name":"$start","line":943},{"kind":13,"containerName":"range","name":"$self","line":943},{"line":943,"kind":12,"containerName":"range","name":"hit"},{"line":943,"name":"start","containerName":"range","kind":12},{"line":944,"containerName":"range","kind":13,"name":"$end"},{"line":944,"containerName":"range","kind":13,"name":"$self"},{"name":"hit","containerName":"range","kind":12,"line":944},{"line":944,"name":"end","kind":12,"containerName":"range"},{"name":"$start","kind":13,"containerName":"range","line":946},{"containerName":"range","kind":13,"name":"$end","line":946}],"name":"range","containerName":"main::","definition":"sub","detail":"($self,$seqType)"}],"version":5}