{"vars":[{"containerName":"","kind":2,"name":"base","line":77},{"containerName":"main::","name":"new","children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":92,"definition":"my"},{"line":92,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":93,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":93},{"line":93,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":94,"name":"$qgaplocs","containerName":"new","localvar":"my","kind":13},{"kind":13,"containerName":"new","name":"$hgaplocs","line":95},{"containerName":"new","kind":13,"name":"$mismatches","line":96},{"containerName":"new","kind":13,"name":"$self","line":96},{"line":96,"containerName":"new","kind":12,"name":"_rearrange"},{"line":99,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":100},{"containerName":"new","kind":12,"name":"gap_blocks","line":100},{"line":100,"kind":13,"containerName":"new","name":"$qgaplocs"},{"name":"$qgaplocs","containerName":"new","kind":13,"line":100},{"name":"$self","containerName":"new","kind":13,"line":101},{"name":"gap_blocks","containerName":"new","kind":12,"line":101},{"name":"$hgaplocs","containerName":"new","kind":13,"line":101},{"line":101,"kind":13,"containerName":"new","name":"$hgaplocs"},{"line":102,"containerName":"new","kind":13,"name":"$self"},{"line":102,"name":"mismatches","containerName":"new","kind":12},{"name":"$mismatches","kind":13,"containerName":"new","line":102},{"containerName":"new","kind":13,"name":"$mismatches","line":102},{"line":103,"name":"$self","kind":13,"containerName":"new"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"start":{"line":91,"character":0},"end":{"character":9999,"line":104}},"line":91,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: PSLHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PSLHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PSLHSP - A HSP for PSL output\n\n=head1 SYNOPSIS\n\n  # get a PSLHSP somehow (SearchIO::psl)\n\n=head1 DESCRIPTION\n\nThis is a HSP for PSL output so we can handle seq_inds differently.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::PSLHSP;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::PSLHSP->new();\n Function: Builds a new Bio::Search::HSP::PSLHSP object \n Returns : an instance of Bio::Search::HSP::PSLHSP\n Args    : -gapblocks => arrayref of gap locations which are [start,length]\n                         of gaps","parameters":[{"label":"$class"},{"label":"@args"}]}},{"containerName":"new","kind":12,"name":"SUPER","line":93},{"containerName":"main::","name":"gap_blocks","children":[{"definition":"my","line":119,"name":"$self","localvar":"my","containerName":"gap_blocks","kind":13},{"line":119,"name":"$seqtype","kind":13,"containerName":"gap_blocks"},{"line":119,"containerName":"gap_blocks","kind":13,"name":"$blocks"},{"containerName":"gap_blocks","kind":13,"name":"$seqtype","line":120},{"line":120,"kind":13,"containerName":"gap_blocks","name":"$seqtype"},{"line":121,"containerName":"gap_blocks","kind":13,"name":"$seqtype"},{"kind":13,"containerName":"gap_blocks","name":"$seqtype","line":121},{"line":122,"kind":13,"containerName":"gap_blocks","name":"$seqtype"},{"line":122,"containerName":"gap_blocks","kind":13,"name":"$seqtype"},{"kind":13,"containerName":"gap_blocks","name":"$seqtype","line":123},{"name":"$self","kind":13,"containerName":"gap_blocks","line":124},{"containerName":"gap_blocks","kind":12,"name":"warn","line":124},{"name":"$blocks","kind":13,"containerName":"gap_blocks","line":127},{"containerName":"gap_blocks","kind":13,"name":"$self","line":128},{"line":128,"name":"$seqtype","containerName":"gap_blocks","kind":13},{"line":130,"kind":13,"containerName":"gap_blocks","name":"$self"},{"line":130,"name":"$seqtype","kind":13,"containerName":"gap_blocks"},{"line":130,"kind":13,"containerName":"gap_blocks","name":"$blocks"}],"detail":"($self,$seqtype,$blocks)","definition":"sub","range":{"end":{"character":9999,"line":132},"start":{"line":118,"character":0}},"kind":12,"line":118,"signature":{"label":"gap_blocks($self,$seqtype,$blocks)","parameters":[{"label":"$self"},{"label":"$seqtype"},{"label":"$blocks"}],"documentation":"1;\n# $Id: PSLHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PSLHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PSLHSP - A HSP for PSL output\n\n=head1 SYNOPSIS\n\n  # get a PSLHSP somehow (SearchIO::psl)\n\n=head1 DESCRIPTION\n\nThis is a HSP for PSL output so we can handle seq_inds differently.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::PSLHSP;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::PSLHSP->new();\n Function: Builds a new Bio::Search::HSP::PSLHSP object \n Returns : an instance of Bio::Search::HSP::PSLHSP\n Args    : -gapblocks => arrayref of gap locations which are [start,length]\n                         of gaps\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($qgaplocs,\n\t$hgaplocs,\n\t$mismatches) = $self->_rearrange([qw(QUERY_GAPBLOCKS\n\t\t\t\t\t     HIT_GAPBLOCKS\n\t\t\t\t\t     MISMATCHES)],\n\t\t\t\t       @args);\n    $self->gap_blocks('query',$qgaplocs) if defined $qgaplocs;\n    $self->gap_blocks('hit',  $hgaplocs) if defined $hgaplocs;\n    $self->mismatches($mismatches) if defined $mismatches;\n    return $self;\n}\n\n=head2 gap_blocks\n\n Title   : gap_blocks\n Usage   : $obj->gap_blocks($seqtype,$blocks)\n Function: Get/Set the gap blocks\n Returns : value of gap_blocks (a scalar)\n Args    : sequence type - 'query' or 'hit'\n           blocks - arrayref of block start,length"}},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"mismatches","localvar":"my","kind":13,"line":146},{"name":"$self","kind":13,"containerName":"mismatches","line":147},{"kind":13,"containerName":"mismatches","name":"$self","line":148}],"name":"mismatches","containerName":"main::","line":145,"kind":12,"range":{"end":{"character":9999,"line":149},"start":{"line":145,"character":0}}}],"version":5}