{"vars":[{"line":79,"kind":2,"containerName":"","name":"vars"},{"kind":2,"containerName":"","name":"base","line":89},{"definition":"sub","name":"read","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"read","line":102,"definition":"my"},{"definition":"my","line":104,"name":"$renzs","localvar":"my","containerName":"read","kind":13},{"line":104,"containerName":"read","kind":12,"name":"new"},{"line":107,"kind":13,"localvar":"my","containerName":"read","name":"$entry","definition":"my"},{"name":"$self","kind":13,"containerName":"read","line":107},{"name":"_readline","containerName":"read","kind":12,"line":107},{"line":108,"containerName":"read","kind":13,"name":"$self"},{"containerName":"read","kind":12,"name":"debug","line":108},{"definition":"my","line":113,"name":"$name","kind":13,"localvar":"my","containerName":"read"},{"line":113,"containerName":"read","kind":13,"name":"$entry"},{"containerName":"read","localvar":"my","kind":13,"name":"$site","line":114,"definition":"my"},{"kind":13,"containerName":"read","name":"$entry","line":114},{"containerName":"read","kind":13,"name":"$name","line":115},{"line":115,"kind":13,"containerName":"read","name":"$site"},{"definition":"my","line":125,"name":"@sequences","kind":13,"localvar":"my","containerName":"read"},{"kind":13,"containerName":"read","name":"$site","line":126},{"line":127,"kind":13,"containerName":"read","name":"@sequences"},{"containerName":"read","kind":13,"name":"$site","line":127},{"containerName":"read","kind":13,"name":"$self","line":128},{"line":128,"containerName":"read","kind":12,"name":"debug"},{"line":128,"name":"@sequences","kind":13,"containerName":"read"},{"containerName":"read","kind":13,"name":"$site","line":129},{"kind":13,"containerName":"read","name":"@sequences","line":129},{"definition":"my","localvar":"my","containerName":"read","kind":13,"name":"$seq","line":132},{"line":132,"name":"$cut","containerName":"read","kind":13},{"kind":13,"containerName":"read","name":"$site","line":132},{"name":"$self","containerName":"read","kind":13,"line":133},{"line":133,"kind":12,"containerName":"read","name":"debug"},{"line":134,"name":"$seq","containerName":"read","kind":13},{"line":135,"name":"$self","kind":13,"containerName":"read"},{"line":135,"name":"warn","containerName":"read","kind":12},{"line":135,"kind":13,"containerName":"read","name":"$self"},{"kind":12,"containerName":"read","name":"verbose","line":135},{"containerName":"read","kind":13,"name":"$seq","line":140},{"line":141,"containerName":"read","kind":13,"name":"$self"},{"line":141,"containerName":"read","kind":12,"name":"throw"},{"name":"$re","localvar":"my","containerName":"read","kind":13,"line":143,"definition":"my"},{"line":144,"containerName":"read","kind":13,"name":"$cut"},{"name":"$re","containerName":"read","kind":13,"line":145},{"name":"new","containerName":"read","kind":12,"line":145},{"line":145,"name":"$name","containerName":"read","kind":13},{"line":145,"name":"$seq","containerName":"read","kind":13},{"line":148,"kind":13,"containerName":"read","name":"$cut"},{"containerName":"read","kind":13,"name":"$self","line":149},{"line":149,"containerName":"read","kind":12,"name":"throw"},{"kind":13,"containerName":"read","name":"$re","line":152},{"name":"new","containerName":"read","kind":12,"line":152},{"name":"$name","kind":13,"containerName":"read","line":152},{"line":153,"name":"$cut","containerName":"read","kind":13},{"kind":13,"containerName":"read","name":"$seq","line":155},{"line":157,"name":"$renzs","kind":13,"containerName":"read"},{"containerName":"read","kind":12,"name":"enzymes","line":157},{"line":157,"name":"$re","kind":13,"containerName":"read"},{"name":"$prototype","localvar":"my","kind":13,"containerName":"read","line":162,"definition":"my"},{"name":"$entry","containerName":"read","kind":13,"line":162},{"line":164,"name":"$prototype","containerName":"read","kind":13},{"line":167,"name":"$re","containerName":"read","kind":13},{"line":167,"containerName":"read","kind":12,"name":"is_prototype"},{"line":169,"kind":13,"containerName":"read","name":"$re"},{"name":"is_prototype","kind":12,"containerName":"read","line":169},{"localvar":"my","kind":13,"containerName":"read","name":"$meth","line":176,"definition":"my"},{"line":176,"containerName":"read","kind":13,"name":"$entry"},{"line":177,"name":"@meths","containerName":"read","localvar":"my","kind":13,"definition":"my"},{"line":178,"kind":13,"containerName":"read","name":"$meth"},{"line":181,"containerName":"read","kind":13,"name":"$meth"},{"containerName":"read","kind":13,"name":"$re","line":183},{"kind":12,"containerName":"read","name":"methylation_sites","line":183},{"line":183,"kind":13,"containerName":"read","name":"$self"},{"line":183,"name":"_meth","containerName":"read","kind":12},{"name":"$re","kind":13,"containerName":"read","line":183},{"line":184,"name":"$self","kind":13,"containerName":"read"},{"line":184,"kind":12,"containerName":"read","name":"_meth"},{"line":184,"kind":13,"containerName":"read","name":"$re"},{"line":186,"kind":13,"containerName":"read","name":"$meth"},{"name":"$re","containerName":"read","kind":13,"line":188},{"line":188,"name":"methylation_sites","containerName":"read","kind":12},{"line":188,"name":"$self","containerName":"read","kind":13},{"line":188,"name":"_meth","kind":12,"containerName":"read"},{"name":"$re","containerName":"read","kind":13,"line":188},{"line":189,"kind":13,"containerName":"read","name":"@meths"},{"containerName":"read","kind":13,"name":"$meth","line":189},{"containerName":"read","kind":13,"name":"$meth","line":190},{"line":190,"name":"@meths","containerName":"read","kind":13},{"line":192,"kind":13,"containerName":"read","name":"$self"},{"name":"warn","containerName":"read","kind":12,"line":192},{"kind":13,"containerName":"read","name":"$self","line":192},{"line":192,"containerName":"read","kind":12,"name":"verbose"},{"name":"$microbe","localvar":"my","kind":13,"containerName":"read","line":199,"definition":"my"},{"kind":13,"containerName":"read","name":"$entry","line":199},{"line":200,"name":"$re","kind":13,"containerName":"read"},{"line":200,"name":"microbe","containerName":"read","kind":12},{"name":"$microbe","containerName":"read","kind":13,"line":200},{"line":200,"containerName":"read","kind":13,"name":"$microbe"},{"line":211,"localvar":"my","containerName":"read","kind":13,"name":"$vendors","definition":"my"},{"line":211,"name":"$entry","containerName":"read","kind":13},{"line":212,"name":"$re","containerName":"read","kind":13},{"containerName":"read","kind":12,"name":"vendors","line":212},{"containerName":"read","kind":13,"name":"$vendors","line":212},{"name":"$vendors","containerName":"read","kind":13,"line":212},{"line":223,"containerName":"read","kind":13,"name":"$self"},{"line":223,"kind":12,"containerName":"read","name":"warn"},{"containerName":"read","kind":13,"name":"@sequences","line":224},{"line":229,"containerName":"read","kind":13,"name":"$renzs"}],"kind":12,"range":{"end":{"character":9999,"line":230},"start":{"character":0,"line":101}},"line":101},{"name":"Bio","containerName":"Restriction::EnzymeCollection","kind":12,"line":104},{"line":145,"name":"Bio","containerName":"Restriction::Enzyme","kind":12},{"line":152,"kind":12,"containerName":"Restriction::Enzyme","name":"Bio"},{"definition":"sub","detail":"($self,@h)","children":[{"definition":"my","line":245,"name":"$self","kind":13,"localvar":"my","containerName":"write"},{"containerName":"write","kind":13,"name":"@h","line":245},{"containerName":"write","kind":13,"name":"$self","line":246},{"line":246,"containerName":"write","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"write","signature":{"parameters":[{"label":"$self"},{"label":"@h"}],"documentation":"1;\n# $Id: bairoch.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Restriction::IO::withrefm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO::bairoch - bairoch enzyme set\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::Restriction::IO class.\n\n=head1 DESCRIPTION\n\nThis is the most complete format of the REBASE files, and basically\nincludes all the data on each of the restriction enzymes.\n\nThis parser is for the Bairoch format (aka MacVector, Vector NTI, PC/Gene \n(Bairoch) format), REBASE format #19\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO::bairoch;\n\nuse vars qw(%WITH_REFM_FIELD);\nuse strict;\n\nuse Bio::Restriction::Enzyme;\nuse Bio::Restriction::Enzyme::MultiCut;\nuse Bio::Restriction::Enzyme::MultiSite;\nuse Bio::Restriction::EnzymeCollection;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Restriction::IO::base);\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::Restriction object\n Args    : none\n\n\nsub read {\n    my $self = shift;\n\n    my $renzs = Bio::Restriction::EnzymeCollection->new(-empty => 1);\n\n    local $/ = '//';\n    while (defined(my $entry=$self->_readline()) ) {\n        $self->debug(\"|$entry|\\n\");\n\n        #\n        # Minimal information\n        #\n        my ($name) = $entry =~ /ID\\s+(\\S+)/;\n        my ($site) = $entry =~ /RS\\s+([^\\n]+)/;\n        next unless ($name && $site);\n       \n        # the standard sequence format for these guys is:\n        # GATC, 2;\n        # or, for enzymes that cut more than once\n        # GATC, 2; GTAC, 2; \n\n        # there are a couple of sequences that have multiple\n        # recognition sites. \n\n        my @sequences;\n        if ($site =~ /\\;/) {\n            @sequences = split /\\;/, $site;\n            $self->debug(@sequences,\"\\n\");\n            $site=shift @sequences;\n        }\n        \n        my ($seq, $cut)=split /,\\s+/, $site;\n        $self->debug(\"SITE: |$site| GAVE: |$seq| and |$cut|\\n\");\n        if ($seq eq '?') {\n           $self->warn(\"$name: no site. Skipping\") if $self->verbose > 1;\n           next;\n        }\n        \n            # this is mainly an error check to make sure that I am adding what I think I am!\t\n        if ($seq !~ /[NGATC]/i) {\n          $self->throw(\"Sequence $name has weird sequence: |$seq|\");\n        }\n        my $re;\n        if ($cut eq \"?\") {\n              $re = Bio::Restriction::Enzyme->new(-name=>$name, -seq => $seq);\n        }\n        else {\n               if ($cut !~ /^-?\\d+$/) {\n             $self->throw(\"Cut site from $name is weird: |$cut|\\n\");\n               }\n        \n               $re = Bio::Restriction::Enzyme->new(-name=>$name,\n                                                  -cut => $cut,\n                                                  -seq => $seq\n                                                  );\n        }\n        $renzs->enzymes($re);\n\n        #\n        # prototype / isoschizomers\n        #\n        my ($prototype) = $entry =~ /PT\\s+([^\\n]+)/;\n\n        if ($prototype) {\n            #$re->isoschizomers(split /\\,/, $isoschizomers);\n            #NOTE: Need to add a method so that we can add isoschosomers to enzymes that may not exist!\n\t    $re->is_prototype(0);\n        } else {\n            $re->is_prototype(1);\n        }\n\n        #\n        # methylation\n        #\n\n        my ($meth) = $entry =~ /MS\\s+([^\\n]+)/;\n        my @meths;\n        if ($meth) {\n            # this can be either X(Y) or X(Y),X2(Y2)\n            # where X is the base and y is the type of methylation\n            if ( $meth =~ /(\\S+)\\((\\d+)\\),(\\S+)\\((\\d+)\\)/ ) { # two msites per site\n                #my ($p1, $m1, $p2, $m2) = ($1, $2, $3, $4);\n                $re->methylation_sites($self->_meth($re,$1, $2),\n                                       $self->_meth($re,$3,$4));\n            }\n            elsif ($meth =~ /(\\S+)\\((\\d+)\\)/ ) { # one msite per site or more sites\n                #print Dumper $meth;\n                $re->methylation_sites( $self->_meth($re,$1,$2) );\n                @meths = split /, /, $meth;\n                $meth=shift @meths;\n            } else {\n                $self->warn(\"Unknown methylation format [$meth]\") if $self->verbose >0;\n            }\n        }\n\n        #\n        # microbe\n        #\n        my ($microbe) = $entry =~ /OS\\s+([^\\n]+)/;\n        $re->microbe($microbe) if $microbe;\n\n        #\n        # source\n        #\n        #my ($source) = $entry =~ /<6>([^\\n]+)/;\n        #$re->source($source) if $source;\n\n        #\n        # vendors\n        #\n        my ($vendors) = $entry =~ /CR\\s+([^\\n]+)/;\n        $re->vendors(split /,\\s*/, $vendors) if $vendors;\n\n        #\n        # references\n        #\n        #my ($refs) = $entry =~ /<8>(.+)/s;\n        #$re->references(map {split /\\n+/} $refs) if $refs;\n\n        #\n        # create special types of Enzymes\n        #\n        $self->warn(\"Current issues with multisite enzymes using bairoch format\\n\".\n                    \"Recommend using itype2 or withrefm formats for now\") if @sequences;\n        #$self->_make_multisites($renzs, $re, \\@sequences, \\@meths) if @sequences;\n\n    }\n\n    return $renzs;\n}\n\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($renzs)\n Function: writes restriction enzymes into the stream\n Returns : 1 for success and 0 for error\n Args    : a Bio::Restriction::Enzyme\n           or a Bio::Restriction::EnzymeCollection object","label":"write($self,@h)"},"line":244,"range":{"start":{"character":0,"line":244},"end":{"line":247,"character":9999}},"kind":12}],"version":5}