{"version":5,"vars":[{"line":173,"name":"in_label","containerName":"main::","kind":14,"definition":1},{"line":173,"name":"strict","kind":12,"containerName":""},{"line":174,"kind":12,"name":"out_label"},{"line":175,"kind":12,"name":"non_syn"},{"name":"syn","kind":12,"line":176},{"line":177,"kind":12,"name":"default_codon_table"},{"kind":2,"containerName":"Bio::MolEvol::CodonModel::List","name":"Util","line":181},{"line":183,"containerName":"","kind":2,"name":"base"},{"line":184,"name":"$codon_table","kind":13,"containerName":"main::","definition":"our"},{"line":184,"name":"default_codon_table","kind":12},{"definition":"our","line":185,"kind":13,"containerName":"main::","name":"%has_twotailed"},{"line":188,"containerName":"NSP::Measures::Fisher2::twotailed","kind":12,"name":"Text"},{"line":188,"name":"%has_twotailed","containerName":null,"kind":13},{"line":189,"kind":13,"containerName":null,"name":"$has_twotailed"},{"line":226,"kind":12,"range":{"start":{"character":0,"line":226},"end":{"character":9999,"line":260}},"signature":{"label":"fu_and_li_D($self,$ingroup,$outgroup)","parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals"},"children":[{"line":227,"localvar":"my","containerName":"fu_and_li_D","kind":13,"name":"$self","definition":"my"},{"name":"$ingroup","kind":13,"containerName":"fu_and_li_D","line":227},{"line":227,"name":"$outgroup","containerName":"fu_and_li_D","kind":13},{"definition":"my","name":"$seg_sites","localvar":"my","kind":13,"containerName":"fu_and_li_D","line":229},{"line":229,"name":"$n","kind":13,"containerName":"fu_and_li_D"},{"line":229,"kind":13,"containerName":"fu_and_li_D","name":"$ancestral"},{"line":229,"kind":13,"containerName":"fu_and_li_D","name":"$derived"},{"kind":13,"containerName":"fu_and_li_D","name":"$ingroup","line":230},{"name":"$n","containerName":"fu_and_li_D","kind":13,"line":231},{"line":231,"kind":13,"containerName":"fu_and_li_D","name":"$ingroup"},{"line":233,"containerName":"fu_and_li_D","kind":13,"name":"$seg_sites"},{"line":233,"containerName":"fu_and_li_D","kind":13,"name":"$self"},{"line":233,"containerName":"fu_and_li_D","kind":12,"name":"segregating_sites_count"},{"line":233,"containerName":"fu_and_li_D","kind":13,"name":"$ingroup"},{"line":234,"name":"$ingroup","containerName":"fu_and_li_D","kind":13},{"line":235,"containerName":"fu_and_li_D","kind":13,"name":"$ingroup"},{"name":"isa","kind":12,"containerName":"fu_and_li_D","line":235},{"line":236,"kind":13,"containerName":"fu_and_li_D","name":"$n"},{"name":"$ingroup","kind":13,"containerName":"fu_and_li_D","line":236},{"name":"get_number_individuals","containerName":"fu_and_li_D","kind":12,"line":236},{"name":"$seg_sites","containerName":"fu_and_li_D","kind":13,"line":237},{"kind":13,"containerName":"fu_and_li_D","name":"$self","line":237},{"name":"segregating_sites_count","kind":12,"containerName":"fu_and_li_D","line":237},{"name":"$ingroup","kind":13,"containerName":"fu_and_li_D","line":237},{"line":239,"name":"$self","containerName":"fu_and_li_D","kind":13},{"line":239,"containerName":"fu_and_li_D","kind":12,"name":"throw"},{"line":243,"containerName":"fu_and_li_D","kind":13,"name":"$seg_sites"},{"kind":13,"containerName":"fu_and_li_D","name":"$self","line":244},{"line":244,"name":"warn","kind":12,"containerName":"fu_and_li_D"},{"line":248,"kind":13,"containerName":"fu_and_li_D","name":"$outgroup"},{"line":249,"kind":13,"containerName":"fu_and_li_D","name":"$self"},{"line":249,"name":"warn","containerName":"fu_and_li_D","kind":12},{"line":251,"containerName":"fu_and_li_D","kind":13,"name":"$outgroup"},{"name":"$ancestral","kind":13,"containerName":"fu_and_li_D","line":252},{"line":252,"name":"$derived","kind":13,"containerName":"fu_and_li_D"},{"kind":13,"containerName":"fu_and_li_D","name":"$self","line":252},{"name":"derived_mutations","containerName":"fu_and_li_D","kind":12,"line":252},{"line":252,"kind":13,"containerName":"fu_and_li_D","name":"$ingroup"},{"line":252,"name":"$outgroup","kind":13,"containerName":"fu_and_li_D"},{"containerName":"fu_and_li_D","kind":13,"name":"$ancestral","line":253},{"name":"$ancestral","kind":13,"containerName":"fu_and_li_D","line":253},{"name":"$ancestral","containerName":"fu_and_li_D","kind":13,"line":255},{"line":255,"containerName":"fu_and_li_D","kind":13,"name":"$outgroup"},{"containerName":"fu_and_li_D","kind":13,"name":"$self","line":258},{"containerName":"fu_and_li_D","kind":12,"name":"fu_and_li_D_counts","line":258},{"line":258,"name":"$n","containerName":"fu_and_li_D","kind":13},{"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D","line":258},{"line":259,"kind":13,"containerName":"fu_and_li_D","name":"$ancestral"},{"name":"$derived","containerName":"fu_and_li_D","kind":13,"line":259}],"containerName":"main::","name":"fu_and_li_D","definition":"sub","detail":"($self,$ingroup,$outgroup)"},{"line":277,"kind":12,"range":{"start":{"character":0,"line":277},"end":{"line":300,"character":9999}},"signature":{"label":"fu_and_li_D_counts($self,$n,$seg_sites,$external_mut)","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$external_mut"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)"},"children":[{"definition":"my","line":278,"localvar":"my","containerName":"fu_and_li_D_counts","kind":13,"name":"$self"},{"kind":13,"containerName":"fu_and_li_D_counts","name":"$n","line":278},{"line":278,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D_counts"},{"kind":13,"containerName":"fu_and_li_D_counts","name":"$external_mut","line":278},{"definition":"my","localvar":"my","kind":13,"containerName":"fu_and_li_D_counts","name":"$a_n","line":279},{"line":280,"localvar":"my","kind":13,"containerName":"fu_and_li_D_counts","name":"$k","definition":"my"},{"kind":13,"containerName":"fu_and_li_D_counts","name":"$k","line":280},{"line":280,"containerName":"fu_and_li_D_counts","kind":13,"name":"$n"},{"line":280,"kind":13,"containerName":"fu_and_li_D_counts","name":"$k"},{"name":"$a_n","containerName":"fu_and_li_D_counts","kind":13,"line":281},{"kind":13,"containerName":"fu_and_li_D_counts","name":"$k","line":281},{"definition":"my","name":"$b","kind":13,"localvar":"my","containerName":"fu_and_li_D_counts","line":283},{"definition":"my","localvar":"my","kind":13,"containerName":"fu_and_li_D_counts","name":"$k","line":284},{"name":"$k","kind":13,"containerName":"fu_and_li_D_counts","line":284},{"line":284,"containerName":"fu_and_li_D_counts","kind":13,"name":"$n"},{"name":"$k","containerName":"fu_and_li_D_counts","kind":13,"line":284},{"line":285,"name":"$b","containerName":"fu_and_li_D_counts","kind":13},{"line":285,"containerName":"fu_and_li_D_counts","kind":13,"name":"$k"},{"definition":"my","name":"$c","localvar":"my","containerName":"fu_and_li_D_counts","kind":13,"line":288},{"line":288,"kind":13,"containerName":"fu_and_li_D_counts","name":"$n"},{"line":288,"kind":13,"containerName":"fu_and_li_D_counts","name":"$a_n"},{"line":288,"name":"$n","kind":13,"containerName":"fu_and_li_D_counts"},{"line":289,"containerName":"fu_and_li_D_counts","kind":13,"name":"$n"},{"line":289,"name":"$n","containerName":"fu_and_li_D_counts","kind":13},{"line":291,"kind":13,"localvar":"my","containerName":"fu_and_li_D_counts","name":"$v","definition":"my"},{"line":291,"kind":13,"containerName":"fu_and_li_D_counts","name":"$a_n"},{"name":"$b","containerName":"fu_and_li_D_counts","kind":13,"line":291},{"name":"$a_n","kind":13,"containerName":"fu_and_li_D_counts","line":291},{"name":"$c","kind":13,"containerName":"fu_and_li_D_counts","line":292},{"name":"$n","kind":13,"containerName":"fu_and_li_D_counts","line":292},{"containerName":"fu_and_li_D_counts","kind":13,"name":"$n","line":293},{"line":295,"name":"$u","localvar":"my","containerName":"fu_and_li_D_counts","kind":13,"definition":"my"},{"line":295,"name":"$a_n","containerName":"fu_and_li_D_counts","kind":13},{"name":"$v","kind":13,"containerName":"fu_and_li_D_counts","line":295},{"line":297,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D_counts"},{"kind":13,"containerName":"fu_and_li_D_counts","name":"$a_n","line":297},{"name":"$external_mut","kind":13,"containerName":"fu_and_li_D_counts","line":297},{"line":298,"name":"$u","containerName":"fu_and_li_D_counts","kind":13},{"line":298,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D_counts"},{"line":298,"containerName":"fu_and_li_D_counts","kind":13,"name":"$v"},{"line":298,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D_counts"},{"line":298,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_D_counts"}],"containerName":"main::","name":"fu_and_li_D_counts","definition":"sub","detail":"($self,$n,$seg_sites,$external_mut)"},{"kind":12,"range":{"start":{"character":0,"line":319},"end":{"character":9999,"line":339}},"line":319,"signature":{"label":"fu_and_li_D_star($self,$individuals)","parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n'\n fu_and_li_D*"},"containerName":"main::","name":"fu_and_li_D_star","children":[{"kind":13,"localvar":"my","containerName":"fu_and_li_D_star","name":"$self","line":320,"definition":"my"},{"containerName":"fu_and_li_D_star","kind":13,"name":"$individuals","line":320},{"line":322,"name":"$seg_sites","containerName":"fu_and_li_D_star","localvar":"my","kind":13,"definition":"my"},{"line":322,"kind":13,"containerName":"fu_and_li_D_star","name":"$n"},{"kind":13,"containerName":"fu_and_li_D_star","name":"$singletons","line":322},{"line":323,"containerName":"fu_and_li_D_star","kind":13,"name":"$individuals"},{"line":324,"kind":13,"containerName":"fu_and_li_D_star","name":"$n"},{"kind":13,"containerName":"fu_and_li_D_star","name":"$individuals","line":324},{"line":325,"containerName":"fu_and_li_D_star","kind":13,"name":"$seg_sites"},{"name":"$self","containerName":"fu_and_li_D_star","kind":13,"line":325},{"line":325,"containerName":"fu_and_li_D_star","kind":12,"name":"segregating_sites_count"},{"kind":13,"containerName":"fu_and_li_D_star","name":"$individuals","line":325},{"line":326,"containerName":"fu_and_li_D_star","kind":13,"name":"$singletons"},{"name":"$self","kind":13,"containerName":"fu_and_li_D_star","line":326},{"containerName":"fu_and_li_D_star","kind":12,"name":"singleton_count","line":326},{"kind":13,"containerName":"fu_and_li_D_star","name":"$individuals","line":326},{"line":327,"containerName":"fu_and_li_D_star","kind":13,"name":"$individuals"},{"line":328,"name":"$individuals","kind":13,"containerName":"fu_and_li_D_star"},{"containerName":"fu_and_li_D_star","kind":12,"name":"isa","line":328},{"name":"$pop","kind":13,"localvar":"my","containerName":"fu_and_li_D_star","line":329,"definition":"my"},{"line":329,"name":"$individuals","kind":13,"containerName":"fu_and_li_D_star"},{"name":"$n","kind":13,"containerName":"fu_and_li_D_star","line":330},{"name":"$pop","containerName":"fu_and_li_D_star","kind":13,"line":330},{"line":330,"name":"get_number_individuals","kind":12,"containerName":"fu_and_li_D_star"},{"containerName":"fu_and_li_D_star","kind":13,"name":"$seg_sites","line":331},{"line":331,"containerName":"fu_and_li_D_star","kind":13,"name":"$self"},{"line":331,"name":"segregating_sites_count","containerName":"fu_and_li_D_star","kind":12},{"line":331,"name":"$pop","containerName":"fu_and_li_D_star","kind":13},{"kind":13,"containerName":"fu_and_li_D_star","name":"$singletons","line":332},{"name":"$self","containerName":"fu_and_li_D_star","kind":13,"line":332},{"name":"singleton_count","kind":12,"containerName":"fu_and_li_D_star","line":332},{"line":332,"kind":13,"containerName":"fu_and_li_D_star","name":"$pop"},{"name":"$self","containerName":"fu_and_li_D_star","kind":13,"line":334},{"name":"throw","containerName":"fu_and_li_D_star","kind":12,"line":334},{"line":338,"containerName":"fu_and_li_D_star","kind":13,"name":"$self"},{"name":"fu_and_li_D_star_counts","containerName":"fu_and_li_D_star","kind":12,"line":338},{"containerName":"fu_and_li_D_star","kind":13,"name":"$n","line":338},{"line":338,"kind":13,"containerName":"fu_and_li_D_star","name":"$seg_sites"},{"line":338,"name":"$singletons","containerName":"fu_and_li_D_star","kind":13}],"detail":"($self,$individuals)","definition":"sub"},{"containerName":"main::","name":"fu_and_li_D_star_counts","children":[{"definition":"my","line":358,"name":"$self","kind":13,"localvar":"my","containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$n","line":358},{"name":"$seg_sites","containerName":"fu_and_li_D_star_counts","kind":13,"line":358},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$singletons","line":358},{"definition":"my","line":359,"kind":13,"localvar":"my","containerName":"fu_and_li_D_star_counts","name":"$a_n"},{"line":360,"name":"$k","localvar":"my","containerName":"fu_and_li_D_star_counts","kind":13,"definition":"my"},{"line":360,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$k"},{"line":360,"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$k","line":360},{"line":361,"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13},{"name":"$k","kind":13,"containerName":"fu_and_li_D_star_counts","line":361},{"line":364,"containerName":"fu_and_li_D_star_counts","localvar":"my","kind":13,"name":"$a1","definition":"my"},{"line":364,"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13},{"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13,"line":364},{"definition":"my","localvar":"my","containerName":"fu_and_li_D_star_counts","kind":13,"name":"$b","line":366},{"line":367,"name":"$k","kind":13,"localvar":"my","containerName":"fu_and_li_D_star_counts","definition":"my"},{"name":"$k","kind":13,"containerName":"fu_and_li_D_star_counts","line":367},{"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13,"line":367},{"line":367,"name":"$k","kind":13,"containerName":"fu_and_li_D_star_counts"},{"line":368,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$b"},{"line":368,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$k"},{"line":371,"name":"$c","localvar":"my","containerName":"fu_and_li_D_star_counts","kind":13,"definition":"my"},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n","line":371},{"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13,"line":371},{"line":371,"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts"},{"line":372,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$n"},{"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts","line":372},{"definition":"my","localvar":"my","kind":13,"containerName":"fu_and_li_D_star_counts","name":"$d","line":374},{"line":374,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$c"},{"line":374,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$n"},{"line":374,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n"},{"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts","line":375},{"line":376,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$a1"},{"line":376,"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13},{"line":377,"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13},{"definition":"my","line":379,"name":"$v_star","localvar":"my","kind":13,"containerName":"fu_and_li_D_star_counts"},{"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts","line":379},{"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13,"line":379},{"line":379,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$b"},{"line":379,"name":"$a_n","kind":13,"containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$d","line":379},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$n","line":380},{"name":"$a_n","kind":13,"containerName":"fu_and_li_D_star_counts","line":380},{"name":"$a_n","kind":13,"containerName":"fu_and_li_D_star_counts","line":380},{"line":380,"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts"},{"name":"$a_n","kind":13,"containerName":"fu_and_li_D_star_counts","line":381},{"line":381,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$b"},{"definition":"my","line":383,"localvar":"my","containerName":"fu_and_li_D_star_counts","kind":13,"name":"$u_star"},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n","line":383},{"line":383,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$n"},{"line":384,"name":"$a_n","kind":13,"containerName":"fu_and_li_D_star_counts"},{"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13,"line":384},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n","line":385},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$v_star","line":385},{"line":388,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n"},{"name":"$n","kind":13,"containerName":"fu_and_li_D_star_counts","line":388},{"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$seg_sites","line":388},{"line":389,"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13},{"line":389,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$singletons"},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$u_star","line":390},{"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$seg_sites","line":390},{"name":"$v_star","containerName":"fu_and_li_D_star_counts","kind":13,"line":390},{"line":390,"containerName":"fu_and_li_D_star_counts","kind":13,"name":"$seg_sites"},{"line":390,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$seg_sites"}],"detail":"($self,$n,$seg_sites,$singletons)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":357},"end":{"line":391,"character":9999}},"line":357,"signature":{"parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$singletons"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)","label":"fu_and_li_D_star_counts($self,$n,$seg_sites,$singletons)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n'","label":"fu_and_li_F($self,$ingroup,$outgroup)"},"line":409,"kind":12,"range":{"end":{"character":9999,"line":436},"start":{"line":409,"character":0}},"definition":"sub","detail":"($self,$ingroup,$outgroup)","children":[{"definition":"my","line":410,"containerName":"fu_and_li_F","localvar":"my","kind":13,"name":"$self"},{"line":410,"name":"$ingroup","containerName":"fu_and_li_F","kind":13},{"name":"$outgroup","kind":13,"containerName":"fu_and_li_F","line":410},{"definition":"my","line":411,"name":"$seg_sites","kind":13,"localvar":"my","containerName":"fu_and_li_F"},{"line":411,"kind":13,"containerName":"fu_and_li_F","name":"$pi"},{"containerName":"fu_and_li_F","kind":13,"name":"$n","line":411},{"kind":13,"containerName":"fu_and_li_F","name":"$external","line":411},{"line":411,"name":"$internal","kind":13,"containerName":"fu_and_li_F"},{"name":"$ingroup","containerName":"fu_and_li_F","kind":13,"line":412},{"name":"$n","containerName":"fu_and_li_F","kind":13,"line":413},{"line":413,"name":"$ingroup","containerName":"fu_and_li_F","kind":13},{"line":415,"name":"$pi","kind":13,"containerName":"fu_and_li_F"},{"containerName":"fu_and_li_F","kind":13,"name":"$self","line":415},{"line":415,"name":"pi","kind":12,"containerName":"fu_and_li_F"},{"name":"$ingroup","containerName":"fu_and_li_F","kind":13,"line":415},{"kind":13,"containerName":"fu_and_li_F","name":"$seg_sites","line":416},{"line":416,"name":"$self","kind":13,"containerName":"fu_and_li_F"},{"containerName":"fu_and_li_F","kind":12,"name":"segregating_sites_count","line":416},{"line":416,"kind":13,"containerName":"fu_and_li_F","name":"$ingroup"},{"line":417,"name":"$ingroup","containerName":"fu_and_li_F","kind":13},{"name":"$ingroup","kind":13,"containerName":"fu_and_li_F","line":418},{"line":418,"kind":12,"containerName":"fu_and_li_F","name":"isa"},{"line":419,"name":"$n","kind":13,"containerName":"fu_and_li_F"},{"line":419,"containerName":"fu_and_li_F","kind":13,"name":"$ingroup"},{"line":419,"name":"get_number_individuals","containerName":"fu_and_li_F","kind":12},{"name":"$pi","kind":13,"containerName":"fu_and_li_F","line":420},{"line":420,"containerName":"fu_and_li_F","kind":13,"name":"$self"},{"line":420,"name":"pi","kind":12,"containerName":"fu_and_li_F"},{"name":"$ingroup","containerName":"fu_and_li_F","kind":13,"line":420},{"name":"$seg_sites","containerName":"fu_and_li_F","kind":13,"line":421},{"kind":13,"containerName":"fu_and_li_F","name":"$self","line":421},{"name":"segregating_sites_count","kind":12,"containerName":"fu_and_li_F","line":421},{"containerName":"fu_and_li_F","kind":13,"name":"$ingroup","line":421},{"line":423,"name":"$self","containerName":"fu_and_li_F","kind":13},{"containerName":"fu_and_li_F","kind":12,"name":"throw","line":423},{"containerName":"fu_and_li_F","kind":13,"name":"$outgroup","line":427},{"name":"$self","kind":13,"containerName":"fu_and_li_F","line":428},{"name":"warn","containerName":"fu_and_li_F","kind":12,"line":428},{"line":430,"containerName":"fu_and_li_F","kind":13,"name":"$outgroup"},{"containerName":"fu_and_li_F","kind":13,"name":"$external","line":431},{"line":431,"containerName":"fu_and_li_F","kind":13,"name":"$internal"},{"line":431,"kind":13,"containerName":"fu_and_li_F","name":"$self"},{"line":431,"kind":12,"containerName":"fu_and_li_F","name":"derived_mutations"},{"line":431,"name":"$ingroup","containerName":"fu_and_li_F","kind":13},{"name":"$outgroup","kind":13,"containerName":"fu_and_li_F","line":431},{"name":"$external","kind":13,"containerName":"fu_and_li_F","line":433},{"line":433,"containerName":"fu_and_li_F","kind":13,"name":"$outgroup"},{"line":435,"name":"$self","containerName":"fu_and_li_F","kind":13},{"name":"fu_and_li_F_counts","containerName":"fu_and_li_F","kind":12,"line":435},{"name":"$n","kind":13,"containerName":"fu_and_li_F","line":435},{"name":"$pi","containerName":"fu_and_li_F","kind":13,"line":435},{"line":435,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_F"},{"line":435,"kind":13,"containerName":"fu_and_li_F","name":"$external"}],"name":"fu_and_li_F","containerName":"main::"},{"children":[{"localvar":"my","kind":13,"containerName":"fu_and_li_F_counts","name":"$self","line":456,"definition":"my"},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":456},{"name":"$pi","containerName":"fu_and_li_F_counts","kind":13,"line":456},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$seg_sites","line":456},{"line":456,"containerName":"fu_and_li_F_counts","kind":13,"name":"$external"},{"name":"$a_n","containerName":"fu_and_li_F_counts","localvar":"my","kind":13,"line":457,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"fu_and_li_F_counts","name":"$k","line":458},{"containerName":"fu_and_li_F_counts","kind":13,"name":"$k","line":458},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":458},{"line":458,"kind":13,"containerName":"fu_and_li_F_counts","name":"$k"},{"line":459,"name":"$a_n","containerName":"fu_and_li_F_counts","kind":13},{"line":459,"containerName":"fu_and_li_F_counts","kind":13,"name":"$k"},{"name":"$a1","containerName":"fu_and_li_F_counts","localvar":"my","kind":13,"line":462,"definition":"my"},{"containerName":"fu_and_li_F_counts","kind":13,"name":"$a_n","line":462},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":462},{"definition":"my","line":464,"name":"$b","containerName":"fu_and_li_F_counts","localvar":"my","kind":13},{"definition":"my","line":465,"localvar":"my","kind":13,"containerName":"fu_and_li_F_counts","name":"$k"},{"line":465,"name":"$k","kind":13,"containerName":"fu_and_li_F_counts"},{"name":"$n","containerName":"fu_and_li_F_counts","kind":13,"line":465},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$k","line":465},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$b","line":466},{"name":"$k","kind":13,"containerName":"fu_and_li_F_counts","line":466},{"name":"$c","localvar":"my","containerName":"fu_and_li_F_counts","kind":13,"line":469,"definition":"my"},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$n","line":469},{"name":"$a_n","containerName":"fu_and_li_F_counts","kind":13,"line":469},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$n","line":469},{"line":470,"name":"$n","containerName":"fu_and_li_F_counts","kind":13},{"line":470,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"definition":"my","line":472,"name":"$v_F","localvar":"my","containerName":"fu_and_li_F_counts","kind":13},{"name":"$c","containerName":"fu_and_li_F_counts","kind":13,"line":472},{"line":472,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"name":"$n","containerName":"fu_and_li_F_counts","kind":13,"line":472},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":473},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":473},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":474},{"line":474,"name":"$a_n","containerName":"fu_and_li_F_counts","kind":13},{"line":474,"name":"$b","kind":13,"containerName":"fu_and_li_F_counts"},{"name":"$u_F","containerName":"fu_and_li_F_counts","localvar":"my","kind":13,"line":476,"definition":"my"},{"line":476,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"line":476,"name":"$n","containerName":"fu_and_li_F_counts","kind":13},{"line":477,"containerName":"fu_and_li_F_counts","kind":13,"name":"$n"},{"line":477,"name":"$n","containerName":"fu_and_li_F_counts","kind":13},{"line":478,"name":"$a1","containerName":"fu_and_li_F_counts","kind":13},{"name":"$n","kind":13,"containerName":"fu_and_li_F_counts","line":478},{"line":478,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"name":"$a_n","kind":13,"containerName":"fu_and_li_F_counts","line":479},{"name":"$v_F","containerName":"fu_and_li_F_counts","kind":13,"line":479},{"definition":"my","name":"$F","kind":13,"localvar":"my","containerName":"fu_and_li_F_counts","line":482},{"name":"$pi","containerName":"fu_and_li_F_counts","kind":13,"line":482},{"line":482,"name":"$external","containerName":"fu_and_li_F_counts","kind":13},{"name":"$u_F","containerName":"fu_and_li_F_counts","kind":13,"line":482},{"line":482,"containerName":"fu_and_li_F_counts","kind":13,"name":"$seg_sites"},{"kind":13,"containerName":"fu_and_li_F_counts","name":"$v_F","line":483},{"name":"$seg_sites","kind":13,"containerName":"fu_and_li_F_counts","line":483},{"name":"$F","kind":13,"containerName":"fu_and_li_F_counts","line":485}],"name":"fu_and_li_F_counts","containerName":"main::","definition":"sub","detail":"($self,$n,$pi,$seg_sites,$external)","line":455,"range":{"start":{"character":0,"line":455},"end":{"line":486,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$n"},{"label":"$pi"},{"label":"$seg_sites"},{"label":"$external"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)","label":"fu_and_li_F_counts($self,$n,$pi,$seg_sites,$external)"}},{"signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n' keep my emacs happy","parameters":[{"label":"$self"},{"label":"$individuals"}],"label":"fu_and_li_F_star($self,$individuals)"},"range":{"end":{"line":528,"character":9999},"start":{"character":0,"line":503}},"kind":12,"line":503,"detail":"($self,$individuals)","definition":"sub","containerName":"main::","name":"fu_and_li_F_star","children":[{"definition":"my","line":504,"containerName":"fu_and_li_F_star","localvar":"my","kind":13,"name":"$self"},{"containerName":"fu_and_li_F_star","kind":13,"name":"$individuals","line":504},{"line":506,"containerName":"fu_and_li_F_star","localvar":"my","kind":13,"name":"$seg_sites","definition":"my"},{"line":506,"name":"$pi","kind":13,"containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","kind":13,"name":"$n","line":506},{"line":506,"containerName":"fu_and_li_F_star","kind":13,"name":"$singletons"},{"line":507,"containerName":"fu_and_li_F_star","kind":13,"name":"$individuals"},{"line":508,"name":"$n","kind":13,"containerName":"fu_and_li_F_star"},{"name":"$individuals","containerName":"fu_and_li_F_star","kind":13,"line":508},{"kind":13,"containerName":"fu_and_li_F_star","name":"$pi","line":510},{"containerName":"fu_and_li_F_star","kind":13,"name":"$self","line":510},{"name":"pi","kind":12,"containerName":"fu_and_li_F_star","line":510},{"name":"$individuals","kind":13,"containerName":"fu_and_li_F_star","line":510},{"line":511,"name":"$seg_sites","containerName":"fu_and_li_F_star","kind":13},{"line":511,"kind":13,"containerName":"fu_and_li_F_star","name":"$self"},{"containerName":"fu_and_li_F_star","kind":12,"name":"segregating_sites_count","line":511},{"line":511,"kind":13,"containerName":"fu_and_li_F_star","name":"$individuals"},{"line":512,"name":"$singletons","kind":13,"containerName":"fu_and_li_F_star"},{"kind":13,"containerName":"fu_and_li_F_star","name":"$self","line":512},{"name":"singleton_count","containerName":"fu_and_li_F_star","kind":12,"line":512},{"name":"$individuals","containerName":"fu_and_li_F_star","kind":13,"line":512},{"kind":13,"containerName":"fu_and_li_F_star","name":"$individuals","line":513},{"containerName":"fu_and_li_F_star","kind":13,"name":"$individuals","line":514},{"kind":12,"containerName":"fu_and_li_F_star","name":"isa","line":514},{"name":"$pop","containerName":"fu_and_li_F_star","localvar":"my","kind":13,"line":515,"definition":"my"},{"containerName":"fu_and_li_F_star","kind":13,"name":"$individuals","line":515},{"name":"$n","containerName":"fu_and_li_F_star","kind":13,"line":516},{"name":"$pop","kind":13,"containerName":"fu_and_li_F_star","line":516},{"name":"get_number_individuals","containerName":"fu_and_li_F_star","kind":12,"line":516},{"name":"$pi","containerName":"fu_and_li_F_star","kind":13,"line":517},{"line":517,"name":"$self","kind":13,"containerName":"fu_and_li_F_star"},{"line":517,"containerName":"fu_and_li_F_star","kind":12,"name":"pi"},{"line":517,"containerName":"fu_and_li_F_star","kind":13,"name":"$pop"},{"line":518,"name":"$seg_sites","kind":13,"containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","kind":13,"name":"$self","line":518},{"line":518,"kind":12,"containerName":"fu_and_li_F_star","name":"segregating_sites_count"},{"kind":13,"containerName":"fu_and_li_F_star","name":"$pop","line":518},{"name":"$singletons","kind":13,"containerName":"fu_and_li_F_star","line":519},{"name":"$self","containerName":"fu_and_li_F_star","kind":13,"line":519},{"line":519,"name":"singleton_count","kind":12,"containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","kind":13,"name":"$pop","line":519},{"name":"$self","kind":13,"containerName":"fu_and_li_F_star","line":521},{"containerName":"fu_and_li_F_star","kind":12,"name":"throw","line":521},{"line":524,"name":"$self","kind":13,"containerName":"fu_and_li_F_star"},{"name":"fu_and_li_F_star_counts","containerName":"fu_and_li_F_star","kind":12,"line":524},{"line":524,"kind":13,"containerName":"fu_and_li_F_star","name":"$n"},{"name":"$pi","containerName":"fu_and_li_F_star","kind":13,"line":525},{"name":"$seg_sites","containerName":"fu_and_li_F_star","kind":13,"line":526},{"line":527,"name":"$singletons","kind":13,"containerName":"fu_and_li_F_star"}]},{"children":[{"line":548,"name":"$self","containerName":"fu_and_li_F_star_counts","localvar":"my","kind":13,"definition":"my"},{"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts","line":548},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$pi","line":548},{"name":"$seg_sites","containerName":"fu_and_li_F_star_counts","kind":13,"line":548},{"name":"$singletons","kind":13,"containerName":"fu_and_li_F_star_counts","line":548},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":549},{"line":550,"name":"$self","kind":13,"containerName":"fu_and_li_F_star_counts"},{"line":550,"kind":12,"containerName":"fu_and_li_F_star_counts","name":"warn"},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":553},{"definition":"my","line":557,"kind":13,"localvar":"my","containerName":"fu_and_li_F_star_counts","name":"$a_n"},{"localvar":"my","containerName":"fu_and_li_F_star_counts","kind":13,"name":"$b","line":560,"definition":"my"},{"line":561,"containerName":"fu_and_li_F_star_counts","localvar":"my","kind":13,"name":"$k","definition":"my"},{"line":561,"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$k"},{"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts","line":561},{"line":561,"name":"$k","containerName":"fu_and_li_F_star_counts","kind":13},{"line":562,"name":"$b","kind":13,"containerName":"fu_and_li_F_star_counts"},{"line":562,"name":"$k","kind":13,"containerName":"fu_and_li_F_star_counts"},{"line":563,"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$a_n"},{"line":563,"name":"$k","kind":13,"containerName":"fu_and_li_F_star_counts"},{"line":565,"containerName":"fu_and_li_F_star_counts","localvar":"my","kind":13,"name":"$a1","definition":"my"},{"line":565,"name":"$a_n","kind":13,"containerName":"fu_and_li_F_star_counts"},{"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n","line":565},{"definition":"my","name":"$v_F_star","localvar":"my","containerName":"fu_and_li_F_star_counts","kind":13,"line":570},{"line":570,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":570},{"line":570,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$n","line":571},{"line":571,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts","line":572},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$a_n","line":572},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$n","line":572},{"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$b","line":573},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$n","line":573},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$a_n","line":574},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$b","line":574},{"line":576,"name":"$u_F_star","localvar":"my","kind":13,"containerName":"fu_and_li_F_star_counts","definition":"my"},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":576},{"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n","line":576},{"line":576,"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13},{"line":576,"name":"$a1","kind":13,"containerName":"fu_and_li_F_star_counts"},{"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts","line":577},{"line":577,"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$a_n","line":577},{"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$v_F_star","line":577},{"definition":"my","line":580,"localvar":"my","containerName":"fu_and_li_F_star_counts","kind":13,"name":"$F_star"},{"name":"$pi","kind":13,"containerName":"fu_and_li_F_star_counts","line":580},{"line":580,"name":"$singletons","containerName":"fu_and_li_F_star_counts","kind":13},{"name":"$n","kind":13,"containerName":"fu_and_li_F_star_counts","line":580},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":580},{"line":581,"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$u_F_star"},{"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$seg_sites","line":581},{"line":581,"containerName":"fu_and_li_F_star_counts","kind":13,"name":"$v_F_star"},{"line":581,"name":"$seg_sites","containerName":"fu_and_li_F_star_counts","kind":13},{"line":582,"name":"$F_star","containerName":"fu_and_li_F_star_counts","kind":13}],"containerName":"main::","name":"fu_and_li_F_star_counts","definition":"sub","detail":"($self,$n,$pi,$seg_sites,$singletons)","line":547,"range":{"end":{"character":9999,"line":583},"start":{"line":547,"character":0}},"kind":12,"signature":{"label":"fu_and_li_F_star_counts($self,$n,$pi,$seg_sites,$singletons)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$pi"},{"label":"$seg_sites"},{"label":"$singletons"}]}},{"line":600,"range":{"end":{"character":9999,"line":621},"start":{"character":0,"line":600}},"kind":12,"signature":{"label":"tajima_D($self,$individuals)","parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n'"},"children":[{"line":601,"kind":13,"localvar":"my","containerName":"tajima_D","name":"$self","definition":"my"},{"line":601,"name":"$individuals","kind":13,"containerName":"tajima_D"},{"line":602,"name":"$seg_sites","kind":13,"localvar":"my","containerName":"tajima_D","definition":"my"},{"containerName":"tajima_D","kind":13,"name":"$pi","line":602},{"name":"$n","kind":13,"containerName":"tajima_D","line":602},{"line":604,"kind":13,"containerName":"tajima_D","name":"$individuals"},{"containerName":"tajima_D","kind":13,"name":"$n","line":605},{"line":605,"name":"$individuals","containerName":"tajima_D","kind":13},{"line":607,"name":"$pi","containerName":"tajima_D","kind":13},{"line":607,"name":"$self","kind":13,"containerName":"tajima_D"},{"containerName":"tajima_D","kind":12,"name":"pi","line":607},{"kind":13,"containerName":"tajima_D","name":"$individuals","line":607},{"line":608,"containerName":"tajima_D","kind":13,"name":"$seg_sites"},{"kind":13,"containerName":"tajima_D","name":"$self","line":608},{"kind":12,"containerName":"tajima_D","name":"segregating_sites_count","line":608},{"containerName":"tajima_D","kind":13,"name":"$individuals","line":608},{"line":610,"kind":13,"containerName":"tajima_D","name":"$individuals"},{"line":611,"containerName":"tajima_D","kind":13,"name":"$individuals"},{"kind":12,"containerName":"tajima_D","name":"isa","line":611},{"line":612,"kind":13,"localvar":"my","containerName":"tajima_D","name":"$pop","definition":"my"},{"line":612,"name":"$individuals","containerName":"tajima_D","kind":13},{"line":613,"name":"$n","containerName":"tajima_D","kind":13},{"kind":13,"containerName":"tajima_D","name":"$pop","line":613},{"line":613,"name":"get_number_individuals","containerName":"tajima_D","kind":12},{"line":614,"name":"$pi","kind":13,"containerName":"tajima_D"},{"line":614,"containerName":"tajima_D","kind":13,"name":"$self"},{"line":614,"kind":12,"containerName":"tajima_D","name":"pi"},{"line":614,"name":"$pop","kind":13,"containerName":"tajima_D"},{"line":615,"name":"$seg_sites","kind":13,"containerName":"tajima_D"},{"line":615,"containerName":"tajima_D","kind":13,"name":"$self"},{"name":"segregating_sites_count","kind":12,"containerName":"tajima_D","line":615},{"line":615,"name":"$pop","containerName":"tajima_D","kind":13},{"line":617,"kind":13,"containerName":"tajima_D","name":"$self"},{"line":617,"kind":12,"containerName":"tajima_D","name":"throw"},{"containerName":"tajima_D","kind":13,"name":"$self","line":620},{"line":620,"containerName":"tajima_D","kind":12,"name":"tajima_D_counts"},{"name":"$n","containerName":"tajima_D","kind":13,"line":620},{"name":"$seg_sites","kind":13,"containerName":"tajima_D","line":620},{"name":"$pi","containerName":"tajima_D","kind":13,"line":620}],"name":"tajima_D","containerName":"main::","definition":"sub","detail":"($self,$individuals)"},{"signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n'","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$pi"}],"label":"tajima_D_counts($self,$n,$seg_sites,$pi)"},"line":638,"range":{"end":{"line":663,"character":9999},"start":{"line":638,"character":0}},"kind":12,"definition":"sub","detail":"($self,$n,$seg_sites,$pi)","children":[{"definition":"my","line":639,"name":"$self","containerName":"tajima_D_counts","localvar":"my","kind":13},{"name":"$n","kind":13,"containerName":"tajima_D_counts","line":639},{"containerName":"tajima_D_counts","kind":13,"name":"$seg_sites","line":639},{"name":"$pi","kind":13,"containerName":"tajima_D_counts","line":639},{"line":640,"name":"$a1","containerName":"tajima_D_counts","localvar":"my","kind":13,"definition":"my"},{"line":641,"containerName":"tajima_D_counts","localvar":"my","kind":13,"name":"$k","definition":"my"},{"containerName":"tajima_D_counts","kind":13,"name":"$k","line":641},{"line":641,"name":"$n","kind":13,"containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","kind":13,"name":"$k","line":641},{"containerName":"tajima_D_counts","kind":13,"name":"$a1","line":642},{"name":"$k","kind":13,"containerName":"tajima_D_counts","line":642},{"name":"$a2","kind":13,"localvar":"my","containerName":"tajima_D_counts","line":645,"definition":"my"},{"name":"$k","kind":13,"localvar":"my","containerName":"tajima_D_counts","line":646,"definition":"my"},{"line":646,"name":"$k","containerName":"tajima_D_counts","kind":13},{"kind":13,"containerName":"tajima_D_counts","name":"$n","line":646},{"name":"$k","kind":13,"containerName":"tajima_D_counts","line":646},{"line":647,"containerName":"tajima_D_counts","kind":13,"name":"$a2"},{"name":"$k","kind":13,"containerName":"tajima_D_counts","line":647},{"definition":"my","line":650,"name":"$b1","localvar":"my","kind":13,"containerName":"tajima_D_counts"},{"line":650,"containerName":"tajima_D_counts","kind":13,"name":"$n"},{"line":650,"containerName":"tajima_D_counts","kind":13,"name":"$n"},{"definition":"my","localvar":"my","kind":13,"containerName":"tajima_D_counts","name":"$b2","line":651},{"kind":13,"containerName":"tajima_D_counts","name":"$n","line":651},{"line":651,"name":"$n","containerName":"tajima_D_counts","kind":13},{"kind":13,"containerName":"tajima_D_counts","name":"$n","line":652},{"name":"$n","kind":13,"containerName":"tajima_D_counts","line":652},{"definition":"my","line":653,"kind":13,"localvar":"my","containerName":"tajima_D_counts","name":"$c1"},{"containerName":"tajima_D_counts","kind":13,"name":"$b1","line":653},{"name":"$a1","kind":13,"containerName":"tajima_D_counts","line":653},{"localvar":"my","containerName":"tajima_D_counts","kind":13,"name":"$c2","line":654,"definition":"my"},{"line":654,"name":"$b2","kind":13,"containerName":"tajima_D_counts"},{"line":654,"kind":13,"containerName":"tajima_D_counts","name":"$n"},{"name":"$a1","kind":13,"containerName":"tajima_D_counts","line":655},{"line":655,"name":"$n","kind":13,"containerName":"tajima_D_counts"},{"name":"$a2","containerName":"tajima_D_counts","kind":13,"line":655},{"kind":13,"containerName":"tajima_D_counts","name":"$a1","line":655},{"definition":"my","line":656,"containerName":"tajima_D_counts","localvar":"my","kind":13,"name":"$e1"},{"containerName":"tajima_D_counts","kind":13,"name":"$c1","line":656},{"name":"$a1","containerName":"tajima_D_counts","kind":13,"line":656},{"definition":"my","line":657,"localvar":"my","kind":13,"containerName":"tajima_D_counts","name":"$e2"},{"containerName":"tajima_D_counts","kind":13,"name":"$c2","line":657},{"kind":13,"containerName":"tajima_D_counts","name":"$a1","line":657},{"line":657,"containerName":"tajima_D_counts","kind":13,"name":"$a2"},{"definition":"my","line":659,"name":"$denom","localvar":"my","containerName":"tajima_D_counts","kind":13},{"line":659,"kind":13,"containerName":"tajima_D_counts","name":"$e1"},{"line":659,"name":"$seg_sites","containerName":"tajima_D_counts","kind":13},{"line":659,"kind":13,"containerName":"tajima_D_counts","name":"$e2"},{"line":659,"containerName":"tajima_D_counts","kind":13,"name":"$seg_sites"},{"name":"$seg_sites","containerName":"tajima_D_counts","kind":13,"line":659},{"line":660,"containerName":"tajima_D_counts","kind":13,"name":"$denom"},{"line":661,"name":"$D","localvar":"my","kind":13,"containerName":"tajima_D_counts","definition":"my"},{"containerName":"tajima_D_counts","kind":13,"name":"$pi","line":661},{"name":"$seg_sites","containerName":"tajima_D_counts","kind":13,"line":661},{"line":661,"name":"$a1","kind":13,"containerName":"tajima_D_counts"},{"line":661,"kind":13,"containerName":"tajima_D_counts","name":"$denom"},{"line":662,"name":"$D","kind":13,"containerName":"tajima_D_counts"}],"name":"tajima_D_counts","containerName":"main::"},{"name":"pi","containerName":"main::","children":[{"definition":"my","line":688,"name":"$self","containerName":"pi","localvar":"my","kind":13},{"name":"$individuals","containerName":"pi","kind":13,"line":688},{"name":"$numsites","kind":13,"containerName":"pi","line":688},{"definition":"my","line":689,"name":"%data","kind":13,"localvar":"my","containerName":"pi"},{"line":689,"name":"%marker_total","kind":13,"containerName":"pi"},{"line":689,"containerName":"pi","kind":13,"name":"@marker_names"},{"kind":13,"containerName":"pi","name":"$n","line":689},{"line":691,"kind":13,"containerName":"pi","name":"$individuals"},{"line":693,"name":"@marker_names","containerName":"pi","kind":13},{"kind":13,"containerName":"pi","name":"$individuals","line":693},{"kind":12,"containerName":"pi","name":"get_marker_names","line":693},{"containerName":"pi","kind":13,"name":"$n","line":694},{"line":694,"name":"$individuals","containerName":"pi","kind":13},{"definition":"my","line":697,"containerName":"pi","localvar":"my","kind":13,"name":"$ind"},{"line":697,"name":"$individuals","containerName":"pi","kind":13},{"kind":13,"containerName":"pi","name":"$ind","line":698},{"containerName":"pi","kind":12,"name":"isa","line":698},{"line":699,"name":"$self","kind":13,"containerName":"pi"},{"kind":12,"containerName":"pi","name":"warn","line":699},{"kind":13,"containerName":"pi","name":"$ind","line":699},{"definition":"my","line":702,"name":"$m","localvar":"my","kind":13,"containerName":"pi"},{"line":702,"kind":13,"containerName":"pi","name":"@marker_names"},{"localvar":"my","containerName":"pi","kind":13,"name":"$allele","line":703,"definition":"my"},{"line":703,"name":"get_Alleles","kind":12,"containerName":"pi"},{"kind":13,"containerName":"pi","name":"$ind","line":704},{"kind":12,"containerName":"pi","name":"get_Genotypes","line":704},{"kind":13,"containerName":"pi","name":"$m","line":704},{"name":"$data","kind":13,"containerName":"pi","line":705},{"name":"$m","containerName":"pi","kind":13,"line":705},{"line":705,"containerName":"pi","kind":13,"name":"$allele"},{"containerName":"pi","kind":13,"name":"$marker_total","line":706},{"line":706,"kind":13,"containerName":"pi","name":"$m"},{"line":716,"containerName":"pi","kind":13,"name":"$individuals"},{"line":717,"name":"$individuals","containerName":"pi","kind":13},{"line":717,"name":"isa","kind":12,"containerName":"pi"},{"definition":"my","line":718,"containerName":"pi","localvar":"my","kind":13,"name":"$pop"},{"line":718,"kind":13,"containerName":"pi","name":"$individuals"},{"containerName":"pi","kind":13,"name":"$n","line":719},{"containerName":"pi","kind":13,"name":"$pop","line":719},{"kind":12,"containerName":"pi","name":"get_number_individuals","line":719},{"line":720,"kind":13,"localvar":"my","containerName":"pi","name":"$marker","definition":"my"},{"name":"$pop","containerName":"pi","kind":13,"line":720},{"line":720,"kind":12,"containerName":"pi","name":"get_Markers"},{"line":721,"kind":13,"containerName":"pi","name":"@marker_names"},{"containerName":"pi","kind":13,"name":"$marker","line":721},{"kind":12,"containerName":"pi","name":"name","line":721},{"line":723,"name":"@genotypes","localvar":"my","containerName":"pi","kind":13,"definition":"my"},{"line":723,"name":"$pop","containerName":"pi","kind":13},{"kind":12,"containerName":"pi","name":"get_Genotypes","line":723},{"containerName":"pi","kind":13,"name":"$marker","line":723},{"line":723,"containerName":"pi","kind":12,"name":"name"},{"definition":"my","kind":13,"localvar":"my","containerName":"pi","name":"$al","line":724},{"kind":12,"containerName":"pi","name":"get_Alleles","line":724},{"line":724,"name":"@genotypes","kind":13,"containerName":"pi"},{"line":725,"kind":13,"containerName":"pi","name":"$data"},{"line":725,"kind":13,"containerName":"pi","name":"$marker"},{"line":725,"kind":12,"containerName":"pi","name":"name"},{"kind":13,"containerName":"pi","name":"$al","line":725},{"line":726,"kind":13,"containerName":"pi","name":"$marker_total"},{"line":726,"name":"$marker","kind":13,"containerName":"pi"},{"name":"name","kind":12,"containerName":"pi","line":726},{"name":"$self","kind":13,"containerName":"pi","line":730},{"containerName":"pi","kind":12,"name":"throw","line":730},{"line":735,"kind":13,"localvar":"my","containerName":"pi","name":"$diffcount","definition":"my"},{"line":735,"containerName":"pi","kind":13,"name":"$totalcompare"},{"definition":"my","name":"$pi","kind":13,"localvar":"my","containerName":"pi","line":736},{"line":737,"name":"$marker","localvar":"my","containerName":"pi","kind":13,"definition":"my"},{"line":737,"name":"$markerdat","containerName":"pi","kind":13},{"name":"%data","kind":13,"containerName":"pi","line":737},{"name":"$sampsize","containerName":"pi","localvar":"my","kind":13,"line":738,"definition":"my"},{"containerName":"pi","kind":13,"name":"$marker_total","line":738},{"name":"$marker","kind":13,"containerName":"pi","line":738},{"definition":"my","name":"$ssh","kind":13,"localvar":"my","containerName":"pi","line":739},{"definition":"my","line":740,"name":"@alleles","localvar":"my","kind":13,"containerName":"pi"},{"line":740,"kind":13,"containerName":"pi","name":"$markerdat"},{"line":741,"name":"$sampsize","containerName":"pi","kind":13},{"name":"$denom","containerName":"pi","localvar":"my","kind":13,"line":742,"definition":"my"},{"line":742,"name":"$sampsize","kind":13,"containerName":"pi"},{"line":742,"kind":13,"containerName":"pi","name":"$sampsize"},{"line":743,"name":"$al","kind":13,"localvar":"my","containerName":"pi","definition":"my"},{"line":743,"name":"@alleles","containerName":"pi","kind":13},{"line":744,"containerName":"pi","kind":13,"name":"$ssh"},{"name":"$markerdat","containerName":"pi","kind":13,"line":744},{"name":"$al","kind":13,"containerName":"pi","line":744},{"containerName":"pi","kind":13,"name":"$markerdat","line":744},{"containerName":"pi","kind":13,"name":"$al","line":744},{"name":"$denom","kind":13,"containerName":"pi","line":744},{"line":746,"containerName":"pi","kind":13,"name":"$pi"},{"kind":13,"containerName":"pi","name":"$ssh","line":746},{"kind":13,"containerName":"pi","name":"$self","line":749},{"line":749,"containerName":"pi","kind":12,"name":"debug"},{"line":750,"name":"$numsites","containerName":"pi","kind":13},{"line":751,"kind":13,"containerName":"pi","name":"$pi"},{"kind":13,"containerName":"pi","name":"$numsites","line":751},{"kind":13,"containerName":"pi","name":"$pi","line":753}],"detail":"($self,$individuals,$numsites)","definition":"sub","range":{"start":{"line":687,"character":0},"end":{"line":755,"character":9999}},"kind":12,"line":687,"signature":{"label":"pi($self,$individuals,$numsites)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.","parameters":[{"label":"$self"},{"label":"$individuals"},{"label":"$numsites"}]}},{"detail":"($n,$seg_sites,$totalsites)","definition":"sub","containerName":"main::","name":"theta","children":[{"definition":"my","line":783,"localvar":"my","kind":13,"containerName":"theta","name":"$self"},{"definition":"my","line":784,"name":"$n","localvar":"my","kind":13,"containerName":"theta"},{"name":"$seg_sites","containerName":"theta","kind":13,"line":784},{"line":784,"containerName":"theta","kind":13,"name":"$totalsites"},{"kind":13,"containerName":"theta","name":"$n","line":785},{"definition":"my","name":"$samps","kind":13,"localvar":"my","containerName":"theta","line":786},{"kind":13,"containerName":"theta","name":"$n","line":786},{"name":"$totalsites","kind":13,"containerName":"theta","line":787},{"line":787,"kind":13,"containerName":"theta","name":"$seg_sites"},{"kind":13,"localvar":"my","containerName":"theta","name":"%data","line":788,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"theta","name":"@marker_names","line":789},{"line":789,"kind":13,"containerName":"theta","name":"$samps"},{"line":789,"name":"get_marker_names","containerName":"theta","kind":12},{"name":"$seg_sites","kind":13,"containerName":"theta","line":791},{"kind":13,"containerName":"theta","name":"$self","line":791},{"line":791,"containerName":"theta","kind":12,"name":"segregating_sites_count"},{"name":"$samps","kind":13,"containerName":"theta","line":791},{"name":"$n","kind":13,"containerName":"theta","line":792},{"line":792,"name":"$samps","containerName":"theta","kind":13},{"line":794,"containerName":"theta","kind":13,"name":"$n"},{"name":"$n","containerName":"theta","kind":13,"line":795},{"name":"isa","kind":12,"containerName":"theta","line":795},{"name":"$pop","containerName":"theta","localvar":"my","kind":13,"line":797,"definition":"my"},{"name":"$n","containerName":"theta","kind":13,"line":797},{"line":798,"name":"$totalsites","kind":13,"containerName":"theta"},{"line":798,"name":"$seg_sites","kind":13,"containerName":"theta"},{"kind":13,"containerName":"theta","name":"$n","line":799},{"line":799,"name":"$pop","kind":13,"containerName":"theta"},{"kind":12,"containerName":"theta","name":"haploid_population","line":799},{"line":799,"name":"get_number_individuals","containerName":"theta","kind":12},{"name":"$seg_sites","kind":13,"containerName":"theta","line":800},{"line":800,"containerName":"theta","kind":13,"name":"$self"},{"containerName":"theta","kind":12,"name":"segregating_sites_count","line":800},{"name":"$pop","kind":13,"containerName":"theta","line":800},{"line":802,"kind":13,"localvar":"my","containerName":"theta","name":"$a1","definition":"my"},{"name":"$k","localvar":"my","kind":13,"containerName":"theta","line":803,"definition":"my"},{"containerName":"theta","kind":13,"name":"$k","line":803},{"line":803,"name":"$n","containerName":"theta","kind":13},{"kind":13,"containerName":"theta","name":"$k","line":803},{"line":804,"containerName":"theta","kind":13,"name":"$a1"},{"name":"$k","kind":13,"containerName":"theta","line":804},{"containerName":"theta","kind":13,"name":"$totalsites","line":806},{"kind":13,"containerName":"theta","name":"$seg_sites","line":807},{"line":807,"name":"$totalsites","containerName":"theta","kind":13},{"name":"$a1","containerName":"theta","kind":13,"line":809},{"name":"$seg_sites","kind":13,"containerName":"theta","line":812},{"line":812,"name":"$a1","containerName":"theta","kind":13}],"signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n'","parameters":[{"label":"$n"},{"label":"$seg_sites"},{"label":"$totalsites"}],"label":"theta($n,$seg_sites,$totalsites)"},"kind":12,"range":{"end":{"character":9999,"line":813},"start":{"character":0,"line":782}},"line":782},{"detail":"($self,$individuals)","definition":"sub","containerName":"main::","name":"singleton_count","children":[{"definition":"my","line":829,"name":"$self","kind":13,"localvar":"my","containerName":"singleton_count"},{"kind":13,"containerName":"singleton_count","name":"$individuals","line":829},{"containerName":"singleton_count","localvar":"my","kind":13,"name":"@inds","line":831,"definition":"my"},{"line":832,"name":"$individuals","kind":13,"containerName":"singleton_count"},{"line":833,"name":"@inds","kind":13,"containerName":"singleton_count"},{"line":833,"name":"$individuals","containerName":"singleton_count","kind":13},{"kind":13,"containerName":"singleton_count","name":"$individuals","line":834},{"line":835,"kind":13,"containerName":"singleton_count","name":"$individuals"},{"name":"isa","kind":12,"containerName":"singleton_count","line":835},{"definition":"my","kind":13,"localvar":"my","containerName":"singleton_count","name":"$pop","line":836},{"kind":13,"containerName":"singleton_count","name":"$individuals","line":836},{"kind":13,"containerName":"singleton_count","name":"@inds","line":837},{"line":837,"name":"$pop","kind":13,"containerName":"singleton_count"},{"kind":12,"containerName":"singleton_count","name":"get_Individuals","line":837},{"line":838,"kind":13,"containerName":"singleton_count","name":"@inds"},{"kind":13,"containerName":"singleton_count","name":"$self","line":839},{"name":"warn","kind":12,"containerName":"singleton_count","line":839},{"line":843,"name":"$self","containerName":"singleton_count","kind":13},{"kind":12,"containerName":"singleton_count","name":"warn","line":843},{"name":"$singleton_allele_ct","localvar":"my","kind":13,"containerName":"singleton_count","line":848,"definition":"my"},{"kind":13,"containerName":"singleton_count","name":"%sites","line":848},{"definition":"my","line":851,"localvar":"my","kind":13,"containerName":"singleton_count","name":"$n"},{"line":851,"containerName":"singleton_count","kind":13,"name":"@inds"},{"containerName":"singleton_count","kind":13,"name":"$n","line":852},{"name":"isa","kind":12,"containerName":"singleton_count","line":852},{"line":853,"containerName":"singleton_count","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"singleton_count","line":853},{"line":853,"kind":13,"containerName":"singleton_count","name":"$n"},{"definition":"my","name":"$g","kind":13,"localvar":"my","containerName":"singleton_count","line":856},{"line":856,"containerName":"singleton_count","kind":13,"name":"$n"},{"name":"get_Genotypes","kind":12,"containerName":"singleton_count","line":856},{"line":857,"localvar":"my","kind":13,"containerName":"singleton_count","name":"$nm","definition":"my"},{"containerName":"singleton_count","kind":13,"name":"@alleles","line":857},{"containerName":"singleton_count","kind":13,"name":"$g","line":857},{"line":857,"name":"marker_name","containerName":"singleton_count","kind":12},{"line":857,"name":"$g","kind":13,"containerName":"singleton_count"},{"line":857,"name":"get_Alleles","kind":12,"containerName":"singleton_count"},{"kind":13,"localvar":"my","containerName":"singleton_count","name":"$allele","line":858,"definition":"my"},{"name":"@alleles","kind":13,"containerName":"singleton_count","line":858},{"name":"$sites","kind":13,"containerName":"singleton_count","line":859},{"name":"$nm","containerName":"singleton_count","kind":13,"line":859},{"line":859,"containerName":"singleton_count","kind":13,"name":"$allele"},{"localvar":"my","kind":13,"containerName":"singleton_count","name":"$site","line":863,"definition":"my"},{"containerName":"singleton_count","kind":13,"name":"%sites","line":863},{"definition":"my","line":864,"kind":13,"localvar":"my","containerName":"singleton_count","name":"$allelect"},{"kind":13,"containerName":"singleton_count","name":"$site","line":864},{"name":"$singleton_allele_ct","kind":13,"containerName":"singleton_count","line":866},{"line":866,"kind":13,"containerName":"singleton_count","name":"$allelect"},{"line":869,"containerName":"singleton_count","kind":13,"name":"$singleton_allele_ct"}],"signature":{"label":"singleton_count($self,$individuals)","parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object"},"range":{"start":{"character":0,"line":828},"end":{"character":9999,"line":870}},"kind":12,"line":828},{"signature":{"parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n perhaps we'll change this in the future\n to return the actual segregating sites\n so one can use this to pull in the names of those sites.\n Would be trivial if it is useful.","label":"segregating_sites_count($self,$individuals)"},"kind":12,"range":{"end":{"character":9999,"line":927},"start":{"line":894,"character":0}},"line":894,"detail":"($self,$individuals)","definition":"sub","containerName":"main::","name":"segregating_sites_count","children":[{"definition":"my","containerName":"segregating_sites_count","localvar":"my","kind":13,"name":"$self","line":895},{"containerName":"segregating_sites_count","kind":13,"name":"$individuals","line":895},{"line":896,"name":"$type","kind":13,"localvar":"my","containerName":"segregating_sites_count","definition":"my"},{"line":896,"name":"$individuals","kind":13,"containerName":"segregating_sites_count"},{"definition":"my","containerName":"segregating_sites_count","localvar":"my","kind":13,"name":"$seg_sites","line":897},{"name":"$type","kind":13,"containerName":"segregating_sites_count","line":898},{"definition":"my","kind":13,"localvar":"my","containerName":"segregating_sites_count","name":"%sites","line":899},{"definition":"my","line":900,"kind":13,"localvar":"my","containerName":"segregating_sites_count","name":"$n"},{"line":900,"kind":13,"containerName":"segregating_sites_count","name":"$individuals"},{"name":"$n","kind":13,"containerName":"segregating_sites_count","line":901},{"line":901,"kind":12,"containerName":"segregating_sites_count","name":"isa"},{"line":902,"name":"$self","kind":13,"containerName":"segregating_sites_count"},{"line":902,"name":"warn","kind":12,"containerName":"segregating_sites_count"},{"kind":13,"containerName":"segregating_sites_count","name":"$n","line":902},{"containerName":"segregating_sites_count","localvar":"my","kind":13,"name":"$g","line":905,"definition":"my"},{"kind":13,"containerName":"segregating_sites_count","name":"$n","line":905},{"name":"get_Genotypes","containerName":"segregating_sites_count","kind":12,"line":905},{"definition":"my","kind":13,"localvar":"my","containerName":"segregating_sites_count","name":"$nm","line":906},{"line":906,"containerName":"segregating_sites_count","kind":13,"name":"@alleles"},{"containerName":"segregating_sites_count","kind":13,"name":"$g","line":906},{"containerName":"segregating_sites_count","kind":12,"name":"marker_name","line":906},{"name":"$g","kind":13,"containerName":"segregating_sites_count","line":906},{"line":906,"name":"get_Alleles","kind":12,"containerName":"segregating_sites_count"},{"line":907,"localvar":"my","containerName":"segregating_sites_count","kind":13,"name":"$allele","definition":"my"},{"line":907,"containerName":"segregating_sites_count","kind":13,"name":"@alleles"},{"name":"$sites","kind":13,"containerName":"segregating_sites_count","line":908},{"line":908,"name":"$nm","containerName":"segregating_sites_count","kind":13},{"kind":13,"containerName":"segregating_sites_count","name":"$allele","line":908},{"definition":"my","localvar":"my","containerName":"segregating_sites_count","kind":13,"name":"$site","line":912},{"line":912,"name":"%sites","containerName":"segregating_sites_count","kind":13},{"containerName":"segregating_sites_count","kind":13,"name":"$seg_sites","line":915},{"name":"$site","containerName":"segregating_sites_count","kind":13,"line":915},{"name":"$type","containerName":"segregating_sites_count","kind":13,"line":917},{"line":917,"containerName":"segregating_sites_count","kind":13,"name":"$individuals"},{"name":"isa","kind":12,"containerName":"segregating_sites_count","line":917},{"definition":"my","localvar":"my","kind":13,"containerName":"segregating_sites_count","name":"$marker","line":918},{"line":918,"kind":13,"containerName":"segregating_sites_count","name":"$individuals"},{"containerName":"segregating_sites_count","kind":12,"name":"haploid_population","line":918},{"name":"get_Markers","containerName":"segregating_sites_count","kind":12,"line":918},{"definition":"my","line":919,"localvar":"my","containerName":"segregating_sites_count","kind":13,"name":"@alleles"},{"name":"$marker","kind":13,"containerName":"segregating_sites_count","line":919},{"containerName":"segregating_sites_count","kind":12,"name":"get_Alleles","line":919},{"name":"$seg_sites","containerName":"segregating_sites_count","kind":13,"line":920},{"containerName":"segregating_sites_count","kind":13,"name":"@alleles","line":920},{"containerName":"segregating_sites_count","kind":13,"name":"$self","line":923},{"kind":12,"containerName":"segregating_sites_count","name":"warn","line":923},{"line":926,"kind":13,"containerName":"segregating_sites_count","name":"$seg_sites"}]},{"containerName":"main::","name":"heterozygosity","children":[{"definition":"my","containerName":"heterozygosity","localvar":"my","kind":13,"name":"$self","line":947},{"name":"$samp_size","containerName":"heterozygosity","kind":13,"line":947},{"name":"$freq1","containerName":"heterozygosity","kind":13,"line":947},{"kind":13,"containerName":"heterozygosity","name":"$freq2","line":947},{"kind":13,"containerName":"heterozygosity","name":"$freq2","line":948},{"line":948,"name":"$freq2","containerName":"heterozygosity","kind":13},{"name":"$freq1","kind":13,"containerName":"heterozygosity","line":948},{"line":949,"kind":13,"containerName":"heterozygosity","name":"$freq1"},{"kind":13,"containerName":"heterozygosity","name":"$freq2","line":949},{"line":950,"name":"$self","kind":13,"containerName":"heterozygosity"},{"kind":12,"containerName":"heterozygosity","name":"warn","line":950},{"definition":"my","line":952,"kind":13,"localvar":"my","containerName":"heterozygosity","name":"$sum"},{"kind":13,"containerName":"heterozygosity","name":"$freq1","line":952},{"line":952,"kind":13,"containerName":"heterozygosity","name":"$freq2"},{"kind":13,"localvar":"my","containerName":"heterozygosity","name":"$h","line":953,"definition":"my"},{"line":953,"kind":13,"containerName":"heterozygosity","name":"$samp_size"},{"containerName":"heterozygosity","kind":13,"name":"$sum","line":953},{"line":953,"name":"$samp_size","kind":13,"containerName":"heterozygosity"},{"line":954,"name":"$h","kind":13,"containerName":"heterozygosity"}],"detail":"($self,$samp_size,$freq1,$freq2)","definition":"sub","range":{"start":{"line":946,"character":0},"end":{"line":955,"character":9999}},"kind":12,"line":946,"signature":{"label":"heterozygosity($self,$samp_size,$freq1,$freq2)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2","parameters":[{"label":"$self"},{"label":"$samp_size"},{"label":"$freq1"},{"label":"$freq2"}]}},{"detail":"($self,$ingroup,$outgroup)","definition":"sub","containerName":"main::","name":"derived_mutations","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"derived_mutations","name":"$self","line":975},{"line":975,"name":"$ingroup","containerName":"derived_mutations","kind":13},{"name":"$outgroup","containerName":"derived_mutations","kind":13,"line":975},{"definition":"my","name":"%indata","containerName":"derived_mutations","localvar":"my","kind":13,"line":976},{"name":"%outdata","kind":13,"containerName":"derived_mutations","line":976},{"line":976,"kind":13,"containerName":"derived_mutations","name":"@marker_names"},{"name":"$itype","localvar":"my","containerName":"derived_mutations","kind":13,"line":980,"definition":"my"},{"name":"$otype","containerName":"derived_mutations","kind":13,"line":980},{"name":"$ingroup","containerName":"derived_mutations","kind":13,"line":980},{"line":980,"containerName":"derived_mutations","kind":13,"name":"$outgroup"},{"name":"$outgroup","kind":13,"containerName":"derived_mutations","line":982},{"line":982,"kind":13,"containerName":"derived_mutations","name":"$otype"},{"line":987,"kind":13,"containerName":"derived_mutations","name":"$ingroup"},{"name":"$ingroup","containerName":"derived_mutations","kind":13,"line":988},{"line":989,"kind":13,"containerName":"derived_mutations","name":"$ingroup"},{"kind":12,"containerName":"derived_mutations","name":"isa","line":989},{"containerName":"derived_mutations","kind":13,"name":"$self","line":990},{"line":990,"containerName":"derived_mutations","kind":12,"name":"warn"},{"line":995,"name":"@marker_names","containerName":"derived_mutations","kind":13},{"line":995,"name":"$ingroup","containerName":"derived_mutations","kind":13},{"name":"get_marker_names","kind":12,"containerName":"derived_mutations","line":995},{"line":996,"kind":13,"localvar":"my","containerName":"derived_mutations","name":"$ind","definition":"my"},{"line":996,"name":"$ingroup","kind":13,"containerName":"derived_mutations"},{"definition":"my","line":997,"localvar":"my","kind":13,"containerName":"derived_mutations","name":"$m"},{"line":997,"name":"@marker_names","kind":13,"containerName":"derived_mutations"},{"containerName":"derived_mutations","localvar":"my","kind":13,"name":"$allele","line":998,"definition":"my"},{"name":"get_Alleles","containerName":"derived_mutations","kind":12,"line":998},{"line":999,"name":"$ind","containerName":"derived_mutations","kind":13},{"name":"get_Genotypes","kind":12,"containerName":"derived_mutations","line":999},{"kind":13,"containerName":"derived_mutations","name":"$m","line":999},{"containerName":"derived_mutations","kind":13,"name":"$indata","line":1000},{"name":"$m","kind":13,"containerName":"derived_mutations","line":1000},{"containerName":"derived_mutations","kind":13,"name":"$allele","line":1000},{"name":"$ingroup","kind":13,"containerName":"derived_mutations","line":1004},{"name":"$ingroup","containerName":"derived_mutations","kind":13,"line":1004},{"line":1004,"kind":12,"containerName":"derived_mutations","name":"isa"},{"line":1005,"containerName":"derived_mutations","kind":13,"name":"@marker_names"},{"line":1005,"name":"$ingroup","containerName":"derived_mutations","kind":13},{"line":1005,"name":"get_marker_names","containerName":"derived_mutations","kind":12},{"line":1006,"containerName":"derived_mutations","localvar":"my","kind":13,"name":"$ind","definition":"my"},{"kind":13,"containerName":"derived_mutations","name":"$ingroup","line":1006},{"kind":12,"containerName":"derived_mutations","name":"haploid_population","line":1006},{"line":1006,"containerName":"derived_mutations","kind":12,"name":"get_Individuals"},{"line":1007,"name":"$m","containerName":"derived_mutations","localvar":"my","kind":13,"definition":"my"},{"line":1007,"name":"@marker_names","containerName":"derived_mutations","kind":13},{"line":1008,"name":"$allele","kind":13,"localvar":"my","containerName":"derived_mutations","definition":"my"},{"line":1008,"kind":12,"containerName":"derived_mutations","name":"get_Alleles"},{"line":1009,"name":"$ind","containerName":"derived_mutations","kind":13},{"line":1009,"kind":12,"containerName":"derived_mutations","name":"get_Genotypes"},{"line":1009,"name":"$m","kind":13,"containerName":"derived_mutations"},{"containerName":"derived_mutations","kind":13,"name":"$indata","line":1010},{"line":1010,"containerName":"derived_mutations","kind":13,"name":"$m"},{"name":"$allele","kind":13,"containerName":"derived_mutations","line":1010},{"kind":13,"containerName":"derived_mutations","name":"$self","line":1015},{"containerName":"derived_mutations","kind":12,"name":"warn","line":1015},{"kind":13,"containerName":"derived_mutations","name":"$otype","line":1019},{"containerName":"derived_mutations","kind":13,"name":"$outgroup","line":1020},{"containerName":"derived_mutations","kind":13,"name":"$outgroup","line":1021},{"line":1021,"containerName":"derived_mutations","kind":12,"name":"isa"},{"line":1022,"containerName":"derived_mutations","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"derived_mutations","line":1022},{"kind":13,"localvar":"my","containerName":"derived_mutations","name":"$ind","line":1025,"definition":"my"},{"name":"$outgroup","containerName":"derived_mutations","kind":13,"line":1025},{"definition":"my","name":"$m","localvar":"my","containerName":"derived_mutations","kind":13,"line":1026},{"line":1026,"containerName":"derived_mutations","kind":13,"name":"@marker_names"},{"definition":"my","line":1027,"containerName":"derived_mutations","localvar":"my","kind":13,"name":"$allele"},{"name":"get_Alleles","kind":12,"containerName":"derived_mutations","line":1027},{"kind":13,"containerName":"derived_mutations","name":"$ind","line":1028},{"line":1028,"name":"get_Genotypes","containerName":"derived_mutations","kind":12},{"name":"$m","kind":13,"containerName":"derived_mutations","line":1028},{"kind":13,"containerName":"derived_mutations","name":"$outdata","line":1029},{"line":1029,"containerName":"derived_mutations","kind":13,"name":"$m"},{"line":1029,"containerName":"derived_mutations","kind":13,"name":"$allele"},{"name":"$otype","containerName":"derived_mutations","kind":13,"line":1034},{"containerName":"derived_mutations","kind":12,"name":"isa","line":1034},{"definition":"my","line":1035,"name":"$ind","kind":13,"localvar":"my","containerName":"derived_mutations"},{"line":1035,"kind":13,"containerName":"derived_mutations","name":"$outgroup"},{"name":"haploid_population","kind":12,"containerName":"derived_mutations","line":1035},{"line":1035,"name":"get_Individuals","kind":12,"containerName":"derived_mutations"},{"definition":"my","line":1036,"name":"$m","containerName":"derived_mutations","localvar":"my","kind":13},{"line":1036,"containerName":"derived_mutations","kind":13,"name":"@marker_names"},{"definition":"my","line":1037,"localvar":"my","kind":13,"containerName":"derived_mutations","name":"$allele"},{"line":1037,"name":"get_Alleles","containerName":"derived_mutations","kind":12},{"line":1038,"name":"$ind","kind":13,"containerName":"derived_mutations"},{"line":1038,"kind":12,"containerName":"derived_mutations","name":"get_Genotypes"},{"containerName":"derived_mutations","kind":13,"name":"$m","line":1038},{"name":"$outdata","kind":13,"containerName":"derived_mutations","line":1039},{"name":"$m","containerName":"derived_mutations","kind":13,"line":1039},{"line":1039,"name":"$allele","kind":13,"containerName":"derived_mutations"},{"name":"$self","containerName":"derived_mutations","kind":13,"line":1044},{"kind":12,"containerName":"derived_mutations","name":"warn","line":1044},{"name":"$internal","localvar":"my","containerName":"derived_mutations","kind":13,"line":1062,"definition":"my"},{"containerName":"derived_mutations","kind":13,"name":"$external","line":1062},{"containerName":"derived_mutations","localvar":"my","kind":13,"name":"$marker","line":1063,"definition":"my"},{"line":1063,"name":"@marker_names","kind":13,"containerName":"derived_mutations"},{"localvar":"my","kind":13,"containerName":"derived_mutations","name":"@outalleles","line":1064,"definition":"my"},{"containerName":"derived_mutations","kind":13,"name":"$outdata","line":1064},{"kind":13,"containerName":"derived_mutations","name":"$marker","line":1064},{"name":"@in_alleles","containerName":"derived_mutations","localvar":"my","kind":13,"line":1065,"definition":"my"},{"name":"$indata","kind":13,"containerName":"derived_mutations","line":1065},{"line":1065,"kind":13,"containerName":"derived_mutations","name":"$marker"}],"signature":{"parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>","label":"derived_mutations($self,$ingroup,$outgroup)"},"kind":12,"range":{"start":{"line":974,"character":0},"end":{"character":9999,"line":1065}},"line":974},{"containerName":null,"kind":13,"name":"@outalleles","line":1066},{"line":1066,"kind":13,"containerName":null,"name":"@in_alleles"},{"name":"$allele","localvar":"my","kind":13,"containerName":null,"line":1067,"definition":"my"},{"name":"@in_alleles","containerName":null,"kind":13,"line":1067},{"name":"%outdata","kind":13,"containerName":null,"line":1068},{"line":1068,"name":"%marker","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%allele","line":1068},{"line":1069,"kind":13,"containerName":null,"name":"%indata"},{"line":1069,"name":"%marker","containerName":null,"kind":13},{"line":1069,"containerName":null,"kind":13,"name":"%allele"},{"line":1070,"containerName":null,"kind":13,"name":"%external"},{"line":1072,"name":"$internal","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$external","line":1077},{"name":"$internal","kind":13,"containerName":null,"line":1077},{"signature":{"label":"composite_LD($self,$pop)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA.","parameters":[{"label":"$self"},{"label":"$pop"}]},"line":1100,"range":{"start":{"character":0,"line":1100},"end":{"line":1292,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$pop)","children":[{"definition":"my","line":1101,"name":"$self","localvar":"my","containerName":"composite_LD","kind":13},{"line":1101,"containerName":"composite_LD","kind":13,"name":"$pop"},{"line":1102,"containerName":"composite_LD","kind":13,"name":"$pop"},{"line":1103,"name":"$pop","kind":13,"containerName":"composite_LD"},{"line":1103,"name":"$pop","kind":13,"containerName":"composite_LD"},{"name":"isa","containerName":"composite_LD","kind":12,"line":1103},{"line":1104,"name":"$pop","containerName":"composite_LD","kind":13},{"line":1104,"containerName":"composite_LD","kind":12,"name":"new"},{"name":"$self","kind":13,"containerName":"composite_LD","line":1106},{"line":1106,"kind":12,"containerName":"composite_LD","name":"warn"},{"line":1109,"kind":13,"containerName":"composite_LD","name":"$pop"},{"name":"$pop","kind":13,"containerName":"composite_LD","line":1109},{"kind":12,"containerName":"composite_LD","name":"isa","line":1109},{"line":1110,"name":"$self","containerName":"composite_LD","kind":13},{"line":1110,"name":"warn","kind":12,"containerName":"composite_LD"},{"definition":"my","line":1114,"name":"@marker_names","containerName":"composite_LD","localvar":"my","kind":13},{"name":"$pop","containerName":"composite_LD","kind":13,"line":1114},{"line":1114,"name":"get_marker_names","containerName":"composite_LD","kind":12},{"definition":"my","line":1115,"name":"@inds","kind":13,"localvar":"my","containerName":"composite_LD"},{"line":1115,"containerName":"composite_LD","kind":13,"name":"$pop"},{"name":"get_Individuals","kind":12,"containerName":"composite_LD","line":1115},{"line":1116,"containerName":"composite_LD","localvar":"my","kind":13,"name":"$num_inds","definition":"my"},{"name":"@inds","containerName":"composite_LD","kind":13,"line":1116},{"definition":"my","line":1117,"localvar":"my","kind":13,"containerName":"composite_LD","name":"%lookup"},{"definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"name":"$marker_name","line":1121},{"containerName":"composite_LD","kind":13,"name":"@marker_names","line":1121},{"definition":"my","name":"%allelef","localvar":"my","kind":13,"containerName":"composite_LD","line":1122},{"definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"name":"$ind","line":1124},{"containerName":"composite_LD","kind":13,"name":"@inds","line":1124},{"definition":"my","line":1125,"name":"$genotype","localvar":"my","containerName":"composite_LD","kind":13},{"line":1125,"name":"$ind","kind":13,"containerName":"composite_LD"},{"kind":12,"containerName":"composite_LD","name":"get_Genotypes","line":1125},{"kind":13,"containerName":"composite_LD","name":"$marker_name","line":1125},{"line":1126,"containerName":"composite_LD","kind":13,"name":"$genotype"},{"containerName":"composite_LD","kind":13,"name":"$self","line":1127},{"name":"warn","containerName":"composite_LD","kind":12,"line":1127},{"kind":13,"containerName":"composite_LD","name":"$ind","line":1127},{"containerName":"composite_LD","kind":12,"name":"unique_id","line":1127},{"line":1130,"name":"@alleles","localvar":"my","kind":13,"containerName":"composite_LD","definition":"my"},{"line":1130,"containerName":"composite_LD","kind":13,"name":"$genotype"},{"line":1130,"kind":12,"containerName":"composite_LD","name":"get_Alleles"},{"line":1131,"containerName":"composite_LD","kind":13,"name":"@alleles"},{"name":"$genostr","kind":13,"localvar":"my","containerName":"composite_LD","line":1132,"definition":"my"},{"kind":13,"containerName":"composite_LD","name":"@alleles","line":1132},{"containerName":"composite_LD","kind":13,"name":"$allelef","line":1133},{"line":1133,"kind":13,"containerName":"composite_LD","name":"$alleles"},{"line":1134,"name":"$allelef","containerName":"composite_LD","kind":13},{"line":1134,"name":"$alleles","containerName":"composite_LD","kind":13},{"definition":"my","localvar":"my","containerName":"composite_LD","kind":13,"name":"@alleles","line":1139},{"line":1139,"containerName":"composite_LD","kind":13,"name":"%allelef"},{"name":"$allele_count","localvar":"my","containerName":"composite_LD","kind":13,"line":1140,"definition":"my"},{"line":1140,"name":"@alleles","kind":13,"containerName":"composite_LD"},{"line":1142,"name":"$allele_count","kind":13,"containerName":"composite_LD"},{"line":1144,"containerName":"composite_LD","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"composite_LD","line":1144},{"line":1144,"kind":13,"containerName":"composite_LD","name":"@alleles"},{"name":"$allele_count","containerName":"composite_LD","kind":13,"line":1144},{"line":1150,"name":"$alleles","containerName":"composite_LD","kind":13},{"containerName":"composite_LD","kind":13,"name":"$alleles","line":1151},{"line":1152,"containerName":"composite_LD","kind":13,"name":"$self"},{"line":1152,"name":"warn","kind":12,"containerName":"composite_LD"},{"kind":13,"containerName":"composite_LD","name":"$self","line":1159},{"line":1159,"name":"debug","kind":12,"containerName":"composite_LD"},{"line":1160,"name":"$lookup","kind":13,"containerName":"composite_LD"},{"line":1160,"kind":13,"containerName":"composite_LD","name":"$marker_name"},{"line":1160,"name":"$alleles","containerName":"composite_LD","kind":13},{"line":1161,"name":"$lookup","kind":13,"containerName":"composite_LD"},{"name":"$marker_name","containerName":"composite_LD","kind":13,"line":1161},{"line":1161,"name":"$alleles","kind":13,"containerName":"composite_LD"},{"line":1164,"name":"@marker_names","containerName":"composite_LD","kind":13},{"line":1164,"containerName":"composite_LD","kind":13,"name":"%lookup"},{"name":"$site_count","kind":13,"localvar":"my","containerName":"composite_LD","line":1165,"definition":"my"},{"line":1165,"containerName":"composite_LD","kind":13,"name":"@marker_names"},{"line":1167,"name":"%stats_for_sites","localvar":"my","kind":13,"containerName":"composite_LD","definition":"my"},{"definition":"my","line":1173,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$i"},{"kind":13,"containerName":"composite_LD","name":"$i","line":1173},{"line":1173,"name":"$site_count","containerName":"composite_LD","kind":13},{"line":1173,"name":"$i","containerName":"composite_LD","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"composite_LD","name":"$site1","line":1174},{"kind":13,"containerName":"composite_LD","name":"$marker_names","line":1174},{"line":1174,"name":"$i","containerName":"composite_LD","kind":13},{"definition":"my","line":1176,"name":"$j","containerName":"composite_LD","localvar":"my","kind":13},{"line":1176,"containerName":"composite_LD","kind":13,"name":"$i"},{"line":1176,"containerName":"composite_LD","kind":13,"name":"$j"},{"line":1176,"name":"$site_count","containerName":"composite_LD","kind":13},{"kind":13,"containerName":"composite_LD","name":"$j","line":1176},{"definition":"my","kind":13,"localvar":"my","containerName":"composite_LD","name":"%genotypes","line":1177},{"name":"%total_genotype_count","containerName":"composite_LD","kind":13,"line":1177},{"line":1177,"name":"$total_pairwisegeno_count","containerName":"composite_LD","kind":13},{"containerName":"composite_LD","kind":13,"name":"%pairwise_genotypes","line":1178},{"line":1180,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$site2","definition":"my"},{"kind":13,"containerName":"composite_LD","name":"$marker_names","line":1180},{"name":"$j","containerName":"composite_LD","kind":13,"line":1180},{"definition":"my","name":"%allele_count","containerName":"composite_LD","localvar":"my","kind":13,"line":1181},{"line":1181,"name":"%allele_freqs","containerName":"composite_LD","kind":13},{"line":1182,"name":"$ind","kind":13,"localvar":"my","containerName":"composite_LD","definition":"my"},{"line":1182,"name":"@inds","kind":13,"containerName":"composite_LD"},{"line":1184,"name":"$genotype1","containerName":"composite_LD","localvar":"my","kind":13,"definition":"my"},{"line":1184,"containerName":"composite_LD","kind":13,"name":"$ind"},{"line":1184,"name":"get_Genotypes","containerName":"composite_LD","kind":12},{"line":1184,"name":"$site1","containerName":"composite_LD","kind":13},{"definition":"my","line":1185,"localvar":"my","containerName":"composite_LD","kind":13,"name":"@alleles1"},{"line":1185,"name":"$genotype1","containerName":"composite_LD","kind":13},{"line":1185,"name":"get_Alleles","containerName":"composite_LD","kind":12},{"line":1191,"kind":13,"containerName":"composite_LD","name":"@alleles1"},{"definition":"my","name":"$genostr1","localvar":"my","kind":13,"containerName":"composite_LD","line":1192},{"name":"@alleles1","kind":13,"containerName":"composite_LD","line":1192},{"line":1195,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$genotype2","definition":"my"},{"line":1195,"name":"$ind","containerName":"composite_LD","kind":13},{"line":1195,"name":"get_Genotypes","containerName":"composite_LD","kind":12},{"line":1195,"name":"$site2","containerName":"composite_LD","kind":13},{"name":"@alleles2","kind":13,"localvar":"my","containerName":"composite_LD","line":1196,"definition":"my"},{"line":1196,"name":"$genotype2","kind":13,"containerName":"composite_LD"},{"line":1196,"name":"get_Alleles","kind":12,"containerName":"composite_LD"},{"line":1197,"name":"$genostr2","localvar":"my","kind":13,"containerName":"composite_LD","definition":"my"},{"line":1197,"name":"@alleles2","kind":13,"containerName":"composite_LD"},{"containerName":"composite_LD","kind":13,"name":"@alleles2","line":1199},{"kind":13,"containerName":"composite_LD","name":"@alleles1","line":1200},{"line":1201,"name":"$allele_count","containerName":"composite_LD","kind":13},{"line":1201,"name":"$site1","containerName":"composite_LD","kind":13},{"name":"$allele_freqs","kind":13,"containerName":"composite_LD","line":1202},{"line":1202,"kind":13,"containerName":"composite_LD","name":"$site1"},{"line":1204,"containerName":"composite_LD","kind":13,"name":"$genotypes"},{"name":"$site1","kind":13,"containerName":"composite_LD","line":1204},{"containerName":"composite_LD","kind":13,"name":"$genostr1","line":1204},{"line":1205,"name":"$total_genotype_count","kind":13,"containerName":"composite_LD"},{"line":1205,"name":"$site1","containerName":"composite_LD","kind":13},{"kind":13,"containerName":"composite_LD","name":"@alleles2","line":1207},{"containerName":"composite_LD","kind":13,"name":"$allele_count","line":1208},{"line":1208,"name":"$site2","containerName":"composite_LD","kind":13},{"name":"$allele_freqs","kind":13,"containerName":"composite_LD","line":1209},{"line":1209,"name":"$site2","containerName":"composite_LD","kind":13},{"line":1211,"name":"$genotypes","kind":13,"containerName":"composite_LD"},{"line":1211,"containerName":"composite_LD","kind":13,"name":"$site2"},{"name":"$genostr2","containerName":"composite_LD","kind":13,"line":1211},{"kind":13,"containerName":"composite_LD","name":"$total_genotype_count","line":1212},{"line":1212,"containerName":"composite_LD","kind":13,"name":"$site2"},{"line":1216,"containerName":"composite_LD","kind":13,"name":"$pairwise_genotypes"},{"containerName":"composite_LD","kind":13,"name":"$total_pairwisegeno_count","line":1218},{"definition":"my","line":1220,"name":"$site","kind":13,"localvar":"my","containerName":"composite_LD"},{"name":"%allele_freqs","kind":13,"containerName":"composite_LD","line":1220},{"name":"$al","localvar":"my","containerName":"composite_LD","kind":13,"line":1221,"definition":"my"},{"name":"$allele_freqs","containerName":"composite_LD","kind":13,"line":1221},{"name":"$site","kind":13,"containerName":"composite_LD","line":1221},{"containerName":"composite_LD","kind":13,"name":"$allele_freqs","line":1222},{"line":1222,"name":"$site","kind":13,"containerName":"composite_LD"},{"line":1222,"containerName":"composite_LD","kind":13,"name":"$al"},{"line":1222,"name":"$allele_count","containerName":"composite_LD","kind":13},{"name":"$site","kind":13,"containerName":"composite_LD","line":1222},{"definition":"my","name":"$n","containerName":"composite_LD","localvar":"my","kind":13,"line":1225},{"line":1225,"name":"$total_pairwisegeno_count","kind":13,"containerName":"composite_LD"},{"definition":"my","name":"$allele1_site1","localvar":"my","kind":13,"containerName":"composite_LD","line":1227},{"line":1227,"kind":13,"containerName":"composite_LD","name":"$lookup"},{"name":"$site1","containerName":"composite_LD","kind":13,"line":1227},{"definition":"my","line":1228,"name":"$allele1_site2","localvar":"my","containerName":"composite_LD","kind":13},{"line":1228,"name":"$lookup","containerName":"composite_LD","kind":13},{"line":1228,"name":"$site2","containerName":"composite_LD","kind":13},{"localvar":"my","containerName":"composite_LD","kind":13,"name":"$allele2_site1","line":1229,"definition":"my"},{"name":"$lookup","kind":13,"containerName":"composite_LD","line":1229},{"line":1229,"kind":13,"containerName":"composite_LD","name":"$site1"},{"containerName":"composite_LD","localvar":"my","kind":13,"name":"$allele2_site2","line":1230,"definition":"my"},{"line":1230,"name":"$lookup","kind":13,"containerName":"composite_LD"},{"line":1230,"name":"$site2","containerName":"composite_LD","kind":13},{"localvar":"my","containerName":"composite_LD","kind":13,"name":"$N1genostr","line":1232,"definition":"my"},{"line":1232,"containerName":"composite_LD","kind":13,"name":"$allele1_site1"},{"name":"$allele1_site1","kind":13,"containerName":"composite_LD","line":1232},{"line":1233,"kind":13,"containerName":"composite_LD","name":"$allele1_site2"},{"kind":13,"containerName":"composite_LD","name":"$allele1_site2","line":1233},{"line":1234,"kind":13,"containerName":"composite_LD","name":"$self"},{"line":1234,"kind":12,"containerName":"composite_LD","name":"debug"},{"definition":"my","line":1236,"containerName":"composite_LD","localvar":"my","kind":13,"name":"$N2genostr"},{"line":1236,"name":"$allele1_site1","containerName":"composite_LD","kind":13},{"name":"$allele1_site1","kind":13,"containerName":"composite_LD","line":1236},{"containerName":"composite_LD","kind":13,"name":"$allele1_site2","line":1237},{"line":1237,"name":"$allele2_site2","containerName":"composite_LD","kind":13},{"line":1238,"kind":13,"containerName":"composite_LD","name":"$self"},{"kind":12,"containerName":"composite_LD","name":"debug","line":1238},{"name":"$N4genostr","containerName":"composite_LD","localvar":"my","kind":13,"line":1240,"definition":"my"},{"line":1240,"containerName":"composite_LD","kind":13,"name":"$allele1_site1"},{"line":1240,"name":"$allele2_site1","kind":13,"containerName":"composite_LD"},{"line":1241,"containerName":"composite_LD","kind":13,"name":"$allele1_site2"},{"name":"$allele1_site2","kind":13,"containerName":"composite_LD","line":1241},{"name":"$self","containerName":"composite_LD","kind":13,"line":1242},{"line":1242,"name":"debug","containerName":"composite_LD","kind":12},{"name":"$N5genostr","localvar":"my","kind":13,"containerName":"composite_LD","line":1244,"definition":"my"},{"kind":13,"containerName":"composite_LD","name":"$allele1_site1","line":1244},{"line":1244,"containerName":"composite_LD","kind":13,"name":"$allele2_site1"},{"line":1245,"containerName":"composite_LD","kind":13,"name":"$allele1_site2"},{"kind":13,"containerName":"composite_LD","name":"$allele2_site2","line":1245},{"line":1246,"containerName":"composite_LD","kind":13,"name":"$self"},{"line":1246,"name":"debug","containerName":"composite_LD","kind":12},{"line":1248,"containerName":"composite_LD","localvar":"my","kind":13,"name":"$n1","definition":"my"},{"line":1248,"name":"$pairwise_genotypes","kind":13,"containerName":"composite_LD"},{"line":1248,"kind":13,"containerName":"composite_LD","name":"$N1genostr"},{"definition":"my","localvar":"my","containerName":"composite_LD","kind":13,"name":"$n2","line":1250},{"name":"$pairwise_genotypes","containerName":"composite_LD","kind":13,"line":1250},{"line":1250,"kind":13,"containerName":"composite_LD","name":"$N2genostr"},{"name":"$n4","containerName":"composite_LD","localvar":"my","kind":13,"line":1252,"definition":"my"},{"line":1252,"containerName":"composite_LD","kind":13,"name":"$pairwise_genotypes"},{"line":1252,"name":"$N4genostr","containerName":"composite_LD","kind":13},{"line":1254,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$n5","definition":"my"},{"line":1254,"kind":13,"containerName":"composite_LD","name":"$pairwise_genotypes"},{"line":1254,"kind":13,"containerName":"composite_LD","name":"$N5genostr"},{"definition":"my","line":1256,"name":"$homozA_site1","localvar":"my","kind":13,"containerName":"composite_LD"},{"name":"$allele1_site1","kind":13,"containerName":"composite_LD","line":1256},{"line":1256,"name":"$allele1_site1","containerName":"composite_LD","kind":13},{"localvar":"my","containerName":"composite_LD","kind":13,"name":"$homozB_site2","line":1257,"definition":"my"},{"line":1257,"containerName":"composite_LD","kind":13,"name":"$allele1_site2"},{"name":"$allele1_site2","containerName":"composite_LD","kind":13,"line":1257},{"name":"$p_AA","localvar":"my","containerName":"composite_LD","kind":13,"line":1258,"definition":"my"},{"name":"$genotypes","kind":13,"containerName":"composite_LD","line":1258},{"line":1258,"name":"$site1","kind":13,"containerName":"composite_LD"},{"line":1258,"name":"$homozA_site1","containerName":"composite_LD","kind":13},{"line":1258,"name":"$n","kind":13,"containerName":"composite_LD"},{"line":1259,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$p_BB","definition":"my"},{"line":1259,"containerName":"composite_LD","kind":13,"name":"$genotypes"},{"containerName":"composite_LD","kind":13,"name":"$site2","line":1259},{"line":1259,"name":"$homozB_site2","containerName":"composite_LD","kind":13},{"line":1259,"kind":13,"containerName":"composite_LD","name":"$n"},{"line":1260,"kind":13,"localvar":"my","containerName":"composite_LD","name":"$p_A","definition":"my"},{"kind":13,"containerName":"composite_LD","name":"$allele_freqs","line":1260},{"kind":13,"containerName":"composite_LD","name":"$site1","line":1260},{"line":1260,"containerName":"composite_LD","kind":13,"name":"$allele1_site1"},{"line":1261,"localvar":"my","kind":13,"containerName":"composite_LD","name":"$p_a","definition":"my"},{"kind":13,"containerName":"composite_LD","name":"$p_A","line":1261},{"localvar":"my","containerName":"composite_LD","kind":13,"name":"$p_B","line":1263,"definition":"my"},{"line":1263,"name":"$allele_freqs","kind":13,"containerName":"composite_LD"},{"line":1263,"kind":13,"containerName":"composite_LD","name":"$site2"},{"line":1263,"containerName":"composite_LD","kind":13,"name":"$allele1_site2"},{"definition":"my","line":1264,"name":"$p_b","localvar":"my","kind":13,"containerName":"composite_LD"},{"line":1264,"kind":13,"containerName":"composite_LD","name":"$p_B"},{"name":"$pi_A","containerName":"composite_LD","localvar":"my","kind":13,"line":1267,"definition":"my"},{"line":1267,"name":"$p_A","containerName":"composite_LD","kind":13},{"line":1267,"name":"$p_a","containerName":"composite_LD","kind":13},{"line":1268,"name":"$pi_B","localvar":"my","kind":13,"containerName":"composite_LD","definition":"my"},{"name":"$p_B","kind":13,"containerName":"composite_LD","line":1268},{"containerName":"composite_LD","kind":13,"name":"$p_b","line":1268},{"definition":"my","name":"$D_A","containerName":"composite_LD","localvar":"my","kind":13,"line":1271},{"name":"$p_AA","containerName":"composite_LD","kind":13,"line":1271},{"line":1271,"name":"$p_A","containerName":"composite_LD","kind":13},{"line":1272,"name":"$D_B","containerName":"composite_LD","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"composite_LD","name":"$p_BB","line":1272},{"name":"$p_B","kind":13,"containerName":"composite_LD","line":1272},{"line":1273,"localvar":"my","containerName":"composite_LD","kind":13,"name":"$n_AB","definition":"my"},{"name":"$n1","containerName":"composite_LD","kind":13,"line":1273},{"kind":13,"containerName":"composite_LD","name":"$n2","line":1273},{"name":"$n4","containerName":"composite_LD","kind":13,"line":1273},{"line":1273,"kind":13,"containerName":"composite_LD","name":"$n5"},{"containerName":"composite_LD","kind":13,"name":"$self","line":1274},{"line":1274,"name":"debug","containerName":"composite_LD","kind":12},{"definition":"my","name":"$delta_AB","localvar":"my","kind":13,"containerName":"composite_LD","line":1276},{"line":1276,"name":"$n","kind":13,"containerName":"composite_LD"},{"kind":13,"containerName":"composite_LD","name":"$n_AB","line":1276},{"name":"$p_A","kind":13,"containerName":"composite_LD","line":1276},{"line":1276,"containerName":"composite_LD","kind":13,"name":"$p_B"},{"kind":13,"containerName":"composite_LD","name":"$self","line":1277},{"containerName":"composite_LD","kind":12,"name":"debug","line":1277},{"line":1278,"name":"$self","containerName":"composite_LD","kind":13},{"name":"debug","containerName":"composite_LD","kind":12,"line":1278},{"containerName":"composite_LD","kind":13,"name":"$n","line":1279},{"line":1279,"containerName":"composite_LD","kind":13,"name":"$delta_AB"},{"containerName":"composite_LD","kind":13,"name":"$pi_A","line":1279},{"line":1279,"name":"$D_A","containerName":"composite_LD","kind":13},{"kind":13,"containerName":"composite_LD","name":"$pi_B","line":1279},{"kind":13,"containerName":"composite_LD","name":"$D_B","line":1279},{"definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"name":"$chisquared","line":1281},{"name":"$chisquared","kind":13,"containerName":"composite_LD","line":1282},{"name":"$n","containerName":"composite_LD","kind":13,"line":1282},{"name":"$delta_AB","containerName":"composite_LD","kind":13,"line":1282},{"containerName":"composite_LD","kind":13,"name":"$pi_A","line":1283},{"name":"$D_A","containerName":"composite_LD","kind":13,"line":1283},{"line":1283,"name":"$pi_B","kind":13,"containerName":"composite_LD"},{"kind":13,"containerName":"composite_LD","name":"$D_B","line":1283},{"kind":13,"containerName":"composite_LD","name":"$self","line":1286},{"name":"debug","kind":12,"containerName":"composite_LD","line":1286},{"line":1290,"kind":13,"containerName":"composite_LD","name":"$stats_for_sites"},{"line":1290,"name":"$site1","containerName":"composite_LD","kind":13},{"line":1290,"kind":13,"containerName":"composite_LD","name":"$site2"},{"containerName":"composite_LD","kind":13,"name":"$delta_AB","line":1290},{"name":"$chisquared","kind":13,"containerName":"composite_LD","line":1290}],"name":"composite_LD","containerName":"main::"},{"line":1104,"containerName":"PopGen::Population","kind":12,"name":"Bio"},{"name":"%stats_for_sites","containerName":null,"kind":13,"line":1293},{"signature":{"label":"mcdonald_kreitman($self,@args)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA.\n\n\nsub composite_LD {\n    my ($self,$pop) = @_;\n    if( ref($pop) =~ /ARRAY/i ) {\n\tif( ref($pop->[0]) && $pop->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t    $pop = Bio::PopGen::Population->new(-individuals => @$pop);\n\t} else { \n\t    $self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\t    return ();\n\t}\n    } elsif( ! ref($pop) || ! $pop->isa('Bio::PopGen::PopulationI') ) {\n\t$self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\treturn ();\n    }\n\n    my @marker_names = $pop->get_marker_names;\n    my @inds = $pop->get_Individuals;\n    my $num_inds = scalar @inds;\n    my (%lookup);\n    # calculate allele frequencies for each marker from the population\n    # use the built-in get_Marker to get the allele freqs\n    # we still need to calculate the genotype frequencies\n    foreach my $marker_name ( @marker_names ) {\t\n\tmy(%allelef);\n\n\tforeach my $ind ( @inds ) {\n\t    my ($genotype) = $ind->get_Genotypes(-marker => $marker_name);\n\t    if( ! defined $genotype ) { \n\t\t$self->warn(\"no genotype for marker $marker_name for individual \". $ind->unique_id. \"\\n\");\n\t\tnext;\n\t    }\n\t    my @alleles  = sort $genotype->get_Alleles;\n\t    next if( scalar @alleles != 2);\n\t    my $genostr  = join(',', @alleles);\n            $allelef{$alleles[0]}++;\n            $allelef{$alleles[1]}++;\n\t}\n\n\t# we should check for cases where there > 2 alleles or\n\t# only 1 allele and throw out those markers.\n\tmy @alleles      = sort keys %allelef;\n\tmy $allele_count = scalar @alleles;\n\t# test if site is polymorphic\n\tif( $allele_count != 2) { \n\t    # only really warn if we're seeing multi-allele\n\t    $self->warn(\"Skipping $marker_name because it has $allele_count alleles (\".join(',',@alleles).\"), \\ncomposite_LD will currently only work for biallelic markers\") if $allele_count > 2;\n\t    next;\t\t# skip this marker\n\t}\n\n\t# Need to do something here to detect alleles which aren't \n\t# a single character\n\tif( length($alleles[0]) != 1 ||\n\t    length($alleles[1]) != 1 ) {\n\t    $self->warn(\"An individual has an allele which is not a single base, this is currently not supported in composite_LD - consider recoding the allele as a single character\");\n\t    next;\n\t}\n\n\t# fix the call for allele 1 (A or B) and \n\t# allele 2 (a or b) in terms of how we'll do the \n\t# N square from Weir p.126\n\t$self->debug( \"$alleles[0] is 1, $alleles[1] is 2 for $marker_name\\n\");\n\t$lookup{$marker_name}->{'1'} = $alleles[0];\n\t$lookup{$marker_name}->{'2'} = $alleles[1];\n    }\n\n    @marker_names = sort keys %lookup;\n    my $site_count   = scalar @marker_names;\n    # where the final data will be stored\n    my %stats_for_sites;\n\n    # standard way of generating pairwise combos\n    # LD is done by comparing all the pairwise site (marker)\n    # combinations and keeping track of the genotype and \n    # pairwise genotype (ie genotypes of the 2 sites) frequencies\n    for( my $i = 0; $i < $site_count - 1; $i++ ) {\n\tmy $site1 = $marker_names[$i];\n\n\tfor( my $j = $i+1; $j < $site_count ; $j++) { \t \n\t    my (%genotypes, %total_genotype_count,$total_pairwisegeno_count,\n\t\t%pairwise_genotypes);\n\t \n\t    my $site2 = $marker_names[$j];\n\t    my (%allele_count,%allele_freqs) = (0,0);\n\t    foreach my $ind ( @inds ) {\n\t\t# build string of genotype at site 1\n\t\tmy ($genotype1) = $ind->get_Genotypes(-marker => $site1);\n\t\tmy @alleles1  = sort $genotype1->get_Alleles;\n\n                # if an individual has only one available allele\n\t\t# (has a blank or N for one of the chromosomes)\n\t\t# we don't want to use it in our calculation\n\n\t\tnext unless( scalar @alleles1 == 2);\n\t\tmy $genostr1  = join(',', @alleles1);\n\n\t\t# build string of genotype at site 2\n\t\tmy ($genotype2) = $ind->get_Genotypes(-marker => $site2);\n\t\tmy @alleles2  = sort $genotype2->get_Alleles;\n\t\tmy $genostr2  = join(',', @alleles2);\n\t\t\n\t\tnext unless( scalar @alleles2 == 2);\n\t\tfor (@alleles1) {\n\t\t    $allele_count{$site1}++;\n\t\t    $allele_freqs{$site1}->{$_}++;\n\t\t}\n\t\t$genotypes{$site1}->{$genostr1}++;\n\t\t$total_genotype_count{$site1}++;\n\n\t\tfor (@alleles2) {\n\t\t    $allele_count{$site2}++;\n\t\t    $allele_freqs{$site2}->{$_}++;\n\t\t}\n\t\t$genotypes{$site2}->{$genostr2}++;\n\t\t$total_genotype_count{$site2}++;\n\n\t\t# We are using the $site1,$site2 to signify\n\t\t# a unique key\n\t\t$pairwise_genotypes{\"$genostr1,$genostr2\"}++;\n\t\t# some individuals \n\t\t$total_pairwisegeno_count++;\n\t    }\n\t    for my $site ( %allele_freqs ) {\n\t\tfor my $al ( keys %{ $allele_freqs{$site} } ) {\n\t\t    $allele_freqs{$site}->{$al} /= $allele_count{$site};\n\t\t}\n\t    }\n\t    my $n = $total_pairwisegeno_count;\t# number of pairs of comparisons\n\t    # 'A' and 'B' are two loci or in our case site1 and site2  \n\t    my $allele1_site1 = $lookup{$site1}->{'1'};\t# this is the BigA allele\n\t    my $allele1_site2 = $lookup{$site2}->{'1'};\t# this is the BigB allele\n\t    my $allele2_site1 = $lookup{$site1}->{'2'};\t# this is the LittleA allele\n\t    my $allele2_site2 = $lookup{$site2}->{'2'};\t# this is the LittleB allele\n\t    # AABB\n\t    my $N1genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AABB) N1genostr=$N1genostr\\n\");\n\t    # AABb\n\t    my $N2genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AABb) N2genostr=$N2genostr\\n\");\n\t    # AaBB\n\t    my $N4genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AaBB) N4genostr=$N4genostr\\n\");\n\t    # AaBb\n\t    my $N5genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AaBb) N5genostr=$N5genostr\\n\");\n\t    # count of AABB in \n\t    my $n1 = $pairwise_genotypes{$N1genostr} || 0;\n\t    # count of AABb in \n\t    my $n2 = $pairwise_genotypes{$N2genostr} || 0;\n\t    # count of AaBB in \n\t    my $n4 = $pairwise_genotypes{$N4genostr} || 0;\n\t    # count of AaBb in \n\t    my $n5 = $pairwise_genotypes{$N5genostr} || 0;\n\n\t    my $homozA_site1 = join(\",\", ($allele1_site1,$allele1_site1));\n\t    my $homozB_site2 = join(\",\", ($allele1_site2,$allele1_site2));\n\t    my $p_AA = ($genotypes{$site1}->{$homozA_site1} || 0) / $n;\n\t    my $p_BB = ($genotypes{$site2}->{$homozB_site2} || 0) / $n;\n\t    my $p_A  = $allele_freqs{$site1}->{$allele1_site1} || 0;\t# an individual allele freq\n\t    my $p_a  =  1 - $p_A;\n\n\t    my $p_B  = $allele_freqs{$site2}->{$allele1_site2} || 0;\t# an individual allele freq\n\t    my $p_b  =  1 - $p_B;\n\n\t    # variance of allele frequencies\n\t    my $pi_A = $p_A * $p_a;\n\t    my $pi_B = $p_B * $p_b;\n\n\t    # hardy weinberg\n\t    my $D_A  = $p_AA - $p_A**2;\n\t    my $D_B  = $p_BB - $p_B**2;\n\t    my $n_AB = 2*$n1 + $n2 + $n4 + 0.5 * $n5;\n\t    $self->debug(\"n_AB=$n_AB -- n1=$n1, n2=$n2 n4=$n4 n5=$n5\\n\");\n\n\t    my $delta_AB = (1 / $n ) * ( $n_AB ) - ( 2 * $p_A * $p_B );\n\t    $self->debug(\"delta_AB=$delta_AB -- n=$n, n_AB=$n_AB p_A=$p_A, p_B=$p_B\\n\");\n\t    $self->debug(sprintf(\" (%d * %.4f) / ( %.2f + %.2f) * ( %.2f + %.2f) \\n\",\n\t\t\t\t $n,$delta_AB**2, $pi_A, $D_A, $pi_B, $D_B));\n\t    \n\t    my $chisquared;\n\t    eval { $chisquared = ( $n * ($delta_AB**2) ) / \n\t\t       ( ( $pi_A + $D_A) * ( $pi_B + $D_B) );\n\t       };\n\t    if( $@ ) {\n\t\t$self->debug(\"Skipping the site because the denom is 0.\\nsite1=$site1, site2=$site2 : pi_A=$pi_A, pi_B=$pi_B D_A=$D_A, D_B=$D_B\\n\");\n\t\tnext;\n\t    }\n\t    # this will be an upper triangular matrix\n\t    $stats_for_sites{$site1}->{$site2} = [$delta_AB,$chisquared];\n\t}\n    }\n    return %stats_for_sites;\n}\n\n=head2 mcdonald_kreitman\n\n Title   : mcdonald_kreitman\n Usage   : $Fstat = mcdonald_kreitman($ingroup, $outgroup);\n Function: Calculates McDonald-Kreitman statistic based on a set of ingroup\n           individuals and an outgroup by computing the number of \n           differences at synonymous and non-synonymous sites\n           for intraspecific comparisons and with the outgroup \n Returns : 2x2 table, followed by a hash reference indicating any \n           warning messages about the status of the alleles or codons \n Args    : -ingroup    => L<Bio::PopGen::Population> object or \n                          arrayref of L<Bio::PopGen::Individual>s \n           -outgroup   => L<Bio::PopGen::Population> object or \n                          arrayef of L<Bio::PopGen::Individual>s\n           -polarized  => Boolean, to indicate if this should be \n                          a polarized test. Must provide two individuals \n                          as outgroups.","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"end":{"character":9999,"line":1410},"start":{"character":0,"line":1316}},"line":1316,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"mcdonald_kreitman","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"mcdonald_kreitman","name":"$self","line":1317},{"kind":13,"containerName":"mcdonald_kreitman","name":"@args","line":1317},{"line":1318,"localvar":"my","containerName":"mcdonald_kreitman","kind":13,"name":"$ingroup","definition":"my"},{"kind":13,"containerName":"mcdonald_kreitman","name":"$outgroup","line":1318},{"line":1318,"containerName":"mcdonald_kreitman","kind":13,"name":"$polarized"},{"name":"$self","kind":13,"containerName":"mcdonald_kreitman","line":1319},{"line":1319,"containerName":"mcdonald_kreitman","kind":12,"name":"_rearrange"},{"line":1319,"name":"@args","containerName":"mcdonald_kreitman","kind":13},{"localvar":"my","kind":13,"containerName":"mcdonald_kreitman","name":"$verbose","line":1320,"definition":"my"},{"containerName":"mcdonald_kreitman","kind":13,"name":"$self","line":1320},{"line":1320,"name":"verbose","containerName":"mcdonald_kreitman","kind":12},{"name":"$outgroup_count","kind":13,"localvar":"my","containerName":"mcdonald_kreitman","line":1321,"definition":"my"},{"line":1322,"name":"$gapchar","localvar":"my","kind":13,"containerName":"mcdonald_kreitman","definition":"my"},{"name":"$outgroup","containerName":"mcdonald_kreitman","kind":13,"line":1323},{"containerName":"mcdonald_kreitman","kind":13,"name":"$outgroup_count","line":1324},{"line":1324,"name":"$outgroup","kind":13,"containerName":"mcdonald_kreitman"},{"name":"$outgroup","kind":13,"containerName":"mcdonald_kreitman","line":1325},{"containerName":"mcdonald_kreitman","kind":13,"name":"$outgroup_count","line":1326},{"containerName":"mcdonald_kreitman","kind":13,"name":"$outgroup","line":1326},{"kind":12,"containerName":"mcdonald_kreitman","name":"get_number_individuals","line":1326},{"name":"$self","containerName":"mcdonald_kreitman","kind":13,"line":1328},{"line":1328,"kind":12,"containerName":"mcdonald_kreitman","name":"throw"},{"kind":13,"containerName":"mcdonald_kreitman","name":"$polarized","line":1331},{"kind":13,"containerName":"mcdonald_kreitman","name":"$outgroup_count","line":1332},{"line":1333,"containerName":"mcdonald_kreitman","kind":13,"name":"$self"},{"line":1333,"name":"throw","kind":12,"containerName":"mcdonald_kreitman"},{"line":1335,"kind":13,"containerName":"mcdonald_kreitman","name":"$outgroup_count"},{"name":"$self","kind":13,"containerName":"mcdonald_kreitman","line":1336},{"kind":12,"containerName":"mcdonald_kreitman","name":"warn","line":1336},{"line":1336,"name":"$outgroup_count","kind":13,"containerName":"mcdonald_kreitman"},{"line":1337,"containerName":"mcdonald_kreitman","kind":13,"name":"$outgroup_count"},{"line":1338,"containerName":"mcdonald_kreitman","kind":13,"name":"$self"},{"name":"throw","containerName":"mcdonald_kreitman","kind":12,"line":1338},{"line":1341,"name":"$codon_path","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"definition":"my"},{"containerName":"mcdonald_kreitman","kind":12,"name":"codon_path","line":1341},{"containerName":"mcdonald_kreitman","localvar":"my","kind":13,"name":"%marker_names","line":1343,"definition":"my"},{"name":"%unique","kind":13,"containerName":"mcdonald_kreitman","line":1343},{"line":1343,"name":"@inds","kind":13,"containerName":"mcdonald_kreitman"},{"definition":"my","line":1344,"name":"$p","localvar":"my","kind":13,"containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","kind":13,"name":"$ingroup","line":1344},{"line":1344,"name":"$outgroup","containerName":"mcdonald_kreitman","kind":13},{"line":1345,"name":"$p","kind":13,"containerName":"mcdonald_kreitman"},{"name":"@inds","kind":13,"containerName":"mcdonald_kreitman","line":1346},{"line":1346,"name":"$p","containerName":"mcdonald_kreitman","kind":13},{"line":1348,"kind":13,"containerName":"mcdonald_kreitman","name":"@inds"},{"line":1348,"kind":13,"containerName":"mcdonald_kreitman","name":"$p"},{"name":"get_Individuals","kind":12,"containerName":"mcdonald_kreitman","line":1348},{"definition":"my","line":1351,"name":"$i","localvar":"my","containerName":"mcdonald_kreitman","kind":13},{"line":1351,"kind":13,"containerName":"mcdonald_kreitman","name":"@inds"},{"kind":13,"containerName":"mcdonald_kreitman","name":"$unique","line":1352},{"line":1352,"name":"$i","containerName":"mcdonald_kreitman","kind":13},{"line":1352,"name":"unique_id","containerName":"mcdonald_kreitman","kind":12},{"line":1353,"name":"$self","kind":13,"containerName":"mcdonald_kreitman"},{"line":1353,"name":"warn","containerName":"mcdonald_kreitman","kind":12},{"line":1353,"name":"$i","containerName":"mcdonald_kreitman","kind":13},{"line":1353,"name":"unique_id","kind":12,"containerName":"mcdonald_kreitman"},{"definition":"my","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"name":"$n","line":1355},{"kind":13,"containerName":"mcdonald_kreitman","name":"$i","line":1355},{"line":1355,"name":"get_marker_names","containerName":"mcdonald_kreitman","kind":12},{"kind":13,"containerName":"mcdonald_kreitman","name":"$marker_names","line":1356},{"line":1356,"containerName":"mcdonald_kreitman","kind":13,"name":"$n"},{"line":1360,"containerName":"mcdonald_kreitman","localvar":"my","kind":13,"name":"@marker_names","definition":"my"},{"line":1360,"containerName":"mcdonald_kreitman","kind":13,"name":"%marker_names"},{"containerName":"mcdonald_kreitman","kind":13,"name":"$marker_names","line":1361},{"line":1364,"name":"@marker_names","containerName":"mcdonald_kreitman","kind":13},{"name":"$a","kind":13,"containerName":"mcdonald_kreitman","line":1365},{"name":"$b","kind":13,"containerName":"mcdonald_kreitman","line":1365},{"line":1366,"name":"@marker_names","kind":13,"containerName":"mcdonald_kreitman"},{"localvar":"my","containerName":"mcdonald_kreitman","kind":13,"name":"$num_inds","line":1370,"definition":"my"},{"name":"@inds","containerName":"mcdonald_kreitman","kind":13,"line":1370},{"definition":"my","name":"%vals","localvar":"my","kind":13,"containerName":"mcdonald_kreitman","line":1371},{"kind":13,"containerName":"mcdonald_kreitman","name":"$ingroup","line":1371},{"line":1372,"name":"$outgroup","containerName":"mcdonald_kreitman","kind":13},{"containerName":"mcdonald_kreitman","localvar":"my","kind":13,"name":"$table","line":1376,"definition":"my"},{"line":1376,"name":"new","kind":12,"containerName":"mcdonald_kreitman"},{"name":"$codon_table","kind":13,"containerName":"mcdonald_kreitman","line":1376},{"localvar":"my","kind":13,"containerName":"mcdonald_kreitman","name":"@vt","line":1377,"definition":"my"},{"line":1378,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","name":"%changes","definition":"my"},{"definition":"my","line":1379,"name":"%status","kind":13,"localvar":"my","containerName":"mcdonald_kreitman"},{"definition":"my","name":"%two_by_two","localvar":"my","kind":13,"containerName":"mcdonald_kreitman","line":1380},{"definition":"my","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"name":"$codon","line":1385},{"containerName":"mcdonald_kreitman","kind":13,"name":"@marker_names","line":1385},{"line":1386,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","name":"%codonvals","definition":"my"},{"name":"%all_alleles","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"line":1387,"definition":"my"},{"definition":"my","line":1388,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","name":"$t"},{"name":"@vt","kind":13,"containerName":"mcdonald_kreitman","line":1388},{"line":1389,"localvar":"my","kind":13,"containerName":"mcdonald_kreitman","name":"$outcount","definition":"my"},{"line":1390,"name":"$ind","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"definition":"my"},{"line":1390,"name":"$vals","kind":13,"containerName":"mcdonald_kreitman"},{"line":1390,"kind":13,"containerName":"mcdonald_kreitman","name":"$t"},{"name":"@alleles","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"line":1391,"definition":"my"},{"line":1391,"name":"$ind","kind":13,"containerName":"mcdonald_kreitman"},{"name":"get_Genotypes","kind":12,"containerName":"mcdonald_kreitman","line":1391},{"name":"$codon","containerName":"mcdonald_kreitman","kind":13,"line":1391},{"line":1391,"name":"get_Alleles","containerName":"mcdonald_kreitman","kind":12},{"name":"@alleles","kind":13,"containerName":"mcdonald_kreitman","line":1392},{"definition":"my","name":"$allele","localvar":"my","kind":13,"containerName":"mcdonald_kreitman","line":1396},{"name":"@alleles","containerName":"mcdonald_kreitman","kind":13,"line":1396},{"name":"$all_alleles","kind":13,"containerName":"mcdonald_kreitman","line":1397},{"line":1397,"containerName":"mcdonald_kreitman","kind":13,"name":"$ind"},{"line":1397,"name":"unique_id","containerName":"mcdonald_kreitman","kind":12},{"kind":13,"containerName":"mcdonald_kreitman","name":"$allele","line":1397},{"name":"$AA","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"line":1398,"definition":"my"},{"line":1398,"kind":13,"containerName":"mcdonald_kreitman","name":"$table"},{"name":"translate","containerName":"mcdonald_kreitman","kind":12,"line":1398},{"name":"$allele","kind":13,"containerName":"mcdonald_kreitman","line":1398},{"name":"$AA","containerName":"mcdonald_kreitman","kind":13,"line":1399},{"containerName":"mcdonald_kreitman","kind":13,"name":"$AA","line":1399},{"line":1399,"name":"$allele","kind":13,"containerName":"mcdonald_kreitman"},{"definition":"my","line":1401,"localvar":"my","containerName":"mcdonald_kreitman","kind":13,"name":"$label"},{"line":1401,"containerName":"mcdonald_kreitman","kind":13,"name":"$t"},{"line":1402,"kind":13,"containerName":"mcdonald_kreitman","name":"$t"},{"line":1403,"name":"$label","kind":13,"containerName":"mcdonald_kreitman"},{"line":1403,"name":"$t","kind":13,"containerName":"mcdonald_kreitman"},{"line":1403,"name":"$outcount","containerName":"mcdonald_kreitman","kind":13},{"containerName":"mcdonald_kreitman","kind":13,"name":"$codonvals","line":1405},{"name":"$label","containerName":"mcdonald_kreitman","kind":13,"line":1405},{"name":"$allele","kind":13,"containerName":"mcdonald_kreitman","line":1405},{"line":1406,"name":"$codonvals","containerName":"mcdonald_kreitman","kind":13},{"line":1406,"name":"$allele","kind":13,"containerName":"mcdonald_kreitman"},{"definition":"my","name":"$total","localvar":"my","containerName":"mcdonald_kreitman","kind":13,"line":1410},{"kind":13,"containerName":"mcdonald_kreitman","name":"$codonvals","line":1410}]},{"line":1325,"name":"UNIVERSAL","containerName":"isa","kind":12},{"kind":12,"containerName":"MolEvol::CodonModel","name":"Bio","line":1341},{"name":"Bio","containerName":"Tools::CodonTable","kind":12,"line":1376},{"kind":12,"name":"all","line":1406},{"line":1410,"name":"sum","kind":12},{"name":"$total","containerName":null,"kind":13,"line":1411},{"line":1411,"kind":13,"containerName":null,"name":"$total"},{"kind":13,"containerName":null,"name":"%codonvals","line":1414},{"kind":12,"name":"all","line":1414},{"localvar":"my","kind":13,"containerName":null,"name":"$outcodon","line":1418,"definition":"my"},{"line":1418,"kind":13,"containerName":null,"name":"%codonvals"},{"kind":13,"containerName":null,"name":"%outcodon","line":1419},{"line":1420,"name":"%status","kind":13,"containerName":null},{"definition":"my","line":1423,"kind":13,"localvar":"my","containerName":null,"name":"$out_AA"},{"line":1423,"containerName":null,"kind":13,"name":"$table"},{"containerName":"main::","kind":12,"name":"translate","line":1423},{"name":"$outcodon","containerName":null,"kind":13,"line":1423},{"containerName":null,"localvar":"my","kind":13,"name":"$outcodon2","line":1424,"definition":"my"},{"line":1424,"kind":13,"containerName":null,"name":"%codonvals"},{"line":1425,"name":"$polarized","containerName":null,"kind":13},{"line":1425,"name":"$outcodon","containerName":null,"kind":13},{"name":"$outcodon2","kind":13,"containerName":null,"line":1425},{"kind":13,"containerName":null,"name":"$out_AA","line":1426},{"name":"%out_AA","kind":13,"containerName":null,"line":1426},{"line":1430,"kind":13,"containerName":null,"name":"%verbose"},{"line":1431,"name":"$self","containerName":null,"kind":13},{"line":1431,"name":"debug","containerName":"main::","kind":12},{"name":"%status","containerName":null,"kind":13,"line":1433},{"name":"@ingroup_codons","kind":13,"localvar":"my","containerName":null,"line":1446,"definition":"my"},{"line":1446,"name":"%codonvals","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$diff_from_out","line":1447},{"name":"%codonvals","kind":13,"containerName":null,"line":1447},{"containerName":null,"kind":13,"name":"$outcodon","line":1447},{"name":"%verbose","containerName":null,"kind":13,"line":1449},{"line":1450,"name":"$self","kind":13,"containerName":null},{"line":1450,"kind":12,"containerName":"main::","name":"debug"},{"name":"@ingroup_codons","containerName":null,"kind":13,"line":1450},{"line":1451,"containerName":null,"kind":13,"name":"%codonvals"},{"kind":12,"name":"outgroup1","line":1451},{"definition":"my","line":1454,"name":"$ind","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%all_alleles","line":1454},{"name":"$self","kind":13,"containerName":null,"line":1455},{"line":1455,"name":"debug","containerName":"main::","kind":12},{"line":1460,"name":"%diff_from_out","containerName":null,"kind":13},{"line":1461,"kind":13,"containerName":null,"name":"@ingroup_codons"},{"line":1463,"name":"%outcodon","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%status","line":1464},{"containerName":null,"kind":13,"name":"@ingroup_codons","line":1466},{"line":1467,"name":"%status","containerName":null,"kind":13},{"line":1470,"localvar":"my","kind":13,"containerName":null,"name":"$path","definition":"my"},{"containerName":null,"kind":13,"name":"%codon_path","line":1470},{"name":"@ingroup_codons","containerName":null,"kind":13,"line":1470},{"name":"$outcodon","kind":13,"containerName":null,"line":1470},{"name":"%two_by_two","kind":13,"containerName":null,"line":1471},{"line":1471,"kind":12,"name":"fixed_N"},{"line":1471,"name":"@path","kind":13,"containerName":null},{"name":"%two_by_two","containerName":null,"kind":13,"line":1472},{"line":1472,"name":"fixed_S","kind":12},{"line":1472,"containerName":null,"kind":13,"name":"@path"},{"line":1473,"containerName":null,"kind":13,"name":"%verbose"},{"line":1474,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"debug","line":1474},{"name":"$self","kind":13,"containerName":null,"line":1475},{"name":"debug","containerName":"main::","kind":12,"line":1475},{"name":"$path","containerName":null,"kind":13,"line":1475},{"line":1476,"kind":13,"containerName":null,"name":"$self"},{"name":"debug","containerName":"main::","kind":12,"line":1477},{"line":1477,"kind":13,"containerName":null,"name":"$codon"},{"line":1477,"name":"@ingroup_codons","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$outcodon","line":1477},{"name":"$out_AA","containerName":null,"kind":13,"line":1477},{"name":"%path","kind":13,"containerName":null,"line":1478},{"line":1478,"name":"%two_by_two","kind":13,"containerName":null},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$Ndiff","line":1484},{"line":1484,"name":"$Sdiff","kind":13,"containerName":null},{"definition":"my","name":"$c","localvar":"my","containerName":null,"kind":13,"line":1485},{"containerName":null,"kind":13,"name":"@ingroup_codons","line":1485},{"line":1486,"name":"$c","containerName":null,"kind":13},{"name":"$outcodon","kind":13,"containerName":null,"line":1486},{"name":"$path","localvar":"my","kind":13,"containerName":null,"line":1487,"definition":"my"},{"containerName":null,"kind":13,"name":"%codon_path","line":1487},{"line":1487,"kind":13,"containerName":null,"name":"$c"},{"name":"$outcodon","kind":13,"containerName":null,"line":1487},{"line":1488,"name":"$tNdiff","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1488,"name":"$tSdiff","containerName":null,"kind":13},{"line":1488,"containerName":null,"kind":13,"name":"$path"},{"line":1489,"containerName":null,"kind":13,"name":"@path"},{"kind":13,"containerName":null,"name":"$Ndiff","line":1489},{"name":"$tNdiff","kind":13,"containerName":null,"line":1490},{"name":"$Ndiff","containerName":null,"kind":13,"line":1490},{"kind":13,"containerName":null,"name":"$tSdiff","line":1491},{"line":1491,"name":"%Sdiff","kind":13,"containerName":null},{"line":1492,"kind":13,"containerName":null,"name":"$Ndiff"},{"name":"$Sdiff","containerName":null,"kind":13,"line":1492},{"containerName":null,"kind":13,"name":"$tNdiff","line":1492},{"line":1492,"kind":13,"containerName":null,"name":"$tSdiff"},{"kind":13,"containerName":null,"name":"%two_by_two","line":1495},{"line":1495,"kind":12,"name":"fixed_N"},{"line":1495,"name":"$Ndiff","containerName":null,"kind":13},{"line":1496,"name":"%two_by_two","containerName":null,"kind":13},{"line":1496,"kind":12,"name":"fixed_S"},{"line":1496,"name":"$Sdiff","kind":13,"containerName":null},{"name":"@ingroup_codons","containerName":null,"kind":13,"line":1497},{"line":1498,"name":"%status","containerName":null,"kind":13},{"name":"$path","localvar":"my","kind":13,"containerName":null,"line":1501,"definition":"my"},{"line":1501,"containerName":null,"kind":13,"name":"%codon_path"},{"line":1501,"name":"@ingroup_codons","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%two_by_two","line":1503},{"line":1503,"kind":12,"name":"poly_N"},{"kind":13,"containerName":null,"name":"@path","line":1503},{"name":"%two_by_two","containerName":null,"kind":13,"line":1504},{"name":"poly_S","kind":12,"line":1504},{"line":1504,"name":"@path","containerName":null,"kind":13},{"name":"%verbose","kind":13,"containerName":null,"line":1505},{"containerName":null,"kind":13,"name":"$self","line":1506},{"name":"debug","containerName":"main::","kind":12,"line":1506},{"containerName":null,"kind":13,"name":"$codon","line":1506},{"kind":13,"containerName":null,"name":"@ingroup_codons","line":1506},{"name":"$outcodon","kind":13,"containerName":null,"line":1506},{"name":"$out_AA","kind":13,"containerName":null,"line":1506},{"line":1506,"containerName":null,"kind":13,"name":"%path"},{"line":1506,"name":"%two_by_two","containerName":null,"kind":13},{"line":1511,"containerName":null,"localvar":"my","kind":13,"name":"%unq","definition":"my"},{"line":1511,"name":"@ingroup_codons","containerName":null,"kind":13},{"name":"%unq","kind":13,"containerName":null,"line":1512},{"containerName":null,"kind":13,"name":"$outcodon","line":1512},{"containerName":null,"localvar":"my","kind":13,"name":"@unique_codons","line":1513,"definition":"my"},{"containerName":null,"kind":13,"name":"%unq","line":1513},{"definition":"my","line":1518,"kind":13,"localvar":"my","containerName":null,"name":"$Ndiff"},{"line":1518,"kind":13,"containerName":null,"name":"$Sdiff"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$c","line":1519},{"kind":13,"containerName":null,"name":"@unique_codons","line":1519},{"line":1520,"name":"$path","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1520,"kind":13,"containerName":null,"name":"%codon_path"},{"containerName":null,"kind":13,"name":"$c","line":1520},{"name":"$outcodon","containerName":null,"kind":13,"line":1520},{"line":1521,"name":"%path","containerName":null,"kind":13},{"name":"$c","containerName":null,"kind":13,"line":1522},{"kind":13,"containerName":null,"name":"$outcodon","line":1522},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$tNdiff","line":1524},{"containerName":null,"kind":13,"name":"$tSdiff","line":1524},{"line":1524,"kind":13,"containerName":null,"name":"$path"},{"name":"@path","kind":13,"containerName":null,"line":1525},{"line":1525,"kind":13,"containerName":null,"name":"$Ndiff"},{"kind":13,"containerName":null,"name":"$tNdiff","line":1526},{"containerName":null,"kind":13,"name":"$Ndiff","line":1526},{"line":1527,"name":"$tSdiff","containerName":null,"kind":13},{"name":"%Sdiff","containerName":null,"kind":13,"line":1527},{"kind":13,"containerName":null,"name":"$Ndiff","line":1528},{"kind":13,"containerName":null,"name":"$Sdiff","line":1528},{"line":1528,"name":"$tNdiff","containerName":null,"kind":13},{"line":1528,"name":"$tSdiff","kind":13,"containerName":null},{"line":1532,"name":"@unique_codons","kind":13,"containerName":null},{"definition":"my","line":1533,"localvar":"my","kind":13,"containerName":null,"name":"$path"},{"containerName":null,"kind":13,"name":"%codon_path","line":1533},{"line":1533,"kind":13,"containerName":null,"name":"@unique_codons"},{"kind":13,"containerName":null,"name":"%path","line":1534},{"name":"$self","containerName":null,"kind":13,"line":1535},{"line":1535,"name":"throw","containerName":"main::","kind":12},{"name":"$Ndiff","kind":13,"containerName":null,"line":1537},{"line":1537,"name":"@path","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$Sdiff","line":1538},{"kind":13,"containerName":null,"name":"@path","line":1538},{"line":1540,"name":"%two_by_two","containerName":null,"kind":13},{"name":"poly_N","kind":12,"line":1540},{"line":1540,"name":"$Ndiff","containerName":null,"kind":13},{"line":1541,"kind":13,"containerName":null,"name":"%two_by_two"},{"line":1541,"name":"poly_S","kind":12},{"line":1541,"name":"$Sdiff","containerName":null,"kind":13},{"line":1542,"name":"%verbose","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":1543},{"name":"debug","containerName":"main::","kind":12,"line":1543},{"line":1543,"kind":13,"containerName":null,"name":"$codon"},{"name":"@ingroup_codons","containerName":null,"kind":13,"line":1543},{"line":1543,"containerName":null,"kind":13,"name":"$outcodon"},{"line":1543,"containerName":null,"kind":13,"name":"$out_AA"},{"name":"$Ndiff","kind":13,"containerName":null,"line":1544},{"line":1544,"kind":13,"containerName":null,"name":"%Sdiff"},{"line":1544,"name":"%two_by_two","kind":13,"containerName":null},{"line":1550,"name":"%two_by_two","containerName":null,"kind":13},{"name":"%two_by_two","containerName":null,"kind":13,"line":1551},{"line":1552,"containerName":null,"kind":13,"name":"%two_by_two"},{"name":"%two_by_two","kind":13,"containerName":null,"line":1553},{"containerName":null,"kind":13,"name":"%status","line":1554},{"children":[{"line":1579,"containerName":"mcdonald_kreitman_counts","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$Npoly","containerName":"mcdonald_kreitman_counts","kind":13,"line":1579},{"name":"$Nfix","kind":13,"containerName":"mcdonald_kreitman_counts","line":1579},{"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Spoly","line":1579},{"name":"$Sfix","kind":13,"containerName":"mcdonald_kreitman_counts","line":1579},{"line":1580,"name":"$has_twotailed","kind":13,"containerName":"mcdonald_kreitman_counts"},{"name":"$Npoly","containerName":"mcdonald_kreitman_counts","kind":13,"line":1582},{"line":1583,"containerName":"mcdonald_kreitman_counts","kind":13,"name":"$Npoly"},{"line":1583,"name":"$Spoly","containerName":"mcdonald_kreitman_counts","kind":13},{"name":"$Npoly","containerName":"mcdonald_kreitman_counts","kind":13,"line":1584},{"name":"$Nfix","kind":13,"containerName":"mcdonald_kreitman_counts","line":1584},{"line":1585,"name":"$Npoly","kind":13,"containerName":"mcdonald_kreitman_counts"},{"line":1585,"containerName":"mcdonald_kreitman_counts","kind":13,"name":"$Nfix"},{"line":1585,"name":"$Spoly","containerName":"mcdonald_kreitman_counts","kind":13},{"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Sfix","line":1585},{"name":"$self","kind":13,"containerName":"mcdonald_kreitman_counts","line":1587},{"line":1587,"kind":12,"containerName":"mcdonald_kreitman_counts","name":"warn"}],"name":"mcdonald_kreitman_counts","containerName":"main::","definition":"sub","detail":"($self,$Npoly,$Nfix,$Spoly,$Sfix)","line":1578,"range":{"start":{"character":0,"line":1578},"end":{"line":1590,"character":9999}},"kind":12,"signature":{"label":"mcdonald_kreitman_counts($self,$Npoly,$Nfix,$Spoly,$Sfix)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA.\n\n\nsub composite_LD {\n    my ($self,$pop) = @_;\n    if( ref($pop) =~ /ARRAY/i ) {\n\tif( ref($pop->[0]) && $pop->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t    $pop = Bio::PopGen::Population->new(-individuals => @$pop);\n\t} else { \n\t    $self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\t    return ();\n\t}\n    } elsif( ! ref($pop) || ! $pop->isa('Bio::PopGen::PopulationI') ) {\n\t$self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\treturn ();\n    }\n\n    my @marker_names = $pop->get_marker_names;\n    my @inds = $pop->get_Individuals;\n    my $num_inds = scalar @inds;\n    my (%lookup);\n    # calculate allele frequencies for each marker from the population\n    # use the built-in get_Marker to get the allele freqs\n    # we still need to calculate the genotype frequencies\n    foreach my $marker_name ( @marker_names ) {\t\n\tmy(%allelef);\n\n\tforeach my $ind ( @inds ) {\n\t    my ($genotype) = $ind->get_Genotypes(-marker => $marker_name);\n\t    if( ! defined $genotype ) { \n\t\t$self->warn(\"no genotype for marker $marker_name for individual \". $ind->unique_id. \"\\n\");\n\t\tnext;\n\t    }\n\t    my @alleles  = sort $genotype->get_Alleles;\n\t    next if( scalar @alleles != 2);\n\t    my $genostr  = join(',', @alleles);\n            $allelef{$alleles[0]}++;\n            $allelef{$alleles[1]}++;\n\t}\n\n\t# we should check for cases where there > 2 alleles or\n\t# only 1 allele and throw out those markers.\n\tmy @alleles      = sort keys %allelef;\n\tmy $allele_count = scalar @alleles;\n\t# test if site is polymorphic\n\tif( $allele_count != 2) { \n\t    # only really warn if we're seeing multi-allele\n\t    $self->warn(\"Skipping $marker_name because it has $allele_count alleles (\".join(',',@alleles).\"), \\ncomposite_LD will currently only work for biallelic markers\") if $allele_count > 2;\n\t    next;\t\t# skip this marker\n\t}\n\n\t# Need to do something here to detect alleles which aren't \n\t# a single character\n\tif( length($alleles[0]) != 1 ||\n\t    length($alleles[1]) != 1 ) {\n\t    $self->warn(\"An individual has an allele which is not a single base, this is currently not supported in composite_LD - consider recoding the allele as a single character\");\n\t    next;\n\t}\n\n\t# fix the call for allele 1 (A or B) and \n\t# allele 2 (a or b) in terms of how we'll do the \n\t# N square from Weir p.126\n\t$self->debug( \"$alleles[0] is 1, $alleles[1] is 2 for $marker_name\\n\");\n\t$lookup{$marker_name}->{'1'} = $alleles[0];\n\t$lookup{$marker_name}->{'2'} = $alleles[1];\n    }\n\n    @marker_names = sort keys %lookup;\n    my $site_count   = scalar @marker_names;\n    # where the final data will be stored\n    my %stats_for_sites;\n\n    # standard way of generating pairwise combos\n    # LD is done by comparing all the pairwise site (marker)\n    # combinations and keeping track of the genotype and \n    # pairwise genotype (ie genotypes of the 2 sites) frequencies\n    for( my $i = 0; $i < $site_count - 1; $i++ ) {\n\tmy $site1 = $marker_names[$i];\n\n\tfor( my $j = $i+1; $j < $site_count ; $j++) { \t \n\t    my (%genotypes, %total_genotype_count,$total_pairwisegeno_count,\n\t\t%pairwise_genotypes);\n\t \n\t    my $site2 = $marker_names[$j];\n\t    my (%allele_count,%allele_freqs) = (0,0);\n\t    foreach my $ind ( @inds ) {\n\t\t# build string of genotype at site 1\n\t\tmy ($genotype1) = $ind->get_Genotypes(-marker => $site1);\n\t\tmy @alleles1  = sort $genotype1->get_Alleles;\n\n                # if an individual has only one available allele\n\t\t# (has a blank or N for one of the chromosomes)\n\t\t# we don't want to use it in our calculation\n\n\t\tnext unless( scalar @alleles1 == 2);\n\t\tmy $genostr1  = join(',', @alleles1);\n\n\t\t# build string of genotype at site 2\n\t\tmy ($genotype2) = $ind->get_Genotypes(-marker => $site2);\n\t\tmy @alleles2  = sort $genotype2->get_Alleles;\n\t\tmy $genostr2  = join(',', @alleles2);\n\t\t\n\t\tnext unless( scalar @alleles2 == 2);\n\t\tfor (@alleles1) {\n\t\t    $allele_count{$site1}++;\n\t\t    $allele_freqs{$site1}->{$_}++;\n\t\t}\n\t\t$genotypes{$site1}->{$genostr1}++;\n\t\t$total_genotype_count{$site1}++;\n\n\t\tfor (@alleles2) {\n\t\t    $allele_count{$site2}++;\n\t\t    $allele_freqs{$site2}->{$_}++;\n\t\t}\n\t\t$genotypes{$site2}->{$genostr2}++;\n\t\t$total_genotype_count{$site2}++;\n\n\t\t# We are using the $site1,$site2 to signify\n\t\t# a unique key\n\t\t$pairwise_genotypes{\"$genostr1,$genostr2\"}++;\n\t\t# some individuals \n\t\t$total_pairwisegeno_count++;\n\t    }\n\t    for my $site ( %allele_freqs ) {\n\t\tfor my $al ( keys %{ $allele_freqs{$site} } ) {\n\t\t    $allele_freqs{$site}->{$al} /= $allele_count{$site};\n\t\t}\n\t    }\n\t    my $n = $total_pairwisegeno_count;\t# number of pairs of comparisons\n\t    # 'A' and 'B' are two loci or in our case site1 and site2  \n\t    my $allele1_site1 = $lookup{$site1}->{'1'};\t# this is the BigA allele\n\t    my $allele1_site2 = $lookup{$site2}->{'1'};\t# this is the BigB allele\n\t    my $allele2_site1 = $lookup{$site1}->{'2'};\t# this is the LittleA allele\n\t    my $allele2_site2 = $lookup{$site2}->{'2'};\t# this is the LittleB allele\n\t    # AABB\n\t    my $N1genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AABB) N1genostr=$N1genostr\\n\");\n\t    # AABb\n\t    my $N2genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AABb) N2genostr=$N2genostr\\n\");\n\t    # AaBB\n\t    my $N4genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AaBB) N4genostr=$N4genostr\\n\");\n\t    # AaBb\n\t    my $N5genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AaBb) N5genostr=$N5genostr\\n\");\n\t    # count of AABB in \n\t    my $n1 = $pairwise_genotypes{$N1genostr} || 0;\n\t    # count of AABb in \n\t    my $n2 = $pairwise_genotypes{$N2genostr} || 0;\n\t    # count of AaBB in \n\t    my $n4 = $pairwise_genotypes{$N4genostr} || 0;\n\t    # count of AaBb in \n\t    my $n5 = $pairwise_genotypes{$N5genostr} || 0;\n\n\t    my $homozA_site1 = join(\",\", ($allele1_site1,$allele1_site1));\n\t    my $homozB_site2 = join(\",\", ($allele1_site2,$allele1_site2));\n\t    my $p_AA = ($genotypes{$site1}->{$homozA_site1} || 0) / $n;\n\t    my $p_BB = ($genotypes{$site2}->{$homozB_site2} || 0) / $n;\n\t    my $p_A  = $allele_freqs{$site1}->{$allele1_site1} || 0;\t# an individual allele freq\n\t    my $p_a  =  1 - $p_A;\n\n\t    my $p_B  = $allele_freqs{$site2}->{$allele1_site2} || 0;\t# an individual allele freq\n\t    my $p_b  =  1 - $p_B;\n\n\t    # variance of allele frequencies\n\t    my $pi_A = $p_A * $p_a;\n\t    my $pi_B = $p_B * $p_b;\n\n\t    # hardy weinberg\n\t    my $D_A  = $p_AA - $p_A**2;\n\t    my $D_B  = $p_BB - $p_B**2;\n\t    my $n_AB = 2*$n1 + $n2 + $n4 + 0.5 * $n5;\n\t    $self->debug(\"n_AB=$n_AB -- n1=$n1, n2=$n2 n4=$n4 n5=$n5\\n\");\n\n\t    my $delta_AB = (1 / $n ) * ( $n_AB ) - ( 2 * $p_A * $p_B );\n\t    $self->debug(\"delta_AB=$delta_AB -- n=$n, n_AB=$n_AB p_A=$p_A, p_B=$p_B\\n\");\n\t    $self->debug(sprintf(\" (%d * %.4f) / ( %.2f + %.2f) * ( %.2f + %.2f) \\n\",\n\t\t\t\t $n,$delta_AB**2, $pi_A, $D_A, $pi_B, $D_B));\n\t    \n\t    my $chisquared;\n\t    eval { $chisquared = ( $n * ($delta_AB**2) ) / \n\t\t       ( ( $pi_A + $D_A) * ( $pi_B + $D_B) );\n\t       };\n\t    if( $@ ) {\n\t\t$self->debug(\"Skipping the site because the denom is 0.\\nsite1=$site1, site2=$site2 : pi_A=$pi_A, pi_B=$pi_B D_A=$D_A, D_B=$D_B\\n\");\n\t\tnext;\n\t    }\n\t    # this will be an upper triangular matrix\n\t    $stats_for_sites{$site1}->{$site2} = [$delta_AB,$chisquared];\n\t}\n    }\n    return %stats_for_sites;\n}\n\n=head2 mcdonald_kreitman\n\n Title   : mcdonald_kreitman\n Usage   : $Fstat = mcdonald_kreitman($ingroup, $outgroup);\n Function: Calculates McDonald-Kreitman statistic based on a set of ingroup\n           individuals and an outgroup by computing the number of \n           differences at synonymous and non-synonymous sites\n           for intraspecific comparisons and with the outgroup \n Returns : 2x2 table, followed by a hash reference indicating any \n           warning messages about the status of the alleles or codons \n Args    : -ingroup    => L<Bio::PopGen::Population> object or \n                          arrayref of L<Bio::PopGen::Individual>s \n           -outgroup   => L<Bio::PopGen::Population> object or \n                          arrayef of L<Bio::PopGen::Individual>s\n           -polarized  => Boolean, to indicate if this should be \n                          a polarized test. Must provide two individuals \n                          as outgroups.\n\n\nsub mcdonald_kreitman {\n    my ($self,@args) = @_;\n    my ($ingroup, $outgroup,$polarized) = \n\t$self->_rearrange([qw(INGROUP OUTGROUP POLARIZED)],@args);\n    my $verbose = $self->verbose;\n    my $outgroup_count;\n    my $gapchar = '\\-';\n    if( ref($outgroup) =~ /ARRAY/i ) {\n\t$outgroup_count = scalar @$outgroup;\n    } elsif( UNIVERSAL::isa($outgroup,'Bio::PopGen::PopulationI') ) {\n\t$outgroup_count = $outgroup->get_number_individuals;\n    } else {\n\t$self->throw(\"Expected an ArrayRef of Individuals OR a Bio::PopGen::PopulationI\");\n    }\n\t\n    if( $polarized ) {\n\tif( $outgroup_count < 2 ) {\n\t    $self->throw(\"Need 2 outgroups with polarized option\\n\");\n\t}\n    } elsif( $outgroup_count > 1 ) {\n\t$self->warn(sprintf(\"%s outgroup sequences provided, but only first will be used\",$outgroup_count ));\n    } elsif( $outgroup_count == 0 ) {\n\t$self->throw(\"No outgroup sequence provided\");\n    }\n    \n    my $codon_path = Bio::MolEvol::CodonModel->codon_path;\n    \n    my (%marker_names,%unique,@inds);\n    for my $p ( $ingroup, $outgroup)  {\n\tif( ref($p) =~ /ARRAY/i ) {\n\t    push @inds, @$p;\n\t} else {\n\t    push @inds, $p->get_Individuals;\n\t}\n    }\n    for my $i ( @inds ) {\n\tif( $unique{$i->unique_id}++ ) {\n\t    $self->warn(\"Individual \". $i->unique_id. \" is seen more than once in the ingroup or outgroup set\\n\");\n\t}\n\tfor my $n ( $i->get_marker_names ) {\n\t    $marker_names{$n}++;\n\t}\n    }\n\n    my @marker_names = keys %marker_names;\n    if( $marker_names[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@marker_names = map { $_->[1] } \n\tsort { $a->[0] <=> $b->[0] }\n\tmap { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @marker_names;\n    }\n\n\n    my $num_inds = scalar @inds;\n    my %vals = ( 'ingroup'  => $ingroup,\n\t\t 'outgroup' => $outgroup,\t\t \n\t\t );\n\n    # Make the Codon Table type a parameter!\n    my $table = Bio::Tools::CodonTable->new(-id => $codon_table);\n    my @vt = qw(outgroup ingroup);\n    my %changes;\n    my %status;\n    my %two_by_two = ( 'fixed_N' => 0,\n\t\t       'fixed_S' => 0,\n\t\t       'poly_N'  => 0,\n\t\t       'poly_S'  => 0);\n\n    for my $codon ( @marker_names ) {\n\tmy (%codonvals);\n\tmy %all_alleles;\n\tfor my $t ( @vt ) {\n\t    my $outcount = 1;\n\t    for my $ind ( @{$vals{$t}} ) {\n\t\tmy @alleles = $ind->get_Genotypes($codon)->get_Alleles;\n\t\tif( @alleles > 1 ) {\n\t\t    die;\n#\t\t  warn(\"$codon $codon saw \", scalar @alleles, \" for ind \", $ind->unique_id, \"\\n\");\n\t\t} else {\n\t\t    my ($allele) = shift @alleles;\n\t\t    $all_alleles{$ind->unique_id} = $allele;\n\t\t    my $AA = $table->translate($allele);\n\t\t    next if( $AA eq 'X' || $AA eq '*' || $allele =~ /N/i);\n\n\t\t    my $label = $t;\n\t\t    if( $t eq 'outgroup' ) {\n\t\t\t$label = $t.$outcount++;\n\t\t    }\n\t\t    $codonvals{$label}->{$allele}++;\n\t\t    $codonvals{all}->{$allele}++;\n\t\t}\n\t    }\n\t}\n\tmy $total = sum ( values %{$codonvals{'ingroup'}} );\n\tnext if( $total && $total < 2 ); # skip sites with < alleles\n\t# process all the seen alleles (codons) \n\t# this is a vertical slide through the alignment\n\tif( keys %{$codonvals{all}} <= 1 ) {\n\t    # no changes or no VALID codons - monomorphic\n\t} else { \n\t    # grab only the first outgroup codon (what to do with rest?)\n\t    my ($outcodon) = keys %{$codonvals{'outgroup1'}};\n            if( ! $outcodon ) { \n\t\t$status{\"no outgroup codon $codon\"}++;\n\t\tnext;\n\t    }\n\t    my $out_AA = $table->translate($outcodon);\n\t    my ($outcodon2) = keys %{$codonvals{'outgroup2'}};\n\t    if( ($polarized && ($outcodon ne $outcodon2)) ||\n\t\t$out_AA eq 'X' || $out_AA eq '*' ) {\n\t\t# skip if outgroup codons are different \n\t\t# (when polarized option is on)\n\t\t# or skip if the outcodon is STOP or 'NNN'\n\t\tif( $verbose > 0 ) {\n\t\t    $self->debug(\"skipping $out_AA and $outcodon $outcodon2\\n\");\n\t\t}\n\t\t$status{'outgroup codons different'}++;\n\t\tnext;\n\t    }\n\n\t    # check if ingroup is actually different from outgroup -\n\t    # if there are the same number of alleles when considering\n\t    # ALL or just the ingroup, then there is nothing new seen\n\t    # in the outgroup so it must be a shared allele (codon)\n\n\t    # so we just count how many total alleles were seen\n\t    # if this is the same as the number of alleles seen for just \n\t    # the ingroup then the outgroup presents no new information\n\n\t    my @ingroup_codons = keys %{$codonvals{'ingroup'}};\n\t    my $diff_from_out = ! exists $codonvals{'ingroup'}->{$outcodon};\n\n\t    if( $verbose > 0 ) {\n\t\t$self->debug(\"alleles are in: \", join(\",\", @ingroup_codons),\n\t\t\t     \" out: \", join(\",\", keys %{$codonvals{outgroup1}}),\n\t\t\t     \" diff_from_out=$diff_from_out\\n\");\n\n\t\tfor my $ind ( sort keys %all_alleles ) {\n\t\t    $self->debug( \"$ind\\t$all_alleles{$ind}\\n\");\n\t\t}\n\t    }\n\t    # are all the ingroup alleles the same and diferent from outgroup?\n\t    # fixed differences between species\n\t    if( $diff_from_out ) {\n\t\tif( scalar @ingroup_codons == 1 ) { \n\t\t    # fixed differences\n\t\t    if( $outcodon =~ /^$gapchar/ ) {\n\t\t\t$status{'outgroup codons with gaps'}++;\n\t\t\tnext;\n\t\t    } elsif( $ingroup_codons[0] =~ /$gapchar/) {\n\t\t\t$status{'ingroup codons with gaps'}++;\n\t\t\tnext;\n\t\t    }\n\t\t    my $path = $codon_path->{uc $ingroup_codons[0].$outcodon};\n\t\t    $two_by_two{fixed_N} += $path->[0];\n\t\t    $two_by_two{fixed_S} += $path->[1];\n\t\t    if( $verbose > 0 ) {\n\t\t\t$self->debug(\"ingroup is @ingroup_codons outcodon is $outcodon\\n\");\n\t\t\t$self->debug(\"path is \",join(\",\",@$path),\"\\n\");\n\t\t\t$self->debug\n\t\t\t    (sprintf(\"%-15s fixeddiff - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,$ingroup_codons[0], $outcodon,$out_AA,\n\t\t\t\t     @$path, map { $two_by_two{$_} } \n\t\t\t\t     qw(fixed_N fixed_S poly_N poly_S)));\n\t\t    }\n\t\t} else { \n\t\t    # polymorphic and all are different from outgroup\n\t\t    # Here we find the minimum number of NS subst\n\t\t    my ($Ndiff,$Sdiff) = (3,0);\t# most different path\n\t\t    for my $c ( @ingroup_codons ) {\n\t\t\tnext if( $c =~ /$gapchar/ || $outcodon =~ /$gapchar/);\n\t\t\tmy $path = $codon_path->{uc $c.$outcodon};\n\t\t\tmy ($tNdiff,$tSdiff) = @$path;\n\t\t\tif( $path->[0] < $Ndiff ||\n\t\t\t    ($tNdiff == $Ndiff &&\n\t\t\t     $tSdiff  <= $Sdiff)) {\n\t\t\t    ($Ndiff,$Sdiff) = ($tNdiff,$tSdiff);\n\t\t\t}\n\t\t    }\n\t\t    $two_by_two{fixed_N} += $Ndiff;\n\t\t    $two_by_two{fixed_S} += $Sdiff;\n\t            if( @ingroup_codons > 2 ) { \n\t\t\t$status{\"more than 2 ingroup codons $codon\"}++;\n\t\t\twarn(\"more than 2 ingroup codons (@ingroup_codons)\\n\");\t\n\t\t    } else {\n\t\t    \tmy $path = $codon_path->{uc join('',@ingroup_codons)};\n\n\t\t    \t$two_by_two{poly_N} += $path->[0];\n\t\t    \t$two_by_two{poly_S} += $path->[1];\n\t\t    \tif( $verbose > 0 ) {\n\t\t\t    $self->debug(sprintf(\"%-15s polysite_all - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,join(',',@ingroup_codons), $outcodon,$out_AA,@$path, map { $two_by_two{$_} } qw(fixed_N fixed_S poly_N poly_S)));\n\t\t\t}\n\t\t    } \n\t\t} \n\t    } else {\n\t\tmy %unq = map { $_ => 1 } @ingroup_codons;\n\t\tdelete $unq{$outcodon};\n\t\tmy @unique_codons = keys %unq;\n\n\t\t# calc path for diff add to poly\n\t\t# Here we find the minimum number of subst bw\n\t\t# codons\n\t\tmy ($Ndiff,$Sdiff) = (3,0); # most different path\n\t\tfor my $c ( @unique_codons ) {\n\t\t    my $path = $codon_path->{uc $c.$outcodon };\n\t\t    if( ! defined $path ) {\n\t\t\tdie \" cannot get path for \", $c.$outcodon, \"\\n\";\n\t\t    }\n\t\t    my ($tNdiff,$tSdiff) = @$path;\n\t\t    if( $path->[0] < $Ndiff ||\n\t\t\t($tNdiff == $Ndiff &&\n\t\t\t $tSdiff  <= $Sdiff)) {\n\t\t\t($Ndiff,$Sdiff) = ($tNdiff,$tSdiff);\n\t\t    }\n\t\t}\n\n\t\tif( @unique_codons == 2 ) {\n\t\t    my $path = $codon_path->{uc join('',@unique_codons)};\n\t\t    if( ! defined $path ) {\n\t\t\t$self->throw(\"no path for @unique_codons\\n\");\n\t\t    }\n\t\t    $Ndiff += $path->[0];\n\t\t    $Sdiff += $path->[1];\n\t\t}\n\t\t$two_by_two{poly_N} += $Ndiff;\n\t\t$two_by_two{poly_S} += $Sdiff;\n\t\tif( $verbose > 0 ) {\n\t\t    $self->debug(sprintf(\"%-15s polysite - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,join(',',@ingroup_codons), $outcodon,$out_AA,\n\t\t\t\t\t $Ndiff, $Sdiff, map { $two_by_two{$_} } \n\t\t\t\t\t qw(fixed_N fixed_S poly_N poly_S)));\n\t\t}\n\t    }\n\t}\t    \n    }\n    return ( $two_by_two{'poly_N'},\n\t     $two_by_two{'fixed_N'},\n\t     $two_by_two{'poly_S'},\n\t     $two_by_two{'fixed_S'},\n\t     {%status});\n    \n}\n\n*MK = \\&mcdonald_kreitman;\n\n\n=head2 mcdonald_kreitman_counts\n\n Title   : mcdonald_kreitman_counts\n Usage   : my $MK = $statistics->mcdonald_kreitman_counts(\n\n             N_poly -> integer of count of non-syn polymorphism\n             N_fix  -> integer of count of non-syn fixed substitutions\n             S_poly -> integer of count of syn polymorphism\n             S_fix  -> integer of count of syn fixed substitutions\n\t\t\t\t\t\t\t  );\n Function:\n Returns : decimal number\n Args    : ","parameters":[{"label":"$self"},{"label":"$Npoly"},{"label":"$Nfix"},{"label":"$Spoly"},{"label":"$Sfix"}]}},{"kind":12,"containerName":"NSP::Measures::Fisher2::twotailed::calculateStatistic","name":"Text","line":1582},{"line":1582,"kind":12,"name":"n11"},{"kind":12,"name":"n1p","line":1583},{"name":"np1","kind":12,"line":1584},{"kind":12,"name":"npp","line":1585}]}