{"vars":[{"name":"vars","containerName":"","kind":2,"line":80},{"line":82,"containerName":null,"kind":13,"name":"$UIDCOUNTER"},{"line":82,"kind":2,"containerName":"","name":"strict"},{"line":87,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":101},"end":{"character":9999,"line":120}},"kind":12,"line":101,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":102},{"name":"@args","kind":13,"containerName":"new","line":102},{"definition":"my","line":104,"localvar":"my","containerName":"new","kind":13,"name":"$self"},{"line":104,"containerName":"new","kind":13,"name":"$class"},{"line":104,"containerName":"new","kind":13,"name":"@args"},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"definition":"my","name":"$uid","containerName":"new","localvar":"my","kind":13,"line":106},{"line":106,"name":"$genotypes","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":106},{"line":106,"kind":12,"containerName":"new","name":"_rearrange"},{"kind":13,"containerName":"new","name":"@args","line":107},{"line":108,"name":"$uid","kind":13,"containerName":"new"},{"line":109,"name":"$uid","kind":13,"containerName":"new"},{"line":109,"name":"$UIDCOUNTER","kind":13,"containerName":"new"},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"line":111,"kind":12,"containerName":"new","name":"unique_id"},{"line":111,"name":"$uid","kind":13,"containerName":"new"},{"name":"$genotypes","kind":13,"containerName":"new","line":112},{"name":"$genotypes","kind":13,"containerName":"new","line":113},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"line":114,"name":"add_Genotype","containerName":"new","kind":12},{"name":"$genotypes","containerName":"new","kind":13,"line":114},{"name":"$self","containerName":"new","kind":13,"line":116},{"line":116,"containerName":"new","kind":12,"name":"warn"},{"name":"$self","kind":13,"containerName":"new","line":119}],"detail":"($class,@args)","definition":"sub"},{"line":104,"name":"SUPER","kind":12,"containerName":"new"},{"containerName":"main::","name":"unique_id","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"unique_id","name":"$self","line":134},{"line":135,"name":"$self","containerName":"unique_id","kind":13},{"line":136,"name":"$self","kind":13,"containerName":"unique_id"}],"definition":"sub","kind":12,"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":133}},"line":133},{"containerName":"main::","name":"num_of_results","children":[],"definition":"sub","range":{"end":{"character":9999,"line":150},"start":{"line":149,"character":0}},"kind":12,"line":149},{"name":"shift","kind":12,"line":150},{"children":[{"line":164,"name":"$self","kind":13,"localvar":"my","containerName":"annotation","definition":"my"},{"line":164,"name":"$arg","containerName":"annotation","kind":13},{"name":"$self","kind":13,"containerName":"annotation","line":165},{"name":"$arg","containerName":"annotation","kind":13,"line":165},{"name":"$self","containerName":"annotation","kind":13,"line":166},{"name":"throw","containerName":"annotation","kind":12,"line":166},{"line":167,"name":"$arg","kind":13,"containerName":"annotation"},{"kind":13,"containerName":"annotation","name":"$arg","line":167},{"kind":12,"containerName":"annotation","name":"isa","line":167},{"name":"$self","containerName":"annotation","kind":13,"line":168},{"name":"$arg","containerName":"annotation","kind":13,"line":168}],"containerName":"main::","name":"annotation","definition":"sub","detail":"($self,$arg)","line":163,"range":{"start":{"character":0,"line":163},"end":{"line":169,"character":9999}},"kind":12,"signature":{"label":"annotation($self,$arg)","parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object"}},{"kind":12,"name":"_annotation","line":165},{"line":168,"kind":12,"name":"_annotation"},{"line":182,"kind":12,"range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":206}},"signature":{"label":"add_Genotype($self,@genotypes)","parameters":[{"label":"$self"},{"label":"@genotypes"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name"},"children":[{"definition":"my","line":183,"kind":13,"localvar":"my","containerName":"add_Genotype","name":"$self"},{"line":183,"kind":13,"containerName":"add_Genotype","name":"@genotypes"},{"definition":"my","kind":13,"localvar":"my","containerName":"add_Genotype","name":"$g","line":185},{"line":185,"kind":13,"containerName":"add_Genotype","name":"@genotypes"},{"name":"$g","containerName":"add_Genotype","kind":13,"line":186},{"name":"$g","kind":13,"containerName":"add_Genotype","line":186},{"kind":12,"containerName":"add_Genotype","name":"isa","line":186},{"line":187,"name":"$self","containerName":"add_Genotype","kind":13},{"line":187,"name":"warn","kind":12,"containerName":"add_Genotype"},{"localvar":"my","containerName":"add_Genotype","kind":13,"name":"$mname","line":190,"definition":"my"},{"containerName":"add_Genotype","kind":13,"name":"$g","line":190},{"line":190,"containerName":"add_Genotype","kind":12,"name":"marker_name"},{"name":"$mname","kind":13,"containerName":"add_Genotype","line":191},{"containerName":"add_Genotype","kind":13,"name":"$mname","line":191},{"name":"$self","containerName":"add_Genotype","kind":13,"line":193},{"kind":12,"containerName":"add_Genotype","name":"warn","line":193},{"line":196,"kind":13,"containerName":"add_Genotype","name":"$self"},{"line":196,"kind":12,"containerName":"add_Genotype","name":"verbose"},{"name":"$self","kind":13,"containerName":"add_Genotype","line":197},{"name":"$mname","containerName":"add_Genotype","kind":13,"line":197},{"line":199,"kind":13,"containerName":"add_Genotype","name":"$self"},{"name":"debug","containerName":"add_Genotype","kind":12,"line":199},{"line":203,"name":"$g","containerName":"add_Genotype","kind":13},{"line":203,"kind":12,"containerName":"add_Genotype","name":"individual_id"},{"kind":13,"containerName":"add_Genotype","name":"$self","line":203},{"line":203,"kind":12,"containerName":"add_Genotype","name":"unique_id"},{"line":204,"containerName":"add_Genotype","kind":13,"name":"$self"},{"line":204,"name":"$mname","kind":13,"containerName":"add_Genotype"},{"line":204,"containerName":"add_Genotype","kind":13,"name":"$g"},{"line":206,"name":"$self","kind":13,"containerName":"add_Genotype"}],"containerName":"main::","name":"add_Genotype","definition":"sub","detail":"($self,@genotypes)"},{"line":220,"kind":12,"range":{"end":{"line":222,"character":9999},"start":{"line":220,"character":0}},"children":[],"containerName":"main::","name":"reset_Genotypes","definition":"sub"},{"name":"remove_Genotype","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"remove_Genotype","line":236,"definition":"my"},{"line":236,"name":"@mkrs","containerName":"remove_Genotype","kind":13},{"containerName":"remove_Genotype","localvar":"my","kind":13,"name":"$m","line":237,"definition":"my"},{"line":237,"containerName":"remove_Genotype","kind":13,"name":"@mkrs"},{"name":"$self","kind":13,"containerName":"remove_Genotype","line":238},{"name":"$m","containerName":"remove_Genotype","kind":13,"line":238}],"detail":"($self,@mkrs)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":240},"start":{"line":235,"character":0}},"line":235,"signature":{"parameters":[{"label":"$self"},{"label":"@mkrs"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers ","label":"remove_Genotype($self,@mkrs)"}},{"children":[{"definition":"my","line":255,"name":"$self","localvar":"my","containerName":"get_Genotypes","kind":13},{"line":255,"kind":13,"containerName":"get_Genotypes","name":"@args"},{"name":"@args","kind":13,"containerName":"get_Genotypes","line":256},{"line":257,"name":"@args","containerName":"get_Genotypes","kind":13},{"line":257,"containerName":"get_Genotypes","kind":13,"name":"@args"},{"definition":"my","line":259,"localvar":"my","containerName":"get_Genotypes","kind":13,"name":"$name"},{"line":259,"name":"$self","kind":13,"containerName":"get_Genotypes"},{"line":259,"containerName":"get_Genotypes","kind":12,"name":"_rearrange"},{"containerName":"get_Genotypes","kind":13,"name":"@args","line":259},{"kind":13,"containerName":"get_Genotypes","name":"$name","line":260},{"line":261,"name":"$self","containerName":"get_Genotypes","kind":13},{"name":"warn","containerName":"get_Genotypes","kind":12,"line":261},{"definition":"my","line":264,"name":"$v","kind":13,"localvar":"my","containerName":"get_Genotypes"},{"line":264,"containerName":"get_Genotypes","kind":13,"name":"$self"},{"line":264,"containerName":"get_Genotypes","kind":13,"name":"$name"},{"line":265,"kind":13,"containerName":"get_Genotypes","name":"$v"},{"line":267,"name":"$self","kind":13,"containerName":"get_Genotypes"}],"name":"get_Genotypes","containerName":"main::","definition":"sub","detail":"($self,@args)","line":254,"kind":12,"range":{"start":{"character":0,"line":254},"end":{"character":9999,"line":267}},"signature":{"label":"get_Genotypes($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)"}},{"line":282,"kind":12,"range":{"start":{"line":282,"character":0},"end":{"character":9999,"line":292}},"signature":{"label":"has_Marker($self,$name)","documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   if( @args ) {\n       unshift @args, '-marker' if( @args == 1 );  # deal with single args\n       \n       my ($name) = $self->_rearrange([qw(MARKER)], @args);\n       if( ! $name ) {\n\t   $self->warn(\"Only know how to process the -marker field currently\");\n\t   return();\n       }\n       my $v = $self->{'_genotypes'}->{$name};\n       return $v;\n   }\n   return values %{$self->{'_genotypes'} || {}};\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name","parameters":[{"label":"$self"},{"label":"$name"}]},"children":[{"line":283,"localvar":"my","containerName":"has_Marker","kind":13,"name":"$self","definition":"my"},{"line":283,"name":"$name","kind":13,"containerName":"has_Marker"},{"line":284,"name":"$name","kind":13,"containerName":"has_Marker"},{"line":286,"name":"$name","containerName":"has_Marker","kind":13},{"line":286,"name":"$name","kind":13,"containerName":"has_Marker"},{"name":"name","kind":12,"containerName":"has_Marker","line":286},{"name":"$name","kind":13,"containerName":"has_Marker","line":286},{"name":"$name","kind":13,"containerName":"has_Marker","line":286},{"name":"isa","containerName":"has_Marker","kind":12,"line":286},{"containerName":"has_Marker","kind":13,"name":"$name","line":287},{"name":"$self","kind":13,"containerName":"has_Marker","line":288},{"line":288,"kind":12,"containerName":"has_Marker","name":"warn"},{"line":288,"kind":13,"containerName":"has_Marker","name":"$name"},{"name":"$self","kind":13,"containerName":"has_Marker","line":291},{"line":291,"name":"$name","kind":13,"containerName":"has_Marker"}],"name":"has_Marker","containerName":"main::","definition":"sub","detail":"($self,$name)"},{"name":"get_marker_names","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_marker_names","localvar":"my","kind":13,"line":306},{"line":307,"kind":13,"containerName":"get_marker_names","name":"$self"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":307,"character":9999},"start":{"line":305,"character":0}},"line":305,"signature":{"documentation":"1;\n# $Id: Individual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Individual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Individual - An implementation of an Individual who has\nGenotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Individual;\n\n  my $ind = Bio::PopGen::Individual->new(-unique_id => $id,\n                                        -genotypes => \\@genotypes);\n\n=head1 DESCRIPTION\n\nThis object is a container for genotypes.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Individual;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Individual->new();\n Function: Builds a new Bio::PopGen::Individual object \n Returns : an instance of Bio::PopGen::Individual\n Args    : -unique_id => $id,\n           -genotypes => \\@genotypes\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_genotypes'} = {};\n  my ($uid,$genotypes) = $self->_rearrange([qw(UNIQUE_ID\n\t\t\t\t\t       GENOTYPES)],@args);\n  unless( defined $uid ) {\n      $uid = $UIDCOUNTER++;\n  } \n  $self->unique_id($uid);\n  if( defined $genotypes ) {\n      if( ref($genotypes) =~ /array/i ) {\n\t  $self->add_Genotype(@$genotypes);\n      } else { \n\t  $self->warn(\"Must provide a valid array reference to set the genotypes value in the contructor\");\n      }\n  }\n  return $self;\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = shift;\n   return $self->{'_unique_id'} = shift if @_;\n   return $self->{'_unique_id'};\n}\n\n=head2 num_of_results\n\n Title   : num_of_results\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_of_results {\n    return scalar keys %{shift->{'_genotypes'}};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 add_Genotype\n\n Title   : add_Genotype\n Usage   : $individual->add_Genotype\n Function: add a genotype value\n Returns : count of the number of genotypes associated with this individual\n Args    : @genotypes - L<Bio::PopGen::GenotypeI> object(s) containing \n                        alleles plus a marker name\n\n\nsub add_Genotype {\n   my ($self,@genotypes) = @_;\n   \n   foreach my $g ( @genotypes ) {\n       if( !ref($g) || ! $g->isa('Bio::PopGen::GenotypeI') ) {\n\t   $self->warn(\"cannot add $g as a genotype skipping\");\n\t   next;\n       }\n       my $mname = $g->marker_name;\n       if( ! defined $mname || ! length($mname) ) { \n         # can't just say ! name b/c '0' wouldn't be valid \n\t   $self->warn(\"cannot add genotype because marker name is not defined or is an empty string\");\n\t   next;\n       }\n       if( $self->verbose > 0 && \n\t   defined $self->{'_genotypes'}->{$mname} ) {\n\t   # a warning when we have verbosity cranked up \n\t   $self->debug(\"Overwriting the previous value for $mname for this individual\");\n       }\n       # this will force Genotype individual_id to be set to \n       # the Individual it has been added for\n       $g->individual_id($self->unique_id);\n       $self->{'_genotypes'}->{$mname} = $g;\n   }\n   return scalar keys %{$self->{'_genotypes'}};\n}\n\n=head2 reset_Genotypes\n\n Title   : reset_Genotypes\n Usage   : $individual->reset_Genotypes;\n Function: Reset the genotypes stored for this individual\n Returns : none\n Args    : none\n\n\n\nsub reset_Genotypes{\n    shift->{'_genotypes'} = {};\n}\n\n=head2 remove_Genotype\n\n Title   : remove_Genotype\n Usage   : $individual->remove_Genotype(@names)\n Function: Removes the genotypes for the requested markers\n Returns : none\n Args    : Names of markers \n\n\n\nsub remove_Genotype{\n   my ($self,@mkrs) = @_;\n   foreach my $m ( @mkrs ) {\n       delete($self->{'_genotypes'}->{$m});\n   }\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   if( @args ) {\n       unshift @args, '-marker' if( @args == 1 );  # deal with single args\n       \n       my ($name) = $self->_rearrange([qw(MARKER)], @args);\n       if( ! $name ) {\n\t   $self->warn(\"Only know how to process the -marker field currently\");\n\t   return();\n       }\n       my $v = $self->{'_genotypes'}->{$name};\n       return $v;\n   }\n   return values %{$self->{'_genotypes'} || {}};\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name\n\n\n\nsub has_Marker{\n   my ($self,$name) = @_;\n   return 0 if ! defined $name;\n\n   $name = $name->name if ref($name) && $name->isa('Bio::PopGen::MarkerI');\n   if( ref($name) ) { \n       $self->warn(\"Passed in a \".ref($name). \" to has_Marker, expecting either a string or a Bio::PopGen::MarkerI\");\n       return 0;\n   }\n   return defined $self->{'_genotypes'}->{$name};\n}\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $individual->get_marker_names;\n Function: Returns the list of known marker names\n Returns : List of strings\n Args    : none","parameters":[{"label":"$self"}],"label":"get_marker_names($self)"}}],"version":5}