{"version":5,"vars":[{"line":87,"name":"vars","kind":2,"containerName":""},{"line":90,"containerName":null,"kind":13,"name":"$BlankAlleles"},{"line":90,"containerName":"","kind":2,"name":"strict"},{"line":97,"containerName":"","kind":2,"name":"base"},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Genotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Genotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Genotype - An implementation of GenotypeI which is just an allele container\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Genotype;\n  my $genotype = Bio::PopGen::Genotype->new(-marker_name   => $name,\n                                           -individual_id => $indid,\n                                           -alleles       => \\@alleles);\n\n=head1 DESCRIPTION\n\nThis object will contain alleles for a given marker for a given\nindividual.\n\nThe class variable BlankAlleles (accessible through\n$Bio::PopGen::Genotype::BlankAlleles = 'somepattern') can be set to a\nregexp pattern for identifying blank alleles which should no be\ncounted (they are effectively missing data).  By default it set to\nmatch white space, '-', 'N' or 'n', and '?' as blank alleles which are\nskipped.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Genotype;\nuse vars qw($BlankAlleles);\nuse strict;\n\n$BlankAlleles = '[\\s\\-Nn\\?]';\n\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::GenotypeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Genotype->new();\n Function: Builds a new Bio::PopGen::Genotype object \n Returns : an instance of Bio::PopGen::Genotype\n Args    : -marker_name   => string representing name of the marker\n           -individual_id => string representing individual id (optional)\n           -alleles       => arrayref with each item in the array being an allele","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"start":{"character":0,"line":111},"end":{"character":9999,"line":128}},"kind":12,"line":111,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":112,"containerName":"new","localvar":"my","kind":13,"name":"$class","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":112},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":114},{"name":"$class","containerName":"new","kind":13,"line":114},{"kind":13,"containerName":"new","name":"@args","line":114},{"definition":"my","name":"$marker_name","localvar":"my","containerName":"new","kind":13,"line":115},{"name":"$ind_id","containerName":"new","kind":13,"line":115},{"containerName":"new","kind":13,"name":"$alleles","line":115},{"line":115,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":115},{"kind":13,"containerName":"new","name":"@args","line":117},{"kind":13,"containerName":"new","name":"$marker_name","line":118},{"name":"$self","kind":13,"containerName":"new","line":118},{"line":118,"name":"marker_name","kind":12,"containerName":"new"},{"line":118,"containerName":"new","kind":13,"name":"$marker_name"},{"containerName":"new","kind":13,"name":"$ind_id","line":119},{"line":119,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"individual_id","line":119},{"line":119,"kind":13,"containerName":"new","name":"$ind_id"},{"line":120,"containerName":"new","kind":13,"name":"$alleles"},{"line":121,"kind":13,"containerName":"new","name":"$alleles"},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"add_Allele","line":122},{"name":"$alleles","kind":13,"containerName":"new","line":122},{"name":"$self","kind":13,"containerName":"new","line":124},{"line":124,"kind":12,"containerName":"new","name":"warn"},{"line":127,"name":"$self","kind":13,"containerName":"new"}]},{"line":114,"name":"SUPER","kind":12,"containerName":"new"},{"line":142,"range":{"start":{"line":142,"character":0},"end":{"line":146,"character":9999}},"kind":12,"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"marker_name","line":143,"definition":"my"},{"name":"$self","containerName":"marker_name","kind":13,"line":144},{"line":145,"name":"$self","containerName":"marker_name","kind":13}],"containerName":"main::","name":"marker_name","definition":"sub"},{"containerName":"main::","name":"individual_id","children":[{"line":163,"name":"$self","localvar":"my","containerName":"individual_id","kind":13,"definition":"my"},{"line":164,"containerName":"individual_id","kind":13,"name":"$self"},{"kind":13,"containerName":"individual_id","name":"$self","line":165}],"definition":"sub","range":{"end":{"line":166,"character":9999},"start":{"line":162,"character":0}},"kind":12,"line":162},{"children":[{"name":"$self","containerName":"get_Alleles","localvar":"my","kind":13,"line":183,"definition":"my"},{"kind":13,"containerName":"get_Alleles","name":"$self","line":186}],"containerName":"main::","name":"get_Alleles","definition":"sub","line":182,"kind":12,"range":{"end":{"character":9999,"line":187},"start":{"line":182,"character":0}}},{"line":188,"kind":13,"containerName":null,"name":"%self"},{"line":189,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","kind":13,"containerName":null,"line":192},{"containerName":null,"kind":13,"name":"%self","line":193},{"containerName":null,"kind":13,"name":"%self","line":194},{"definition":"sub","children":[{"line":213,"kind":13,"localvar":"my","containerName":"add_Allele","name":"$self","definition":"my"},{"line":214,"name":"$self","kind":13,"containerName":"add_Allele"},{"line":215,"containerName":"add_Allele","kind":13,"name":"$self"}],"name":"add_Allele","containerName":"main::","line":212,"kind":12,"range":{"end":{"character":9999,"line":215},"start":{"character":0,"line":212}}},{"line":216,"containerName":null,"kind":13,"name":"%self"},{"children":[{"line":231,"localvar":"my","kind":13,"containerName":"reset_Alleles","name":"$self","definition":"my"},{"line":231,"kind":13,"containerName":"reset_Alleles","name":"@args"},{"line":232,"name":"$self","kind":13,"containerName":"reset_Alleles"},{"containerName":"reset_Alleles","kind":13,"name":"$self","line":233}],"containerName":"main::","name":"reset_Alleles","definition":"sub","detail":"($self,@args)","line":230,"range":{"start":{"character":0,"line":230},"end":{"line":235,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Genotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Genotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Genotype - An implementation of GenotypeI which is just an allele container\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Genotype;\n  my $genotype = Bio::PopGen::Genotype->new(-marker_name   => $name,\n                                           -individual_id => $indid,\n                                           -alleles       => \\@alleles);\n\n=head1 DESCRIPTION\n\nThis object will contain alleles for a given marker for a given\nindividual.\n\nThe class variable BlankAlleles (accessible through\n$Bio::PopGen::Genotype::BlankAlleles = 'somepattern') can be set to a\nregexp pattern for identifying blank alleles which should no be\ncounted (they are effectively missing data).  By default it set to\nmatch white space, '-', 'N' or 'n', and '?' as blank alleles which are\nskipped.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Genotype;\nuse vars qw($BlankAlleles);\nuse strict;\n\n$BlankAlleles = '[\\s\\-Nn\\?]';\n\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::GenotypeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Genotype->new();\n Function: Builds a new Bio::PopGen::Genotype object \n Returns : an instance of Bio::PopGen::Genotype\n Args    : -marker_name   => string representing name of the marker\n           -individual_id => string representing individual id (optional)\n           -alleles       => arrayref with each item in the array being an allele\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($marker_name, $ind_id, $alleles) = $self->_rearrange([qw(MARKER_NAME\n\t\t\t\t\t\t\t       INDIVIDUAL_ID\n\t\t\t\t\t\t\t       ALLELES)],@args);\n  defined $marker_name && $self->marker_name($marker_name);\n  defined $ind_id      && $self->individual_id($ind_id);\n  if( defined $alleles ) {\n      if( ref($alleles) =~ /array/i ) {\n\t  $self->add_Allele(@$alleles);\n      } else { \n\t  $self->warn(\"Could not initialize with -alleles value, it is not an array ref\");\n      }\n  }\n  return $self;\n}\n\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : [optional] marker name value to store\n\n\n\nsub marker_name{\n    my ($self) = shift;\n    return $self->{'_marker_name'} = shift if @_;\n    return $self->{'_marker_name'};\n}\n\n=head2 individual_id\n\n Title   : individual_id\n Usage   : my $indid = $genotype->individual_id();\n Function: Gets the individual id associated with a genotype\n           This is effectively a back reference since we will typically\n           associate a genotype with an individual with an \n           individual HAS-A genotype relationship.\n Returns : unique id string for an individual\n Args    : none\n\n\n\nsub individual_id {\n    my ($self) = shift;\n    return $self->{'_individual_id'} = shift if @_;\n    return $self->{'_individual_id'};\n}\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $genotype->get_Alleles();\n Function: Get the alleles for a given marker and individual\n Returns : array of alleles (strings in this implementation)\n Args    : $showblank - boolean flag to indicate return ALL alleles not \n                        skipping the coded EMPTY alleles\n\n Note    : Uses the class variable $BlankAlleles to test if alleles\n           should be skipped or not.\n\n\nsub get_Alleles{\n    my ($self) = shift;\n    \n     if( @_ && $_[0] ) {\n\treturn @{$self->{'_alleles'} || []};\n    } else {\n\tif( defined $self->{'_cached_noblank'} ) {\n\t    return @{$self->{'_cached_noblank'}} \n\t}\n\t# one liners - woo hoo.\n\t$self->{'_cached_noblank'} = [ grep { ! /^\\s*$BlankAlleles\\s*$/o } \n\t\t\t\t       @{$self->{'_alleles'} || []}];\n\treturn @{$self->{'_cached_noblank'}};\n    }\n}\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $genotype->add_Allele(@alleles);\n Function: Add alleles to the genotype, at this point there is no\n           verification to insure that haploid individuals only have 1 \n           allele or that diploids only have 2 - we assume that is\n           done by the user creating these objects \n Returns : count of the number of alleles in genotype\n Args    : Array of alleles to store\n\n\n\nsub add_Allele {\n    my ($self) = shift;\n    $self->{'_cached_noblank'} = undef;    \n    push @{$self->{'_alleles'}}, @_;\n    return scalar @{$self->{'_alleles'}};\n}\n\n=head2 reset_Alleles\n\n Title   : reset_Alleles\n Usage   : $genotype->reset_Alleles;\n Function: Resets the stored alleles so the list is empty\n Returns : None\n Args    : None","parameters":[{"label":"$self"},{"label":"@args"}],"label":"reset_Alleles($self,@args)"}}]}