{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":63},{"containerName":"main::","name":"new","children":[{"line":88,"name":"$pkg","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":88,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":90,"name":"$self","localvar":"my","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$pkg","line":90},{"name":"@args","kind":13,"containerName":"new","line":90},{"line":92,"localvar":"my","kind":13,"containerName":"new","name":"$leavesR","definition":"my"},{"line":92,"name":"$numleaves","containerName":"new","kind":13},{"line":92,"containerName":"new","kind":13,"name":"$numhybrids"},{"name":"$self","containerName":"new","kind":13,"line":93},{"name":"_rearrange","kind":12,"containerName":"new","line":93},{"line":95,"kind":13,"containerName":"new","name":"@args"},{"line":97,"name":"@leaves","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$leavesR","kind":13,"containerName":"new","line":98},{"name":"$numleaves","containerName":"new","kind":13,"line":98},{"containerName":"new","kind":13,"name":"@leaves","line":99},{"containerName":"new","kind":13,"name":"$numleaves","line":99},{"kind":13,"containerName":"new","name":"$leavesR","line":100},{"line":100,"kind":13,"containerName":"new","name":"@leaves"},{"line":102,"kind":13,"containerName":"new","name":"$leavesR"},{"line":103,"name":"$self","kind":13,"containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":103},{"name":"@leaves","kind":13,"containerName":"new","line":105},{"line":105,"kind":13,"containerName":"new","name":"$leavesR"},{"containerName":"new","kind":13,"name":"$self","line":106},{"containerName":"new","kind":13,"name":"$leavesR","line":106},{"line":108,"containerName":"new","kind":13,"name":"$numleaves"},{"line":108,"name":"@leaves","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":109},{"line":109,"containerName":"new","kind":13,"name":"$numleaves"},{"line":110,"kind":13,"containerName":"new","name":"$numleaves"},{"line":111,"name":"@leavesparent","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":111,"containerName":"new","kind":13,"name":"@leaves"},{"containerName":"new","localvar":"my","kind":13,"name":"$newleaf","line":112,"definition":"my"},{"line":112,"containerName":"new","kind":13,"name":"@leavesparent"},{"containerName":"new","kind":13,"name":"$self","line":113},{"containerName":"new","kind":13,"name":"$newleaf","line":113},{"line":114,"name":"$self","containerName":"new","kind":13},{"line":115,"kind":13,"containerName":"new","name":"$pkg"},{"line":115,"containerName":"new","kind":13,"name":"@leavesparent"},{"line":116,"localvar":"my","containerName":"new","kind":13,"name":"$oldnet","definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":116},{"line":116,"kind":12,"containerName":"new","name":"next_network"},{"name":"$self","containerName":"new","kind":13,"line":117},{"name":"$oldnet","containerName":"new","kind":13,"line":117},{"definition":"my","name":"@candidates","kind":13,"localvar":"my","containerName":"new","line":118},{"name":"$oldnet","kind":13,"containerName":"new","line":118},{"line":118,"name":"nodes","containerName":"new","kind":12},{"line":119,"containerName":"new","kind":13,"name":"$self"},{"kind":13,"containerName":"new","name":"@candidates","line":119},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"@candidatesbis","line":120},{"containerName":"new","kind":13,"name":"$oldnet","line":120},{"name":"internal_nodes","containerName":"new","kind":12,"line":120},{"name":"$self","kind":13,"containerName":"new","line":121},{"kind":13,"containerName":"new","name":"@candidatesbis","line":121},{"name":"$self","kind":13,"containerName":"new","line":122},{"kind":13,"containerName":"new","name":"$self","line":124},{"line":126,"kind":13,"containerName":"new","name":"$self"},{"line":126,"containerName":"new","kind":13,"name":"$pkg"}],"detail":"($pkg,@args)","definition":"sub","kind":12,"range":{"start":{"line":87,"character":0},"end":{"line":127,"character":9999}},"line":87,"signature":{"documentation":"1;\n# $Id: TreeFactoryMulti.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryMulti\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryMulti - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryMulti;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".","parameters":[{"label":"$pkg"},{"label":"@args"}],"label":"new($pkg,@args)"}},{"name":"PhyloNetwork","kind":2,"containerName":"Bio","line":88},{"name":"SUPER","kind":12,"containerName":"new","line":90},{"line":106,"name":"leaves","kind":12},{"kind":12,"name":"numleaves","line":109},{"line":113,"name":"newleaf","kind":12},{"kind":12,"name":"parent","line":114},{"name":"parent","kind":12,"line":116},{"line":117,"name":"oldnet","kind":12},{"line":119,"kind":12,"name":"candidates"},{"line":121,"name":"candidatesbis","kind":12},{"line":122,"name":"processbis","kind":12},{"line":124,"kind":12,"name":"index"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeFactoryMulti.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryMulti\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryMulti - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryMulti;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n    my @candidatesbis=$oldnet->internal_nodes();\n    $self->{candidatesbis}=\\@candidatesbis;\n    $self->{processbis}=0;\n  }\n  $self->{index}=0;\n\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","label":"next_network($self)"},"kind":12,"range":{"start":{"line":139,"character":0},"end":{"character":9999,"line":173}},"line":139,"detail":"($self)","definition":"sub","name":"next_network","containerName":"main::","children":[{"line":140,"name":"$self","kind":13,"localvar":"my","containerName":"next_network","definition":"my"},{"definition":"my","line":142,"name":"$n","containerName":"next_network","localvar":"my","kind":13},{"line":142,"kind":13,"containerName":"next_network","name":"$self"},{"line":143,"kind":13,"containerName":"next_network","name":"$self"},{"kind":13,"containerName":"next_network","name":"$self","line":144},{"definition":"my","line":145,"localvar":"my","kind":13,"containerName":"next_network","name":"$graph"},{"line":145,"name":"new","containerName":"next_network","kind":12},{"line":146,"name":"$graph","kind":13,"containerName":"next_network"},{"line":146,"kind":12,"containerName":"next_network","name":"add_edges"},{"line":146,"name":"$self","kind":13,"containerName":"next_network"},{"name":"$self","kind":13,"containerName":"next_network","line":146},{"line":147,"containerName":"next_network","localvar":"my","kind":13,"name":"$net","definition":"my"},{"line":147,"name":"new","containerName":"next_network","kind":12},{"line":147,"containerName":"next_network","kind":13,"name":"$graph"},{"name":"$self","containerName":"next_network","kind":13,"line":148},{"line":149,"kind":13,"containerName":"next_network","name":"$net"},{"line":156,"name":"$self","containerName":"next_network","kind":13},{"line":156,"name":"$self","containerName":"next_network","kind":13},{"line":156,"name":"$self","kind":13,"containerName":"next_network"},{"definition":"my","localvar":"my","containerName":"next_network","kind":13,"name":"$oldnet","line":158},{"line":158,"name":"$self","containerName":"next_network","kind":13},{"line":158,"name":"next_network","containerName":"next_network","kind":12},{"line":159,"kind":13,"containerName":"next_network","name":"$oldnet"},{"line":162,"name":"$self","kind":13,"containerName":"next_network"},{"name":"$oldnet","containerName":"next_network","kind":13,"line":162},{"line":163,"name":"@candidates","containerName":"next_network","localvar":"my","kind":13,"definition":"my"},{"line":163,"name":"$oldnet","kind":13,"containerName":"next_network"},{"name":"nodes","containerName":"next_network","kind":12,"line":163},{"kind":13,"containerName":"next_network","name":"$self","line":164},{"kind":13,"containerName":"next_network","name":"@candidates","line":164},{"definition":"my","name":"@candidatesbis","localvar":"my","kind":13,"containerName":"next_network","line":165},{"kind":13,"containerName":"next_network","name":"$oldnet","line":165},{"kind":12,"containerName":"next_network","name":"internal_nodes","line":165},{"line":166,"name":"$self","kind":13,"containerName":"next_network"},{"line":166,"containerName":"next_network","kind":13,"name":"@candidatesbis"},{"name":"$self","kind":13,"containerName":"next_network","line":167},{"line":168,"containerName":"next_network","kind":13,"name":"$self"},{"name":"$n1","localvar":"my","kind":13,"containerName":"next_network","line":169,"definition":"my"},{"containerName":"next_network","kind":13,"name":"@candidates","line":169},{"definition":"my","name":"$n2","localvar":"my","kind":13,"containerName":"next_network","line":170},{"line":170,"name":"@candidatesbis","containerName":"next_network","kind":13},{"kind":13,"containerName":"next_network","name":"$oldnet","line":171},{"name":"eNewick","containerName":"next_network","kind":12,"line":171},{"line":171,"name":"$self","kind":13,"containerName":"next_network"},{"line":173,"containerName":"next_network","kind":13,"name":"$self"},{"line":173,"kind":13,"containerName":"next_network","name":"$self"}]},{"kind":12,"name":"numleaves","line":142},{"name":"numleaves","kind":12,"line":143},{"name":"index","kind":12,"line":144},{"line":145,"containerName":"Directed","kind":12,"name":"Graph"},{"name":"leaves","kind":12,"line":146},{"line":146,"name":"leaves","kind":12},{"line":147,"name":"Bio","kind":12,"containerName":"PhyloNetwork"},{"line":148,"name":"index","kind":12},{"line":156,"name":"index","kind":12},{"line":156,"name":"candidatesbis","kind":12},{"name":"processbis","kind":12,"line":156},{"name":"parent","kind":12,"line":158},{"name":"oldnet","kind":12,"line":162},{"kind":12,"name":"candidates","line":164},{"line":166,"name":"candidatesbis","kind":12},{"name":"processbis","kind":12,"line":167},{"line":168,"name":"index","kind":12},{"line":171,"name":"numleaves","kind":12},{"line":173,"name":"index","kind":12},{"line":173,"kind":12,"name":"candidates"},{"line":173,"containerName":null,"kind":13,"name":"%self"},{"name":"processbis","kind":12,"line":173},{"line":175,"name":"%self","kind":13,"containerName":null},{"name":"processbis","kind":12,"line":175},{"line":176,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"index","line":176},{"line":179,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"processbis","line":179},{"line":180,"name":"$graph","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":180},{"line":180,"name":"oldnet","kind":12},{"kind":12,"name":"graph","line":180},{"line":180,"containerName":"main::","kind":12,"name":"copy"},{"definition":"my","name":"$u","localvar":"my","containerName":null,"kind":13,"line":181},{"line":181,"kind":13,"containerName":null,"name":"%self"},{"line":181,"kind":12,"name":"candidates"},{"line":181,"name":"%self","kind":13,"containerName":null},{"name":"index","kind":12,"line":181},{"line":182,"kind":13,"localvar":"my","containerName":null,"name":"$w","definition":"my"},{"name":"$graph","kind":13,"containerName":null,"line":182},{"name":"predecessors","containerName":"main::","kind":12,"line":182},{"line":182,"name":"%u","containerName":null,"kind":13},{"line":183,"name":"$graph","containerName":null,"kind":13},{"line":183,"kind":12,"containerName":"main::","name":"delete_edge"},{"kind":13,"containerName":null,"name":"$w","line":183},{"kind":13,"containerName":null,"name":"$u","line":183},{"name":"$graph","kind":13,"containerName":null,"line":184},{"containerName":"main::","kind":12,"name":"add_edge","line":184},{"line":184,"name":"$w","kind":13,"containerName":null},{"line":186,"name":"$graph","kind":13,"containerName":null},{"line":186,"containerName":"main::","kind":12,"name":"add_edge"},{"line":186,"name":"$u","containerName":null,"kind":13},{"line":187,"containerName":null,"kind":13,"name":"$graph"},{"line":187,"kind":12,"containerName":"main::","name":"add_edge"},{"line":187,"name":"%self","containerName":null,"kind":13},{"line":187,"name":"newleaf","kind":12},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$net","line":188},{"line":188,"containerName":"PhyloNetwork","kind":12,"name":"Bio"},{"containerName":"main::","kind":12,"name":"new","line":188},{"containerName":null,"kind":13,"name":"$graph","line":188},{"containerName":null,"kind":13,"name":"%self","line":189},{"line":189,"name":"index","kind":12},{"line":190,"kind":13,"containerName":null,"name":"%net"},{"localvar":"my","kind":13,"containerName":null,"name":"$graph","line":192,"definition":"my"},{"line":192,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"oldnet","line":192},{"name":"graph","kind":12,"line":192},{"line":192,"kind":12,"containerName":"main::","name":"copy"},{"definition":"my","line":193,"localvar":"my","kind":13,"containerName":null,"name":"$u"},{"name":"%self","kind":13,"containerName":null,"line":193},{"line":193,"name":"candidatesbis","kind":12},{"kind":13,"containerName":null,"name":"%self","line":193},{"name":"index","kind":12,"line":193},{"line":195,"kind":13,"containerName":null,"name":"$graph"},{"line":195,"name":"add_edge","containerName":"main::","kind":12},{"line":195,"name":"$u","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":195},{"line":195,"name":"newleaf","kind":12},{"line":196,"name":"$net","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":196,"name":"Bio","kind":12,"containerName":"PhyloNetwork"},{"name":"new","containerName":"main::","kind":12,"line":196},{"line":196,"name":"$graph","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":197},{"kind":12,"name":"index","line":197},{"line":198,"containerName":null,"kind":13,"name":"$net"}]}