{"vars":[{"containerName":"","kind":2,"name":"base","line":139},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment ","label":"new($class,@args)"},"range":{"end":{"line":182,"character":9999},"start":{"line":158,"character":0}},"kind":12,"line":158,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":160,"name":"$class","localvar":"my","containerName":"new","kind":13},{"line":160,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":162,"name":"$self","containerName":"new","localvar":"my","kind":13},{"name":"$class","kind":13,"containerName":"new","line":162},{"line":162,"name":"@args","containerName":"new","kind":13},{"line":164,"name":"$name","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$description","line":165},{"name":"$species","containerName":"new","kind":13,"line":166},{"kind":13,"containerName":"new","name":"$comment","line":167},{"line":168,"containerName":"new","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"new","line":168},{"line":171,"containerName":"new","kind":13,"name":"@args"},{"line":173,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"init","line":173},{"line":175,"containerName":"new","kind":13,"name":"$name"},{"line":175,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"name","line":175},{"containerName":"new","kind":13,"name":"$name","line":175},{"name":"$description","containerName":"new","kind":13,"line":176},{"name":"$self","kind":13,"containerName":"new","line":176},{"line":176,"containerName":"new","kind":12,"name":"description"},{"name":"$description","containerName":"new","kind":13,"line":176},{"line":177,"containerName":"new","kind":13,"name":"$species"},{"name":"$self","containerName":"new","kind":13,"line":177},{"kind":12,"containerName":"new","name":"species","line":177},{"line":177,"name":"$species","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$comment","line":178},{"name":"$self","containerName":"new","kind":13,"line":178},{"line":178,"kind":12,"containerName":"new","name":"comment"},{"line":178,"name":"$comment","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":180}]},{"name":"SUPER","containerName":"new","kind":12,"line":162},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :","label":"init($self)"},"line":195,"kind":12,"range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":195}},"definition":"sub","detail":"($self)","children":[{"containerName":"init","localvar":"my","kind":13,"name":"$self","line":197,"definition":"my"},{"name":"$self","containerName":"init","kind":13,"line":200},{"name":"name","kind":12,"containerName":"init","line":200},{"kind":13,"containerName":"init","name":"$self","line":201},{"name":"description","containerName":"init","kind":12,"line":201},{"line":202,"name":"$species","containerName":"init","localvar":"my","kind":13,"definition":"my"},{"kind":12,"containerName":"init","name":"new","line":202},{"containerName":"init","kind":13,"name":"$species","line":203},{"line":203,"containerName":"init","kind":12,"name":"classification"},{"line":204,"name":"$self","kind":13,"containerName":"init"},{"line":204,"name":"species","kind":12,"containerName":"init"},{"kind":13,"containerName":"init","name":"$species","line":204},{"kind":13,"containerName":"init","name":"$self","line":205},{"line":205,"kind":12,"containerName":"init","name":"comment"},{"name":"$self","kind":13,"containerName":"init","line":206},{"name":"remove_Correlates","kind":12,"containerName":"init","line":206},{"line":207,"containerName":"init","kind":13,"name":"$self"},{"line":207,"containerName":"init","kind":12,"name":"remove_References"},{"line":208,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","kind":12,"name":"remove_CytoPositions","line":208},{"line":209,"name":"$self","containerName":"init","kind":13},{"kind":12,"containerName":"init","name":"remove_gene_symbols","line":209},{"line":210,"containerName":"init","kind":13,"name":"$self"},{"line":210,"containerName":"init","kind":12,"name":"remove_Genotypes"},{"kind":13,"containerName":"init","name":"$self","line":211},{"line":211,"kind":12,"containerName":"init","name":"remove_DBLinks"},{"line":212,"name":"$self","containerName":"init","kind":13},{"kind":12,"containerName":"init","name":"remove_keywords","line":212},{"kind":13,"containerName":"init","name":"$self","line":213},{"line":213,"name":"remove_Variants","containerName":"init","kind":12},{"line":214,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","kind":12,"name":"remove_Measures","line":214}],"name":"init","containerName":"main::"},{"line":202,"name":"Bio","containerName":"Species","kind":12},{"line":231,"kind":12,"range":{"start":{"line":231,"character":0},"end":{"line":240,"character":9999}},"signature":{"label":"name($self,$value)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"line":232,"containerName":"name","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":232,"name":"$value","containerName":"name","kind":13},{"containerName":"name","kind":13,"name":"$value","line":234},{"line":235,"name":"$self","kind":13,"containerName":"name"},{"name":"$value","kind":13,"containerName":"name","line":235},{"name":"$self","containerName":"name","kind":13,"line":238}],"containerName":"main::","name":"name","definition":"sub","detail":"($self,$value)"},{"name":"description","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"description","line":256,"definition":"my"},{"kind":13,"containerName":"description","name":"$self","line":257},{"kind":13,"containerName":"description","name":"$self","line":258}],"definition":"sub","range":{"start":{"line":255,"character":0},"end":{"line":259,"character":9999}},"kind":12,"line":255},{"name":"species","containerName":"main::","children":[{"line":274,"name":"$self","kind":13,"localvar":"my","containerName":"species","definition":"my"},{"line":274,"containerName":"species","kind":13,"name":"$value"},{"line":276,"containerName":"species","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"species","line":277},{"name":"_check_ref_type","kind":12,"containerName":"species","line":277},{"containerName":"species","kind":13,"name":"$value","line":277},{"containerName":"species","kind":13,"name":"$self","line":278},{"kind":13,"containerName":"species","name":"$value","line":278},{"line":281,"name":"$self","kind":13,"containerName":"species"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":283,"character":9999},"start":{"character":0,"line":273}},"kind":12,"line":273,"signature":{"label":"species($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional)."}},{"definition":"sub","containerName":"main::","name":"comment","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"comment","name":"$self","line":298},{"name":"$self","containerName":"comment","kind":13,"line":299},{"kind":13,"containerName":"comment","name":"$self","line":300}],"kind":12,"range":{"end":{"character":9999,"line":301},"start":{"character":0,"line":297}},"line":297},{"detail":"($self)","definition":"sub","containerName":"main::","name":"each_gene_symbol","children":[{"line":316,"name":"$self","containerName":"each_gene_symbol","localvar":"my","kind":13,"definition":"my"},{"containerName":"each_gene_symbol","kind":13,"name":"$self","line":318}],"signature":{"label":"each_gene_symbol($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":315}},"kind":12,"line":315},{"line":318,"name":"%self","containerName":null,"kind":13},{"definition":"sub","detail":"($self,@values)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_gene_symbols","line":337},{"kind":13,"containerName":"add_gene_symbols","name":"@values","line":337},{"line":339,"containerName":"add_gene_symbols","kind":13,"name":"@values"},{"kind":13,"containerName":"add_gene_symbols","name":"$self","line":341}],"name":"add_gene_symbols","containerName":"main::","signature":{"label":"add_gene_symbols($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"line":336,"range":{"start":{"line":336,"character":0},"end":{"line":341,"character":9999}},"kind":12},{"line":341,"name":"@values","kind":13,"containerName":null},{"range":{"start":{"character":0,"line":356},"end":{"character":9999,"line":363}},"kind":12,"line":356,"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_gene_symbols($self)"},"containerName":"main::","name":"remove_gene_symbols","children":[{"kind":13,"localvar":"my","containerName":"remove_gene_symbols","name":"$self","line":357,"definition":"my"},{"definition":"my","name":"@a","localvar":"my","containerName":"remove_gene_symbols","kind":13,"line":359},{"line":359,"containerName":"remove_gene_symbols","kind":13,"name":"$self"},{"containerName":"remove_gene_symbols","kind":12,"name":"each_gene_symbol","line":359},{"containerName":"remove_gene_symbols","kind":13,"name":"$self","line":360},{"kind":13,"containerName":"remove_gene_symbols","name":"@a","line":361}],"detail":"($self)","definition":"sub"},{"line":383,"range":{"start":{"character":0,"line":383},"end":{"line":386,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","label":"each_Variant($self)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"each_Variant","name":"$self","line":384},{"line":386,"containerName":"each_Variant","kind":13,"name":"$self"}],"name":"each_Variant","containerName":"main::","definition":"sub","detail":"($self)"},{"line":386,"name":"%self","kind":13,"containerName":null},{"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_Variants($self,@values)"},"line":403,"range":{"end":{"character":9999,"line":412},"start":{"character":0,"line":403}},"kind":12,"definition":"sub","detail":"($self,@values)","children":[{"definition":"my","localvar":"my","containerName":"add_Variants","kind":13,"name":"$self","line":404},{"name":"@values","kind":13,"containerName":"add_Variants","line":404},{"name":"@values","containerName":"add_Variants","kind":13,"line":406},{"name":"$value","localvar":"my","containerName":"add_Variants","kind":13,"line":408,"definition":"my"},{"containerName":"add_Variants","kind":13,"name":"@values","line":408},{"line":409,"name":"$self","containerName":"add_Variants","kind":13},{"line":409,"kind":12,"containerName":"add_Variants","name":"_check_ref_type"},{"containerName":"add_Variants","kind":13,"name":"$value","line":409},{"kind":13,"containerName":"add_Variants","name":"$self","line":412}],"name":"add_Variants","containerName":"main::"},{"name":"@values","kind":13,"containerName":null,"line":412},{"children":[{"definition":"my","line":429,"name":"$self","localvar":"my","containerName":"remove_Variants","kind":13},{"definition":"my","line":431,"kind":13,"localvar":"my","containerName":"remove_Variants","name":"@a"},{"kind":13,"containerName":"remove_Variants","name":"$self","line":431},{"kind":12,"containerName":"remove_Variants","name":"each_Variant","line":431},{"line":432,"containerName":"remove_Variants","kind":13,"name":"$self"},{"line":433,"kind":13,"containerName":"remove_Variants","name":"@a"}],"name":"remove_Variants","containerName":"main::","definition":"sub","detail":"($self)","line":428,"range":{"end":{"character":9999,"line":435},"start":{"line":428,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","label":"remove_Variants($self)"}},{"containerName":"main::","name":"each_Reference","children":[{"definition":"my","line":452,"localvar":"my","containerName":"each_Reference","kind":13,"name":"$self"},{"kind":13,"containerName":"each_Reference","name":"$self","line":454}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":451},"end":{"character":9999,"line":454}},"kind":12,"line":451,"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Reference($self)"}},{"name":"%self","containerName":null,"kind":13,"line":454},{"detail":"($self,@values)","definition":"sub","name":"add_References","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"add_References","kind":13,"line":473},{"name":"@values","containerName":"add_References","kind":13,"line":473},{"name":"@values","kind":13,"containerName":"add_References","line":475},{"definition":"my","localvar":"my","containerName":"add_References","kind":13,"name":"$value","line":477},{"line":477,"name":"@values","kind":13,"containerName":"add_References"},{"line":478,"name":"$self","kind":13,"containerName":"add_References"},{"containerName":"add_References","kind":12,"name":"_check_ref_type","line":478},{"line":478,"kind":13,"containerName":"add_References","name":"$value"},{"line":481,"containerName":"add_References","kind":13,"name":"$self"}],"signature":{"label":"add_References($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"range":{"end":{"line":481,"character":9999},"start":{"line":472,"character":0}},"kind":12,"line":472},{"line":481,"containerName":null,"kind":13,"name":"@values"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","label":"remove_References($self)"},"range":{"start":{"character":0,"line":497},"end":{"line":504,"character":9999}},"kind":12,"line":497,"detail":"($self)","definition":"sub","name":"remove_References","containerName":"main::","children":[{"definition":"my","line":498,"name":"$self","containerName":"remove_References","localvar":"my","kind":13},{"line":500,"localvar":"my","containerName":"remove_References","kind":13,"name":"@a","definition":"my"},{"line":500,"name":"$self","kind":13,"containerName":"remove_References"},{"kind":12,"containerName":"remove_References","name":"each_Reference","line":500},{"line":501,"name":"$self","containerName":"remove_References","kind":13},{"line":502,"kind":13,"containerName":"remove_References","name":"@a"}]},{"signature":{"label":"each_CytoPosition($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :"},"line":520,"range":{"start":{"character":0,"line":520},"end":{"line":523,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":521,"name":"$self","containerName":"each_CytoPosition","localvar":"my","kind":13},{"name":"$self","containerName":"each_CytoPosition","kind":13,"line":523}],"containerName":"main::","name":"each_CytoPosition"},{"line":523,"name":"%self","kind":13,"containerName":null},{"line":541,"kind":12,"range":{"end":{"line":550,"character":9999},"start":{"character":0,"line":541}},"signature":{"parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).","label":"add_CytoPositions($self,@values)"},"children":[{"definition":"my","line":542,"containerName":"add_CytoPositions","localvar":"my","kind":13,"name":"$self"},{"line":542,"name":"@values","containerName":"add_CytoPositions","kind":13},{"name":"@values","kind":13,"containerName":"add_CytoPositions","line":544},{"localvar":"my","kind":13,"containerName":"add_CytoPositions","name":"$value","line":546,"definition":"my"},{"line":546,"kind":13,"containerName":"add_CytoPositions","name":"@values"},{"line":547,"containerName":"add_CytoPositions","kind":13,"name":"$self"},{"containerName":"add_CytoPositions","kind":12,"name":"_check_ref_type","line":547},{"line":547,"name":"$value","kind":13,"containerName":"add_CytoPositions"},{"kind":13,"containerName":"add_CytoPositions","name":"$self","line":550}],"name":"add_CytoPositions","containerName":"main::","definition":"sub","detail":"($self,@values)"},{"name":"@values","containerName":null,"kind":13,"line":550},{"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_CytoPositions($self)"},"line":566,"range":{"end":{"character":9999,"line":573},"start":{"character":0,"line":566}},"kind":12,"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"remove_CytoPositions","name":"$self","line":567,"definition":"my"},{"name":"@a","localvar":"my","kind":13,"containerName":"remove_CytoPositions","line":569,"definition":"my"},{"containerName":"remove_CytoPositions","kind":13,"name":"$self","line":569},{"line":569,"kind":12,"containerName":"remove_CytoPositions","name":"each_CytoPosition"},{"line":570,"name":"$self","containerName":"remove_CytoPositions","kind":13},{"line":571,"containerName":"remove_CytoPositions","kind":13,"name":"@a"}],"name":"remove_CytoPositions","containerName":"main::"},{"definition":"sub","detail":"($self)","children":[{"line":593,"containerName":"each_Correlate","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"each_Correlate","kind":13,"name":"$self","line":595}],"containerName":"main::","name":"each_Correlate","signature":{"label":"each_Correlate($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","parameters":[{"label":"$self"}]},"line":592,"kind":12,"range":{"start":{"character":0,"line":592},"end":{"line":595,"character":9999}}},{"containerName":null,"kind":13,"name":"%self","line":595},{"signature":{"label":"add_Correlates($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"line":615,"kind":12,"range":{"end":{"line":624,"character":9999},"start":{"character":0,"line":615}},"definition":"sub","detail":"($self,@values)","children":[{"line":616,"localvar":"my","containerName":"add_Correlates","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"add_Correlates","name":"@values","line":616},{"line":618,"name":"@values","containerName":"add_Correlates","kind":13},{"definition":"my","line":620,"localvar":"my","containerName":"add_Correlates","kind":13,"name":"$value"},{"line":620,"kind":13,"containerName":"add_Correlates","name":"@values"},{"line":621,"containerName":"add_Correlates","kind":13,"name":"$self"},{"line":621,"name":"_check_ref_type","containerName":"add_Correlates","kind":12},{"line":621,"containerName":"add_Correlates","kind":13,"name":"$value"},{"line":624,"name":"$self","containerName":"add_Correlates","kind":13}],"containerName":"main::","name":"add_Correlates"},{"name":"@values","containerName":null,"kind":13,"line":624},{"line":640,"kind":12,"range":{"start":{"line":640,"character":0},"end":{"character":9999,"line":647}},"signature":{"label":"remove_Correlates($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","parameters":[{"label":"$self"}]},"children":[{"definition":"my","localvar":"my","containerName":"remove_Correlates","kind":13,"name":"$self","line":641},{"line":643,"localvar":"my","kind":13,"containerName":"remove_Correlates","name":"@a","definition":"my"},{"containerName":"remove_Correlates","kind":13,"name":"$self","line":643},{"name":"each_Correlate","containerName":"remove_Correlates","kind":12,"line":643},{"line":644,"kind":13,"containerName":"remove_Correlates","name":"$self"},{"line":645,"containerName":"remove_Correlates","kind":13,"name":"@a"}],"name":"remove_Correlates","containerName":"main::","definition":"sub","detail":"($self)"},{"line":665,"range":{"end":{"line":668,"character":9999},"start":{"character":0,"line":665}},"kind":12,"signature":{"label":"each_Measure($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :"},"children":[{"definition":"my","localvar":"my","containerName":"each_Measure","kind":13,"name":"$self","line":666},{"name":"$self","kind":13,"containerName":"each_Measure","line":668}],"name":"each_Measure","containerName":"main::","definition":"sub","detail":"($self)"},{"name":"%self","containerName":null,"kind":13,"line":668},{"signature":{"parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).","label":"add_Measures($self,@values)"},"line":686,"kind":12,"range":{"end":{"line":695,"character":9999},"start":{"line":686,"character":0}},"definition":"sub","detail":"($self,@values)","children":[{"definition":"my","containerName":"add_Measures","localvar":"my","kind":13,"name":"$self","line":687},{"line":687,"name":"@values","kind":13,"containerName":"add_Measures"},{"name":"@values","kind":13,"containerName":"add_Measures","line":689},{"name":"$value","kind":13,"localvar":"my","containerName":"add_Measures","line":691,"definition":"my"},{"line":691,"kind":13,"containerName":"add_Measures","name":"@values"},{"name":"$self","kind":13,"containerName":"add_Measures","line":692},{"name":"_check_ref_type","containerName":"add_Measures","kind":12,"line":692},{"name":"$value","kind":13,"containerName":"add_Measures","line":692},{"containerName":"add_Measures","kind":13,"name":"$self","line":695}],"containerName":"main::","name":"add_Measures"},{"name":"@values","containerName":null,"kind":13,"line":695},{"children":[{"name":"$self","localvar":"my","containerName":"remove_Measures","kind":13,"line":712,"definition":"my"},{"definition":"my","line":714,"containerName":"remove_Measures","localvar":"my","kind":13,"name":"@a"},{"name":"$self","kind":13,"containerName":"remove_Measures","line":714},{"containerName":"remove_Measures","kind":12,"name":"each_Measure","line":714},{"line":715,"containerName":"remove_Measures","kind":13,"name":"$self"},{"name":"@a","containerName":"remove_Measures","kind":13,"line":716}],"containerName":"main::","name":"remove_Measures","definition":"sub","detail":"($self)","line":711,"kind":12,"range":{"end":{"line":718,"character":9999},"start":{"line":711,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","label":"remove_Measures($self)"}},{"definition":"sub","detail":"($self)","children":[{"line":735,"kind":13,"localvar":"my","containerName":"each_keyword","name":"$self","definition":"my"},{"containerName":"each_keyword","kind":13,"name":"$self","line":737}],"containerName":"main::","name":"each_keyword","signature":{"label":"each_keyword($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :"},"line":734,"range":{"end":{"character":9999,"line":737},"start":{"line":734,"character":0}},"kind":12},{"line":737,"name":"%self","containerName":null,"kind":13},{"detail":"($self,@values)","definition":"sub","containerName":"main::","name":"add_keywords","children":[{"name":"$self","localvar":"my","containerName":"add_keywords","kind":13,"line":756,"definition":"my"},{"line":756,"name":"@values","kind":13,"containerName":"add_keywords"},{"line":758,"name":"@values","containerName":"add_keywords","kind":13},{"line":760,"name":"$self","containerName":"add_keywords","kind":13}],"signature":{"label":"add_keywords($self,@values)","parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s)."},"kind":12,"range":{"start":{"character":0,"line":755},"end":{"line":760,"character":9999}},"line":755},{"line":760,"name":"@values","kind":13,"containerName":null},{"name":"remove_keywords","containerName":"main::","children":[{"definition":"my","line":777,"kind":13,"localvar":"my","containerName":"remove_keywords","name":"$self"},{"definition":"my","name":"@a","localvar":"my","kind":13,"containerName":"remove_keywords","line":779},{"name":"$self","kind":13,"containerName":"remove_keywords","line":779},{"line":779,"kind":12,"containerName":"remove_keywords","name":"each_keyword"},{"containerName":"remove_keywords","kind":13,"name":"$self","line":780},{"name":"@a","kind":13,"containerName":"remove_keywords","line":781}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":783},"start":{"line":776,"character":0}},"line":776,"signature":{"label":"remove_keywords($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","label":"each_DBLink($self)"},"line":799,"kind":12,"range":{"start":{"character":0,"line":799},"end":{"line":802,"character":9999}},"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"each_DBLink","line":800,"definition":"my"},{"line":802,"kind":13,"containerName":"each_DBLink","name":"$self"}],"name":"each_DBLink","containerName":"main::"},{"kind":13,"containerName":null,"name":"%self","line":802},{"containerName":"main::","name":"add_DBLinks","children":[{"definition":"my","line":821,"kind":13,"localvar":"my","containerName":"add_DBLinks","name":"$self"},{"kind":13,"containerName":"add_DBLinks","name":"@values","line":821},{"containerName":"add_DBLinks","kind":13,"name":"@values","line":823},{"definition":"my","kind":13,"localvar":"my","containerName":"add_DBLinks","name":"$value","line":825},{"line":825,"name":"@values","kind":13,"containerName":"add_DBLinks"},{"line":826,"name":"$self","containerName":"add_DBLinks","kind":13},{"line":826,"kind":12,"containerName":"add_DBLinks","name":"_check_ref_type"},{"line":826,"containerName":"add_DBLinks","kind":13,"name":"$value"},{"containerName":"add_DBLinks","kind":13,"name":"$self","line":829}],"detail":"($self,@values)","definition":"sub","range":{"start":{"line":820,"character":0},"end":{"character":9999,"line":829}},"kind":12,"line":820,"signature":{"label":"add_DBLinks($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).","parameters":[{"label":"$self"},{"label":"@values"}]}},{"kind":13,"containerName":null,"name":"@values","line":829},{"children":[{"definition":"my","line":846,"name":"$self","localvar":"my","kind":13,"containerName":"remove_DBLinks"},{"definition":"my","name":"@a","containerName":"remove_DBLinks","localvar":"my","kind":13,"line":848},{"name":"$self","kind":13,"containerName":"remove_DBLinks","line":848},{"line":848,"name":"each_DBLink","containerName":"remove_DBLinks","kind":12},{"line":849,"containerName":"remove_DBLinks","kind":13,"name":"$self"},{"line":850,"kind":13,"containerName":"remove_DBLinks","name":"@a"}],"containerName":"main::","name":"remove_DBLinks","definition":"sub","detail":"($self)","line":845,"range":{"start":{"character":0,"line":845},"end":{"line":852,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_DBLinks($self)"}},{"kind":12,"range":{"end":{"character":9999,"line":874},"start":{"line":871,"character":0}},"line":871,"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Genotype($self)"},"containerName":"main::","name":"each_Genotype","children":[{"definition":"my","name":"$self","containerName":"each_Genotype","localvar":"my","kind":13,"line":872},{"line":874,"containerName":"each_Genotype","kind":13,"name":"$self"}],"detail":"($self)","definition":"sub"},{"line":874,"containerName":null,"kind":13,"name":"%self"},{"range":{"end":{"line":901,"character":9999},"start":{"line":892,"character":0}},"kind":12,"line":892,"signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_Genotypes($self,@values)"},"name":"add_Genotypes","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"add_Genotypes","name":"$self","line":893,"definition":"my"},{"line":893,"name":"@values","containerName":"add_Genotypes","kind":13},{"line":895,"containerName":"add_Genotypes","kind":13,"name":"@values"},{"kind":13,"containerName":"add_Genotypes","name":"$self","line":901}],"detail":"($self,@values)","definition":"sub"},{"line":901,"name":"@values","kind":13,"containerName":null},{"signature":{"label":"remove_Genotypes($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    #foreach my $value ( @values ) {  \n    #    $self->_check_ref_type( $value, \"Bio::GenotypeI\" );\n    #}\n        \n    push( @{ $self->{ \"_genotypes\" } }, @values );\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :","parameters":[{"label":"$self"}]},"line":917,"kind":12,"range":{"start":{"character":0,"line":917},"end":{"line":924,"character":9999}},"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"remove_Genotypes","kind":13,"line":918},{"definition":"my","name":"@a","containerName":"remove_Genotypes","localvar":"my","kind":13,"line":920},{"line":920,"containerName":"remove_Genotypes","kind":13,"name":"$self"},{"line":920,"name":"each_Genotype","containerName":"remove_Genotypes","kind":12},{"kind":13,"containerName":"remove_Genotypes","name":"$self","line":921},{"line":922,"name":"@a","containerName":"remove_Genotypes","kind":13}],"name":"remove_Genotypes","containerName":"main::"},{"line":937,"kind":12,"range":{"end":{"line":952,"character":9999},"start":{"line":937,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    #foreach my $value ( @values ) {  \n    #    $self->_check_ref_type( $value, \"Bio::GenotypeI\" );\n    #}\n        \n    push( @{ $self->{ \"_genotypes\" } }, @values );\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub remove_Genotypes {\n    my ( $self ) = @_;\n\n    my @a = $self->each_Genotype();\n    $self->{ \"_genotypes\" } = [];\n    return @a;\n\n} # remove_Genotypes\n\n\n=head2 _check_ref_type\n\n Title   : _check_ref_type\n Usage   : $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n Function: Checks for the correct type.\n Returns : \n Args    : The value to be checked, the expected class.","label":"_check_ref_type($self,$value,$expected_class)"},"children":[{"definition":"my","localvar":"my","containerName":"_check_ref_type","kind":13,"name":"$self","line":938},{"line":938,"name":"$value","containerName":"_check_ref_type","kind":13},{"containerName":"_check_ref_type","kind":13,"name":"$expected_class","line":938},{"containerName":"_check_ref_type","kind":13,"name":"$value","line":940},{"containerName":"_check_ref_type","kind":13,"name":"$self","line":941},{"line":941,"name":"throw","kind":12,"containerName":"_check_ref_type"},{"kind":13,"containerName":"_check_ref_type","name":"$value","line":944},{"name":"$self","containerName":"_check_ref_type","kind":13,"line":945},{"name":"throw","containerName":"_check_ref_type","kind":12,"line":945},{"containerName":"_check_ref_type","kind":13,"name":"$value","line":948},{"name":"isa","containerName":"_check_ref_type","kind":12,"line":948},{"line":948,"name":"$expected_class","kind":13,"containerName":"_check_ref_type"},{"containerName":"_check_ref_type","kind":13,"name":"$self","line":949},{"kind":12,"containerName":"_check_ref_type","name":"throw","line":949},{"name":"$value","kind":13,"containerName":"_check_ref_type","line":949}],"name":"_check_ref_type","containerName":"main::","definition":"sub","detail":"($self,$value,$expected_class)"}],"version":5}