{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":106},{"children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":134,"definition":"my"},{"line":134,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":136,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":136},{"line":136,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":138,"kind":13,"localvar":"my","containerName":"new","name":"$number"},{"line":138,"kind":13,"containerName":"new","name":"$title"},{"name":"$symbol","containerName":"new","kind":13,"line":138},{"name":"$desc","kind":13,"containerName":"new","line":138},{"line":138,"name":"$ori","containerName":"new","kind":13},{"name":"$mut","kind":13,"containerName":"new","line":138},{"name":"$pos","containerName":"new","kind":13,"line":138},{"line":138,"kind":13,"containerName":"new","name":"$am"},{"line":139,"containerName":"new","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"new","line":139},{"name":"@args","containerName":"new","kind":13,"line":146},{"line":148,"containerName":"new","kind":13,"name":"$self"},{"line":148,"name":"init","containerName":"new","kind":12},{"line":150,"kind":13,"containerName":"new","name":"$number"},{"containerName":"new","kind":13,"name":"$self","line":150},{"name":"number","containerName":"new","kind":12,"line":150},{"line":150,"name":"$number","containerName":"new","kind":13},{"name":"$title","containerName":"new","kind":13,"line":151},{"name":"$self","containerName":"new","kind":13,"line":151},{"name":"title","containerName":"new","kind":12,"line":151},{"name":"$title","containerName":"new","kind":13,"line":151},{"name":"$symbol","containerName":"new","kind":13,"line":152},{"kind":13,"containerName":"new","name":"$self","line":152},{"name":"symbol","kind":12,"containerName":"new","line":152},{"name":"$symbol","containerName":"new","kind":13,"line":152},{"line":153,"containerName":"new","kind":13,"name":"$desc"},{"kind":13,"containerName":"new","name":"$self","line":153},{"kind":12,"containerName":"new","name":"description","line":153},{"line":153,"name":"$desc","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$ori","line":154},{"line":154,"name":"$self","containerName":"new","kind":13},{"line":154,"name":"aa_ori","kind":12,"containerName":"new"},{"name":"$ori","containerName":"new","kind":13,"line":154},{"line":155,"containerName":"new","kind":13,"name":"$mut"},{"containerName":"new","kind":13,"name":"$self","line":155},{"containerName":"new","kind":12,"name":"aa_mut","line":155},{"name":"$mut","containerName":"new","kind":13,"line":155},{"line":156,"name":"$pos","containerName":"new","kind":13},{"line":156,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"position","line":156},{"line":156,"name":"$pos","containerName":"new","kind":13},{"line":157,"name":"$am","kind":13,"containerName":"new"},{"line":157,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"additional_mutations","line":157},{"line":157,"name":"$am","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":159}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":132,"range":{"start":{"line":132,"character":0},"end":{"line":161,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":136,"kind":12,"containerName":"new","name":"SUPER"},{"signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :"},"range":{"start":{"character":0,"line":176},"end":{"character":9999,"line":188}},"kind":12,"line":176,"detail":"($self)","definition":"sub","name":"init","containerName":"main::","children":[{"line":177,"kind":13,"localvar":"my","containerName":"init","name":"$self","definition":"my"},{"name":"$self","containerName":"init","kind":13,"line":179},{"name":"number","containerName":"init","kind":12,"line":179},{"kind":13,"containerName":"init","name":"$self","line":180},{"name":"title","kind":12,"containerName":"init","line":180},{"line":181,"kind":13,"containerName":"init","name":"$self"},{"line":181,"containerName":"init","kind":12,"name":"symbol"},{"containerName":"init","kind":13,"name":"$self","line":182},{"name":"description","kind":12,"containerName":"init","line":182},{"line":183,"containerName":"init","kind":13,"name":"$self"},{"line":183,"name":"aa_ori","kind":12,"containerName":"init"},{"line":184,"name":"$self","kind":13,"containerName":"init"},{"line":184,"name":"aa_mut","kind":12,"containerName":"init"},{"name":"$self","containerName":"init","kind":13,"line":185},{"line":185,"name":"position","kind":12,"containerName":"init"},{"containerName":"init","kind":13,"name":"$self","line":186},{"name":"additional_mutations","kind":12,"containerName":"init","line":186}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).","label":"number($self,$value)"},"line":206,"range":{"start":{"line":206,"character":0},"end":{"line":215,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":207,"containerName":"number","localvar":"my","kind":13,"name":"$self"},{"line":207,"name":"$value","containerName":"number","kind":13},{"name":"$value","containerName":"number","kind":13,"line":209},{"line":210,"name":"$self","containerName":"number","kind":13},{"line":210,"name":"$value","containerName":"number","kind":13},{"name":"$self","kind":13,"containerName":"number","line":213}],"containerName":"main::","name":"number"},{"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"title","line":232,"definition":"my"},{"containerName":"title","kind":13,"name":"$value","line":232},{"name":"$value","kind":13,"containerName":"title","line":234},{"line":235,"containerName":"title","kind":13,"name":"$self"},{"kind":13,"containerName":"title","name":"$value","line":235},{"line":238,"name":"$self","containerName":"title","kind":13}],"containerName":"main::","name":"title","signature":{"label":"title($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional)."},"line":231,"kind":12,"range":{"start":{"character":0,"line":231},"end":{"character":9999,"line":240}}},{"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","containerName":"symbol","kind":13,"name":"$self","line":258,"definition":"my"},{"line":258,"name":"$value","containerName":"symbol","kind":13},{"line":260,"name":"$value","containerName":"symbol","kind":13},{"line":261,"containerName":"symbol","kind":13,"name":"$self"},{"line":261,"name":"$value","containerName":"symbol","kind":13},{"name":"$self","kind":13,"containerName":"symbol","line":264}],"name":"symbol","containerName":"main::","signature":{"label":"symbol($self,$value)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"line":257,"range":{"start":{"character":0,"line":257},"end":{"character":9999,"line":266}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":292},"start":{"line":283,"character":0}},"line":283,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).","label":"description($self,$value)"},"name":"description","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"description","kind":13,"line":284,"definition":"my"},{"line":284,"kind":13,"containerName":"description","name":"$value"},{"kind":13,"containerName":"description","name":"$value","line":286},{"name":"$self","containerName":"description","kind":13,"line":287},{"line":287,"kind":13,"containerName":"description","name":"$value"},{"line":290,"name":"$self","containerName":"description","kind":13}],"detail":"($self,$value)","definition":"sub"},{"range":{"start":{"character":0,"line":309},"end":{"character":9999,"line":318}},"kind":12,"line":309,"signature":{"label":"aa_ori($self,$value)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","name":"aa_ori","children":[{"definition":"my","line":310,"localvar":"my","containerName":"aa_ori","kind":13,"name":"$self"},{"name":"$value","kind":13,"containerName":"aa_ori","line":310},{"containerName":"aa_ori","kind":13,"name":"$value","line":312},{"line":313,"containerName":"aa_ori","kind":13,"name":"$self"},{"kind":13,"containerName":"aa_ori","name":"$value","line":313},{"line":316,"kind":13,"containerName":"aa_ori","name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"signature":{"label":"aa_mut($self,$value)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"line":335,"range":{"start":{"character":0,"line":335},"end":{"character":9999,"line":344}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"aa_mut","line":336},{"line":336,"name":"$value","kind":13,"containerName":"aa_mut"},{"line":338,"kind":13,"containerName":"aa_mut","name":"$value"},{"kind":13,"containerName":"aa_mut","name":"$self","line":339},{"line":339,"name":"$value","kind":13,"containerName":"aa_mut"},{"line":342,"kind":13,"containerName":"aa_mut","name":"$self"}],"name":"aa_mut","containerName":"main::"},{"children":[{"definition":"my","containerName":"position","localvar":"my","kind":13,"name":"$self","line":362},{"line":362,"containerName":"position","kind":13,"name":"$value"},{"line":364,"name":"$value","containerName":"position","kind":13},{"line":365,"containerName":"position","kind":13,"name":"$self"},{"line":365,"name":"$value","containerName":"position","kind":13},{"containerName":"position","kind":13,"name":"$self","line":368}],"name":"position","containerName":"main::","definition":"sub","detail":"($self,$value)","line":361,"range":{"start":{"line":361,"character":0},"end":{"line":370,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"position($self,$value)"}},{"signature":{"label":"additional_mutations($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).\n\n\nsub position {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_position\" } = $value;\n    }\n\n    return $self->{ \"_position\" };\n\n} # position\n\n\n\n\n=head2 additional_mutations\n\n Title   : additional_mutations\n Usage   : $av->additional_mutations( \"1-BP DEL, 911T\" );\n           or\n           print $av->additional_mutations();\n Function: Set/get for free form description of (additional) mutation(s).\n Returns : description of (additional) mutation(s).\n Args    : description of (additional) mutation(s) (optional)."},"kind":12,"range":{"start":{"line":387,"character":0},"end":{"line":396,"character":9999}},"line":387,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"additional_mutations","children":[{"name":"$self","containerName":"additional_mutations","localvar":"my","kind":13,"line":388,"definition":"my"},{"containerName":"additional_mutations","kind":13,"name":"$value","line":388},{"line":390,"kind":13,"containerName":"additional_mutations","name":"$value"},{"line":391,"containerName":"additional_mutations","kind":13,"name":"$self"},{"line":391,"name":"$value","kind":13,"containerName":"additional_mutations"},{"name":"$self","kind":13,"containerName":"additional_mutations","line":394}]},{"detail":"($self)","definition":"sub","name":"to_string","containerName":"main::","children":[{"definition":"my","line":411,"name":"$self","localvar":"my","kind":13,"containerName":"to_string"},{"localvar":"my","containerName":"to_string","kind":13,"name":"$s","line":413,"definition":"my"},{"name":"$s","containerName":"to_string","kind":13,"line":415},{"name":"$s","kind":13,"containerName":"to_string","line":416},{"kind":13,"containerName":"to_string","name":"$self","line":416},{"line":416,"name":"number","containerName":"to_string","kind":12},{"line":417,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"containerName":"to_string","name":"$s","line":418},{"kind":13,"containerName":"to_string","name":"$self","line":418},{"name":"title","kind":12,"containerName":"to_string","line":418},{"kind":13,"containerName":"to_string","name":"$s","line":419},{"line":420,"kind":13,"containerName":"to_string","name":"$s"},{"line":420,"containerName":"to_string","kind":13,"name":"$self"},{"line":420,"kind":12,"containerName":"to_string","name":"symbol"},{"containerName":"to_string","kind":13,"name":"$s","line":421},{"line":422,"kind":13,"containerName":"to_string","name":"$s"},{"line":422,"containerName":"to_string","kind":13,"name":"$self"},{"line":422,"name":"description","kind":12,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":423},{"kind":13,"containerName":"to_string","name":"$s","line":424},{"line":424,"name":"$self","kind":13,"containerName":"to_string"},{"line":424,"kind":12,"containerName":"to_string","name":"aa_ori"},{"name":"$s","kind":13,"containerName":"to_string","line":425},{"containerName":"to_string","kind":13,"name":"$s","line":426},{"name":"$self","containerName":"to_string","kind":13,"line":426},{"line":426,"name":"aa_mut","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$s","line":427},{"line":428,"name":"$s","kind":13,"containerName":"to_string"},{"line":428,"name":"$self","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":12,"name":"position","line":428},{"name":"$s","containerName":"to_string","kind":13,"line":429},{"line":430,"containerName":"to_string","kind":13,"name":"$s"},{"line":430,"containerName":"to_string","kind":13,"name":"$self"},{"line":430,"kind":12,"containerName":"to_string","name":"additional_mutations"},{"line":432,"kind":13,"containerName":"to_string","name":"$s"}],"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).\n\n\nsub position {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_position\" } = $value;\n    }\n\n    return $self->{ \"_position\" };\n\n} # position\n\n\n\n\n=head2 additional_mutations\n\n Title   : additional_mutations\n Usage   : $av->additional_mutations( \"1-BP DEL, 911T\" );\n           or\n           print $av->additional_mutations();\n Function: Set/get for free form description of (additional) mutation(s).\n Returns : description of (additional) mutation(s).\n Args    : description of (additional) mutation(s) (optional).\n\n\nsub additional_mutations {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_additional_mutations\" } = $value;\n    }\n\n    return $self->{ \"_additional_mutations\" };\n\n} # additional_mutations\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $av->to_string();\n Function: To string method for OMIMentryAllelicVariant objects.\n Returns : A string representations of this OMIMentryAllelicVariant.\n Args    :"},"range":{"start":{"character":0,"line":410},"end":{"character":9999,"line":434}},"kind":12,"line":410}]}