{"version":5,"vars":[{"line":94,"kind":2,"containerName":"","name":"base"},{"line":120,"range":{"end":{"line":159,"character":9999},"start":{"line":120,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","line":121,"name":"$self","localvar":"my","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":123},{"definition":"my","line":125,"name":"$eng","containerName":"_initialize","localvar":"my","kind":13},{"line":125,"name":"$eng_type","containerName":"_initialize","kind":13},{"line":125,"name":"$name","containerName":"_initialize","kind":13},{"line":126,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":126},{"line":131,"name":"$ip_h","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"name":"new","containerName":"_initialize","kind":12,"line":131},{"line":132,"name":"$name","kind":13,"containerName":"_initialize"},{"line":134,"name":"$eng","containerName":"_initialize","kind":13},{"line":135,"name":"$eng_type","kind":13,"containerName":"_initialize"},{"name":"$eng_type","kind":13,"containerName":"_initialize","line":135},{"name":"$eng_type","containerName":"_initialize","kind":13,"line":136},{"kind":13,"containerName":"_initialize","name":"$eng","line":137},{"line":137,"name":"new","containerName":"_initialize","kind":12},{"line":139,"name":"$self","kind":13,"containerName":"_initialize"},{"line":139,"containerName":"_initialize","kind":12,"name":"throw"},{"line":143,"name":"$eng","kind":13,"containerName":"_initialize"},{"name":"isa","containerName":"_initialize","kind":12,"line":143},{"name":"$ip_h","containerName":"_initialize","kind":13,"line":144},{"name":"ontology","containerName":"_initialize","kind":12,"line":144},{"name":"$eng","containerName":"_initialize","kind":13,"line":144},{"name":"$eng","containerName":"_initialize","kind":13,"line":145},{"name":"$eng","kind":13,"containerName":"_initialize","line":145},{"containerName":"_initialize","kind":12,"name":"engine","line":145},{"line":145,"kind":13,"containerName":"_initialize","name":"$eng"},{"line":145,"name":"can","kind":12,"containerName":"_initialize"},{"name":"$self","kind":13,"containerName":"_initialize","line":147},{"line":147,"name":"$eng","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$ip_h","line":148},{"line":148,"kind":12,"containerName":"_initialize","name":"ontology_engine"},{"line":148,"containerName":"_initialize","kind":13,"name":"$eng"},{"containerName":"_initialize","kind":13,"name":"$self","line":150},{"line":150,"name":"new","kind":12,"containerName":"_initialize"},{"line":150,"name":"$ip_h","kind":13,"containerName":"_initialize"},{"line":151,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"$ip_h","containerName":"_initialize","kind":13,"line":151},{"line":154,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"term_factory","line":154},{"line":154,"kind":12,"containerName":"_initialize","name":"new"},{"kind":13,"containerName":"_initialize","name":"$self","line":156},{"line":156,"name":"term_factory","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$ip_h","line":157},{"line":157,"name":"term_factory","containerName":"_initialize","kind":12},{"kind":13,"containerName":"_initialize","name":"$self","line":157},{"line":157,"containerName":"_initialize","kind":12,"name":"term_factory"}],"containerName":"main::","name":"_initialize"},{"name":"SUPER","containerName":"_initialize","kind":12,"line":123},{"line":131,"containerName":"OntologyIO::Handlers::InterProHandler","kind":12,"name":"Bio"},{"containerName":"Ontology::SimpleOntologyEngine","kind":12,"name":"Bio","line":137},{"line":147,"name":"_ontology_engine","kind":12},{"line":150,"name":"_parser","kind":12},{"name":"XML","kind":12,"containerName":"Parser::PerlSAX","line":150},{"line":150,"name":"Handler","kind":12},{"kind":12,"name":"_interpro_handler","line":151},{"kind":12,"containerName":"Ontology::TermFactory","name":"Bio","line":154},{"range":{"end":{"line":189,"character":9999},"start":{"line":172,"character":0}},"kind":12,"line":172,"definition":"sub","containerName":"main::","name":"parse","children":[{"definition":"my","line":173,"kind":13,"localvar":"my","containerName":"parse","name":"$self"},{"definition":"my","line":175,"localvar":"my","kind":13,"containerName":"parse","name":"$ret"},{"containerName":"parse","kind":13,"name":"$self","line":176},{"name":"file","containerName":"parse","kind":12,"line":176},{"name":"$ret","kind":13,"containerName":"parse","line":177},{"name":"$self","containerName":"parse","kind":13,"line":177},{"line":177,"name":"parse","containerName":"parse","kind":12},{"line":178,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","kind":12,"name":"file","line":178},{"line":179,"name":"$self","containerName":"parse","kind":13},{"line":179,"containerName":"parse","kind":12,"name":"_fh"},{"kind":13,"containerName":"parse","name":"$ret","line":180},{"containerName":"parse","kind":13,"name":"$self","line":180},{"name":"parse","kind":12,"containerName":"parse","line":180},{"line":181,"name":"$self","containerName":"parse","kind":13},{"name":"_fh","containerName":"parse","kind":12,"line":181},{"name":"$ret","kind":13,"containerName":"parse","line":183},{"line":184,"containerName":"parse","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"parse","line":184},{"line":187,"kind":13,"containerName":"parse","name":"$self"},{"name":"_is_parsed","containerName":"parse","kind":12,"line":187},{"line":188,"kind":13,"containerName":"parse","name":"$ret"}]},{"line":177,"kind":12,"name":"_parser"},{"line":177,"kind":12,"name":"Source"},{"kind":12,"name":"SystemId","line":178},{"line":180,"name":"_parser","kind":12},{"name":"Source","kind":12,"line":180},{"line":181,"name":"ByteStream","kind":12},{"children":[{"definition":"my","line":211,"localvar":"my","kind":13,"containerName":"next_ontology","name":"$self"},{"line":213,"containerName":"next_ontology","kind":13,"name":"$self"},{"line":213,"kind":12,"containerName":"next_ontology","name":"parse"},{"line":213,"containerName":"next_ontology","kind":13,"name":"$self"},{"line":213,"name":"_is_parsed","kind":12,"containerName":"next_ontology"},{"containerName":"next_ontology","kind":13,"name":"$self","line":215},{"localvar":"my","kind":13,"containerName":"next_ontology","name":"$ont","line":216,"definition":"my"},{"line":216,"name":"$self","kind":13,"containerName":"next_ontology"},{"line":216,"name":"ontology","containerName":"next_ontology","kind":12},{"line":217,"containerName":"next_ontology","kind":13,"name":"$self"},{"line":218,"kind":13,"containerName":"next_ontology","name":"$ont"}],"containerName":"main::","name":"next_ontology","definition":"sub","line":210,"kind":12,"range":{"end":{"character":9999,"line":221},"start":{"line":210,"character":0}}},{"kind":12,"name":"_interpro_handler","line":216},{"line":217,"name":"_ontology_engine","kind":12},{"definition":"sub","children":[{"line":235,"name":"$self","localvar":"my","containerName":"_is_parsed","kind":13,"definition":"my"},{"kind":13,"containerName":"_is_parsed","name":"$self","line":237},{"line":238,"name":"$self","kind":13,"containerName":"_is_parsed"}],"name":"_is_parsed","containerName":"main::","line":234,"kind":12,"range":{"end":{"character":9999,"line":239},"start":{"line":234,"character":0}}},{"signature":{"label":"secondary_accessions_map($self)","documentation":"1;\n# $Id: InterProParser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProParser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::InterProParser - Parser for InterPro xml files.\n\n=head1 SYNOPSIS\n\n    # don't use this module directly - use Bio::OntologyIO with instead\n    my $ipp = Bio::OntologyIO->new( -format  => 'interpro',\n                                    -file    => 't/data/interpro.xml',\n                                    -ontology_engine => 'simple' );\n\n=head1 DESCRIPTION\n\n  Use InterProParser to parse InterPro files in xml format. Typical\n  use is the interpro.xml file published by EBI. The xml records\n  should follow the format described in interpro.dtd, although the dtd\n  file is not needed, and the XML file will not be validated against it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::InterProParser;\nuse strict;\n#use Carp;\nuse XML::Parser::PerlSAX;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Ontology::TermFactory;\nuse Bio::OntologyIO::Handlers::InterProHandler;\n\nuse base qw(Bio::OntologyIO);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Initializes objects needed for parsing.\n Example : $ipp = Bio::OntologyIO::InterProParser->new( \n                                  -file => 't/data/interpro.xml',\n\t\t\t\t  -ontology_engine => 'simple' )\n\n Returns : Object of class Bio::OntologyIO::InterProParser.\n Args    :\n\n  -file            - file name\n  -ontology_engine - type of ontology engine. Should satisfy the\n                     OntologyEngine interface requirements. Currently\n                     the only option is 'simple'. In the future\n                     Graph.pm based engine will be added to the\n                     choices.\n\n\n\n# in reality we let OntologyIO handle the first pass initialization\n# and instead override _initialize().\nsub _initialize{\n    my $self = shift;\n\n    $self->SUPER::_initialize(@_);\n\n    my ($eng,$eng_type,$name) =\n\t$self->_rearrange([qw(ENGINE\n\t\t\t      ONTOLOGY_ENGINE\n\t\t\t      ONTOLOGY_NAME)\n\t\t\t   ], @_);\n\n    my $ip_h = Bio::OntologyIO::Handlers::InterProHandler->new(\n\t\t\t                             -ontology_name => $name);\n\n    if(! $eng) {\n\t$eng_type = 'simple' unless $eng_type;\n\tif(lc($eng_type) eq 'simple') {\n\t    $eng = Bio::Ontology::SimpleOntologyEngine->new();\n\t} else {\n\t    $self->throw(\"ontology engine type '$eng_type' \".\n\t\t\t \"not implemented yet\");\n\t}\n    }\n    if($eng->isa(\"Bio::Ontology::OntologyI\")) {\n\t$ip_h->ontology($eng);\n\t$eng = $eng->engine() if $eng->can('engine');\n    }\n    $self->{_ontology_engine} = $eng;\n    $ip_h->ontology_engine($eng);\n\n    $self->{_parser} = XML::Parser::PerlSAX->new( Handler => $ip_h );\n    $self->{_interpro_handler} = $ip_h;\n\n    # default term object factory\n    $self->term_factory(Bio::Ontology::TermFactory->new(\n\t\t\t\t   -type => \"Bio::Ontology::InterProTerm\"))\n\tunless $self->term_factory();\n    $ip_h->term_factory($self->term_factory());\n\n}\n\n=head2 parse\n\n Title   : parse\n Usage   :\n Function: Performs the actual parsing.\n Example : $ipp->parse();\n Returns : \n Args    :\n\n\nsub parse{\n   my $self = shift;\n\n   my $ret;\n   if ($self->file()) {\n         $ret = $self->{_parser}->parse( Source => {\n\t                SystemId => $self->file() } );\n   } elsif ($self->_fh()) {\n        $ret = $self->{_parser}->parse( Source => {\n                ByteStream => $self->_fh() } );\n   } else {\n        $ret = undef;\n        $self->throw(\"Only filenames and filehandles are understood here.\\n\");\n   }\n\n   $self->_is_parsed(1);\n   return $ret;\n}\n\n=head2 next_ontology\n\n Title   : next_ontology\n Usage   : $ipp->next_ontology()\n Function: Parses the input file and returns the next InterPro ontology\n           available.\n\n           Usually there will be only one ontology returned from an\n           InterPro XML input.\n\n Example : $ipp->next_ontology();\n Returns : Returns the ontology as a Bio::Ontology::OntologyEngineI\n           compliant object.\n Args    : \n\nSee L<Bio::Ontology::OntologyEngineI>.\n\n\nsub next_ontology{\n  my $self = shift;\n\n  $self->parse() unless $self->_is_parsed();\n  # there is only one ontology in an InterPro source file\n  if(exists($self->{'_ontology_engine'})) {\n      my $ont = $self->{_interpro_handler}->ontology();\n      delete $self->{_ontology_engine};\n      return $ont;\n  }\n  return;\n}\n\n=head2 _is_parsed\n\n Title   : _is_parsed\n Usage   : $obj->_is_parsed($newval)\n Function: \n Example : \n Returns : value of _is_parsed (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub _is_parsed{\n    my $self = shift;\n\n    return $self->{'_is_parsed'} = shift if @_;\n    return $self->{'_is_parsed'};\n}\n\n=head2 secondary_accessions_map\n\n Title   : secondary_accessions_map\n Usage   : $obj->secondary_accessions_map()\n Function: This method is merely for convenience, and one should\n           normally use the InterProTerm secondary_ids method to\n           access the secondary accessions.\n Example : $map = $interpro_parser->secondary_accessions_map;\n Returns : Reference to a hash that maps InterPro identifier to an\n           array reference of secondary accessions following the \n           InterPro xml schema.\n Args    : Empty hash reference","parameters":[{"label":"$self"}]},"line":256,"range":{"start":{"character":0,"line":256},"end":{"line":260,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"secondary_accessions_map","line":257,"definition":"my"},{"line":259,"kind":13,"containerName":"secondary_accessions_map","name":"$self"}],"containerName":"main::","name":"secondary_accessions_map"},{"name":"_interpro_handler","kind":12,"line":259},{"line":259,"name":"secondary_accessions_map","kind":12}]}