{"version":5,"vars":[{"definition":1,"containerName":"main::","kind":14,"name":"TRUE","line":81},{"containerName":"","kind":12,"name":"strict","line":81},{"containerName":"main::","kind":14,"name":"FALSE","line":82,"definition":1},{"line":84,"kind":2,"containerName":"","name":"base"},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"name":"$class","containerName":"new","localvar":"my","kind":13,"line":112,"definition":"my"},{"line":112,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":113,"definition":"my"},{"line":113,"name":"$class","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":113},{"name":"$self","containerName":"new","kind":13,"line":114}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: OBOterm.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Ontology::OBOterm - representation of OBO terms\n\n=head1 SYNOPSIS\n\n  $term = Bio::Ontology::OBOterm->new\n    ( -identifier       => \"GO:0005623\",\n      -name        => \"Cell\",\n      -definition  => \"The basic structural and functional unit ...\",\n      -is_obsolete => 0,\n      -comment     => \"\" );\n\n  $term->add_reference( @refs );\n  $term->add_secondary_id( @ids );\n  $term->add_synonym( @synonym );\n\n  # etc.\n\n=head1 DESCRIPTION\n\nThis is data holder class for OBO terms. It is currently a dummy class since we anticipate that the\nOBO term will become more richer with more features being added to OBO flat-file format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n# Let the code begin...\n\npackage Bio::Ontology::OBOterm;\nuse strict;\n\nuse constant TRUE  => 1;\nuse constant FALSE => 0;\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   :   $term = Bio::Ontology::OBOterm->new\n     ( -identifier       => \"GO:0005623\",\n      -name        => \"Cell\",\n      -definition  => \"The basic structural and functional unit ...\",\n      -is_obsolete => 0,\n      -comment     => \"\" );\n\n Function: Creates a new Bio::Ontology::OBOterm.\n Returns : A new Bio::Ontology::OBOterm object.\n Args    : -identifier    => the id of this OBO term [GO:nnnnnnn]\n                             integer of seven digits)\n           -name          => the name of this OBO term [scalar]\n           -definition    => the definition of this OBO term [scalar]\n           -ontology      => the ontology for this term (a\n                             Bio::Ontology::OntologyI compliant object)\n           -version       => version information [scalar]\n           -is_obsolete   => the obsoleteness of this OBO term [0 or 1]\n           -comment       => a comment [scalar]"},"kind":12,"range":{"start":{"character":0,"line":110},"end":{"character":9999,"line":115}},"line":110},{"containerName":"new","kind":12,"name":"SUPER","line":113}]}