{"version":5,"vars":[{"definition":1,"line":95,"containerName":"main::","kind":14,"name":"INTERPRO_ID_DEFAULT"},{"containerName":"Bio::Annotation::Reference","kind":12,"name":"strict","line":95},{"kind":2,"containerName":"","name":"base","line":97},{"name":"new","containerName":"main::","children":[{"definition":"my","line":121,"name":"$class","containerName":"new","localvar":"my","kind":13},{"name":"@args","containerName":"new","kind":13,"line":121},{"line":122,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":122},{"name":"@args","kind":13,"containerName":"new","line":122},{"line":124,"name":"$interpro_id","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":125,"name":"$short_name","containerName":"new","kind":13},{"line":126,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","kind":12,"containerName":"new","line":126},{"containerName":"new","kind":13,"name":"@args","line":129},{"name":"$interpro_id","kind":13,"containerName":"new","line":131},{"name":"$self","kind":13,"containerName":"new","line":131},{"name":"interpro_id","kind":12,"containerName":"new","line":131},{"line":131,"name":"$interpro_id","containerName":"new","kind":13},{"line":132,"name":"$short_name","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":132},{"line":132,"name":"short_name","containerName":"new","kind":12},{"name":"$short_name","kind":13,"containerName":"new","line":132},{"line":134,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":135},"start":{"character":0,"line":120}},"line":120,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":122,"name":"SUPER","kind":12,"containerName":"new"},{"range":{"end":{"line":159,"character":9999},"start":{"character":0,"line":149}},"kind":12,"line":149,"name":"init","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"init","line":150,"definition":"my"},{"line":153,"name":"$self","kind":13,"containerName":"init"},{"line":156,"containerName":"init","kind":13,"name":"$self"},{"line":156,"name":"interpro_id","kind":12,"containerName":"init"},{"kind":13,"containerName":"init","name":"$self","line":157},{"containerName":"init","kind":12,"name":"short_name","line":157}],"definition":"sub"},{"line":153,"kind":12,"containerName":"init","name":"SUPER"},{"line":156,"kind":12,"name":"INTERPRO_ID_DEFAULT"},{"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","containerName":"_check_interpro_id","kind":13,"name":"$self","line":174,"definition":"my"},{"line":174,"name":"$value","kind":13,"containerName":"_check_interpro_id"},{"line":176,"name":"$self","containerName":"_check_interpro_id","kind":13},{"containerName":"_check_interpro_id","kind":12,"name":"throw","line":176},{"name":"$value","containerName":"_check_interpro_id","kind":13,"line":176},{"line":177,"name":"$value","kind":13,"containerName":"_check_interpro_id"},{"line":178,"name":"$value","kind":13,"containerName":"_check_interpro_id"},{"kind":13,"containerName":"_check_interpro_id","name":"$value","line":180}],"containerName":"main::","name":"_check_interpro_id","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String","label":"_check_interpro_id($self,$value)"},"line":173,"kind":12,"range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":181}}},{"line":178,"name":"INTERPRO_ID_DEFAULT","kind":12},{"signature":{"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"interpro_id($self,$value)"},"range":{"start":{"line":195,"character":0},"end":{"character":9999,"line":204}},"kind":12,"line":195,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"interpro_id","children":[{"definition":"my","line":196,"name":"$self","containerName":"interpro_id","localvar":"my","kind":13},{"line":196,"kind":13,"containerName":"interpro_id","name":"$value"},{"containerName":"interpro_id","kind":13,"name":"$value","line":198},{"line":199,"name":"$value","kind":13,"containerName":"interpro_id"},{"name":"$self","kind":13,"containerName":"interpro_id","line":199},{"line":199,"name":"_check_interpro_id","containerName":"interpro_id","kind":12},{"kind":13,"containerName":"interpro_id","name":"$value","line":199},{"line":200,"name":"$self","kind":13,"containerName":"interpro_id"},{"line":200,"containerName":"interpro_id","kind":12,"name":"identifier"},{"name":"$value","containerName":"interpro_id","kind":13,"line":200},{"name":"$self","containerName":"interpro_id","kind":13,"line":203},{"name":"identifier","containerName":"interpro_id","kind":12,"line":203}]},{"kind":12,"range":{"end":{"character":9999,"line":226},"start":{"line":218,"character":0}},"line":218,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)","label":"short_name($self,$value)"},"name":"short_name","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"short_name","line":219,"definition":"my"},{"containerName":"short_name","kind":13,"name":"$value","line":219},{"name":"$value","kind":13,"containerName":"short_name","line":221},{"line":222,"kind":13,"containerName":"short_name","name":"$self"},{"kind":13,"containerName":"short_name","name":"$value","line":222},{"name":"$value","kind":13,"containerName":"short_name","line":222},{"line":225,"name":"$self","containerName":"short_name","kind":13}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"range":{"end":{"line":248,"character":9999},"start":{"line":240,"character":0}},"line":240,"signature":{"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"protein_count($self,$value)"},"name":"protein_count","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"protein_count","kind":13,"name":"$self","line":241},{"containerName":"protein_count","kind":13,"name":"$value","line":241},{"line":243,"name":"$value","containerName":"protein_count","kind":13},{"line":244,"containerName":"protein_count","kind":13,"name":"$self"},{"name":"$value","containerName":"protein_count","kind":13,"line":244},{"line":244,"containerName":"protein_count","kind":13,"name":"$value"},{"kind":13,"containerName":"protein_count","name":"$self","line":247}],"detail":"($self,$value)","definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":263,"name":"$self","containerName":"get_references","localvar":"my","kind":13},{"kind":13,"containerName":"get_references","name":"$self","line":265}],"containerName":"main::","name":"get_references","line":262,"range":{"end":{"line":265,"character":9999},"start":{"character":0,"line":262}},"kind":12},{"line":265,"name":"%self","kind":13,"containerName":null},{"kind":12,"range":{"end":{"line":285,"character":9999},"start":{"character":0,"line":281}},"line":281,"definition":"sub","name":"add_reference","containerName":"main::","children":[{"definition":"my","line":282,"kind":13,"localvar":"my","containerName":"add_reference","name":"$self"},{"line":284,"containerName":"add_reference","kind":13,"name":"$self"},{"line":284,"name":"$self","containerName":"add_reference","kind":13},{"line":285,"containerName":"add_reference","kind":13,"name":"$self"}]},{"definition":"sub","containerName":"main::","name":"remove_references","children":[{"definition":"my","line":302,"containerName":"remove_references","localvar":"my","kind":13,"name":"$self"},{"name":"@arr","localvar":"my","kind":13,"containerName":"remove_references","line":304,"definition":"my"},{"line":304,"name":"$self","containerName":"remove_references","kind":13},{"containerName":"remove_references","kind":12,"name":"get_references","line":304},{"name":"$self","kind":13,"containerName":"remove_references","line":305},{"line":306,"name":"@arr","containerName":"remove_references","kind":13}],"kind":12,"range":{"start":{"character":0,"line":301},"end":{"character":9999,"line":307}},"line":301},{"children":[{"definition":"my","line":322,"name":"$self","containerName":"get_members","localvar":"my","kind":13},{"line":324,"name":"$self","kind":13,"containerName":"get_members"}],"containerName":"main::","name":"get_members","definition":"sub","line":321,"range":{"end":{"line":324,"character":9999},"start":{"line":321,"character":0}},"kind":12},{"line":324,"name":"%self","containerName":null,"kind":13},{"containerName":"main::","name":"add_member","children":[{"kind":13,"localvar":"my","containerName":"add_member","name":"$self","line":341,"definition":"my"},{"containerName":"add_member","kind":13,"name":"$self","line":343},{"name":"$self","kind":13,"containerName":"add_member","line":343},{"containerName":"add_member","kind":13,"name":"$self","line":344}],"definition":"sub","range":{"start":{"character":0,"line":340},"end":{"character":9999,"line":344}},"kind":12,"line":340},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"remove_members","line":361,"definition":"my"},{"definition":"my","name":"@arr","localvar":"my","containerName":"remove_members","kind":13,"line":363},{"containerName":"remove_members","kind":13,"name":"$self","line":363},{"kind":12,"containerName":"remove_members","name":"get_members","line":363},{"line":364,"kind":13,"containerName":"remove_members","name":"$self"},{"line":365,"kind":13,"containerName":"remove_members","name":"@arr"}],"containerName":"main::","name":"remove_members","line":360,"range":{"end":{"character":9999,"line":366},"start":{"character":0,"line":360}},"kind":12},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_examples","name":"$self","line":384},{"line":386,"name":"$self","containerName":"get_examples","kind":13}],"containerName":"main::","name":"get_examples","definition":"sub","line":383,"kind":12,"range":{"end":{"character":9999,"line":386},"start":{"character":0,"line":383}}},{"kind":13,"containerName":null,"name":"%self","line":386},{"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"add_example","name":"$self","line":406},{"line":408,"containerName":"add_example","kind":13,"name":"$self"},{"line":408,"name":"$self","containerName":"add_example","kind":13},{"line":409,"name":"$self","kind":13,"containerName":"add_example"}],"name":"add_example","containerName":"main::","line":405,"kind":12,"range":{"start":{"character":0,"line":405},"end":{"line":409,"character":9999}}},{"line":428,"range":{"end":{"line":434,"character":9999},"start":{"character":0,"line":428}},"kind":12,"children":[{"definition":"my","containerName":"remove_examples","localvar":"my","kind":13,"name":"$self","line":429},{"name":"@arr","localvar":"my","kind":13,"containerName":"remove_examples","line":431,"definition":"my"},{"containerName":"remove_examples","kind":13,"name":"$self","line":431},{"line":431,"kind":12,"containerName":"remove_examples","name":"get_examples"},{"containerName":"remove_examples","kind":13,"name":"$self","line":432},{"kind":13,"containerName":"remove_examples","name":"@arr","line":433}],"containerName":"main::","name":"remove_examples","definition":"sub"},{"line":451,"range":{"end":{"character":9999,"line":454},"start":{"line":451,"character":0}},"kind":12,"definition":"sub","children":[{"line":452,"name":"$self","localvar":"my","kind":13,"containerName":"get_external_documents","definition":"my"},{"name":"$self","kind":13,"containerName":"get_external_documents","line":454}],"name":"get_external_documents","containerName":"main::"},{"line":454,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"range":{"end":{"character":9999,"line":477},"start":{"line":473,"character":0}},"line":473,"name":"add_external_document","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"add_external_document","name":"$self","line":474,"definition":"my"},{"containerName":"add_external_document","kind":13,"name":"$self","line":476},{"line":476,"name":"$self","containerName":"add_external_document","kind":13},{"kind":13,"containerName":"add_external_document","name":"$self","line":477}],"definition":"sub"},{"children":[{"name":"$self","localvar":"my","containerName":"remove_external_documents","kind":13,"line":497,"definition":"my"},{"definition":"my","line":499,"kind":13,"localvar":"my","containerName":"remove_external_documents","name":"@arr"},{"containerName":"remove_external_documents","kind":13,"name":"$self","line":499},{"containerName":"remove_external_documents","kind":12,"name":"get_external_documents","line":499},{"containerName":"remove_external_documents","kind":13,"name":"$self","line":500},{"line":501,"name":"@arr","containerName":"remove_external_documents","kind":13}],"containerName":"main::","name":"remove_external_documents","definition":"sub","line":496,"range":{"end":{"character":9999,"line":502},"start":{"line":496,"character":0}},"kind":12},{"signature":{"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub protein_count{\n  my ($self,$value) = @_;\n\n  if( defined $value) {\n    $self->{'protein_count'} = $value ? $value : undef;\n  }\n\n  return $self->{'protein_count'};\n}\n\n=head2 get_references\n\n Title   : get_references\n Usage   :\n Function: Get the references for this InterPro term.\n Example :\n Returns : An array of L<Bio::Annotation::Reference> objects\n Args    :\n\n\n\nsub get_references{\n    my $self = shift;\n\n    return @{$self->{\"_references\"}} if exists($self->{\"_references\"});\n    return ();\n}\n\n=head2 add_reference\n\n Title   : add_reference\n Usage   :\n Function: Add one or more references to this InterPro term.\n Example :\n Returns : \n Args    : One or more L<Bio::Annotation::Reference> objects.\n\n\n\nsub add_reference{\n    my $self = shift;\n\n    $self->{\"_references\"} = [] unless exists($self->{\"_references\"});\n    push(@{$self->{\"_references\"}}, @_);\n}\n\n=head2 remove_references\n\n Title   : remove_references\n Usage   :\n Function: Remove all references for this InterPro term.\n Example :\n Returns : The list of previous references as an array of\n           L<Bio::Annotation::Reference> objects.\n Args    :\n\n\n\nsub remove_references{\n    my $self = shift;\n\n    my @arr = $self->get_references();\n    $self->{\"_references\"} = [];\n    return @arr;\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : @arr = get_members()\n Function: Get the list of member(s) for this object.\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_members{\n    my $self = shift;\n\n    return @{$self->{'_members'}} if exists($self->{'_members'});\n    return ();\n}\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Add one or more member(s) to this object.\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_member{\n    my $self = shift;\n\n    $self->{'_members'} = [] unless exists($self->{'_members'});\n    push(@{$self->{'_members'}}, @_);\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove all members for this class.\n Example :\n Returns : The list of previous members as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @arr = $self->get_members();\n    $self->{'_members'} = [];\n    return @arr;\n}\n\n=head2 get_examples\n\n Title   : get_examples\n Usage   : @arr = get_examples()\n Function: Get the list of example(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_examples{\n    my $self = shift;\n\n    return @{$self->{'_examples'}} if exists($self->{'_examples'});\n    return ();\n}\n\n=head2 add_example\n\n Title   : add_example\n Usage   :\n Function: Add one or more example(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_example{\n    my $self = shift;\n\n    $self->{'_examples'} = [] unless exists($self->{'_examples'});\n    push(@{$self->{'_examples'}}, @_);\n}\n\n=head2 remove_examples\n\n Title   : remove_examples\n Usage   :\n Function: Remove all examples for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous examples as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_examples{\n    my $self = shift;\n\n    my @arr = $self->get_examples();\n    $self->{'_examples'} = [];\n    return @arr;\n}\n\n=head2 get_external_documents\n\n Title   : get_external_documents\n Usage   : @arr = get_external_documents()\n Function: Get the list of external_document(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_external_documents{\n    my $self = shift;\n\n    return @{$self->{'_external_documents'}} if exists($self->{'_external_documents'});\n    return ();\n}\n\n=head2 add_external_document\n\n Title   : add_external_document\n Usage   :\n Function: Add one or more external_document(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_external_document{\n    my $self = shift;\n\n    $self->{'_external_documents'} = [] unless exists($self->{'_external_documents'});\n    push(@{$self->{'_external_documents'}}, @_);\n}\n\n=head2 remove_external_documents\n\n Title   : remove_external_documents\n Usage   :\n Function: Remove all external_documents for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous external_documents as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_external_documents{\n    my $self = shift;\n\n    my @arr = $self->get_external_documents();\n    $self->{'_external_documents'} = [];\n    return @arr;\n}\n\n=head2 class_list\n\n Title   : class_list\n Usage   : $obj->class_list($newval)\n Function: Set/get for class list element of the InterPro xml schema\n Example : \n Returns : reference to an array of Bio::Annotation::DBLink objects\n Args    : reference to an array of Bio::Annotation::DBLink objects","parameters":[{"label":"$self"},{"label":"$value"}],"label":"class_list($self,$value)"},"kind":12,"range":{"end":{"line":524,"character":9999},"start":{"line":516,"character":0}},"line":516,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"class_list","children":[{"line":517,"kind":13,"localvar":"my","containerName":"class_list","name":"$self","definition":"my"},{"containerName":"class_list","kind":13,"name":"$value","line":517},{"kind":13,"containerName":"class_list","name":"$value","line":519},{"line":520,"name":"$self","containerName":"class_list","kind":13},{"line":520,"containerName":"class_list","kind":13,"name":"$value"},{"kind":13,"containerName":"class_list","name":"$self","line":523}]},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub protein_count{\n  my ($self,$value) = @_;\n\n  if( defined $value) {\n    $self->{'protein_count'} = $value ? $value : undef;\n  }\n\n  return $self->{'protein_count'};\n}\n\n=head2 get_references\n\n Title   : get_references\n Usage   :\n Function: Get the references for this InterPro term.\n Example :\n Returns : An array of L<Bio::Annotation::Reference> objects\n Args    :\n\n\n\nsub get_references{\n    my $self = shift;\n\n    return @{$self->{\"_references\"}} if exists($self->{\"_references\"});\n    return ();\n}\n\n=head2 add_reference\n\n Title   : add_reference\n Usage   :\n Function: Add one or more references to this InterPro term.\n Example :\n Returns : \n Args    : One or more L<Bio::Annotation::Reference> objects.\n\n\n\nsub add_reference{\n    my $self = shift;\n\n    $self->{\"_references\"} = [] unless exists($self->{\"_references\"});\n    push(@{$self->{\"_references\"}}, @_);\n}\n\n=head2 remove_references\n\n Title   : remove_references\n Usage   :\n Function: Remove all references for this InterPro term.\n Example :\n Returns : The list of previous references as an array of\n           L<Bio::Annotation::Reference> objects.\n Args    :\n\n\n\nsub remove_references{\n    my $self = shift;\n\n    my @arr = $self->get_references();\n    $self->{\"_references\"} = [];\n    return @arr;\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : @arr = get_members()\n Function: Get the list of member(s) for this object.\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_members{\n    my $self = shift;\n\n    return @{$self->{'_members'}} if exists($self->{'_members'});\n    return ();\n}\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Add one or more member(s) to this object.\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_member{\n    my $self = shift;\n\n    $self->{'_members'} = [] unless exists($self->{'_members'});\n    push(@{$self->{'_members'}}, @_);\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove all members for this class.\n Example :\n Returns : The list of previous members as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @arr = $self->get_members();\n    $self->{'_members'} = [];\n    return @arr;\n}\n\n=head2 get_examples\n\n Title   : get_examples\n Usage   : @arr = get_examples()\n Function: Get the list of example(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_examples{\n    my $self = shift;\n\n    return @{$self->{'_examples'}} if exists($self->{'_examples'});\n    return ();\n}\n\n=head2 add_example\n\n Title   : add_example\n Usage   :\n Function: Add one or more example(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_example{\n    my $self = shift;\n\n    $self->{'_examples'} = [] unless exists($self->{'_examples'});\n    push(@{$self->{'_examples'}}, @_);\n}\n\n=head2 remove_examples\n\n Title   : remove_examples\n Usage   :\n Function: Remove all examples for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous examples as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_examples{\n    my $self = shift;\n\n    my @arr = $self->get_examples();\n    $self->{'_examples'} = [];\n    return @arr;\n}\n\n=head2 get_external_documents\n\n Title   : get_external_documents\n Usage   : @arr = get_external_documents()\n Function: Get the list of external_document(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_external_documents{\n    my $self = shift;\n\n    return @{$self->{'_external_documents'}} if exists($self->{'_external_documents'});\n    return ();\n}\n\n=head2 add_external_document\n\n Title   : add_external_document\n Usage   :\n Function: Add one or more external_document(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_external_document{\n    my $self = shift;\n\n    $self->{'_external_documents'} = [] unless exists($self->{'_external_documents'});\n    push(@{$self->{'_external_documents'}}, @_);\n}\n\n=head2 remove_external_documents\n\n Title   : remove_external_documents\n Usage   :\n Function: Remove all external_documents for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous external_documents as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_external_documents{\n    my $self = shift;\n\n    my @arr = $self->get_external_documents();\n    $self->{'_external_documents'} = [];\n    return @arr;\n}\n\n=head2 class_list\n\n Title   : class_list\n Usage   : $obj->class_list($newval)\n Function: Set/get for class list element of the InterPro xml schema\n Example : \n Returns : reference to an array of Bio::Annotation::DBLink objects\n Args    : reference to an array of Bio::Annotation::DBLink objects\n\n\n\nsub class_list{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'class_list'} = $value;\n  }\n\n  return $self->{'class_list'};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $term->to_string();\n Function: to_string method for InterPro terms.\n Returns : A string representation of this InterPro term.\n Args    :","label":"to_string($self)"},"kind":12,"range":{"start":{"character":0,"line":536},"end":{"line":601,"character":9999}},"line":536,"detail":"($self)","definition":"sub","containerName":"main::","name":"to_string","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"to_string","name":"$self","line":537},{"definition":"my","line":538,"name":"$s","kind":13,"localvar":"my","containerName":"to_string"},{"line":540,"name":"$s","containerName":"to_string","kind":13},{"name":"$s","kind":13,"containerName":"to_string","line":541},{"kind":13,"containerName":"to_string","name":"$self","line":541},{"line":541,"containerName":"to_string","kind":12,"name":"interpro_id"},{"line":542,"kind":13,"containerName":"to_string","name":"$self"},{"line":542,"kind":12,"containerName":"to_string","name":"name"},{"name":"$s","kind":13,"containerName":"to_string","line":543},{"containerName":"to_string","kind":13,"name":"$s","line":544},{"containerName":"to_string","kind":13,"name":"$self","line":544},{"containerName":"to_string","kind":12,"name":"name","line":544},{"line":545,"name":"$s","kind":13,"containerName":"to_string"},{"line":546,"containerName":"to_string","kind":13,"name":"$s"},{"kind":13,"containerName":"to_string","name":"$self","line":546},{"kind":12,"containerName":"to_string","name":"definition","line":546},{"name":"$s","kind":13,"containerName":"to_string","line":547},{"name":"$self","containerName":"to_string","kind":13,"line":548},{"containerName":"to_string","kind":12,"name":"ontology","line":548},{"line":549,"containerName":"to_string","kind":13,"name":"$s"},{"kind":13,"containerName":"to_string","name":"$self","line":549},{"line":549,"kind":12,"containerName":"to_string","name":"ontology"},{"line":549,"containerName":"to_string","kind":12,"name":"name"},{"name":"$s","containerName":"to_string","kind":13,"line":551},{"containerName":"to_string","kind":13,"name":"$s","line":553},{"line":554,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":554},{"line":554,"kind":12,"containerName":"to_string","name":"version"},{"name":"$s","containerName":"to_string","kind":13,"line":555},{"line":556,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":556},{"line":556,"name":"is_obsolete","containerName":"to_string","kind":12},{"containerName":"to_string","kind":13,"name":"$s","line":557},{"name":"$s","kind":13,"containerName":"to_string","line":558},{"containerName":"to_string","kind":13,"name":"$self","line":558},{"name":"comment","containerName":"to_string","kind":12,"line":558},{"line":559,"name":"$self","containerName":"to_string","kind":13},{"line":559,"name":"get_references","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$s","line":560},{"name":"$ref","localvar":"my","containerName":"to_string","kind":13,"line":561,"definition":"my"},{"line":561,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"get_references","line":561},{"containerName":"to_string","kind":13,"name":"$s","line":562},{"line":562,"containerName":"to_string","kind":13,"name":"$ref"},{"line":562,"name":"authors","kind":12,"containerName":"to_string"},{"line":562,"name":"$ref","kind":13,"containerName":"to_string"},{"name":"title","kind":12,"containerName":"to_string","line":562},{"line":562,"containerName":"to_string","kind":13,"name":"$ref"},{"line":562,"name":"location","kind":12,"containerName":"to_string"},{"line":564,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":566},{"kind":12,"containerName":"to_string","name":"get_members","line":566},{"line":567,"kind":13,"containerName":"to_string","name":"$s"},{"line":568,"name":"$ref","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"line":568,"kind":13,"containerName":"to_string","name":"$self"},{"line":568,"containerName":"to_string","kind":12,"name":"get_members"},{"line":569,"kind":13,"containerName":"to_string","name":"$s"},{"line":569,"containerName":"to_string","kind":13,"name":"$ref"},{"line":569,"name":"database","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$ref","line":569},{"kind":12,"containerName":"to_string","name":"primary_id","line":569},{"line":571,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$self","kind":13,"containerName":"to_string","line":573},{"line":573,"name":"get_external_documents","kind":12,"containerName":"to_string"},{"line":574,"name":"$s","containerName":"to_string","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"to_string","name":"$ref","line":575},{"line":575,"name":"$self","containerName":"to_string","kind":13},{"line":575,"name":"get_external_documents","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$s","line":576},{"line":576,"name":"$ref","kind":13,"containerName":"to_string"},{"name":"database","containerName":"to_string","kind":12,"line":576},{"line":576,"name":"$ref","containerName":"to_string","kind":13},{"line":576,"name":"primary_id","containerName":"to_string","kind":12},{"name":"$s","kind":13,"containerName":"to_string","line":578},{"line":580,"containerName":"to_string","kind":13,"name":"$self"},{"line":580,"kind":12,"containerName":"to_string","name":"get_examples"},{"line":581,"name":"$s","kind":13,"containerName":"to_string"},{"line":582,"name":"$ref","localvar":"my","kind":13,"containerName":"to_string","definition":"my"},{"line":582,"containerName":"to_string","kind":13,"name":"$self"},{"line":582,"name":"get_examples","containerName":"to_string","kind":12},{"line":583,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"containerName":"to_string","name":"$ref","line":583},{"name":"database","containerName":"to_string","kind":12,"line":583},{"line":583,"containerName":"to_string","kind":13,"name":"$ref"},{"line":583,"containerName":"to_string","kind":12,"name":"primary_id"},{"containerName":"to_string","kind":13,"name":"$ref","line":583},{"line":583,"name":"comment","containerName":"to_string","kind":12},{"line":585,"kind":13,"containerName":"to_string","name":"$s"},{"line":587,"name":"$self","containerName":"to_string","kind":13},{"line":587,"name":"class_list","containerName":"to_string","kind":12},{"line":588,"name":"$s","containerName":"to_string","kind":13},{"line":589,"name":"$ref","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"to_string","line":589},{"line":589,"name":"class_list","containerName":"to_string","kind":12},{"line":590,"name":"$s","containerName":"to_string","kind":13},{"name":"$ref","containerName":"to_string","kind":13,"line":590},{"line":590,"name":"primary_id","kind":12,"containerName":"to_string"},{"name":"$s","containerName":"to_string","kind":13,"line":592},{"line":594,"containerName":"to_string","kind":13,"name":"$self"},{"name":"get_secondary_ids","containerName":"to_string","kind":12,"line":594},{"name":"$s","containerName":"to_string","kind":13,"line":595},{"definition":"my","name":"$ref","localvar":"my","kind":13,"containerName":"to_string","line":596},{"name":"$self","containerName":"to_string","kind":13,"line":596},{"name":"get_secondary_ids","kind":12,"containerName":"to_string","line":596},{"name":"$s","kind":13,"containerName":"to_string","line":597},{"kind":13,"containerName":"to_string","name":"$ref","line":597},{"line":599,"name":"$s","containerName":"to_string","kind":13}]},{"name":"$s","kind":13,"containerName":null,"line":603},{"name":"$s","containerName":null,"kind":13,"line":605},{"line":627,"kind":12,"range":{"end":{"character":9999,"line":649},"start":{"character":0,"line":627}},"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"secondary_ids","line":628,"definition":"my"},{"containerName":"secondary_ids","localvar":"my","kind":13,"name":"@ids","line":629,"definition":"my"},{"name":"$self","containerName":"secondary_ids","kind":13,"line":631},{"line":631,"name":"warn","kind":12,"containerName":"secondary_ids"},{"definition":"my","line":636,"containerName":"secondary_ids","localvar":"my","kind":13,"name":"$sids"},{"containerName":"secondary_ids","kind":13,"name":"$sids","line":637},{"line":638,"kind":13,"containerName":"secondary_ids","name":"$self"},{"name":"add_secondary_id","containerName":"secondary_ids","kind":12,"line":638},{"name":"$sids","kind":13,"containerName":"secondary_ids","line":638},{"kind":13,"containerName":"secondary_ids","name":"@ids","line":639},{"line":639,"containerName":"secondary_ids","kind":13,"name":"$sids"},{"kind":13,"containerName":"secondary_ids","name":"$self","line":642},{"name":"remove_secondary_ids","kind":12,"containerName":"secondary_ids","line":642},{"line":646,"name":"@ids","containerName":"secondary_ids","kind":13},{"name":"$self","kind":13,"containerName":"secondary_ids","line":646},{"line":646,"name":"get_secondary_ids","kind":12,"containerName":"secondary_ids"},{"kind":13,"containerName":"secondary_ids","name":"@ids","line":648}],"name":"secondary_ids","containerName":"main::"}]}