{"vars":[{"kind":14,"containerName":"main::","name":"GOID_DEFAULT","line":109,"definition":1},{"name":"strict","containerName":"","kind":12,"line":109},{"definition":1,"line":110,"containerName":"main::","kind":14,"name":"TRUE"},{"definition":1,"name":"FALSE","kind":14,"containerName":"main::","line":111},{"containerName":"","kind":2,"name":"base","line":113},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GOterm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::GOterm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Ontology::GOterm - representation of GO terms \n\n=head1 SYNOPSIS\n\n  $term = Bio::Ontology::GOterm->new\n    ( -go_id       => \"GO:0016847\",\n      -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n      -definition  => \"Catalysis of ...\",\n      -is_obsolete => 0,\n      -comment     => \"\" );\n\n  $term->add_definition_references( @refs );\n  $term->add_secondary_GO_ids( @ids );\n  $term->add_aliases( @aliases );\n\n  foreach my $dr ( $term->each_definition_reference() ) {\n      print $dr, \"\\n\";\n  }\n\n  # etc.\n\n=head1 DESCRIPTION\n\nThis is \"dumb\" class for GO terms (it provides no functionality \nrelated to graphs). Implements Bio::Ontology::TermI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::GOterm;\nuse strict;\n\nuse constant GOID_DEFAULT => \"GO:0000000\";\nuse constant TRUE         => 1;\nuse constant FALSE        => 0;\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::GOterm->new( \n       -go_id       => \"GO:0016847\",\n       -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n       -definition  => \"Catalysis of ...\",\n       -is_obsolete => 0,\n       -comment     => \"\" );                   \n Function: Creates a new Bio::Ontology::GOterm.\n Returns : A new Bio::Ontology::GOterm object.\n Args    : -go_id         => the goid of this GO term [GO:nnnnnnn] \n                             or [nnnnnnn] (nnnnnnn is a zero-padded\n                             integer of seven digits)\n           -name          => the name of this GO term [scalar]\n           -definition    => the definition of this GO term [scalar]  \n           -ontology      => the ontology for this term (a\n                             Bio::Ontology::OntologyI compliant object)\n           -version       => version information [scalar]\n           -is_obsolete   => the obsoleteness of this GO term [0 or 1]   \n           -comment       => a comment [scalar]","label":"new($class,@args)"},"line":139,"kind":12,"range":{"start":{"character":0,"line":139},"end":{"character":9999,"line":153}},"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":141,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":141},{"definition":"my","line":143,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"kind":13,"containerName":"new","name":"$class","line":143},{"line":143,"kind":13,"containerName":"new","name":"@args"},{"name":"$GO_id","localvar":"my","containerName":"new","kind":13,"line":145,"definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":146},{"line":146,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":146},{"name":"$GO_id","kind":13,"containerName":"new","line":148},{"containerName":"new","kind":13,"name":"$self","line":148},{"name":"GO_id","containerName":"new","kind":12,"line":148},{"line":148,"containerName":"new","kind":13,"name":"$GO_id"},{"kind":13,"containerName":"new","name":"$self","line":151}],"name":"new","containerName":"main::"},{"line":143,"name":"SUPER","containerName":"new","kind":12},{"definition":"sub","containerName":"main::","name":"init","children":[{"kind":13,"localvar":"my","containerName":"init","name":"$self","line":168,"definition":"my"},{"line":171,"kind":13,"containerName":"init","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":166},"end":{"character":9999,"line":176}},"line":166},{"name":"SUPER","containerName":"init","kind":12,"line":171},{"line":196,"kind":12,"range":{"start":{"line":196,"character":0},"end":{"line":207,"character":9999}},"children":[{"line":197,"name":"$self","kind":13,"localvar":"my","containerName":"GO_id","definition":"my"},{"definition":"my","localvar":"my","containerName":"GO_id","kind":13,"name":"$value","line":198},{"line":201,"containerName":"GO_id","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"GO_id","line":201},{"line":201,"name":"_check_go_id","containerName":"GO_id","kind":12},{"name":"$value","kind":13,"containerName":"GO_id","line":202},{"kind":13,"containerName":"GO_id","name":"$self","line":205},{"line":205,"kind":12,"containerName":"GO_id","name":"identifier"}],"name":"GO_id","containerName":"main::","definition":"sub"},{"children":[{"name":"get_secondary_ids","containerName":"get_secondary_GO_ids","kind":12,"line":225}],"name":"get_secondary_GO_ids","containerName":"main::","definition":"sub","line":224,"range":{"end":{"character":9999,"line":226},"start":{"character":0,"line":224}},"kind":12},{"definition":"sub","name":"add_secondary_GO_id","containerName":"main::","children":[{"kind":12,"containerName":"add_secondary_GO_id","name":"add_secondary_id","line":248}],"kind":12,"range":{"start":{"character":0,"line":247},"end":{"line":249,"character":9999}},"line":247},{"containerName":"main::","name":"remove_secondary_GO_ids","children":[{"kind":12,"containerName":"remove_secondary_GO_ids","name":"remove_secondary_ids","line":267}],"definition":"sub","kind":12,"range":{"end":{"line":268,"character":9999},"start":{"character":0,"line":266}},"line":266},{"detail":"($self)","definition":"sub","containerName":"main::","name":"to_string","children":[{"definition":"my","line":282,"name":"$self","localvar":"my","kind":13,"containerName":"to_string"},{"name":"$s","localvar":"my","containerName":"to_string","kind":13,"line":284,"definition":"my"},{"line":286,"name":"$s","kind":13,"containerName":"to_string"},{"line":287,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$self","kind":13,"containerName":"to_string","line":287},{"name":"GO_id","kind":12,"containerName":"to_string","line":287},{"line":288,"name":"$s","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$s","line":289},{"line":289,"containerName":"to_string","kind":13,"name":"$self"},{"line":289,"kind":12,"containerName":"to_string","name":"name"},{"line":290,"name":"$s","containerName":"to_string","kind":13},{"name":"$s","kind":13,"containerName":"to_string","line":291},{"name":"$self","kind":13,"containerName":"to_string","line":291},{"line":291,"name":"definition","kind":12,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":292},{"line":293,"name":"$self","kind":13,"containerName":"to_string"},{"line":293,"containerName":"to_string","kind":12,"name":"ontology"},{"line":294,"name":"$s","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":294},{"line":294,"kind":12,"containerName":"to_string","name":"ontology"},{"line":294,"containerName":"to_string","kind":12,"name":"name"},{"line":297,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":299},{"name":"$s","containerName":"to_string","kind":13,"line":300},{"kind":13,"containerName":"to_string","name":"$self","line":300},{"line":300,"name":"version","containerName":"to_string","kind":12},{"line":301,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":302},{"line":302,"name":"$self","kind":13,"containerName":"to_string"},{"name":"is_obsolete","containerName":"to_string","kind":12,"line":302},{"line":303,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","kind":13,"containerName":"to_string","line":304},{"line":304,"containerName":"to_string","kind":13,"name":"$self"},{"containerName":"to_string","kind":12,"name":"comment","line":304},{"kind":13,"containerName":"to_string","name":"$s","line":305},{"line":306,"name":"$s","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":306},{"line":306,"name":"_array_to_string","kind":12,"containerName":"to_string"},{"name":"$self","kind":13,"containerName":"to_string","line":306},{"kind":12,"containerName":"to_string","name":"get_dbxrefs","line":306},{"line":307,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":308},{"line":308,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"containerName":"to_string","name":"_array_to_string","line":308},{"line":308,"name":"$self","kind":13,"containerName":"to_string"},{"line":308,"kind":12,"containerName":"to_string","name":"get_secondary_GO_ids"},{"line":309,"name":"$s","containerName":"to_string","kind":13},{"line":310,"name":"$s","containerName":"to_string","kind":13},{"line":310,"name":"$self","containerName":"to_string","kind":13},{"line":310,"kind":12,"containerName":"to_string","name":"_array_to_string"},{"line":310,"name":"$self","kind":13,"containerName":"to_string"},{"name":"get_synonyms","containerName":"to_string","kind":12,"line":310},{"line":312,"name":"$s","containerName":"to_string","kind":13}],"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GOterm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::GOterm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Ontology::GOterm - representation of GO terms \n\n=head1 SYNOPSIS\n\n  $term = Bio::Ontology::GOterm->new\n    ( -go_id       => \"GO:0016847\",\n      -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n      -definition  => \"Catalysis of ...\",\n      -is_obsolete => 0,\n      -comment     => \"\" );\n\n  $term->add_definition_references( @refs );\n  $term->add_secondary_GO_ids( @ids );\n  $term->add_aliases( @aliases );\n\n  foreach my $dr ( $term->each_definition_reference() ) {\n      print $dr, \"\\n\";\n  }\n\n  # etc.\n\n=head1 DESCRIPTION\n\nThis is \"dumb\" class for GO terms (it provides no functionality \nrelated to graphs). Implements Bio::Ontology::TermI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::GOterm;\nuse strict;\n\nuse constant GOID_DEFAULT => \"GO:0000000\";\nuse constant TRUE         => 1;\nuse constant FALSE        => 0;\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::GOterm->new( \n       -go_id       => \"GO:0016847\",\n       -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n       -definition  => \"Catalysis of ...\",\n       -is_obsolete => 0,\n       -comment     => \"\" );                   \n Function: Creates a new Bio::Ontology::GOterm.\n Returns : A new Bio::Ontology::GOterm object.\n Args    : -go_id         => the goid of this GO term [GO:nnnnnnn] \n                             or [nnnnnnn] (nnnnnnn is a zero-padded\n                             integer of seven digits)\n           -name          => the name of this GO term [scalar]\n           -definition    => the definition of this GO term [scalar]  \n           -ontology      => the ontology for this term (a\n                             Bio::Ontology::OntologyI compliant object)\n           -version       => version information [scalar]\n           -is_obsolete   => the obsoleteness of this GO term [0 or 1]   \n           -comment       => a comment [scalar]\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $GO_id )\n\t= $self->_rearrange( [ qw( GO_ID ) ], @args );\n   \n    $GO_id && $self->GO_id( $GO_id );\n  \n                                                    \n    return $self;\n    \n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $term->init();   \n Function: Initializes this GOterm to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    #$self->GO_id( GOID_DEFAULT );\n  \n} # init\n\n\n=head2 GO_id\n\n Title   : GO_id\n Usage   : $term->GO_id( \"GO:0003947\" );\n           or\n           print $term->GO_id();\n Function: Set/get for the goid of this GO term.\n\n           This is essentially an alias to identifier(), with added\n           format checking.\n\n Returns : The goid [GO:nnnnnnn].\n Args    : The goid [GO:nnnnnnn] or [nnnnnnn] (nnnnnnn is a\n           zero-padded integer of seven digits) (optional).\n\n\nsub GO_id {\n    my $self = shift;\n    my $value;\n\n    if ( @_ ) {\n        $value = $self->_check_go_id( shift );\n\tunshift(@_, $value);\n    }\n\n    return $self->identifier( @_ );\n\n} # GO_id\n\n\n=head2 get_secondary_GO_ids\n\n Title   : get_secondary_GO_ids\n Usage   : @ids = $term->get_secondary_GO_ids();\n Function: Returns a list of secondary goids of this Term.\n\n           This is aliased to remove_secondary_ids().\n\n Returns : A list of secondary goids [array of [GO:nnnnnnn]]\n           (nnnnnnn is a zero-padded integer of seven digits).\n Args    :\n\n\nsub get_secondary_GO_ids {\n    return shift->get_secondary_ids(@_);\n} # get_secondary_GO_ids\n\n\n=head2 add_secondary_GO_id\n\n Title   : add_secondary_GO_id\n Usage   : $term->add_secondary_GO_id( @ids );\n           or\n           $term->add_secondary_GO_id( $id );                  \n Function: Pushes one or more secondary goids into\n           the list of secondary goids.\n\n           This is aliased to remove_secondary_ids().\n\n Returns : \n Args    : One secondary goid [GO:nnnnnnn or nnnnnnn] or a list\n           of secondary goids [array of [GO:nnnnnnn or nnnnnnn]]\n           (nnnnnnn is a zero-padded integer of seven digits).\n\n\nsub add_secondary_GO_id {\n    return shift->add_secondary_id(@_);\n} # add_secondary_GO_id\n\n\n=head2 remove_secondary_GO_ids\n\n Title   : remove_secondary_GO_ids()\n Usage   : $term->remove_secondary_GO_ids();\n Function: Deletes (and returns) the secondary goids of this Term.\n\n           This is aliased to remove_secondary_ids().\n\n Returns : A list of secondary goids [array of [GO:nnnnnnn]]\n           (nnnnnnn is a zero-padded integer of seven digits).\n Args    :\n\n\nsub remove_secondary_GO_ids {\n    return shift->remove_secondary_ids(@_);\n} # remove_secondary_GO_ids\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $term->to_string();\n Function: to_string method for GO terms.\n Returns : A string representation of this GOterm.\n Args    :"},"kind":12,"range":{"end":{"character":9999,"line":314},"start":{"line":281,"character":0}},"line":281},{"children":[{"definition":"my","localvar":"my","containerName":"_check_go_id","kind":13,"name":"$self","line":325},{"line":325,"kind":13,"containerName":"_check_go_id","name":"$value"},{"line":326,"containerName":"_check_go_id","kind":13,"name":"$value"},{"containerName":"_check_go_id","kind":13,"name":"$value","line":326},{"line":327,"containerName":"_check_go_id","kind":13,"name":"$self"},{"containerName":"_check_go_id","kind":12,"name":"throw","line":327},{"line":328,"name":"$value","kind":13,"containerName":"_check_go_id"},{"kind":13,"containerName":"_check_go_id","name":"$value","line":330},{"name":"$value","kind":13,"containerName":"_check_go_id","line":331},{"kind":13,"containerName":"_check_go_id","name":"$value","line":331},{"name":"$value","containerName":"_check_go_id","kind":13,"line":333}],"name":"_check_go_id","containerName":"main::","definition":"sub","detail":"($self,$value)","line":324,"range":{"end":{"line":334,"character":9999},"start":{"line":324,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Title   : _check_go_id\n Function: Checks whether the argument is [GO:nnnnnnn].\n           If \"GO:\" is not present, it adds it.\n Returns : The canonical GO id.\n Args    : The value to be checked.","label":"_check_go_id($self,$value)"}},{"line":326,"name":"GOID_DEFAULT","kind":12},{"detail":"($self,@value)","definition":"sub","containerName":"main::","name":"_array_to_string","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_array_to_string","name":"$self","line":343},{"kind":13,"containerName":"_array_to_string","name":"@value","line":343},{"containerName":"_array_to_string","localvar":"my","kind":13,"name":"$s","line":345,"definition":"my"},{"definition":"my","line":347,"name":"$i","containerName":"_array_to_string","localvar":"my","kind":13},{"line":347,"containerName":"_array_to_string","kind":13,"name":"$i"},{"containerName":"_array_to_string","kind":13,"name":"@value","line":347},{"name":"$i","containerName":"_array_to_string","kind":13,"line":347},{"line":348,"name":"$value","containerName":"_array_to_string","kind":13},{"name":"$i","kind":13,"containerName":"_array_to_string","line":348},{"name":"$s","containerName":"_array_to_string","kind":13,"line":349},{"kind":13,"containerName":"_array_to_string","name":"$i","line":349},{"line":349,"kind":13,"containerName":"_array_to_string","name":"$value"},{"kind":13,"containerName":"_array_to_string","name":"$i","line":349},{"name":"$s","containerName":"_array_to_string","kind":13,"line":353}],"signature":{"documentation":" Title   : _array_to_string\n Function:\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"@value"}],"label":"_array_to_string($self,@value)"},"range":{"start":{"line":342,"character":0},"end":{"line":355,"character":9999}},"kind":12,"line":342}],"version":5}