{"vars":[{"line":79,"kind":2,"containerName":"","name":"vars"},{"line":82,"name":"base","containerName":"","kind":2},{"containerName":"main::","name":"new","children":[{"definition":"my","line":101,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"line":102,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":102,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":102},{"definition":"my","line":103,"name":"$file","localvar":"my","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":103},{"kind":12,"containerName":"new","name":"_rearrange","line":103},{"line":103,"name":"@args","kind":13,"containerName":"new"},{"name":"$query","localvar":"my","containerName":"new","kind":13,"line":104,"definition":"my"},{"containerName":"new","kind":13,"name":"$tr1","line":104},{"name":"$file","kind":13,"containerName":"new","line":104},{"name":"$self","kind":13,"containerName":"new","line":105},{"kind":13,"containerName":"new","name":"$file","line":105},{"line":106,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","kind":13,"containerName":"new","line":107},{"name":"$self","kind":13,"containerName":"new","line":107},{"kind":12,"containerName":"new","name":"_rearrange","line":107},{"line":107,"name":"@args","kind":13,"containerName":"new"},{"line":108,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_initialize_io","line":108},{"line":108,"containerName":"new","kind":13,"name":"@args"},{"line":108,"name":"$self","kind":13,"containerName":"new"},{"name":"warn","kind":12,"containerName":"new","line":108},{"name":"$self","kind":13,"containerName":"new","line":109}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":100},"end":{"line":110,"character":9999}},"kind":12,"line":100,"signature":{"label":"new($class,@args)","documentation":"1;\n#---------------------------------------------------------\n# $Id: masta.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::masta - motif fasta format parser\n\n=head1 SYNOPSIS \n\nMASTA is a position frequency matrix format similar to\nfasta. It contains one ID row just like fasta and then the actual\ndata, which is tab delimited:\n\n  0.1\t0.62\t.017\t0.11\n  0.22\t0.13\t0.54\t0.11\n\nOr A,C,G and T could be horizontally positioned (positioning is\nautomatically detected).  Please note masta will parse only DNA at the\nmoment.\n\nIt will also convert a set of aligned sequences:\nACATGCAT\nACAGGGAT\nACAGGCAT\nACCGGCAT\n\nto a PFM (SiteMatrix object). When writing if you supply SEQ it will\nwrite 10 random instances, which represent correctly the frequency and\ncan be used as an input for weblogo creation purposes.\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use masta parser\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::masta;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::IO Bio::Root::Root);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=> 'masta',\n\t\t\t\t\t\t -file  => $file, \n                                                 -mtype => 'PWM');\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}]}},{"name":"SUPER","containerName":"new","kind":12,"line":102},{"line":105,"name":"file","kind":12},{"line":106,"name":"_end","kind":12},{"kind":12,"name":"mtype","line":107},{"definition":"sub","detail":"($self,$matrix,$type)","children":[{"definition":"my","containerName":"write_psm","localvar":"my","kind":13,"name":"$self","line":125},{"line":125,"name":"$matrix","containerName":"write_psm","kind":13},{"name":"$type","containerName":"write_psm","kind":13,"line":125},{"line":126,"name":"$self","kind":13,"containerName":"write_psm"},{"name":"$type","kind":13,"containerName":"write_psm","line":126},{"line":126,"kind":13,"containerName":"write_psm","name":"$type"},{"line":127,"name":"$idline","localvar":"my","containerName":"write_psm","kind":13,"definition":"my"},{"line":127,"name":"$matrix","kind":13,"containerName":"write_psm"},{"line":127,"containerName":"write_psm","kind":12,"name":"id"},{"line":128,"containerName":"write_psm","kind":13,"name":"$self"},{"name":"_print","kind":12,"containerName":"write_psm","line":128},{"containerName":"write_psm","kind":13,"name":"$idline","line":128},{"name":"$self","containerName":"write_psm","kind":13,"line":129},{"definition":"my","name":"%h","localvar":"my","kind":13,"containerName":"write_psm","line":130},{"kind":13,"containerName":"write_psm","name":"$matrix","line":130},{"name":"next_pos","kind":12,"containerName":"write_psm","line":130},{"containerName":"write_psm","localvar":"my","kind":13,"name":"$row","line":131,"definition":"my"},{"line":131,"kind":13,"containerName":"write_psm","name":"$self"},{"kind":13,"containerName":"write_psm","name":"$h","line":131},{"line":131,"kind":13,"containerName":"write_psm","name":"$h"},{"line":131,"name":"$h","containerName":"write_psm","kind":13},{"line":131,"name":"$h","kind":13,"containerName":"write_psm"},{"line":131,"name":"$h","kind":13,"containerName":"write_psm"},{"line":131,"name":"$h","kind":13,"containerName":"write_psm"},{"line":131,"name":"$h","containerName":"write_psm","kind":13},{"line":131,"name":"$h","containerName":"write_psm","kind":13},{"line":132,"name":"$self","kind":13,"containerName":"write_psm"},{"name":"_print","kind":12,"containerName":"write_psm","line":132},{"line":132,"kind":13,"containerName":"write_psm","name":"$row"},{"definition":"my","name":"@seq","localvar":"my","kind":13,"containerName":"write_psm","line":135},{"line":136,"name":"%h","localvar":"my","kind":13,"containerName":"write_psm","definition":"my"},{"name":"$matrix","containerName":"write_psm","kind":13,"line":136},{"line":136,"name":"next_pos","kind":12,"containerName":"write_psm"},{"line":137,"name":"$a","kind":13,"localvar":"my","containerName":"write_psm","definition":"my"},{"name":"$c","kind":13,"containerName":"write_psm","line":137},{"line":137,"name":"$g","containerName":"write_psm","kind":13},{"name":"$t","containerName":"write_psm","kind":13,"line":137},{"name":"%h","kind":13,"containerName":"write_psm","line":137},{"containerName":"write_psm","kind":13,"name":"$self","line":138},{"name":"throw","containerName":"write_psm","kind":12,"line":138},{"name":"$a","kind":13,"containerName":"write_psm","line":138},{"line":138,"containerName":"write_psm","kind":13,"name":"$c"},{"line":138,"containerName":"write_psm","kind":13,"name":"$g"},{"name":"$t","containerName":"write_psm","kind":13,"line":138},{"line":139,"kind":13,"localvar":"my","containerName":"write_psm","name":"$i","definition":"my"},{"line":139,"name":"$a","containerName":"write_psm","kind":13},{"line":139,"containerName":"write_psm","kind":13,"name":"$seq"},{"line":139,"containerName":"write_psm","kind":13,"name":"$i"},{"definition":"my","localvar":"my","containerName":"write_psm","kind":13,"name":"$m","line":140},{"name":"$a","containerName":"write_psm","kind":13,"line":140},{"line":140,"name":"$c","containerName":"write_psm","kind":13},{"localvar":"my","containerName":"write_psm","kind":13,"name":"$i","line":141,"definition":"my"},{"line":141,"kind":13,"containerName":"write_psm","name":"$a"},{"name":"$m","containerName":"write_psm","kind":13,"line":141},{"name":"$seq","kind":13,"containerName":"write_psm","line":141},{"line":141,"name":"$i","kind":13,"containerName":"write_psm"},{"localvar":"my","kind":13,"containerName":"write_psm","name":"$n","line":142,"definition":"my"},{"line":142,"name":"$a","kind":13,"containerName":"write_psm"},{"name":"$c","kind":13,"containerName":"write_psm","line":142},{"line":142,"kind":13,"containerName":"write_psm","name":"$g"},{"line":143,"localvar":"my","containerName":"write_psm","kind":13,"name":"$i","definition":"my"},{"line":143,"kind":13,"containerName":"write_psm","name":"$m"},{"line":143,"name":"$n","containerName":"write_psm","kind":13},{"line":143,"name":"$seq","containerName":"write_psm","kind":13},{"name":"$i","kind":13,"containerName":"write_psm","line":143},{"line":144,"name":"$i","localvar":"my","containerName":"write_psm","kind":13,"definition":"my"},{"line":144,"kind":13,"containerName":"write_psm","name":"$n"},{"line":144,"containerName":"write_psm","kind":13,"name":"$seq"},{"line":144,"kind":13,"containerName":"write_psm","name":"$i"},{"definition":"my","localvar":"my","kind":13,"containerName":"write_psm","name":"$s","line":146},{"line":146,"kind":13,"containerName":"write_psm","name":"@seq"},{"line":147,"kind":13,"containerName":"write_psm","name":"$s"},{"name":"$self","kind":13,"containerName":"write_psm","line":148},{"kind":12,"containerName":"write_psm","name":"_print","line":148},{"containerName":"write_psm","kind":13,"name":"$s","line":148}],"containerName":"main::","name":"write_psm","signature":{"label":"write_psm($self,$matrix,$type)","parameters":[{"label":"$self"},{"label":"$matrix"},{"label":"$type"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: masta.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::masta - motif fasta format parser\n\n=head1 SYNOPSIS \n\nMASTA is a position frequency matrix format similar to\nfasta. It contains one ID row just like fasta and then the actual\ndata, which is tab delimited:\n\n  0.1\t0.62\t.017\t0.11\n  0.22\t0.13\t0.54\t0.11\n\nOr A,C,G and T could be horizontally positioned (positioning is\nautomatically detected).  Please note masta will parse only DNA at the\nmoment.\n\nIt will also convert a set of aligned sequences:\nACATGCAT\nACAGGGAT\nACAGGCAT\nACCGGCAT\n\nto a PFM (SiteMatrix object). When writing if you supply SEQ it will\nwrite 10 random instances, which represent correctly the frequency and\ncan be used as an input for weblogo creation purposes.\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use masta parser\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::masta;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::IO Bio::Root::Root);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=> 'masta',\n\t\t\t\t\t\t -file  => $file, \n                                                 -mtype => 'PWM');\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    my ($query,$tr1)=split(/\\./,$file,2);\n    $self->{file}  = $file;\n    $self->{_end}  = 0;\n    $self->{mtype} = uc($self->_rearrange(['MTYPE'], @args) || \"PFM\");\n    $self->_initialize_io(@args) || $self->warn(\"Did you intend to use STDIN?\"); #Read only for now\n    return $self;\n}\n\n=head2 write_psm\n\n Title   : write_psm\n Usage   : \n Function: writes a pfm/pwm/raw sequence in a simple masta format\n Throws  :\n Example : \n Args    : SiteMatrix object, type (optional string: PWM, SEQ or PFM)\n Returns : "},"line":124,"range":{"end":{"character":9999,"line":151},"start":{"line":124,"character":0}},"kind":12},{"line":126,"name":"mtype","kind":12},{"name":"mtype","kind":12,"line":129},{"line":131,"kind":12,"name":"mtype"},{"line":131,"name":"lA","kind":12},{"line":131,"name":"lC","kind":12},{"line":131,"kind":12,"name":"lG"},{"kind":12,"name":"lT","line":131},{"line":131,"name":"pA","kind":12},{"kind":12,"name":"pC","line":131},{"line":131,"kind":12,"name":"pG"},{"line":131,"kind":12,"name":"pT"},{"line":137,"kind":12,"name":"_freq_to_count"},{"containerName":"main::","name":"next_matrix","children":[{"line":162,"name":"next_psm","kind":12,"containerName":"next_matrix"}],"definition":"sub","range":{"start":{"line":161,"character":0},"end":{"character":9999,"line":163}},"kind":12,"line":161},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_psm","line":180,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_psm","line":181},{"line":182,"localvar":"my","containerName":"next_psm","kind":13,"name":"$line","definition":"my"},{"name":"$self","kind":13,"containerName":"next_psm","line":182},{"line":182,"kind":12,"containerName":"next_psm","name":"_readline"},{"name":"$self","kind":13,"containerName":"next_psm","line":183},{"line":183,"name":"throw","kind":12,"containerName":"next_psm"},{"line":183,"name":"$line","containerName":"next_psm","kind":13},{"line":184,"containerName":"next_psm","localvar":"my","kind":13,"name":"$id","definition":"my"},{"line":184,"containerName":"next_psm","kind":13,"name":"$desc"},{"line":184,"containerName":"next_psm","kind":13,"name":"$line"},{"name":"$id","kind":13,"containerName":"next_psm","line":185},{"line":186,"localvar":"my","containerName":"next_psm","kind":13,"name":"$mtype","definition":"my"},{"name":"$format","containerName":"next_psm","kind":13,"line":186},{"line":186,"name":"@mdata","kind":13,"containerName":"next_psm"},{"kind":13,"containerName":"next_psm","name":"$len","line":186},{"name":"$self","containerName":"next_psm","kind":13,"line":187},{"containerName":"next_psm","kind":13,"name":"$line","line":188},{"line":188,"containerName":"next_psm","kind":13,"name":"$self"},{"line":188,"containerName":"next_psm","kind":12,"name":"_readline"},{"line":189,"containerName":"next_psm","kind":13,"name":"$line"},{"line":190,"containerName":"next_psm","kind":13,"name":"$line"},{"name":"$line","containerName":"next_psm","kind":13,"line":191},{"kind":13,"containerName":"next_psm","name":"$self","line":192},{"containerName":"next_psm","kind":12,"name":"_pushback","line":192},{"containerName":"next_psm","kind":13,"name":"$line","line":192},{"kind":13,"containerName":"next_psm","name":"$line","line":196},{"line":198,"kind":13,"containerName":"next_psm","name":"$self"},{"containerName":"next_psm","kind":12,"name":"throw","line":198},{"line":199,"kind":13,"containerName":"next_psm","name":"$self"},{"containerName":"next_psm","kind":13,"name":"$mtype","line":199},{"name":"$self","kind":13,"containerName":"next_psm","line":200},{"kind":12,"containerName":"next_psm","name":"throw","line":200},{"line":201,"name":"$len","containerName":"next_psm","kind":13},{"kind":13,"containerName":"next_psm","name":"$len","line":201},{"line":201,"containerName":"next_psm","kind":13,"name":"$line"},{"containerName":"next_psm","kind":13,"name":"$len","line":202},{"line":202,"name":"$line","containerName":"next_psm","kind":13},{"containerName":"next_psm","kind":13,"name":"$len","line":202},{"line":203,"name":"@mdata","containerName":"next_psm","kind":13},{"name":"$line","containerName":"next_psm","kind":13,"line":203},{"line":204,"name":"$self","kind":13,"containerName":"next_psm"},{"line":207,"containerName":"next_psm","kind":13,"name":"$line"},{"containerName":"next_psm","kind":13,"name":"$line","line":208},{"name":"$line","containerName":"next_psm","kind":13,"line":209},{"line":210,"localvar":"my","kind":13,"containerName":"next_psm","name":"@data","definition":"my"},{"line":210,"name":"$line","containerName":"next_psm","kind":13},{"name":"$self","kind":13,"containerName":"next_psm","line":212},{"name":"throw","containerName":"next_psm","kind":12,"line":212},{"line":212,"name":"$mtype","kind":13,"containerName":"next_psm"},{"kind":13,"containerName":"next_psm","name":"$self","line":212},{"containerName":"next_psm","kind":13,"name":"$self","line":213},{"line":214,"name":"$mtype","kind":13,"containerName":"next_psm"},{"line":217,"kind":13,"containerName":"next_psm","name":"$self"},{"line":217,"name":"throw","containerName":"next_psm","kind":12},{"line":217,"name":"$mtype","kind":13,"containerName":"next_psm"},{"kind":13,"containerName":"next_psm","name":"$self","line":217},{"line":218,"name":"$self","kind":13,"containerName":"next_psm"},{"line":219,"kind":13,"containerName":"next_psm","name":"$mtype"},{"line":221,"name":"@mdata","kind":13,"containerName":"next_psm"},{"line":221,"name":"@data","containerName":"next_psm","kind":13},{"kind":13,"containerName":"next_psm","name":"$self","line":224},{"containerName":"next_psm","kind":13,"name":"$line","line":224},{"containerName":"next_psm","kind":13,"name":"$line","line":224},{"line":225,"kind":13,"containerName":"next_psm","name":"@mdata"},{"line":225,"name":"$self","kind":13,"containerName":"next_psm"},{"line":225,"kind":13,"containerName":"next_psm","name":"$id"},{"kind":13,"containerName":"next_psm","name":"$desc","line":225}],"containerName":"main::","name":"next_psm","definition":"sub","line":179,"range":{"start":{"line":179,"character":0},"end":{"character":9999,"line":226}},"kind":12},{"name":"_end","kind":12,"line":181},{"line":187,"name":"_mtype","kind":12},{"line":199,"kind":12,"name":"_mtype"},{"line":204,"kind":12,"name":"_mtype"},{"kind":12,"name":"data","line":211},{"line":212,"name":"_mtype","kind":12},{"line":213,"kind":12,"name":"_mtype"},{"line":217,"kind":12,"name":"_mtype"},{"line":218,"name":"_mtype","kind":12},{"kind":12,"name":"_end","line":224},{"line":225,"kind":12,"name":"_make_matrix"},{"name":"_mtype","kind":12,"line":225},{"containerName":"main::","name":"_make_matrix","children":[{"line":229,"localvar":"my","kind":13,"containerName":"_make_matrix","name":"$mdata","definition":"my"},{"containerName":"_make_matrix","kind":13,"name":"$type","line":229},{"line":229,"containerName":"_make_matrix","kind":13,"name":"$id"},{"line":229,"name":"$desc","kind":13,"containerName":"_make_matrix"},{"name":"$type","containerName":"_make_matrix","kind":13,"line":230},{"definition":"my","localvar":"my","containerName":"_make_matrix","kind":13,"name":"@rearr","line":231},{"containerName":"_make_matrix","kind":13,"name":"$mdata","line":231},{"name":"$mdata","kind":13,"containerName":"_make_matrix","line":232},{"containerName":"_make_matrix","kind":13,"name":"@rearr","line":232},{"definition":"my","containerName":"_make_matrix","localvar":"my","kind":13,"name":"$mformat","line":237},{"definition":"my","name":"$a","localvar":"my","kind":13,"containerName":"_make_matrix","line":238},{"kind":13,"containerName":"_make_matrix","name":"$c","line":238},{"name":"$g","containerName":"_make_matrix","kind":13,"line":238},{"line":238,"kind":13,"containerName":"_make_matrix","name":"$t"},{"line":239,"name":"$type","kind":13,"containerName":"_make_matrix"},{"containerName":"_make_matrix","kind":13,"name":"$a","line":240},{"kind":13,"containerName":"_make_matrix","name":"$c","line":240},{"line":240,"name":"$g","containerName":"_make_matrix","kind":13},{"line":240,"containerName":"_make_matrix","kind":13,"name":"$t"},{"name":"$mdata","containerName":"_make_matrix","kind":13,"line":240},{"line":242,"kind":13,"containerName":"_make_matrix","name":"$a"},{"line":242,"name":"$c","containerName":"_make_matrix","kind":13},{"containerName":"_make_matrix","kind":13,"name":"$g","line":242},{"line":242,"kind":13,"containerName":"_make_matrix","name":"$t"},{"line":242,"name":"$mdata","kind":13,"containerName":"_make_matrix"},{"definition":"my","localvar":"my","kind":13,"containerName":"_make_matrix","name":"$k","line":243},{"kind":13,"containerName":"_make_matrix","name":"$a","line":243},{"name":"$c","containerName":"_make_matrix","kind":13,"line":243},{"line":243,"containerName":"_make_matrix","kind":13,"name":"$g"},{"kind":13,"containerName":"_make_matrix","name":"$t","line":243},{"definition":"my","name":"$l","localvar":"my","kind":13,"containerName":"_make_matrix","line":244},{"line":244,"name":"$a","containerName":"_make_matrix","kind":13},{"line":244,"kind":13,"containerName":"_make_matrix","name":"$c"},{"name":"$g","containerName":"_make_matrix","kind":13,"line":244},{"kind":13,"containerName":"_make_matrix","name":"$t","line":244},{"kind":13,"containerName":"_make_matrix","name":"$a","line":245},{"containerName":"_make_matrix","kind":13,"name":"$c","line":245},{"containerName":"_make_matrix","kind":13,"name":"$g","line":245},{"name":"$t","containerName":"_make_matrix","kind":13,"line":245},{"line":246,"kind":13,"containerName":"_make_matrix","name":"$mformat"},{"line":246,"name":"$k","kind":13,"containerName":"_make_matrix"},{"kind":13,"containerName":"_make_matrix","name":"$l","line":246},{"line":247,"name":"$mformat","kind":13,"containerName":"_make_matrix"},{"name":"$l","kind":13,"containerName":"_make_matrix","line":247}],"detail":"($mdata,$type,$id,$desc)","definition":"sub","kind":12,"range":{"start":{"line":228,"character":0},"end":{"line":248,"character":9999}},"line":228,"signature":{"parameters":[{"label":"$mdata"},{"label":"$type"},{"label":"$id"},{"label":"$desc"}],"documentation":"","label":"_make_matrix($mdata,$type,$id,$desc)"}},{"line":231,"name":"_rearrange_matrix","kind":12},{"kind":12,"name":"_count_positions","line":240},{"name":"@fa","containerName":null,"localvar":"my","kind":13,"line":249,"definition":"my"},{"line":249,"name":"@fc","kind":13,"containerName":null},{"name":"@fg","kind":13,"containerName":null,"line":249},{"containerName":null,"kind":13,"name":"@ft","line":249},{"kind":13,"containerName":null,"name":"%mparam","line":249},{"name":"%mformat","containerName":null,"kind":13,"line":251},{"line":252,"name":"$i","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"%a","containerName":null,"kind":13,"line":252},{"line":253,"name":"$ca","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"@a","line":253},{"kind":13,"containerName":null,"name":"$i","line":253},{"kind":13,"localvar":"my","containerName":null,"name":"$cc","line":254,"definition":"my"},{"line":254,"name":"@c","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":254},{"definition":"my","name":"$cg","localvar":"my","containerName":null,"kind":13,"line":255},{"name":"@g","containerName":null,"kind":13,"line":255},{"line":255,"containerName":null,"kind":13,"name":"$i"},{"line":256,"name":"$ct","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"@t","line":256},{"line":256,"name":"$i","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$all","line":257},{"line":257,"containerName":null,"kind":13,"name":"$ca"},{"line":257,"kind":13,"containerName":null,"name":"$cc"},{"line":257,"name":"$cg","containerName":null,"kind":13},{"line":257,"kind":13,"containerName":null,"name":"$ct"},{"name":"@fa","kind":13,"containerName":null,"line":258},{"name":"$ca","containerName":null,"kind":13,"line":258},{"line":258,"name":"$all","kind":13,"containerName":null},{"name":"@fc","containerName":null,"kind":13,"line":259},{"line":259,"containerName":null,"kind":13,"name":"$cc"},{"name":"$all","containerName":null,"kind":13,"line":259},{"kind":13,"containerName":null,"name":"@fg","line":260},{"line":260,"containerName":null,"kind":13,"name":"$cg"},{"line":260,"name":"$all","containerName":null,"kind":13},{"line":261,"kind":13,"containerName":null,"name":"@ft"},{"kind":13,"containerName":null,"name":"$ct","line":261},{"kind":13,"containerName":null,"name":"$all","line":261},{"name":"$desc","containerName":null,"kind":13,"line":264},{"kind":13,"containerName":null,"name":"%mformat","line":265},{"containerName":null,"kind":13,"name":"$desc","line":266},{"line":267,"containerName":null,"kind":13,"name":"%mparam"},{"line":267,"kind":13,"containerName":null,"name":"@fa"},{"line":267,"name":"@fc","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@fg","line":267},{"containerName":null,"kind":13,"name":"@ft","line":267},{"line":267,"kind":13,"containerName":null,"name":"$id"},{"name":"$desc","containerName":null,"kind":13,"line":267},{"name":"$a","kind":13,"containerName":null,"line":268},{"line":268,"name":"$c","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$g","line":268},{"name":"%t","containerName":null,"kind":13,"line":268},{"line":271,"containerName":null,"kind":13,"name":"%mparam"},{"line":271,"name":"$a","kind":13,"containerName":null},{"name":"$c","kind":13,"containerName":null,"line":271},{"line":271,"kind":13,"containerName":null,"name":"$g"},{"name":"$t","kind":13,"containerName":null,"line":271},{"kind":13,"containerName":null,"name":"$id","line":271},{"containerName":null,"kind":13,"name":"$desc","line":271},{"name":"Bio","kind":12,"containerName":"Matrix::PSM::SiteMatrix","line":273},{"line":273,"name":"%mparam","kind":13,"containerName":null},{"line":276,"range":{"end":{"character":9999,"line":279},"start":{"line":276,"character":0}},"kind":12,"children":[{"line":277,"localvar":"my","kind":13,"containerName":"_rearrange_matrix","name":"$mdata","definition":"my"},{"localvar":"my","containerName":"_rearrange_matrix","kind":13,"name":"@a","line":278,"definition":"my"},{"containerName":"_rearrange_matrix","kind":13,"name":"@c","line":278},{"line":278,"containerName":"_rearrange_matrix","kind":13,"name":"@g"},{"containerName":"_rearrange_matrix","kind":13,"name":"@t","line":278},{"name":"$entry","containerName":"_rearrange_matrix","localvar":"my","kind":13,"line":279,"definition":"my"},{"line":279,"name":"$mdata","kind":13,"containerName":"_rearrange_matrix"}],"containerName":"main::","name":"_rearrange_matrix","definition":"sub"},{"definition":"my","line":280,"localvar":"my","containerName":null,"kind":13,"name":"$a"},{"line":280,"containerName":null,"kind":13,"name":"$c"},{"line":280,"name":"$g","containerName":null,"kind":13},{"line":280,"name":"$t","containerName":null,"kind":13},{"name":"$entry","kind":13,"containerName":null,"line":280},{"line":281,"name":"@a","containerName":null,"kind":13},{"line":281,"containerName":null,"kind":13,"name":"$a"},{"line":282,"name":"@c","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$c","line":282},{"containerName":null,"kind":13,"name":"@g","line":283},{"line":283,"kind":13,"containerName":null,"name":"$g"},{"line":284,"name":"@t","containerName":null,"kind":13},{"name":"$t","kind":13,"containerName":null,"line":284},{"kind":13,"containerName":null,"name":"@a","line":286},{"line":286,"containerName":null,"kind":13,"name":"@c"},{"kind":13,"containerName":null,"name":"@g","line":286},{"containerName":null,"kind":13,"name":"@t","line":286},{"line":290,"range":{"end":{"character":9999,"line":299},"start":{"character":0,"line":290}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_count_positions","name":"$seq","line":291},{"line":292,"name":"%pos","containerName":"_count_positions","localvar":"my","kind":13,"definition":"my"},{"line":293,"name":"$l","kind":13,"localvar":"my","containerName":"_count_positions","definition":"my"},{"line":293,"name":"$seq","containerName":"_count_positions","kind":13},{"line":294,"localvar":"my","kind":13,"containerName":"_count_positions","name":"$i","definition":"my"},{"name":"$i","kind":13,"containerName":"_count_positions","line":294},{"line":294,"kind":13,"containerName":"_count_positions","name":"$l"},{"name":"$i","containerName":"_count_positions","kind":13,"line":294},{"line":296,"name":"$pos","containerName":"_count_positions","kind":13},{"kind":13,"containerName":"_count_positions","name":"$i","line":296},{"definition":"my","line":299,"name":"$sequence","containerName":"_count_positions","localvar":"my","kind":13},{"kind":13,"containerName":"_count_positions","name":"$seq","line":299}],"name":"_count_positions","containerName":"main::"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@let","line":300},{"containerName":null,"kind":13,"name":"$sequence","line":300},{"definition":"my","line":301,"name":"$i","localvar":"my","containerName":null,"kind":13},{"line":301,"kind":12,"name":"let"},{"line":302,"name":"%pos","containerName":null,"kind":13},{"line":302,"kind":13,"containerName":null,"name":"@let"},{"line":302,"kind":13,"containerName":null,"name":"@i"},{"line":302,"kind":13,"containerName":null,"name":"$i"},{"line":305,"name":"%pos","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%pos","line":305},{"line":305,"kind":13,"containerName":null,"name":"%pos"},{"line":305,"kind":13,"containerName":null,"name":"%pos"},{"line":309,"range":{"start":{"character":0,"line":309},"end":{"character":9999,"line":316}},"kind":12,"definition":"sub","children":[{"containerName":"_freq_to_count","localvar":"my","kind":13,"name":"$h","line":310,"definition":"my"},{"line":311,"name":"$a","localvar":"my","containerName":"_freq_to_count","kind":13,"definition":"my"},{"name":"$h","kind":13,"containerName":"_freq_to_count","line":311},{"name":"$c","kind":13,"localvar":"my","containerName":"_freq_to_count","line":312,"definition":"my"},{"line":312,"name":"$h","containerName":"_freq_to_count","kind":13},{"definition":"my","line":313,"name":"$g","localvar":"my","containerName":"_freq_to_count","kind":13},{"line":313,"containerName":"_freq_to_count","kind":13,"name":"$h"},{"definition":"my","name":"$t","localvar":"my","containerName":"_freq_to_count","kind":13,"line":314},{"line":314,"name":"$h","containerName":"_freq_to_count","kind":13},{"line":315,"name":"$a","kind":13,"containerName":"_freq_to_count"},{"kind":13,"containerName":"_freq_to_count","name":"$c","line":315},{"containerName":"_freq_to_count","kind":13,"name":"$g","line":315},{"line":315,"name":"$t","containerName":"_freq_to_count","kind":13}],"containerName":"main::","name":"_freq_to_count"},{"name":"pA","kind":12,"line":311},{"name":"pC","kind":12,"line":312},{"name":"pG","kind":12,"line":313},{"line":314,"name":"pT","kind":12}],"version":5}