{"vars":[{"line":78,"kind":2,"containerName":"","name":"base"},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":100,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":100},{"name":"%args","kind":13,"localvar":"my","containerName":"new","line":101,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":101},{"line":103,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":103,"name":"$class","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"%args","line":103},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"line":105,"kind":12,"containerName":"new","name":"_set_from_args"},{"line":105,"name":"@args","containerName":"new","kind":13},{"line":107,"kind":13,"containerName":"new","name":"$self"}],"signature":{"documentation":"1;\n# $Id: Mlagan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Mlagan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Mlagan - A generic matrix with mlagan fields\n\n=head1 SYNOPSIS\n\n  # See L<Bio::Matrix::Generic> for most methods.\n  # These are relevant for mlagan IO:\n  $matrix->gap_open(-400);\n  $matrix->gap_continue(-25);\n\n=head1 DESCRIPTION\n\nThis is based on Bio::Matrix::Generic, differing by storing gap_open and\ngap_continue data members to allow mlagan IO (see Bio::Matrix::IO::mlagan).\n(Those values are 'outside' the matrix.)\n\nIt also limits the structure to a 6x6 matrix with row & column names 'A', 'C',\n'G', 'T', '.' and 'N'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Mlagan;\nuse strict;\n\nuse base qw(Bio::Matrix::Generic);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values            => arrayref of arrayrefs of data initialization\n           -matrix_id         => id of the matrix\n           -matrix_name       => name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n           -gap_open          => gap open penalty (int)\n           -gap_continue      => gap continue penalty (int)\n\n           NB: -rownames and -colnames should not be given here, since they are\n           always being set to 'A', 'C', 'G', 'T', '.' and 'N'.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"start":{"line":99,"character":0},"end":{"line":108,"character":9999}},"line":99},{"name":"SUPER","containerName":"new","kind":12,"line":103},{"name":"gap_open","containerName":"main::","children":[{"definition":"my","line":121,"name":"$self","localvar":"my","containerName":"gap_open","kind":13},{"name":"$self","containerName":"gap_open","kind":13,"line":122},{"containerName":"gap_open","kind":13,"name":"$self","line":123}],"definition":"sub","range":{"end":{"character":9999,"line":124},"start":{"line":120,"character":0}},"kind":12,"line":120},{"kind":12,"name":"gap_open","line":122},{"line":123,"kind":12,"name":"gap_open"},{"line":136,"range":{"end":{"character":9999,"line":140},"start":{"character":0,"line":136}},"kind":12,"children":[{"definition":"my","line":137,"kind":13,"localvar":"my","containerName":"gap_continue","name":"$self"},{"kind":13,"containerName":"gap_continue","name":"$self","line":138},{"name":"$self","kind":13,"containerName":"gap_continue","line":139}],"name":"gap_continue","containerName":"main::","definition":"sub"},{"line":138,"kind":12,"name":"gap_continue"},{"line":139,"name":"gap_continue","kind":12},{"definition":"sub","children":[{"name":"warn","containerName":"add_row","kind":12,"line":154}],"name":"add_row","containerName":"main::","line":153,"range":{"end":{"line":155,"character":9999},"start":{"character":0,"line":153}},"kind":12},{"line":168,"kind":12,"range":{"start":{"line":168,"character":0},"end":{"character":9999,"line":170}},"children":[{"kind":12,"containerName":"remove_row","name":"warn","line":169}],"name":"remove_row","containerName":"main::","definition":"sub"},{"children":[{"line":184,"containerName":"add_column","kind":12,"name":"warn"}],"name":"add_column","containerName":"main::","definition":"sub","line":183,"kind":12,"range":{"end":{"line":185,"character":9999},"start":{"character":0,"line":183}}},{"definition":"sub","containerName":"main::","name":"remove_column","children":[{"name":"warn","containerName":"remove_column","kind":12,"line":199}],"range":{"start":{"line":198,"character":0},"end":{"line":200,"character":9999}},"kind":12,"line":198}],"version":5}