{"vars":[{"containerName":"","kind":2,"name":"vars","line":75},{"line":78,"name":"$DEFAULTPROGRAM","kind":13,"containerName":null},{"line":78,"containerName":"","kind":2,"name":"strict"},{"line":82,"name":"base","kind":2,"containerName":""},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":96},{"line":96,"name":"@args","containerName":"new","kind":13},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":98,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":98},{"line":98,"name":"@args","containerName":"new","kind":13},{"line":99,"kind":13,"localvar":"my","containerName":"new","name":"$prog","definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":99},{"containerName":"new","kind":12,"name":"_rearrange","line":99},{"line":99,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":100},{"kind":13,"containerName":"new","name":"$prog","line":100},{"kind":13,"containerName":"new","name":"$DEFAULTPROGRAM","line":100},{"line":101,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":95,"kind":12,"range":{"end":{"character":9999,"line":102},"start":{"character":0,"line":95}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :"}},{"line":98,"kind":12,"containerName":"new","name":"SUPER"},{"line":116,"range":{"end":{"character":9999,"line":138},"start":{"line":116,"character":0}},"kind":12,"signature":{"label":"next_matrix($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($prog) = $self->_rearrange([qw(PROGRAM)], @args);\n  $self->{'_program'} = $prog || $DEFAULTPROGRAM;\n  return $self;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $parser->next_matrix\n Function: Get the next result set from parser data\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : none"},"children":[{"definition":"my","line":117,"name":"$self","kind":13,"localvar":"my","containerName":"next_matrix"},{"kind":13,"localvar":"my","containerName":"next_matrix","name":"@names","line":118,"definition":"my"},{"kind":13,"localvar":"my","containerName":"next_matrix","name":"@values","line":119,"definition":"my"},{"definition":"my","line":120,"name":"$entry","kind":13,"localvar":"my","containerName":"next_matrix"},{"kind":13,"localvar":"my","containerName":"next_matrix","name":"$size","line":121,"definition":"my"},{"name":"$entry","containerName":"next_matrix","kind":13,"line":122},{"containerName":"next_matrix","kind":13,"name":"$self","line":122},{"containerName":"next_matrix","kind":12,"name":"_readline","line":122},{"name":"$entry","containerName":"next_matrix","kind":13,"line":123},{"line":124,"name":"$self","kind":13,"containerName":"next_matrix"},{"name":"_pushback","kind":12,"containerName":"next_matrix","line":124},{"kind":13,"containerName":"next_matrix","name":"$entry","line":124},{"name":"$entry","containerName":"next_matrix","kind":13,"line":126},{"line":127,"kind":13,"containerName":"next_matrix","name":"$size"},{"line":129,"kind":13,"containerName":"next_matrix","name":"$entry"},{"name":"@line","kind":13,"localvar":"my","containerName":"next_matrix","line":130,"definition":"my"},{"kind":13,"containerName":"next_matrix","name":"$entry","line":130},{"name":"$values","containerName":"next_matrix","kind":13,"line":131},{"line":131,"name":"@line","containerName":"next_matrix","kind":13},{"definition":"my","line":134,"name":"$n","kind":13,"localvar":"my","containerName":"next_matrix"},{"line":134,"containerName":"next_matrix","kind":13,"name":"@line"},{"kind":13,"containerName":"next_matrix","name":"$entry","line":134},{"line":136,"name":"@names","kind":13,"containerName":"next_matrix"},{"line":136,"name":"$n","kind":13,"containerName":"next_matrix"},{"name":"@values","kind":13,"containerName":"next_matrix","line":137},{"name":"@line","kind":13,"containerName":"next_matrix","line":137}],"containerName":"main::","name":"next_matrix","definition":"sub","detail":"($self)"},{"name":"names","kind":12,"line":123},{"line":139,"containerName":null,"kind":13,"name":"@names"},{"line":139,"name":"%size","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":140},{"name":"warn","kind":12,"containerName":"main::","line":140},{"line":140,"name":"@names","containerName":null,"kind":13},{"name":"names","kind":12,"line":143},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"%dist","line":144},{"name":"$i","localvar":"my","containerName":null,"kind":13,"line":145,"definition":"my"},{"line":146,"containerName":null,"localvar":"my","kind":13,"name":"$name","definition":"my"},{"containerName":null,"kind":13,"name":"@names","line":146},{"localvar":"my","kind":13,"containerName":null,"name":"$j","line":147,"definition":"my"},{"name":"$n","kind":13,"localvar":"my","containerName":null,"line":148,"definition":"my"},{"line":148,"kind":13,"containerName":null,"name":"@names"},{"line":149,"name":"%dist","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%name","line":149},{"line":149,"name":"@n","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$i","line":149},{"line":149,"name":"$j","kind":13,"containerName":null},{"name":"$j","kind":13,"containerName":null,"line":150},{"name":"$i","kind":13,"containerName":null,"line":152},{"definition":"my","name":"$matrix","localvar":"my","kind":13,"containerName":null,"line":154},{"name":"Bio","containerName":"Matrix::PhylipDist","kind":12,"line":154},{"line":155,"kind":12,"containerName":"main::","name":"new"},{"line":155,"containerName":null,"kind":13,"name":"%self"},{"name":"%dist","kind":13,"containerName":null,"line":156},{"kind":13,"containerName":null,"name":"@names","line":157},{"name":"@values","kind":13,"containerName":null,"line":158},{"containerName":null,"kind":13,"name":"$matrix","line":159},{"signature":{"parameters":[{"label":"$self"},{"label":"@matricies"}],"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($prog) = $self->_rearrange([qw(PROGRAM)], @args);\n  $self->{'_program'} = $prog || $DEFAULTPROGRAM;\n  return $self;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $parser->next_matrix\n Function: Get the next result set from parser data\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : none\n\n\n\nsub next_matrix {\n   my ($self) = @_;\n   my @names;\n   my @values;\n   my $entry;\n   my $size = 0;\n   while ($entry=$self->_readline) {\n       if($#names >=0 && $entry =~/^\\s+\\d+\\n$/){\n\t   $self->_pushback($entry);\n\t   last;\n       } elsif($entry=~/^\\s+(\\d+)\\n$/){\t   \n\t   $size = $1;\n\t   next;\n       } elsif( $entry =~ s/^\\s+(\\-?\\d+\\.\\d+)/$1/ ) {\n\t   my (@line) = split( /\\s+/,$entry);\n\t   push @{$values[-1]}, @line;\n\t   next;\n       }\n       my ($n,@line) = split( /\\s+/,$entry);\n       \n       push @names, $n;\n       push @values, [@line];\n   }\n   if( scalar @names != $size ) {\n       $self->warn(\"The number of entries \".(scalar @names).\n\t\t   \" is not the same $size\");\n   }\n   $#names>=0 || return;\n   my %dist;\n   my $i=0;\n   foreach my $name(@names){\n       my $j=0;\n       foreach my $n(@names) {\n\t   $dist{$name}{$n} = [$i,$j];\n\t   $j++;\n       }\n       $i++;\n   }\n   my $matrix = Bio::Matrix::PhylipDist->new\n       (-matrix_name => $self->{'_program'},\n\t-matrix      => \\%dist,\n\t-names       => \\@names,\n\t-values      => \\@values);\n    return $matrix;\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $matio->write_matrix($matrix)\n Function: Write out a matrix in the phylip distance format\n Returns : none\n Args    : L<Bio::Matrix::PhylipDist>","label":"write_matrix($self,@matricies)"},"line":173,"kind":12,"range":{"end":{"line":177,"character":9999},"start":{"line":173,"character":0}},"definition":"sub","detail":"($self,@matricies)","children":[{"definition":"my","line":174,"name":"$self","kind":13,"localvar":"my","containerName":"write_matrix"},{"line":174,"name":"@matricies","kind":13,"containerName":"write_matrix"},{"definition":"my","localvar":"my","containerName":"write_matrix","kind":13,"name":"$matrix","line":175},{"name":"@matricies","containerName":"write_matrix","kind":13,"line":175},{"name":"@names","kind":13,"localvar":"my","containerName":"write_matrix","line":176,"definition":"my"},{"line":176,"name":"$matrix","kind":13,"containerName":"write_matrix"},{"line":176,"name":"names","containerName":"write_matrix","kind":12},{"line":177,"kind":13,"localvar":"my","containerName":"write_matrix","name":"@values","definition":"my"},{"line":177,"name":"$matrix","kind":13,"containerName":"write_matrix"},{"line":177,"name":"_values","kind":12,"containerName":"write_matrix"}],"name":"write_matrix","containerName":"main::"},{"line":178,"name":"%matrix","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"$matrix","line":178},{"line":178,"kind":12,"containerName":"main::","name":"_matrix"},{"definition":"my","line":179,"localvar":"my","kind":13,"containerName":null,"name":"$str"},{"kind":13,"containerName":null,"name":"$str","line":180},{"kind":13,"containerName":null,"name":"@names","line":180},{"line":181,"kind":13,"localvar":"my","containerName":null,"name":"$name","definition":"my"},{"kind":13,"containerName":null,"name":"@names","line":181},{"definition":"my","line":182,"localvar":"my","containerName":null,"kind":13,"name":"$newname"},{"kind":13,"containerName":null,"name":"$name","line":182},{"name":"$name","kind":13,"containerName":null,"line":182},{"name":"%name","containerName":null,"kind":13,"line":183},{"line":183,"name":"$newname","kind":13,"containerName":null},{"line":184,"name":"$str","containerName":null,"kind":13},{"name":"$newname","containerName":null,"kind":13,"line":184},{"definition":"my","line":185,"name":"$count","localvar":"my","containerName":null,"kind":13},{"line":186,"localvar":"my","kind":13,"containerName":null,"name":"$n","definition":"my"},{"line":186,"containerName":null,"kind":13,"name":"@names"},{"definition":"my","line":187,"localvar":"my","containerName":null,"kind":13,"name":"$i"},{"line":187,"kind":13,"containerName":null,"name":"$j"},{"line":187,"containerName":null,"kind":13,"name":"%matrix"},{"line":187,"name":"%name","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$n","line":187},{"line":188,"kind":13,"containerName":null,"name":"$count"},{"kind":12,"name":"names","line":188},{"line":189,"containerName":null,"kind":13,"name":"$str"},{"name":"@values","kind":13,"containerName":null,"line":189},{"containerName":null,"kind":13,"name":"@i","line":189},{"containerName":null,"kind":13,"name":"%j","line":189},{"containerName":null,"kind":13,"name":"$str","line":192},{"name":"@values","containerName":null,"kind":13,"line":192},{"kind":13,"containerName":null,"name":"@i","line":192},{"line":192,"name":"$j","kind":13,"containerName":null},{"line":194,"containerName":null,"kind":13,"name":"$count"},{"name":"$str","containerName":null,"kind":13,"line":196},{"name":"$self","containerName":null,"kind":13,"line":198},{"containerName":"main::","kind":12,"name":"_print","line":198},{"kind":13,"containerName":null,"name":"$str","line":198}],"version":5}