{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":79},{"kind":12,"range":{"end":{"line":123,"character":9999},"start":{"character":0,"line":101}},"line":101,"definition":"sub","containerName":"main::","name":"next_matrix","children":[{"definition":"my","localvar":"my","containerName":"next_matrix","kind":13,"name":"$self","line":102},{"definition":"my","line":104,"localvar":"my","kind":13,"containerName":"next_matrix","name":"@matrix"},{"name":"$gap_open","containerName":"next_matrix","kind":13,"line":104},{"line":104,"name":"$gap_cont","containerName":"next_matrix","kind":13},{"line":105,"containerName":"next_matrix","kind":13,"name":"$self"},{"line":105,"name":"_readline","kind":12,"containerName":"next_matrix"},{"line":107,"name":"@values","kind":13,"localvar":"my","containerName":"next_matrix","definition":"my"},{"line":108,"name":"@matrix","containerName":"next_matrix","kind":13},{"line":108,"name":"@values","kind":13,"containerName":"next_matrix"},{"name":"$gap_open","kind":13,"containerName":"next_matrix","line":111},{"name":"$gap_cont","kind":13,"containerName":"next_matrix","line":111},{"kind":13,"containerName":"next_matrix","name":"@matrix","line":116},{"name":"$self","containerName":"next_matrix","kind":13,"line":116},{"name":"throw","containerName":"next_matrix","kind":12,"line":116},{"definition":"my","line":118,"name":"$matrix","containerName":"next_matrix","localvar":"my","kind":13},{"line":118,"name":"new","containerName":"next_matrix","kind":12},{"kind":13,"containerName":"next_matrix","name":"@matrix","line":118},{"name":"$gap_open","kind":13,"containerName":"next_matrix","line":119},{"name":"$gap_cont","containerName":"next_matrix","kind":13,"line":120},{"line":122,"name":"$matrix","containerName":"next_matrix","kind":13}]},{"kind":12,"containerName":"Matrix::Mlagan","name":"Bio","line":118},{"range":{"start":{"character":0,"line":135},"end":{"character":9999,"line":160}},"kind":12,"line":135,"signature":{"parameters":[{"label":"$self"},{"label":"$matrix"}],"documentation":"1;\n# $Id: mlagan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::mlagan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::mlagan - A parser for the mlagan substitution matrix\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'mlagan',\n                                   -file   => 'nucmatrix.txt');\n  my $matrix = $parser->next_matrix;\n  my $gap_open = $parser->gap_open;\n  my $gap_continue = $parser->gap_continue;\n\n=head1 DESCRIPTION\n\nUse to read in and write out substitution matrix files suitable for use by\nmlagan.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Matrix::IO::mlagan;\nuse strict;\n\nuse Bio::Matrix::Mlagan;\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::mlagan->new();\n Function: Builds a new Bio::Matrix::IO::mlagan object \n Returns : an instance of Bio::Matrix::IO::mlagan\n Args    :\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $obj->next_matrix();\n Function: parses a matrix file\n Returns : L<Bio::Matrix::Mlagan>\n Args    : none\n\n\nsub next_matrix {\n    my $self = shift;\n    \n    my (@matrix, $gap_open, $gap_cont);\n    while (defined ($_ = $self->_readline)) {\n        if (/^[ACGTN\\.]/) {\n            my (undef, @values) = split;\n            push(@matrix, \\@values);\n        }\n        elsif (/^[-\\d]/) {\n            ($gap_open, $gap_cont) = split;\n            last;\n        }\n    }\n    \n    @matrix == 6 || $self->throw(\"Something wrong with file, was it the correct format?\");\n    \n    my $matrix = Bio::Matrix::Mlagan->new(-values => \\@matrix,\n                                          -gap_open => $gap_open,\n                                          -gap_continue => $gap_cont);\n    \n    return $matrix;\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $obj->write_matrix($matrix)\n Function: Write out a matrix in mlagan format\n Returns : n/a\n Args    : L<Bio::Matrix::Generic>","label":"write_matrix($self,$matrix)"},"name":"write_matrix","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"write_matrix","line":136},{"name":"$matrix","containerName":"write_matrix","kind":13,"line":136},{"containerName":"write_matrix","kind":13,"name":"$matrix","line":137},{"name":"$self","kind":13,"containerName":"write_matrix","line":137},{"name":"throw","containerName":"write_matrix","kind":12,"line":137},{"line":138,"name":"$gap_open","localvar":"my","containerName":"write_matrix","kind":13,"definition":"my"},{"name":"$matrix","kind":13,"containerName":"write_matrix","line":138},{"line":138,"containerName":"write_matrix","kind":12,"name":"gap_open"},{"line":139,"localvar":"my","kind":13,"containerName":"write_matrix","name":"$gap_continue","definition":"my"},{"kind":13,"containerName":"write_matrix","name":"$matrix","line":139},{"containerName":"write_matrix","kind":12,"name":"gap_continue","line":139},{"name":"$gap_open","containerName":"write_matrix","kind":13,"line":141},{"name":"$gap_continue","kind":13,"containerName":"write_matrix","line":141},{"name":"$self","kind":13,"containerName":"write_matrix","line":142},{"line":142,"name":"throw","kind":12,"containerName":"write_matrix"},{"containerName":"write_matrix","kind":13,"name":"$self","line":145},{"line":145,"name":"_print","kind":12,"containerName":"write_matrix"},{"definition":"my","line":147,"name":"$char","localvar":"my","kind":13,"containerName":"write_matrix"},{"line":148,"containerName":"write_matrix","localvar":"my","kind":13,"name":"@row","definition":"my"},{"name":"$matrix","containerName":"write_matrix","kind":13,"line":148},{"name":"get_row","containerName":"write_matrix","kind":12,"line":148},{"name":"$char","kind":13,"containerName":"write_matrix","line":148},{"line":149,"localvar":"my","containerName":"write_matrix","kind":13,"name":"$row","definition":"my"},{"name":"$char","containerName":"write_matrix","kind":13,"line":149},{"line":150,"localvar":"my","kind":13,"containerName":"write_matrix","name":"$val","definition":"my"},{"name":"@row","containerName":"write_matrix","kind":13,"line":150},{"line":151,"name":"$row","kind":13,"containerName":"write_matrix"},{"containerName":"write_matrix","kind":13,"name":"$val","line":151},{"containerName":"write_matrix","kind":13,"name":"$val","line":151},{"kind":13,"containerName":"write_matrix","name":"$self","line":154},{"kind":12,"containerName":"write_matrix","name":"_print","line":154},{"line":154,"containerName":"write_matrix","kind":13,"name":"$row"},{"kind":13,"containerName":"write_matrix","name":"$self","line":157},{"line":157,"kind":12,"containerName":"write_matrix","name":"_print"}],"detail":"($self,$matrix)","definition":"sub"}]}