{"vars":[{"line":82,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($caller,@args)","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$caller","line":96},{"line":96,"name":"@args","kind":13,"containerName":"new"},{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":97,"definition":"my"},{"line":97,"kind":13,"containerName":"new","name":"$caller"},{"line":97,"name":"$caller","kind":13,"containerName":"new"},{"line":101,"kind":13,"containerName":"new","name":"$class"},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":102},{"line":102,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":102},{"name":"$self","containerName":"new","kind":13,"line":103},{"containerName":"new","kind":12,"name":"_initialize","line":103},{"name":"@args","kind":13,"containerName":"new","line":103},{"line":104,"kind":13,"containerName":"new","name":"$self"},{"definition":"my","line":107,"containerName":"new","localvar":"my","kind":13,"name":"%param"},{"kind":13,"containerName":"new","name":"@args","line":107},{"kind":13,"containerName":"new","name":"@param","line":108},{"line":108,"kind":13,"containerName":"new","name":"%param"},{"name":"%param","kind":13,"containerName":"new","line":108},{"kind":13,"localvar":"my","containerName":"new","name":"$format","line":109,"definition":"my"},{"line":109,"name":"$param","kind":13,"containerName":"new"},{"line":110,"kind":13,"containerName":"new","name":"$class"},{"line":110,"kind":12,"containerName":"new","name":"_guess_format"},{"line":110,"kind":13,"containerName":"new","name":"$param"},{"line":110,"name":"$ARGV","kind":13,"containerName":"new"},{"line":112,"name":"$format","kind":13,"containerName":"new"},{"line":115,"name":"$class","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_load_format_module","line":115},{"name":"$format","kind":13,"containerName":"new","line":115},{"name":"new","containerName":"new","kind":12,"line":116},{"line":116,"name":"@args","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :"},"line":95,"kind":12,"range":{"end":{"line":118,"character":9999},"start":{"line":95,"character":0}}},{"kind":12,"containerName":"new","name":"SUPER","line":102},{"name":"newFh","containerName":"main::","children":[{"line":134,"name":"$class","kind":13,"localvar":"my","containerName":"newFh","definition":"my"},{"definition":"my","line":135,"name":"$self","kind":13,"localvar":"my","containerName":"newFh"},{"name":"$class","containerName":"newFh","kind":13,"line":135},{"line":135,"name":"new","containerName":"newFh","kind":12},{"name":"$self","containerName":"newFh","kind":13,"line":136},{"line":136,"kind":12,"containerName":"newFh","name":"fh"}],"definition":"sub","kind":12,"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":133}},"line":133},{"name":"fh","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"fh","kind":13,"line":154},{"definition":"my","name":"$class","localvar":"my","containerName":"fh","kind":13,"line":155},{"line":155,"containerName":"fh","kind":13,"name":"$self"},{"line":155,"name":"$self","containerName":"fh","kind":13},{"definition":"my","containerName":"fh","localvar":"my","kind":13,"name":"$s","line":156},{"name":"$class","containerName":"fh","kind":13,"line":157},{"containerName":"fh","kind":13,"name":"$self","line":157},{"name":"$s","containerName":"fh","kind":13,"line":158}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":153},"end":{"line":159,"character":9999}},"line":153},{"line":157,"kind":12,"containerName":"gensym","name":"Symbol"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_matrix","line":174,"definition":"my"},{"line":175,"containerName":"next_matrix","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"next_matrix","line":175}],"containerName":"main::","name":"next_matrix","definition":"sub","detail":"($self)","line":173,"range":{"end":{"line":176,"character":9999},"start":{"line":173,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none","parameters":[{"label":"$self"}],"label":"next_matrix($self)"}},{"children":[{"kind":13,"localvar":"my","containerName":"write_matrix","name":"$self","line":191,"definition":"my"},{"line":192,"containerName":"write_matrix","kind":13,"name":"$self"},{"line":192,"kind":12,"containerName":"write_matrix","name":"throw_not_implemented"}],"containerName":"main::","name":"write_matrix","definition":"sub","detail":"($self)","line":190,"kind":12,"range":{"end":{"character":9999,"line":193},"start":{"line":190,"character":0}},"signature":{"label":"write_matrix($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none\n\n\n\nsub next_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $io->write_matrix($matrix)\n Function: Writes a matrix out to the data stream\n Returns : none\n Args    : Array of Bio::Matrix::MatrixI object\n          - note that not all matricies can be converted to \n            each format, beware with mixing matrix types and output formats"}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"line":195,"range":{"end":{"character":9999,"line":198},"start":{"line":195,"character":0}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$self","line":196},{"name":"@args","containerName":"_initialize","kind":13,"line":196},{"line":197,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"_initialize_io","containerName":"_initialize","kind":12,"line":197},{"line":197,"name":"@args","containerName":"_initialize","kind":13}],"containerName":"main::","name":"_initialize"},{"line":208,"kind":12,"range":{"end":{"line":227,"character":9999},"start":{"line":208,"character":0}},"signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none\n\n\n\nsub next_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $io->write_matrix($matrix)\n Function: Writes a matrix out to the data stream\n Returns : none\n Args    : Array of Bio::Matrix::MatrixI object\n          - note that not all matricies can be converted to \n            each format, beware with mixing matrix types and output formats\n\n\nsub write_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->_initialize_io(@args);\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Matrix::IO stuff*\n Function: Loads up (like use) a module at run time on demand","parameters":[{"label":"$self"},{"label":"$format"}]},"children":[{"definition":"my","line":209,"containerName":"_load_format_module","localvar":"my","kind":13,"name":"$self"},{"line":209,"kind":13,"containerName":"_load_format_module","name":"$format"},{"containerName":"_load_format_module","localvar":"my","kind":13,"name":"$module","line":210,"definition":"my"},{"name":"$format","kind":13,"containerName":"_load_format_module","line":210},{"line":211,"name":"$ok","localvar":"my","kind":13,"containerName":"_load_format_module","definition":"my"},{"line":214,"kind":13,"containerName":"_load_format_module","name":"$ok"},{"name":"$self","kind":13,"containerName":"_load_format_module","line":214},{"line":214,"kind":12,"containerName":"_load_format_module","name":"_load_module"},{"line":214,"name":"$module","kind":13,"containerName":"_load_format_module"},{"line":226,"name":"$ok","containerName":"_load_format_module","kind":13}],"name":"_load_format_module","containerName":"main::","definition":"sub","detail":"($self,$format)"},{"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":239}},"kind":12,"line":239,"name":"_guess_format","containerName":"main::","children":[{"line":240,"name":"$class","containerName":"_guess_format","localvar":"my","kind":13,"definition":"my"}],"definition":"sub"},{"line":246,"kind":12,"range":{"start":{"character":0,"line":246},"end":{"character":9999,"line":249}},"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"DESTROY","name":"$self","line":247},{"line":248,"kind":13,"containerName":"DESTROY","name":"$self"},{"line":248,"kind":12,"containerName":"DESTROY","name":"close"}],"name":"DESTROY","containerName":"main::"},{"kind":12,"range":{"start":{"character":0,"line":251},"end":{"character":9999,"line":254}},"line":251,"containerName":"main::","name":"TIEHANDLE","children":[{"definition":"my","line":252,"name":"$class","containerName":"TIEHANDLE","localvar":"my","kind":13},{"line":253,"name":"$class","kind":13,"containerName":"TIEHANDLE"}],"definition":"sub"},{"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"READLINE","name":"$self","line":257},{"containerName":"READLINE","kind":13,"name":"$self","line":258},{"kind":12,"containerName":"READLINE","name":"next_tree","line":258},{"definition":"my","name":"@list","containerName":"READLINE","localvar":"my","kind":13,"line":259},{"line":259,"kind":13,"containerName":"READLINE","name":"$obj"},{"line":260,"containerName":"READLINE","kind":13,"name":"@list"},{"name":"$obj","containerName":"READLINE","kind":13,"line":260},{"line":260,"kind":13,"containerName":"READLINE","name":"$obj"},{"containerName":"READLINE","kind":13,"name":"$self","line":260},{"line":260,"name":"next_tree","kind":12,"containerName":"READLINE"},{"line":261,"containerName":"READLINE","kind":13,"name":"@list"}],"name":"READLINE","containerName":"main::","line":256,"range":{"start":{"character":0,"line":256},"end":{"character":9999,"line":262}},"kind":12},{"name":"PRINT","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"PRINT","kind":13,"line":265,"definition":"my"},{"name":"$self","containerName":"PRINT","kind":13,"line":266},{"line":266,"name":"write_tree","containerName":"PRINT","kind":12}],"definition":"sub","range":{"start":{"character":0,"line":264},"end":{"line":267,"character":9999}},"kind":12,"line":264}],"version":5}