{"vars":[{"line":83,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($caller,@args)","children":[{"name":"$caller","containerName":"new","localvar":"my","kind":13,"line":97,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":97},{"definition":"my","line":99,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"name":"$caller","kind":13,"containerName":"new","line":99},{"line":99,"name":"$caller","kind":13,"containerName":"new"},{"line":103,"kind":13,"containerName":"new","name":"$class"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":104},{"line":104,"name":"$class","containerName":"new","kind":13},{"line":104,"name":"@args","containerName":"new","kind":13},{"line":105,"name":"$self","kind":13,"containerName":"new"},{"line":105,"containerName":"new","kind":12,"name":"_initialize"},{"name":"@args","kind":13,"containerName":"new","line":105},{"line":106,"name":"$self","kind":13,"containerName":"new"},{"definition":"my","name":"%param","containerName":"new","localvar":"my","kind":13,"line":109},{"name":"@args","kind":13,"containerName":"new","line":109},{"name":"@param","kind":13,"containerName":"new","line":110},{"line":110,"name":"%param","kind":13,"containerName":"new"},{"line":110,"containerName":"new","kind":13,"name":"%param"},{"line":111,"name":"$format","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"name":"$param","containerName":"new","kind":13,"line":111},{"name":"$class","containerName":"new","kind":13,"line":112},{"name":"_guess_format","containerName":"new","kind":12,"line":112},{"line":112,"name":"$param","kind":13,"containerName":"new"},{"name":"$ARGV","kind":13,"containerName":"new","line":112},{"name":"$format","kind":13,"containerName":"new","line":114},{"kind":13,"containerName":"new","name":"$class","line":117},{"name":"_load_format_module","containerName":"new","kind":12,"line":117},{"line":117,"containerName":"new","kind":13,"name":"$format"},{"name":"new","containerName":"new","kind":12,"line":118},{"kind":13,"containerName":"new","name":"@args","line":118}],"name":"new","containerName":"main::","signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :","parameters":[{"label":"$caller"},{"label":"@args"}]},"line":96,"kind":12,"range":{"end":{"character":9999,"line":121},"start":{"character":0,"line":96}}},{"line":104,"kind":12,"containerName":"new","name":"SUPER"},{"signature":{"documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>","parameters":[{"label":"$self"},{"label":"$handler"}],"label":"attach_EventHandler($self,$handler)"},"line":157,"kind":12,"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":165}},"definition":"sub","detail":"($self,$handler)","children":[{"line":158,"containerName":"attach_EventHandler","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":158},{"name":"$handler","kind":13,"containerName":"attach_EventHandler","line":159},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":160},{"line":160,"containerName":"attach_EventHandler","kind":12,"name":"isa"},{"line":161,"name":"$self","containerName":"attach_EventHandler","kind":13},{"containerName":"attach_EventHandler","kind":12,"name":"warn","line":161},{"containerName":"attach_EventHandler","kind":13,"name":"$handler","line":161},{"line":163,"name":"$self","containerName":"attach_EventHandler","kind":13},{"line":163,"name":"$handler","containerName":"attach_EventHandler","kind":13}],"name":"attach_EventHandler","containerName":"main::"},{"line":178,"range":{"end":{"line":181,"character":9999},"start":{"line":178,"character":0}},"kind":12,"signature":{"label":"_eventHandler($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n\t$self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : L<Bio::Event::EventHandlerI>\n Args    : none"},"children":[{"definition":"my","containerName":"_eventHandler","localvar":"my","kind":13,"name":"$self","line":179},{"line":180,"name":"$self","kind":13,"containerName":"_eventHandler"}],"containerName":"main::","name":"_eventHandler","definition":"sub","detail":"($self)"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"line":184,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":184},{"line":185,"name":"$self","containerName":"_initialize","kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":188},{"line":188,"name":"_initialize_io","containerName":"_initialize","kind":12},{"containerName":"_initialize","kind":13,"name":"@args","line":188}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"range":{"start":{"character":0,"line":183},"end":{"line":190,"character":9999}},"kind":12,"line":183},{"kind":12,"range":{"end":{"line":220,"character":9999},"start":{"character":0,"line":203}},"line":203,"signature":{"documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n\t$self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : L<Bio::Event::EventHandlerI>\n Args    : none\n\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    \n    # initialize the IO part\n    $self->_initialize_io(@args);\n#    $self->attach_EventHandler(Bio::MapIO::MapEventBuilder->new());\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL MapIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}],"label":"_load_format_module($self,$format)"},"name":"_load_format_module","containerName":"main::","children":[{"definition":"my","line":204,"name":"$self","containerName":"_load_format_module","localvar":"my","kind":13},{"name":"$format","containerName":"_load_format_module","kind":13,"line":204},{"definition":"my","name":"$module","localvar":"my","containerName":"_load_format_module","kind":13,"line":205},{"line":205,"name":"$format","kind":13,"containerName":"_load_format_module"},{"localvar":"my","containerName":"_load_format_module","kind":13,"name":"$ok","line":206,"definition":"my"},{"line":208,"name":"$ok","kind":13,"containerName":"_load_format_module"},{"line":208,"containerName":"_load_format_module","kind":13,"name":"$self"},{"name":"_load_module","containerName":"_load_format_module","kind":12,"line":208},{"name":"$module","containerName":"_load_format_module","kind":13,"line":208},{"line":219,"name":"$ok","containerName":"_load_format_module","kind":13}],"detail":"($self,$format)","definition":"sub"},{"line":234,"kind":12,"range":{"end":{"line":239,"character":9999},"start":{"character":0,"line":234}},"children":[{"line":235,"name":"$class","kind":13,"localvar":"my","containerName":"_guess_format","definition":"my"}],"name":"_guess_format","containerName":"main::","definition":"sub"},{"line":241,"range":{"end":{"line":245,"character":9999},"start":{"character":0,"line":241}},"kind":12,"definition":"sub","children":[{"containerName":"DESTROY","localvar":"my","kind":13,"name":"$self","line":242,"definition":"my"},{"name":"$self","kind":13,"containerName":"DESTROY","line":244},{"name":"close","kind":12,"containerName":"DESTROY","line":244}],"name":"DESTROY","containerName":"main::"}],"version":5}