{"vars":[{"line":101,"name":"Util","kind":2,"containerName":"strict::Scalar"},{"name":"base","containerName":"","kind":2,"line":103},{"range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":130}},"kind":12,"line":130,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)"},"containerName":"main::","name":"new","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":131},{"containerName":"new","kind":13,"name":"@args","line":131},{"definition":"my","line":132,"name":"$self","containerName":"new","localvar":"my","kind":13},{"name":"$class","containerName":"new","kind":13,"line":132},{"name":"@args","containerName":"new","kind":13,"line":132},{"name":"$map","localvar":"my","containerName":"new","kind":13,"line":134,"definition":"my"},{"line":134,"containerName":"new","kind":13,"name":"$element"},{"line":134,"name":"$position","containerName":"new","kind":13},{"line":134,"name":"$desc","containerName":"new","kind":13},{"line":135,"name":"$self","containerName":"new","kind":13},{"name":"_rearrange","kind":12,"containerName":"new","line":135},{"kind":13,"containerName":"new","name":"@args","line":135},{"containerName":"new","kind":13,"name":"$map","line":137},{"line":137,"containerName":"new","kind":13,"name":"$element"},{"line":137,"containerName":"new","kind":13,"name":"$position"},{"name":"$self","kind":13,"containerName":"new","line":138},{"containerName":"new","kind":12,"name":"throw","line":138},{"containerName":"new","kind":13,"name":"$map","line":141},{"line":141,"kind":13,"containerName":"new","name":"$self"},{"line":141,"containerName":"new","kind":12,"name":"map"},{"line":141,"name":"$map","kind":13,"containerName":"new"},{"line":142,"kind":13,"containerName":"new","name":"$element"},{"name":"$self","containerName":"new","kind":13,"line":142},{"name":"element","containerName":"new","kind":12,"line":142},{"line":142,"kind":13,"containerName":"new","name":"$element"},{"containerName":"new","kind":13,"name":"$position","line":143},{"containerName":"new","kind":13,"name":"$self","line":143},{"containerName":"new","kind":12,"name":"position","line":143},{"kind":13,"containerName":"new","name":"$position","line":143},{"line":144,"name":"$desc","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":144},{"line":144,"containerName":"new","kind":12,"name":"description"},{"line":144,"containerName":"new","kind":13,"name":"$desc"},{"containerName":"new","kind":13,"name":"$self","line":146}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":132},{"definition":"sub","detail":"($self,$pos)","children":[{"definition":"my","line":161,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$self"},{"kind":13,"containerName":"absolute_conversion","name":"$pos","line":161},{"name":"$self","containerName":"absolute_conversion","kind":13,"line":162},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":162},{"containerName":"absolute_conversion","kind":13,"name":"$pos","line":162},{"containerName":"absolute_conversion","kind":13,"name":"$self","line":163},{"line":163,"name":"throw","containerName":"absolute_conversion","kind":12},{"line":163,"kind":13,"containerName":"absolute_conversion","name":"$pos"},{"line":163,"name":"isa","kind":12,"containerName":"absolute_conversion"},{"line":166,"name":"$prior_abs","localvar":"my","containerName":"absolute_conversion","kind":13,"definition":"my"},{"name":"$pos","containerName":"absolute_conversion","kind":13,"line":166},{"kind":12,"containerName":"absolute_conversion","name":"absolute","line":166},{"line":167,"name":"$pos","kind":13,"containerName":"absolute_conversion"},{"name":"absolute","kind":12,"containerName":"absolute_conversion","line":167},{"name":"$prior_abs","kind":13,"containerName":"absolute_conversion","line":167},{"line":168,"name":"$raw","containerName":"absolute_conversion","localvar":"my","kind":13,"definition":"my"},{"line":168,"name":"$pos","containerName":"absolute_conversion","kind":13},{"line":168,"name":"start","kind":12,"containerName":"absolute_conversion"},{"kind":13,"containerName":"absolute_conversion","name":"$pos","line":169},{"name":"absolute","containerName":"absolute_conversion","kind":12,"line":169},{"containerName":"absolute_conversion","kind":13,"name":"$prior_abs","line":169},{"kind":13,"containerName":"absolute_conversion","name":"$prior_abs","line":169},{"name":"$self","containerName":"absolute_conversion","kind":13,"line":170},{"line":170,"name":"throw","kind":12,"containerName":"absolute_conversion"},{"name":"$raw","containerName":"absolute_conversion","kind":13,"line":170},{"name":"$type","localvar":"my","containerName":"absolute_conversion","kind":13,"line":173,"definition":"my"},{"name":"$self","containerName":"absolute_conversion","kind":13,"line":173},{"containerName":"absolute_conversion","kind":12,"name":"type","line":173},{"definition":"my","line":174,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$value"},{"line":174,"name":"$self","kind":13,"containerName":"absolute_conversion"},{"containerName":"absolute_conversion","kind":13,"name":"$type","line":174},{"line":175,"kind":13,"containerName":"absolute_conversion","name":"$self"},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":175},{"name":"$type","containerName":"absolute_conversion","kind":13,"line":175},{"line":175,"name":"$value","kind":13,"containerName":"absolute_conversion"},{"definition":"my","line":178,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$map"},{"line":178,"kind":13,"containerName":"absolute_conversion","name":"$pos"},{"line":178,"kind":12,"containerName":"absolute_conversion","name":"map"},{"line":179,"name":"$type","kind":13,"containerName":"absolute_conversion"},{"kind":13,"containerName":"absolute_conversion","name":"$self","line":180},{"containerName":"absolute_conversion","kind":12,"name":"throw","line":180},{"name":"$map","kind":13,"containerName":"absolute_conversion","line":180},{"line":181,"name":"@positions","containerName":"absolute_conversion","localvar":"my","kind":13,"definition":"my"},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":181},{"line":181,"name":"get_positions","kind":12,"containerName":"absolute_conversion"},{"kind":13,"containerName":"absolute_conversion","name":"$map","line":181},{"line":182,"containerName":"absolute_conversion","kind":13,"name":"$value"},{"line":182,"name":"@positions","kind":13,"containerName":"absolute_conversion"},{"containerName":"absolute_conversion","kind":13,"name":"$self","line":183},{"line":183,"name":"throw","kind":12,"containerName":"absolute_conversion"},{"line":183,"kind":13,"containerName":"absolute_conversion","name":"$value"},{"line":185,"name":"$value","containerName":"absolute_conversion","kind":13},{"line":187,"localvar":"my","containerName":"absolute_conversion","kind":13,"name":"$rel","definition":"my"},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":187},{"containerName":"absolute_conversion","kind":12,"name":"relative","line":187},{"line":188,"kind":13,"containerName":"absolute_conversion","name":"$value"},{"kind":13,"containerName":"absolute_conversion","name":"$rel","line":188},{"containerName":"absolute_conversion","kind":12,"name":"absolute_conversion","line":188},{"containerName":"absolute_conversion","kind":13,"name":"$value","line":188},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":191},{"containerName":"absolute_conversion","kind":13,"name":"$value","line":192},{"containerName":"absolute_conversion","kind":13,"name":"$raw","line":192}],"containerName":"main::","name":"absolute_conversion","signature":{"parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object","label":"absolute_conversion($self,$pos)"},"line":160,"kind":12,"range":{"start":{"character":0,"line":160},"end":{"character":9999,"line":195}}},{"containerName":"main::","name":"type","children":[{"definition":"my","line":214,"kind":13,"localvar":"my","containerName":"type","name":"$self"},{"name":"$self","containerName":"type","kind":13,"line":215}],"definition":"sub","range":{"end":{"character":9999,"line":216},"start":{"line":213,"character":0}},"kind":12,"line":213},{"name":"_use","kind":12,"line":215},{"definition":"sub","detail":"($self,$num)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"map","line":232},{"line":232,"name":"$num","kind":13,"containerName":"map"},{"line":233,"name":"$num","containerName":"map","kind":13},{"line":234,"kind":13,"containerName":"map","name":"$self"},{"line":234,"name":"throw","containerName":"map","kind":12},{"name":"$num","kind":13,"containerName":"map","line":234},{"containerName":"map","kind":13,"name":"$self","line":235},{"containerName":"map","kind":13,"name":"$self","line":236},{"name":"$num","containerName":"map","kind":13,"line":236},{"line":238,"containerName":"map","kind":13,"name":"$self"},{"name":"$self","containerName":"map","kind":13,"line":238}],"containerName":"main::","name":"map","signature":{"parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.","label":"map($self,$num)"},"line":231,"range":{"end":{"character":9999,"line":239},"start":{"line":231,"character":0}},"kind":12},{"kind":12,"name":"looks_like_number","line":234},{"kind":12,"name":"_use","line":235},{"line":236,"name":"_map","kind":12},{"line":238,"name":"_map","kind":12},{"line":238,"name":"_map","kind":12},{"detail":"($self,$element)","definition":"sub","name":"element","containerName":"main::","children":[{"line":256,"localvar":"my","kind":13,"containerName":"element","name":"$self","definition":"my"},{"line":256,"name":"$element","kind":13,"containerName":"element"},{"containerName":"element","kind":13,"name":"$element","line":257},{"line":258,"containerName":"element","kind":13,"name":"$self"},{"line":258,"containerName":"element","kind":12,"name":"throw"},{"line":258,"kind":13,"containerName":"element","name":"$element"},{"kind":13,"containerName":"element","name":"$self","line":259},{"name":"throw","kind":12,"containerName":"element","line":259},{"name":"$element","containerName":"element","kind":13,"line":259},{"name":"isa","containerName":"element","kind":12,"line":259},{"line":260,"name":"$self","kind":13,"containerName":"element"},{"line":261,"kind":13,"containerName":"element","name":"$self"},{"containerName":"element","kind":13,"name":"$element","line":261},{"line":263,"name":"$self","containerName":"element","kind":13}],"signature":{"label":"element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.\n\n\nsub map {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'map';\n        $self->{_map} = $num;\n    }\n    return defined($self->{_map}) ? $self->{_map} : return;\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $relative->element();\n           $relative->element($element);\n Function: Get/set the map element (Mappable) the Position is relative to. If\n           the Mappable has more than one Position on the Position's map, we\n           will be relative to the Mappable's first Position on the map.\n Returns : Bio::Map::MappableI\n Args    : none to get, OR\n           Bio::Map::MappableI to set"},"kind":12,"range":{"end":{"character":9999,"line":264},"start":{"line":255,"character":0}},"line":255},{"line":260,"kind":12,"name":"_use"},{"kind":12,"name":"_element","line":261},{"name":"_element","kind":12,"line":263},{"definition":"sub","detail":"($self,$pos)","children":[{"line":281,"name":"$self","localvar":"my","kind":13,"containerName":"position","definition":"my"},{"name":"$pos","containerName":"position","kind":13,"line":281},{"kind":13,"containerName":"position","name":"$pos","line":282},{"line":283,"name":"$self","kind":13,"containerName":"position"},{"kind":12,"containerName":"position","name":"throw","line":283},{"containerName":"position","kind":13,"name":"$pos","line":283},{"line":284,"name":"$self","kind":13,"containerName":"position"},{"line":284,"name":"throw","kind":12,"containerName":"position"},{"line":284,"name":"$pos","containerName":"position","kind":13},{"line":284,"name":"isa","containerName":"position","kind":12},{"line":285,"kind":13,"containerName":"position","name":"$self"},{"line":286,"kind":13,"containerName":"position","name":"$self"},{"containerName":"position","kind":13,"name":"$pos","line":286},{"name":"$self","containerName":"position","kind":13,"line":288}],"containerName":"main::","name":"position","signature":{"label":"position($self,$pos)","parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.\n\n\nsub map {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'map';\n        $self->{_map} = $num;\n    }\n    return defined($self->{_map}) ? $self->{_map} : return;\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $relative->element();\n           $relative->element($element);\n Function: Get/set the map element (Mappable) the Position is relative to. If\n           the Mappable has more than one Position on the Position's map, we\n           will be relative to the Mappable's first Position on the map.\n Returns : Bio::Map::MappableI\n Args    : none to get, OR\n           Bio::Map::MappableI to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $self->throw(\"Must supply an object\") unless ref($element);\n        $self->throw(\"This is [$element], not a Bio::Map::MappableI\") unless $element->isa('Bio::Map::MappableI');\n        $self->{_use} = 'element';\n        $self->{_element} = $element;\n    }\n    return $self->{_element} || return;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $relative->position();\n           $relative->position($position);\n Function: Get/set the Position your Position is relative to. Your Position\n           will be made relative to the start of this supplied Position. It\n           makes no difference what maps the Positions are on.\n Returns : Bio::Map::PositionI\n Args    : none to get, OR\n           Bio::Map::PositionI to set"},"line":280,"range":{"start":{"character":0,"line":280},"end":{"character":9999,"line":289}},"kind":12},{"name":"_use","kind":12,"line":285},{"line":286,"name":"_position","kind":12},{"name":"_position","kind":12,"line":288},{"line":303,"kind":12,"range":{"end":{"character":9999,"line":307},"start":{"character":0,"line":303}},"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"description","kind":13,"name":"$self","line":304},{"line":305,"kind":13,"containerName":"description","name":"$self"},{"line":306,"kind":13,"containerName":"description","name":"$self"}],"name":"description","containerName":"main::"},{"line":305,"name":"desc","kind":12},{"line":306,"kind":12,"name":"desc"}],"version":5}