{"version":5,"vars":[{"line":80,"kind":2,"containerName":"","name":"base"},{"line":107,"range":{"end":{"line":116,"character":9999},"start":{"line":107,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: PositionWithSequence.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::PositionWithSequence\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionWithSequence - A position with a sequence.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::PositionWithSequence;\n    \n    my $pos = Bio::Map::PositionWithSequence->new(-map => $map, \n                                -element => $element,\n                                -start => 0,\n                                -seq => 'ATGC');\n\n\n=head1 DESCRIPTION\n\nHave a position with a sequence, eg. define what the binding site sequence of\na certain transcription factor binding site is by modelling it as one of these\nobjects with the -element assigned to a Bio::Map::TranscriptionFactor instance.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionWithSequence;\nuse strict;\n\nuse base qw(Bio::Map::Position Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::PositionWithSequence->new();\n Function: Builds a new Bio::Map::PositionWithSequence object \n Returns : Bio::Map::PositionWithSequence\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range","parameters":[{"label":"$class"},{"label":"@args"}]},"children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":108,"definition":"my"},{"line":108,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":109,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"name":"$class","kind":13,"containerName":"new","line":109},{"name":"@args","containerName":"new","kind":13,"line":109},{"name":"$seq","localvar":"my","containerName":"new","kind":13,"line":111,"definition":"my"},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"line":111,"containerName":"new","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"new","name":"@args","line":111},{"name":"$self","kind":13,"containerName":"new","line":113},{"containerName":"new","kind":12,"name":"seq","line":113},{"kind":13,"containerName":"new","name":"$seq","line":113},{"line":113,"containerName":"new","kind":13,"name":"$seq"},{"line":115,"kind":13,"containerName":"new","name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":109,"name":"SUPER","containerName":"new","kind":12},{"name":"seq","containerName":"main::","children":[{"line":130,"name":"$self","localvar":"my","containerName":"seq","kind":13,"definition":"my"},{"name":"$str","kind":13,"containerName":"seq","line":130},{"line":130,"name":"$alpha","containerName":"seq","kind":13},{"localvar":"my","kind":13,"containerName":"seq","name":"$seq","line":135,"definition":"my"},{"line":136,"name":"$str","containerName":"seq","kind":13},{"line":137,"name":"$alpha","containerName":"seq","kind":13},{"line":137,"containerName":"seq","kind":13,"name":"$seq"},{"line":137,"containerName":"seq","kind":13,"name":"$self"},{"line":137,"containerName":"seq","kind":13,"name":"$str"},{"line":137,"kind":13,"containerName":"seq","name":"$alpha"},{"line":137,"name":"$seq","containerName":"seq","kind":13},{"containerName":"seq","kind":13,"name":"$self","line":137},{"line":137,"containerName":"seq","kind":13,"name":"$str"},{"kind":13,"containerName":"seq","name":"$seq","line":140},{"kind":13,"containerName":"seq","name":"$self","line":140},{"containerName":"seq","kind":13,"name":"$seq","line":143},{"line":144,"kind":13,"containerName":"seq","name":"$self"},{"line":144,"name":"length","kind":12,"containerName":"seq"},{"line":144,"kind":13,"containerName":"seq","name":"$seq"},{"name":"$seq","kind":13,"containerName":"seq","line":145}],"detail":"($self,$str,$alpha)","definition":"sub","kind":12,"range":{"start":{"line":129,"character":0},"end":{"line":148,"character":9999}},"line":129,"signature":{"label":"seq($self,$str,$alpha)","parameters":[{"label":"$self"},{"label":"$str"},{"label":"$alpha"}],"documentation":"1;\n# $Id: PositionWithSequence.pm,v 1.19 2006/09/20 10:20:01 sendu Exp $\n#\n# BioPerl module for Bio::Map::PositionWithSequence\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionWithSequence - A position with a sequence.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::PositionWithSequence;\n    \n    my $pos = Bio::Map::PositionWithSequence->new(-map => $map, \n                                -element => $element,\n                                -start => 0,\n                                -seq => 'ATGC');\n\n\n=head1 DESCRIPTION\n\nHave a position with a sequence, eg. define what the binding site sequence of\na certain transcription factor binding site is by modelling it as one of these\nobjects with the -element assigned to a Bio::Map::TranscriptionFactor instance.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionWithSequence;\nuse strict;\n\nuse base qw(Bio::Map::Position Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::PositionWithSequence->new();\n Function: Builds a new Bio::Map::PositionWithSequence object \n Returns : Bio::Map::PositionWithSequence\n Args    : -map      => Bio::Map::GeneMap object\n           -element  => Bio::Map::Gene object\n           -relative => Bio::Map::GeneRelative object\n           -seq      => string, length of this string will set the length\n                        of this position's range\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($seq) = $self->_rearrange([qw( SEQ )], @args);\n    \n    $self->seq($seq) if $seq;\n    \n    return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $obj->seq();\n Function: Get/set the sequence as a string of letters.\n Returns : scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed)."}},{"kind":12,"containerName":"seq","name":"SUPER","line":137},{"containerName":"seq","kind":12,"name":"SUPER","line":137},{"line":143,"kind":12,"containerName":"seq","name":"SUPER"}]}