{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":106},{"definition":"my","name":"%RELATIONS","localvar":"my","containerName":null,"kind":13,"line":109},{"kind":12,"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":125}},"line":125,"signature":{"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":126,"name":"$class","localvar":"my","containerName":"new","kind":13},{"line":126,"containerName":"new","kind":13,"name":"@args"},{"line":127,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":127,"name":"$class","kind":13,"containerName":"new"},{"line":127,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":129,"name":"$you","localvar":"my","containerName":"new","kind":13},{"line":129,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":129},{"name":"@args","containerName":"new","kind":13,"line":129},{"name":"$self","containerName":"new","kind":13,"line":131},{"containerName":"new","kind":12,"name":"throw","line":131},{"line":131,"name":"$you","kind":13,"containerName":"new"},{"line":132,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":132},{"kind":13,"containerName":"new","name":"$you","line":132},{"line":133,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"throw","line":133},{"line":133,"containerName":"new","kind":13,"name":"$you"},{"name":"isa","containerName":"new","kind":12,"line":133},{"name":"$self","kind":13,"containerName":"new","line":134},{"line":134,"name":"$you","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":135},{"line":135,"kind":13,"containerName":"new","name":"$RELATIONS"},{"line":136,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":127,"name":"SUPER","kind":12,"containerName":"new"},{"name":"_who","kind":12,"line":134},{"line":135,"kind":12,"name":"_rel"},{"line":149,"range":{"end":{"line":157,"character":9999},"start":{"line":149,"character":0}},"kind":12,"children":[{"line":150,"name":"$self","localvar":"my","containerName":"register","kind":13,"definition":"my"},{"localvar":"my","containerName":"register","kind":13,"name":"$you","line":151,"definition":"my"},{"line":151,"name":"$self","kind":13,"containerName":"register"},{"line":153,"containerName":"register","kind":13,"name":"$self"},{"line":153,"kind":12,"containerName":"register","name":"throw"},{"line":153,"kind":13,"containerName":"register","name":"$you"},{"name":"get_position_handler","kind":12,"containerName":"register","line":153},{"line":153,"containerName":"register","kind":12,"name":"index"},{"containerName":"register","kind":13,"name":"$self","line":155},{"line":155,"name":"$self","kind":13,"containerName":"register"},{"line":156,"name":"$self","containerName":"register","kind":13},{"line":156,"name":"$self","kind":13,"containerName":"register"},{"line":156,"containerName":"register","kind":13,"name":"$you"}],"containerName":"main::","name":"register","definition":"sub"},{"line":151,"name":"_who","kind":12},{"name":"_index","kind":12,"line":155},{"kind":12,"name":"_rel","line":155},{"line":155,"name":"assigned_indices","kind":12},{"line":156,"kind":12,"name":"_rel"},{"kind":12,"name":"registered","line":156},{"line":156,"kind":12,"name":"_index"},{"line":170,"range":{"start":{"line":170,"character":0},"end":{"character":9999,"line":173}},"kind":12,"children":[{"definition":"my","line":171,"name":"$self","containerName":"index","localvar":"my","kind":13},{"kind":13,"containerName":"index","name":"$self","line":172}],"containerName":"main::","name":"index","definition":"sub"},{"name":"_index","kind":12,"line":172},{"kind":12,"range":{"end":{"character":9999,"line":188},"start":{"character":0,"line":185}},"line":185,"signature":{"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int","parameters":[{"label":"$self"},{"label":"$index"}],"label":"get_entity($self,$index)"},"containerName":"main::","name":"get_entity","children":[{"definition":"my","line":186,"localvar":"my","kind":13,"containerName":"get_entity","name":"$self"},{"line":186,"containerName":"get_entity","kind":13,"name":"$index"},{"kind":13,"containerName":"get_entity","name":"$self","line":187},{"line":187,"kind":13,"containerName":"get_entity","name":"$index"},{"line":187,"kind":13,"containerName":"get_entity","name":"$self"},{"line":187,"kind":12,"containerName":"get_entity","name":"throw"}],"detail":"($self,$index)","definition":"sub"},{"name":"_rel","kind":12,"line":187},{"name":"registered","kind":12,"line":187},{"signature":{"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set","parameters":[{"label":"$self"},{"label":"$entity"}],"label":"map($self,$entity)"},"line":206,"kind":12,"range":{"end":{"line":209,"character":9999},"start":{"line":206,"character":0}},"definition":"sub","detail":"($self,$entity)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"map","name":"$self","line":207},{"name":"$entity","containerName":"map","kind":13,"line":207},{"containerName":"map","kind":13,"name":"$self","line":208},{"line":208,"name":"_pos_get_set","containerName":"map","kind":12},{"line":208,"name":"$entity","containerName":"map","kind":13}],"name":"map","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"},{"label":"$entity"}],"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set","label":"element($self,$entity)"},"range":{"start":{"character":0,"line":223},"end":{"line":226,"character":9999}},"kind":12,"line":223,"detail":"($self,$entity)","definition":"sub","name":"element","containerName":"main::","children":[{"definition":"my","line":224,"name":"$self","kind":13,"localvar":"my","containerName":"element"},{"containerName":"element","kind":13,"name":"$entity","line":224},{"line":225,"containerName":"element","kind":13,"name":"$self"},{"name":"_pos_get_set","kind":12,"containerName":"element","line":225},{"kind":13,"containerName":"element","name":"$entity","line":225}]},{"line":242,"kind":12,"range":{"end":{"character":9999,"line":254},"start":{"character":0,"line":242}},"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"add_positions","localvar":"my","kind":13,"line":243},{"kind":13,"containerName":"add_positions","name":"$self","line":244},{"line":244,"kind":12,"containerName":"add_positions","name":"throw"},{"definition":"my","line":245,"name":"$you_index","kind":13,"localvar":"my","containerName":"add_positions"},{"kind":13,"containerName":"add_positions","name":"$self","line":245},{"line":245,"containerName":"add_positions","kind":12,"name":"_get_you_index"},{"definition":"my","name":"$kind","localvar":"my","kind":13,"containerName":"add_positions","line":246},{"line":246,"name":"$self","containerName":"add_positions","kind":13},{"containerName":"add_positions","kind":12,"name":"_get_kind","line":246},{"name":"$pos","localvar":"my","containerName":"add_positions","kind":13,"line":248,"definition":"my"},{"containerName":"add_positions","kind":13,"name":"$self","line":249},{"kind":12,"containerName":"add_positions","name":"_check_object","line":249},{"line":249,"containerName":"add_positions","kind":13,"name":"$pos"},{"definition":"my","name":"$pos_index","localvar":"my","containerName":"add_positions","kind":13,"line":250},{"name":"$self","containerName":"add_positions","kind":13,"line":250},{"line":250,"kind":12,"containerName":"add_positions","name":"_get_other_index"},{"containerName":"add_positions","kind":13,"name":"$pos","line":250},{"name":"$self","containerName":"add_positions","kind":13,"line":252},{"kind":12,"containerName":"add_positions","name":"_pos_set","line":252},{"containerName":"add_positions","kind":13,"name":"$pos_index","line":252},{"line":252,"containerName":"add_positions","kind":13,"name":"$you_index"},{"line":252,"name":"$kind","kind":13,"containerName":"add_positions"}],"containerName":"main::","name":"add_positions"},{"children":[{"kind":13,"localvar":"my","containerName":"get_positions","name":"$self","line":269,"definition":"my"},{"containerName":"get_positions","kind":13,"name":"$entity","line":269},{"definition":"my","name":"$you_index","containerName":"get_positions","localvar":"my","kind":13,"line":270},{"containerName":"get_positions","kind":13,"name":"$self","line":270},{"containerName":"get_positions","kind":12,"name":"_get_you_index","line":270},{"definition":"my","line":272,"localvar":"my","containerName":"get_positions","kind":13,"name":"@positions"},{"containerName":"get_positions","kind":13,"name":"$self","line":272},{"line":272,"name":"$you_index","containerName":"get_positions","kind":13}],"containerName":"main::","name":"get_positions","definition":"sub","detail":"($self,$entity)","line":268,"kind":12,"range":{"end":{"character":9999,"line":272},"start":{"line":268,"character":0}},"signature":{"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_elements', 'Bio::Map::MappableI');\n}\n\n=head2 Methods for all other Bio::Map::EntityI objects\n\n\n=head2 add_positions\n\n Title   : add_positions\n Usage   : $position_handler->add_positions($pos1, $pos2, ...);\n Function: Add some positions to yourself. You can't be a position.\n Returns : n/a\n Args    : Array of Bio::Map::PositionI objects\n\n\nsub add_positions {\n    my $self = shift;\n    $self->throw('Must supply at least one Bio::Map::EntityI') unless @_ > 0;\n    my $you_index = $self->_get_you_index(0);\n    my $kind = $self->_get_kind;\n    \n    foreach my $pos (@_) {\n        $self->_check_object($pos, 'Bio::Map::PositionI');\n        my $pos_index = $self->_get_other_index($pos);\n        \n        $self->_pos_set($pos_index, $you_index, $kind);\n    }\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $position_handler->get_positions();\n Function: Get all your positions. You can't be a Position.\n Returns : Array of Bio::Map::PositionI objects\n Args    : none for all, OR\n           Bio::Map::EntityI object to limit the Positions to those that\n           are shared by you and this other entity.","parameters":[{"label":"$self"},{"label":"$entity"}],"label":"get_positions($self,$entity)"}},{"line":272,"name":"_rel","kind":12},{"name":"%entity","containerName":null,"kind":13,"line":274},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$entity_index","line":275},{"line":275,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"_get_other_index","line":275},{"line":275,"name":"$entity","containerName":null,"kind":13},{"localvar":"my","containerName":null,"kind":13,"name":"$pos_ref","line":276,"definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":276},{"line":276,"name":"_rel","kind":12},{"name":"$entity_index","containerName":null,"kind":13,"line":276},{"name":"@positions","kind":13,"containerName":null,"line":277},{"containerName":null,"kind":13,"name":"%pos_ref","line":277},{"line":277,"kind":13,"containerName":null,"name":"@positions"},{"line":280,"containerName":null,"kind":13,"name":"$self"},{"name":"get_entity","containerName":"main::","kind":12,"line":280},{"kind":13,"containerName":null,"name":"@positions","line":280},{"name":"purge_positions","containerName":"main::","children":[{"definition":"my","line":297,"localvar":"my","kind":13,"containerName":"purge_positions","name":"$self"},{"line":297,"name":"$thing","kind":13,"containerName":"purge_positions"},{"definition":"my","line":298,"containerName":"purge_positions","localvar":"my","kind":13,"name":"$you_index"},{"kind":13,"containerName":"purge_positions","name":"$self","line":298},{"kind":12,"containerName":"purge_positions","name":"_get_you_index","line":298},{"line":299,"localvar":"my","kind":13,"containerName":"purge_positions","name":"$kind","definition":"my"},{"name":"$self","kind":13,"containerName":"purge_positions","line":299},{"name":"_get_kind","containerName":"purge_positions","kind":12,"line":299},{"definition":"my","line":301,"localvar":"my","containerName":"purge_positions","kind":13,"name":"@pos_indices"},{"name":"$thing","kind":13,"containerName":"purge_positions","line":302},{"line":303,"name":"$self","kind":13,"containerName":"purge_positions"},{"containerName":"purge_positions","kind":12,"name":"throw","line":303},{"name":"$thing","containerName":"purge_positions","kind":13,"line":303},{"name":"$thing","containerName":"purge_positions","kind":13,"line":304},{"name":"isa","containerName":"purge_positions","kind":12,"line":304},{"line":305,"name":"@pos_indices","containerName":"purge_positions","kind":13},{"containerName":"purge_positions","kind":13,"name":"$self","line":305},{"name":"_get_other_index","kind":12,"containerName":"purge_positions","line":305},{"name":"$thing","containerName":"purge_positions","kind":13,"line":305},{"definition":"my","kind":13,"localvar":"my","containerName":"purge_positions","name":"$entity_index","line":308},{"line":308,"containerName":"purge_positions","kind":13,"name":"$self"},{"name":"_get_other_index","containerName":"purge_positions","kind":12,"line":308},{"line":308,"name":"$thing","containerName":"purge_positions","kind":13},{"definition":"my","line":309,"name":"$pos_ref","kind":13,"localvar":"my","containerName":"purge_positions"},{"line":309,"containerName":"purge_positions","kind":13,"name":"$self"},{"name":"$entity_index","kind":13,"containerName":"purge_positions","line":309},{"line":310,"name":"@pos_indices","kind":13,"containerName":"purge_positions"},{"name":"$pos_ref","kind":13,"containerName":"purge_positions","line":310},{"name":"$self","kind":13,"containerName":"purge_positions","line":310},{"line":310,"name":"$you_index","containerName":"purge_positions","kind":13}],"detail":"($self,$thing)","definition":"sub","range":{"end":{"character":9999,"line":312},"start":{"line":296,"character":0}},"kind":12,"line":296,"signature":{"label":"purge_positions($self,$thing)","documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_elements', 'Bio::Map::MappableI');\n}\n\n=head2 Methods for all other Bio::Map::EntityI objects\n\n\n=head2 add_positions\n\n Title   : add_positions\n Usage   : $position_handler->add_positions($pos1, $pos2, ...);\n Function: Add some positions to yourself. You can't be a position.\n Returns : n/a\n Args    : Array of Bio::Map::PositionI objects\n\n\nsub add_positions {\n    my $self = shift;\n    $self->throw('Must supply at least one Bio::Map::EntityI') unless @_ > 0;\n    my $you_index = $self->_get_you_index(0);\n    my $kind = $self->_get_kind;\n    \n    foreach my $pos (@_) {\n        $self->_check_object($pos, 'Bio::Map::PositionI');\n        my $pos_index = $self->_get_other_index($pos);\n        \n        $self->_pos_set($pos_index, $you_index, $kind);\n    }\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $position_handler->get_positions();\n Function: Get all your positions. You can't be a Position.\n Returns : Array of Bio::Map::PositionI objects\n Args    : none for all, OR\n           Bio::Map::EntityI object to limit the Positions to those that\n           are shared by you and this other entity.\n\n\nsub get_positions {\n    my ($self, $entity) = @_;\n    my $you_index = $self->_get_you_index(0);\n    \n    my @positions = keys %{$self->{_rel}->{has}->{$you_index}};\n    \n    if ($entity) {\n        my $entity_index = $self->_get_other_index($entity);\n        my $pos_ref = $self->{_rel}->{has}->{$entity_index};\n        @positions = grep { $pos_ref->{$_} } @positions;\n    }\n    \n    return map { $self->get_entity($_) } @positions;\n}\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $position_handler->purge_positions();\n Function: Remove all positions from yourself. You can't be a Position.\n Returns : n/a\n Args    : none to remove all, OR\n           Bio::Map::PositionI object to remove only that entity, OR\n           Bio::Map::EntityI object to limit the removal to those Positions that\n           are shared by you and this other entity.","parameters":[{"label":"$self"},{"label":"$thing"}]}},{"name":"_rel","kind":12,"line":309},{"name":"_rel","kind":12,"line":310},{"containerName":null,"kind":13,"name":"@pos_indices","line":314},{"line":314,"containerName":null,"kind":13,"name":"%self"},{"line":314,"kind":12,"name":"_rel"},{"name":"$you_index","containerName":null,"kind":13,"line":314},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$pos_index","line":317},{"name":"@pos_indices","containerName":null,"kind":13,"line":317},{"line":318,"name":"$self","kind":13,"containerName":null},{"name":"_purge_pos_entity","containerName":"main::","kind":12,"line":318},{"name":"$pos_index","containerName":null,"kind":13,"line":318},{"name":"$you_index","kind":13,"containerName":null,"line":318},{"line":318,"name":"$kind","kind":13,"containerName":null},{"name":"get_other_entities","containerName":"main::","children":[{"definition":"my","line":334,"name":"$self","kind":13,"localvar":"my","containerName":"get_other_entities"},{"name":"$you_index","kind":13,"localvar":"my","containerName":"get_other_entities","line":335,"definition":"my"},{"line":335,"name":"$self","containerName":"get_other_entities","kind":13},{"kind":12,"containerName":"get_other_entities","name":"_get_you_index","line":335},{"definition":"my","name":"$kind","kind":13,"localvar":"my","containerName":"get_other_entities","line":336},{"kind":13,"containerName":"get_other_entities","name":"$self","line":336},{"containerName":"get_other_entities","kind":12,"name":"_get_kind","line":336},{"definition":"my","line":337,"name":"$want","kind":13,"localvar":"my","containerName":"get_other_entities"},{"line":337,"containerName":"get_other_entities","kind":13,"name":"$kind"},{"definition":"my","name":"%entities","kind":13,"localvar":"my","containerName":"get_other_entities","line":339},{"kind":13,"localvar":"my","containerName":"get_other_entities","name":"$pos_index","line":340,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_other_entities","line":340},{"containerName":"get_other_entities","kind":13,"name":"$you_index","line":340}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":340},"start":{"line":333,"character":0}},"line":333},{"name":"_rel","kind":12,"line":340},{"line":341,"name":"$entity_index","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":341},{"line":341,"name":"_rel","kind":12},{"line":341,"containerName":null,"kind":13,"name":"%want"},{"line":341,"containerName":null,"kind":13,"name":"$pos_index"},{"containerName":null,"kind":13,"name":"%entities","line":342},{"line":342,"kind":13,"containerName":null,"name":"$entity_index"},{"kind":13,"containerName":null,"name":"%entity_index","line":342},{"line":345,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"get_entity","line":345},{"containerName":null,"kind":13,"name":"%entities","line":345},{"detail":"($self,$object,$interface)","definition":"sub","name":"_check_object","containerName":"main::","children":[{"containerName":"_check_object","localvar":"my","kind":13,"name":"$self","line":350,"definition":"my"},{"containerName":"_check_object","kind":13,"name":"$object","line":350},{"kind":13,"containerName":"_check_object","name":"$interface","line":350},{"line":351,"name":"$self","kind":13,"containerName":"_check_object"},{"line":351,"name":"throw","kind":12,"containerName":"_check_object"},{"containerName":"_check_object","kind":13,"name":"$object","line":351},{"name":"$self","kind":13,"containerName":"_check_object","line":352},{"name":"throw","kind":12,"containerName":"_check_object","line":352},{"kind":13,"containerName":"_check_object","name":"$object","line":352},{"line":353,"kind":13,"containerName":"_check_object","name":"$self"},{"name":"throw","containerName":"_check_object","kind":12,"line":353},{"containerName":"_check_object","kind":13,"name":"$object","line":353},{"line":353,"name":"isa","kind":12,"containerName":"_check_object"},{"name":"$interface","containerName":"_check_object","kind":13,"line":353}],"signature":{"parameters":[{"label":"$self"},{"label":"$object"},{"label":"$interface"}],"documentation":" do basic check on an object, make sure it is the right type","label":"_check_object($self,$object,$interface)"},"kind":12,"range":{"end":{"line":354,"character":9999},"start":{"line":349,"character":0}},"line":349},{"containerName":"main::","name":"_get_you_index","children":[{"line":359,"name":"$self","kind":13,"localvar":"my","containerName":"_get_you_index","definition":"my"},{"name":"$should_be_pos","kind":13,"containerName":"_get_you_index","line":359},{"line":360,"name":"$you","kind":13,"localvar":"my","containerName":"_get_you_index","definition":"my"},{"line":360,"name":"$self","kind":13,"containerName":"_get_you_index"},{"name":"$should_be_pos","kind":13,"containerName":"_get_you_index","line":361},{"line":362,"containerName":"_get_you_index","kind":13,"name":"$self"},{"line":362,"containerName":"_get_you_index","kind":12,"name":"throw"},{"containerName":"_get_you_index","kind":13,"name":"$you","line":362},{"name":"isa","containerName":"_get_you_index","kind":12,"line":362},{"line":365,"kind":13,"containerName":"_get_you_index","name":"$self"},{"containerName":"_get_you_index","kind":12,"name":"throw","line":365},{"name":"$you","containerName":"_get_you_index","kind":13,"line":365},{"containerName":"_get_you_index","kind":12,"name":"isa","line":365},{"kind":13,"containerName":"_get_you_index","name":"$self","line":367},{"name":"index","kind":12,"containerName":"_get_you_index","line":367}],"detail":"($self,$should_be_pos)","definition":"sub","range":{"start":{"character":0,"line":358},"end":{"line":368,"character":9999}},"kind":12,"line":358,"signature":{"label":"_get_you_index($self,$should_be_pos)","documentation":" get the object we are the handler of, its index, and throw depending on if\n we're a Position","parameters":[{"label":"$self"},{"label":"$should_be_pos"}]}},{"line":360,"kind":12,"name":"_who"},{"detail":"($self,$entity)","definition":"sub","name":"_get_other_index","containerName":"main::","children":[{"line":372,"containerName":"_get_other_index","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"_get_other_index","kind":13,"name":"$entity","line":372},{"kind":13,"containerName":"_get_other_index","name":"$self","line":373},{"line":373,"kind":12,"containerName":"_get_other_index","name":"throw"},{"containerName":"_get_other_index","kind":13,"name":"$entity","line":373},{"line":374,"name":"$index","localvar":"my","containerName":"_get_other_index","kind":13,"definition":"my"},{"kind":13,"containerName":"_get_other_index","name":"$entity","line":374},{"line":374,"name":"get_position_handler","containerName":"_get_other_index","kind":12},{"containerName":"_get_other_index","kind":12,"name":"index","line":374},{"line":375,"kind":13,"containerName":"_get_other_index","name":"$self"},{"name":"throw","containerName":"_get_other_index","kind":12,"line":375},{"kind":13,"containerName":"_get_other_index","name":"$index","line":375},{"kind":13,"containerName":"_get_other_index","name":"$self","line":376},{"name":"throw","kind":12,"containerName":"_get_other_index","line":376},{"name":"$entity","containerName":"_get_other_index","kind":13,"line":376},{"name":"$self","kind":13,"containerName":"_get_other_index","line":376},{"name":"get_entity","kind":12,"containerName":"_get_other_index","line":376},{"name":"$index","kind":13,"containerName":"_get_other_index","line":376},{"containerName":"_get_other_index","kind":13,"name":"$index","line":377}],"signature":{"parameters":[{"label":"$self"},{"label":"$entity"}],"documentation":" check an entity is registered and get its index","label":"_get_other_index($self,$entity)"},"range":{"start":{"line":371,"character":0},"end":{"character":9999,"line":378}},"kind":12,"line":371},{"children":[{"line":382,"name":"$self","kind":13,"localvar":"my","containerName":"_get_kind","definition":"my"},{"containerName":"_get_kind","localvar":"my","kind":13,"name":"$you","line":383,"definition":"my"},{"kind":13,"containerName":"_get_kind","name":"$self","line":383},{"line":384,"kind":13,"containerName":"_get_kind","name":"$you"},{"line":384,"containerName":"_get_kind","kind":12,"name":"isa"},{"name":"$you","containerName":"_get_kind","kind":13,"line":384},{"line":384,"name":"isa","containerName":"_get_kind","kind":12},{"containerName":"_get_kind","kind":13,"name":"$self","line":384},{"name":"throw","containerName":"_get_kind","kind":12,"line":384}],"name":"_get_kind","containerName":"main::","definition":"sub","line":381,"range":{"end":{"line":385,"character":9999},"start":{"line":381,"character":0}},"kind":12},{"name":"_who","kind":12,"line":383},{"definition":"sub","detail":"($self,$entity,$kind,$interface)","children":[{"line":389,"localvar":"my","kind":13,"containerName":"_pos_get_set","name":"$self","definition":"my"},{"line":389,"name":"$entity","containerName":"_pos_get_set","kind":13},{"line":389,"kind":13,"containerName":"_pos_get_set","name":"$kind"},{"line":389,"name":"$interface","containerName":"_pos_get_set","kind":13},{"name":"$you_index","kind":13,"localvar":"my","containerName":"_pos_get_set","line":390,"definition":"my"},{"line":390,"name":"$self","kind":13,"containerName":"_pos_get_set"},{"name":"_get_you_index","containerName":"_pos_get_set","kind":12,"line":390},{"containerName":"_pos_get_set","localvar":"my","kind":13,"name":"$entity_index","line":392,"definition":"my"},{"line":393,"kind":13,"containerName":"_pos_get_set","name":"$entity"},{"line":394,"containerName":"_pos_get_set","kind":13,"name":"$self"},{"containerName":"_pos_get_set","kind":12,"name":"_check_object","line":394},{"line":394,"name":"$entity","containerName":"_pos_get_set","kind":13},{"line":394,"name":"$interface","containerName":"_pos_get_set","kind":13},{"name":"$new_entity_index","containerName":"_pos_get_set","localvar":"my","kind":13,"line":395,"definition":"my"},{"name":"$self","kind":13,"containerName":"_pos_get_set","line":395},{"line":395,"name":"_get_other_index","kind":12,"containerName":"_pos_get_set"},{"name":"$entity","kind":13,"containerName":"_pos_get_set","line":395},{"name":"$entity_index","kind":13,"containerName":"_pos_get_set","line":396},{"line":396,"name":"$self","kind":13,"containerName":"_pos_get_set"},{"name":"_pos_set","kind":12,"containerName":"_pos_get_set","line":396},{"line":396,"kind":13,"containerName":"_pos_get_set","name":"$you_index"},{"line":396,"name":"$new_entity_index","containerName":"_pos_get_set","kind":13},{"line":396,"name":"$kind","kind":13,"containerName":"_pos_get_set"},{"line":399,"name":"$entity_index","containerName":"_pos_get_set","kind":13},{"line":399,"name":"$self","containerName":"_pos_get_set","kind":13},{"line":399,"name":"$kind","containerName":"_pos_get_set","kind":13},{"kind":13,"containerName":"_pos_get_set","name":"$you_index","line":399},{"containerName":"_pos_get_set","kind":13,"name":"$entity_index","line":400},{"name":"$self","kind":13,"containerName":"_pos_get_set","line":401},{"name":"get_entity","kind":12,"containerName":"_pos_get_set","line":401},{"name":"$entity_index","kind":13,"containerName":"_pos_get_set","line":401}],"name":"_pos_get_set","containerName":"main::","signature":{"documentation":" get/set position entity","parameters":[{"label":"$self"},{"label":"$entity"},{"label":"$kind"},{"label":"$interface"}],"label":"_pos_get_set($self,$entity,$kind,$interface)"},"line":388,"kind":12,"range":{"end":{"line":404,"character":9999},"start":{"character":0,"line":388}}},{"kind":12,"name":"_rel","line":399},{"signature":{"documentation":" set position entity","parameters":[{"label":"$self"},{"label":"$pos_index"},{"label":"$new_entity_index"},{"label":"$kind"}],"label":"_pos_set($self,$pos_index,$new_entity_index,$kind)"},"line":407,"kind":12,"range":{"end":{"line":422,"character":9999},"start":{"line":407,"character":0}},"definition":"sub","detail":"($self,$pos_index,$new_entity_index,$kind)","children":[{"line":408,"name":"$self","localvar":"my","containerName":"_pos_set","kind":13,"definition":"my"},{"line":408,"kind":13,"containerName":"_pos_set","name":"$pos_index"},{"line":408,"name":"$new_entity_index","containerName":"_pos_set","kind":13},{"containerName":"_pos_set","kind":13,"name":"$kind","line":408},{"containerName":"_pos_set","localvar":"my","kind":13,"name":"$current_entity_index","line":409,"definition":"my"},{"line":409,"containerName":"_pos_set","kind":13,"name":"$self"},{"kind":13,"containerName":"_pos_set","name":"$kind","line":409},{"line":409,"name":"$pos_index","containerName":"_pos_set","kind":13},{"kind":13,"containerName":"_pos_set","name":"$current_entity_index","line":411},{"line":412,"containerName":"_pos_set","kind":13,"name":"$current_entity_index"},{"name":"$new_entity_index","containerName":"_pos_set","kind":13,"line":412},{"kind":13,"containerName":"_pos_set","name":"$current_entity_index","line":413},{"name":"$self","containerName":"_pos_set","kind":13,"line":416},{"line":416,"containerName":"_pos_set","kind":12,"name":"_purge_pos_entity"},{"kind":13,"containerName":"_pos_set","name":"$pos_index","line":416},{"line":416,"name":"$current_entity_index","kind":13,"containerName":"_pos_set"},{"kind":13,"containerName":"_pos_set","name":"$kind","line":416},{"containerName":"_pos_set","kind":13,"name":"$self","line":419},{"name":"$new_entity_index","containerName":"_pos_set","kind":13,"line":419},{"name":"$pos_index","containerName":"_pos_set","kind":13,"line":419},{"line":420,"name":"$self","containerName":"_pos_set","kind":13},{"line":420,"containerName":"_pos_set","kind":13,"name":"$kind"},{"name":"$pos_index","kind":13,"containerName":"_pos_set","line":420},{"line":420,"containerName":"_pos_set","kind":13,"name":"$new_entity_index"},{"containerName":"_pos_set","kind":13,"name":"$new_entity_index","line":421}],"name":"_pos_set","containerName":"main::"},{"name":"_rel","kind":12,"line":409},{"name":"_rel","kind":12,"line":419},{"line":420,"kind":12,"name":"_rel"},{"range":{"start":{"character":0,"line":425},"end":{"line":429,"character":9999}},"kind":12,"line":425,"signature":{"label":"_purge_pos_entity($self,$pos_index,$entity_index,$kind)","documentation":" disassociate position from one of its current entities","parameters":[{"label":"$self"},{"label":"$pos_index"},{"label":"$entity_index"},{"label":"$kind"}]},"containerName":"main::","name":"_purge_pos_entity","children":[{"definition":"my","line":426,"name":"$self","kind":13,"localvar":"my","containerName":"_purge_pos_entity"},{"line":426,"containerName":"_purge_pos_entity","kind":13,"name":"$pos_index"},{"line":426,"name":"$entity_index","kind":13,"containerName":"_purge_pos_entity"},{"line":426,"containerName":"_purge_pos_entity","kind":13,"name":"$kind"},{"line":427,"containerName":"_purge_pos_entity","kind":13,"name":"$self"},{"kind":13,"containerName":"_purge_pos_entity","name":"$entity_index","line":427},{"name":"$pos_index","containerName":"_purge_pos_entity","kind":13,"line":427},{"name":"$self","kind":13,"containerName":"_purge_pos_entity","line":428},{"containerName":"_purge_pos_entity","kind":13,"name":"$kind","line":428},{"line":428,"containerName":"_purge_pos_entity","kind":13,"name":"$pos_index"}],"detail":"($self,$pos_index,$entity_index,$kind)","definition":"sub"},{"name":"_rel","kind":12,"line":427},{"name":"_rel","kind":12,"line":428}]}