{"version":5,"vars":[{"line":135,"name":"vars","kind":2,"containerName":""},{"line":143,"containerName":"","kind":2,"name":"base"},{"containerName":null,"kind":13,"name":"$MAPCOUNT","line":144},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set","label":"version($self,$value)"},"line":161,"range":{"start":{"character":0,"line":161},"end":{"character":9999,"line":167}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":162,"name":"$self","kind":13,"localvar":"my","containerName":"version","definition":"my"},{"line":162,"kind":13,"containerName":"version","name":"$value"},{"line":163,"name":"$value","kind":13,"containerName":"version"},{"line":164,"kind":13,"containerName":"version","name":"$self"},{"line":164,"name":"$value","kind":13,"containerName":"version"},{"line":166,"kind":13,"containerName":"version","name":"$self"}],"name":"version","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"modification_user($self,$value)"},"line":179,"range":{"end":{"character":9999,"line":185},"start":{"line":179,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":180,"name":"$self","localvar":"my","containerName":"modification_user","kind":13,"definition":"my"},{"line":180,"kind":13,"containerName":"modification_user","name":"$value"},{"name":"$value","containerName":"modification_user","kind":13,"line":181},{"line":182,"name":"$self","containerName":"modification_user","kind":13},{"containerName":"modification_user","kind":13,"name":"$value","line":182},{"name":"$self","kind":13,"containerName":"modification_user","line":184}],"containerName":"main::","name":"modification_user"},{"signature":{"label":"group_type($self,$value)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}]},"line":198,"range":{"start":{"line":198,"character":0},"end":{"character":9999,"line":204}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":199,"name":"$self","localvar":"my","kind":13,"containerName":"group_type","definition":"my"},{"name":"$value","containerName":"group_type","kind":13,"line":199},{"kind":13,"containerName":"group_type","name":"$value","line":200},{"name":"$self","kind":13,"containerName":"group_type","line":201},{"line":201,"containerName":"group_type","kind":13,"name":"$value"},{"line":203,"kind":13,"containerName":"group_type","name":"$self"}],"name":"group_type","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","name":"group_abbr","containerName":"main::","children":[{"containerName":"group_abbr","localvar":"my","kind":13,"name":"$self","line":218,"definition":"my"},{"line":218,"kind":13,"containerName":"group_abbr","name":"$value"},{"line":219,"name":"$value","kind":13,"containerName":"group_abbr"},{"name":"$self","kind":13,"containerName":"group_abbr","line":220},{"name":"$value","containerName":"group_abbr","kind":13,"line":220},{"line":222,"kind":13,"containerName":"group_abbr","name":"$self"}],"signature":{"label":"group_abbr($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set"},"range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":223}},"kind":12,"line":217},{"signature":{"label":"core_exists($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set"},"line":235,"kind":12,"range":{"end":{"line":241,"character":9999},"start":{"line":235,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":236,"name":"$self","kind":13,"localvar":"my","containerName":"core_exists"},{"line":236,"name":"$value","containerName":"core_exists","kind":13},{"line":237,"name":"$value","kind":13,"containerName":"core_exists"},{"name":"$self","containerName":"core_exists","kind":13,"line":238},{"line":238,"name":"$value","kind":13,"containerName":"core_exists"},{"name":"$self","kind":13,"containerName":"core_exists","line":240}],"containerName":"main::","name":"core_exists"},{"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"each_cloneid","line":254,"definition":"my"},{"kind":13,"containerName":"each_cloneid","name":"$self","line":255}],"containerName":"main::","name":"each_cloneid","signature":{"label":"each_cloneid($self)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none","parameters":[{"label":"$self"}]},"line":253,"kind":12,"range":{"end":{"character":9999,"line":255},"start":{"character":0,"line":253}}},{"name":"get_cloneobj","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"get_cloneobj","name":"$self","line":269,"definition":"my"},{"name":"$clone","kind":13,"containerName":"get_cloneobj","line":269},{"name":"$clone","containerName":"get_cloneobj","kind":13,"line":271},{"kind":13,"containerName":"get_cloneobj","name":"$clone","line":272},{"kind":13,"containerName":"get_cloneobj","name":"$self","line":273},{"name":"$clone","containerName":"get_cloneobj","kind":13,"line":273},{"definition":"my","line":275,"localvar":"my","kind":13,"containerName":"get_cloneobj","name":"$type"},{"containerName":"get_cloneobj","kind":13,"name":"$contig","line":275},{"line":275,"containerName":"get_cloneobj","kind":13,"name":"$bands"},{"line":275,"name":"$gel","kind":13,"containerName":"get_cloneobj"},{"line":275,"containerName":"get_cloneobj","kind":13,"name":"$group"},{"line":275,"containerName":"get_cloneobj","kind":13,"name":"$remark"},{"name":"$fp_number","containerName":"get_cloneobj","kind":13,"line":275},{"definition":"my","line":276,"localvar":"my","kind":13,"containerName":"get_cloneobj","name":"$sequence_type"},{"name":"$sequence_status","kind":13,"containerName":"get_cloneobj","line":276},{"containerName":"get_cloneobj","kind":13,"name":"$fpc_remark","line":276},{"kind":13,"containerName":"get_cloneobj","name":"@amatch","line":276},{"line":276,"kind":13,"containerName":"get_cloneobj","name":"@pmatch"},{"name":"@ematch","containerName":"get_cloneobj","kind":13,"line":276},{"line":277,"kind":13,"containerName":"get_cloneobj","name":"$startrange"},{"line":277,"name":"$endrange","kind":13,"containerName":"get_cloneobj"},{"definition":"my","line":278,"containerName":"get_cloneobj","localvar":"my","kind":13,"name":"%clones"},{"line":278,"name":"$self","containerName":"get_cloneobj","kind":13},{"line":278,"containerName":"get_cloneobj","kind":13,"name":"$clone"}],"detail":"($self,$clone)","definition":"sub","kind":12,"range":{"end":{"line":278,"character":9999},"start":{"character":0,"line":268}},"line":268,"signature":{"parameters":[{"label":"$self"},{"label":"$clone"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name","label":"get_cloneobj($self,$clone)"}},{"definition":"my","name":"@markers","kind":13,"localvar":"my","containerName":null,"line":279},{"line":281,"name":"%clones","kind":13,"containerName":null},{"line":282,"name":"%clones","kind":13,"containerName":null},{"line":285,"name":"$type","containerName":null,"kind":13},{"line":285,"name":"%clones","containerName":null,"kind":13},{"line":285,"kind":13,"containerName":null,"name":"%clones"},{"line":286,"kind":13,"containerName":null,"name":"@markers"},{"name":"%clones","kind":13,"containerName":null,"line":286},{"line":286,"kind":13,"containerName":null,"name":"%clones"},{"name":"$contig","kind":13,"containerName":null,"line":287},{"containerName":null,"kind":13,"name":"%clones","line":287},{"kind":13,"containerName":null,"name":"%clones","line":287},{"containerName":null,"kind":13,"name":"$bands","line":288},{"name":"%clones","kind":13,"containerName":null,"line":288},{"line":288,"name":"%clones","containerName":null,"kind":13},{"name":"$gel","kind":13,"containerName":null,"line":289},{"name":"%clones","kind":13,"containerName":null,"line":289},{"line":289,"containerName":null,"kind":13,"name":"%clones"},{"line":290,"name":"$group","kind":13,"containerName":null},{"line":290,"containerName":null,"kind":13,"name":"%clones"},{"line":290,"kind":13,"containerName":null,"name":"%clones"},{"line":291,"kind":13,"containerName":null,"name":"$remark"},{"name":"%clones","kind":13,"containerName":null,"line":291},{"kind":13,"containerName":null,"name":"%clones","line":291},{"kind":13,"containerName":null,"name":"$fp_number","line":293},{"kind":13,"containerName":null,"name":"%clones","line":293},{"line":293,"name":"%clones","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$fpc_remark","line":294},{"name":"%clones","containerName":null,"kind":13,"line":294},{"containerName":null,"kind":13,"name":"%clones","line":294},{"containerName":null,"kind":13,"name":"$sequence_type","line":296},{"name":"%clones","containerName":null,"kind":13,"line":296},{"line":297,"name":"%clones","containerName":null,"kind":13},{"line":298,"containerName":null,"kind":13,"name":"$sequence_status"},{"kind":13,"containerName":null,"name":"%clones","line":298},{"line":299,"name":"%clones","containerName":null,"kind":13},{"line":301,"containerName":null,"kind":13,"name":"@amatch"},{"containerName":null,"kind":13,"name":"%clones","line":301},{"line":301,"name":"%clones","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@ematch","line":302},{"line":302,"name":"%clones","kind":13,"containerName":null},{"line":302,"name":"%clones","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@pmatch","line":303},{"line":303,"containerName":null,"kind":13,"name":"%clones"},{"containerName":null,"kind":13,"name":"%clones","line":303},{"containerName":null,"kind":13,"name":"$startrange","line":305},{"kind":13,"containerName":null,"name":"%clones","line":305},{"line":306,"name":"%clones","containerName":null,"kind":13},{"line":307,"containerName":null,"kind":13,"name":"$endrange"},{"name":"%clones","containerName":null,"kind":13,"line":307},{"kind":13,"containerName":null,"name":"%clones","line":308},{"line":311,"name":"%cloneobj","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":312,"name":"_name","kind":12},{"line":312,"containerName":null,"kind":13,"name":"$clone"},{"line":313,"kind":12,"name":"_markers"},{"line":313,"name":"@markers","kind":13,"containerName":null},{"kind":12,"name":"_contig","line":314},{"line":314,"name":"$contig","kind":13,"containerName":null},{"name":"_type","kind":12,"line":315},{"containerName":null,"kind":13,"name":"$type","line":315},{"name":"_bands","kind":12,"line":316},{"line":316,"kind":13,"containerName":null,"name":"$bands"},{"kind":12,"name":"_gel","line":317},{"name":"$gel","kind":13,"containerName":null,"line":317},{"line":318,"name":"_group","kind":12},{"line":318,"name":"$group","containerName":null,"kind":13},{"line":319,"name":"_remark","kind":12},{"kind":13,"containerName":null,"name":"$remark","line":319},{"kind":12,"name":"_fpnumber","line":320},{"line":320,"name":"$fp_number","containerName":null,"kind":13},{"kind":12,"name":"_sequencetype","line":321},{"containerName":null,"kind":13,"name":"$sequence_type","line":321},{"line":322,"name":"_sequencestatus","kind":12},{"kind":13,"containerName":null,"name":"$sequence_status","line":322},{"name":"_fpcremark","kind":12,"line":323},{"kind":13,"containerName":null,"name":"$fpc_remark","line":323},{"line":324,"name":"_matche","kind":12},{"line":324,"kind":13,"containerName":null,"name":"@ematch"},{"line":325,"name":"_matcha","kind":12},{"name":"@amatch","kind":13,"containerName":null,"line":325},{"name":"_matchp","kind":12,"line":326},{"name":"@pmatch","containerName":null,"kind":13,"line":326},{"line":327,"name":"_range","kind":12},{"containerName":"Range","kind":12,"name":"Bio","line":327},{"kind":12,"containerName":"main::","name":"new","line":327},{"name":"$startrange","kind":13,"containerName":null,"line":327},{"line":328,"kind":13,"containerName":null,"name":"$endrange"},{"line":331,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%clone","line":331},{"name":"$cloneobj","containerName":null,"kind":13,"line":331},{"kind":13,"containerName":null,"name":"$cloneobj","line":332},{"containerName":"main::","name":"each_markerid","children":[{"line":346,"containerName":"each_markerid","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"each_markerid","name":"$self","line":347}],"detail":"($self)","definition":"sub","range":{"end":{"line":347,"character":9999},"start":{"line":345,"character":0}},"kind":12,"line":345,"signature":{"label":"each_markerid($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$marker"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name","label":"get_markerobj($self,$marker)"},"kind":12,"range":{"start":{"character":0,"line":360},"end":{"line":368,"character":9999}},"line":360,"detail":"($self,$marker)","definition":"sub","name":"get_markerobj","containerName":"main::","children":[{"definition":"my","line":361,"name":"$self","kind":13,"localvar":"my","containerName":"get_markerobj"},{"line":361,"name":"$marker","kind":13,"containerName":"get_markerobj"},{"line":363,"name":"$marker","containerName":"get_markerobj","kind":13},{"line":364,"name":"$marker","containerName":"get_markerobj","kind":13},{"line":365,"containerName":"get_markerobj","kind":13,"name":"$self"},{"name":"$marker","containerName":"get_markerobj","kind":13,"line":365},{"definition":"my","line":367,"localvar":"my","kind":13,"containerName":"get_markerobj","name":"$global"},{"name":"$framework","containerName":"get_markerobj","kind":13,"line":367},{"containerName":"get_markerobj","kind":13,"name":"$group","line":367},{"containerName":"get_markerobj","kind":13,"name":"$anchor","line":367},{"line":367,"name":"$remark","kind":13,"containerName":"get_markerobj"},{"line":367,"kind":13,"containerName":"get_markerobj","name":"$type"},{"containerName":"get_markerobj","kind":13,"name":"$linkage","line":367},{"line":367,"name":"$subgroup","kind":13,"containerName":"get_markerobj"},{"definition":"my","name":"%mkr","localvar":"my","containerName":"get_markerobj","kind":13,"line":368},{"line":368,"name":"$self","containerName":"get_markerobj","kind":13},{"kind":13,"containerName":"get_markerobj","name":"$marker","line":368}]},{"containerName":null,"kind":13,"name":"%mkr","line":370},{"name":"%mkr","containerName":null,"kind":13,"line":370},{"kind":13,"containerName":null,"name":"$type","line":372},{"line":372,"name":"%mkr","containerName":null,"kind":13},{"name":"%mkr","kind":13,"containerName":null,"line":372},{"name":"$global","containerName":null,"kind":13,"line":373},{"line":373,"kind":13,"containerName":null,"name":"%mkr"},{"name":"%mkr","kind":13,"containerName":null,"line":373},{"name":"$framework","containerName":null,"kind":13,"line":374},{"line":374,"containerName":null,"kind":13,"name":"%mkr"},{"name":"%mkr","kind":13,"containerName":null,"line":374},{"line":375,"name":"$anchor","kind":13,"containerName":null},{"name":"%mkr","containerName":null,"kind":13,"line":375},{"kind":13,"containerName":null,"name":"%mkr","line":375},{"name":"$group","kind":13,"containerName":null,"line":376},{"containerName":null,"kind":13,"name":"%mkr","line":376},{"name":"%mkr","kind":13,"containerName":null,"line":376},{"containerName":null,"kind":13,"name":"$subgroup","line":377},{"containerName":null,"kind":13,"name":"%mkr","line":377},{"kind":13,"containerName":null,"name":"%mkr","line":377},{"kind":13,"containerName":null,"name":"$remark","line":378},{"name":"%mkr","containerName":null,"kind":13,"line":378},{"name":"%mkr","containerName":null,"kind":13,"line":378},{"localvar":"my","containerName":null,"kind":13,"name":"%clones","line":380,"definition":"my"},{"line":380,"containerName":null,"kind":13,"name":"%mkr"},{"kind":13,"localvar":"my","containerName":null,"name":"%contigs","line":381,"definition":"my"},{"line":381,"kind":13,"containerName":null,"name":"%mkr"},{"definition":"my","line":383,"name":"%markerpos","localvar":"my","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%mkr","line":383},{"line":383,"containerName":null,"kind":13,"name":"%mkr"},{"definition":"my","name":"%markerobj","localvar":"my","containerName":null,"kind":13,"line":386},{"line":387,"kind":12,"name":"_name"},{"kind":13,"containerName":null,"name":"$marker","line":387},{"name":"_type","kind":12,"line":388},{"kind":13,"containerName":null,"name":"$type","line":388},{"kind":12,"name":"_global","line":389},{"name":"$global","containerName":null,"kind":13,"line":389},{"line":390,"kind":12,"name":"_frame"},{"name":"$framework","kind":13,"containerName":null,"line":390},{"name":"_group","kind":12,"line":391},{"line":391,"name":"$group","kind":13,"containerName":null},{"line":392,"name":"_subgroup","kind":12},{"line":392,"kind":13,"containerName":null,"name":"$subgroup"},{"line":393,"kind":12,"name":"_anchor"},{"line":393,"name":"$anchor","kind":13,"containerName":null},{"name":"_remark","kind":12,"line":394},{"line":394,"kind":13,"containerName":null,"name":"$remark"},{"line":395,"kind":12,"name":"_clones"},{"name":"%clones","kind":13,"containerName":null,"line":395},{"name":"_contigs","kind":12,"line":396},{"line":396,"kind":13,"containerName":null,"name":"%contigs"},{"line":397,"kind":12,"name":"_position"},{"line":397,"containerName":null,"kind":13,"name":"%markerpos"},{"line":400,"name":"%self","containerName":null,"kind":13},{"line":400,"name":"%marker","containerName":null,"kind":13},{"name":"$markerobj","containerName":null,"kind":13,"line":400},{"containerName":null,"kind":13,"name":"$markerobj","line":401},{"containerName":"main::","name":"each_contigid","children":[{"definition":"my","line":415,"localvar":"my","containerName":"each_contigid","kind":13,"name":"$self"},{"name":"$self","containerName":"each_contigid","kind":13,"line":416}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":416},"start":{"line":414,"character":0}},"kind":12,"line":414,"signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none","parameters":[{"label":"$self"}],"label":"each_contigid($self)"}},{"line":429,"range":{"start":{"line":429,"character":0},"end":{"line":438,"character":9999}},"kind":12,"signature":{"label":"get_contigobj($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number"},"children":[{"localvar":"my","containerName":"get_contigobj","kind":13,"name":"$self","line":430,"definition":"my"},{"kind":13,"containerName":"get_contigobj","name":"$contig","line":430},{"name":"$contig","kind":13,"containerName":"get_contigobj","line":432},{"name":"$contig","containerName":"get_contigobj","kind":13,"line":433},{"line":434,"name":"$self","kind":13,"containerName":"get_contigobj"},{"kind":13,"containerName":"get_contigobj","name":"$contig","line":434},{"definition":"my","name":"$group","localvar":"my","containerName":"get_contigobj","kind":13,"line":436},{"name":"$anchor","kind":13,"containerName":"get_contigobj","line":436},{"name":"$uremark","kind":13,"containerName":"get_contigobj","line":436},{"line":436,"containerName":"get_contigobj","kind":13,"name":"$tremark"},{"kind":13,"containerName":"get_contigobj","name":"$cremark","line":436},{"line":436,"name":"$startrange","kind":13,"containerName":"get_contigobj"},{"containerName":"get_contigobj","kind":13,"name":"$endrange","line":436},{"kind":13,"containerName":"get_contigobj","name":"$linkage","line":437},{"line":437,"name":"$subgroup","containerName":"get_contigobj","kind":13},{"name":"%ctg","containerName":"get_contigobj","localvar":"my","kind":13,"line":438,"definition":"my"},{"kind":13,"containerName":"get_contigobj","name":"$self","line":438},{"name":"$contig","containerName":"get_contigobj","kind":13,"line":438}],"containerName":"main::","name":"get_contigobj","definition":"sub","detail":"($self,$contig)"},{"definition":"my","line":439,"containerName":null,"localvar":"my","kind":13,"name":"%position"},{"line":439,"kind":13,"containerName":null,"name":"%pos"},{"containerName":null,"kind":13,"name":"%ctg","line":441},{"containerName":null,"kind":13,"name":"%ctg","line":441},{"line":443,"containerName":null,"kind":13,"name":"$group"},{"line":443,"name":"%ctg","containerName":null,"kind":13},{"line":443,"name":"%ctg","kind":13,"containerName":null},{"line":444,"name":"$subgroup","containerName":null,"kind":13},{"name":"%ctg","containerName":null,"kind":13,"line":444},{"line":444,"name":"%ctg","kind":13,"containerName":null},{"name":"$anchor","containerName":null,"kind":13,"line":445},{"name":"%ctg","kind":13,"containerName":null,"line":445},{"kind":13,"containerName":null,"name":"%ctg","line":445},{"kind":13,"containerName":null,"name":"$cremark","line":446},{"kind":13,"containerName":null,"name":"%ctg","line":446},{"line":446,"name":"%ctg","containerName":null,"kind":13},{"line":447,"name":"$uremark","containerName":null,"kind":13},{"line":447,"containerName":null,"kind":13,"name":"%ctg"},{"line":447,"containerName":null,"kind":13,"name":"%ctg"},{"name":"$tremark","kind":13,"containerName":null,"line":448},{"line":448,"kind":13,"containerName":null,"name":"%ctg"},{"line":448,"name":"%ctg","containerName":null,"kind":13},{"name":"$startrange","kind":13,"containerName":null,"line":450},{"line":450,"name":"%ctg","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%ctg","line":451},{"name":"$endrange","containerName":null,"kind":13,"line":452},{"line":452,"containerName":null,"kind":13,"name":"%ctg"},{"line":453,"name":"%ctg","kind":13,"containerName":null},{"name":"%clones","localvar":"my","containerName":null,"kind":13,"line":455,"definition":"my"},{"line":455,"kind":13,"containerName":null,"name":"%ctg"},{"line":455,"kind":13,"containerName":null,"name":"%ctg"},{"name":"%markers","localvar":"my","kind":13,"containerName":null,"line":456,"definition":"my"},{"containerName":null,"kind":13,"name":"%ctg","line":456},{"name":"%ctg","kind":13,"containerName":null,"line":456},{"definition":"my","line":458,"containerName":null,"localvar":"my","kind":13,"name":"$pos"},{"line":458,"name":"%ctg","containerName":null,"kind":13},{"line":461,"name":"%contigobj","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"_group","kind":12,"line":462},{"line":462,"containerName":null,"kind":13,"name":"$group"},{"kind":12,"name":"_subgroup","line":463},{"line":463,"kind":13,"containerName":null,"name":"$subgroup"},{"name":"_anchor","kind":12,"line":464},{"name":"$anchor","kind":13,"containerName":null,"line":464},{"name":"_markers","kind":12,"line":465},{"name":"%markers","containerName":null,"kind":13,"line":465},{"name":"_clones","kind":12,"line":466},{"line":466,"kind":13,"containerName":null,"name":"%clones"},{"line":467,"kind":12,"name":"_name"},{"line":467,"name":"$contig","containerName":null,"kind":13},{"name":"_cremark","kind":12,"line":468},{"name":"$cremark","kind":13,"containerName":null,"line":468},{"line":469,"name":"_uremark","kind":12},{"line":469,"kind":13,"containerName":null,"name":"$uremark"},{"name":"_tremark","kind":12,"line":470},{"containerName":null,"kind":13,"name":"$tremark","line":470},{"line":471,"kind":12,"name":"_position"},{"containerName":null,"kind":13,"name":"$pos","line":471},{"line":472,"kind":12,"name":"_range"},{"name":"Bio","kind":12,"containerName":"Range","line":472},{"kind":12,"containerName":"main::","name":"new","line":472},{"line":472,"containerName":null,"kind":13,"name":"$startrange"},{"name":"$endrange","kind":13,"containerName":null,"line":473},{"line":476,"name":"%self","kind":13,"containerName":null},{"name":"%contig","containerName":null,"kind":13,"line":476},{"line":476,"name":"$contigobj","kind":13,"containerName":null},{"line":477,"name":"$contigobj","containerName":null,"kind":13},{"signature":{"label":"matching_bands($self,$cloneA,$cloneB,$tol)","parameters":[{"label":"$self"},{"label":"$cloneA"},{"label":"$cloneB"},{"label":"$tol"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]"},"kind":12,"range":{"end":{"character":9999,"line":501},"start":{"line":492,"character":0}},"line":492,"detail":"($self,$cloneA,$cloneB,$tol)","definition":"sub","containerName":"main::","name":"matching_bands","children":[{"localvar":"my","kind":13,"containerName":"matching_bands","name":"$self","line":493,"definition":"my"},{"line":493,"name":"$cloneA","containerName":"matching_bands","kind":13},{"name":"$cloneB","kind":13,"containerName":"matching_bands","line":493},{"name":"$tol","kind":13,"containerName":"matching_bands","line":493},{"line":494,"localvar":"my","kind":13,"containerName":"matching_bands","name":"$lstart","definition":"my"},{"containerName":"matching_bands","kind":13,"name":"$kband","line":494},{"line":494,"name":"$match","kind":13,"containerName":"matching_bands"},{"name":"$diff","containerName":"matching_bands","kind":13,"line":494},{"line":494,"kind":13,"containerName":"matching_bands","name":"$i"},{"kind":13,"containerName":"matching_bands","name":"$j","line":494},{"line":496,"kind":13,"containerName":"matching_bands","name":"$cloneA"},{"line":496,"name":"$cloneB","kind":13,"containerName":"matching_bands"},{"name":"$self","containerName":"matching_bands","kind":13,"line":497},{"name":"core_exists","containerName":"matching_bands","kind":12,"line":497},{"line":499,"name":"$tol","containerName":"matching_bands","kind":13},{"name":"$tol","containerName":"matching_bands","kind":13,"line":499},{"definition":"my","name":"%_clones","kind":13,"localvar":"my","containerName":"matching_bands","line":501},{"containerName":"matching_bands","kind":13,"name":"$self","line":501}]},{"line":503,"localvar":"my","kind":13,"containerName":null,"name":"@bandsA","definition":"my"},{"containerName":null,"kind":13,"name":"%_clones","line":503},{"name":"%cloneA","containerName":null,"kind":13,"line":503},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"@bandsB","line":504},{"containerName":null,"kind":13,"name":"%_clones","line":504},{"name":"%cloneB","containerName":null,"kind":13,"line":504},{"line":506,"kind":13,"containerName":null,"name":"$match"},{"line":507,"name":"$lstart","kind":13,"containerName":null},{"name":"$i","kind":13,"containerName":null,"line":509},{"line":509,"name":"$i","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@bandsA","line":509},{"name":"%i","containerName":null,"kind":13,"line":509},{"kind":13,"containerName":null,"name":"$kband","line":510},{"kind":13,"containerName":null,"name":"@bandsA","line":510},{"line":510,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"$j","line":511},{"kind":13,"containerName":null,"name":"$lstart","line":511},{"name":"$j","containerName":null,"kind":13,"line":511},{"name":"@bandsB","kind":13,"containerName":null,"line":511},{"line":511,"kind":13,"containerName":null,"name":"%j"},{"line":512,"name":"$diff","kind":13,"containerName":null},{"name":"$kband","containerName":null,"kind":13,"line":512},{"line":512,"kind":13,"containerName":null,"name":"@bandsB"},{"name":"$j","kind":13,"containerName":null,"line":512},{"kind":13,"containerName":null,"name":"$diff","line":513},{"containerName":null,"kind":13,"name":"%tol","line":513},{"line":514,"name":"$match","kind":13,"containerName":null},{"name":"$lstart","kind":13,"containerName":null,"line":515},{"line":515,"name":"$j","containerName":null,"kind":13},{"line":518,"kind":13,"containerName":null,"name":"%diff"},{"line":519,"name":"$lstart","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$j","line":519},{"line":524,"name":"$match","containerName":null,"kind":13},{"detail":"($self,$cloneA,$cloneB,$tol,$gellen)","definition":"sub","name":"coincidence_score","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"coincidence_score","localvar":"my","kind":13,"line":541},{"line":541,"name":"$cloneA","kind":13,"containerName":"coincidence_score"},{"kind":13,"containerName":"coincidence_score","name":"$cloneB","line":541},{"name":"$tol","containerName":"coincidence_score","kind":13,"line":541},{"name":"$gellen","containerName":"coincidence_score","kind":13,"line":541},{"line":543,"containerName":"coincidence_score","kind":13,"name":"$cloneA"},{"kind":13,"containerName":"coincidence_score","name":"$cloneB","line":543},{"line":544,"containerName":"coincidence_score","kind":13,"name":"$self"},{"containerName":"coincidence_score","kind":12,"name":"core_exists","line":544},{"line":546,"localvar":"my","kind":13,"containerName":"coincidence_score","name":"%_clones","definition":"my"},{"line":546,"kind":13,"containerName":"coincidence_score","name":"$self"}],"signature":{"parameters":[{"label":"$self"},{"label":"$cloneA"},{"label":"$cloneB"},{"label":"$tol"},{"label":"$gellen"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]","label":"coincidence_score($self,$cloneA,$cloneB,$tol,$gellen)"},"kind":12,"range":{"end":{"character":9999,"line":546},"start":{"character":0,"line":540}},"line":540},{"definition":"my","line":548,"kind":13,"localvar":"my","containerName":null,"name":"$numbandsA"},{"kind":13,"containerName":null,"name":"%_clones","line":548},{"line":548,"name":"%cloneA","containerName":null,"kind":13},{"definition":"my","name":"$numbandsB","localvar":"my","containerName":null,"kind":13,"line":549},{"containerName":null,"kind":13,"name":"%_clones","line":549},{"name":"%cloneB","kind":13,"containerName":null,"line":549},{"definition":"my","line":551,"localvar":"my","kind":13,"containerName":null,"name":"$nL"},{"name":"$nH","kind":13,"containerName":null,"line":551},{"line":551,"name":"$m","containerName":null,"kind":13},{"line":551,"name":"$i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$psmn","line":551},{"line":551,"name":"$pp","containerName":null,"kind":13},{"line":551,"name":"$pa","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$pb","line":551},{"line":551,"name":"$t","containerName":null,"kind":13},{"line":551,"kind":13,"containerName":null,"name":"$c"},{"line":551,"name":"$a","kind":13,"containerName":null},{"line":551,"kind":13,"containerName":null,"name":"$n"},{"definition":"my","name":"@logfact","kind":13,"localvar":"my","containerName":null,"line":552},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$score","line":553},{"line":555,"name":"$gellen","kind":13,"containerName":null},{"line":555,"name":"$gellen","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$tol","line":556},{"name":"$tol","containerName":null,"kind":13,"line":556},{"line":558,"name":"$numbandsA","kind":13,"containerName":null},{"line":558,"name":"%numbandsB","kind":13,"containerName":null},{"line":559,"name":"$nH","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$numbandsA","line":559},{"containerName":null,"kind":13,"name":"$nL","line":560},{"line":560,"kind":13,"containerName":null,"name":"%numbandsB"},{"name":"$nH","kind":13,"containerName":null,"line":563},{"containerName":null,"kind":13,"name":"$numbandsB","line":563},{"kind":13,"containerName":null,"name":"$nL","line":564},{"line":564,"name":"$numbandsA","kind":13,"containerName":null},{"name":"$m","containerName":null,"kind":13,"line":567},{"line":567,"kind":13,"containerName":null,"name":"$self"},{"line":567,"containerName":"main::","kind":12,"name":"matching_bands"},{"containerName":null,"kind":13,"name":"$cloneA","line":567},{"line":567,"name":"$cloneB","kind":13,"containerName":null},{"line":567,"name":"$tol","kind":13,"containerName":null},{"name":"@logfact","kind":13,"containerName":null,"line":569},{"line":570,"name":"@logfact","containerName":null,"kind":13},{"line":571,"name":"$i","kind":13,"containerName":null},{"name":"$i","kind":13,"containerName":null,"line":571},{"line":571,"name":"$nL","kind":13,"containerName":null},{"line":571,"name":"%i","kind":13,"containerName":null},{"line":572,"kind":13,"containerName":null,"name":"@logfact"},{"name":"$i","kind":13,"containerName":null,"line":572},{"containerName":null,"kind":13,"name":"@logfact","line":572},{"name":"$i","containerName":null,"kind":13,"line":572},{"kind":13,"containerName":null,"name":"$i","line":572},{"name":"$psmn","containerName":null,"kind":13,"line":575},{"containerName":null,"kind":13,"name":"$tol","line":575},{"name":"$gellen","kind":13,"containerName":null,"line":575},{"name":"$pp","containerName":null,"kind":13,"line":577},{"containerName":null,"kind":13,"name":"$psmn","line":577},{"name":"$nH","kind":13,"containerName":null,"line":577},{"line":578,"containerName":null,"kind":13,"name":"$pa"},{"line":578,"name":"$pp","kind":13,"containerName":null},{"line":579,"name":"$pb","kind":13,"containerName":null},{"line":579,"name":"$pp","kind":13,"containerName":null},{"name":"$t","kind":13,"containerName":null,"line":580},{"containerName":null,"kind":13,"name":"$n","line":582},{"containerName":null,"kind":13,"name":"$m","line":582},{"name":"$n","containerName":null,"kind":13,"line":582},{"line":582,"containerName":null,"kind":13,"name":"$nL"},{"name":"%n","kind":13,"containerName":null,"line":582},{"line":583,"kind":13,"containerName":null,"name":"$c"},{"line":583,"containerName":null,"kind":13,"name":"@logfact"},{"kind":13,"containerName":null,"name":"$nL","line":583},{"line":583,"name":"@logfact","containerName":null,"kind":13},{"line":583,"name":"$nL","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$n","line":583},{"containerName":null,"kind":13,"name":"@logfact","line":583},{"line":583,"name":"$n","kind":13,"containerName":null},{"line":584,"name":"$a","containerName":null,"kind":13},{"line":584,"containerName":null,"kind":13,"name":"$c"},{"line":584,"kind":13,"containerName":null,"name":"$n"},{"name":"$pb","kind":13,"containerName":null,"line":584},{"kind":13,"containerName":null,"name":"$nL","line":584},{"kind":13,"containerName":null,"name":"$n","line":584},{"line":584,"kind":13,"containerName":null,"name":"$pa"},{"line":585,"kind":13,"containerName":null,"name":"$t"},{"name":"$a","containerName":null,"kind":13,"line":585},{"kind":13,"containerName":null,"name":"$score","line":588},{"name":"$t","kind":13,"containerName":null,"line":588},{"line":589,"name":"$score","containerName":null,"kind":13},{"signature":{"parameters":[{"label":"$self"},{"label":"$showall"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers","label":"print_contiglist($self,$showall)"},"range":{"end":{"line":609,"character":9999},"start":{"line":604,"character":0}},"kind":12,"line":604,"detail":"($self,$showall)","definition":"sub","containerName":"main::","name":"print_contiglist","children":[{"line":605,"name":"$self","kind":13,"localvar":"my","containerName":"print_contiglist","definition":"my"},{"line":605,"name":"$showall","containerName":"print_contiglist","kind":13},{"definition":"my","name":"$pos","kind":13,"localvar":"my","containerName":"print_contiglist","line":606},{"name":"$showall","containerName":"print_contiglist","kind":13,"line":608},{"name":"$showall","kind":13,"containerName":"print_contiglist","line":608},{"line":609,"localvar":"my","containerName":"print_contiglist","kind":13,"name":"%_contigs","definition":"my"},{"line":609,"kind":13,"containerName":"print_contiglist","name":"$self"}]},{"definition":"my","name":"%_markers","kind":13,"localvar":"my","containerName":null,"line":610},{"containerName":null,"kind":13,"name":"%self","line":610},{"kind":13,"localvar":"my","containerName":null,"name":"%_clones","line":611,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":611},{"name":"@contigs","kind":13,"localvar":"my","containerName":null,"line":613,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":613},{"containerName":"main::","kind":12,"name":"each_contigid","line":613},{"definition":"my","name":"@sortedcontigs","containerName":null,"localvar":"my","kind":13,"line":614},{"name":"$a","containerName":null,"kind":13,"line":614},{"containerName":null,"kind":13,"name":"$b","line":614},{"name":"@contigs","kind":13,"containerName":null,"line":614},{"line":617,"localvar":"my","containerName":null,"kind":13,"name":"$contig","definition":"my"},{"line":617,"kind":13,"containerName":null,"name":"@sortedcontigs"},{"definition":"my","line":618,"localvar":"my","kind":13,"containerName":null,"name":"%list"},{"localvar":"my","containerName":null,"kind":13,"name":"%alist","line":619,"definition":"my"},{"localvar":"my","kind":13,"containerName":null,"name":"$ctgAnchor","line":621,"definition":"my"},{"line":621,"containerName":null,"kind":13,"name":"%_contigs"},{"name":"%contig","containerName":null,"kind":13,"line":621},{"name":"$ctgGroup","kind":13,"localvar":"my","containerName":null,"line":622,"definition":"my"},{"line":622,"name":"%_contigs","kind":13,"containerName":null},{"name":"%contig","containerName":null,"kind":13,"line":622},{"name":"@mkr","localvar":"my","containerName":null,"kind":13,"line":624,"definition":"my"},{"line":624,"kind":13,"containerName":null,"name":"%_contigs"},{"name":"%contig","containerName":null,"kind":13,"line":624},{"definition":"my","name":"$marker","localvar":"my","containerName":null,"kind":13,"line":626},{"name":"@mkr","containerName":null,"kind":13,"line":626},{"name":"$mrkGroup","localvar":"my","kind":13,"containerName":null,"line":627,"definition":"my"},{"line":627,"name":"%_markers","kind":13,"containerName":null},{"line":627,"kind":13,"containerName":null,"name":"%marker"},{"kind":13,"localvar":"my","containerName":null,"name":"$mrkGlobal","line":628,"definition":"my"},{"line":628,"name":"%_markers","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%marker","line":628},{"definition":"my","line":629,"name":"$mrkFramework","localvar":"my","containerName":null,"kind":13},{"name":"%_markers","kind":13,"containerName":null,"line":629},{"line":629,"containerName":null,"kind":13,"name":"%marker"},{"line":630,"name":"$mrkAnchor","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"%_markers","kind":13,"containerName":null,"line":630},{"line":630,"name":"%marker","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$ctgGroup","line":632},{"containerName":null,"kind":13,"name":"%ctgGroup","line":632},{"kind":13,"containerName":null,"name":"$mrkGroup","line":633},{"line":633,"name":"%ctgGroup","containerName":null,"kind":13},{"line":634,"kind":13,"containerName":null,"name":"%mrkFramework"},{"line":635,"name":"$pos","kind":13,"containerName":null},{"line":635,"name":"%mrkGlobal","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$pos","line":638},{"name":"$mrkGlobal","containerName":null,"kind":13,"line":638},{"containerName":null,"kind":13,"name":"%list","line":640},{"kind":13,"containerName":null,"name":"$marker","line":640},{"line":640,"kind":13,"containerName":null,"name":"$pos"},{"line":642,"kind":13,"containerName":null,"name":"%showall"},{"definition":"my","line":643,"containerName":null,"localvar":"my","kind":13,"name":"$chr"},{"name":"$self","kind":13,"containerName":null,"line":643},{"name":"group_abbr","kind":12,"containerName":"main::","line":643},{"kind":13,"containerName":null,"name":"$mrkGroup","line":643},{"line":644,"name":"%alist","kind":13,"containerName":null},{"line":644,"name":"$marker","kind":13,"containerName":null},{"line":644,"name":"$chr","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$showall","line":647},{"line":647,"name":"%ctgGroup","kind":13,"containerName":null},{"definition":"my","name":"$chr","localvar":"my","containerName":null,"kind":13,"line":648},{"line":648,"kind":13,"containerName":null,"name":"$self"},{"line":648,"name":"group_abbr","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$mrkGroup","line":648},{"kind":13,"containerName":null,"name":"%alist","line":649},{"kind":13,"containerName":null,"name":"$marker","line":649},{"name":"$chr","containerName":null,"kind":13,"line":649},{"definition":"my","line":653,"name":"$chr","localvar":"my","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$ctgGroup","line":653},{"name":"$chr","containerName":null,"kind":13,"line":654},{"line":654,"name":"$self","containerName":null,"kind":13},{"line":654,"name":"group_abbr","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$ctgGroup","line":654},{"line":654,"name":"$ctgGroup","kind":13,"containerName":null},{"name":"%showall","kind":13,"containerName":null,"line":656},{"name":"$chr","containerName":null,"kind":13,"line":658},{"line":659,"containerName":null,"kind":13,"name":"%_contigs"},{"containerName":null,"kind":13,"name":"%contig","line":659},{"line":661,"name":"$ctgGroup","kind":13,"containerName":null},{"name":"%ctgGroup","containerName":null,"kind":13,"line":661},{"containerName":null,"kind":13,"name":"$contig","line":662},{"line":662,"name":"$chr","containerName":null,"kind":13},{"name":"$k","containerName":null,"localvar":"my","kind":13,"line":665,"definition":"my"},{"name":"$v","containerName":null,"kind":13,"line":665},{"name":"%list","kind":13,"containerName":null,"line":665},{"line":669,"name":"$showall","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$ctgGroup","line":669},{"name":"$ctgGroup","kind":13,"containerName":null,"line":670},{"line":672,"containerName":null,"kind":13,"name":"%showall"},{"line":673,"name":"$k","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":673,"containerName":null,"kind":13,"name":"$v"},{"line":673,"kind":13,"containerName":null,"name":"%alist"},{"signature":{"label":"print_markerlist($self)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":695,"character":9999},"start":{"character":0,"line":692}},"line":692,"detail":"($self)","definition":"sub","name":"print_markerlist","containerName":"main::","children":[{"line":693,"kind":13,"localvar":"my","containerName":"print_markerlist","name":"$self","definition":"my"},{"line":695,"name":"%_contigs","containerName":"print_markerlist","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"print_markerlist","line":695}]},{"line":696,"name":"%_markers","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":696,"containerName":null,"kind":13,"name":"%self"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"%_clones","line":697},{"line":697,"name":"%self","kind":13,"containerName":null},{"name":"$marker","localvar":"my","kind":13,"containerName":null,"line":701,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":701},{"line":701,"name":"each_markerid","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$marker","line":702},{"line":704,"kind":13,"localvar":"my","containerName":null,"name":"%list","definition":"my"},{"localvar":"my","kind":13,"containerName":null,"name":"%mclones","line":705,"definition":"my"},{"line":705,"containerName":null,"kind":13,"name":"%_markers"},{"line":705,"name":"%marker","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"$clone","line":707,"definition":"my"},{"kind":13,"containerName":null,"name":"%mclones","line":707},{"containerName":null,"kind":13,"name":"%_clones","line":708},{"line":708,"containerName":null,"kind":13,"name":"%clone"},{"kind":13,"localvar":"my","containerName":null,"name":"$ctg","line":709,"definition":"my"},{"containerName":null,"kind":13,"name":"%_clones","line":709},{"name":"%clone","containerName":null,"kind":13,"line":709},{"kind":13,"containerName":null,"name":"%list","line":711},{"containerName":null,"kind":13,"name":"%ctg","line":711},{"definition":"my","line":712,"name":"$clonehits","kind":13,"localvar":"my","containerName":null},{"line":712,"name":"%list","containerName":null,"kind":13},{"line":712,"name":"$ctg","containerName":null,"kind":13},{"line":713,"name":"$clonehits","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%list","line":714},{"kind":13,"containerName":null,"name":"$ctg","line":714},{"line":714,"name":"%clonehits","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%list","line":717},{"name":"$ctg","kind":13,"containerName":null,"line":717},{"definition":"my","line":721,"localvar":"my","containerName":null,"kind":13,"name":"$k"},{"kind":13,"containerName":null,"name":"$v","line":721},{"line":721,"name":"%list","containerName":null,"kind":13},{"definition":"sub","detail":"($self,$style)","children":[{"definition":"my","line":740,"name":"$self","localvar":"my","containerName":"print_gffstyle","kind":13},{"name":"$style","kind":13,"containerName":"print_gffstyle","line":740},{"line":742,"name":"$style","containerName":"print_gffstyle","kind":13},{"kind":13,"containerName":"print_gffstyle","name":"$style","line":742},{"localvar":"my","kind":13,"containerName":"print_gffstyle","name":"%_contigs","line":744,"definition":"my"},{"line":744,"containerName":"print_gffstyle","kind":13,"name":"$self"}],"name":"print_gffstyle","containerName":"main::","signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).","parameters":[{"label":"$self"},{"label":"$style"}],"label":"print_gffstyle($self,$style)"},"line":739,"range":{"start":{"line":739,"character":0},"end":{"line":744,"character":9999}},"kind":12},{"kind":13,"localvar":"my","containerName":null,"name":"%_markers","line":745,"definition":"my"},{"line":745,"name":"%self","containerName":null,"kind":13},{"definition":"my","line":746,"containerName":null,"localvar":"my","kind":13,"name":"%_clones"},{"line":746,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"localvar":"my","containerName":null,"name":"$i","line":748,"definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"$depth","line":749,"definition":"my"},{"line":749,"name":"$save_depth","containerName":null,"kind":13},{"definition":"my","name":"$x","containerName":null,"localvar":"my","kind":13,"line":750},{"name":"$y","kind":13,"containerName":null,"line":750},{"definition":"my","line":751,"localvar":"my","kind":13,"containerName":null,"name":"@stack"},{"definition":"my","line":752,"kind":13,"localvar":"my","containerName":null,"name":"$k"},{"line":752,"kind":13,"containerName":null,"name":"$j"},{"name":"$s","kind":13,"containerName":null,"line":752},{"line":753,"kind":13,"localvar":"my","containerName":null,"name":"$pos","definition":"my"},{"line":754,"containerName":null,"localvar":"my","kind":13,"name":"$contig","definition":"my"},{"line":758,"name":"@contigs","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":758,"kind":13,"containerName":null,"name":"$self"},{"name":"each_contigid","kind":12,"containerName":"main::","line":758},{"name":"@sortedcontigs","containerName":null,"localvar":"my","kind":13,"line":759,"definition":"my"},{"name":"$a","kind":13,"containerName":null,"line":759},{"line":759,"name":"$b","kind":13,"containerName":null},{"line":759,"containerName":null,"kind":13,"name":"@contigs"},{"line":760,"name":"$offset","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"definition":"my","line":761,"kind":13,"localvar":"my","containerName":null,"name":"%gffclones"},{"line":762,"kind":13,"localvar":"my","containerName":null,"name":"%gffcontigs","definition":"my"},{"line":763,"name":"%gffmarkers","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":764,"name":"$basepair","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"localvar":"my","kind":13,"containerName":null,"name":"$contig","line":766,"definition":"my"},{"containerName":null,"kind":13,"name":"@sortedcontigs","line":766},{"containerName":null,"kind":13,"name":"%_contigs","line":767},{"containerName":null,"kind":13,"name":"%contig","line":767},{"line":768,"kind":13,"containerName":null,"name":"$offset"},{"kind":13,"containerName":null,"name":"%_contigs","line":768},{"line":768,"kind":13,"containerName":null,"name":"%contig"},{"kind":13,"containerName":null,"name":"%offset","line":770},{"line":771,"name":"$offset","containerName":null,"kind":13},{"name":"$offset","kind":13,"containerName":null,"line":771},{"name":"%gffcontigs","kind":13,"containerName":null,"line":772},{"line":772,"kind":13,"containerName":null,"name":"%contig"},{"containerName":null,"kind":13,"name":"%gffcontigs","line":773},{"line":773,"name":"%contig","kind":13,"containerName":null},{"name":"%_contigs","kind":13,"containerName":null,"line":774},{"containerName":null,"kind":13,"name":"%contig","line":774},{"name":"$offset","kind":13,"containerName":null,"line":775},{"kind":13,"containerName":null,"name":"%basepair","line":775},{"line":778,"name":"$offset","containerName":null,"kind":13},{"line":779,"name":"%gffcontigs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%contig","line":779},{"line":780,"kind":13,"containerName":null,"name":"%_contigs"},{"line":780,"name":"%contig","containerName":null,"kind":13},{"line":780,"name":"$basepair","containerName":null,"kind":13},{"name":"%gffcontigs","kind":13,"containerName":null,"line":781},{"line":781,"containerName":null,"kind":13,"name":"%contig"},{"name":"%_contigs","kind":13,"containerName":null,"line":782},{"line":782,"kind":13,"containerName":null,"name":"%contig"},{"line":782,"name":"%basepair","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%gffcontigs","line":786},{"line":786,"containerName":null,"kind":13,"name":"%contig"},{"line":787,"name":"%gffcontigs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%contig","line":787},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@clones","line":790},{"line":790,"containerName":null,"kind":13,"name":"%_contigs"},{"line":790,"name":"%contig","kind":13,"containerName":null},{"definition":"my","line":791,"kind":13,"localvar":"my","containerName":null,"name":"$clone"},{"line":791,"kind":13,"containerName":null,"name":"@clones"},{"kind":13,"containerName":null,"name":"%_clones","line":792},{"line":792,"name":"%clone","kind":13,"containerName":null},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$gffclone","line":793},{"name":"$clone","containerName":null,"kind":13,"line":793},{"line":795,"name":"$gffclone","containerName":null,"kind":13},{"name":"%gffclones","kind":13,"containerName":null,"line":797},{"line":797,"kind":13,"containerName":null,"name":"%gffclone"},{"line":798,"containerName":null,"kind":13,"name":"%_clones"},{"line":798,"kind":13,"containerName":null,"name":"%clone"},{"name":"$offset","kind":13,"containerName":null,"line":798},{"kind":13,"containerName":null,"name":"$basepair","line":799},{"containerName":null,"kind":13,"name":"%gffclones","line":801},{"name":"%gffclone","kind":13,"containerName":null,"line":801},{"line":802,"name":"%_clones","containerName":null,"kind":13},{"line":802,"kind":13,"containerName":null,"name":"%clone"},{"line":803,"kind":13,"containerName":null,"name":"$offset"},{"line":803,"name":"$basepair","kind":13,"containerName":null},{"line":806,"kind":13,"containerName":null,"name":"%contig"},{"containerName":null,"localvar":"my","kind":13,"name":"%markers","line":807,"definition":"my"},{"name":"%_clones","containerName":null,"kind":13,"line":807},{"kind":13,"containerName":null,"name":"%clone","line":807},{"line":808,"kind":13,"containerName":null,"name":"%_clones"},{"line":808,"name":"%clone","containerName":null,"kind":13},{"line":810,"localvar":"my","containerName":null,"kind":13,"name":"$k","definition":"my"},{"name":"$v","containerName":null,"kind":13,"line":810},{"kind":13,"containerName":null,"name":"%markers","line":810},{"name":"%gffmarkers","kind":13,"containerName":null,"line":811},{"kind":13,"containerName":null,"name":"%contig","line":811},{"line":811,"kind":13,"containerName":null,"name":"$k"},{"line":812,"containerName":null,"kind":13,"name":"%_clones"},{"kind":13,"containerName":null,"name":"%clone","line":812},{"line":813,"kind":13,"containerName":null,"name":"%_clones"},{"name":"%clone","kind":13,"containerName":null,"line":813},{"line":814,"containerName":null,"kind":13,"name":"$basepair"},{"line":819,"kind":13,"containerName":null,"name":"%contig"},{"definition":"my","line":820,"name":"%markers","localvar":"my","kind":13,"containerName":null},{"name":"%_contigs","kind":13,"containerName":null,"line":820},{"name":"%contig","kind":13,"containerName":null,"line":820},{"containerName":null,"kind":13,"name":"%_contigs","line":821},{"name":"%contig","containerName":null,"kind":13,"line":821},{"kind":13,"localvar":"my","containerName":null,"name":"$k","line":823,"definition":"my"},{"containerName":null,"kind":13,"name":"$v","line":823},{"name":"%markers","containerName":null,"kind":13,"line":823},{"kind":13,"containerName":null,"name":"%gffmarkers","line":824},{"line":824,"containerName":null,"kind":13,"name":"%contig"},{"kind":13,"containerName":null,"name":"$k","line":824},{"kind":13,"containerName":null,"name":"$v","line":824},{"line":824,"name":"$offset","containerName":null,"kind":13},{"line":824,"name":"$basepair","kind":13,"containerName":null},{"name":"%style","containerName":null,"kind":13,"line":829},{"definition":"my","line":830,"containerName":null,"localvar":"my","kind":13,"name":"$contig"},{"name":"@sortedcontigs","kind":13,"containerName":null,"line":830},{"kind":13,"containerName":null,"name":"%_contigs","line":832},{"containerName":null,"kind":13,"name":"%contig","line":832},{"line":834,"kind":13,"containerName":null,"name":"%gffcontigs"},{"kind":13,"containerName":null,"name":"%contig","line":834},{"line":835,"kind":13,"containerName":null,"name":"%gffcontigs"},{"line":835,"kind":13,"containerName":null,"name":"%contig"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@clones","line":840},{"line":840,"name":"%_contigs","containerName":null,"kind":13},{"name":"%contig","kind":13,"containerName":null,"line":840},{"localvar":"my","containerName":null,"kind":13,"name":"$clone","line":842,"definition":"my"},{"kind":13,"containerName":null,"name":"@clones","line":842},{"kind":13,"containerName":null,"name":"%_clones","line":843},{"line":843,"name":"%clone","containerName":null,"kind":13},{"line":846,"kind":13,"localvar":"my","containerName":null,"name":"$type","definition":"my"},{"line":846,"name":"%_clones","kind":13,"containerName":null},{"line":846,"name":"%clone","containerName":null,"kind":13},{"name":"%clone","kind":13,"containerName":null,"line":848},{"line":849,"name":"$clone","containerName":null,"kind":13},{"line":850,"kind":13,"containerName":null,"name":"$type"},{"name":"%gffclones","kind":13,"containerName":null,"line":852},{"name":"%clone","kind":13,"containerName":null,"line":852},{"line":853,"name":"%gffclones","kind":13,"containerName":null},{"name":"%clone","containerName":null,"kind":13,"line":853},{"line":856,"localvar":"my","kind":13,"containerName":null,"name":"@markers","definition":"my"},{"line":856,"name":"%_clones","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%clone","line":856},{"line":857,"name":"@markers","containerName":null,"kind":13},{"definition":"my","line":859,"name":"$mkr","localvar":"my","containerName":null,"kind":13},{"line":859,"name":"@markers","containerName":null,"kind":13},{"name":"%_markers","kind":13,"containerName":null,"line":860},{"line":860,"name":"%mkr","kind":13,"containerName":null},{"line":861,"name":"%_markers","kind":13,"containerName":null},{"line":861,"kind":13,"containerName":null,"name":"%mkr"},{"line":862,"name":"%_markers","containerName":null,"kind":13},{"name":"%mkr","kind":13,"containerName":null,"line":862},{"line":868,"kind":13,"containerName":null,"name":"%_clones"},{"line":868,"kind":13,"containerName":null,"name":"%clone"},{"name":"%_clones","containerName":null,"kind":13,"line":869},{"line":869,"name":"%clone","kind":13,"containerName":null},{"name":"%_contigs","kind":13,"containerName":null,"line":874},{"name":"%contig","containerName":null,"kind":13,"line":874},{"definition":"my","line":875,"kind":13,"localvar":"my","containerName":null,"name":"%list"},{"line":875,"containerName":null,"kind":13,"name":"%_contigs"},{"name":"%contig","containerName":null,"kind":13,"line":875},{"definition":"my","line":877,"name":"$k","kind":13,"localvar":"my","containerName":null},{"line":877,"name":"$v","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%list","line":877},{"name":"$contig","kind":13,"containerName":null,"line":878},{"definition":"my","line":879,"containerName":null,"localvar":"my","kind":13,"name":"$position"},{"line":879,"name":"%gffmarkers","kind":13,"containerName":null},{"line":879,"containerName":null,"kind":13,"name":"%contig"},{"kind":13,"containerName":null,"name":"$k","line":879},{"definition":"my","name":"$type","localvar":"my","containerName":null,"kind":13,"line":881},{"name":"$type","kind":13,"containerName":null,"line":883},{"kind":13,"containerName":null,"name":"%_markers","line":884},{"kind":13,"containerName":null,"name":"%k","line":884},{"line":886,"name":"%_markers","containerName":null,"kind":13},{"name":"%k","kind":13,"containerName":null,"line":886},{"line":887,"kind":13,"containerName":null,"name":"$type"},{"line":888,"name":"%_markers","kind":13,"containerName":null},{"line":888,"name":"%k","kind":13,"containerName":null},{"line":890,"name":"$type","kind":13,"containerName":null},{"name":"%_markers","kind":13,"containerName":null,"line":891},{"line":891,"containerName":null,"kind":13,"name":"%k"},{"line":894,"name":"$position","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$position","line":894},{"line":897,"name":"@clonelist","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":898,"localvar":"my","kind":13,"containerName":null,"name":"@clones","definition":"my"},{"line":898,"name":"%_markers","kind":13,"containerName":null},{"line":898,"kind":13,"containerName":null,"name":"%k"},{"line":900,"name":"$cl","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"@clones","line":900},{"line":901,"name":"@clonelist","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$cl","line":901},{"kind":13,"containerName":null,"name":"%_clones","line":902},{"kind":13,"containerName":null,"name":"%cl","line":902},{"kind":13,"containerName":null,"name":"$contig","line":902},{"line":906,"name":"@clonelist","containerName":null,"kind":13},{"line":913,"localvar":"my","kind":13,"containerName":null,"name":"%_groups","definition":"my"},{"name":"$margin","kind":13,"localvar":"my","containerName":null,"line":914,"definition":"my"},{"line":914,"name":"$basepair","containerName":null,"kind":13},{"localvar":"my","containerName":null,"kind":13,"name":"$displacement","line":915,"definition":"my"},{"definition":"my","line":916,"name":"@grouplist","containerName":null,"localvar":"my","kind":13},{"line":918,"name":"$contig","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"@sortedcontigs","kind":13,"containerName":null,"line":918},{"line":919,"containerName":null,"localvar":"my","kind":13,"name":"$recordchr","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$chr","line":920},{"line":920,"containerName":null,"kind":13,"name":"%_contigs"},{"line":920,"kind":13,"containerName":null,"name":"%contig"},{"kind":13,"containerName":null,"name":"$chr","line":921},{"line":921,"name":"$chr","containerName":null,"kind":13},{"line":923,"name":"%recordchr","kind":13,"containerName":null},{"line":923,"name":"group","kind":12},{"name":"$chr","kind":13,"containerName":null,"line":923},{"name":"%recordchr","containerName":null,"kind":13,"line":924},{"line":924,"kind":12,"name":"contig"},{"line":924,"name":"$contig","containerName":null,"kind":13},{"line":925,"name":"%recordchr","kind":13,"containerName":null},{"line":925,"name":"position","kind":12},{"line":925,"kind":13,"containerName":null,"name":"%_contigs"},{"name":"%contig","containerName":null,"kind":13,"line":925},{"containerName":null,"kind":13,"name":"@grouplist","line":927},{"kind":13,"containerName":null,"name":"$recordchr","line":927},{"containerName":null,"localvar":"my","kind":13,"name":"@chr","line":930,"definition":"my"},{"line":930,"kind":13,"containerName":null,"name":"%_groups"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"@sortedchr","line":931},{"line":933,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"group_type","line":933},{"line":934,"kind":13,"containerName":null,"name":"@sortedchr"},{"line":934,"kind":13,"containerName":null,"name":"%a"},{"kind":13,"containerName":null,"name":"%b","line":934},{"line":936,"name":"%a","containerName":null,"kind":13},{"line":936,"kind":13,"containerName":null,"name":"%b"},{"kind":13,"containerName":null,"name":"@grouplist","line":937},{"line":940,"kind":13,"containerName":null,"name":"@sortedchr"},{"line":940,"kind":13,"containerName":null,"name":"%a"},{"kind":13,"containerName":null,"name":"%b","line":940},{"line":942,"name":"%a","kind":13,"containerName":null},{"line":942,"name":"%b","containerName":null,"kind":13},{"line":943,"kind":13,"containerName":null,"name":"@grouplist"},{"definition":"my","line":945,"localvar":"my","containerName":null,"kind":13,"name":"$lastchr"},{"line":946,"kind":13,"localvar":"my","containerName":null,"name":"$chrend","definition":"my"},{"name":"$chr","containerName":null,"localvar":"my","kind":13,"line":948,"definition":"my"},{"line":948,"kind":13,"containerName":null,"name":"@sortedchr"},{"definition":"my","name":"$chrname","localvar":"my","kind":13,"containerName":null,"line":949},{"name":"$self","kind":13,"containerName":null,"line":949},{"containerName":"main::","kind":12,"name":"group_abbr","line":949},{"name":"%chr","kind":13,"containerName":null,"line":949},{"line":951,"kind":13,"containerName":null,"name":"$lastchr"},{"name":"%chr","kind":13,"containerName":null,"line":951},{"name":"%lastchr","kind":13,"containerName":null,"line":951},{"line":952,"name":"$lastchr","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%chr","line":952},{"name":"$lastchr","containerName":null,"kind":13,"line":952},{"line":953,"name":"$displacement","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$ctgcount","line":956},{"line":957,"localvar":"my","containerName":null,"kind":13,"name":"$prevchr","definition":"my"},{"name":"$chrend","containerName":null,"kind":13,"line":958},{"line":960,"kind":13,"containerName":null,"name":"%chr"},{"name":"contig","kind":12,"line":960},{"definition":"my","line":961,"kind":13,"localvar":"my","containerName":null,"name":"$ch"},{"line":961,"kind":13,"containerName":null,"name":"@sortedchr"},{"line":962,"containerName":null,"kind":13,"name":"%ch"},{"kind":13,"containerName":null,"name":"%chr","line":962},{"line":963,"kind":13,"containerName":null,"name":"%ch"},{"definition":"my","line":964,"name":"$ctg","localvar":"my","kind":13,"containerName":null},{"line":964,"kind":13,"containerName":null,"name":"%ch"},{"kind":13,"containerName":null,"name":"%ch","line":965},{"containerName":null,"kind":13,"name":"$chrend","line":967},{"line":967,"kind":13,"containerName":null,"name":"%gffcontigs"},{"kind":13,"containerName":null,"name":"%ctg","line":967},{"name":"$ctgcount","containerName":null,"kind":13,"line":968},{"line":972,"name":"$chrend","containerName":null,"kind":13},{"line":972,"kind":13,"containerName":null,"name":"$ctgcount"},{"line":972,"name":"%margin","kind":13,"containerName":null},{"line":975,"containerName":null,"kind":13,"name":"$chrend"},{"line":975,"name":"%gffcontigs","containerName":null,"kind":13},{"line":978,"kind":13,"containerName":null,"name":"$chrname"},{"containerName":null,"kind":13,"name":"$self","line":978},{"line":978,"kind":12,"containerName":"main::","name":"group_abbr"},{"kind":13,"containerName":null,"name":"%chr","line":979},{"line":981,"containerName":null,"kind":13,"name":"$chrname"},{"line":986,"kind":13,"containerName":null,"name":"$chrname"},{"containerName":null,"kind":13,"name":"%chr","line":989},{"name":"$lastchr","containerName":null,"kind":13,"line":989},{"name":"%chr","kind":13,"containerName":null,"line":989},{"name":"$lastchr","kind":13,"containerName":null,"line":991},{"line":991,"name":"%chr","kind":13,"containerName":null},{"name":"$lastchr","containerName":null,"kind":13,"line":992},{"kind":13,"containerName":null,"name":"%chr","line":992},{"kind":13,"localvar":"my","containerName":null,"name":"$contig","line":994,"definition":"my"},{"line":994,"name":"%chr","kind":13,"containerName":null},{"name":"%_contigs","kind":13,"containerName":null,"line":996},{"line":996,"name":"%contig","kind":13,"containerName":null},{"line":998,"containerName":null,"kind":13,"name":"$chrname"},{"kind":13,"containerName":null,"name":"%gffcontigs","line":999},{"name":"%contig","containerName":null,"kind":13,"line":999},{"containerName":null,"kind":13,"name":"$displacement","line":999},{"name":"%gffcontigs","kind":13,"containerName":null,"line":1000},{"name":"%contig","kind":13,"containerName":null,"line":1000},{"line":1000,"name":"$displacement","containerName":null,"kind":13},{"definition":"my","line":1005,"name":"@clones","kind":13,"localvar":"my","containerName":null},{"kind":13,"containerName":null,"name":"%_contigs","line":1005},{"name":"%contig","containerName":null,"kind":13,"line":1005},{"definition":"my","name":"$clone","localvar":"my","kind":13,"containerName":null,"line":1006},{"line":1006,"name":"@clones","kind":13,"containerName":null},{"line":1007,"name":"%_clones","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%clone","line":1007},{"kind":13,"containerName":null,"name":"$chrname","line":1008},{"line":1009,"containerName":null,"localvar":"my","kind":13,"name":"$type","definition":"my"},{"containerName":null,"kind":13,"name":"%_clones","line":1009},{"kind":13,"containerName":null,"name":"%clone","line":1009},{"line":1011,"kind":13,"containerName":null,"name":"%clone"},{"line":1012,"name":"$clone","containerName":null,"kind":13},{"line":1013,"name":"$type","containerName":null,"kind":13},{"line":1016,"name":"%gffclones","containerName":null,"kind":13},{"name":"%clone","containerName":null,"kind":13,"line":1016},{"name":"$displacement","kind":13,"containerName":null,"line":1017},{"line":1017,"name":"%gffclones","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%clone","line":1017},{"kind":13,"containerName":null,"name":"$displacement","line":1018},{"containerName":null,"localvar":"my","kind":13,"name":"@markers","line":1021,"definition":"my"},{"kind":13,"containerName":null,"name":"%_clones","line":1021},{"line":1021,"name":"%clone","kind":13,"containerName":null},{"name":"@markers","containerName":null,"kind":13,"line":1022},{"line":1024,"name":"$mkr","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"@markers","line":1024},{"line":1025,"name":"%_markers","kind":13,"containerName":null},{"line":1025,"kind":13,"containerName":null,"name":"%mkr"},{"line":1026,"name":"%_markers","containerName":null,"kind":13},{"name":"%mkr","containerName":null,"kind":13,"line":1026},{"line":1027,"name":"%_markers","kind":13,"containerName":null},{"line":1027,"name":"%mkr","kind":13,"containerName":null},{"line":1033,"name":"%_clones","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%clone","line":1033},{"line":1034,"kind":13,"containerName":null,"name":"%_clones"},{"containerName":null,"kind":13,"name":"%clone","line":1034},{"line":1039,"kind":13,"containerName":null,"name":"%_contigs"},{"line":1039,"kind":13,"containerName":null,"name":"%contig"},{"containerName":null,"localvar":"my","kind":13,"name":"%list","line":1040,"definition":"my"},{"containerName":null,"kind":13,"name":"%_contigs","line":1040},{"line":1040,"name":"%contig","containerName":null,"kind":13},{"line":1042,"name":"$k","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1042,"name":"$v","kind":13,"containerName":null},{"name":"%list","containerName":null,"kind":13,"line":1042},{"name":"$chrname","kind":13,"containerName":null,"line":1043},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$type","line":1044},{"name":"$type","kind":13,"containerName":null,"line":1046},{"kind":13,"containerName":null,"name":"%_markers","line":1047},{"kind":13,"containerName":null,"name":"%k","line":1047},{"name":"%_markers","containerName":null,"kind":13,"line":1049},{"line":1049,"kind":13,"containerName":null,"name":"%k"},{"line":1050,"containerName":null,"kind":13,"name":"$type"},{"line":1051,"name":"%_markers","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%k","line":1051},{"line":1053,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"kind":13,"name":"%_markers","line":1054},{"name":"%k","kind":13,"containerName":null,"line":1054},{"line":1057,"name":"%gffmarkers","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%contig","line":1057},{"line":1057,"name":"$k","containerName":null,"kind":13},{"line":1058,"kind":13,"containerName":null,"name":"$displacement"},{"line":1058,"containerName":null,"kind":13,"name":"%gffmarkers"},{"name":"%contig","kind":13,"containerName":null,"line":1058},{"name":"$k","kind":13,"containerName":null,"line":1058},{"line":1059,"kind":13,"containerName":null,"name":"$displacement"},{"definition":"my","line":1062,"name":"@clonelist","localvar":"my","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@clones","line":1063},{"name":"%_markers","kind":13,"containerName":null,"line":1063},{"kind":13,"containerName":null,"name":"%k","line":1063},{"line":1065,"localvar":"my","containerName":null,"kind":13,"name":"$cl","definition":"my"},{"containerName":null,"kind":13,"name":"@clones","line":1065},{"line":1066,"containerName":null,"kind":13,"name":"@clonelist"},{"name":"$cl","kind":13,"containerName":null,"line":1066},{"kind":13,"containerName":null,"name":"%_clones","line":1067},{"line":1067,"kind":13,"containerName":null,"name":"%cl"},{"kind":13,"containerName":null,"name":"$contig","line":1067},{"line":1072,"name":"@clonelist","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$displacement","line":1075},{"kind":13,"containerName":null,"name":"$margin","line":1075},{"line":1075,"kind":13,"containerName":null,"name":"%gffcontigs"},{"name":"%contig","containerName":null,"kind":13,"line":1075},{"line":1090,"range":{"start":{"line":1090,"character":0},"end":{"character":9999,"line":1092}},"kind":12,"signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"_calc_markerposition($self)"},"children":[{"containerName":"_calc_markerposition","localvar":"my","kind":13,"name":"$self","line":1091,"definition":"my"},{"line":1092,"localvar":"my","kind":13,"containerName":"_calc_markerposition","name":"%_contigs","definition":"my"},{"containerName":"_calc_markerposition","kind":13,"name":"$self","line":1092}],"containerName":"main::","name":"_calc_markerposition","definition":"sub","detail":"($self)"},{"name":"%_markers","localvar":"my","kind":13,"containerName":null,"line":1093,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":1093},{"definition":"my","line":1094,"localvar":"my","kind":13,"containerName":null,"name":"%_clones"},{"line":1094,"kind":13,"containerName":null,"name":"%self"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$i","line":1096},{"definition":"my","line":1097,"kind":13,"localvar":"my","containerName":null,"name":"$depth"},{"line":1097,"kind":13,"containerName":null,"name":"$save_depth"},{"name":"$x","containerName":null,"localvar":"my","kind":13,"line":1098,"definition":"my"},{"kind":13,"containerName":null,"name":"$y","line":1098},{"line":1099,"kind":13,"localvar":"my","containerName":null,"name":"@stack","definition":"my"},{"definition":"my","name":"$k","kind":13,"localvar":"my","containerName":null,"line":1100},{"containerName":null,"kind":13,"name":"$j","line":1100},{"line":1100,"name":"$s","kind":13,"containerName":null},{"name":"$pos","localvar":"my","containerName":null,"kind":13,"line":1101,"definition":"my"},{"definition":"my","line":1102,"kind":13,"localvar":"my","containerName":null,"name":"$contig"},{"kind":13,"localvar":"my","containerName":null,"name":"@contigs","line":1106,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":1106},{"containerName":"main::","kind":12,"name":"each_contigid","line":1106},{"line":1107,"name":"@sortedcontigs","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"$a","line":1107},{"name":"$b","containerName":null,"kind":13,"line":1107},{"containerName":null,"kind":13,"name":"@contigs","line":1107},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$offset","line":1108},{"definition":"my","name":"%gffclones","containerName":null,"localvar":"my","kind":13,"line":1109},{"line":1110,"name":"%gffcontigs","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$marker","localvar":"my","kind":13,"containerName":null,"line":1112,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":1112},{"containerName":"main::","kind":12,"name":"each_markerid","line":1112},{"definition":"my","name":"@ctgmarker","localvar":"my","containerName":null,"kind":13,"line":1113},{"line":1113,"containerName":null,"kind":13,"name":"@sortedctgmarker"},{"line":1115,"localvar":"my","containerName":null,"kind":13,"name":"@clones","definition":"my"},{"line":1115,"name":"%_markers","kind":13,"containerName":null},{"name":"%marker","kind":13,"containerName":null,"line":1115},{"line":1116,"kind":13,"containerName":null,"name":"%_markers"},{"containerName":null,"kind":13,"name":"%marker","line":1116},{"definition":"my","name":"$clone","localvar":"my","kind":13,"containerName":null,"line":1118},{"line":1118,"name":"@clones","kind":13,"containerName":null},{"definition":"my","name":"$record","kind":13,"localvar":"my","containerName":null,"line":1119},{"kind":13,"containerName":null,"name":"%record","line":1120},{"name":"contig","kind":12,"line":1120},{"line":1120,"kind":13,"containerName":null,"name":"%_clones"},{"line":1120,"containerName":null,"kind":13,"name":"%clone"},{"line":1121,"kind":13,"containerName":null,"name":"%record"},{"kind":12,"name":"start","line":1121},{"name":"%_clones","kind":13,"containerName":null,"line":1121},{"line":1121,"containerName":null,"kind":13,"name":"%clone"},{"line":1122,"name":"%record","containerName":null,"kind":13},{"line":1122,"name":"end","kind":12},{"line":1122,"kind":13,"containerName":null,"name":"%_clones"},{"line":1122,"containerName":null,"kind":13,"name":"%clone"},{"kind":13,"containerName":null,"name":"@ctgmarker","line":1123},{"line":1123,"name":"$record","kind":13,"containerName":null},{"line":1127,"containerName":null,"kind":13,"name":"@sortedctgmarker"},{"kind":13,"containerName":null,"name":"%a","line":1127},{"line":1127,"name":"%b","containerName":null,"kind":13},{"line":1129,"containerName":null,"kind":13,"name":"%b"},{"line":1129,"name":"%a","kind":13,"containerName":null},{"line":1130,"kind":13,"containerName":null,"name":"@ctgmarker"},{"line":1132,"localvar":"my","kind":13,"containerName":null,"name":"$ctg","definition":"my"},{"line":1134,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$i","line":1134},{"kind":13,"containerName":null,"name":"@sortedctgmarker","line":1134},{"name":"%i","kind":13,"containerName":null,"line":1134},{"name":"$ctg","kind":13,"containerName":null,"line":1135},{"line":1135,"name":"@sortedctgmarker","kind":13,"containerName":null},{"line":1135,"name":"%i","containerName":null,"kind":13},{"name":"%ctg","kind":13,"containerName":null,"line":1136},{"containerName":null,"kind":13,"name":"$ctg","line":1137},{"name":"@sortedctgmarker","containerName":null,"kind":13,"line":1137},{"name":"%i","kind":13,"containerName":null,"line":1137},{"line":1140,"name":"$depth","kind":13,"containerName":null},{"name":"%save_depth","kind":13,"containerName":null,"line":1140},{"name":"$pos","kind":13,"containerName":null,"line":1141},{"name":"$x","containerName":null,"kind":13,"line":1141},{"containerName":null,"kind":13,"name":"$y","line":1141},{"name":"%_contigs","containerName":null,"kind":13,"line":1142},{"name":"%ctg","containerName":null,"kind":13,"line":1142},{"line":1142,"name":"$marker","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$pos","line":1142},{"containerName":null,"kind":13,"name":"%_markers","line":1143},{"line":1143,"containerName":null,"kind":13,"name":"%marker"},{"name":"$ctg","kind":13,"containerName":null,"line":1143},{"line":1143,"name":"$pos","containerName":null,"kind":13},{"line":1147,"name":"$ctg","kind":13,"containerName":null},{"line":1147,"name":"@sortedctgmarker","containerName":null,"kind":13},{"name":"%i","kind":13,"containerName":null,"line":1147},{"kind":13,"containerName":null,"name":"$x","line":1148},{"name":"@sortedctgmarker","containerName":null,"kind":13,"line":1148},{"name":"%i","containerName":null,"kind":13,"line":1148},{"name":"$y","containerName":null,"kind":13,"line":1149},{"line":1149,"name":"@sortedctgmarker","containerName":null,"kind":13},{"name":"%i","containerName":null,"kind":13,"line":1149},{"containerName":null,"kind":13,"name":"@stack","line":1150},{"containerName":null,"kind":13,"name":"$y","line":1150},{"containerName":null,"kind":13,"name":"$pos","line":1152},{"line":1152,"kind":13,"containerName":null,"name":"$x"},{"line":1152,"name":"$y","kind":13,"containerName":null},{"line":1153,"name":"%_contigs","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%ctg","line":1153},{"line":1153,"kind":13,"containerName":null,"name":"$marker"},{"line":1153,"containerName":null,"kind":13,"name":"$pos"},{"line":1154,"name":"%_markers","kind":13,"containerName":null},{"line":1154,"kind":13,"containerName":null,"name":"%marker"},{"line":1154,"kind":13,"containerName":null,"name":"$ctg"},{"line":1154,"kind":13,"containerName":null,"name":"$pos"},{"name":"$depth","kind":13,"containerName":null,"line":1156},{"line":1156,"containerName":null,"kind":13,"name":"$save_depth"},{"line":1158,"kind":13,"containerName":null,"name":"@sortedctgmarker"},{"name":"$i","kind":13,"containerName":null,"line":1158},{"containerName":null,"kind":13,"name":"%y","line":1158},{"name":"@stack","containerName":null,"kind":13,"line":1159},{"kind":13,"containerName":null,"name":"$depth","line":1159},{"containerName":null,"kind":13,"name":"@sortedctgmarker","line":1159},{"kind":13,"containerName":null,"name":"%i","line":1159},{"name":"$x","kind":13,"containerName":null,"line":1161},{"name":"@sortedctgmarker","containerName":null,"kind":13,"line":1161},{"line":1161,"name":"%i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$x","line":1162},{"line":1162,"name":"@sortedctgmarker","containerName":null,"kind":13},{"line":1162,"name":"%i","kind":13,"containerName":null},{"name":"$y","kind":13,"containerName":null,"line":1165},{"name":"@sortedctgmarker","kind":13,"containerName":null,"line":1165},{"line":1165,"containerName":null,"kind":13,"name":"%i"},{"line":1166,"name":"$y","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@sortedctgmarker","line":1166},{"name":"%i","kind":13,"containerName":null,"line":1166},{"name":"$depth","kind":13,"containerName":null,"line":1170},{"kind":13,"containerName":null,"name":"%save_depth","line":1170},{"line":1171,"kind":13,"containerName":null,"name":"$save_depth"},{"containerName":null,"kind":13,"name":"$depth","line":1171},{"kind":13,"containerName":null,"name":"$pos","line":1172},{"containerName":null,"kind":13,"name":"$x","line":1172},{"containerName":null,"kind":13,"name":"$y","line":1172},{"line":1173,"name":"%_contigs","kind":13,"containerName":null},{"name":"%ctg","kind":13,"containerName":null,"line":1173},{"line":1173,"name":"$marker","kind":13,"containerName":null},{"name":"$pos","kind":13,"containerName":null,"line":1173},{"containerName":null,"kind":13,"name":"%_markers","line":1174},{"line":1174,"containerName":null,"kind":13,"name":"%marker"},{"line":1174,"containerName":null,"kind":13,"name":"$ctg"},{"containerName":null,"kind":13,"name":"$pos","line":1174},{"line":1177,"containerName":null,"kind":13,"name":"$x"},{"containerName":null,"kind":13,"name":"@sortedctgmarker","line":1177},{"line":1177,"name":"%i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$y","line":1178},{"kind":13,"containerName":null,"name":"@sortedctgmarker","line":1178},{"containerName":null,"kind":13,"name":"%i","line":1178},{"line":1179,"name":"@stack","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$depth","line":1179},{"kind":13,"containerName":null,"name":"$y","line":1179},{"name":"$j","kind":13,"containerName":null,"line":1181},{"containerName":null,"kind":13,"name":"$k","line":1181},{"containerName":null,"kind":13,"name":"$s","line":1181},{"name":"$s","containerName":null,"kind":13,"line":1181},{"line":1181,"name":"$depth","containerName":null,"kind":13},{"name":"%s","containerName":null,"kind":13,"line":1181},{"line":1182,"name":"@stack","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$s","line":1182},{"line":1182,"name":"%x","containerName":null,"kind":13},{"line":1183,"name":"@stack","kind":13,"containerName":null},{"name":"$s","kind":13,"containerName":null,"line":1183},{"name":"$j","kind":13,"containerName":null,"line":1184},{"name":"$s","containerName":null,"kind":13,"line":1184},{"kind":13,"containerName":null,"name":"%j","line":1184},{"line":1187,"name":"$k","containerName":null,"kind":13},{"line":1189,"kind":13,"containerName":null,"name":"$y"},{"kind":13,"containerName":null,"name":"@stack","line":1189},{"line":1189,"kind":13,"containerName":null,"name":"$s"},{"name":"$y","kind":13,"containerName":null,"line":1189},{"name":"@stack","kind":13,"containerName":null,"line":1189},{"containerName":null,"kind":13,"name":"$s","line":1189},{"line":1190,"name":"@stack","kind":13,"containerName":null},{"name":"%j","kind":13,"containerName":null,"line":1190},{"name":"@stack","containerName":null,"kind":13,"line":1191},{"name":"$j","containerName":null,"kind":13,"line":1191},{"name":"@stack","kind":13,"containerName":null,"line":1191},{"name":"$s","containerName":null,"kind":13,"line":1191},{"line":1192,"name":"@stack","kind":13,"containerName":null},{"line":1192,"kind":13,"containerName":null,"name":"$s"},{"name":"@stack","containerName":null,"kind":13,"line":1193},{"name":"%j","kind":13,"containerName":null,"line":1193},{"name":"%j","containerName":null,"kind":13,"line":1193},{"containerName":null,"kind":13,"name":"$j","line":1196},{"kind":13,"containerName":null,"name":"$s","line":1196},{"line":1199,"name":"$depth","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$k","line":1199},{"line":1202,"name":"$depth","containerName":null,"kind":13},{"name":"%save_depth","kind":13,"containerName":null,"line":1202},{"kind":13,"containerName":null,"name":"$pos","line":1203},{"name":"$x","kind":13,"containerName":null,"line":1203},{"line":1203,"kind":13,"containerName":null,"name":"$y"},{"line":1204,"name":"%_contigs","kind":13,"containerName":null},{"line":1204,"name":"%ctg","kind":13,"containerName":null},{"line":1204,"containerName":null,"kind":13,"name":"$marker"},{"kind":13,"containerName":null,"name":"$pos","line":1204},{"containerName":null,"kind":13,"name":"%_markers","line":1205},{"line":1205,"name":"%marker","containerName":null,"kind":13},{"line":1205,"kind":13,"containerName":null,"name":"$ctg"},{"line":1205,"kind":13,"containerName":null,"name":"$pos"},{"children":[{"definition":"my","line":1222,"name":"$self","localvar":"my","containerName":"_calc_contigposition","kind":13},{"line":1224,"localvar":"my","containerName":"_calc_contigposition","kind":13,"name":"%_contigs","definition":"my"},{"line":1224,"kind":13,"containerName":"_calc_contigposition","name":"$self"}],"containerName":"main::","name":"_calc_contigposition","definition":"sub","detail":"($self)","line":1221,"kind":12,"range":{"start":{"character":0,"line":1221},"end":{"line":1224,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none","label":"_calc_contigposition($self)"}},{"line":1225,"containerName":null,"localvar":"my","kind":13,"name":"%_markers","definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":1225},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%_clones","line":1226},{"containerName":null,"kind":13,"name":"%self","line":1226},{"definition":"my","name":"@contigs","localvar":"my","containerName":null,"kind":13,"line":1228},{"containerName":null,"kind":13,"name":"$self","line":1228},{"containerName":"main::","kind":12,"name":"each_contigid","line":1228},{"definition":"my","line":1229,"localvar":"my","containerName":null,"kind":13,"name":"@sortedcontigs"},{"containerName":null,"kind":13,"name":"$a","line":1229},{"line":1229,"kind":13,"containerName":null,"name":"$b"},{"kind":13,"containerName":null,"name":"@contigs","line":1229},{"definition":"my","line":1231,"localvar":"my","kind":13,"containerName":null,"name":"$contig"},{"line":1231,"kind":13,"containerName":null,"name":"@sortedcontigs"},{"definition":"my","line":1232,"name":"$position","containerName":null,"localvar":"my","kind":13},{"line":1233,"name":"$group","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1235,"kind":13,"containerName":null,"name":"%_contigs"},{"line":1235,"name":"%contig","kind":13,"containerName":null},{"definition":"my","line":1237,"name":"%weightedmarkers","localvar":"my","kind":13,"containerName":null},{"line":1238,"localvar":"my","kind":13,"containerName":null,"name":"@mkrs","definition":"my"},{"name":"%_contigs","kind":13,"containerName":null,"line":1238},{"name":"%contig","containerName":null,"kind":13,"line":1238},{"kind":13,"containerName":null,"name":"%_contigs","line":1239},{"name":"%contig","containerName":null,"kind":13,"line":1239},{"name":"$chr","localvar":"my","containerName":null,"kind":13,"line":1241,"definition":"my"},{"line":1241,"containerName":null,"kind":13,"name":"%_contigs"},{"containerName":null,"kind":13,"name":"%contig","line":1241},{"line":1242,"kind":13,"containerName":null,"name":"$chr"},{"line":1242,"name":"%_contigs","containerName":null,"kind":13},{"name":"%contig","kind":13,"containerName":null,"line":1242},{"line":1244,"name":"$mkr","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"@mkrs","line":1244},{"kind":13,"containerName":null,"name":"%_markers","line":1245},{"line":1245,"name":"%mkr","containerName":null,"kind":13},{"name":"%_markers","containerName":null,"kind":13,"line":1246},{"name":"%mkr","kind":13,"containerName":null,"line":1246},{"containerName":null,"kind":13,"name":"%chr","line":1246},{"line":1247,"name":"@mkrclones","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1247,"containerName":null,"kind":13,"name":"%_markers"},{"name":"%mkr","kind":13,"containerName":null,"line":1247},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$clonescount","line":1248},{"kind":13,"localvar":"my","containerName":null,"name":"$clone","line":1249,"definition":"my"},{"containerName":null,"kind":13,"name":"@mkrclones","line":1249},{"line":1251,"kind":13,"containerName":null,"name":"$clonescount"},{"containerName":null,"kind":13,"name":"%_clones","line":1251},{"line":1251,"name":"%clone","kind":13,"containerName":null},{"name":"$contig","containerName":null,"kind":13,"line":1251},{"containerName":null,"kind":13,"name":"%weightedmarkers","line":1253},{"line":1253,"containerName":null,"kind":13,"name":"%_markers"},{"name":"%mkr","containerName":null,"kind":13,"line":1253},{"line":1254,"name":"$clonescount","kind":13,"containerName":null},{"name":"$weightedctgsum","containerName":null,"localvar":"my","kind":13,"line":1259,"definition":"my"},{"definition":"my","line":1260,"name":"$totalhits","containerName":null,"localvar":"my","kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"$mpos","line":1262,"definition":"my"},{"line":1262,"containerName":null,"kind":13,"name":"$hits"},{"containerName":null,"kind":13,"name":"%weightedmarkers","line":1262},{"line":1263,"containerName":null,"kind":13,"name":"$weightedctgsum"},{"name":"$mpos","containerName":null,"kind":13,"line":1263},{"line":1263,"name":"$hits","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$totalhits","line":1264},{"line":1264,"name":"$hits","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$position","line":1267},{"line":1267,"name":"$weightedctgsum","kind":13,"containerName":null},{"line":1267,"name":"$totalhits","kind":13,"containerName":null},{"line":1268,"name":"$totalhits","containerName":null,"kind":13},{"line":1270,"kind":13,"containerName":null,"name":"%_contigs"},{"containerName":null,"kind":13,"name":"%contig","line":1270},{"kind":13,"containerName":null,"name":"$position","line":1270},{"kind":12,"range":{"start":{"character":0,"line":1285},"end":{"line":1287,"character":9999}},"line":1285,"signature":{"label":"_calc_contiggroup($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none\n\n\nsub _calc_contigposition{\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    foreach my $contig (@sortedcontigs) {\n\t\tmy $position = 0;\n\tmy $group;\n\t\n\tif (exists($_contigs{$contig}{'group'}) ) {\t\t\n\t\n\t    my %weightedmarkers;\n\t    my @mkrs = keys (%{$_contigs{$contig}{'markers'}})\n\t        if (exists($_contigs{$contig}{'markers'})) ;\n\n\t    my $chr = $_contigs{$contig}{'group'};\n\t    $chr = 0 if ($_contigs{$contig}{'group'} =~ /\\?/);\t\n\n\t    foreach my $mkr (@mkrs) {\n\t\tif (exists($_markers{$mkr}{'group'})) {\n\t\t    if ( $_markers{$mkr}{'group'} == $chr ) {\n\t\t\tmy @mkrclones = keys( %{$_markers{$mkr}{'clones'}});\n\t\t\tmy $clonescount = 0;\n\t\t\tforeach my $clone (@mkrclones) {\n\t\t\t    ++$clonescount\n\t\t\t        if ($_clones{$clone}{'contig'} == $contig);\n\t\t\t}\n\t\t\t$weightedmarkers{$_markers{$mkr}{'global'}} =\n\t\t\t    $clonescount;\t\t\t\n\t\t    }\n\t\t}\n\t    }\n\t\n\t    my $weightedctgsum = 0;\n\t    my $totalhits      = 0;\n\n\t    while (my ($mpos,$hits) = each %weightedmarkers) {\n\t\t$weightedctgsum += ($mpos * $hits);\n\t\t$totalhits      += $hits;\n\t    }\n\t\n\t    $position = sprintf(\"%.2f\",$weightedctgsum / $totalhits)\n\t        if ($totalhits != 0);\t\n\t\n\t    $_contigs{$contig}{'position'} = $position;\t\n\t}\n    }\n}\n\n=head2 _calc_contiggroup\n\n Title   : _calc_contiggroup\n Usage   : $map->_calc_contiggroup();\n Function: calculates the group of the contig\n Returns : none\n Args    : none"},"name":"_calc_contiggroup","containerName":"main::","children":[{"line":1286,"kind":13,"localvar":"my","containerName":"_calc_contiggroup","name":"$self","definition":"my"},{"localvar":"my","kind":13,"containerName":"_calc_contiggroup","name":"%_contig","line":1287,"definition":"my"},{"kind":13,"containerName":"_calc_contiggroup","name":"$self","line":1287}],"detail":"($self)","definition":"sub"},{"localvar":"my","containerName":null,"kind":13,"name":"@contigs","line":1288,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":1288},{"name":"each_contigid","containerName":"main::","kind":12,"line":1288},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$ctg","line":1290},{"containerName":null,"kind":13,"name":"@contigs","line":1290},{"definition":"my","line":1291,"name":"$chr","kind":13,"localvar":"my","containerName":null},{"line":1291,"kind":12,"name":"floor"},{"name":"$ctg","containerName":null,"kind":13,"line":1291},{"line":1292,"name":"%_contig","kind":13,"containerName":null},{"name":"%ctg","kind":13,"containerName":null,"line":1292},{"name":"$chr","containerName":null,"kind":13,"line":1292},{"children":[{"definition":"my","name":"$self","containerName":"_setCloneRef","localvar":"my","kind":13,"line":1312},{"line":1312,"containerName":"_setCloneRef","kind":13,"name":"$ref"},{"line":1313,"name":"$self","kind":13,"containerName":"_setCloneRef"}],"name":"_setCloneRef","containerName":"main::","definition":"sub","detail":"($self,$ref)","line":1311,"range":{"end":{"character":9999,"line":1313},"start":{"line":1311,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$ref"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none\n\n\nsub _calc_contigposition{\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    foreach my $contig (@sortedcontigs) {\n\t\tmy $position = 0;\n\tmy $group;\n\t\n\tif (exists($_contigs{$contig}{'group'}) ) {\t\t\n\t\n\t    my %weightedmarkers;\n\t    my @mkrs = keys (%{$_contigs{$contig}{'markers'}})\n\t        if (exists($_contigs{$contig}{'markers'})) ;\n\n\t    my $chr = $_contigs{$contig}{'group'};\n\t    $chr = 0 if ($_contigs{$contig}{'group'} =~ /\\?/);\t\n\n\t    foreach my $mkr (@mkrs) {\n\t\tif (exists($_markers{$mkr}{'group'})) {\n\t\t    if ( $_markers{$mkr}{'group'} == $chr ) {\n\t\t\tmy @mkrclones = keys( %{$_markers{$mkr}{'clones'}});\n\t\t\tmy $clonescount = 0;\n\t\t\tforeach my $clone (@mkrclones) {\n\t\t\t    ++$clonescount\n\t\t\t        if ($_clones{$clone}{'contig'} == $contig);\n\t\t\t}\n\t\t\t$weightedmarkers{$_markers{$mkr}{'global'}} =\n\t\t\t    $clonescount;\t\t\t\n\t\t    }\n\t\t}\n\t    }\n\t\n\t    my $weightedctgsum = 0;\n\t    my $totalhits      = 0;\n\n\t    while (my ($mpos,$hits) = each %weightedmarkers) {\n\t\t$weightedctgsum += ($mpos * $hits);\n\t\t$totalhits      += $hits;\n\t    }\n\t\n\t    $position = sprintf(\"%.2f\",$weightedctgsum / $totalhits)\n\t        if ($totalhits != 0);\t\n\t\n\t    $_contigs{$contig}{'position'} = $position;\t\n\t}\n    }\n}\n\n=head2 _calc_contiggroup\n\n Title   : _calc_contiggroup\n Usage   : $map->_calc_contiggroup();\n Function: calculates the group of the contig\n Returns : none\n Args    : none\n\n\nsub _calc_contiggroup {\n    my ($self)  = @_;\n    my %_contig = %{$self->{'_contigs'}};\n    my @contigs = $self->each_contigid();\n\n    foreach my $ctg (@contigs) {\n        my $chr = floor($ctg/1000);\n\t\t$_contig{$ctg}{'group'} = $chr;\n    }\n}\n\n=head2 _setI<E<lt>TypeE<gt>>Ref\n\n Title   : _set<Type>Ref\n Usage   : These are used for initializing the reference of the hash in\n           Bio::MapIO (fpc.pm) to the corresponding hash in Bio::Map\n           (physical.pm). Should be used only from Bio::MapIO System.\n               $map->setCloneRef(\\%_clones);\n               $map->setMarkerRef(\\%_markers);\n               $map->setContigRef(\\%_contigs);\n Function: sets the hash references to the corresponding hashes\n Returns : none\n Args    : reference of the hash.","label":"_setCloneRef($self,$ref)"}},{"line":1313,"name":"$ref","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$ref)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_setMarkerRef","line":1317,"definition":"my"},{"line":1317,"name":"$ref","kind":13,"containerName":"_setMarkerRef"},{"line":1318,"name":"$self","kind":13,"containerName":"_setMarkerRef"}],"containerName":"main::","name":"_setMarkerRef","signature":{"label":"_setMarkerRef($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]},"line":1316,"range":{"start":{"character":0,"line":1316},"end":{"character":9999,"line":1318}},"kind":12},{"containerName":null,"kind":13,"name":"$ref","line":1318},{"line":1321,"kind":12,"range":{"end":{"line":1323,"character":9999},"start":{"character":0,"line":1321}},"signature":{"label":"_setContigRef($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]},"children":[{"line":1322,"name":"$self","localvar":"my","kind":13,"containerName":"_setContigRef","definition":"my"},{"line":1322,"containerName":"_setContigRef","kind":13,"name":"$ref"},{"line":1323,"name":"$self","containerName":"_setContigRef","kind":13}],"containerName":"main::","name":"_setContigRef","definition":"sub","detail":"($self,$ref)"},{"name":"$ref","kind":13,"containerName":null,"line":1323}]}