{"vars":[{"line":85,"name":"base","containerName":"","kind":2},{"name":"get_position_handler","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"get_position_handler","kind":13,"name":"$self","line":105},{"name":"$self","containerName":"get_position_handler","kind":13,"line":106},{"name":"$ph","containerName":"get_position_handler","localvar":"my","kind":13,"line":107,"definition":"my"},{"line":107,"name":"new","containerName":"get_position_handler","kind":12},{"line":107,"kind":13,"containerName":"get_position_handler","name":"$self"},{"line":108,"containerName":"get_position_handler","kind":13,"name":"$self"},{"name":"$ph","containerName":"get_position_handler","kind":13,"line":108},{"containerName":"get_position_handler","kind":13,"name":"$ph","line":109},{"line":109,"kind":12,"containerName":"get_position_handler","name":"register"},{"name":"$self","containerName":"get_position_handler","kind":13,"line":111}],"definition":"sub","range":{"end":{"character":9999,"line":112},"start":{"character":0,"line":104}},"kind":12,"line":104},{"line":106,"name":"_eh","kind":12},{"containerName":"Map::PositionHandler","kind":12,"name":"Bio","line":107},{"name":"_eh","kind":12,"line":108},{"line":111,"kind":12,"name":"_eh"},{"children":[{"line":132,"localvar":"my","containerName":"add_position","kind":13,"name":"$self","definition":"my"},{"line":134,"name":"$self","containerName":"add_position","kind":13},{"name":"get_position_handler","containerName":"add_position","kind":12,"line":134},{"containerName":"add_position","kind":12,"name":"add_positions","line":134}],"name":"add_position","containerName":"main::","definition":"sub","line":131,"range":{"start":{"line":131,"character":0},"end":{"character":9999,"line":135}},"kind":12},{"containerName":"main::","name":"get_positions","children":[{"definition":"my","line":150,"localvar":"my","containerName":"get_positions","kind":13,"name":"$self"},{"name":"$thing","kind":13,"containerName":"get_positions","line":150},{"name":"$no_sort","containerName":"get_positions","kind":13,"line":150},{"line":151,"kind":13,"localvar":"my","containerName":"get_positions","name":"$map","definition":"my"},{"kind":13,"containerName":"get_positions","name":"$thing","line":152},{"line":152,"name":"$thing","containerName":"get_positions","kind":13},{"line":152,"containerName":"get_positions","kind":12,"name":"isa"},{"name":"$map","containerName":"get_positions","kind":13,"line":153},{"line":153,"name":"$thing","containerName":"get_positions","kind":13},{"kind":13,"containerName":"get_positions","name":"$no_sort","line":156},{"containerName":"get_positions","kind":13,"name":"$thing","line":156},{"line":158,"name":"@positions","containerName":"get_positions","localvar":"my","kind":13,"definition":"my"},{"line":158,"name":"$self","kind":13,"containerName":"get_positions"},{"kind":12,"containerName":"get_positions","name":"get_position_handler","line":158},{"name":"get_positions","kind":12,"containerName":"get_positions","line":158},{"line":158,"containerName":"get_positions","kind":13,"name":"$map"},{"line":159,"name":"@positions","containerName":"get_positions","kind":13},{"name":"@positions","containerName":"get_positions","kind":13,"line":159},{"line":161,"name":"$no_sort","containerName":"get_positions","kind":13},{"line":167,"kind":13,"containerName":"get_positions","name":"@positions"},{"name":"$a","containerName":"get_positions","kind":13,"line":168},{"line":168,"containerName":"get_positions","kind":13,"name":"$b"},{"kind":12,"containerName":"get_positions","name":"sortable","line":169},{"name":"@positions","containerName":"get_positions","kind":13,"line":170},{"line":172,"kind":13,"containerName":"get_positions","name":"@positions"}],"detail":"($self,$thing,$no_sort)","definition":"sub","range":{"end":{"character":9999,"line":173},"start":{"line":149,"character":0}},"kind":12,"line":149,"signature":{"parameters":[{"label":"$self"},{"label":"$thing"},{"label":"$no_sort"}],"documentation":"1;\n# $Id: MappableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MappableI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MappableI - An object that can be placed in a map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Mappable for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object handles the generic notion of an element placed on a\n(linear) Map. A Mappable can have multiple positions in multiple maps, such as\nis the case of Restriction enzyme cut sites on sequence maps. For exact\ninformation about a mappable's position in a map one must query the associate\nPositionI objects which are accessible through the get_positions() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MappableI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $mappable->add_position($position);\n Function: Add a position to this mappable (defining where on which map it is).\n Returns : n/a\n Args    : L<Bio::Map::PositionI> object\n\n\nsub add_position {\n    my $self = shift;\n\t# actually, we allow multiple positions to be set at once\n    $self->get_position_handler->add_positions(@_);\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions of this Mappable (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MapI> object for positions on the given map, AND/OR some\n           other true value to avoid sorting","label":"get_positions($self,$thing,$no_sort)"}},{"containerName":"main::","name":"purge_positions","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"purge_positions","name":"$self","line":199},{"line":199,"containerName":"purge_positions","kind":13,"name":"$thing"},{"line":200,"name":"$self","kind":13,"containerName":"purge_positions"},{"containerName":"purge_positions","kind":12,"name":"get_position_handler","line":200},{"name":"purge_positions","containerName":"purge_positions","kind":12,"line":200},{"line":200,"containerName":"purge_positions","kind":13,"name":"$thing"}],"detail":"($self,$thing)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":201},"start":{"character":0,"line":198}},"line":198,"signature":{"parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: MappableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MappableI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MappableI - An object that can be placed in a map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Mappable for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object handles the generic notion of an element placed on a\n(linear) Map. A Mappable can have multiple positions in multiple maps, such as\nis the case of Restriction enzyme cut sites on sequence maps. For exact\ninformation about a mappable's position in a map one must query the associate\nPositionI objects which are accessible through the get_positions() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MappableI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $mappable->add_position($position);\n Function: Add a position to this mappable (defining where on which map it is).\n Returns : n/a\n Args    : L<Bio::Map::PositionI> object\n\n\nsub add_position {\n    my $self = shift;\n\t# actually, we allow multiple positions to be set at once\n    $self->get_position_handler->add_positions(@_);\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions of this Mappable (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MapI> object for positions on the given map, AND/OR some\n           other true value to avoid sorting\n\n\nsub get_positions {\n    my ($self, $thing, $no_sort) = @_;\n    my $map;\n    if (ref($thing) && $thing->isa('Bio::Map::MapI')) {\n        $map = $thing;\n    }\n    else {\n        $no_sort = $thing;\n    }\n    my @positions = $self->get_position_handler->get_positions($map);\n    return @positions if @positions == 1;\n    \n    unless ($no_sort) {\n        # don't do\n        # @positions = sort { $a->sortable <=> $b->sortable } @positions;\n        # directly since sortable() can result in the call of another sort\n        # routine and cause problems; pre-compute sortable values instead\n        # (which is also more efficient)\n        @positions = map { $_->[1] }\n                     sort { $a->[0] <=> $b->[0] }\n                     map  { [$_->sortable, $_] }\n                     @positions;\n    }\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $mappable->purge_positions();\n Function: Remove positions from this mappable.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MapI> object to remove only those positions on the given\n\t\t   map","label":"purge_positions($self,$thing)"}},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"known_maps","kind":13,"line":214},{"line":215,"kind":13,"containerName":"known_maps","name":"$self"},{"line":215,"name":"get_position_handler","containerName":"known_maps","kind":12},{"line":215,"name":"get_other_entities","containerName":"known_maps","kind":12}],"containerName":"main::","name":"known_maps","line":213,"kind":12,"range":{"start":{"character":0,"line":213},"end":{"character":9999,"line":216}}},{"line":234,"kind":12,"range":{"end":{"character":9999,"line":237},"start":{"character":0,"line":234}},"children":[{"definition":"my","containerName":"name","localvar":"my","kind":13,"name":"$self","line":235},{"line":236,"kind":13,"containerName":"name","name":"$self"},{"containerName":"name","kind":12,"name":"throw_not_implemented","line":236}],"containerName":"main::","name":"name","definition":"sub"},{"children":[{"definition":"my","line":252,"name":"$self","localvar":"my","kind":13,"containerName":"id"},{"name":"$self","kind":13,"containerName":"id","line":253},{"containerName":"id","kind":12,"name":"throw_not_implemented","line":253}],"name":"id","containerName":"main::","definition":"sub","line":251,"kind":12,"range":{"start":{"line":251,"character":0},"end":{"line":254,"character":9999}}},{"range":{"start":{"line":266,"character":0},"end":{"character":9999,"line":269}},"kind":12,"line":266,"definition":"sub","name":"in_map","containerName":"main::","children":[{"definition":"my","line":267,"name":"$self","localvar":"my","kind":13,"containerName":"in_map"},{"line":268,"name":"$self","kind":13,"containerName":"in_map"},{"containerName":"in_map","kind":12,"name":"throw_not_implemented","line":268}]},{"definition":"sub","containerName":"main::","name":"equals","children":[{"line":299,"localvar":"my","containerName":"equals","kind":13,"name":"$self","definition":"my"},{"containerName":"equals","kind":13,"name":"$self","line":300},{"line":300,"name":"throw_not_implemented","containerName":"equals","kind":12}],"range":{"start":{"character":0,"line":298},"end":{"character":9999,"line":301}},"kind":12,"line":298},{"definition":"sub","name":"overlaps","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"overlaps","line":324,"definition":"my"},{"name":"$self","kind":13,"containerName":"overlaps","line":325},{"name":"throw_not_implemented","kind":12,"containerName":"overlaps","line":325}],"range":{"start":{"line":323,"character":0},"end":{"character":9999,"line":326}},"kind":12,"line":323},{"line":348,"range":{"start":{"line":348,"character":0},"end":{"line":351,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","line":349,"localvar":"my","kind":13,"containerName":"contains","name":"$self"},{"kind":13,"containerName":"contains","name":"$self","line":350},{"name":"throw_not_implemented","kind":12,"containerName":"contains","line":350}],"containerName":"main::","name":"contains"},{"line":374,"kind":12,"range":{"start":{"line":374,"character":0},"end":{"line":377,"character":9999}},"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"intersection","kind":13,"line":375,"definition":"my"},{"kind":13,"containerName":"intersection","name":"$self","line":376},{"containerName":"intersection","kind":12,"name":"throw_not_implemented","line":376}],"containerName":"main::","name":"intersection"},{"children":[{"line":401,"name":"$self","containerName":"union","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"union","name":"$self","line":402},{"kind":12,"containerName":"union","name":"throw_not_implemented","line":402}],"containerName":"main::","name":"union","definition":"sub","line":400,"range":{"start":{"character":0,"line":400},"end":{"line":403,"character":9999}},"kind":12}],"version":5}