{"vars":[{"containerName":"","kind":2,"name":"base","line":94},{"detail":"($self)","definition":"sub","name":"length","containerName":"main::","children":[{"definition":"my","line":126,"localvar":"my","containerName":"length","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"length","line":127},{"line":127,"containerName":"length","kind":12,"name":"throw"},{"name":"$total_distance","containerName":"length","localvar":"my","kind":13,"line":129,"definition":"my"},{"definition":"my","name":"$element","containerName":"length","localvar":"my","kind":13,"line":130},{"name":"$self","kind":13,"containerName":"length","line":130},{"name":"get_elements","kind":12,"containerName":"length","line":130}],"signature":{"documentation":"1;\n# BioPerl module for Bio::Map::LinkageMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::LinkageMap - A representation of a genetic linkage map.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::LinkageMap;\n\t# create a new map\n    my $map = Bio::Map::LinkageMap->new(-name => 'Chads Superterriffic Map',\n                                      -type => 'Linkage',\n                                      -units=> 'cM');\n\t# create the location of a marker for that map\n    my $position = Bio::Map::LinkagePosition->new( -positions => 1,\n                -distance => \"22.3\");\n\t# create a marker and place it at that position\n    my $marker = Bio::Map::Marker::Microsatellite->new(\n\t\t\t-name => 'SuuuperMarker',\n\t\t\t-position => $position);\n\t# place that marker on that map\n    $map->add_element($marker);\n\n\t# done!\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a genetic linkage map in\nBioperl. Each 'position' can have one or more markers that map some number of\nunits from the markers at the previous position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein       lstein@cshl.org\nHeikki Lehvaslaiho  heikki-at-bioperl-dot-org\nJason Stajich       jason@bioperl.org\nSendu Bala          bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::LinkageMap;\nuse strict;\n\nuse base qw(Bio::Map::SimpleMap);\n\n=head2 new\n\n Title   : new\n Usage   : my $linkage_map = Bio::Map::LinkageMap->new();\n Function: Builds a new Bio::Map::LinkageMap object\n Returns : Bio::Map::LinkageMap\n Args    : -name    => the name of the map (string) [optional]\n\t       -type    => the type of this map (string, defaults to Linkage) [optional]\n           -species => species for this map (Bio::Species) [optional]\n           -units   => the map units (string, defaults to cM) [optional]\n           -elements=> elements to initialize with\n                       (arrayref of Bio::Map::MappableI objects) [optional]\n           -uid      => Unique ID of this map\n\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. In the case of a LinkageMap, the\n\t       length is the sum of all marker distances.\n Returns : An integer representing the length of this LinkageMap. Will return\n\t       0 if length is not calculateable\n Args    : None.","parameters":[{"label":"$self"}],"label":"length($self)"},"range":{"end":{"line":130,"character":9999},"start":{"character":0,"line":125}},"kind":12,"line":125},{"line":132,"name":"$total_distance","containerName":null,"kind":13},{"name":"$element","kind":13,"containerName":null,"line":132},{"line":132,"name":"position","containerName":"main::","kind":12},{"containerName":"main::","kind":12,"name":"each_position_value","line":132},{"kind":13,"containerName":null,"name":"@self","line":132},{"line":134,"containerName":null,"kind":13,"name":"$total_distance"},{"signature":{"label":"_add_element_will_be_deleted($self,$marker)","documentation":"1;\n# BioPerl module for Bio::Map::LinkageMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::LinkageMap - A representation of a genetic linkage map.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::LinkageMap;\n\t# create a new map\n    my $map = Bio::Map::LinkageMap->new(-name => 'Chads Superterriffic Map',\n                                      -type => 'Linkage',\n                                      -units=> 'cM');\n\t# create the location of a marker for that map\n    my $position = Bio::Map::LinkagePosition->new( -positions => 1,\n                -distance => \"22.3\");\n\t# create a marker and place it at that position\n    my $marker = Bio::Map::Marker::Microsatellite->new(\n\t\t\t-name => 'SuuuperMarker',\n\t\t\t-position => $position);\n\t# place that marker on that map\n    $map->add_element($marker);\n\n\t# done!\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a genetic linkage map in\nBioperl. Each 'position' can have one or more markers that map some number of\nunits from the markers at the previous position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein       lstein@cshl.org\nHeikki Lehvaslaiho  heikki-at-bioperl-dot-org\nJason Stajich       jason@bioperl.org\nSendu Bala          bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::LinkageMap;\nuse strict;\n\nuse base qw(Bio::Map::SimpleMap);\n\n=head2 new\n\n Title   : new\n Usage   : my $linkage_map = Bio::Map::LinkageMap->new();\n Function: Builds a new Bio::Map::LinkageMap object\n Returns : Bio::Map::LinkageMap\n Args    : -name    => the name of the map (string) [optional]\n\t       -type    => the type of this map (string, defaults to Linkage) [optional]\n           -species => species for this map (Bio::Species) [optional]\n           -units   => the map units (string, defaults to cM) [optional]\n           -elements=> elements to initialize with\n                       (arrayref of Bio::Map::MappableI objects) [optional]\n           -uid      => Unique ID of this map\n\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. In the case of a LinkageMap, the\n\t       length is the sum of all marker distances.\n Returns : An integer representing the length of this LinkageMap. Will return\n\t       0 if length is not calculateable\n Args    : None.\n\n\n\nsub length {\n    my ($self) = @_;\n    $self->throw(\"Not yet implemented correctly\");\n    \n    my $total_distance;\n    foreach my $element (@{$self->get_elements}) {\n        #*** there is no such method ->each_position_value!\n        $total_distance += ($element->position->each_position_value($self))[0];\n    }\n    return $total_distance;\n}\n\n=head2 add_element($marker)\n\n Title   : add_element($marker)\n Usage   : $map->add_element($marker)\n Function: Add a Bio::Map::MappableI object to the Map\n Returns : none\n Args    : Bio::Map::MappableI object\n Notes   : It is strongly recommended that you use a\n\t   Bio::Map::LinkagePosition as the position in any\n\t   Bio::Map::Mappable that you create to place on this\n\t   map. Using some other Bio::Map::Position might work but might\n\t   be unpredictable.\n           N.B. I've added Bio::Map::OrderedPosition which should achieve\n                similar things from LinkagePosition and will work for\n                RH markers too.\n*** what is this? what calls it? note that it seems to be private","parameters":[{"label":"$self"},{"label":"$marker"}]},"line":155,"range":{"end":{"line":182,"character":9999},"start":{"character":0,"line":155}},"kind":12,"definition":"sub","detail":"($self,$marker)","children":[{"line":156,"containerName":"_add_element_will_be_deleted","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$marker","containerName":"_add_element_will_be_deleted","kind":13,"line":156},{"name":"$o_position","localvar":"my","kind":13,"containerName":"_add_element_will_be_deleted","line":158,"definition":"my"},{"name":"$marker","kind":13,"containerName":"_add_element_will_be_deleted","line":158},{"line":158,"kind":12,"containerName":"_add_element_will_be_deleted","name":"position"},{"line":160,"name":"$self","kind":13,"containerName":"_add_element_will_be_deleted"},{"line":160,"containerName":"_add_element_will_be_deleted","kind":12,"name":"debug"},{"line":160,"name":"$marker","kind":13,"containerName":"_add_element_will_be_deleted"},{"line":160,"kind":12,"containerName":"_add_element_will_be_deleted","name":"position"},{"line":164,"containerName":"_add_element_will_be_deleted","localvar":"my","kind":13,"name":"$position","definition":"my"},{"line":165,"containerName":"_add_element_will_be_deleted","kind":13,"name":"$o_position"},{"name":"isa","kind":12,"containerName":"_add_element_will_be_deleted","line":165},{"line":166,"containerName":"_add_element_will_be_deleted","kind":13,"name":"$o_position"},{"line":166,"containerName":"_add_element_will_be_deleted","kind":12,"name":"isa"},{"name":"$self","containerName":"_add_element_will_be_deleted","kind":13,"line":168},{"line":168,"kind":12,"containerName":"_add_element_will_be_deleted","name":"warn"},{"definition":"my","name":"@p","kind":13,"localvar":"my","containerName":"_add_element_will_be_deleted","line":169},{"kind":13,"containerName":"_add_element_will_be_deleted","name":"$o_position","line":169},{"line":169,"name":"each_position_value","kind":12,"containerName":"_add_element_will_be_deleted"},{"name":"$self","kind":13,"containerName":"_add_element_will_be_deleted","line":169},{"line":170,"containerName":"_add_element_will_be_deleted","kind":13,"name":"$position"},{"line":170,"name":"@p","kind":13,"containerName":"_add_element_will_be_deleted"},{"line":171,"kind":13,"containerName":"_add_element_will_be_deleted","name":"$position"},{"name":"$self","containerName":"_add_element_will_be_deleted","kind":13,"line":172},{"name":"throw","kind":12,"containerName":"_add_element_will_be_deleted","line":172},{"line":175,"name":"$position","containerName":"_add_element_will_be_deleted","kind":13},{"name":"$o_position","containerName":"_add_element_will_be_deleted","kind":13,"line":175},{"containerName":"_add_element_will_be_deleted","kind":12,"name":"order","line":175},{"line":178,"containerName":"_add_element_will_be_deleted","kind":13,"name":"$self"},{"containerName":"_add_element_will_be_deleted","kind":13,"name":"$position","line":178},{"line":179,"name":"$self","kind":13,"containerName":"_add_element_will_be_deleted"},{"kind":12,"containerName":"_add_element_will_be_deleted","name":"warn","line":179},{"name":"$self","kind":13,"containerName":"_add_element_will_be_deleted","line":181},{"kind":13,"containerName":"_add_element_will_be_deleted","name":"$position","line":181},{"name":"$marker","kind":13,"containerName":"_add_element_will_be_deleted","line":181}],"containerName":"main::","name":"_add_element_will_be_deleted"}],"version":5}