{"vars":[{"name":"base","kind":2,"containerName":"","line":105},{"line":107,"name":"$USE_ENSEMBL","containerName":"main::","kind":13,"definition":"our"},{"containerName":"main::","kind":13,"name":"%GENES","line":108,"definition":"our"},{"definition":"our","line":109,"containerName":"main::","kind":13,"name":"%SET_FROM_DB"},{"line":115,"kind":13,"containerName":null,"name":"$USE_ENSEMBL"},{"line":115,"name":"Bio","containerName":"Tools::Run::Ensembl","kind":12},{"containerName":"main::","name":"new","children":[{"definition":"my","line":132,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"line":132,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":133,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":133},{"line":133,"name":"@args","containerName":"new","kind":13},{"name":"$u_name","containerName":"new","localvar":"my","kind":13,"line":135,"definition":"my"},{"line":135,"name":"$desc","containerName":"new","kind":13},{"line":135,"kind":13,"containerName":"new","name":"$self"},{"line":135,"containerName":"new","kind":12,"name":"_rearrange"},{"line":135,"containerName":"new","kind":13,"name":"@args"},{"name":"$u_name","kind":13,"containerName":"new","line":136},{"containerName":"new","kind":13,"name":"$self","line":136},{"line":136,"containerName":"new","kind":12,"name":"throw"},{"line":137,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"universal_name","line":137},{"name":"$u_name","containerName":"new","kind":13,"line":137},{"containerName":"new","kind":13,"name":"$desc","line":139},{"line":139,"name":"$self","kind":13,"containerName":"new"},{"line":139,"name":"description","containerName":"new","kind":12},{"name":"$desc","kind":13,"containerName":"new","line":139},{"line":141,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub","range":{"end":{"character":9999,"line":142},"start":{"line":131,"character":0}},"kind":12,"line":131,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene","parameters":[{"label":"$class"},{"label":"@args"}]}},{"containerName":"new","kind":12,"name":"SUPER","line":133},{"signature":{"label":"get($class,@args)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene","parameters":[{"label":"$class"},{"label":"@args"}]},"line":158,"range":{"start":{"line":158,"character":0},"end":{"line":168,"character":9999}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"line":159,"containerName":"get","localvar":"my","kind":13,"name":"$class","definition":"my"},{"line":159,"containerName":"get","kind":13,"name":"@args"},{"definition":"my","name":"$u_name","localvar":"my","containerName":"get","kind":13,"line":160},{"containerName":"get","kind":13,"name":"$desc","line":160},{"line":160,"kind":12,"containerName":"get","name":"_rearrange"},{"containerName":"get","kind":13,"name":"@args","line":160},{"line":162,"containerName":"get","kind":13,"name":"$u_name"},{"line":162,"name":"$GENES","kind":13,"containerName":"get"},{"name":"$u_name","kind":13,"containerName":"get","line":162},{"name":"$GENES","kind":13,"containerName":"get","line":163},{"line":163,"kind":13,"containerName":"get","name":"$u_name"},{"kind":12,"containerName":"get","name":"description","line":163},{"line":163,"name":"$desc","containerName":"get","kind":13},{"name":"$desc","kind":13,"containerName":"get","line":163},{"kind":13,"containerName":"get","name":"$GENES","line":164},{"name":"$u_name","containerName":"get","kind":13,"line":164},{"name":"$class","kind":13,"containerName":"get","line":167},{"line":167,"name":"new","containerName":"get","kind":12},{"line":167,"kind":13,"containerName":"get","name":"@args"}],"containerName":"main::","name":"get"},{"name":"Bio","kind":12,"containerName":"Root::Root","line":160},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":183,"kind":13,"localvar":"my","containerName":"universal_name","name":"$self"},{"line":183,"kind":13,"containerName":"universal_name","name":"$value"},{"line":184,"containerName":"universal_name","kind":13,"name":"$value"},{"line":185,"kind":13,"containerName":"universal_name","name":"$GENES"},{"line":185,"kind":13,"containerName":"universal_name","name":"$self"},{"line":185,"containerName":"universal_name","kind":13,"name":"$self"},{"line":186,"kind":13,"containerName":"universal_name","name":"$self"},{"kind":13,"containerName":"universal_name","name":"$value","line":186},{"containerName":"universal_name","kind":13,"name":"$GENES","line":187},{"kind":13,"containerName":"universal_name","name":"$value","line":187},{"line":187,"name":"$self","containerName":"universal_name","kind":13},{"name":"$self","kind":13,"containerName":"universal_name","line":189}],"containerName":"main::","name":"universal_name","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set","label":"universal_name($self,$value)"},"line":182,"range":{"end":{"line":190,"character":9999},"start":{"character":0,"line":182}},"kind":12},{"range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":207}},"kind":12,"line":207,"definition":"sub","name":"description","containerName":"main::","children":[{"definition":"my","line":208,"localvar":"my","containerName":"description","kind":13,"name":"$self"},{"line":209,"containerName":"description","kind":13,"name":"$self"},{"containerName":"description","kind":12,"name":"_gene_data","line":209}]},{"definition":"sub","containerName":"main::","name":"display_id","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"display_id","line":228},{"name":"$self","containerName":"display_id","kind":13,"line":229},{"kind":12,"containerName":"display_id","name":"_gene_data","line":229}],"range":{"start":{"line":227,"character":0},"end":{"line":230,"character":9999}},"kind":12,"line":227},{"children":[{"line":248,"name":"$self","localvar":"my","containerName":"display_xref","kind":13,"definition":"my"},{"kind":13,"containerName":"display_xref","name":"$self","line":249},{"name":"_gene_data","kind":12,"containerName":"display_xref","line":249}],"containerName":"main::","name":"display_xref","definition":"sub","line":247,"kind":12,"range":{"start":{"line":247,"character":0},"end":{"line":250,"character":9999}}},{"line":267,"range":{"start":{"line":267,"character":0},"end":{"character":9999,"line":270}},"kind":12,"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"external_db","line":268,"definition":"my"},{"line":269,"name":"$self","containerName":"external_db","kind":13},{"line":269,"name":"_gene_data","containerName":"external_db","kind":12}],"name":"external_db","containerName":"main::"},{"definition":"sub","children":[{"definition":"my","line":289,"name":"$self","localvar":"my","containerName":"external_name","kind":13},{"name":"$self","containerName":"external_name","kind":13,"line":290},{"line":290,"name":"_gene_data","kind":12,"containerName":"external_name"}],"name":"external_name","containerName":"main::","line":288,"kind":12,"range":{"end":{"character":9999,"line":291},"start":{"character":0,"line":288}}},{"line":308,"kind":12,"range":{"start":{"line":308,"character":0},"end":{"line":311,"character":9999}},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"biotype","kind":13,"line":309},{"line":310,"kind":13,"containerName":"biotype","name":"$self"},{"kind":12,"containerName":"biotype","name":"_gene_data","line":310}],"name":"biotype","containerName":"main::","definition":"sub"},{"definition":"sub","name":"source","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"source","kind":13,"line":329,"definition":"my"},{"line":330,"name":"$self","containerName":"source","kind":13},{"line":330,"name":"_gene_data","kind":12,"containerName":"source"}],"range":{"start":{"line":328,"character":0},"end":{"character":9999,"line":331}},"kind":12,"line":328},{"definition":"sub","detail":"($self,$map)","children":[{"line":349,"name":"$self","localvar":"my","containerName":"position","kind":13,"definition":"my"},{"containerName":"position","kind":13,"name":"$map","line":349},{"name":"$map","kind":13,"containerName":"position","line":350},{"kind":13,"containerName":"position","name":"$self","line":350},{"kind":12,"containerName":"position","name":"in_map","line":350},{"name":"$map","kind":13,"containerName":"position","line":350},{"line":352,"name":"$pos","containerName":"position","localvar":"my","kind":13,"definition":"my"},{"line":352,"kind":13,"containerName":"position","name":"$self"},{"kind":12,"containerName":"position","name":"get_positions","line":352},{"name":"$map","containerName":"position","kind":13,"line":352},{"kind":13,"containerName":"position","name":"$pos","line":353},{"line":353,"name":"isa","kind":12,"containerName":"position"},{"line":354,"name":"$pos","containerName":"position","kind":13}],"name":"position","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$map"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.","label":"position($self,$map)"},"line":348,"kind":12,"range":{"end":{"character":9999,"line":359},"start":{"line":348,"character":0}}},{"signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)","parameters":[{"label":"$self"},{"label":"$pos"}],"label":"add_transcript_position($self,$pos)"},"line":378,"kind":12,"range":{"start":{"character":0,"line":378},"end":{"line":399,"character":9999}},"definition":"sub","detail":"($self,$pos)","children":[{"definition":"my","line":379,"kind":13,"localvar":"my","containerName":"add_transcript_position","name":"$self"},{"kind":13,"containerName":"add_transcript_position","name":"$pos","line":379},{"line":380,"name":"$pos","containerName":"add_transcript_position","kind":13},{"name":"$pos","kind":13,"containerName":"add_transcript_position","line":380},{"containerName":"add_transcript_position","kind":12,"name":"isa","line":380},{"definition":"my","line":382,"localvar":"my","kind":13,"containerName":"add_transcript_position","name":"$map"},{"name":"$pos","containerName":"add_transcript_position","kind":13,"line":382},{"line":382,"containerName":"add_transcript_position","kind":12,"name":"map"},{"line":382,"name":"$self","containerName":"add_transcript_position","kind":13},{"kind":12,"containerName":"add_transcript_position","name":"throw","line":382},{"line":383,"containerName":"add_transcript_position","kind":13,"name":"$self"},{"line":383,"containerName":"add_transcript_position","kind":12,"name":"in_map"},{"line":383,"containerName":"add_transcript_position","kind":13,"name":"$map"},{"kind":13,"containerName":"add_transcript_position","name":"$self","line":383},{"kind":12,"containerName":"add_transcript_position","name":"throw","line":383},{"definition":"my","name":"@transcripts","containerName":"add_transcript_position","localvar":"my","kind":13,"line":384},{"line":384,"kind":13,"containerName":"add_transcript_position","name":"$self"},{"line":384,"name":"get_transcript_positions","kind":12,"containerName":"add_transcript_position"},{"name":"$map","kind":13,"containerName":"add_transcript_position","line":384},{"line":385,"kind":13,"containerName":"add_transcript_position","name":"@transcripts"},{"line":387,"containerName":"add_transcript_position","kind":13,"name":"$pos"},{"kind":12,"containerName":"add_transcript_position","name":"start","line":387},{"kind":13,"containerName":"add_transcript_position","name":"$self","line":388},{"name":"warn","kind":12,"containerName":"add_transcript_position","line":388},{"kind":13,"containerName":"add_transcript_position","name":"$pos","line":393},{"name":"type","containerName":"add_transcript_position","kind":12,"line":393},{"containerName":"add_transcript_position","kind":13,"name":"$pos","line":394},{"line":394,"kind":12,"containerName":"add_transcript_position","name":"relative"},{"line":394,"name":"gene","containerName":"add_transcript_position","kind":12},{"line":395,"name":"$self","kind":13,"containerName":"add_transcript_position"},{"name":"$pos","kind":13,"containerName":"add_transcript_position","line":395},{"name":"$self","containerName":"add_transcript_position","kind":13,"line":399},{"containerName":"add_transcript_position","kind":13,"name":"$map","line":399}],"containerName":"main::","name":"add_transcript_position"},{"line":395,"containerName":"add_position","kind":12,"name":"SUPER"},{"kind":12,"name":"t_order","line":399},{"line":399,"name":"$pos","kind":13,"containerName":null},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$main_pos","line":402},{"line":402,"name":"$self","kind":13,"containerName":null},{"line":402,"name":"position","containerName":"main::","kind":12},{"line":402,"containerName":null,"kind":13,"name":"$map"},{"definition":"my","line":403,"containerName":null,"localvar":"my","kind":13,"name":"$increase"},{"name":"$pos","kind":13,"containerName":null,"line":403},{"name":"length","containerName":"main::","kind":12,"line":403},{"containerName":null,"kind":13,"name":"$pos","line":403},{"line":403,"name":"start","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$pos","line":403},{"line":403,"containerName":"main::","kind":12,"name":"absolute_relative"},{"line":403,"containerName":null,"kind":13,"name":"$main_pos"},{"name":"end","containerName":"main::","kind":12,"line":403},{"line":404,"containerName":null,"kind":13,"name":"%increase"},{"line":405,"containerName":null,"kind":13,"name":"$main_pos"},{"line":405,"name":"end","kind":12,"containerName":"main::"},{"line":405,"containerName":null,"kind":13,"name":"$main_pos"},{"containerName":"main::","kind":12,"name":"end","line":405},{"line":405,"kind":13,"containerName":null,"name":"$increase"},{"containerName":null,"kind":13,"name":"$self","line":409},{"line":409,"containerName":"main::","kind":12,"name":"active_transcript"},{"line":409,"containerName":null,"kind":13,"name":"$map"},{"name":"@transcripts","kind":13,"containerName":null,"line":409},{"signature":{"label":"active_transcript($self,$map,$int)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$int"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set"},"line":430,"kind":12,"range":{"start":{"character":0,"line":430},"end":{"character":9999,"line":459}},"definition":"sub","detail":"($self,$map,$int)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"active_transcript","line":431,"definition":"my"},{"name":"$map","containerName":"active_transcript","kind":13,"line":431},{"name":"$int","kind":13,"containerName":"active_transcript","line":431},{"containerName":"active_transcript","kind":13,"name":"$map","line":432},{"definition":"my","line":434,"containerName":"active_transcript","localvar":"my","kind":13,"name":"@transcripts"},{"line":434,"name":"$self","containerName":"active_transcript","kind":13},{"name":"get_transcript_positions","containerName":"active_transcript","kind":12,"line":434},{"containerName":"active_transcript","kind":13,"name":"$map","line":434},{"kind":13,"containerName":"active_transcript","name":"@transcripts","line":435},{"name":"$int","kind":13,"containerName":"active_transcript","line":436},{"line":437,"containerName":"active_transcript","kind":13,"name":"$int"},{"line":437,"kind":13,"containerName":"active_transcript","name":"$int"},{"kind":13,"containerName":"active_transcript","name":"@transcripts","line":437},{"kind":13,"containerName":"active_transcript","name":"$self","line":438},{"name":"$map","kind":13,"containerName":"active_transcript","line":438},{"kind":13,"containerName":"active_transcript","name":"$int","line":438},{"name":"$int","containerName":"active_transcript","kind":13,"line":439},{"line":442,"kind":13,"containerName":"active_transcript","name":"$self"},{"name":"warn","kind":12,"containerName":"active_transcript","line":442},{"kind":13,"containerName":"active_transcript","name":"$self","line":447},{"line":447,"kind":13,"containerName":"active_transcript","name":"$map"},{"line":448,"name":"$self","containerName":"active_transcript","kind":13},{"line":448,"containerName":"active_transcript","kind":13,"name":"$map"},{"kind":13,"containerName":"active_transcript","name":"$self","line":453},{"containerName":"active_transcript","kind":13,"name":"$map","line":453},{"line":453,"name":"@transcripts","kind":13,"containerName":"active_transcript"},{"line":454,"name":"$self","containerName":"active_transcript","kind":13},{"name":"$map","kind":13,"containerName":"active_transcript","line":454}],"name":"active_transcript","containerName":"main::"},{"kind":12,"name":"active_transcript","line":438},{"name":"active_transcript","kind":12,"line":447},{"line":448,"kind":12,"name":"active_transcript"},{"line":453,"kind":12,"name":"active_transcript"},{"name":"active_transcript","kind":12,"line":454},{"signature":{"label":"get_transcript_positions($self,$map)","parameters":[{"label":"$self"},{"label":"$map"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap"},"line":472,"range":{"end":{"line":477,"character":9999},"start":{"character":0,"line":472}},"kind":12,"definition":"sub","detail":"($self,$map)","children":[{"line":473,"containerName":"get_transcript_positions","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":473,"name":"$map","containerName":"get_transcript_positions","kind":13},{"line":474,"name":"$map","containerName":"get_transcript_positions","kind":13},{"line":475,"containerName":"get_transcript_positions","kind":13,"name":"$map"},{"line":475,"containerName":"get_transcript_positions","kind":12,"name":"isa"},{"line":476,"kind":13,"containerName":"get_transcript_positions","name":"$self"},{"line":476,"kind":12,"containerName":"get_transcript_positions","name":"_get_typed_positions"},{"kind":13,"containerName":"get_transcript_positions","name":"$map","line":476}],"containerName":"main::","name":"get_transcript_positions"},{"signature":{"label":"get_transcript_position($self,$map,$value)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}]},"line":493,"range":{"start":{"character":0,"line":493},"end":{"line":502,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$map,$value)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_transcript_position","name":"$self","line":494},{"name":"$map","containerName":"get_transcript_position","kind":13,"line":494},{"name":"$value","kind":13,"containerName":"get_transcript_position","line":494},{"kind":13,"containerName":"get_transcript_position","name":"$map","line":495},{"containerName":"get_transcript_position","kind":13,"name":"$value","line":496},{"line":496,"name":"$self","kind":13,"containerName":"get_transcript_position"},{"name":"active_transcript","containerName":"get_transcript_position","kind":12,"line":496},{"line":496,"containerName":"get_transcript_position","kind":13,"name":"$map"},{"line":497,"name":"@transcripts","localvar":"my","kind":13,"containerName":"get_transcript_position","definition":"my"},{"name":"$self","containerName":"get_transcript_position","kind":13,"line":497},{"name":"get_transcript_positions","containerName":"get_transcript_position","kind":12,"line":497},{"containerName":"get_transcript_position","kind":13,"name":"$map","line":497},{"name":"@transcripts","containerName":"get_transcript_position","kind":13,"line":498},{"name":"$value","containerName":"get_transcript_position","kind":13,"line":498},{"line":499,"containerName":"get_transcript_position","kind":13,"name":"$self"},{"kind":12,"containerName":"get_transcript_position","name":"position","line":499},{"name":"$map","kind":13,"containerName":"get_transcript_position","line":499},{"containerName":"get_transcript_position","kind":13,"name":"$self","line":501},{"line":501,"name":"_get_list_element","containerName":"get_transcript_position","kind":12},{"containerName":"get_transcript_position","kind":13,"name":"$value","line":501},{"containerName":"get_transcript_position","kind":13,"name":"@transcripts","line":501}],"containerName":"main::","name":"get_transcript_position"},{"name":"coding_position","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"coding_position","name":"$self","line":533,"definition":"my"},{"kind":13,"containerName":"coding_position","name":"$thing","line":533},{"line":533,"name":"$transcript_num","containerName":"coding_position","kind":13},{"kind":13,"containerName":"coding_position","name":"$thing","line":534},{"name":"$transcript_num","containerName":"coding_position","kind":13,"line":535},{"line":539,"containerName":"coding_position","kind":13,"name":"$thing"},{"line":539,"containerName":"coding_position","kind":12,"name":"isa"},{"definition":"my","name":"$map","containerName":"coding_position","localvar":"my","kind":13,"line":540},{"name":"$thing","kind":13,"containerName":"coding_position","line":540},{"name":"map","containerName":"coding_position","kind":12,"line":540},{"localvar":"my","containerName":"coding_position","kind":13,"name":"$existing_pos","line":541,"definition":"my"},{"name":"$self","containerName":"coding_position","kind":13,"line":541},{"line":541,"containerName":"coding_position","kind":12,"name":"_get_typed_positions"},{"line":541,"kind":13,"containerName":"coding_position","name":"$map"},{"name":"$transcript_num","kind":13,"containerName":"coding_position","line":541},{"name":"$existing_pos","kind":13,"containerName":"coding_position","line":542},{"name":"$self","kind":13,"containerName":"coding_position","line":544},{"line":544,"name":"purge_positions","containerName":"coding_position","kind":12},{"line":544,"name":"$existing_pos","kind":13,"containerName":"coding_position"},{"line":546,"containerName":"coding_position","kind":13,"name":"$self"},{"line":546,"kind":12,"containerName":"coding_position","name":"_add_type_position"},{"containerName":"coding_position","kind":13,"name":"$thing","line":546},{"kind":13,"containerName":"coding_position","name":"$transcript_num","line":546},{"containerName":"coding_position","kind":13,"name":"$thing","line":547},{"kind":13,"containerName":"coding_position","name":"$map","line":547},{"definition":"my","line":550,"name":"$pos","localvar":"my","kind":13,"containerName":"coding_position"},{"name":"$self","containerName":"coding_position","kind":13,"line":550},{"line":550,"containerName":"coding_position","kind":12,"name":"_get_typed_positions"},{"containerName":"coding_position","kind":13,"name":"$thing","line":550},{"line":550,"name":"$transcript_num","kind":13,"containerName":"coding_position"},{"kind":13,"containerName":"coding_position","name":"$pos","line":551},{"line":551,"containerName":"coding_position","kind":13,"name":"$self"},{"kind":12,"containerName":"coding_position","name":"get_transcript_position","line":551},{"kind":13,"containerName":"coding_position","name":"$thing","line":551},{"name":"$transcript_num","kind":13,"containerName":"coding_position","line":551}],"detail":"($self,$thing,$transcript_num)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":532},"end":{"character":9999,"line":552}},"line":532,"signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map","parameters":[{"label":"$self"},{"label":"$thing"},{"label":"$transcript_num"}],"label":"coding_position($self,$thing,$transcript_num)"}},{"definition":"sub","children":[{"line":571,"kind":13,"localvar":"my","containerName":"add_exon_position","name":"$self","definition":"my"},{"line":572,"containerName":"add_exon_position","kind":13,"name":"$self"},{"containerName":"add_exon_position","kind":12,"name":"_add_type_position","line":572}],"name":"add_exon_position","containerName":"main::","line":570,"kind":12,"range":{"start":{"character":0,"line":570},"end":{"line":573,"character":9999}}},{"children":[{"definition":"my","line":589,"localvar":"my","kind":13,"containerName":"get_exon_positions","name":"$self"},{"line":589,"kind":13,"containerName":"get_exon_positions","name":"$map"},{"name":"$value","kind":13,"containerName":"get_exon_positions","line":589},{"line":590,"name":"$map","containerName":"get_exon_positions","kind":13},{"kind":13,"containerName":"get_exon_positions","name":"$value","line":591},{"line":592,"name":"$self","kind":13,"containerName":"get_exon_positions"},{"kind":12,"containerName":"get_exon_positions","name":"_get_typed_positions","line":592},{"line":592,"kind":13,"containerName":"get_exon_positions","name":"$map"},{"kind":13,"containerName":"get_exon_positions","name":"$value","line":592}],"containerName":"main::","name":"get_exon_positions","definition":"sub","detail":"($self,$map,$value)","line":588,"range":{"start":{"line":588,"character":0},"end":{"character":9999,"line":593}},"kind":12,"signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"label":"get_exon_positions($self,$map,$value)"}},{"line":613,"range":{"end":{"line":620,"character":9999},"start":{"character":0,"line":613}},"kind":12,"signature":{"label":"get_exon_position($self,$map,$exon_num,$value)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$exon_num"},{"label":"$value"}]},"children":[{"definition":"my","line":614,"containerName":"get_exon_position","localvar":"my","kind":13,"name":"$self"},{"line":614,"name":"$map","kind":13,"containerName":"get_exon_position"},{"name":"$exon_num","containerName":"get_exon_position","kind":13,"line":614},{"line":614,"name":"$value","containerName":"get_exon_position","kind":13},{"definition":"my","name":"@exons","localvar":"my","containerName":"get_exon_position","kind":13,"line":615},{"line":615,"kind":13,"containerName":"get_exon_position","name":"$self"},{"line":615,"name":"get_exon_positions","containerName":"get_exon_position","kind":12},{"kind":13,"containerName":"get_exon_position","name":"$map","line":615},{"name":"$value","kind":13,"containerName":"get_exon_position","line":615},{"name":"@exons","containerName":"get_exon_position","kind":13,"line":616},{"containerName":"get_exon_position","kind":13,"name":"$exon_num","line":616},{"line":617,"containerName":"get_exon_position","kind":13,"name":"$self"},{"line":617,"name":"get_transcript_position","containerName":"get_exon_position","kind":12},{"name":"$map","containerName":"get_exon_position","kind":13,"line":617},{"containerName":"get_exon_position","kind":13,"name":"$value","line":617},{"line":619,"kind":13,"containerName":"get_exon_position","name":"$self"},{"name":"_get_list_element","kind":12,"containerName":"get_exon_position","line":619},{"line":619,"name":"$exon_num","containerName":"get_exon_position","kind":13},{"line":619,"kind":13,"containerName":"get_exon_position","name":"@exons"}],"containerName":"main::","name":"get_exon_position","definition":"sub","detail":"($self,$map,$exon_num,$value)"},{"range":{"start":{"line":638,"character":0},"end":{"line":641,"character":9999}},"kind":12,"line":638,"containerName":"main::","name":"add_intron_position","children":[{"definition":"my","line":639,"name":"$self","localvar":"my","containerName":"add_intron_position","kind":13},{"line":640,"name":"$self","kind":13,"containerName":"add_intron_position"},{"name":"_add_type_position","kind":12,"containerName":"add_intron_position","line":640}],"definition":"sub"},{"containerName":"main::","name":"get_intron_positions","children":[{"definition":"my","line":657,"name":"$self","localvar":"my","kind":13,"containerName":"get_intron_positions"},{"line":657,"name":"$map","kind":13,"containerName":"get_intron_positions"},{"name":"$value","kind":13,"containerName":"get_intron_positions","line":657},{"kind":13,"containerName":"get_intron_positions","name":"$map","line":658},{"line":659,"name":"$value","kind":13,"containerName":"get_intron_positions"},{"line":660,"name":"$self","kind":13,"containerName":"get_intron_positions"},{"line":660,"containerName":"get_intron_positions","kind":12,"name":"_get_typed_positions"},{"line":660,"containerName":"get_intron_positions","kind":13,"name":"$map"},{"containerName":"get_intron_positions","kind":13,"name":"$value","line":660}],"detail":"($self,$map,$value)","definition":"sub","range":{"end":{"character":9999,"line":661},"start":{"line":656,"character":0}},"kind":12,"line":656,"signature":{"label":"get_intron_positions($self,$map,$value)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$map"},{"label":"$intron_num"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_intron_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'intron', $value);\n}\n\n=head2 get_intron_position\n\n Title   : get_intron_position\n Usage   : my $position = $gene->get_intron_position($map, $intron_num, $int);\n Function: Get the $intron_num'th intron position that is relative to the\n           $int'th transcript position added to the map. Introns are numbered in\n           Position order, not the order they were added to the map.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the intron you want) AND int (the\n           transcript number; if second int not supplied, or 0, considers the\n           currently active transcript)","label":"get_intron_position($self,$map,$intron_num,$value)"},"kind":12,"range":{"start":{"line":677,"character":0},"end":{"character":9999,"line":681}},"line":677,"detail":"($self,$map,$intron_num,$value)","definition":"sub","name":"get_intron_position","containerName":"main::","children":[{"definition":"my","line":678,"name":"$self","localvar":"my","containerName":"get_intron_position","kind":13},{"line":678,"name":"$map","kind":13,"containerName":"get_intron_position"},{"line":678,"kind":13,"containerName":"get_intron_position","name":"$intron_num"},{"line":678,"name":"$value","kind":13,"containerName":"get_intron_position"},{"line":679,"name":"@introns","localvar":"my","kind":13,"containerName":"get_intron_position","definition":"my"},{"containerName":"get_intron_position","kind":13,"name":"$self","line":679},{"containerName":"get_intron_position","kind":12,"name":"get_intron_positions","line":679},{"line":679,"name":"$map","containerName":"get_intron_position","kind":13},{"name":"$value","kind":13,"containerName":"get_intron_position","line":679},{"line":680,"name":"$self","kind":13,"containerName":"get_intron_position"},{"name":"_get_list_element","containerName":"get_intron_position","kind":12,"line":680},{"line":680,"name":"$intron_num","kind":13,"containerName":"get_intron_position"},{"line":680,"kind":13,"containerName":"get_intron_position","name":"@introns"}]},{"detail":"($self,$bool)","definition":"sub","name":"set_from_db","containerName":"main::","children":[{"line":708,"name":"$self","localvar":"my","containerName":"set_from_db","kind":13,"definition":"my"},{"kind":13,"containerName":"set_from_db","name":"$bool","line":708},{"line":709,"containerName":"set_from_db","kind":13,"name":"$USE_ENSEMBL"},{"name":"registry_setup","containerName":"set_from_db","kind":12,"line":710},{"kind":13,"containerName":"set_from_db","name":"$bool","line":711},{"line":711,"name":"$bool","kind":13,"containerName":"set_from_db"},{"line":713,"containerName":"set_from_db","kind":13,"name":"$self"},{"line":714,"containerName":"set_from_db","kind":13,"name":"$SET_FROM_DB"},{"name":"$bool","containerName":"set_from_db","kind":13,"line":714},{"line":718,"kind":13,"containerName":"set_from_db","name":"$self"},{"kind":13,"containerName":"set_from_db","name":"$bool","line":718},{"name":"$success","containerName":"set_from_db","localvar":"my","kind":13,"line":720,"definition":"my"},{"definition":"my","line":721,"name":"$map","containerName":"set_from_db","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"set_from_db","line":721},{"line":721,"containerName":"set_from_db","kind":12,"name":"known_maps"},{"containerName":"set_from_db","kind":13,"name":"$success","line":722},{"line":722,"kind":13,"containerName":"set_from_db","name":"$self"},{"line":722,"name":"_set_from_db","kind":12,"containerName":"set_from_db"},{"line":722,"kind":13,"containerName":"set_from_db","name":"$map"},{"containerName":"set_from_db","kind":13,"name":"$success","line":725}],"signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_intron_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'intron', $value);\n}\n\n=head2 get_intron_position\n\n Title   : get_intron_position\n Usage   : my $position = $gene->get_intron_position($map, $intron_num, $int);\n Function: Get the $intron_num'th intron position that is relative to the\n           $int'th transcript position added to the map. Introns are numbered in\n           Position order, not the order they were added to the map.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the intron you want) AND int (the\n           transcript number; if second int not supplied, or 0, considers the\n           currently active transcript)\n\n\nsub get_intron_position {\n    my ($self, $map, $intron_num, $value) = @_;\n    my @introns = $self->get_intron_positions($map, $value);\n    return $self->_get_list_element($intron_num, @introns);\n}\n\n=head2 set_from_db\n\n Title   : set_from_db\n Usage   : $gene->set_from_db(); # for an instance only\n           Bio::Map::Gene->set_from_db(); # decide that all future genes added\n                                          # to maps will be set from db\n Function: Creates all the various types of positions (transcripts, coding,\n           exons, introns) for this gene on all its maps. The information comes\n           from an Ensembl database via Bio::Tools::Run::Ensembl. NB: will\n           purge any existing Bio::Map::GenePosition objects that were\n           previously on the maps this gene is one.\n Returns : undef on failure, otherwise the number of maps that successfully\n           had positions added to them\n Args    : boolean (no argument/undef is treated as 1, ie. do set from db;\n           supply 0 to turn off)\n\n           NB: Bio::Tools::Run::Ensembl is available in the bioperl-run package;\n           see it for details on setting up a database to use.\n\n           Once set, any new maps (species) this gene is added to will\n           automatically also have their positions set_from_db","parameters":[{"label":"$self"},{"label":"$bool"}],"label":"set_from_db($self,$bool)"},"kind":12,"range":{"start":{"character":0,"line":707},"end":{"character":9999,"line":726}},"line":707},{"name":"Bio","containerName":"Tools::Run::Ensembl","kind":12,"line":710},{"line":718,"kind":12,"name":"_set_from_db"},{"signature":{"documentation":" set from db for a particular map (species)","parameters":[{"label":"$self"},{"label":"$map"}],"label":"_set_from_db($self,$map)"},"range":{"start":{"character":0,"line":729},"end":{"line":754,"character":9999}},"kind":12,"line":729,"detail":"($self,$map)","definition":"sub","containerName":"main::","name":"_set_from_db","children":[{"definition":"my","containerName":"_set_from_db","localvar":"my","kind":13,"name":"$self","line":730},{"line":730,"name":"$map","kind":13,"containerName":"_set_from_db"},{"line":731,"localvar":"my","kind":13,"containerName":"_set_from_db","name":"$gene_name","definition":"my"},{"line":731,"containerName":"_set_from_db","kind":13,"name":"$self"},{"containerName":"_set_from_db","kind":12,"name":"universal_name","line":731},{"line":732,"containerName":"_set_from_db","kind":13,"name":"$SET_FROM_DB"},{"name":"$self","containerName":"_set_from_db","kind":13,"line":732},{"line":734,"name":"$species","localvar":"my","containerName":"_set_from_db","kind":13,"definition":"my"},{"line":734,"name":"$map","containerName":"_set_from_db","kind":13},{"line":734,"kind":12,"containerName":"_set_from_db","name":"species"},{"name":"$slice_adaptor","localvar":"my","containerName":"_set_from_db","kind":13,"line":736,"definition":"my"},{"line":736,"name":"get_adaptor","kind":12,"containerName":"_set_from_db"},{"line":736,"containerName":"_set_from_db","kind":13,"name":"$species"},{"definition":"my","line":737,"kind":13,"localvar":"my","containerName":"_set_from_db","name":"$gene"},{"name":"get_gene_by_name","containerName":"_set_from_db","kind":12,"line":737},{"name":"$species","containerName":"_set_from_db","kind":13,"line":737},{"containerName":"_set_from_db","kind":13,"name":"$gene_name","line":738},{"kind":13,"containerName":"_set_from_db","name":"$self","line":744},{"line":744,"kind":12,"containerName":"_set_from_db","name":"description"},{"name":"$gene","kind":13,"containerName":"_set_from_db","line":744},{"line":744,"name":"description","containerName":"_set_from_db","kind":12},{"line":744,"containerName":"_set_from_db","kind":13,"name":"$map"},{"line":745,"name":"$self","containerName":"_set_from_db","kind":13},{"line":745,"name":"display_id","containerName":"_set_from_db","kind":12},{"containerName":"_set_from_db","kind":13,"name":"$gene","line":745},{"line":745,"name":"display_id","containerName":"_set_from_db","kind":12},{"line":745,"name":"$map","containerName":"_set_from_db","kind":13},{"kind":13,"containerName":"_set_from_db","name":"$self","line":746},{"kind":12,"containerName":"_set_from_db","name":"display_xref","line":746},{"line":746,"kind":13,"containerName":"_set_from_db","name":"$gene"},{"line":746,"kind":12,"containerName":"_set_from_db","name":"display_xref"},{"name":"display_id","kind":12,"containerName":"_set_from_db","line":746},{"line":746,"name":"$map","containerName":"_set_from_db","kind":13},{"containerName":"_set_from_db","kind":13,"name":"$self","line":747},{"name":"external_db","containerName":"_set_from_db","kind":12,"line":747},{"line":747,"name":"$gene","containerName":"_set_from_db","kind":13},{"line":747,"kind":12,"containerName":"_set_from_db","name":"external_db"},{"name":"$map","containerName":"_set_from_db","kind":13,"line":747},{"kind":13,"containerName":"_set_from_db","name":"$self","line":748},{"line":748,"name":"external_name","kind":12,"containerName":"_set_from_db"},{"line":748,"kind":13,"containerName":"_set_from_db","name":"$gene"},{"line":748,"kind":12,"containerName":"_set_from_db","name":"external_name"},{"line":748,"name":"$map","containerName":"_set_from_db","kind":13},{"kind":13,"containerName":"_set_from_db","name":"$self","line":749},{"name":"biotype","containerName":"_set_from_db","kind":12,"line":749},{"line":749,"containerName":"_set_from_db","kind":13,"name":"$gene"},{"line":749,"name":"biotype","kind":12,"containerName":"_set_from_db"},{"line":749,"name":"$map","containerName":"_set_from_db","kind":13},{"line":750,"kind":13,"containerName":"_set_from_db","name":"$self"},{"line":750,"containerName":"_set_from_db","kind":12,"name":"source"},{"name":"$gene","containerName":"_set_from_db","kind":13,"line":750},{"name":"source","kind":12,"containerName":"_set_from_db","line":750},{"name":"$map","kind":13,"containerName":"_set_from_db","line":750},{"definition":"my","name":"$trans_ref","localvar":"my","containerName":"_set_from_db","kind":13,"line":753},{"name":"$gene","kind":13,"containerName":"_set_from_db","line":753},{"line":753,"kind":12,"containerName":"_set_from_db","name":"get_all_Transcripts"},{"name":"$trans_ref","kind":13,"containerName":"_set_from_db","line":754},{"kind":13,"containerName":"_set_from_db","name":"$trans_ref","line":754}]},{"line":732,"name":"_set_from_db","kind":12},{"kind":12,"containerName":"Tools::Run::Ensembl","name":"Bio","line":736},{"kind":12,"containerName":"Tools::Run::Ensembl","name":"Bio","line":737},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$handler","line":759},{"line":759,"containerName":null,"kind":13,"name":"$map"},{"containerName":"main::","kind":12,"name":"get_position_handler","line":759},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$pos","line":760},{"containerName":null,"kind":13,"name":"$map","line":760},{"name":"get_positions","containerName":"main::","kind":12,"line":760},{"containerName":null,"kind":13,"name":"$pos","line":761},{"containerName":"main::","kind":12,"name":"isa","line":761},{"line":762,"kind":13,"containerName":null,"name":"$handler"},{"line":762,"name":"purge_positions","containerName":"main::","kind":12},{"name":"$pos","containerName":null,"kind":13,"line":762},{"definition":"my","line":767,"name":"$strand","kind":13,"localvar":"my","containerName":null},{"name":"@trans_ref","containerName":null,"kind":13,"line":767},{"kind":12,"containerName":"main::","name":"strand","line":767},{"definition":"my","line":768,"name":"@transcripts","kind":13,"localvar":"my","containerName":null},{"name":"$strand","containerName":null,"kind":13,"line":768},{"line":768,"containerName":null,"kind":13,"name":"$b"},{"line":768,"containerName":"main::","kind":12,"name":"end"},{"name":"$a","kind":13,"containerName":null,"line":768},{"kind":12,"containerName":"main::","name":"end","line":768},{"line":768,"name":"$a","kind":13,"containerName":null},{"line":768,"name":"start","containerName":"main::","kind":12},{"line":768,"name":"$b","containerName":null,"kind":13},{"line":768,"name":"start","containerName":"main::","kind":12},{"name":"$trans_ref","containerName":null,"kind":13,"line":768},{"definition":"my","line":772,"name":"$primary_slice","localvar":"my","containerName":null,"kind":13},{"line":772,"containerName":null,"kind":13,"name":"$slice_adaptor"},{"name":"fetch_by_transcript_stable_id","kind":12,"containerName":"main::","line":772},{"line":772,"kind":13,"containerName":null,"name":"@transcripts"},{"name":"stable_id","kind":12,"containerName":"main::","line":772},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$uid","line":773},{"line":773,"name":"$map","containerName":null,"kind":13},{"line":773,"containerName":"main::","kind":12,"name":"unique_id"},{"name":"%self","containerName":null,"kind":13,"line":774},{"name":"_ensembl","kind":12,"line":774},{"containerName":null,"kind":13,"name":"$uid","line":774},{"line":774,"kind":13,"containerName":null,"name":"$slice_adaptor"},{"line":774,"name":"$primary_slice","containerName":null,"kind":13},{"line":774,"name":"$strand","kind":13,"containerName":null},{"definition":"my","name":"$adjust","kind":13,"localvar":"my","containerName":null,"line":784},{"line":784,"name":"$strand","kind":13,"containerName":null},{"name":"@transcripts","containerName":null,"kind":13,"line":784},{"name":"end","kind":12,"containerName":"main::","line":784},{"line":784,"name":"@transcripts","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"start","line":784},{"line":785,"name":"$orig_adjust","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$adjust","line":785},{"definition":"my","line":786,"localvar":"my","containerName":null,"kind":13,"name":"%adjustment"},{"line":786,"name":"$strand","kind":13,"containerName":null},{"line":786,"kind":13,"containerName":null,"name":"$adjust"},{"name":"$adjust","containerName":null,"kind":13,"line":786},{"line":789,"name":"$longest_trans","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$longest","kind":13,"localvar":"my","containerName":null,"line":790,"definition":"my"},{"kind":13,"localvar":"my","containerName":null,"name":"$count","line":791,"definition":"my"},{"line":792,"name":"$transcript","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"@transcripts","containerName":null,"kind":13,"line":792},{"line":794,"name":"$length","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"$transcript","containerName":null,"kind":13,"line":794},{"name":"length","containerName":"main::","kind":12,"line":794},{"name":"$length","containerName":null,"kind":13,"line":795},{"name":"%longest_trans","containerName":null,"kind":13,"line":795},{"line":796,"name":"$longest_trans","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$length","line":796},{"containerName":null,"kind":13,"name":"$longest","line":797},{"line":797,"kind":13,"containerName":null,"name":"$count"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$slice","line":801},{"line":801,"kind":13,"containerName":null,"name":"$slice_adaptor"},{"line":801,"name":"fetch_by_transcript_stable_id","kind":12,"containerName":"main::"},{"name":"$transcript","kind":13,"containerName":null,"line":801},{"containerName":"main::","kind":12,"name":"stable_id","line":801},{"localvar":"my","containerName":null,"kind":13,"name":"$start","line":802,"definition":"my"},{"line":802,"kind":12,"name":"adjustment"},{"line":802,"kind":13,"containerName":null,"name":"$slice"},{"line":802,"name":"start","kind":12,"containerName":"main::"},{"definition":"my","line":803,"localvar":"my","kind":13,"containerName":null,"name":"$end"},{"line":803,"kind":12,"name":"adjustment"},{"line":803,"name":"$slice","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"end","line":803},{"line":804,"containerName":null,"kind":13,"name":"$start"},{"line":804,"containerName":null,"kind":13,"name":"$end"},{"line":804,"containerName":null,"kind":13,"name":"$end"},{"containerName":null,"kind":13,"name":"$start","line":804},{"line":804,"kind":13,"containerName":null,"name":"$start"},{"kind":13,"containerName":null,"name":"$end","line":804},{"definition":"my","line":806,"kind":13,"localvar":"my","containerName":null,"name":"$trans_pos"},{"line":806,"name":"Bio","kind":12,"containerName":"Map::GenePosition"},{"line":806,"containerName":"main::","kind":12,"name":"new"},{"name":"$map","containerName":null,"kind":13,"line":806},{"line":806,"name":"$start","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$end","line":806},{"name":"$self","kind":13,"containerName":null,"line":807},{"line":807,"name":"add_transcript_position","containerName":"main::","kind":12},{"line":807,"name":"$trans_pos","kind":13,"containerName":null},{"name":"$adjust","kind":13,"containerName":null,"line":811},{"line":811,"kind":13,"containerName":null,"name":"$strand"},{"kind":13,"containerName":null,"name":"$slice","line":811},{"containerName":"main::","kind":12,"name":"end","line":811},{"line":811,"name":"$slice","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"start","line":811},{"line":814,"containerName":null,"kind":13,"name":"$transcript"},{"line":814,"name":"coding_region_start","kind":12,"containerName":"main::"},{"line":815,"containerName":null,"localvar":"my","kind":13,"name":"$atg","definition":"my"},{"kind":12,"name":"adjustment","line":815},{"containerName":null,"kind":13,"name":"$transcript","line":815},{"line":815,"name":"coding_region_start","containerName":"main::","kind":12},{"definition":"my","line":816,"kind":13,"localvar":"my","containerName":null,"name":"$stop"},{"line":816,"name":"adjustment","kind":12},{"name":"$transcript","containerName":null,"kind":13,"line":816},{"line":816,"name":"coding_region_end","containerName":"main::","kind":12},{"line":817,"kind":13,"containerName":null,"name":"$atg"},{"line":817,"kind":13,"containerName":null,"name":"$stop"},{"line":817,"kind":13,"containerName":null,"name":"$stop"},{"line":817,"name":"$atg","kind":13,"containerName":null},{"line":817,"name":"$atg","kind":13,"containerName":null},{"line":817,"kind":13,"containerName":null,"name":"$stop"},{"line":819,"localvar":"my","containerName":null,"kind":13,"name":"$cod_pos","definition":"my"},{"line":819,"name":"Bio","containerName":"Map::GenePosition","kind":12},{"containerName":"main::","kind":12,"name":"new","line":819},{"containerName":null,"kind":13,"name":"$map","line":819},{"line":819,"containerName":null,"kind":13,"name":"$atg"},{"containerName":null,"kind":13,"name":"$stop","line":819},{"name":"$self","containerName":null,"kind":13,"line":820},{"line":820,"name":"coding_position","kind":12,"containerName":"main::"},{"name":"$cod_pos","containerName":null,"kind":13,"line":820},{"definition":"my","line":824,"name":"$exon","containerName":null,"localvar":"my","kind":13},{"line":824,"name":"$transcript","kind":13,"containerName":null},{"name":"get_all_Exons","containerName":"main::","kind":12,"line":824},{"line":825,"name":"$start","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"adjustment","kind":12,"line":825},{"name":"$exon","kind":13,"containerName":null,"line":825},{"line":825,"containerName":"main::","kind":12,"name":"start"},{"definition":"my","line":826,"name":"$end","localvar":"my","containerName":null,"kind":13},{"name":"adjustment","kind":12,"line":826},{"kind":13,"containerName":null,"name":"$exon","line":826},{"kind":12,"containerName":"main::","name":"end","line":826},{"name":"$start","kind":13,"containerName":null,"line":827},{"name":"$end","containerName":null,"kind":13,"line":827},{"line":827,"name":"$end","containerName":null,"kind":13},{"line":827,"name":"$start","containerName":null,"kind":13},{"line":827,"name":"$start","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$end","line":827},{"definition":"my","line":829,"name":"$throw_species","localvar":"my","containerName":null,"kind":13},{"line":829,"kind":13,"containerName":null,"name":"$species"},{"line":829,"kind":13,"containerName":null,"name":"$species"},{"name":"scientific_name","kind":12,"containerName":"main::","line":829},{"name":"$species","kind":13,"containerName":null,"line":829},{"line":830,"kind":13,"containerName":null,"name":"$end"},{"name":"$self","containerName":null,"kind":13,"line":830},{"name":"throw","containerName":"main::","kind":12,"line":830},{"line":830,"name":"$gene","containerName":null,"kind":13},{"line":830,"containerName":"main::","kind":12,"name":"display_id"},{"definition":"my","line":831,"name":"$pos","localvar":"my","kind":13,"containerName":null},{"kind":12,"containerName":"Map::GenePosition","name":"Bio","line":831},{"name":"new","kind":12,"containerName":"main::","line":831},{"name":"$map","kind":13,"containerName":null,"line":831},{"name":"$start","kind":13,"containerName":null,"line":831},{"containerName":null,"kind":13,"name":"$end","line":831},{"kind":13,"containerName":null,"name":"$self","line":832},{"line":832,"name":"add_exon_position","containerName":"main::","kind":12},{"name":"$pos","containerName":null,"kind":13,"line":832},{"line":836,"localvar":"my","kind":13,"containerName":null,"name":"$intron","definition":"my"},{"line":836,"kind":13,"containerName":null,"name":"$transcript"},{"line":836,"containerName":"main::","kind":12,"name":"get_all_Introns"},{"definition":"my","line":837,"containerName":null,"localvar":"my","kind":13,"name":"$start"},{"name":"adjustment","kind":12,"line":837},{"kind":13,"containerName":null,"name":"$intron","line":837},{"containerName":"main::","kind":12,"name":"start","line":837},{"line":838,"containerName":null,"localvar":"my","kind":13,"name":"$end","definition":"my"},{"name":"adjustment","kind":12,"line":838},{"line":838,"kind":13,"containerName":null,"name":"$intron"},{"line":838,"name":"end","kind":12,"containerName":"main::"},{"name":"$start","kind":13,"containerName":null,"line":839},{"line":839,"kind":13,"containerName":null,"name":"$end"},{"line":839,"kind":13,"containerName":null,"name":"$end"},{"containerName":null,"kind":13,"name":"$start","line":839},{"line":839,"name":"$start","containerName":null,"kind":13},{"line":839,"containerName":null,"kind":13,"name":"$end"},{"definition":"my","line":841,"localvar":"my","containerName":null,"kind":13,"name":"$pos"},{"name":"Bio","containerName":"Map::GenePosition","kind":12,"line":841},{"name":"new","containerName":"main::","kind":12,"line":841},{"line":841,"containerName":null,"kind":13,"name":"$map"},{"name":"$start","kind":13,"containerName":null,"line":841},{"line":841,"containerName":null,"kind":13,"name":"$end"},{"name":"$self","containerName":null,"kind":13,"line":842},{"line":842,"kind":12,"containerName":"main::","name":"add_intron_position"},{"line":842,"name":"$pos","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$adjust","line":845},{"line":845,"kind":13,"containerName":null,"name":"%orig_adjust"},{"kind":13,"containerName":null,"name":"$count","line":846},{"line":848,"name":"$self","kind":13,"containerName":null},{"line":848,"name":"active_transcript","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$map","line":848},{"line":848,"containerName":null,"kind":13,"name":"$longest"},{"detail":"($self,$map,$type,$transcript_number)","definition":"sub","name":"_get_typed_positions","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_get_typed_positions","name":"$self","line":855,"definition":"my"},{"line":855,"name":"$map","containerName":"_get_typed_positions","kind":13},{"line":855,"containerName":"_get_typed_positions","kind":13,"name":"$type"},{"line":855,"containerName":"_get_typed_positions","kind":13,"name":"$transcript_number"},{"name":"$transcript_number","kind":13,"containerName":"_get_typed_positions","line":856},{"name":"$transcript_number","kind":13,"containerName":"_get_typed_positions","line":856},{"line":857,"kind":13,"containerName":"_get_typed_positions","name":"$transcript_number"},{"kind":13,"containerName":"_get_typed_positions","name":"$self","line":857},{"containerName":"_get_typed_positions","kind":12,"name":"active_transcript","line":857},{"name":"$map","containerName":"_get_typed_positions","kind":13,"line":857},{"name":"@positions","localvar":"my","containerName":"_get_typed_positions","kind":13,"line":860,"definition":"my"},{"line":861,"localvar":"my","kind":13,"containerName":"_get_typed_positions","name":"$pos","definition":"my"},{"line":861,"kind":13,"containerName":"_get_typed_positions","name":"$self"},{"line":861,"name":"get_positions","kind":12,"containerName":"_get_typed_positions"},{"line":861,"kind":13,"containerName":"_get_typed_positions","name":"$map"},{"line":862,"kind":13,"containerName":"_get_typed_positions","name":"$pos"},{"containerName":"_get_typed_positions","kind":12,"name":"isa","line":862},{"name":"$pos","kind":13,"containerName":"_get_typed_positions","line":863},{"name":"type","containerName":"_get_typed_positions","kind":12,"line":863},{"name":"$type","containerName":"_get_typed_positions","kind":13,"line":863},{"name":"$transcript_number","kind":13,"containerName":"_get_typed_positions","line":865},{"containerName":"_get_typed_positions","localvar":"my","kind":13,"name":"$rel","line":866,"definition":"my"},{"line":866,"name":"$pos","containerName":"_get_typed_positions","kind":13},{"name":"relative","containerName":"_get_typed_positions","kind":12,"line":866},{"name":"$rel","kind":13,"containerName":"_get_typed_positions","line":867},{"line":867,"name":"type","kind":12,"containerName":"_get_typed_positions"},{"definition":"my","containerName":"_get_typed_positions","localvar":"my","kind":13,"name":"$rel_transcript_num","line":868},{"line":868,"name":"$rel","containerName":"_get_typed_positions","kind":13},{"line":868,"containerName":"_get_typed_positions","kind":12,"name":"transcript"},{"line":868,"kind":13,"containerName":"_get_typed_positions","name":"$self"},{"kind":12,"containerName":"_get_typed_positions","name":"active_transcript","line":868},{"line":868,"containerName":"_get_typed_positions","kind":13,"name":"$map"},{"line":869,"kind":13,"containerName":"_get_typed_positions","name":"$rel_transcript_num"},{"kind":13,"containerName":"_get_typed_positions","name":"$transcript_number","line":869},{"kind":13,"containerName":"_get_typed_positions","name":"@positions","line":872},{"line":872,"containerName":"_get_typed_positions","kind":13,"name":"$pos"},{"line":879,"name":"$transcript_number","containerName":"_get_typed_positions","kind":13},{"definition":"my","line":882,"name":"@sort","localvar":"my","containerName":"_get_typed_positions","kind":13},{"line":883,"containerName":"_get_typed_positions","kind":13,"name":"$a"},{"kind":13,"containerName":"_get_typed_positions","name":"$b","line":883},{"line":884,"kind":12,"containerName":"_get_typed_positions","name":"start"},{"kind":12,"containerName":"_get_typed_positions","name":"relative","line":884},{"kind":13,"containerName":"_get_typed_positions","name":"@positions","line":885},{"line":886,"name":"@sort","kind":13,"containerName":"_get_typed_positions"},{"line":889,"localvar":"my","containerName":"_get_typed_positions","kind":13,"name":"@known_order","definition":"my"},{"kind":13,"containerName":"_get_typed_positions","name":"$self","line":889},{"name":"$map","containerName":"_get_typed_positions","kind":13,"line":889},{"line":890,"kind":13,"containerName":"_get_typed_positions","name":"@known_order"},{"line":893,"kind":13,"containerName":"_get_typed_positions","name":"@known_order"},{"line":893,"name":"@known_order","kind":13,"containerName":"_get_typed_positions"},{"name":"@positions","kind":13,"containerName":"_get_typed_positions","line":893},{"localvar":"my","containerName":"_get_typed_positions","kind":13,"name":"%exists","line":894,"definition":"my"},{"name":"@positions","kind":13,"containerName":"_get_typed_positions","line":894},{"line":895,"containerName":"_get_typed_positions","localvar":"my","kind":13,"name":"@new_order","definition":"my"},{"definition":"my","name":"$pos","containerName":"_get_typed_positions","localvar":"my","kind":13,"line":896},{"name":"@known_order","containerName":"_get_typed_positions","kind":13,"line":896},{"name":"$exists","kind":13,"containerName":"_get_typed_positions","line":897},{"line":897,"name":"$pos","containerName":"_get_typed_positions","kind":13},{"line":898,"kind":13,"containerName":"_get_typed_positions","name":"@new_order"},{"name":"$pos","kind":13,"containerName":"_get_typed_positions","line":898},{"line":900,"kind":13,"containerName":"_get_typed_positions","name":"$self"},{"kind":13,"containerName":"_get_typed_positions","name":"$map","line":900}],"signature":{"documentation":" get safely sorted positions of a certain type","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$type"},{"label":"$transcript_number"}],"label":"_get_typed_positions($self,$map,$type,$transcript_number)"},"kind":12,"range":{"start":{"line":854,"character":0},"end":{"character":9999,"line":900}},"line":854},{"kind":12,"name":"t_order","line":889},{"line":900,"name":"t_order","kind":12},{"line":900,"kind":13,"containerName":null,"name":"@new_order"},{"containerName":null,"kind":13,"name":"@new_order","line":901},{"signature":{"label":"_get_list_element($self,$wanted,@list)","parameters":[{"label":"$self"},{"label":"$wanted"},{"label":"@list"}],"documentation":" get a certain element from an array, checking the array has that element"},"line":906,"range":{"end":{"line":915,"character":9999},"start":{"line":906,"character":0}},"kind":12,"definition":"sub","detail":"($self,$wanted,@list)","children":[{"definition":"my","name":"$self","containerName":"_get_list_element","localvar":"my","kind":13,"line":907},{"containerName":"_get_list_element","kind":13,"name":"$wanted","line":907},{"name":"@list","kind":13,"containerName":"_get_list_element","line":907},{"kind":13,"containerName":"_get_list_element","name":"$wanted","line":908},{"line":908,"name":"$wanted","containerName":"_get_list_element","kind":13},{"name":"@list","containerName":"_get_list_element","kind":13,"line":909},{"definition":"my","localvar":"my","kind":13,"containerName":"_get_list_element","name":"$index","line":910},{"kind":13,"containerName":"_get_list_element","name":"$wanted","line":910},{"line":911,"containerName":"_get_list_element","kind":13,"name":"$index"},{"line":911,"name":"$index","containerName":"_get_list_element","kind":13},{"line":912,"kind":13,"containerName":"_get_list_element","name":"$list"},{"kind":13,"containerName":"_get_list_element","name":"$index","line":912}],"name":"_get_list_element","containerName":"main::"},{"name":"list","kind":12,"line":911},{"line":918,"range":{"start":{"character":0,"line":918},"end":{"character":9999,"line":939}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$pos"},{"label":"$transcript_num"}],"documentation":" add a certain type of posiiton","label":"_add_type_position($self,$type,$pos,$transcript_num)"},"children":[{"name":"$self","localvar":"my","containerName":"_add_type_position","kind":13,"line":919,"definition":"my"},{"line":919,"kind":13,"containerName":"_add_type_position","name":"$type"},{"line":919,"kind":13,"containerName":"_add_type_position","name":"$pos"},{"line":919,"name":"$transcript_num","containerName":"_add_type_position","kind":13},{"line":920,"name":"$pos","containerName":"_add_type_position","kind":13},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":920},{"line":920,"name":"isa","containerName":"_add_type_position","kind":12},{"line":922,"name":"$map","localvar":"my","kind":13,"containerName":"_add_type_position","definition":"my"},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":922},{"line":922,"name":"map","containerName":"_add_type_position","kind":12},{"line":922,"containerName":"_add_type_position","kind":13,"name":"$self"},{"containerName":"_add_type_position","kind":12,"name":"throw","line":922},{"name":"$self","containerName":"_add_type_position","kind":13,"line":923},{"name":"in_map","containerName":"_add_type_position","kind":12,"line":923},{"line":923,"name":"$map","containerName":"_add_type_position","kind":13},{"containerName":"_add_type_position","kind":13,"name":"$self","line":923},{"kind":12,"containerName":"_add_type_position","name":"throw","line":923},{"line":925,"name":"$transcript_num","containerName":"_add_type_position","kind":13},{"line":925,"name":"$self","kind":13,"containerName":"_add_type_position"},{"containerName":"_add_type_position","kind":12,"name":"active_transcript","line":925},{"line":925,"name":"$map","kind":13,"containerName":"_add_type_position"},{"line":925,"kind":13,"containerName":"_add_type_position","name":"$self"},{"line":925,"name":"throw","kind":12,"containerName":"_add_type_position"},{"definition":"my","name":"$transcript_pos","containerName":"_add_type_position","localvar":"my","kind":13,"line":928},{"containerName":"_add_type_position","kind":13,"name":"$self","line":928},{"containerName":"_add_type_position","kind":12,"name":"get_transcript_position","line":928},{"line":928,"name":"$map","kind":13,"containerName":"_add_type_position"},{"line":928,"name":"$transcript_num","containerName":"_add_type_position","kind":13},{"line":928,"name":"$self","kind":13,"containerName":"_add_type_position"},{"name":"throw","containerName":"_add_type_position","kind":12,"line":928},{"line":929,"name":"$transcript_pos","kind":13,"containerName":"_add_type_position"},{"line":929,"kind":12,"containerName":"_add_type_position","name":"end"},{"containerName":"_add_type_position","kind":13,"name":"$self","line":929},{"line":929,"containerName":"_add_type_position","kind":12,"name":"warn"},{"kind":13,"containerName":"_add_type_position","name":"$self","line":929},{"line":929,"kind":12,"containerName":"_add_type_position","name":"universal_name"},{"line":929,"name":"$pos","kind":13,"containerName":"_add_type_position"},{"line":929,"name":"map","kind":12,"containerName":"_add_type_position"},{"line":930,"containerName":"_add_type_position","kind":13,"name":"$pos"},{"kind":12,"containerName":"_add_type_position","name":"end","line":930},{"line":930,"name":"$self","kind":13,"containerName":"_add_type_position"},{"name":"warn","containerName":"_add_type_position","kind":12,"line":930},{"name":"$self","kind":13,"containerName":"_add_type_position","line":930},{"containerName":"_add_type_position","kind":12,"name":"universal_name","line":930},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":930},{"name":"map","containerName":"_add_type_position","kind":12,"line":930},{"line":931,"name":"$transcript_pos","kind":13,"containerName":"_add_type_position"},{"line":931,"kind":12,"containerName":"_add_type_position","name":"contains"},{"kind":13,"containerName":"_add_type_position","name":"$pos","line":931},{"name":"$self","containerName":"_add_type_position","kind":13,"line":932},{"name":"warn","kind":12,"containerName":"_add_type_position","line":932},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":936},{"line":936,"kind":12,"containerName":"_add_type_position","name":"type"},{"name":"$type","containerName":"_add_type_position","kind":13,"line":936},{"name":"$pos","kind":13,"containerName":"_add_type_position","line":937},{"line":937,"containerName":"_add_type_position","kind":12,"name":"relative"},{"line":937,"name":"transcript","containerName":"_add_type_position","kind":12},{"line":937,"name":"$transcript_num","kind":13,"containerName":"_add_type_position"},{"line":938,"kind":13,"containerName":"_add_type_position","name":"$self"},{"kind":13,"containerName":"_add_type_position","name":"$pos","line":938}],"containerName":"main::","name":"_add_type_position","definition":"sub","detail":"($self,$type,$pos,$transcript_num)"},{"line":929,"kind":12,"name":"species"},{"kind":12,"name":"species","line":930},{"name":"SUPER","containerName":"add_position","kind":12,"line":938},{"signature":{"label":"_gene_data($self,$type,$thing,$map)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$thing"},{"label":"$map"}],"documentation":" get/setter for general/map-specific data"},"line":942,"kind":12,"range":{"start":{"character":0,"line":942},"end":{"character":9999,"line":957}},"definition":"sub","detail":"($self,$type,$thing,$map)","children":[{"containerName":"_gene_data","localvar":"my","kind":13,"name":"$self","line":943,"definition":"my"},{"line":943,"name":"$type","containerName":"_gene_data","kind":13},{"name":"$thing","containerName":"_gene_data","kind":13,"line":943},{"name":"$map","containerName":"_gene_data","kind":13,"line":943},{"containerName":"_gene_data","kind":13,"name":"$thing","line":944},{"containerName":"_gene_data","kind":13,"name":"$self","line":944},{"line":944,"name":"$type","containerName":"_gene_data","kind":13},{"containerName":"_gene_data","kind":13,"name":"$thing","line":946},{"line":946,"containerName":"_gene_data","kind":13,"name":"$thing"},{"containerName":"_gene_data","kind":12,"name":"isa","line":946},{"name":"$self","containerName":"_gene_data","kind":13,"line":947},{"line":947,"name":"$type","kind":13,"containerName":"_gene_data"},{"name":"$thing","containerName":"_gene_data","kind":13,"line":947},{"line":950,"kind":13,"containerName":"_gene_data","name":"$map"},{"containerName":"_gene_data","kind":13,"name":"$map","line":950},{"kind":12,"containerName":"_gene_data","name":"isa","line":950},{"name":"$self","kind":13,"containerName":"_gene_data","line":951},{"line":951,"kind":13,"containerName":"_gene_data","name":"$type"},{"line":951,"containerName":"_gene_data","kind":13,"name":"$map"},{"line":951,"name":"$thing","kind":13,"containerName":"_gene_data"},{"name":"$self","containerName":"_gene_data","kind":13,"line":954},{"name":"$type","containerName":"_gene_data","kind":13,"line":954},{"line":954,"name":"$thing","kind":13,"containerName":"_gene_data"},{"line":956,"containerName":"_gene_data","kind":13,"name":"$thing"}],"containerName":"main::","name":"_gene_data"},{"name":"general","kind":12,"line":944},{"name":"general","kind":12,"line":954},{"definition":"sub","detail":"($self,$map)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_get_slice","line":961},{"line":961,"containerName":"_get_slice","kind":13,"name":"$map"},{"line":962,"name":"$map","kind":13,"containerName":"_get_slice"},{"name":"$uid","kind":13,"localvar":"my","containerName":"_get_slice","line":963,"definition":"my"},{"line":963,"kind":13,"containerName":"_get_slice","name":"$map"},{"line":963,"kind":12,"containerName":"_get_slice","name":"unique_id"},{"line":964,"name":"$self","containerName":"_get_slice","kind":13},{"containerName":"_get_slice","kind":13,"name":"$uid","line":964},{"line":965,"name":"$self","containerName":"_get_slice","kind":13},{"name":"$uid","containerName":"_get_slice","kind":13,"line":965}],"containerName":"main::","name":"_get_slice","signature":{"documentation":" for exclusive use by GeneMap so it can get sequence data","parameters":[{"label":"$self"},{"label":"$map"}],"label":"_get_slice($self,$map)"},"line":960,"range":{"end":{"line":966,"character":9999},"start":{"character":0,"line":960}},"kind":12},{"name":"_ensembl","kind":12,"line":964},{"kind":12,"name":"_ensembl","line":965}],"version":5}