{"version":5,"vars":[{"line":107,"kind":2,"containerName":"","name":"base"},{"name":"cytorange","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"cytorange","line":156},{"definition":"my","localvar":"my","containerName":"cytorange","kind":13,"name":"$chr","line":157},{"name":"$r","containerName":"cytorange","kind":13,"line":157},{"line":157,"name":"$band","kind":13,"containerName":"cytorange"},{"kind":13,"containerName":"cytorange","name":"$band2","line":157},{"kind":13,"containerName":"cytorange","name":"$arm","line":157},{"name":"$arm2","containerName":"cytorange","kind":13,"line":157},{"line":157,"kind":13,"containerName":"cytorange","name":"$lc"},{"line":157,"kind":13,"containerName":"cytorange","name":"$uc"},{"containerName":"cytorange","kind":13,"name":"$lcchar","line":157},{"line":157,"kind":13,"containerName":"cytorange","name":"$ucchar"},{"line":159,"name":"$r","kind":13,"containerName":"cytorange"},{"name":"$self","containerName":"cytorange","kind":13,"line":159},{"containerName":"cytorange","kind":13,"name":"$self","line":160},{"name":"$self","kind":13,"containerName":"cytorange","line":163},{"name":"warn","containerName":"cytorange","kind":12,"line":163},{"kind":13,"containerName":"cytorange","name":"$self","line":163},{"line":164,"name":"$r","containerName":"cytorange","kind":13},{"line":166,"containerName":"cytorange","kind":13,"name":"$chr"},{"line":167,"kind":13,"containerName":"cytorange","name":"$self"},{"line":167,"name":"chr","containerName":"cytorange","kind":12},{"line":167,"name":"$chr","containerName":"cytorange","kind":13},{"name":"$chr","kind":13,"containerName":"cytorange","line":169},{"name":"$chr","kind":13,"containerName":"cytorange","line":169},{"containerName":"cytorange","kind":13,"name":"$chr","line":170},{"containerName":"cytorange","kind":13,"name":"$chr","line":170},{"line":171,"name":"$chr","containerName":"cytorange","kind":13},{"line":173,"containerName":"cytorange","kind":13,"name":"$r"},{"line":173,"kind":12,"containerName":"cytorange","name":"new"},{"containerName":"cytorange","kind":13,"name":"$band","line":175},{"line":177,"kind":13,"containerName":"cytorange","name":"$self"},{"kind":12,"containerName":"cytorange","name":"throw","line":177},{"containerName":"cytorange","kind":13,"name":"$band","line":178},{"name":"$band","containerName":"cytorange","kind":13,"line":179},{"name":"$arm2","kind":13,"containerName":"cytorange","line":182},{"line":183,"name":"$arm2","containerName":"cytorange","kind":13},{"line":184,"containerName":"cytorange","kind":13,"name":"$band2"},{"line":185,"containerName":"cytorange","kind":13,"name":"$band2"},{"containerName":"cytorange","kind":13,"name":"$band","line":189},{"line":189,"kind":13,"containerName":"cytorange","name":"$arm2"},{"name":"$arm2","kind":13,"containerName":"cytorange","line":189},{"kind":13,"containerName":"cytorange","name":"$arm2","line":189},{"line":190,"containerName":"cytorange","kind":13,"name":"$lc"},{"name":"$lcchar","kind":13,"containerName":"cytorange","line":190},{"line":191,"containerName":"cytorange","kind":13,"name":"$uc"},{"kind":13,"containerName":"cytorange","name":"$ucchar","line":191},{"kind":13,"containerName":"cytorange","name":"$band","line":193},{"containerName":"cytorange","kind":13,"name":"$arm2","line":193},{"line":193,"name":"$arm2","kind":13,"containerName":"cytorange"},{"name":"$lc","containerName":"cytorange","kind":13,"line":194},{"name":"$lcchar","containerName":"cytorange","kind":13,"line":194},{"name":"$uc","kind":13,"containerName":"cytorange","line":195},{"name":"$ucchar","kind":13,"containerName":"cytorange","line":195},{"line":197,"name":"$band","kind":13,"containerName":"cytorange"},{"line":197,"kind":13,"containerName":"cytorange","name":"$arm2"},{"line":198,"name":"$uc","kind":13,"containerName":"cytorange"},{"kind":13,"containerName":"cytorange","name":"$ucchar","line":198},{"line":200,"containerName":"cytorange","kind":13,"name":"$arm2"},{"name":"$band","kind":13,"containerName":"cytorange","line":201},{"kind":13,"containerName":"cytorange","name":"$band2","line":201},{"name":"$lc","kind":13,"containerName":"cytorange","line":202},{"line":202,"name":"$lcchar","kind":13,"containerName":"cytorange"},{"line":203,"name":"$uc","kind":13,"containerName":"cytorange"},{"line":203,"containerName":"cytorange","kind":13,"name":"$ucchar"},{"name":"$lc","containerName":"cytorange","kind":13,"line":205},{"name":"$lcchar","containerName":"cytorange","kind":13,"line":205},{"line":206,"kind":13,"containerName":"cytorange","name":"$uc"},{"line":206,"name":"$ucchar","kind":13,"containerName":"cytorange"},{"line":209,"name":"$arm2","kind":13,"containerName":"cytorange"},{"name":"$band","containerName":"cytorange","kind":13,"line":210},{"kind":13,"containerName":"cytorange","name":"$band2","line":210},{"name":"$lc","kind":13,"containerName":"cytorange","line":211},{"containerName":"cytorange","kind":13,"name":"$lcchar","line":211},{"kind":13,"containerName":"cytorange","name":"$uc","line":212},{"line":212,"name":"$ucchar","kind":13,"containerName":"cytorange"},{"name":"$lc","containerName":"cytorange","kind":13,"line":214},{"containerName":"cytorange","kind":13,"name":"$lcchar","line":214},{"line":215,"name":"$uc","kind":13,"containerName":"cytorange"},{"line":215,"name":"$ucchar","containerName":"cytorange","kind":13},{"name":"$self","kind":13,"containerName":"cytorange","line":219},{"containerName":"cytorange","kind":12,"name":"throw","line":219},{"containerName":"cytorange","kind":13,"name":"$arm2","line":223},{"line":223,"kind":13,"containerName":"cytorange","name":"$arm2"},{"line":223,"containerName":"cytorange","kind":13,"name":"$arm2"},{"name":"$arm2","containerName":"cytorange","kind":13,"line":223},{"name":"$r","kind":13,"containerName":"cytorange","line":224},{"kind":13,"containerName":"cytorange","name":"$uc","line":224},{"line":224,"name":"$band2","containerName":"cytorange","kind":13},{"name":"$ucchar","containerName":"cytorange","kind":13,"line":224},{"containerName":"cytorange","kind":13,"name":"$chr","line":224},{"containerName":"cytorange","kind":13,"name":"$r","line":226},{"line":226,"name":"end","containerName":"cytorange","kind":12},{"line":226,"name":"$chr","kind":13,"containerName":"cytorange"},{"line":229,"name":"$r","containerName":"cytorange","kind":13},{"kind":13,"containerName":"cytorange","name":"$lc","line":229},{"line":229,"kind":13,"containerName":"cytorange","name":"$chr"},{"line":232,"name":"$r","containerName":"cytorange","kind":13},{"line":232,"containerName":"cytorange","kind":13,"name":"$lc"},{"kind":13,"containerName":"cytorange","name":"$band","line":232},{"containerName":"cytorange","kind":13,"name":"$lcchar","line":232},{"containerName":"cytorange","kind":13,"name":"$chr","line":232},{"name":"$r","containerName":"cytorange","kind":13,"line":234},{"name":"$lc","containerName":"cytorange","kind":13,"line":234},{"name":"$band","kind":13,"containerName":"cytorange","line":234},{"line":234,"kind":13,"containerName":"cytorange","name":"$lcchar"},{"line":234,"name":"$chr","kind":13,"containerName":"cytorange"},{"name":"$r","containerName":"cytorange","kind":13,"line":238},{"line":238,"kind":13,"containerName":"cytorange","name":"$uc"},{"line":238,"name":"$band2","containerName":"cytorange","kind":13},{"line":238,"name":"$ucchar","kind":13,"containerName":"cytorange"},{"kind":13,"containerName":"cytorange","name":"$chr","line":238},{"name":"$r","containerName":"cytorange","kind":13,"line":240},{"line":240,"kind":13,"containerName":"cytorange","name":"$lc"},{"line":240,"containerName":"cytorange","kind":13,"name":"$chr"},{"line":244,"containerName":"cytorange","kind":13,"name":"$r"},{"line":244,"kind":13,"containerName":"cytorange","name":"$lc"},{"kind":13,"containerName":"cytorange","name":"$chr","line":244},{"kind":13,"containerName":"cytorange","name":"$r","line":246},{"name":"$lc","kind":13,"containerName":"cytorange","line":246},{"kind":13,"containerName":"cytorange","name":"$band","line":246},{"kind":13,"containerName":"cytorange","name":"$lcchar","line":246},{"containerName":"cytorange","kind":13,"name":"$chr","line":246},{"line":249,"name":"$r","kind":13,"containerName":"cytorange"},{"line":249,"name":"$lc","kind":13,"containerName":"cytorange"},{"line":249,"kind":13,"containerName":"cytorange","name":"$band"},{"line":249,"name":"$lcchar","kind":13,"containerName":"cytorange"},{"line":249,"kind":13,"containerName":"cytorange","name":"$chr"},{"containerName":"cytorange","kind":13,"name":"$r","line":260},{"name":"end","containerName":"cytorange","kind":12,"line":260},{"containerName":"cytorange","kind":13,"name":"$chr","line":260},{"kind":13,"containerName":"cytorange","name":"$r","line":263},{"line":263,"kind":12,"containerName":"cytorange","name":"start"},{"name":"$chr","kind":13,"containerName":"cytorange","line":263},{"containerName":"cytorange","kind":13,"name":"$r","line":265},{"line":265,"name":"start","kind":12,"containerName":"cytorange"},{"name":"$band","kind":13,"containerName":"cytorange","line":265},{"containerName":"cytorange","kind":13,"name":"$chr","line":265},{"line":269,"name":"$self","kind":13,"containerName":"cytorange"},{"line":269,"name":"throw","kind":12,"containerName":"cytorange"},{"line":271,"containerName":"cytorange","kind":13,"name":"$self"},{"line":271,"containerName":"cytorange","kind":12,"name":"throw"},{"line":275,"kind":13,"containerName":"cytorange","name":"$r"},{"containerName":"cytorange","kind":12,"name":"end","line":275},{"kind":13,"containerName":"cytorange","name":"$chr","line":275},{"line":277,"name":"$r","containerName":"cytorange","kind":13},{"name":"start","containerName":"cytorange","kind":12,"line":277},{"name":"$band","kind":13,"containerName":"cytorange","line":277},{"name":"$chr","containerName":"cytorange","kind":13,"line":277},{"containerName":"cytorange","kind":13,"name":"$r","line":280},{"line":280,"name":"start","kind":12,"containerName":"cytorange"},{"line":280,"name":"$band","kind":13,"containerName":"cytorange"},{"line":280,"name":"$chr","containerName":"cytorange","kind":13},{"line":283,"name":"$r","containerName":"cytorange","kind":13},{"line":283,"containerName":"cytorange","kind":12,"name":"start"},{"containerName":"cytorange","kind":13,"name":"$chr","line":283},{"line":288,"containerName":"cytorange","kind":13,"name":"$r"},{"kind":12,"containerName":"cytorange","name":"start","line":288},{"name":"$chr","containerName":"cytorange","kind":13,"line":288},{"name":"$r","kind":13,"containerName":"cytorange","line":290},{"line":290,"name":"end","kind":12,"containerName":"cytorange"},{"containerName":"cytorange","kind":13,"name":"$band","line":290},{"line":290,"name":"$chr","containerName":"cytorange","kind":13},{"line":293,"kind":13,"containerName":"cytorange","name":"$r"},{"name":"end","containerName":"cytorange","kind":12,"line":293},{"line":293,"containerName":"cytorange","kind":13,"name":"$band"},{"line":293,"name":"$chr","containerName":"cytorange","kind":13},{"name":"$r","containerName":"cytorange","kind":13,"line":296},{"name":"end","kind":12,"containerName":"cytorange","line":296},{"line":296,"name":"$chr","kind":13,"containerName":"cytorange"},{"name":"$self","kind":13,"containerName":"cytorange","line":299},{"name":"throw","containerName":"cytorange","kind":12,"line":299},{"line":308,"kind":13,"containerName":"cytorange","name":"$r"},{"line":308,"kind":12,"containerName":"cytorange","name":"new"},{"kind":13,"containerName":"cytorange","name":"$chr","line":308},{"line":309,"name":"$chr","containerName":"cytorange","kind":13},{"name":"$r","kind":13,"containerName":"cytorange","line":312},{"line":312,"containerName":"cytorange","kind":12,"name":"new"},{"line":312,"name":"$band","kind":13,"containerName":"cytorange"},{"name":"$chr","kind":13,"containerName":"cytorange","line":312},{"kind":13,"containerName":"cytorange","name":"$band","line":313},{"name":"$chr","kind":13,"containerName":"cytorange","line":313},{"kind":13,"containerName":"cytorange","name":"$r","line":318},{"name":"new","containerName":"cytorange","kind":12,"line":318},{"line":318,"name":"$chr","kind":13,"containerName":"cytorange"},{"name":"$chr","kind":13,"containerName":"cytorange","line":319},{"line":322,"kind":13,"containerName":"cytorange","name":"$r"},{"line":322,"kind":12,"containerName":"cytorange","name":"new"},{"line":322,"name":"$band","containerName":"cytorange","kind":13},{"name":"$chr","containerName":"cytorange","kind":13,"line":322},{"name":"$band","containerName":"cytorange","kind":13,"line":323},{"line":323,"kind":13,"containerName":"cytorange","name":"$chr"},{"kind":13,"containerName":"cytorange","name":"$self","line":327},{"name":"throw","kind":12,"containerName":"cytorange","line":327},{"name":"$r","containerName":"cytorange","kind":13,"line":335},{"line":335,"kind":12,"containerName":"cytorange","name":"new"},{"containerName":"cytorange","kind":13,"name":"$chr","line":335},{"kind":13,"containerName":"cytorange","name":"$chr","line":337},{"line":340,"kind":13,"containerName":"cytorange","name":"$r"},{"name":"new","containerName":"cytorange","kind":12,"line":340},{"name":"$chr","kind":13,"containerName":"cytorange","line":340},{"name":"$chr","containerName":"cytorange","kind":13,"line":342},{"kind":13,"containerName":"cytorange","name":"$r","line":344},{"line":344,"containerName":"cytorange","kind":12,"name":"new"},{"kind":13,"containerName":"cytorange","name":"$chr","line":344},{"line":346,"name":"$chr","containerName":"cytorange","kind":13},{"line":353,"name":"$r","containerName":"cytorange","kind":13},{"line":353,"kind":12,"containerName":"cytorange","name":"new"},{"line":353,"name":"$chr","containerName":"cytorange","kind":13},{"containerName":"cytorange","kind":13,"name":"$chr","line":355},{"line":358,"containerName":"cytorange","kind":13,"name":"$r"},{"containerName":"cytorange","kind":13,"name":"$self","line":359},{"name":"start","containerName":"cytorange","kind":12,"line":359},{"kind":13,"containerName":"cytorange","name":"$r","line":359},{"containerName":"cytorange","kind":12,"name":"start","line":359},{"kind":13,"containerName":"cytorange","name":"$self","line":360},{"line":360,"name":"end","kind":12,"containerName":"cytorange"},{"line":360,"containerName":"cytorange","kind":13,"name":"$r"},{"containerName":"cytorange","kind":12,"name":"end","line":360},{"name":"$r","kind":13,"containerName":"cytorange","line":362}],"detail":"($self)","definition":"sub","range":{"start":{"line":155,"character":0},"end":{"line":363,"character":9999}},"kind":12,"line":155,"signature":{"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none","parameters":[{"label":"$self"}],"label":"cytorange($self)"}},{"kind":12,"name":"_value","line":159},{"line":160,"kind":12,"name":"_value"},{"name":"_value","kind":12,"line":163},{"line":173,"name":"Bio","containerName":"Range","kind":12},{"line":201,"kind":12,"name":"_pad"},{"kind":12,"name":"_pad","line":201},{"kind":12,"name":"_pad","line":210},{"kind":12,"name":"_pad","line":210},{"kind":12,"name":"_pad","line":224},{"name":"_pad","kind":12,"line":232},{"kind":12,"name":"_pad","line":234},{"line":238,"name":"_pad","kind":12},{"line":246,"kind":12,"name":"_pad"},{"kind":12,"name":"_pad","line":249},{"line":265,"kind":12,"name":"_pad"},{"line":277,"kind":12,"name":"_pad"},{"line":280,"kind":12,"name":"_pad"},{"kind":12,"name":"_pad","line":290},{"name":"_pad","kind":12,"line":293},{"containerName":"Range","kind":12,"name":"Bio","line":308},{"line":312,"containerName":"Range","kind":12,"name":"Bio"},{"kind":12,"name":"_pad","line":312},{"line":313,"kind":12,"name":"_pad"},{"line":318,"name":"Bio","kind":12,"containerName":"Range"},{"name":"Bio","kind":12,"containerName":"Range","line":322},{"line":322,"kind":12,"name":"_pad"},{"name":"_pad","kind":12,"line":323},{"name":"Bio","kind":12,"containerName":"Range","line":335},{"name":"Bio","containerName":"Range","kind":12,"line":340},{"line":344,"name":"Bio","containerName":"Range","kind":12},{"line":353,"name":"Bio","kind":12,"containerName":"Range"},{"children":[{"localvar":"my","containerName":"_pad","kind":13,"name":"$string","line":367,"definition":"my"},{"line":367,"name":"$len","kind":13,"containerName":"_pad"},{"name":"$pad_char","kind":13,"containerName":"_pad","line":367},{"name":"throw","kind":12,"containerName":"_pad","line":368},{"name":"$len","kind":13,"containerName":"_pad","line":369},{"containerName":"_pad","kind":12,"name":"throw","line":370},{"line":371,"name":"$pad_char","kind":13,"containerName":"_pad"},{"containerName":"_pad","kind":13,"name":"$string","line":372},{"line":373,"containerName":"_pad","kind":13,"name":"$string"},{"line":373,"name":"$pad_char","kind":13,"containerName":"_pad"},{"kind":13,"containerName":"_pad","name":"$len","line":373},{"name":"$string","kind":13,"containerName":"_pad","line":373}],"name":"_pad","containerName":"main::","definition":"sub","detail":"($string,$len,$pad_char)","line":366,"range":{"end":{"character":9999,"line":374},"start":{"line":366,"character":0}},"kind":12,"signature":{"label":"_pad($string,$len,$pad_char)","parameters":[{"label":"$string"},{"label":"$len"},{"label":"$pad_char"}],"documentation":""}},{"kind":12,"range":{"end":{"character":9999,"line":514},"start":{"character":0,"line":387}},"line":387,"signature":{"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object","parameters":[{"label":"$self"},{"label":"$value"}],"label":"range2value($self,$value)"},"containerName":"main::","name":"range2value","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"range2value","name":"$self","line":388},{"line":388,"kind":13,"containerName":"range2value","name":"$value"},{"name":"$value","containerName":"range2value","kind":13,"line":389},{"line":390,"containerName":"range2value","kind":13,"name":"$value"},{"line":390,"name":"isa","containerName":"range2value","kind":12},{"line":391,"name":"$self","kind":13,"containerName":"range2value"},{"name":"throw","kind":12,"containerName":"range2value","line":391},{"line":394,"name":"$value","kind":13,"containerName":"range2value"},{"containerName":"range2value","kind":12,"name":"start","line":394},{"name":"$self","kind":13,"containerName":"range2value","line":395},{"kind":12,"containerName":"range2value","name":"throw","line":395},{"line":398,"kind":13,"containerName":"range2value","name":"$value"},{"line":398,"containerName":"range2value","kind":12,"name":"end"},{"line":399,"name":"$self","kind":13,"containerName":"range2value"},{"line":399,"name":"throw","containerName":"range2value","kind":12},{"kind":13,"containerName":"range2value","name":"$value","line":402},{"line":402,"containerName":"range2value","kind":12,"name":"start"},{"line":403,"name":"$self","containerName":"range2value","kind":13},{"containerName":"range2value","kind":12,"name":"throw","line":403},{"line":403,"kind":13,"containerName":"range2value","name":"$value"},{"name":"start","containerName":"range2value","kind":12,"line":403},{"line":406,"containerName":"range2value","kind":13,"name":"$value"},{"name":"end","containerName":"range2value","kind":12,"line":406},{"line":407,"name":"$self","kind":13,"containerName":"range2value"},{"name":"throw","kind":12,"containerName":"range2value","line":407},{"name":"$value","kind":13,"containerName":"range2value","line":407},{"line":407,"containerName":"range2value","kind":12,"name":"end"},{"definition":"my","name":"$chr","localvar":"my","containerName":"range2value","kind":13,"line":411},{"line":411,"name":"$arm","containerName":"range2value","kind":13},{"name":"$band","kind":13,"containerName":"range2value","line":411},{"line":411,"name":"$value","kind":13,"containerName":"range2value"},{"name":"start","containerName":"range2value","kind":12,"line":411},{"definition":"my","line":412,"localvar":"my","containerName":"range2value","kind":13,"name":"$chr2"},{"line":412,"kind":13,"containerName":"range2value","name":"$arm2"},{"line":412,"name":"$band2","kind":13,"containerName":"range2value"},{"kind":13,"containerName":"range2value","name":"$value","line":412},{"line":412,"name":"end","kind":12,"containerName":"range2value"},{"definition":"my","name":"$chrS","containerName":"range2value","localvar":"my","kind":13,"line":414},{"name":"$armS","containerName":"range2value","kind":13,"line":414},{"line":414,"kind":13,"containerName":"range2value","name":"$bandS"},{"line":414,"kind":13,"containerName":"range2value","name":"$arm2S"},{"name":"$band2S","kind":13,"containerName":"range2value","line":414},{"line":414,"containerName":"range2value","kind":13,"name":"$sep"},{"line":419,"name":"$chr","containerName":"range2value","kind":13},{"line":420,"kind":13,"containerName":"range2value","name":"$chrS"},{"line":422,"containerName":"range2value","kind":13,"name":"$chr"},{"name":"$chrS","kind":13,"containerName":"range2value","line":423},{"containerName":"range2value","kind":13,"name":"$chrS","line":425},{"line":425,"containerName":"range2value","kind":13,"name":"$chr"},{"containerName":"range2value","kind":13,"name":"$arm","line":427},{"name":"$arm2","kind":13,"containerName":"range2value","line":427},{"containerName":"range2value","kind":13,"name":"$band","line":427},{"name":"$band2","kind":13,"containerName":"range2value","line":427},{"line":431,"name":"$arm","kind":13,"containerName":"range2value"},{"line":431,"containerName":"range2value","kind":13,"name":"$arm2"},{"name":"$arm","containerName":"range2value","kind":13,"line":432},{"line":433,"kind":13,"containerName":"range2value","name":"$armS"},{"line":435,"kind":13,"containerName":"range2value","name":"$bandS"},{"containerName":"range2value","kind":13,"name":"$band","line":435},{"kind":13,"containerName":"range2value","name":"$arm","line":438},{"line":439,"containerName":"range2value","kind":13,"name":"$armS"},{"line":440,"kind":13,"containerName":"range2value","name":"$bandS"},{"name":"$band","kind":13,"containerName":"range2value","line":440},{"line":442,"name":"$armS","containerName":"range2value","kind":13},{"line":444,"name":"$armS","containerName":"range2value","kind":13},{"line":444,"containerName":"range2value","kind":13,"name":"$band"},{"line":447,"kind":13,"containerName":"range2value","name":"$arm"},{"line":448,"name":"$armS","kind":13,"containerName":"range2value"},{"line":449,"kind":13,"containerName":"range2value","name":"$arm2S"},{"line":450,"containerName":"range2value","kind":13,"name":"$arm2S"},{"kind":13,"containerName":"range2value","name":"$band","line":450},{"line":450,"kind":13,"containerName":"range2value","name":"$band2"},{"name":"$armS","kind":13,"containerName":"range2value","line":452},{"containerName":"range2value","kind":13,"name":"$arm2S","line":453},{"line":454,"name":"$arm2S","kind":13,"containerName":"range2value"},{"line":454,"containerName":"range2value","kind":13,"name":"$arm2"},{"line":454,"kind":13,"containerName":"range2value","name":"$band"},{"name":"$band2","containerName":"range2value","kind":13,"line":454},{"containerName":"range2value","kind":13,"name":"$band","line":457},{"containerName":"range2value","kind":13,"name":"$band2","line":457},{"name":"$c","localvar":"my","kind":13,"containerName":"range2value","line":458,"definition":"my"},{"name":"$bandS","containerName":"range2value","kind":13,"line":462},{"containerName":"range2value","kind":13,"name":"$armS","line":463},{"line":464,"name":"$band","kind":13,"containerName":"range2value"},{"line":464,"kind":13,"containerName":"range2value","name":"$band"},{"kind":13,"containerName":"range2value","name":"$c","line":465},{"name":"$c","containerName":"range2value","kind":13,"line":467},{"line":469,"name":"$band","containerName":"range2value","kind":13},{"containerName":"range2value","kind":13,"name":"$bandS","line":470},{"line":470,"name":"$band","containerName":"range2value","kind":13},{"name":"$bandS","kind":13,"containerName":"range2value","line":471},{"kind":13,"containerName":"range2value","name":"$band","line":471},{"line":471,"name":"$band","containerName":"range2value","kind":13},{"name":"$band","containerName":"range2value","kind":13,"line":471},{"name":"$band2","containerName":"range2value","kind":13,"line":473},{"line":477,"kind":13,"containerName":"range2value","name":"$arm2"},{"line":478,"kind":13,"containerName":"range2value","name":"$arm2S"},{"line":479,"kind":13,"containerName":"range2value","name":"$band2"},{"line":479,"name":"$band2","kind":13,"containerName":"range2value"},{"containerName":"range2value","kind":13,"name":"$c","line":480},{"kind":13,"containerName":"range2value","name":"$arm2S","line":482},{"containerName":"range2value","kind":13,"name":"$c","line":483},{"name":"$band2","kind":13,"containerName":"range2value","line":485},{"kind":13,"containerName":"range2value","name":"$arm2","line":486},{"line":487,"name":"$arm2S","kind":13,"containerName":"range2value"},{"line":488,"name":"$band2S","containerName":"range2value","kind":13},{"name":"$band2S","containerName":"range2value","kind":13,"line":490},{"name":"$band","kind":13,"containerName":"range2value","line":494},{"line":494,"containerName":"range2value","kind":13,"name":"$band2"},{"kind":13,"containerName":"range2value","name":"$arm","line":494},{"line":494,"name":"$arm2","containerName":"range2value","kind":13},{"line":496,"name":"$band2","containerName":"range2value","kind":13},{"name":"$band2S","containerName":"range2value","kind":13,"line":497},{"line":497,"name":"$band2","kind":13,"containerName":"range2value"},{"line":498,"name":"$band2S","containerName":"range2value","kind":13},{"line":498,"kind":13,"containerName":"range2value","name":"$band2"},{"kind":13,"containerName":"range2value","name":"$band2","line":498},{"containerName":"range2value","kind":13,"name":"$band2","line":498},{"containerName":"range2value","kind":13,"name":"$armS","line":502},{"line":502,"name":"$arm2S","kind":13,"containerName":"range2value"},{"definition":"my","localvar":"my","kind":13,"containerName":"range2value","name":"$tmp","line":503},{"name":"$band2S","kind":13,"containerName":"range2value","line":503},{"line":504,"containerName":"range2value","kind":13,"name":"$band2S"},{"kind":13,"containerName":"range2value","name":"$bandS","line":504},{"line":505,"kind":13,"containerName":"range2value","name":"$bandS"},{"name":"$tmp","containerName":"range2value","kind":13,"line":505},{"name":"$band2S","containerName":"range2value","kind":13,"line":507},{"containerName":"range2value","kind":13,"name":"$bandS","line":507},{"line":507,"kind":13,"containerName":"range2value","name":"$band2S"},{"name":"$armS","kind":13,"containerName":"range2value","line":508},{"name":"$bandS","kind":13,"containerName":"range2value","line":508},{"name":"$arm2S","containerName":"range2value","kind":13,"line":509},{"line":509,"kind":13,"containerName":"range2value","name":"$armS"},{"kind":13,"containerName":"range2value","name":"$arm2S","line":509},{"line":509,"kind":13,"containerName":"range2value","name":"$band2S"},{"line":510,"containerName":"range2value","kind":13,"name":"$sep"},{"kind":13,"containerName":"range2value","name":"$arm2S","line":510},{"line":510,"name":"$band2S","containerName":"range2value","kind":13},{"line":511,"kind":13,"containerName":"range2value","name":"$self"},{"line":511,"name":"value","containerName":"range2value","kind":12},{"line":511,"containerName":"range2value","kind":13,"name":"$chrS"},{"line":511,"containerName":"range2value","kind":13,"name":"$armS"},{"kind":13,"containerName":"range2value","name":"$bandS","line":511},{"containerName":"range2value","kind":13,"name":"$sep","line":511},{"line":511,"name":"$arm2S","containerName":"range2value","kind":13},{"line":511,"name":"$band2S","containerName":"range2value","kind":13},{"kind":13,"containerName":"range2value","name":"$self","line":513},{"kind":12,"containerName":"range2value","name":"value","line":513}],"detail":"($self,$value)","definition":"sub"},{"line":415,"kind":12,"name":"LOC"},{"line":427,"name":"LOC","kind":12},{"name":"LOC","kind":12,"line":457},{"line":473,"name":"LOC","kind":12},{"line":492,"name":"LOC","kind":12},{"name":"LOC","kind":12,"line":494},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object\n\n\nsub range2value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ! $value->isa('Bio::Range') ) {\n\t    $self->throw(\"Is not a Bio::Range object but a [$value]\");\n\t    return;\n\t}\n\tif( ! $value->start ) {\n\t    $self->throw(\"Start is not defined in [$value]\");\n\t    return;\n\t}\n\tif( ! $value->end ) {\n\t    $self->throw(\"End is not defined in [$value]\");\n\t    return;\n\t}\n\tif( $value->start < 100000 ) {\n\t    $self->throw(\"Start value has to be in millions, not \". $value->start);\n\t    return;\n\t}\n\tif( $value->end < 100000 ) {\n\t    $self->throw(\"End value has to be in millions, not \". $value->end);\n\t    return;\n\t}\n\n\tmy ($chr, $arm, $band) = $value->start =~ /(\\d+)(\\d)(\\d{5})/;\t\n\tmy ($chr2, $arm2, $band2) = $value->end =~ /(\\d+)(\\d)(\\d{5})/;\t\n\n\tmy ($chrS, $armS, $bandS, $arm2S, $band2S, $sep) = ('', '', '', '', '', '' );\n      LOC: {\n\t  #\n\t  # chromosome\n\t  #\n\t  if ($chr == 100) {\n\t      $chrS = 'X';\n\t  }\n\t  elsif ($chr == 100) {\n\t      $chrS = 'Y';\n\t  } else {\n\t      $chrS = $chr;\n\t  }\n\t  last LOC if  $arm == 0 and $arm2 == 2 and $band == 0 and $band2 == 0 ;\n\t  #\n\t  # arm\n\t  #\n\t  if ($arm == $arm2 ) {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  #$armS = 'pter' if $band == 0 and $band2 == 0;\n\t\t  $bandS = 'ter' if $band == 0;\n\t\t  #$arm2S = 'p'; #?\n\t      }\n\t      elsif ($arm == 2) {\n\t\t  $armS = 'q';\n\t\t  $bandS = 'ter' if $band == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  #$arm2S = 'q'; #?\n\t\t  $armS = 'cen',  if $band == 0;# and $band2 == 0;\n\t      }\n\t  } else {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  $arm2S = 'q';\n\t\t  $arm2S = '' if $band == 0 and $band2 == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  $arm2S = 'p';\n\t\t  $arm2S = '' if $arm2 == 2 and $band == 0 and $band2 == 0;\n\t      }\n\t  }\n\t  last LOC if $band == $band2 ;\n\t  my $c;\n\t  #\n\t  # first band (ter is hadled with the arm)\n\t  #\n\t  if ($bandS ne 'ter') {\n\t      if ($armS eq 'p') {\n\t\t  $band = 100000 - $band;\n\t\t  $c = '9';\n\t      } else {\n\t\t  $c = '0';\n\t      }\n\t      $band =~ s/$c+$//; \n\t      $bandS = $band;\n\t      $bandS = substr($band, 0, 2). '.'. substr($band, 2) if length $band > 2;\n\t  }\n\t  last LOC unless $band2;\n\t  #\n\t  # second band\n\t  #\n\t  if ($arm2 == 0) {\n\t      $arm2S = 'p';\n\t      $band2 = 100000 - $band2;\n\t      $c = '0';\n\t  } else { # 1 or 2\n\t      $arm2S = 'q';\n\t      $c = '9';\n\t  }\n\t  if ($band2 == 0) {\n\t      if ($arm2 == 1) {\n\t\t  $arm2S = 'p';\n\t\t  $band2S = 'cen';\n\t      } else {\n\t\t  $band2S = 'ter';\n\t      }\n\t      last LOC;\n\t  }\n\t  last LOC if $band eq $band2 and $arm == $arm2;\n\n\t  $band2 =~ s/$c+$//; \n\t  $band2S = $band2;\n\t  $band2S = substr($band2, 0, 2). '.'. substr($band2, 2) if length $band2 > 2;\n\n      } # end of LOC:\n\n\tif ($armS eq 'p' and $arm2S eq 'p') {\n\t    my $tmp = $band2S;\n\t    $band2S = $bandS;\n\t    $bandS = $tmp;\n\t}\n\t$band2S = '' if $bandS eq $band2S ;\n\t$armS = '' if $bandS eq 'cen';\n\t$arm2S = '' if $armS eq $arm2S and $band2S ne 'ter';\n\t$sep = '-' if $arm2S || $band2S;\n\t$self->value( $chrS. $armS. $bandS. $sep. $arm2S. $band2S);\n    }\n   return $self->value;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : none to get, OR scalar to set","label":"value($self,$value)"},"line":526,"range":{"start":{"line":526,"character":0},"end":{"line":533,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":527,"localvar":"my","containerName":"value","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"value","kind":13,"line":527},{"name":"$value","containerName":"value","kind":13,"line":528},{"line":529,"kind":13,"containerName":"value","name":"$self"},{"line":529,"name":"$value","kind":13,"containerName":"value"},{"line":530,"name":"$self","kind":13,"containerName":"value"},{"name":"cytorange","kind":12,"containerName":"value","line":530},{"line":532,"name":"$self","containerName":"value","kind":13}],"containerName":"main::","name":"value"},{"line":546,"kind":12,"range":{"start":{"character":0,"line":546},"end":{"line":549,"character":9999}},"children":[{"definition":"my","line":547,"kind":13,"localvar":"my","containerName":"numeric","name":"$self"},{"name":"$self","kind":13,"containerName":"numeric","line":548},{"containerName":"numeric","kind":12,"name":"start","line":548}],"containerName":"main::","name":"numeric","definition":"sub"},{"line":561,"range":{"start":{"line":561,"character":0},"end":{"character":9999,"line":567}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$chr"}],"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object\n\n\nsub range2value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ! $value->isa('Bio::Range') ) {\n\t    $self->throw(\"Is not a Bio::Range object but a [$value]\");\n\t    return;\n\t}\n\tif( ! $value->start ) {\n\t    $self->throw(\"Start is not defined in [$value]\");\n\t    return;\n\t}\n\tif( ! $value->end ) {\n\t    $self->throw(\"End is not defined in [$value]\");\n\t    return;\n\t}\n\tif( $value->start < 100000 ) {\n\t    $self->throw(\"Start value has to be in millions, not \". $value->start);\n\t    return;\n\t}\n\tif( $value->end < 100000 ) {\n\t    $self->throw(\"End value has to be in millions, not \". $value->end);\n\t    return;\n\t}\n\n\tmy ($chr, $arm, $band) = $value->start =~ /(\\d+)(\\d)(\\d{5})/;\t\n\tmy ($chr2, $arm2, $band2) = $value->end =~ /(\\d+)(\\d)(\\d{5})/;\t\n\n\tmy ($chrS, $armS, $bandS, $arm2S, $band2S, $sep) = ('', '', '', '', '', '' );\n      LOC: {\n\t  #\n\t  # chromosome\n\t  #\n\t  if ($chr == 100) {\n\t      $chrS = 'X';\n\t  }\n\t  elsif ($chr == 100) {\n\t      $chrS = 'Y';\n\t  } else {\n\t      $chrS = $chr;\n\t  }\n\t  last LOC if  $arm == 0 and $arm2 == 2 and $band == 0 and $band2 == 0 ;\n\t  #\n\t  # arm\n\t  #\n\t  if ($arm == $arm2 ) {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  #$armS = 'pter' if $band == 0 and $band2 == 0;\n\t\t  $bandS = 'ter' if $band == 0;\n\t\t  #$arm2S = 'p'; #?\n\t      }\n\t      elsif ($arm == 2) {\n\t\t  $armS = 'q';\n\t\t  $bandS = 'ter' if $band == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  #$arm2S = 'q'; #?\n\t\t  $armS = 'cen',  if $band == 0;# and $band2 == 0;\n\t      }\n\t  } else {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  $arm2S = 'q';\n\t\t  $arm2S = '' if $band == 0 and $band2 == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  $arm2S = 'p';\n\t\t  $arm2S = '' if $arm2 == 2 and $band == 0 and $band2 == 0;\n\t      }\n\t  }\n\t  last LOC if $band == $band2 ;\n\t  my $c;\n\t  #\n\t  # first band (ter is hadled with the arm)\n\t  #\n\t  if ($bandS ne 'ter') {\n\t      if ($armS eq 'p') {\n\t\t  $band = 100000 - $band;\n\t\t  $c = '9';\n\t      } else {\n\t\t  $c = '0';\n\t      }\n\t      $band =~ s/$c+$//; \n\t      $bandS = $band;\n\t      $bandS = substr($band, 0, 2). '.'. substr($band, 2) if length $band > 2;\n\t  }\n\t  last LOC unless $band2;\n\t  #\n\t  # second band\n\t  #\n\t  if ($arm2 == 0) {\n\t      $arm2S = 'p';\n\t      $band2 = 100000 - $band2;\n\t      $c = '0';\n\t  } else { # 1 or 2\n\t      $arm2S = 'q';\n\t      $c = '9';\n\t  }\n\t  if ($band2 == 0) {\n\t      if ($arm2 == 1) {\n\t\t  $arm2S = 'p';\n\t\t  $band2S = 'cen';\n\t      } else {\n\t\t  $band2S = 'ter';\n\t      }\n\t      last LOC;\n\t  }\n\t  last LOC if $band eq $band2 and $arm == $arm2;\n\n\t  $band2 =~ s/$c+$//; \n\t  $band2S = $band2;\n\t  $band2S = substr($band2, 0, 2). '.'. substr($band2, 2) if length $band2 > 2;\n\n      } # end of LOC:\n\n\tif ($armS eq 'p' and $arm2S eq 'p') {\n\t    my $tmp = $band2S;\n\t    $band2S = $bandS;\n\t    $bandS = $tmp;\n\t}\n\t$band2S = '' if $bandS eq $band2S ;\n\t$armS = '' if $bandS eq 'cen';\n\t$arm2S = '' if $armS eq $arm2S and $band2S ne 'ter';\n\t$sep = '-' if $arm2S || $band2S;\n\t$self->value( $chrS. $armS. $bandS. $sep. $arm2S. $band2S);\n    }\n   return $self->value;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : none to get, OR scalar to set\n\n\nsub value {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_value'} = $value;\n       $self->cytorange;\n   }\n   return $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guarantied to return a numeric \n           representation of the start of this position.\n Returns : int (the start of the range)\n Args    : optional Bio::RangeI object \n\n\nsub numeric {\n   my $self = shift;\n   return $self->start(@_);\n}\n\n=head2 chr\n\n Title   : chr\n Usage   : my $mychr = $position->chr();\n Function: Get/Set method for the chromosome string of the location.\n Returns : chromosome value\n Args    : none to get, OR scalar to set","label":"chr($self,$chr)"},"children":[{"definition":"my","localvar":"my","containerName":"chr","kind":13,"name":"$self","line":562},{"name":"$chr","kind":13,"containerName":"chr","line":562},{"name":"$chr","containerName":"chr","kind":13,"line":563},{"line":564,"name":"$self","kind":13,"containerName":"chr"},{"line":564,"name":"$chr","kind":13,"containerName":"chr"},{"name":"$self","containerName":"chr","kind":13,"line":566}],"containerName":"main::","name":"chr","definition":"sub","detail":"($self,$chr)"}]}